<?php
require_once (dirname(__FILE__)."/config.php");


class Jormall_SMS_Gateway {    
 
    public function __construct(){
        DBConnection::getInstance();
    }

    // ----------------------------------------------------------------- //
    // ------------------ check the remaining SMS balance -------------- //
    // ----------------------------------------------------------------- //
    public function getBalance(){

        $url = Config::$jormall_base_url . '/GetBalance.cfm';
        $fields = array(
            'AccName'=>"minagate",
            'ACCPASS'=> 'F4$zF1@GcY7'
        );
        // call the remote endpoint        
        $response = $this->curl($url,$fields);

        return $response;
    }

    // ---------------------------------------------------------- //
    // ----------- send SMS to single device--------------------- //
    // ---------------------------------------------------------- //
    public function sendMessage($phone , $msg){

        $phone = convertToInternational($phone);
        $phone = str_replace("+","",$phone);
 
        $url = Config::$jormall_base_url . '/msgservicejo.cfm';
        $fields = array(
            'numbers'=> $phone,
            'senderid' => "Minagate",
            'msg' => $msg,
            'requesttimeout' => 5000000,
            'accname'=> "minagate",
            'ACCPASS'=> 'F4$zF1@GcY7'
        );

        // call the remote endpoint        
        $response = $this->curl($url,$fields);

        return $response;
    }


    // ---------------------------------------------------------------------------- //
    // ----------- send bulk SMS to multi devices (up to 120) --------------------- //
    // ---------------------------------------------------------------------------- //
    public function sendBulkMessage($phones , $msg){

        // format the numbers
        $numbers = "";
        foreach ($phones as $singlePhone) {        
            $singlePhone = convertToInternational($singlePhone);
            $singlePhone = str_replace("+","",$singlePhone);
            $numbers .= $singlePhone . ",";
        }

        //send curl
        $url = Config::$jormall_base_url . '/smppformwwl.cfm';
        $fields = array(
            'numbers'=> $numbers,
            'senderid' => "Minagate",
            'msg' => $msg,
            'requesttimeout' => 5000000,
            'accname'=> "minagate", 
            'ACCPASS'=> 'F4$zF1@GcY7'
        );
       
        // call the remote endpoint        
        $response = $this->curl($url,$fields);
 
        return $response;
    }



    // ----------------------------------------------------------------------------------------- //
    // ------------------ call cURL request to minagate-registrat end point ---------------------- //
    // ----------------------------------------------------------------------------------------- //
    private function curl($url,$fields){
 
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));
       
        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            throw new Exception(curl_error($ch) , curl_errno($ch));
        }

        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close ($ch);
 
        if($http_code != 200){
            throw new Exception("Error Processing Request", 1);            
        }

        $response = json_decode($result,1);
        if($response){
            return $response;
        }else{
            return $result;
        }
    }
}