<?php

// ----------------------------------------------------------------------------------- //
// --------------------- Convert any code into arabic caption ------------------------ //
// ----------------------------------------------------------------------------------- //
class Captions{

    private static $CAPTION_JSON = null;

    private static function get_Caption_Instance() {
        if(self::$CAPTION_JSON){
            return self::$CAPTION_JSON;
        }else{
            $url = 'https://storage.googleapis.com/waybill_system_config/CAPTIONS.json'; 
            $ch = curl_init(); 
            curl_setopt($ch, CURLOPT_URL, $url); 
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            $output = curl_exec($ch); 
            curl_close($ch);
            self::$CAPTION_JSON = $output;
            return self::$CAPTION_JSON;
        }
    }


    public static function getCaption($code) {
        
        // CUSTOM MESSAGES for DB Errors
        if (strpos($code, '100 No Authority!') !== false) {
            return 'لا يوجد لديك صلاحية لإتمام العملية';
        }

        if (strpos($code, 'Duplicate entry') !== false && strpos($code, 'tn_nat_idx') !== false) {
            return 'الشاحنة مسجلة مسبقا';
        }
        if (strpos($code, 'Duplicate entry') !== false && strpos($code, 'user_id_UNIQUE') !== false) {
            return 'اليوزر لديه ملف سائق مسيق';
        }
         

        // Call API and get the arabic caption
        $CAPTIONS = json_decode(self::get_Caption_Instance());
        if($CAPTIONS->$code) {
            return $CAPTIONS->$code;
        }else{
            return $code;
        }
    }
}