<?php

error_reporting(E_ERROR | E_ALL);
ini_set('display_errors', 1);


require_once (dirname(__FILE__) . '/API.php');
require_once (dirname(__FILE__) . '/../includes/debug.php');
require_once (dirname(__FILE__) . '/../includes/util.php');
require_once (dirname(__FILE__) . "/../includes/config.php");
require_once (dirname(__FILE__) . "/Jo_Petrol/Jo_Petrol_API.php");


class face extends API{

    private $public_key = "C9yruGYyJq2WEqzUs7GFWBsRbX5LvcR5Zw9UsYeYjERJdpj9aBzP6MPy8rLXNhcG";  
    private $jo_petrol;

    public function __construct(){

        $this->jo_petrol = new Jo_Petrol();

        // call the super constructur
        $this->_request = parent::__construct();
        // process the incoming request
        $this->processRequest();
    }

    // call the correnponding method based on what the request call
    private function processRequest(){

        // validate public key "AUTHORIZATION" for each request        
        $HTTP_PUBLIC_KEY = $_SERVER['HTTP_PUBLIC_KEY'];
        if($HTTP_PUBLIC_KEY != $this->public_key){
            //throw new Exception("INVALID TOKEN" , 501);            
        }

        $func = $this->_request->method;
        unset($this->_request->method);
        if((int)method_exists($this,$func) > 0)
            $this->$func();
        else
            parent::response('Error code 404, method not found',404);   // If the method not exist with in this class, response would be "Page not found".
    }


    // ----------------------------------------------------------------------------------------------- //
    // ------------------ insert new waybill into Jo_Petrol system ----------------------------------- //
    // ----------------------------------------------------------------------------------------------- //
    public function insertWaybill(){ 

        try {
            // get params
            $waybill_id = $this->_request->waybill_id;
            $create_date = $this->_request->create_date;
            $create_time = $this->_request->create_time;
            $ct_id = $this->_request->ct_id;
            $destination_id = $this->_request->destination_id;
            $tn = $this->_request->tn;
            $trn = $this->_request->trn;
            $driver_nn = $this->_request->driver_nn;

            // validate params
            if(!$waybill_id) throw new Exception("waybill_id is required");
            if(!$create_date) throw new Exception("create_date is required");
            if(!$create_time) throw new Exception("create_time is required");
            if(!$ct_id) throw new Exception("ct_id is required");
            if(!$destination_id) throw new Exception("destination_id is required");
            if(!$tn) throw new Exception("tn is required");
            if(!$trn) throw new Exception("trn is required");
            if(!$driver_nn) throw new Exception("driver_nn is required");
            
            // insert data into jo petrol system
            $this->jo_petrol->insertWaybill($waybill_id , $create_date, $create_time , $ct_id, $destination_id, $tn , $trn, $driver_nn);

            // return success result
            $Result = [];
            $Result['ERRORCODE'] = "200";
            $Result['MESSAGE'] = "SUCCESSFUL_OPERATION";
            parent::response($Result);


        } catch (Exception $e) {
            throw new Exception($e->getMessage(), 500);
        }        
    }

    // ------------------------------------------------------------------ //
    // ---------------- get the status for certain waybill  ------------- //
    // ------------------------------------------------------------------ //
    public function geWaybillStatus(){ 
 
        try {
            // get params
            $waybill_id = $this->_request->waybill_id;

            // validate params
            if(!$waybill_id) throw new Exception("waybill_id is required");

            // query data from jo petrol system
            $status = $this->jo_petrol->geWaybillStatus($waybill_id);

            parent::response($status);
            
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), 500);
        }      
    }


    // ---------------------------------------------------------- //
    // ---------------- delete for certain waybill  ------------- //
    // ---------------------------------------------------------- //
    public function deleteWaybill(){ 
 
        try {
            // get params
            $waybill_id = $this->_request->waybill_id;

            // validate params
            if(!$waybill_id) throw new Exception("waybill_id is required");

            // query data from jo petrol system
            $status = $this->jo_petrol->deleteWaybill($waybill_id);

            parent::response($status);
            
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), 500);
        }      
    }


    // --------------------------------------------------------------------------------------------------- //
    // -------------- Update the status for certain waybill ---------------------------------------------- //
    // -------------- This method is used when the weight is transfered from Jo Petrol successfuly ------- //
    // --------------------------------------------------------------------------------------------------- //
    public function changeWaybillStatus(){ 
 
        try {
            // get params
            $waybill_id = $this->_request->waybill_id;
            $new_status = $this->_request->new_status;

            // validate params
            if(!$waybill_id) throw new Exception("waybill_id is required");
            if(!$new_status) throw new Exception("new_status is required");

            if($new_status == "ONROAD"){
                $this->jo_petrol->UpdateStatusTo3($waybill_id);
            }

            // 3: truck finished loading in jo_Petrol and trx is synced successfuly
            else if($new_status == 3){
                $this->jo_petrol->UpdateStatusTo3($waybill_id);
            }

            // 4: truck left shwaire yard
            else if($new_status == 4){
                $this->jo_petrol->UpdateStatusTo4($waybill_id);
            }

            // 4: truck left shwaire yard
            else if($new_status == 5){
                $this->jo_petrol->UpdateStatusTo5($waybill_id);
            }
            
            // 6: truck finished discharge and trx is synced successfuly
            else if($new_status == 6){
                $this->jo_petrol->UpdateStatusTo6($waybill_id);
            }

            else{
                throw new Exception("INVALID Status");                
            }

            // return success result
            $Result = [];
            $Result['ERRORCODE'] = "200";
            $Result['MESSAGE'] = "SUCCESSFUL_OPERATION";
            parent::response($Result);
            
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), 500);
        }      
    }


    // --------------------------------------------------------------------------------------------------- //
    // -------------- Update the claim number for certain waybill ---------------------------------------- //
    // --------------------------------------------------------------------------------------------------- //
    public function saveWaybillClaimNumber(){ 
 
        try {
            // get params
            $waybill_id = $this->_request->waybill_id;
            $claim_number = $this->_request->claim_number;

            $this->jo_petrol->sendClaimandUpdateStatusTo7($waybill_id, $claim_number);

            // return success result
            $Result = [];
            $Result['ERRORCODE'] = "200";
            $Result['MESSAGE'] = "SUCCESSFUL_OPERATION";
            parent::response($Result);

        } catch (Exception $e) {
            throw new Exception($e->getMessage(), 500);
        }      
    }
    


    // ----------------------------------------------------------------------------------- //
    // -------------- get a list of all pending waybills on Jo_Petrol System ------------- //
    // ----------------------------------------------------------------------------------- //
    public function fetchWaybills(){ 
 
        try {
            // get params
            $status = $this->_request->status;

            // validate params
            if(!$status) throw new Exception("status is required");
            $data = $this->jo_petrol->fetchWaybills($status); 
          
            $result = [];
            $result['data'] = $data;
            $result['found_rows'] = sizeof($data);
            parent::response($result);
            
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), 500);
        }      
    }

    // ------------------------------------------------------------ //
    // ------------ get list of waybills using claim id ----------- //
    // ------------------------------------------------------------ //
    public function QueryOnClaimNumber(){ 
 
        try {
            // get params
            $ClaimNumber = $this->_request->ClaimNumber;

            // validate params
            if(!$ClaimNumber) throw new Exception("ClaimNumber is required");
            $data = $this->jo_petrol->QueryOnClaimNumber($ClaimNumber); 
          
            $result = [];
            $result['data'] = $data;
            $result['found_rows'] = sizeof($data);
            parent::response($result);
            
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), 500);
        }      
    }


    // ------------------------------------------------------------ //
    // ------------ get list of waybills using claim id ----------- //
    // ------------------------------------------------------------ //
    public function QueryOnWayBill(){ 
 
        try {
            // get params
            $waybill_id = $this->_request->waybill_id;

            // validate params
            if(!$waybill_id) throw new Exception("waybill_id is required");
            $data = $this->jo_petrol->QueryOnWayBill($waybill_id); 
          
            parent::response($data[0]);
            
        } catch (Exception $e) {
            throw new Exception($e->getMessage(), 500);
        }      
    }

}

$interface = new face();
