            DBConnection::rollBackTransaction();
            <?php

// import objects
include_once('../includes/html_parser.php'); 

class Jo_Petrol {    

    private $Jo_Petrol_base_url;

    public function __construct(){

        // ----------------- Jo Petrol Config ---------------------
        $this->Jo_Petrol_base_url = "http://213.186.163.69:6060/TransportMgt/TransMgtWS.asmx?wsdl";
        $this->timeout = 150;

        // cargo types
        $this->cargo_types = [
            920301 => 77 , // نفط خام T1
            920302 => 45 , // فيول 
            920303 => 43 , // سولار             
            920304 => 42 , // بنزين  
            920305 => 66   // افتور 
        ];
        // cargo types
        $this->reverse_cargo_types = [
            77 => 920301 , // نفط خام T1
            45 => 920302 , // فيول 
            43 => 920303 , // سولار             
            42 => 920304 , // بنزين  
            66 => 920305   // افتور 
        ];

        // destinations
        $this->destinations = [
            920303 => 2173375 , // شرق عمان 
            920302 => 1266458 , // رحاب
            920302 => 155431  , // السمرا
            91030015 => 2001    , // الزرقاء    
            91060012 => 109778, // فوسفات الأبيض
            920303   => 1267943 , // توليد العقبة/العقبة
            91090018 => 2303    , // العقبة الحرارية
            91090019 => 158170  , // الأسمدة والكيماويات
            91090017 => 132267 ,  // كاميرا 
            91090021 => 2301 ,    // ستودعات المصفاة في العقبة
            91120005 => 109680,   // الحسا
            91110009 => 109884,    // الشيدية
            91060001 => 2233846,     //  القطرانه
            91060014 => 2233846,     //شركة اسمنت القطرانه
            91090020 => 109292, // الاسمدة اليابانية
            91060016 => 109078, // شركة برومين الأردن المحدودة
	        91010048 => 2382625, // شركة القسطل لإنتاج العصائر والمشروبات
            91010042 =>  2347674 // الاتحاد للتنمية الزراعية والمسلخ
        ];

        // status
        $this->status = [        
            "ACTIVE"  => 1  , // فعال                 
            "PENDING" => 2 , // قيد التحميل            
            "ONROAD"  => 5 ,  //قيد التفريغ         
            0 => 0,
            1 => 1,
	        2 => 2,
            3 => 3,
            5 => 5,
	        6 => 6
        ];

        // reverse status
        $this->reverseStatus = [            
            1 => "ACTIVE"  , // فعال 
            2 => "PENDING" , // قيد التحميل
            5 => "ONROAD"    // على الطريق
        ];
    }


    // -------------------------------------------------------------------------- //
    // ---------------- Insert waybill info into Jo_Petrol database ------------- //
    // -------------------------------------------------------------------------- //
    public function insertWaybill($waybill_id , $create_date, $create_time , $ct_id, $destination_id, $tn , $trn, $driver_nn){       
                        
        $client = new SoapClient($this->Jo_Petrol_base_url);
        $params = new stdClass();

        $params->TransNo = $waybill_id;
        $params->TransDate = $create_date;
        $params->TransTime = $create_time;
        $params->Cno = $this->destinations[$destination_id];
        $params->ItemNumber = $this->cargo_types[$ct_id];
        $params->TraktorNo = $tn;
        $params->TrailerNo = $trn;
        $params->DriverNID = $driver_nn;


        $objectresult = $client->InsertNafethData($params);

        if($objectresult->InsertNafethDataResult == "Inserted Successfuly"){
            return $objectresult;  
        }else if($objectresult->InsertNafethDataResult == "Updated Successfuly"){
            return $objectresult;  
        }else{
            $error_code = json_encode($objectresult, JSON_UNESCAPED_UNICODE);
            if (strstr($error_code, "NF55DRNID")) {
                throw new Exception("لم يتمكن النظام من ترحيل المستند لنظام المصفاة ، الرجاء التاكد من الرقم الوطني للسائق  ");
            }
            throw new Exception("لم يتمكن النظام من ترحيل المستند لنظام المصفاة ، الرجاء مراجعة العمليات" . json_encode($objectresult,JSON_UNESCAPED_UNICODE));
        }
        
    }


    // ------------------------------------------------------------------------------------------------------------------------------------- //
    // ----------------  update waybill status to 3 ("ONROAD") ----------------------------------------------------------------------------- //
    // ---------------- 3: the truck finished loading in Jo_Petrol system and the trx is saved succesfuly on Minagate ---------------------- //
    // ------------------------------------------------------------------------------------------------------------------------------------- //
    public function UpdateStatusTo3($waybill_id){       
                        
        $client = new SoapClient($this->Jo_Petrol_base_url);
        $params = new stdClass();

        $params->TransNumber = $waybill_id;     
        $objectresult = $client->UpdateStatusTo3($params);      

        return $objectresult;  
    }

    // --------------------------------------------------------------------------- //
    // ----------------  update waybill status to 4 ------------------------------ //
    // ----------------4: the truck left shwaire yard ---------------------------- //
    public function UpdateStatusTo4($waybill_id){       
                        
        $client = new SoapClient($this->Jo_Petrol_base_url);
        $params = new stdClass();

        $params->TransNumber = $waybill_id;     
        $objectresult = $client->UpdateStatusTo4($params);      

        return $objectresult;  
    }

    // --------------------------------------------------------------------------- //
    // ----------------  update waybill status to 6  ----------------------------- //
    // ----------------6:  tender claim id is issued ----------------------------- //
    // --------------------------------------------------------------------------- //
    public function UpdateStatusTo6($waybill_id){
                        
        $client = new SoapClient($this->Jo_Petrol_base_url);
        $params = new stdClass();

        $params->TransNumber = $waybill_id; 
        $objectresult = $client->UpdateStatusTo6($params);      

        return $objectresult;  
    }

    // ------------------------------------------------------ //
    // -------------- delete a certain waybill -------------- //
    // ------------------------------------------------------ //
    public function deleteWaybill($waybill_id){       
                        
        $client = new SoapClient($this->Jo_Petrol_base_url);
        $params = new stdClass();

        $params->TransNumber = $waybill_id;
        $objectresult = $client->DeleteTrans($params);     
        
        return $objectresult;  
    }

    // --------------------------------------------------------------------------------------------------- //
    // -------------- Update the claim number for certain waybill ---------------------------------------- //
    // --------------------------------------------------------------------------------------------------- //
    public function sendClaimandUpdateStatusTo7($waybill_id , $ClaimNumber){
        $client = new SoapClient($this->Jo_Petrol_base_url);
        $params = new stdClass();
        $params->TransNumber = $waybill_id;
        $params->claimNo = $ClaimNumber;

        $objectresult = $client->sendClaimandUpdateStatusTo7($params);
    }


    // ------------------------------------------------------------ //
    // ------------ get list of waybills using claim id ----------- //
    // ------------------------------------------------------------ //
    public function QueryOnClaimNumber($ClaimNumber){       
                        
        $client = new SoapClient($this->Jo_Petrol_base_url);
        $params = new stdClass();
        $params->ClaimNumber = $ClaimNumber;

        $objectresult = $client->QueryOnClaimNumber($params);
        $result = $objectresult->QueryOnClaimNumberResult->any;    

        libxml_use_internal_errors(true);

        $array = [];
        $dom = new DOMDocument;
        $dom->loadHTML($result);
        foreach($dom->getElementsByTagName('table') as $node){               
            $array[] = $dom->saveHTML($node);
        }

        $result = [];
        foreach ($array as $t) {
            $xml = simplexml_load_string($t);
            $json = json_encode($xml);
            $array = json_decode($json,TRUE);   
            $result[] = $array;
        }        
        return $result;  
     
    }

    // ------------------------------------------------------------ //
    // ------------ get list of waybills using claim id ----------- //
    // ------------------------------------------------------------ //
    public function QueryOnWayBill($waybill_id){

        $client = new SoapClient($this->Jo_Petrol_base_url);
        $params = new stdClass();
        $params->TransNo = $waybill_id;

        $objectresult = $client->QueryOnWayBill($params);
        $result = $objectresult->QueryOnWayBillResult->any;

        libxml_use_internal_errors(true);

        $array = [];
        $dom = new DOMDocument;
        $dom->loadHTML($result);

        foreach($dom->getElementsByTagName('table') as $node){               
            $array[] = $dom->saveHTML($node);
        }
 
        $result = [];
        foreach ($array as $t) {
            $xml = simplexml_load_string($t);
            $json = json_encode($xml);
            $array = json_decode($json,TRUE);   
            $result[] = $array;
        }

        return $result;  
     
    }
    

    // ------------------------------------------------------------------ //
    // ---------------- get the status for certain waybill  ------------- //
    // ------------------------------------------------------------------ //
    public function geWaybillStatus($waybill_id){       
                        
        $client = new SoapClient($this->Jo_Petrol_base_url);
        $params = new stdClass();
        $params->TransNo = $waybill_id;

        $objectresult = $client->QueryOnStatus($params);      
        $status = $this->reverseStatus[$objectresult->QueryOnStatusResult];
        if($status){
            return $status;
        }else{
            throw new Exception("Waybill_id does not exist in remote system");            
        }
    }

    // ----------------------------------------------------------------------------------- //
    // -------------- get a list of all waybills on Jo_Petrol System --------------------- //
    // ----------------------------------------------------------------------------------- //
    public function fetchWaybills($status){ 
        $client = new SoapClient($this->Jo_Petrol_base_url , array("connection_timeout" => 150));
        $params = new stdClass();
 
        $params->StstusNo = $this->status[$status];

        $objectresult = $client->QueryOnStatus2($params); 
        $result = $objectresult->QueryOnStatus2Result->any;     
       
        libxml_use_internal_errors(true);

        $array = [];
        $dom = new DOMDocument;
        $dom->loadHTML($result);
        foreach($dom->getElementsByTagName('table') as $node){           
            $array[] = $dom->saveHTML($node);	  
        }

        $result = [];
        foreach ($array as $t) {
            $xml = simplexml_load_string($t);
            $json = json_encode($xml);
            $array = json_decode($json,TRUE);   
            $result[] = $array;
        }                       
        return $result;  
    }

    // -------------------------------------------------------------------------- //
    // ------------- convert julian date to calander date ----------------------- //
    // -------------------------------------------------------------------------- //
    private function convertToDate($jDate) {          
        if($jDate){
            $Day = $jDate % 1000;
	        $Day = $Day - 1 ;
            $Year = (($jDate - $Day + 2000000) / 1000) - 100;
            $result =  date('Y-m-d', strtotime($Year.'-1-1' . " + $Day days"));
            return $result;
        }else{
            return "";
        }       
    }

    // -------------------------------------------------------------------------- //
    // ------------- convert julian date to calander date ----------------------- //
    // -------------------------------------------------------------------------- //
    private function convertToTime($time) {          
        if($time){
            return date( "H:i:s", strtotime(str_pad($time,6,"0" , STR_PAD_LEFT))); 
        }else{
            return "";
        }       
    }
    
    private function find_in_html($str, $element){

        $start = strpos($str,$element) + strLen($element);
        if(!$start || $start == -1){
            return "";
        }
        $end = strpos($str,"/".$element);
        if(!$end || $end == -1){
            return "";
        }

        $sub = substr($str, $start, $end - $start);
        $result = trim($sub,"&gt;");
        $result = trim($result,"&l;");
        return $result;
    }



}