<?php
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/yard_simulation_core.php");


class Yard_simulation_interface extends API
{

    private $_request = array();
    private $_yardSimulationCore;

    public function __construct()
    {

        $this->_request = parent::__construct();
        session_start();
        if (!isset($_SESSION['user_id'])) {
            throw new Exception('No Session!');
        }

        // init the object
        $this->_yardSimulationCore = new YardSimulationCore();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // ---------------------------------------------------------------- //
    // -------------- get settings of post audit screen --------------- //
    // ---------------------------------------------------------------- //
    public function getPostAuditSettingsScreen()
    {
    }

    // --------------------------------------------------------- //
    // -------------- get certain yard Settings --------------- //
    // --------------------------------------------------------- //
    public function getYardSettings()
    {
        // get user params
        $yard_id = $this->_request->yard_id;

        // get Settings of the selected yard
        $settings = $this->_yardSimulationCore->getYardSettings($yard_id, $_SESSION['user_id']);

        // return response
        parent::response($settings);
    }


    // --------------------------------------------------------- //
    // -------------- save certain yard resources --------------- //
    // --------------------------------------------------------- //
    public function saveYardSettings()
    {
        // get user params
        $yard_id = $this->_request->yard_id;
        $resources = $this->_request->resources;
        $clear_setting = $this->_request->clear;
        $working_hours = $this->_request->working_hours;

        // validate input
        if (!$yard_id || !$resources) {
            throw new Exception("yard_id,resources is required");
        }

        // validate resources is in correct format
        if (gettype($resources) == "string") {
            $resources = json_decode($resources);
        }

        foreach ($resources as $r) {
            if (!isset($r->max) || !isset($r->teams)) {
                throw new Exception("invalid resources");
            }
            if (!intval($r->teams) || intval($r->teams) < 0) {
                throw new Exception("invalid teams");
            }
        }

        // get Settings of the selected yard
        $settingsRaw = $this->_yardSimulationCore->getYardSettings($yard_id, $_SESSION['user_id']);
        $settings = json_decode($settingsRaw[0]->settings);
        $settings->input->dest->resources = $resources;

        $settings->input->dest->clear = $clear_setting;
        $settings->input->dest->working_hours = $working_hours;
        if (gettype($settings->input->dest->working_hours) == "string") {
            $settings->input->dest->working_hours = json_decode($settings->input->dest->working_hours);
        }
        if (gettype($settings->input->dest->clear) == "string") {
            $settings->input->dest->clear = json_decode($settings->input->dest->clear);
        }

        // get Settings of the selected yard
        $settings = json_encode($settings, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        $result = $this->_yardSimulationCore->saveYardSettings($yard_id, $settings, $_SESSION['u_id']);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['RESULT'] = $result;
        $Result['MESSAGE'] = "تمت العملية بنجاح";
        parent::response($Result, 200);
    }

    // --------------------------------------------------------------------------------------- //
    // -------------- update process info (name , prop , ramps , queue , color) -------------- //
    // --------------------------------------------------------------------------------------- //
    public function updateProcessInfo()
    {
        // get user params
        $yard_id = $this->_request->yard_id;
        $type_code = $this->_request->type_code;
        $prop = $this->_request->prop;
        $ramps = $this->_request->ramps;
        $queues = $this->_request->queues;
        $color = $this->_request->color;

        // validate input
        if (!$yard_id || !$prop || !$ramps || !$queues || !$type_code || !$color) {
            throw new Exception("yard_id,prop,ramps,queues,type_code,color is required");
        }

        // format input
        $type_code = strtolower($type_code);
        if (gettype($ramps) == "string" && json_decode($ramps)) {
            $ramps = json_decode($ramps);
        }
        if (gettype($queues) == "string" && json_decode($queues)) {
            $queues = json_decode($queues);
        }


        // get process ifno of the selected yard
        $settingsRaw = $this->_yardSimulationCore->getYardSettings($yard_id, $_SESSION['user_id']);
        $settings = json_decode($settingsRaw[0]->settings);
        $inspection = $settings->input->dest->inspection;
        $info = $inspection->$type_code;

        // update the info
        $info->prob = $prop;
        $info->color = $color;
        $info->ramps = $ramps;
        $info->queues = $queues;

        //return modified object to original
        $inspection->$type_code  = $info;
        $settings->input->dest->inspection = $inspection;

        // get Settings of the selected yard
        $settings = json_encode($settings, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        $result = $this->_yardSimulationCore->saveYardSettings($yard_id, $settings, $_SESSION['u_id']);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['RESULT'] = $result;
        $Result['MESSAGE'] = "تمت العملية بنجاح";
        parent::response($Result, 200);
    }

    // ---------------------------------------------------------------------- //
    // -------------- Add new process to inspection processes --------------- //
    // ---------------------------------------------------------------------- //
    public function addNewProcess()
    {
        // get user params
        $yard_id = $this->_request->yard_id;
        $type_code = $this->_request->type_code;
        $process_name = $this->_request->process_name;
        $resource_name = $this->_request->resource_name;
        $lock_team_for_container = $this->_request->lock_team_for_container;
        $lock_container_for_team = $this->_request->lock_container_for_team;

        // validate input
        if (!$yard_id || !$process_name || !$resource_name || !$type_code) {
            throw new Exception("yard_id,process_name,resource_name,type_code is required");
        }

        // get inspection of the selected yard
        $settingsRaw = $this->_yardSimulationCore->getYardSettings($yard_id, $_SESSION['user_id']);
        $settings = json_decode($settingsRaw[0]->settings);
        $inspection = $settings->input->dest->inspection;
        $processList = $inspection->$type_code->process;

        // push new process
        $tempProcess = new stdClass();
        $tempProcess->code = $process_name;
        $tempProcess->resources[] = $resource_name;
        $tempProcess->lock_team_for_container = $lock_team_for_container;
        $tempProcess->lock_container_for_team = $lock_container_for_team;
        $processList[] = $tempProcess;

        //return modified object to original
        $inspection->$type_code->process = $processList;
        $settings->input->dest->inspection = $inspection;

        // get Settings of the selected yard
        $settings = json_encode($settings, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        $result = $this->_yardSimulationCore->saveYardSettings($yard_id, $settings, $_SESSION['u_id']);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['RESULT'] = $result;
        $Result['MESSAGE'] = "تمت العملية بنجاح";
        parent::response($Result, 200);
    }

    // ------------------------------------------------------------------------------ //
    // -------------- delete certain process from inspection processes --------------- //
    // ------------------------------------------------------------------------------- //
    public function deleteProcess()
    {
        // get user params
        $yard_id = $this->_request->yard_id;
        $type_code = $this->_request->type_code;
        $process_name = $this->_request->process_name;

        // validate input
        if (!$yard_id || !$process_name || !$type_code) {
            throw new Exception("yard_id,process_name,type_code is required");
        }

        // get inspection of the selected yard
        $settingsRaw = $this->_yardSimulationCore->getYardSettings($yard_id, $_SESSION['user_id']);
        $settings = json_decode($settingsRaw[0]->settings);
        $inspection = $settings->input->dest->inspection;
        $processList = $inspection->$type_code->process;

        // search for target process in order to delete it
        foreach ($processList as $index => $p) {
            if ($p->code == $process_name) {
                unset($processList[$index]);
            }
        }

        $newProcessList = [];
        foreach ($processList as $index => $p) {
            $newProcessList[] = $p;
        }


        //return modified object to original
        $inspection->$type_code->process = $newProcessList;
        $settings->input->dest->inspection = $inspection;

        // get Settings of the selected yard
        $settings = json_encode($settings, JSON_UNESCAPED_UNICODE);

        $result = $this->_yardSimulationCore->saveYardSettings($yard_id, $settings, $_SESSION['u_id']);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['RESULT'] = $result;
        $Result['MESSAGE'] = "تمت العملية بنجاح";
        parent::response($Result, 200);
    }

    // ------------------------------------------------------ //
    // -------------- get certain process info --------------- //
    // ------------------------------------------------------- //
    public function getProcessInfo()
    {
        // get user params
        $yard_id = $this->_request->yard_id;
        $type_code = $this->_request->type_code;

        // validate input
        if (!$yard_id || !$type_code) {
            throw new Exception("yard_id,type_code is required");
        }

        // get inspection of the selected yard
        $settingsRaw = $this->_yardSimulationCore->getYardSettings($yard_id, $_SESSION['user_id']);
        $settings = json_decode($settingsRaw[0]->settings);
        $inspection = $settings->input->dest->inspection;
        $info = $inspection->$type_code;

        //return reponse
        parent::response($info, 200);
    }

    // --------------------------------------------------------- //
    // -------------- save certain yard notification ----------- //
    // --------------------------------------------------------- //
    public function saveYardNotification()
    {
        // get user params
        $yard_id = $this->_request->yard_id;
        $notification = $this->_request->notification;

        // validate input
        if (!$yard_id || !$notification) {
            throw new Exception("yard_id,resources is required");
        }

        // validate resources is in correct format
        if (gettype($notification) == "string") {
            $notification = json_decode($notification);
        }

        // get Settings of the selected yard
        $settingsRaw = $this->_yardSimulationCore->getYardSettings($yard_id, $_SESSION['user_id']);
        $settings = json_decode($settingsRaw[0]->settings);
        $settings->notification = $notification;

        // get Settings of the selected yard
        $settings = json_encode($settings, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
        $result = $this->_yardSimulationCore->saveYardSettings($yard_id, $settings, $_SESSION['u_id']);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['RESULT'] = $result;
        $Result['MESSAGE'] = "تمت العملية بنجاح";
        parent::response($Result, 200);
    }


    // -------------------------------- private --------------------------- //
    private function getUpArrow()
    {
        return  " <i class='fa-solid fa-arrow-up' style='color: green'></i>";
        // return "";
    }
    private function getDownArrow()
    {
        return  " <i class='fa-solid fa-arrow-down' style='color: red'></i>";
        // return "";
    }
    private function get_random_value()
    {
        return random_int(0, 100);
    }
    private function get_random_arrow()
    {
        $coin_flip = random_int(1, 2);

        if ($coin_flip == 1) {
            return $this->getDownArrow();
        } else {
            return $this->getUpArrow();
        }
    }


    // ------------------------------------------------------------- //
    // -------------- Search for post audit stattiscs -------------- //
    // ------------------------------------------------------------- //
    public function searchPostAuditStatistics()
    {
        // get user params
        $yard_id = $this->_request->yard_id;
        $filter = $this->_request->filter;

        // temp for testing
        $KBI_header = ['2022-06-15', '2022-06-14', '2022-06-13', '2022-06-12'];
        $KPI_list = [
            ["id" => "KPI_1", "label" => "Queue Time"],
            ["id" => "KPI_2", "label" => "Ramp Utilization"],
            ["id" => "KPI_3", "label" => "Waiting Time"],
            ["id" => "KPI_4", "label" => "Yard Througput"]
        ];
        $KPI_details_number = random_int(0, 4);

        $reult = [];
        $reult['headers'] = $KBI_header;
        $reult['data'] = [];

        foreach ($KPI_list as $KPI) {
            $temp_value_data = new stdClass();
            $temp_value_data->key = $KPI;
            $temp_value_data->values = [];

            for ($h = 0; $h < sizeof($KBI_header); $h++) {

                $details = [];
                for ($i = 0; $i < $KPI_details_number; $i++) {
                    $details[] = 'lane ' . random_int(1, 60) . ' : ' . $this->get_random_value() . "%" . $this->get_random_arrow();
                }
                $temp_value_data->values[] =  [
                    'master' => $this->get_random_value() . "%" . $this->get_random_arrow(),
                    'detail' => $details
                ];
            }
            $reult['data'][] = $temp_value_data;
        }

        // // return result
        parent::response($reult, 200);
    }


    // ------------------------------------------------------------ //
    // -------------- search for yard typecode stattiscs ----------- //
    // ------------------------------------------------------------- //
    public function searchYardTypeCodeStatistics()
    {
        // get user params
        $yard_id = $this->_request->yard_id;

        // return result
        $reult = [
            ['Type', 'Queue', 'Ramps', 'On_road', 'Cleared'],
            ['DRY',  random_int(1, 100), random_int(1, 66), random_int(1, 150),  random_int(1, 50)],
            ['MOA',  random_int(1, 100), random_int(1, 66), random_int(1, 150),  random_int(1, 50)],
            ['JFDA',  random_int(1, 100), random_int(1, 66), random_int(1, 150),  random_int(1, 50)],
            ['JSMP',  random_int(1, 100), random_int(1, 66), random_int(1, 150),  random_int(1, 50)],
            ['ASEZA',  random_int(1, 100), random_int(1, 66), random_int(1, 150),  random_int(1, 50)]
        ];



        parent::response($reult, 200);
    }



    // ----------------------------------------------------- //
    // -------------- get certain yard scenarion ----------- //
    // ----------------------------------------------------- //
    public function getYardScenario()
    {

        // get user params
        $yard_id = $this->_request->yard_id;
        $scenraio_id = $this->_request->scenraio_id;

        // validate input
        if (!$yard_id || !$scenraio_id) {
            throw new Exception("yard_id,scenraio_id is required");
        }

        // get scenario of the selected yard
        $scenario = $this->_yardSimulationCore->getYardScenario($yard_id, $scenraio_id, $_SESSION['user_id']);

        parent::response($scenario, 200);
    }

    // ------------------------------------------------------------ //
    // -------------- search for list of yard scenraios ----------- //
    // ------------------------------------------------------------ //
    public function searchYardsScenario()
    {
        // get user params
        $filter = $this->_request->filter;
        $yard_id = $this->_request->yard_id;

        // validate input
        if (!$yard_id) {
            throw new Exception("yard_id is required");
        }

        // get scenario of the selected yard
        $scenarios = $this->_yardSimulationCore->searchYardsScenario($filter, $_SESSION['user_id']);

        parent::response($scenarios, 200);
 
    }
}


new Yard_simulation_interface();
