<?php
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");


class YardSimulationCore
{

    public function __construct()
    {
        DBConnection::getInstance();
    }

    // ---------------------------------------------------------------------- //
    // --------------------- get info for a certian yard settings ----------- //
    // ---------------------------------------------------------------------- //
    public function getYardSettings($yard_id, $user_id)
    {

        $sqlQuery = "select 
        id, yard_id , yard_name,
        CAST(`settings` AS CHAR CHARSET UTF8) AS settings
         from yard_settings where yard_id = ?  and type='LIVE' and status='ACTIVE' ";

        $param = [$yard_id];
        $result = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        return $result;
    }


    // --------------------------------------------------------------------------- //
    // --------------------- save resource for a certian yard settings ----------- //
    // --------------------------------------------------------------------------- //
    public function saveYardSettings($yard_id, $settings, $user_id)
    {

        try {
            DBConnection::startTransaction();

            $id = $this->getYardSettings($yard_id, $user_id)[0]->id;

            // update setting to INACTIVE
            $sqlQuery = "UPDATE  waybill.yard_settings  SET  status  = 'INACTIVE' , update_by=?  where id=? ";
            $param1 = [$user_id, $id];
            $result = DBConnection::runBindDatabaseQuery($sqlQuery, $param1);

            // insert new record
            $sqlQuery2 = "INSERT INTO waybill.yard_settings (yard_id , yard_name, settings, status, update_by) VALUES (?,?,?,?,?)";
            $param2 = [$yard_id, 'Yard 4', $settings, 'ACTIVE', $user_id];
            $result = DBConnection::runBindDatabaseQuery($sqlQuery2, $param2);


            DBConnection::commitTransaction();
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }

        return $result;
    }

    // ----------------------------------------------------------- //
    // --------------------- get certian yard scenario ----------- //
    // ----------------------------------------------------------- //
    public function getYardScenario($yard_id, $scenraio_id, $user_id)
    {

        // update setting to INACTIVE
        $sqlQuery = "select 
                     id , name, description , 
                     CAST(`details` AS CHAR CHARSET UTF8) AS details
                     from yard_scenario_2 where id = ?";
        $param = [$scenraio_id];
        $result = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        return $result;
    }

    // ------------------------------------------------------- //
    // --------------------- search yard scenarios ----------- //
    // ------------------------------------------------------- //
    public function searchYardsScenario($filter, $user_id)
    {

        // update setting to INACTIVE
        $sqlQuery = "select 
                     id , name, description                      
                     from yard_scenario_2";
        $param = [];
        $result = DBConnection::runDatabaseQuery($sqlQuery);

        return $result;
    }

    // ------------------------------------------------------------ //
    // --------------------- save Throughput Prediction ----------- //
    // ------------------------------------------------------------ //
    public function saveThroughputPrediction($yard_id, $arrive, $in_yard, $left, $user_id)
    {
        // update record to INACTIVE
        try {
            DBConnection::startTransaction();

            $sqlQuery1 = "select id from yard_prediction where yard_id = ?  and status='ACTIVE' ";
            $param1 = [$yard_id];
            $result = DBConnection::runBindDatabaseQuery($sqlQuery1, $param1);
            $id = $result[0]->id;

            // update prediction to INACTIVE
            if ($id) {
                $sqlQuery2 = "UPDATE  waybill.yard_prediction SET status  = 'INACTIVE' , update_by=?  where id=? ";
                $param2 = [$user_id, $id];
                $result = DBConnection::runBindDatabaseQuery($sqlQuery2, $param2);
            }

            // insert new prediction
            $sqlQuery3 = "INSERT INTO waybill.yard_prediction (`yard_id`, `arrive`, `in_yard`, `left`, `status`,`update_by`) VALUES
                                                             (?,?,?,?,?,?);";
            $param3 = [$yard_id, $arrive, $in_yard, $left, 'ACTIVE', $user_id];

            $result = DBConnection::runBindDatabaseQuery($sqlQuery3, $param3);

            DBConnection::commitTransaction();
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }

        return $result;
    }

    // ------------------------------------------------------------ //
    // --------------------- get Throughput Prediction ----------- //
    // ------------------------------------------------------------ //
    public function getThroughputPrediction($yard_id, $user_id)
    {

        $sqlQuery1 = "select 
            yard_id,
            CAST(`arrive` AS CHAR CHARSET UTF8) AS arrive,
            CAST(`in_yard` AS CHAR CHARSET UTF8) AS in_yard,
            CAST(`left` AS CHAR CHARSET UTF8) AS `left`

        from yard_prediction where yard_id = ? 
             and status='ACTIVE' ";

        $param1 = [$yard_id];
        $result = DBConnection::runBindDatabaseQuery($sqlQuery1, $param1);
        
        if($result[0]){
            $result[0]->arrive = json_decode($result[0]->arrive);
            $result[0]->in_yard = json_decode($result[0]->in_yard);
            $result[0]->left = json_decode($result[0]->left);
        }
        return $result;
    }
}
