<?php
require_once (dirname(__FILE__)."/../API.php");
require_once (dirname(__FILE__)."/woq_core.php");
require_once (dirname(__FILE__)."/../queue/queue_core.php");
require_once (dirname(__FILE__)."/../waybill_order/waybill_order_core.php");
require_once (dirname(__FILE__).'/../truck_contract/truck_contract_core.php');
require_once (dirname(__FILE__)."/../truck_owner/truck_owner_core.php");
require_once (dirname(__FILE__)."/../user/user_core.php");
require_once (dirname(__FILE__)."/../waybill/waybill_core.php");
require_once (dirname(__FILE__)."/../tender/tender_core.php");


// woq = waybill order queue
class Woq_interface extends API{

    private $_request = array();
    private $_woqCore;
    private $_queueCore;
    private $_truckContractCore;
    private $_truckOwnerCore;
    private $_userCore;
    private $_waybillCore;
    private $_tenderCore;


    public function __construct(){

        // call the super constructur
        $this->_request = parent::__construct();
        $this->_woqCore = new WoqCore();
        $this->_queueCore = new QueueCore();
        $this->_truckContractCore = new TruckContractCore();
        $this->_truckOwnerCore = new TruckOwnerCore();
        $this->_userCore = new UserCore();
        $this->_waybillCore = new WaybillCore();
        $this->_tenderCore = new TenderCore();


        session_start();
        if( !isset($_SESSION['user_id'])){
            throw new Exception('No Session!');
        }

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }
    

    // ---------------------------------------------------------------------------------------------------------- //
    // -------------------- prepare incoming search to be mysql json object ------------------------------------- //
    // ---------------------------------------------------------------------------------------------------------- //
    private function prepareFilter(){
      
        $filter = json_decode($this->_request->filter, true);
        $query = $filter['query'];

        $searchFilter = [];
        $searchFilter['query'] = $query;
        $searchFilter['table_names'] = strtoupper($filter['table_names']);
        $searchFilter['object_status'] = $filter['object_status'];
        $searchFilter['from_date'] = $filter['from_date'];
        $searchFilter['to_date'] = $filter['to_date'];
        $searchFilter['tender_id'] = $filter['tender_id'];
        $searchFilter['q_id'] = $filter['q_id'];

        if ($searchFilter['query'] == "" &&  $searchFilter['from_date'] == null && $searchFilter['to_date'] == null) {
            $searchFilter['from_date'] = date("Y/m/d", strtotime( -2 .' days' ));
        }
        $searchFilter['filter'] = $filter;

        // if the tender list available for user not * (all tenders)
        if ($_SESSION['tender_ids'] && $_SESSION['tender_ids'][0] != "*") {
            $searchFilter['tender_ids'] = implode(",",$_SESSION['tender_ids']) ;
        }
 
        return $searchFilter;

    }


    // ---------------------------------------------------------------------------------------------------------- //
    // --------------------- search for any search text in waybill , waybill-order and queue  ------------------- //
    // ---------------------------------------------------------------------------------------------------------- //
    public function search(){
    
        $searchFilter = $this->prepareFilter();

        $Result = $this->_woqCore->search($searchFilter,
                                          $this->_request->limit,
                                          $this->_request->offset,
                                          $_SESSION['u_id']
        );
        // add procedure column in waybill order cards
        $Result->data = $this->generateWaybillOrderProcedure($Result->data);

        //return response
        parent::response($Result);
    }


    // ------------------------------------------------------------------------------------------------ //
    // --------------------- get single woq record by id , waybill-order and queue  ------------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function get_woq(){
        $woqInfo = $this->_woqCore->get_woq($this->_request->id);

        //return Success reponse
        parent::response($woqInfo[0]);
    }

    // --------------------------------------------------------------------- //
    // --------------------- refresh list of ids for woq ------------------- //
    // --------------------------------------------------------------------- //
    public function refreshData(){

        $woqInfo = $this->_woqCore->refreshData($this->_request->ids,$_SESSION['user_id']);

        // add procedure column in waybill order cards
        $woqInfo = $this->generateWaybillOrderProcedure($woqInfo);

        //return Success reponse
        parent::response($woqInfo);
    }



    private function generateWaybillOrderProcedure($data){
        foreach ($data as &$r) {
            // Add the requiered Procedure to waybill order
            if($r->object_code == 'WAYBILL_ORDER'){
                $objectBean = json_decode($r->object_record);
                if($objectBean->status == "NEW"){
                    $timeDiff = 900000 - difference($objectBean->create_date,DBConnection::getSystemDate());
                    $objectBean->procedure = 0;
                    if($timeDiff > 0){
                        $objectBean->procedure =$timeDiff;
                    }
                }else{
                    $objectBean->procedure = '-';
                }
                $r->object_record = json_encode($objectBean,JSON_UNESCAPED_UNICODE);
            }
        }

        return $data;
    }

    // ----------------------------------------------------------------- //
    // ---------------------  get queue info (stats) ------------------- //
    // ----------------------------------------------------------------- //
    public function getQueueInfo(){

        // search for raw data
        $queueSearchFilter = [
            ['key'=>'q_id','val' => $this->_request->queue_id],
            ['key'=>'tender_id','val' => $this->_request->tender_id],
            ['key'=>'status','val' =>['ACTIVE','PENDING'], 'op'=>'in' ]];
        $queue_qry = $this->_queueCore->searchQueue($queueSearchFilter,3000,0,0);

        // init the 4 variables
        $active_gallab = 0;
        $pending_gallab = 0;
        $active_trilla = 0;
        $pending_trilla = 0;
        $trilla_max_rank = 0;
        $gallab_max_rank = 0;

        $queueInfo = new stdClass();
        foreach ($queue_qry->data as $queueRow) {
            if($queueRow->status == 'ACTIVE' && $queueRow->trail_minor_tt == 201) $active_gallab++;
            if($queueRow->status == 'PENDING' && $queueRow->trail_minor_tt == 201) $pending_gallab++;
            if($queueRow->status == 'ACTIVE' && ($queueRow->trail_minor_tt == 203 || $queueRow->trail_minor_tt == null)) $active_trilla++;
            if($queueRow->status == 'PENDING' && ($queueRow->trail_minor_tt == 203 || $queueRow->trail_minor_tt == null)) $pending_trilla++;
        }
        $queueInfo->queueName= $queue_qry->data[0]->queue_name;
        $queueInfo->trilla_active = $active_trilla;
        $queueInfo->gallab_active = $active_gallab;
        $queueInfo->total_active = intval($active_gallab+$active_trilla);

        $queueInfo->trilla_pending = $pending_trilla;
        $queueInfo->gallab_pending = $pending_gallab;
        $queueInfo->total_pending = intval($pending_gallab+$pending_trilla);

        $maxRankObj = $this->_woqCore->getMaxRank(3,1,$_SESSION['user_id']); //3: tender_id, 1: queue_id
        $queueInfo->trilla_max_rank = $maxRankObj->max_trilla_rank;
        $queueInfo->gallab_max_rank = $maxRankObj->max_gallab_rank;

        //return Success reponse
        parent::response($queueInfo);

    }

    // ---------------------------------------------------------------------------------------------------------- //
    // --------------------- search for any search text in waybill , waybill-order and queue  ------------------- //
    // --------------------- built for trucking company search -------------------------------------------------- //
    // ---------------------------------------------------------------------------------------------------------- //
    public function searchTruckingCompanyWOQ(){

        // get userBean
        $userBean = $this->_userCore->getUserBasic($_SESSION['u_id'],0);

        // search company truck owner recored
        $truck_ownerFilter = [['key'=>'company_id','val' =>$_SESSION['company_id']],
                               ['key'=>'status','val' => ['NEW','ACTIVE'], 'op'=>'in']
                              ];
        $truckOwnerQuery = $this->_truckOwnerCore->searchTruckOwner($truck_ownerFilter,1,0,0);
        $truck_owner_id = $truckOwnerQuery->data[0]->id;

        // search for truck contract (not trailers) for the company
        $companyFleetFilter = [['key'=>'truck_owner_id','val' =>$truck_owner_id],
                               ['key'=>'status','val' => ['NEW','ACTIVE'], 'op'=>'in'],
                               ['key'=>'cat','val' => ['TRUCK-SINGLE','TRUCK'], 'op'=>'in' ]
                              ];
        $contract_qry = $this->_truckContractCore->searchTruckContracts($companyFleetFilter,1000, 0, $_SESSION['user_id'] );

        // prepare the truck_ids
        $truck_ids = [0];
        foreach ($contract_qry->data as $contract) {
            array_push($truck_ids, $contract->truck_id);
        }
 
        // search for truck waybills in active status
        $activeWaybillStatus = DBConnection::getActiveStatus('waybill');
        $waybillFilter = [['key'=>'truck_id','val' => $truck_ids, 'op'=> 'in']];
        $waybill_result = $this->_waybillCore->searchWaybills($waybillFilter,$this->_request->limit, $this->_request->offset,$_SESSION['user_id']) ;
 
        // search for truck queue
        $activeQueueStatus = DBConnection::getActiveStatus('queue');
        $queueSearchFilter = [['key'=>'truck_id','val' =>$truck_ids , 'op' => 'in'],
                              ['key'=>'status','val' =>$activeQueueStatus , 'op' => 'in']];
        $queueResult = $this->_queueCore->searchQueue($queueSearchFilter,
                                                      $this->_request->limit, $this->_request->offset,
                                                      $_SESSION['user_id']) ;

        // search for truck tender_truck
        $activeTenderTruckStatus = DBConnection::getActiveStatus('tender_truck');
        $tenderTruckFilter = [['key'=>'truck_id','val' => $truck_ids, 'op'=> 'in'],
                              ['key'=>'status','val' => $activeTenderTruckStatus, 'op' => 'in']];
        $tenderTruck_result = $this->_tenderCore->searchTenderTruck($tenderTruckFilter,$this->_request->limit, $this->_request->offset,$_SESSION['user_id']) ;


        // prepare the data
        $result = [];
        foreach ($contract_qry->data as $contract) {

            // --------- Truck Details ---------------
            $truck_details = new stdClass();
            $truck_details->tn = $contract->tn;
            $truck_details->truck_id = $contract->truck_id;
            $truck_details->status = $contract->truck_status;
            $truck_details->contract_type = $contract->contract_type;
            $truck_details->truck_owner_name = $contract->name;
            $truck_details->truck_owner_nn = $contract->nn;
            $truck_details->truck_owner_phone = $contract->phone;
            $truck_details->create_date = $contract->create_date;
            $truck_details->tc_name = $contract->name;
            $truck_details->tt = $contract->tt;
            $truck_details->minor_tt = $contract->minor_tt;
            $truck_details->photos = $contract->photos;


            // --------- WOQ -----------------------------
            // waybill
            $waybill_details = null;
            foreach ($waybill_result->data as $waybill) {

                if($waybill->truck_id == $contract->truck_id){
                    $waybill_details = new stdClass();

                    $waybill_doc = json_decode($waybill->document);
                    $waybill_details->id = $waybill->id;
                    $waybill_details->wn = $waybill->wn;
                    $waybill_details->tn = $waybill_doc->carrier[0]->truck->tn;
                    $waybill_details->trn = $waybill_doc->carrier[0]->trailer->tn;
                    $waybill_details->driver_name = $waybill_doc->carrier[0]->driver->name;
                    $waybill_details->driver_phone = $waybill_doc->carrier[0]->driver->phone;
                    $waybill_details->pa_company_name = ""; //TODO
                    $waybill_details->status = $waybill->status;
                    $waybill_details->cargo_id = $waybill_doc->cargo[0]->cargo_id;
                    $waybill_details->cargo_name = $waybill_doc->cargo[0]->name;
                    $waybill_details->create_date = $waybill->create_date;
                    break;
                }
            }

            $queue_details = null;
            foreach ($queueResult->data as $queue) {
                if($queue->truck_id == $contract->truck_id){
                    $queue_details = new stdClass();

                    $queue_details->q_id = $queue->q_id;
                    $queue_details->id = $queue->id;
                    $queue_details->queue_name = $queue->queue_name;
                    $queue_details->status = $queue->status;
                    $queue_details->rank = $queue->rank;
                    $queue_details->trn = $queue->trn;
                    $queue_details->driver_name = $queue->driver_name;
                    $queue_details->driver_phone = $queue->driver_phone;
                    break;
                }
            }

            // tender trucks
            $tenderTruck_details = null;
            foreach ($tenderTruck_result->data as $tenderTruck) {

                if($tenderTruck->truck_id == $contract->truck_id){
                    $tenderTruck_details = new stdClass();

                    $tenderTruck_details->id = $tenderTruck->id;
                    $tenderTruck_details->tender_id = $tenderTruck->tender_id;
                    $tenderTruck_details->tender_name = $tenderTruck->tender_name;
                    $tenderTruck_details->tender_company_id = $tenderTruck->tender_company_id;
                    $tenderTruck_details->status = $tenderTruck->status;

                    break;
                }
            }

            //push the data into the result object
            $temp = new stdClass();
            $temp->woq = new stdClass();
            $temp->truck_details = $truck_details;
            $temp->woq->waybill = $waybill_details;
            $temp->woq->queue = $queue_details;
            $temp->woq->tender_truck = $tenderTruck_details;
            array_push($result,$temp);
        }

        // ------------------- apply filter -------------------------
        $filter = json_decode($this->_request->filter, true);
        $index = 0;
        foreach ($result as $r) {
            // search for TN, TRN, Container
            if($filter['search']){
                if ( strpos($r->truck_details->tn, $filter['search']) === false &&
                     strpos($r->woq->queue->trn, $filter['search']) === false   &&
                     strpos($r->woq->waybill->cargo_name, $filter['search']) === false){
                     unset($result[$index]);
                }
            }
            // search for tender_id
            if($filter['tender_id']){
                if(!$r->woq->tender_truck) unset($result[$index]);
                if($r->woq->tender_truck->tender_id != $filter['tender_id']){
                    unset($result[$index]);
                }
            }
            // search for contract_type
            if($filter['contract_type']){
                if($r->truck_details->contract_type != $filter['contract_type']){
                    unset($result[$index]);
                }
            }
            // search for queue
            if($filter['q_id']){
                if($r->woq->queue->q_id != $filter['q_id']){
                    unset($result[$index]);
                }
            }

            $index++;
        }
        $result = array_values($result); // 'reindex' array

        $output = new stdClass();
        $output->data = $result;
        $output->found_rows = $contract_qry->found_rows;

        parent::response($output);
    }

}

$woq_interface = new Woq_interface();
