<?php 

// import objects
require_once (dirname(__FILE__)."/../../includes/DBConnection.php"); 
require_once (dirname(__FILE__)."/../../includes/util.php");

class WoqCore {

    public function __construct(){
        DBConnection::getInstance();
    }

    // ---------------------------------------------------------------------------------------------------------- //
    // --------------------- search for any search text in waybill , waybill-order and queue  ------------------- //
    // ---------------------------------------------------------------------------------------------------------- //
    public function search($searchFilter, $limit, $offset, $user_id){
        
        $searchResult = DBConnection::search_woq($searchFilter['table_names'] ,$searchFilter['query'], $searchFilter['filter'],
                                                $searchFilter['tender_id'],$searchFilter['q_id'],
                                                $searchFilter['from_date'],$searchFilter['to_date'],$searchFilter['object_status'],
                                                $limit, $offset,$user_id,$searchFilter['tender_ids']);
        return $searchResult;
    }


    // ------------------------------------------------------------------------ //
    // ------------------- Create woq bean and fill it from DB  --------------- //
    // ------------------------------------------------------------------------ //
    public function get_woq($id){

        $db_query1 = "select  id,
                        object_code,
                        object_id,
                        CAST(object_record AS CHAR CHARSET UTF8) AS object_record,
                        object_status,
                        object_keys,
                        create_date,
                        search_text
                        from search_waybill_order_queue where id = $id";
        $result = DBConnection::runDatabaseQuery($db_query1);
        return $result;

    }

    // ------------------------------------------------------------------------ //
    // ------------------- Create woq bean and fill it from DB  --------------- //
    // ------------------------------------------------------------------------ //
    public function refreshData($ids, $user_id){
        $db_query1 = "select  id,
                    object_code,
                    object_id,
                    CAST(object_record AS CHAR CHARSET UTF8) AS object_record,
                    object_status,
                    object_keys,
                    create_date,
                    search_text
                    from search_waybill_order_queue woq

                    where id in ($ids)
                    AND EXISTS( SELECT id FROM wf
                                WHERE
                                object_code = woq.object_code
                                and IFNULL(wf.object_status_code, woq.object_status) = woq.object_status
                                AND action_code = 'VIEW'
                                AND status = 'ACTIVE'
                                AND role_code IN (SELECT
                                                role_code
                                                FROM
                                                user_role
                                                WHERE
                                                user_id = $user_id
                                                AND status = wf.role_status_code)
                              )
                    ORDER BY create_date desc";

        $result = DBConnection::runDatabaseQuery($db_query1);

        return $result;

    }

    // ------------------------------------------------------------------------ //
    // ------------------- get max rank for triall and gallab from last distribution --------------- //
    // ------------------------------------------------------------------------ //
    public function getMaxRank($tender_id, $q_id, $user_id){

        $searchFilter = [];
        $getMaxRankQuery = DBConnection::searchDB("assign_cargo",$searchFilter, 1, 0, $user_id);

        $details = $getMaxRankQuery->data[0]->details;
        $details = json_decode($details);

        return $details->info;
    }

}