<?php
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/waybill_order_core.php");
require_once(dirname(__FILE__) . "/../notes/add_notes_core.php");
require_once(dirname(__FILE__) . "/../../core/queue/queue_core.php");
require_once(dirname(__FILE__) . "/../../core/user/user_core.php");
require_once(dirname(__FILE__) . "/../../core/social/social_core.php");
require_once(dirname(__FILE__) . "/../../core/truck/truck_core.php");
require_once(dirname(__FILE__) . "/../../core/tender_driver/tender_driver_core.php");
require_once(dirname(__FILE__) . "/../../core/tender_company/tender_company_core.php");
require_once(dirname(__FILE__) . "/../../core/tender/tender_core.php");
require_once(dirname(__FILE__) . "/../../core/user/user_core.php");
require_once(dirname(__FILE__) . "/../../core/company/trucking_company/trucking_company_core.php");
require_once(dirname(__FILE__) . "/../../core/company/clearing_agent/clearing_agent_core.php");
require_once(dirname(__FILE__) . "/../../core/driver/driver_core.php");
require_once(dirname(__FILE__) . "/../../core/cargo/cargo_core.php");
require_once(dirname(__FILE__) . "/../../core/waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../../core/truck_contract/truck_contract_core.php");
require_once(dirname(__FILE__) . "/../taskQueues/taskQueues_core.php");
require_once(dirname(__FILE__) . "/../../includes/config.php");
require_once(dirname(__FILE__) . "/../../core/truck_routing/truck_routing_core.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/customer_care.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/poll.php");

class Waybill_order_interface extends API
{
    // the request of each call
    private $_request = array();
    private $_waybillOrderCore;
    private $_queueCore;
    private $_tenderCore;
    private $_socialCore;
    private $_truckingCompanyCore;
    private $_truckCore;
    private $_userCore;
    private $_tenderDriverCore;
    private $_tenderCompanyCore;
    private $_driverCore;
    private $_cargoCore;
    private $_waybillCore;
    private $_truckContractCore;
    private $_truckRoutingCore;
    private $_customerCare;
    private $_pollCore;
    private $_clearingAgentCore;

    public function __construct()
    {
        DBConnection::getInstance();
        $this->_request = parent::__construct();

        session_start();
        if (!isset($_SESSION['user_id'])) {
            throw new Exception('No Session!');
        }

        // init the object
        $this->_waybillOrderCore = new WaybillOrderCore();
        $this->_queueCore = new QueueCore();
        $this->_tenderCore = new TenderCore();
        $this->_socialCore = new SocialCore();
        $this->_truckingCompanyCore = new TruckingCompanyCore();
        $this->_truckCore = new TruckCore();
        $this->_userCore = new UserCore();
        $this->_tenderDriverCore = new TenderDriverCore();
        $this->_driverCore = new DriverCore();
        $this->_tenderCompanyCore = new TenderCompanyCore();
        $this->_cargoCore = new CargoCore();
        $this->_waybillCore = new WaybillCore();
        $this->_truckContractCore = new TruckContractCore();
        $this->_truckRoutingCore = new TruckRoutingCore();
        $this->_customerCare = new CustomerCare();
        $this->_pollCore = new Poll();
        $this->_clearingAgentCore = new ClearingAgentCore();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }


    // --------------------------------------------------------------------- //
    // --------------------- get bean for waybill Order  ------------------- //
    // --------------------------------------------------------------------- //
    public function getWaybillOrder()
    {
        $waybillOrder = $this->_waybillOrderCore->getWaybillOrder($this->_request->id, $_SESSION['user_id']);
        $waybillOrderSearchResult = $this->_waybillOrderCore->searchWaybillOrder([['key' => 'id', 'val' => $this->_request->id]], 1, 0,  $_SESSION['user_id']);
        $waybillOrderBean = new stdClass();
        $waybillOrderBean = (object) array_merge((array) json_decode($waybillOrder), (array) $waybillOrderSearchResult->data[0]);

        // get the truck trail minor tt
        $queueSearchFilter = [['key' => 'id', 'val' => $waybillOrderBean->queue_id]];
        $queueInfo = $this->_queueCore->searchQueue($queueSearchFilter, 1, 0, 0)->data[0];

        switch ($queueInfo->trail_minor_tt) {
            case '201':
                $waybillOrderBean->trail_minor_tt = 'قلاب';
                break;
            case '203':
                $waybillOrderBean->trail_minor_tt = 'تريلا';
                break;
            case '301':
                $waybillOrderBean->trail_minor_tt = 'صهريج';
                break;
            case '303':
                $waybillOrderBean->trail_minor_tt = 'صهريج مواد نفطية';
                break;
            default:
                $waybillOrderBean->trail_minor_tt = '-';
                break;
        }

        // get the name of the trucking company of the cargo
        $cargoBean = $this->_cargoCore->getCargoBasic($waybillOrderBean->cargo_id, 0);
        $cargo_tc_id = $cargoBean->waybill_template->carrier[0]->tc_id;
        $waybillOrderBean->cargo_trucking_company_id = $cargo_tc_id;
        $tc_searchFilter = [['key' => 'id', 'val' => $cargo_tc_id]];
        $tc_qry = $this->_truckingCompanyCore->searchTruckingCompany($tc_searchFilter, 1, 0, $_SESSION['user_id']);
        $waybillOrderBean->cargo_trucking_company_name = $tc_qry->data[0]->name;

        // get the destination if the user is OPERATION_MANAGER
        $userRoles = (array) explode(",", $_SESSION['USER_ROLES']);
        $isUserOpManger = in_array("OPERATION_MANAGER", $userRoles) || in_array("OPERATION_SUPERVISOR", $userRoles);

        $tender_order_id = $waybillOrderBean->tender_order_id;
        $tenderOrder = $this->_tenderCore->getTenderOrderBasic($tender_order_id, 0);

        $questionnaire = $tenderOrder->questionnaire;

        if ($questionnaire[1]) {
            if ($questionnaire[1]->val == "*") {
                $origin_order = "من أي المواقع";
            } else {
                $origin_order = getLocationName($questionnaire[1]->val);
            }
            $waybillOrderBean->origin_order = $origin_order;
        }


        if ($questionnaire[2]) {
            $minor_tt =  $questionnaire[2]->val;
            if ($minor_tt == "201") $minor_tt_caption = "قلاب";
            if ($minor_tt == "203") $minor_tt_caption = "تريلا";
            if ($minor_tt == "*") $minor_tt_caption = "جميع الانماط متاحة";
            $waybillOrderBean->order_minor_tt = $minor_tt_caption;
        }

        if ($isUserOpManger) {
            if ($questionnaire[0]->val == "*") {
                $origin_order = "من أي المواقع";
            } else {
                $destinationOreder = getLocationName($questionnaire[0]->val);
            }
            $waybillOrderBean->destination_order = $destinationOreder;
        }


        $waybillOrderBean->answer_method = "لم تتم الإجابة بعد";
        // if($answerMethod[0] && in_array($waybillOrderBean->status, ['APPROVED','CLOSED','REVOKED'])){
        //     //$waybillOrderBean->answer_method = $answerMethod[0]->done_by;
        // }

        parent::response($waybillOrderBean);
    }


    private function prepareFilter()
    {
        $waybillFilter = [];

        if ($this->_request->filter) {
            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {
                if ($key == 'duration' || $key == 'create_date') continue;
                if ($key == "search_index") {
                    $tempArr = ['key' => $key, 'val' => $value, 'op' => 'like'];
                } else if ($key == "create_date_from") {
                    $tempArr = ['key' => "create_date", 'val' => $value, 'op' => 'greater than'];
                } else {
                    $tempArr = ['key' => $key, 'val' => $value];
                }

                array_push($waybillFilter, $tempArr);
            }
        }

        // if the tender list available for user not * (all tenders)
        if ($_SESSION['tender_ids'] && $_SESSION['tender_ids'][0] != "*") {
            $temp = ['key' => 'tender_id', 'val' => $_SESSION['tender_ids'], 'op' => 'in'];
            array_push($waybillFilter, $temp);
        }

        return $waybillFilter;
    }



    // -------------------------------------------------------------------------------- //
    // --------------------- search for waybill Order using filter  ------------------- //
    // -------------------------------------------------------------------------------- //
    public function searchWaybillOrder()
    {


        if (!$this->_request->preparefilter) {
            $waybillOrderFilter = $this->prepareFilter();
        } else {
            $waybillOrderFilter = [];
            foreach (json_decode($this->_request->filter) as &$filter) {
                array_push($waybillOrderFilter, ["key" => $filter->key, "val" => $filter->val, "op" => $filter->op]);
            }
        }

        $waybillOrderResult = $this->_waybillOrderCore->searchWaybillOrder(
            $waybillOrderFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        // calculate each record remaining time in case the w-order is NEW
        $currentTime = DBConnection::getSystemDate();
        foreach ($waybillOrderResult->data as &$waybillOrder) {
            if ($waybillOrder->status == "NEW") {
                //to do : the number 900000 should be returned by the database (900000 = 15 min)
                $timeDiff = 900000 - difference($waybillOrder->create_date, $currentTime);
                $waybillOrder->timer = 0;
                if ($timeDiff > 0) {
                    $waybillOrder->timer = $timeDiff;
                }
                try {
                    $waybillOrder->order_notes = json_decode($waybillOrder->order_notes)->accept_waybill_order_sms;
                } catch (Exception $e) {
                    $waybillOrder->order_notes = "";
                }
            } else {
                $waybillOrder->is_app_reachable = null;
            }
            $waybillOrder->server_date = $currentTime;
        }

        //return Success response
        parent::response($waybillOrderResult);
    }

    // --------------------------------------------------------------------------------------------- //
    // --------------------- search for waybill Order to be shown on mobile app  ------------------- //
    // --------------------------------------------------------------------------------------------- //
    public function searchWaybillOrderMobile()
    {


        // validate RECEIVE_ALARM auth
        try {
            DBConnection::has_authority($_SESSION['u_id'], 'WAYBILL_ORDER', 'RECEIVE_ALARM', 'NEW', 'NEW');
        } catch (Exception $e) {
            $Result = new stdClass();
            $Result->data = [];
            $Result->found_rows = 0;
            parent::response($Result);
            die;
        }

        $waybillOrderFilter = [];
        $waybillOrderFilter[] = ["key" => "status", "val" => ['NEW', 'WAITING'], "op" => 'in'];
        $waybillOrderResult = $this->_waybillOrderCore->searchWaybillOrder(
            $waybillOrderFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        // calculate each record remaining time in case the w-order is NEW
        $currentTime = DBConnection::getSystemDate();
        foreach ($waybillOrderResult->data as &$waybillOrder) {

            if ($waybillOrder->status == "NEW" || $waybillOrder->status == "WAITING") {
                //to do : the number 900000 should be returned by the database (900000 = 15 min)
                $timeDiff = 900000 - difference($waybillOrder->create_date, $currentTime);
                $waybillOrder->timer = 0;
                if ($timeDiff > 0) {
                    $waybillOrder->timer = $timeDiff;
                }

                // inject order notes
                try {
                    $waybillOrder->order_notes = json_decode($waybillOrder->order_notes)->accept_waybill_order_sms;
                } catch (Exception $e) {
                    $waybillOrder->order_notes = "";
                }
            } else {
                $waybillOrder->is_app_reachable = null;
            }

            // inject extra info
            // البواخر
            if ($waybillOrder->tender_id == 3) {
                $waybillOrder->info_message =  "لديك أمر حركة للشاحنة رقم $waybillOrder->tn على الحمل $waybillOrder->cargo_name مع شركة $waybillOrder->trucking_company_name";
                $waybillOrder->revoke_message = "في حال الرفض، سيتم تأجيل الدور ليوم واحد";
                $waybillOrder->disable_revoke_button = false;
                $waybillOrder->timesup_action = "none";
            }

            // التموينTODO
            if ($waybillOrder->tender_id == 13) {
                $waybillOrder->info_message =  "لديك أمر حركة للشاحنة رقم $waybillOrder->tn على الحمل $waybillOrder->cargo_name مع  $waybillOrder->trucking_company_name";
                $waybillOrder->revoke_message = "في حال الرفض، سيتم تأجيل الدور ليوم واحد";
                $waybillOrder->disable_revoke_button = false;
                $waybillOrder->timesup_action = "none";
            }

            // النفط
            if ($waybillOrder->tender_id == 11) {
                $waybillOrder->info_message =  "لديك أمر حركة للشاحنة رقم $waybillOrder->tn على $waybillOrder->queue_name ، دورك على الفيول هو: 325";
                $waybillOrder->revoke_message = "في حال الرفض، سيتم تأجيل الدور لثلاثة أيام";
                $waybillOrder->disable_revoke_button = false;
                $waybillOrder->timesup_action = "none";
            }

            $waybillOrder->server_date = $currentTime;
        }

        //return Success response
        parent::response($waybillOrderResult);
    }

    // ------------------------------------------------------------------------------------------------------ //
    // --------------------- get list of waybill Orders as JSON format similar to WOQ search------------------- //
    // -------------------------------------------------------------------------------------------------------- //
    public function searchWaybillOrderJSON()
    {

        if ($this->_request->filter) {
            $waybillFilter = json_decode($this->_request->filter);
        } else if ($this->_request->ids) {
            $ids = explode(",", $this->_request->ids);
            $ids = implode("','", $ids);
            $waybillFilter = [['key' => 'id', 'val' => [$ids], 'op' => 'in']];
        }

        // search database in case of a filter search
        $waybillOrderResult = $this->_waybillOrderCore->searchWaybillOrder(
            $waybillFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        // format the data in a way similar to JSON format in WOQ
        $data = [];
        foreach ($waybillOrderResult->data as $wblOrder) {

            $wblOrderObj = new stdClass();
            $wblOrderObj->id = rand();
            $wblOrderObj->object_code = 'WAYBILL_ORDER';
            $wblOrderObj->object_id = $wblOrder->id;
            $objectRecord = new stdClass();
            $objectRecord->id = $wblOrder->id;
            $objectRecord->tn = $wblOrder->tn;
            $objectRecord->trn = $wblOrder->trn;
            $objectRecord->status = $wblOrder->status;
            $objectRecord->ca_name = $wblOrder->ca_name;
            $objectRecord->tc_name = $wblOrder->trucking_company_name;
            $objectRecord->cargo_id = $wblOrder->cargo_id;
            $objectRecord->caro_name = $wblOrder->cargo_name;
            $objectRecord->driver_nn = $wblOrder->driver_nn;
            $objectRecord->contact_nn = $wblOrder->contact_nn;
            $objectRecord->queue_name = $wblOrder->queue_name;
            $objectRecord->create_date = $wblOrder->create_date;
            $objectRecord->driver_name = $wblOrder->driver->name;
            $objectRecord->tender_name = $wblOrder->name;
            $objectRecord->contact_name = $wblOrder->contact_name;
            $objectRecord->contact_phone = $wblOrder->contact_phone;
            $objectRecord->driver_phone = $wblOrder->driver_phone;
            $objectRecord->truck_owner_nn = $wblOrder->truck_owner->nn; //TODO
            $objectRecord->cargo_owner_name = $wblOrder->consigner->cargo_owner->name ? $wblOrder->consigner->cargo_owner->name : "-";
            $objectRecord->truck_owner_name = $wblOrder->truck_owner->name;
            $objectRecord->truck_owner_phone = $wblOrder->truck_owner->phone;
            $objectRecord->is_app_reachable = $wblOrder->is_app_reachable;
            $objectRecord->procedure = "-";
            $objectRecord->phone_reach_date = $wblOrder->phone_reach_date;

            $wblOrderObj->object_record = json_encode($objectRecord, JSON_UNESCAPED_UNICODE);
            $wblOrderObj->object_status = $wblOrder->status;
            $wblOrderObj->object_keys = null;
            $wblOrderObj->create_date =  $wblOrder->create_date;
            $wblOrderObj->search_text =  $wblOrder->search_index;

            array_push($data, $wblOrderObj);
        }

        $result['data'] = $data;
        $result['found_rows'] = $waybillOrderResult->found_rows;
        parent::response($result);
    }



    // -------------------------------------------------------------------------------- //
    // --------------------- search for waybill Order using filter  ------------------- //
    // --------------------- params: (new_status, duration, remarks)  ----------------- //
    // -------------------------------------------------------------------------------- //
    public function changeStatus()
    {

        try {

            $waybillOrderBean = $this->_waybillOrderCore->getWaybillOrderBasic($this->_request->id, $_SESSION['user_id']);
 
            // push to call center or return to waiting
            if ($this->_request->new_status == 'WAITING') {

                // change WO status to WAITING
                $this->_waybillOrderCore->changeStatus($this->_request->id, 'WAITING', $_SESSION['user_id']);
                // change queue status to WAITING
                $queueCore = new QueueCore();
                $queueCore->changeStatus($waybillOrderBean->queue_id, 'WAITING', 0);
                $this->_tenderCore->createCallTicket($this->_request->id, false);
            }

            // Accept waybill order
            else if ($this->_request->new_status == 'APPROVED') {

                // send cancel alarams to mobile APP
                $this->_waybillOrderCore->cancelWaybillOrderNotification($this->_request->id);

                // accept the waybill order
                $this->_waybillOrderCore->acceptWaybillOrder($this->_request->id, $_SESSION['user_id']);

                // get extra info for waybill order
                $waybillOrderFilter = [['key' => 'id', 'val' => $this->_request->id]];
                $waybillOrderQry = $this->_waybillOrderCore->searchWaybillOrder($waybillOrderFilter, 1, 0, $_SESSION['user_id']);
                $waybillOrderInfo = $waybillOrderQry->data[0];

                // write a post on user wall
                $user_id = $this->_waybillOrderCore->getWaybillOrderDefaultContact($this->_request->id);
                $title = "قبول أمر الحركة";
                $msg = "تم قبول أمر الحركة للشاحنة :$waybillOrderInfo->tn+$waybillOrderInfo->trn - الحمل: $waybillOrderInfo->cargo_name - الشركة: $waybillOrderInfo->trucking_company_name";
                $this->_socialCore->createWallEntry($user_id, $title, $msg);

                //return Success response
                $Result['ERRORCODE'] = "0";
                $Result['MESSAGE'] = "WAYBILL_ORDER.SUCCESS_OPERATION";
                $Result['ID'] = $this->_request->id;
                parent::response($Result, 200);
            }

            // reject waybill order for company
            else if ($this->_request->new_status == 'REVOKED' && !$waybillOrderBean->tc_details->tn) {

                if ($this->_request->remarks) {
                    $addNoteCore = new Add_notes_core();
                    $addNoteCore->addNotes('waybill_order', $waybillOrderBean->id, $this->_request->remarks, 0);
                }
                $this->_waybillOrderCore->changeStatus($waybillOrderBean->id, 'REVOKED', $_SESSION['user_id']);

                //return Success response
                $Result['ERRORCODE'] = "0";
                $Result['MESSAGE'] = "WAYBILL_ORDER.SUCCESS_OPERATION";
                parent::response($Result, 200);
            }

            // reject waybill order for indivisuals
            elseif ($this->_request->new_status == 'REVOKED') {

                // send cancel alarams to mobile APP
                $this->_waybillOrderCore->cancelWaybillOrderNotification($this->_request->id);

                // reject the waybill order
                $this->_waybillOrderCore->rejectWaybillOrder($this->_request->id, $this->_request->duration, $this->_request->remarks, $_SESSION['user_id']);

                // get extra info for waybill order
                $waybillOrderFilter = [['key' => 'id', 'val' => $this->_request->id]];
                $waybillOrderQry = $this->_waybillOrderCore->searchWaybillOrder($waybillOrderFilter, 1, 0, $_SESSION['user_id']);
                $waybillOrderInfo = $waybillOrderQry->data[0];

                // write a post on user wall
                $user_id = $this->_waybillOrderCore->getWaybillOrderDefaultContact($this->_request->id);
                $title = "رفض أمر الحركة";
                if ($this->_request->duration > 0)
                    $msg = "تم رفض أمر الحركة للشاحنة :$waybillOrderInfo->tn+$waybillOrderInfo->trn - الحمل: $waybillOrderInfo->cargo_name - وتم تأجيل الدور لمدة: $this->_request->duration يوم";
                if ($this->_request->duration == -1)
                    $msg = "تم رفض أمر الحركة للشاحنة :$waybillOrderInfo->tn+$waybillOrderInfo->trn - الحمل: $waybillOrderInfo->cargo_name - وتم ارجاعها لاخر الدور";
                else
                    $msg = "تم رفض أمر الحركة للشاحنة :$waybillOrderInfo->tn+$waybillOrderInfo->trn";
                $this->_socialCore->createWallEntry($user_id, $title, $msg);

                //return Success response
                $Result['ERRORCODE'] = "0";
                $Result['MESSAGE'] = "WAYBILL_ORDER.SUCCESS_OPERATION";
                $Result['ID'] = $this->_request->id;
                parent::response($Result, 200);
            }

            // freeze waybill order
            elseif ($this->_request->new_status == 'HELD') {

                $waybill_order_id = $this->_request->id;
                $waybillOrderBean = $this->_waybillOrderCore->getWaybillOrderBasic($waybill_order_id, $_SESSION['user_id']);
                $addNoteCore = new Add_notes_core();
                $queueCore = new QueueCore();

                // change waybill order to REVOKED
                $this->_waybillOrderCore->changeStatus($waybill_order_id, 'REVOKED', $_SESSION['user_id']);

                // change queue status to HELD
                $queueCore->changeStatus($waybillOrderBean->queue_id, 'HELD', 0);

                // write remark on waybill order and queue
                $addNoteCore->addNotes('waybill_order', $waybill_order_id, 'تم الغاء امر الحركة بسبب تجميد دور الشاحنة على التموين', 0);
                $addNoteCore->addNotes('queue', $waybillOrderBean->queue_id, 'تم تجميد دور الشاحنة بسبب وجود ارسالية على التموين', 0);

                //return Success response
                $Result['ERRORCODE'] = "0";
                $Result['MESSAGE'] = "WAYBILL_ORDER.SUCCESS_OPERATION";
                $Result['ID'] = $this->_request->id;
                parent::response($Result, 200);
            }

            // close waybill order
            elseif ($this->_request->new_status == 'CLOSED') {
                $result = $this->_waybillOrderCore->closeWaybillOrder($this->_request->id, $_SESSION['user_id']);

                // if the tender has create notification when closing Waybill_order
                $tenderOrderBean = $this->_tenderCore->getTenderOrderBasic($waybillOrderBean->tender_order_id, 0);           
                if($tenderOrderBean->tender_id == 22){
                    $cargoBean = $this->_cargoCore->getCargoBasic($tenderOrderBean->cargo[0], 0);
                    // send SMS to ca
                    $tn =  $waybillOrderBean->tc_details->tn;
                    $cargoName= $cargoBean->name;
                    $message = "تم إنشاء مستند شحن للسيارة $tn على الحمولة  $cargoName";
                    //$this->_clearingAgentCore->informClearingAgentEmployee($cargoBean->ca_id,"انشاء مستند شحن", $message);
                                
                    // for demo
                    $result = sendSMS("0791233492", $message);
                }
 
                //return Success response
                $Result['ERRORCODE'] = "0";
                $Result['MESSAGE'] = "تمت العملية بنجاح - " . $result['MESSAGE'];
                $Result['waybill_order_id'] = $result['waybill_order_id'];
                $Result['waybill_id'] =  $result['waybill_id'];
                $Result['wn'] =  $result['wn'];
                parent::response($Result, 200);
            }

            // reject waybill order by company
            elseif ($this->_request->new_status == 'REJECTED') {

                // change WO status to WAITING
                $this->_waybillOrderCore->changeStatus($this->_request->id, 'REJECTED', $_SESSION['user_id']);

                //return Success response
                $Result['ERRORCODE'] = "0";
                $Result['MESSAGE'] = "تمت العملية بنجاح ";
                $Result['waybill_order_id'] = $this->_request->id;
                parent::response($Result, 200);
            } elseif ($this->_request->new_status == 'NEW') {
                // change WO status to NEW
                $this->_waybillOrderCore->changeStatus($this->_request->id, 'NEW', $_SESSION['user_id']);
            }
        } catch (Exception $e) {

            $this->_waybillOrderCore->cancelWaybillOrderNotification($this->_request->id);

            if (strpos($e->getMessage(), "uk_waybill_active_truck")) {
                throw new Exception("لا تستطيع المتابعة ، الشاحنة لديها رحلة غير منتهية");
            } else if (strpos($e->getMessage(), "uk_waybill_active_trailer")) {
                throw new Exception("لا تستطيع المتابعة ، المقطورة لديها رحلة غير منتهية");
            } else if (strpos($e->getMessage(), "uk_waybill_active_driver")) {
                throw new Exception("لا تستطيع المتابعة ، السائق لديه رحلة غير منتهية");
            } else {
                throw new Exception($e->getMessage());
            }
        }
    }


    // ---------------------------------------------------------------------------------------------------------------- //
    // ---------------- search the approved waybill order in case they are late for a certain time  ------------------- //
    // ---------------------------------------------------------------------------------------------------------------- //
    public function returnApprovedWaybillOrders()
    {

        //prepare filter
        $waybillOrderFilter = $this->prepareFilter();
        $filter = json_decode($this->_request->filter, true);

        // in case the user wants to search by number of hours
        if ($filter['duration']) {
            $now = new DateTime(DBConnection::getSystemDate()); //current date/time
            $now->sub(new DateInterval("PT{$filter['duration']}H"));
            $new_time = $now->format('Y-m-d H:i:s');
            $tempArr = ['key' => 'create_date', 'val' => $new_time, 'op' => 'less than'];
            array_push($waybillOrderFilter, $tempArr);
        }
        // in case the user want to search for specific date
        if ($filter['create_date']) {
            $tempArr = ['key' => 'create_date', 'val' => $filter['create_date'], 'op' => 'date greater than'];
            array_push($waybillOrderFilter, $tempArr);

            $new_date = DateTime::createFromFormat('Y-m-d', $filter['create_date'])->modify('+1 day')->format('Y-m-d');
            $tempArr = ['key' => 'create_date', 'val' => $new_date, 'op' => 'date less than'];
            array_push($waybillOrderFilter, $tempArr);
        }
        // in case the user want to search using tender order id
        if ($filter['tender_order_id']) {
            $tempArr = ['key' => 'tender_order_id', 'val' => $filter['tender_order_id']];
            array_push($waybillOrderFilter, $tempArr);
        }

        $tempArr = ['key' => 'status', 'val' => 'APPROVED'];
        array_push($waybillOrderFilter, $tempArr);

        // search for the waybill_orders
        $approvedWaybilloRders = $this->_waybillOrderCore->searchWaybillOrder($waybillOrderFilter, 1000, 0, $_SESSION['user_id']);
        parent::response($approvedWaybilloRders, 200);
    }

    // ------------------------------------------------------------------- //
    // ---------------- revoke bulk of waybill orders  ------------------- //
    // ------------------------------------------------------------------- //
    public function revokeBulkWaybillOrders()
    {

        $ids_arr = explode(",", $this->_request->ids);
        $tender_id = $this->_request->tender_id;
        $q_id = $this->_request->q_id;

        try {

            // check if there is an active tender order on the queue              
            $date = new DateTime(date("Y-m-d"));
            $end_date = $date->modify('-1 day')->format('Y-m-d 23:59:59');
            $searchFilter = [
                ["key" => 'tender_id', 'val' => $tender_id],
                ["key" => 'q_id', 'val' => $q_id],
                ["key" => 'status', 'val' => ['ACTIVE', 'PENDING'], "op" => "in"],
                ["key" => 'order_date', 'val' => $end_date, "op" => "date less than"],
            ];
            $tender_orders = $this->_tenderCore->searchTenderOrder($searchFilter, 100, 0, $_SESSION['user_id']);
            if ($tender_orders->found_rows > 0) {
                throw new Exception("لا يمكنك الغاء اوامر الحركة على هذا الدور, يوجد طلبية فعالة برقم " . $tender_orders->data[0]->id);
            }

            // loop on waybill order
            foreach ($ids_arr as $id) {
                // get the waybillOrderBean
                $waybillOrderBean = $this->_waybillOrderCore->getWaybillOrderBasic($id, 0);

                $queue_id = $waybillOrderBean->queue_id;
                $q_id = $waybillOrderBean->tc_details->q_id;
                $tender_id = $waybillOrderBean->tc_details->tender_id;
                $truck_id = $waybillOrderBean->tc_details->truck_id;

                // get delay options
                $delayOptions = $this->_queueCore->getQueueDelayOptions($waybillOrderBean->queue_id, $tender_id, $q_id, $_SESSION['user_id']);

                // in case the truck has available delay, reject the WO for 1 day
                if ($delayOptions->delay_options) {
                    $this->_waybillOrderCore->rejectWaybillOrder($id, 1, 'بسبب انقضاء المهلة الزمنية للحضور', $_SESSION['user_id']);
                }
                // in case no delay options is left, return it to the last of the queue
                else {
                    if ($tender_id == 12) {
                        $this->_waybillOrderCore->rejectWaybillOrder($id, -1, 'بسبب عدم الحضور', $_SESSION['user_id']);
                    } else {
                        $this->_waybillOrderCore->rejectWaybillOrder($id, -1, 'بسبب استنفاذ كامل رصيد التأجيلات', $_SESSION['user_id']);
                    }
                }

                // change status of tender truck
                if ($tender_id != 12) {
                    $tenderSearchFilter = [
                        ['key' => 'truck_id', 'val' => $truck_id],
                        ['key' => 'tender_id', 'val' => $tender_id],
                        ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in']
                    ];
                    $tenderTruckResult = $this->_tenderCore->searchTenderTruck($tenderSearchFilter, 1, 0, 0);

                    if ($tenderTruckResult->found_rows > 0) {
                        $tender_truck_bean = $tenderTruckResult->data[0];
                        // change status of tender truck to pending
                        $this->_tenderCore->changeTruckStatus($tender_truck_bean->id, 'PENDING', 0);

                        //write remark on tender_truck
                        $addNoteCore = new Add_notes_core();
                        $revokeDateEnd = date('Y-m-d H:i', strtotime(DBConnection::getSystemDate() . ' + 2 day'));
                        $addNoteCore->addNotes(
                            'tender_truck',
                            $tender_truck_bean->id,
                            'تم ايقاف عقد تشغيل الشاحنة لمدة يومين بسبب انقضاء المهلة الزمنية للحضور' . '- سيتم فك الايقاف بتاريخ: ' . $revokeDateEnd,
                            0
                        );
                    }

                    //write remark on queue
                    $revokeDateEnd = date('Y-m-d', strtotime(DBConnection::getSystemDate() . ' + 2 day'));
                    $this->_queueCore->logActivity(
                        $waybillOrderBean->queue_id,
                        "اضافة ملاحظة",
                        'تم ايقاف عقد تشغيل الشاحنة لمدة يومين بسبب انقضاء المهلة الزمنية للحضور' . '- سيتم فك الايقاف بتاريخ: ' . $revokeDateEnd,
                        "ADD_NOTES",
                        $_SESSION['user_id']
                    );
                    // create task to activate the contracts after 2 days
                    $taskQueuesCore = new TaskQueuesCore();
                    $taskQueuesCore->creteActivatTenderTruckTask($tender_truck_bean->id);
                }
            }
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }

        //return Success response
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "WAYBILL_ORDER.SUCCESS_OPERATION";
        parent::response($Result, 200);
    }

    // ------------------------------------------------------ CALL CENTER INTEGERATION METHODS -------------------------------------------------------- //

    // ------------------------------------------------------------------------------------------------------ //
    // ---------------- Process the result of the phone call done by call center system  -------------------- //
    // ---------------- param: phone_number, call_details, result ------------------------------------------- //
    // ------------------------------------------------------------------------------------------------------ //
    public function processPhoneCallResult()
    {

        // prepare needed objects
        $addNoteCore = new Add_notes_core();
        $queueCore = new QueueCore();
        $socialCore = new SocialCore();

        // prepare input param
        $dony_by = $_SESSION['user_id'];
        $waybill_order_id = $this->_request->id;
        if (!$waybill_order_id) {
            throw new Exception("INVALID.WAYBILL_ORDER", 500);
        }

        // get the phone number and waybill order bean
        $phone_number = convertToInternational($this->_request->phone_number);
        $waybillOrderBean = $this->_waybillOrderCore->getWaybillOrderBasic($waybill_order_id, 0);
        $tender_id = $waybillOrderBean->tc_details->tender_id;

        $super_visor_user_id = $this->_tenderCore->getCallCenterSupervisorId($tender_id);

        // handle each answer
        switch (strtoupper($this->_request->result)) {

                // -------------------------- No Answer from user ------------------------------------------------------
            case 'NO_ANSWER':
                // Add note on waybill order and return it to WAITING
                $addNoteCore->addNotes('WAYBILL_ORDER', $waybill_order_id, " حاول نظام الإتصال الصوتي الوصول لجهة الإتصال على الرقم " . $phone_number . " ولكن السائق/المالك لا يرد", $dony_by);
                $this->_waybillOrderCore->changeStatus($waybill_order_id, 'WAITING', $dony_by);
                break;

                // -------------------------- Number is busy -----------------------------------------------------------
            case 'BUSY':
                // Add note on waybill order and return it to WAITING
                $addNoteCore->addNotes('WAYBILL_ORDER', $waybill_order_id, " حاول نظام الإتصال الصوتي الوصول لجهة الإتصال على الرقم " . $phone_number . " ولكن السائق/المالك مشغول", $dony_by);
                $this->_waybillOrderCore->changeStatus($waybill_order_id, 'WAITING', $dony_by);
                break;

                // -------------------------- Distination Unreachable ---------------------------------------------------
            case 'UNREACHABLE':
                // Add note on waybill order and return it to WAITING
                $addNoteCore->addNotes('WAYBILL_ORDER', $waybill_order_id, " حاول نظام الإتصال الصوتي الوصول لجهة الإتصال على الرقم " . $phone_number . " ولكن السائق/المالك لا يمكن الاتصال به", $dony_by);
                $this->_waybillOrderCore->changeStatus($waybill_order_id, 'WAITING', $dony_by);
                break;

                // -------------------------- Wrong Contact Number ------------------------------------------------------
            case 'INVALID':
                // Add note on waybill order and return it to WAITING
                $addNoteCore->addNotes('WAYBILL_ORDER', $waybill_order_id, " حاول نظام الإتصال الصوتي الوصول لجهة الإتصال على الرقم " . $phone_number . " ولكن الرقم غير مستعمل أو غير صحيح", $dony_by);
                $this->_waybillOrderCore->changeStatus($waybill_order_id, 'WAITING', $dony_by);

                // inform call center supervisor
                $super_visor_user_id = $this->_tenderCore->getCallCenterSupervisorId($tender_id);
                $notification_title = "رقم جهة الإتصال غير صحيح";
                $notification_body = "رقم جهة الإتصال لأمر الحركة  $waybillOrderBean->id غير صحيح";
                $socialCore->informSupervisor($notification_title, $notification_body, $notification_body);

                break;

                // ----------------------------- number of retrials reachs 0 ---------------------------------------------
            case 'NO_RETRY':
                // get truck remaining delay options
                $queueBean = $queueCore->getQueueBasic($waybillOrderBean->queue_id, 0);
                $options = $queueCore->getQueueDelayOptions($waybillOrderBean->queue_id, $queueBean->tender_id, $queueBean->q_id, 0);

                // if it has delay options, change status of queue to PENDING with dalay = 1
                if (isset($options->delay_options)) {
                    $duration = 1;
                    $remarks = "تمت محاولة الإتصال بسائق/مالك الشاحنة على الرقم $phone_number لعدد كبير من المرات بدون الحصول على اجابة، وتم تأجيل الدور ليوم واحد";

                    // reject the waybill order
                    $this->_waybillOrderCore->rejectWaybillOrder($waybill_order_id, $duration, $remarks, $dony_by);
                }
                // in case the truck has no more delay options, inform the call center supervisor
                else {

                    $super_visor_user_id = $this->_tenderCore->getCallCenterSupervisorId($tender_id);
                    $notification_body = "لم يتمكن نظام الإتصال الإلي من الوصول للرقم $phone_number صاحب أمر الحركة $waybillOrderBean->id ولا يوجد للشاحنة تأجيلات متاحة";
                    $notification_title = "الرجاء متابعة امر الحركة رقم $waybillOrderBean->id";
                    $socialCore->informSupervisor($notification_title, $notification_body, $notification_body);

                    // return to waiting status
                    $this->_waybillOrderCore->changeStatus($waybill_order_id, 'WAITING', 0);

                    // repush the waybill order to call center as manual mode
                    $this->_tenderCore->createCallTicket($waybill_order_id, true);
                }

                break;

                // ------------------------------ Accept Waybill Order ----------------------------------------------------
            case '0':
                $this->_waybillOrderCore->acceptWaybillOrder($waybill_order_id, $dony_by);
                break;

                // ------------------------------ Reject Waybill Order ----------------------------------------------------
            case '1':
            case '2':
            case '3':
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':
                $duration = $this->_request->result;
                $remarks = 'تم الإتصال بسائق/مالك الشاحنة عبر نظام الإتصال الالي';

                // reject the waybill order
                $this->_waybillOrderCore->rejectWaybillOrder($waybill_order_id, $duration, $remarks, $dony_by);
                break;

                // ----------------------------- Reject Waybill Order and return to end of queue --------------------------
            case '-1':
                $duration = $this->_request->result;
                $remarks = 'تم ارجاع الشاحنة لأخر الدور بسبب نفاذ خيارات التأجيل';

                $addNoteCore->addNotes('WAYBILL_ORDER', $waybill_order_id, "تم ارجاع الشاحنة لأخر الدور بسبب نفاذ خيارات التأجيل", $dony_by);

                // reject the waybill order
                $this->_waybillOrderCore->rejectWaybillOrder($waybill_order_id, $duration, $remarks, $dony_by);
                break;

            default:
                // Do nothing
                break;
        }

        //return Success response
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "SUCCESSFUL_OPERATION";
        parent::response($Result, 200);
    }



    // ------------------------------------------------------------------------------ //
    // ---------------- assign phone call to a certain employee  -------------------- //
    // ---------------- param: phone_number, call_details, slot_details ------------- //
    // ------------------------------------------------------------------------------ //
    public function assignPhoneCall()
    {

        //parse the incoming param
        $slot_details = json_decode($this->_request->slot_details);
        $call_details = json_decode($this->_request->call_details);
        $phone_number = $this->_request->phone_number;
        $cc_id = $this->_request->cc_id;

        $details = $call_details;
        $details->phone_number = $phone_number;
        $details->cc_id = $cc_id;

        // validate waybill_order date
        $waybill_order_id = $details->id;
        $waybillOrderBean = $this->_waybillOrderCore->getWaybillOrderBasic($waybill_order_id, 0);
        $wo_date_Date = date('Y-m-d', strtotime($waybillOrderBean->create_date));
        $today    =  date('Y-m-d', strtotime(DBConnection::getSystemDate()));
        if ($wo_date_Date != $today) {
            $this->cancelCall($waybill_order_id);
        }

        //get the user UUID
        $user_id = $slot_details->user_id;
        $userCore = new UserCore();
        $userHB = $userCore->getUserHeartBeatObject($user_id);
        $UUID = $userHB->UUID;

        //send websocket
        $socialCore = new SocialCore();
        $socialCore->sendWebSocket($UUID, "ASSIGN_CALL", $details);

        // return success
        $Result = [];
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "SUCCESSFUL_OPERATION";
        parent::response($Result, 200);
    }

    // ------------------------------------------------------------------------------------ //
    // ---------------- when the employee accept phone call request ----------------------- //
    // ---------------- param: phone_number, call_details, result ------------------------- //
    // ------------------------------------------------------------------------------------ //
    public function saveAssignCallResponse()
    {

        // call API in callCenter System
        $phone_number = $this->_request->phone_number;
        $result = $this->_request->result; //0=accept assign , -1= reject
        $cc_id = $this->_request->cc_id;

        $url = Config::$call_center_base_url . "/saveAssignCallResponse";

        $fields = array(
            'phone_number' => urlencode($phone_number),
            'cc_id' => $cc_id,
            'result' => urlencode($result)
        );
        $result = callCurl($url, $fields);

        parent::response("DONE", 200);
    }


    // ------------------------------------------------------------------------------------------------------------ //
    // ---------------- send the phone call result provided by driver to call center system ----------------------- //
    // ---------------- param: phone_number,  result -------------------------------------------------------------- //
    // ------------------------------------------------------------------------------------------------------------ //
    public function saveCallRequestResult()
    {

        // call API in callCenter System
        $phone_number = $this->_request->phone_number;
        $waybill_order_id = $this->_request->waybill_order_id;
        $call_details = array(
            'user_id' => $_SESSION['user_id'],
            'waybill_order_id' => $waybill_order_id
        );

        $result = $this->_request->result;                                        //0=approve, 1-9=revoke, NO_ANSWER, BUSY, UNREACHABLE, CLOSED, INVALID
        $cc_id = $this->_request->cc_id;

        $url = Config::$call_center_base_url . "/saveCallResult";

        $fields = array(
            'phone_number' => urlencode($phone_number),
            'call_details' => urlencode(json_encode($call_details)),
            'cc_id' => $cc_id,
            'result' => urlencode($result)
        );

        $result = callCurl($url, $fields);

        $Result = [];
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "SUCCESSFUL_OPERATION";
        parent::response($Result, 200);
    }

    // ------------------------------------------------------------------------------------------------------ //
    // --------------------- Send mobile notification to the call center supervisor ------------------------- //
    // ------------------------------------------------------------------------------------------------------ //
    public function notifySupervisor()
    {
        //parse the incoming param
        $slot_details = json_decode($this->_request->slot_details);
        $user_id = $slot_details->user_id;

        // TODO: get the supervisor user_id
        $super_visor_user_id = '2';
        $notification_title = "تنبيه عدم اتصال";
        $notification_body = "الموظف رقم " . $user_id . " لم يستجب لطلب اتصال";
        $socialCore = new SocialCore();
        $socialCore->informSupervisor($notification_title, $notification_body, $notification_body);
        parent::response("DONE", 200);
    }

    // ---------------------------------------------------------------------------------------------------------------------- //
    // ------------------------- this method is called when waybill system want to cancel a call request -------------------- //
    // ---------------------------------------------------------------------------------------------------------------------- //
    public function cancelCall($waybill_order_id)
    {

        $url = Config::$call_center_base_url . "/cancelCall";
        $fields = array(
            'id' => $waybill_order_id
        );
        $response = callCurl($url, $fields);

        // init objects
        $socialCore = new SocialCore();
        $userCore = new UserCore();

        // cancel the UI of the websocket
        $userHB = $userCore->getUserHeartBeatObject($_SESSION['user_id']);
        $UUID = $userHB->UUID;
        $socialCore->sendWebSocket($UUID, "CANCEL_CALL", null);
    }


    // ---------------------------------------------------------------------------------------------------------- //
    // ------------------------- this method is called when the cc System start a phone call -------------------- //
    // ---------------------------------------------------------------------------------------------------------- //
    public function startCall()
    {

        try {
            // add FollowCallTask
            $taskQueuesCore = new TaskQueuesCore();
            //$taskQueuesCore->addFollowCallTask($waybill_order_id);
        } catch (Exception $e) {
            $msg  =  $e;
            $socialCore = new SocialCore();
            $wall_message = $msg;
            $notification_message = $msg;
            $socialCore->informSupervisor('addFollowCallTask error', $wall_message, $notification_message, '2');
        }

        try {
            //parse the incoming param
            $waybill_order_id = $this->_request->id;

            // change status of waybill order to PENDING "جار الإتصال"
            $this->_waybillOrderCore->changeStatus($waybill_order_id, 'PENDING', $_SESSION['user_id']);

            $Result = [];
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "SUCCESSFUL_OPERATION";
            parent::response($Result, 200);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ----------------------------------------------------------------------------------------------------------------------------------- //
    // ----------------- get a summary of approved and closed waybill orders for certain date grouped by trail minor tt------------------- //
    // ----------------------------------------------------------------------------------------------------------------------------------- //
    public function searchApprovedWaybillOrderByMinorTT()
    {

        // parse filter data
        $tender_id = $this->_request->tender_id;
        $create_date = $this->_request->create_date;
        $cargo_id = $this->_request->cargo_id;
        $end_date = date('Y-m-d', strtotime($create_date . ' + 1 days'));
        $param = [];

        // run query
        $sqlQuery = "SELECT
                     COUNT(w.id) cnt,
                     w.cargo_name,
                     w.cargo_id,
                        tender_order.order_date,
                     CASE
                        WHEN w.status = 'CLOSED' THEN 'مكتمل'
                        WHEN w.status = 'APPROVED' THEN 'موافق عليه'
                        END AS status,
                        (SELECT CASE
                                WHEN t.minor_tt = 201 THEN 'قلاب'
                                WHEN t.minor_tt = 203 THEN 'تريلا'
                                WHEN t.minor_tt = 9 THEN 'تريلا'
                                END
                            FROM truck t
                            WHERE w.trn = tn AND status = 'ACTIVE') AS tt
                     FROM
                        waybill_order_view w , tender_order
                    WHERE
                            w.tender_order_id = tender_order.id
                     and w.status in ('APPROVED','CLOSED')
                            AND w.tender_id = $tender_id ";

        if ($create_date && $end_date) {
            $sqlQuery .= "and w.create_date > ?
                          and w.create_date < ? ";

            $param[] = $create_date;
            $param[] = $end_date;
        }

        if ($cargo_id) {
            $sqlQuery .= "and w.cargo_id = ? ";
            $param[] = $cargo_id;
        }

        $sqlQuery .= "GROUP BY w.cargo_name , w.cargo_id , order_date , status , tt";

        if (sizeof($param) == 0) {
            return;
        }

        $data = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        // format data
        $result = new stdClass();
        $result->data = $data;
        $result->found_rows = sizeof($data);
        parent::response($result, 200);
    }

    // -------------------------------------------------------------------------------------------------------------------------------- //
    // ----------------- Get a report of all waybill orders that were revoked because they exceeded the allowed time to come ---------- //
    // -------------------------------------------------------------------------------------------------------------------------------- //
    public function getRevokedWaybillOrdersReport()
    {
        // parse filter data
        $tender_id = $this->_request->tender_id;
        $revokeDate = $this->_request->revoke_date;

        // run query to get raw data
        $revokeDateStart = $revokeDate;
        $revokeDateEnd = date('Y-m-d', strtotime($revokeDateStart . ' + 1 day'));
        $sqlQuery = "SELECT
                        w.id,
                        w.tn,
                        w.trn,
                        w.cargo_name,
                        w.queue_name,
                        w.contact_name,
                        w.contact_phone,
                        TIMESTAMPDIFF(HOUR, w.order_date,a.activity_date) diff
                    FROM
                        waybill_order_view w,
                        activity a
                    WHERE
                        a.notes = 'إرجاع الشاحنة على الدور بسبب انقضاء المهلة الزمنية'
                            AND a.waybill_order_id = w.id
                            AND w.tender_id = ?
                            AND a.activity_date >= ?
                            AND a.activity_date < ?";

        $param = [$tender_id, $revokeDateStart, $revokeDateEnd];
        $data = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        // format data
        $result = new stdClass();
        $result->data = $data;
        $result->found_rows = sizeof($data);
        parent::response($result, 200);
    }


    // -------------------------------------------------------------------------------------------- //
    // ----------------- Get a report of all trucks that finished all the delays options ---------- //
    // -------------------------------------------------------------------------------------------- //
    public function getNoMoreDelaysTrucksReport()
    {

        // parse filter data
        $tender_order_id = $this->_request->tender_order_id;

        // prepare sql
        $sqlQuery = "SELECT
                        q.tn,
                        w.trn,
                        CASE q.trail_minor_tt
                            WHEN 201 THEN 'قلاب'
                            WHEN 203 THEN 'تريلا'
                        END AS trail_minor_tt,
                        q.rank,
                        w.truck_owner_phone,
                        w.truck_owner_name
                    FROM
                        waybill_order_view w,
                        queue_view q
                    WHERE
                        w.tender_order_id = $tender_order_id
                            AND w.queue_id = q.id
                            AND w.status in ('WAITING')
                            AND q.total_delay = 8";

        $param = [];
        $data = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        // format data
        $result = new stdClass();
        $result->data = $data;
        $result->found_rows = sizeof($data);
        parent::response($result, 200);
    }

    // --------------------------------------------------------------------------------------------------- //
    // ------------------ Update the trucking company id in waybill order -------------------------------- //
    // --------------------------------------------------------------------------------------------------- //
    public function updateWaybillOrderTruckingCompany()
    {

        // get params
        $waybill_order_id = $this->_request->id;
        $tc_id = $this->_request->tc_id;
        if (!$waybill_order_id) throw new Exception("id is not defined");
        if (!$tc_id) throw new Exception("tc_id is not defined");

        // get the tc_details object in waybill order
        $waybillOrderBean = $this->_waybillOrderCore->getWaybillOrderBasic($waybill_order_id, $_SESSION['user_id']);
        $tc_details = $waybillOrderBean->tc_details;

        // get trucking company name
        $tc_searchFilter = [['key' => 'id', 'val' => $tc_id]];
        $tc_qry = $this->_truckingCompanyCore->searchTruckingCompany($tc_searchFilter, 1, 0, $_SESSION['user_id']);
        $truckingCompanyBean = $tc_qry->data[0];
        if (!$truckingCompanyBean) throw new Exception("trucking company is not defined");

        // update trucking company
        $tc_details->tc_company_id = $truckingCompanyBean->id;
        $tc_details->trucking_company_id = $truckingCompanyBean->id;
        $tc_details->trucking_company_name = $truckingCompanyBean->name;
        $waybillOrderBean->tc_details = $tc_details;
        $this->_waybillOrderCore->updateWaybillOrder($waybillOrderBean, $waybill_order_id, $_SESSION['user_id']);

        //return result
        $Result = [];
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "SUCCESSFUL_OPERATION";
        parent::response($Result, 200);
    }


    // --------------------------------------------------------------------------------------------------- //
    // ------------------ Update the tn, trn and driver for waybill order -------------------------------- //
    // --------------------------------------------------------------------------------------------------- //
    public function updateWaybillOrderInfo()
    {

        // get params
        $waybill_order_id = $this->_request->id;
        $tn = $this->_request->tn;
        $trn = $this->_request->trn;
        $nn = $this->_request->nn;


        // get the tc_details object in waybill order
        $waybillOrderBean = $this->_waybillOrderCore->getWaybillOrderBasic($waybill_order_id, $_SESSION['user_id']);
        $tc_details = $waybillOrderBean->tc_details;

        // get the tender_company_id
        $tenderCompanyFilter = [['key' => 'tender_id', 'val' => $tc_details->tender_id], ['key' => 'trucking_company_id', 'val' => $tc_details->trucking_company_id]];
        $tenderCompaniesReuslt = $this->_tenderCompanyCore->searchTenderCompany($tenderCompanyFilter, 1, 0, 0);
        $tenderCompanyId = $tenderCompaniesReuslt->data[0]->id;
        if (!$tenderCompanyId) {
            throw new Exception("أمر حركة مسجل لشركة نقل غير صحيحة");
        }

        // validate truck has valid auth with tc and tender
        if ($tn) {
            $tenderFilter = [
                ['key' => 'tn', 'val' => $tn],
                ['key' => 'status', 'val' => 'ACTIVE'],
                ['key' => 'tender_company_id', 'val' => $tenderCompanyId],
                ['key' => 'tender_id', 'val' => $tc_details->tender_id]
            ];
            $tenderTruck_qry = $this->_tenderCore->searchTenderTruck($tenderFilter, 1, 0, 0);
            if ($tenderTruck_qry->found_rows == 0) {
                throw new Exception("لا تستطيع المتابعة ، الشاحنة غير مرتبطة بعقد تشغيل فعال للمشروع مع شركة النقل صاحبة أمر الحركة");
            }
            $truck_id = $tenderTruck_qry->data[0]->truck_id;
        } else {
            $tn = $waybillOrderBean->tc_details->tn;
            $truck_id = $waybillOrderBean->tc_details->truck_id;
        }


        // validate trailer has valid auth with tc and tender
        if ($trn) {
            $searchFilter = [['key' => 'tn', 'val' => $trn], ['key' => 'status', 'val' => "ACTIVE"]];
            $trailerResult = $this->_truckCore->searchTrucks($searchFilter, 1, 0, 0);
            if ($trailerResult->found_rows == 0) {
                throw new Exception("لا تستطيع المتابعة ، المقطورة غير فعالة");
            }
            $trailer_id = $trailerResult->data[0]->id;
            $tenderFilter = [
                ['key' => 'trailer_id', 'val' => $trailer_id],
                ['key' => 'status', 'val' => 'ACTIVE'],
                ['key' => 'tender_company_id', 'val' => $tenderCompanyId],
                ['key' => 'tender_id', 'val' => $tc_details->tender_id]
            ];
            $tenderTrailer_qry = $this->_tenderCore->searchTenderTruck($tenderFilter, 1, 0, 0);
            if ($tenderTrailer_qry->found_rows == 0) {
                throw new Exception("لا تستطيع المتابعة ، المقطورة غير مرتبطة بعقد تشغيل فعال مع شركة النقل صاحبة أمر الحركة");
            }
        }

        // validate TRN minor tt agains tender order minor tt
        $tender_order_id = $waybillOrderBean->tender_order_id;

        $tenderOrderBean = $this->_tenderCore->getTenderOrderBasic($tender_order_id, 0);
        $order_minor_tt = $tenderOrderBean->questionnaire[2]->val;

        $userRoles = (array) explode(",", $_SESSION['USER_ROLES']);
        $isUserOpManger = in_array("OPERATION_MANAGER", $userRoles) || in_array("OPERATION_SUPERVISOR", $userRoles);
        if (!$isUserOpManger) {
            if ($order_minor_tt && ($order_minor_tt == "201" || $order_minor_tt == "203")) {
                if ($trailer_id) {
                    $trailerBean = $this->_truckCore->getTruckBasic($trailer_id, 0);
                    if ($trailerBean->minor_tt != $order_minor_tt) {
                        $minor_tt_caption = "";
                        if ($order_minor_tt == "201") $minor_tt_caption = "قلاب";
                        if ($order_minor_tt == "203") $minor_tt_caption = "تريلا";
                        throw new Exception("لا تستطيع المتابعة ، نمط المقطورة غير متوافق مع نمط المقطورة المطلوب في امر الحركة" . "- يرجى تثبيت مقطورة " . $minor_tt_caption);
                    }
                }
            }
        }


        if ($nn && $nn != "null") {
            // validate if the driver is already registered on the tender
            $tenderDriverFilter = [
                ['key' => 'tender_id', 'val' => $tc_details->tender_id],
                ['key' => 'nn', 'val' => $nn],
                ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']
            ];
            $tenderDriverResult = $this->_tenderDriverCore->searchTenderDriver($tenderDriverFilter, 1, 0, 0);

            if ($tenderDriverResult->found_rows == 0) {

                // get the tenderBean
                $man = $this->_tenderCore->getTenderManifest($tc_details->tender_id, 0);
                // if adding driver to tender is set to be auto , add the driver
                if ($man['tender_driver']['allow_add_by_system'] == true) {

                    $driverFilter = [['key' => 'nn', 'val' => $nn], ['key' => 'status', 'val' => 'ACTIVE']];
                    $driver_qry = $this->_driverCore->searchDriver($driverFilter, 1, 0, 0);
                    $driver_id = $driver_qry->data[0]->id;
                    if (!$driver_id) {
                        throw new Exception("لا يمكن اضافة عقد تشغيل للسائق، الرقم الوطني غير صحيح");
                    }
                    $tender_driver_id = $this->_tenderDriverCore->create($driver_id, $waybillOrderBean->tc_details->tender_id, 0);
                    $this->_tenderDriverCore->activateTenderDriver($tender_driver_id, 0);

                    $tenderDriverFilter = [
                        ['key' => 'tender_id', 'val' => $waybillOrderBean->tc_details->tender_id],
                        ['key' => 'driver_id', 'val' => $driver_id],
                        ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']
                    ];
                    $tenderDriverResult = $this->_tenderDriverCore->searchTenderDriver($tenderDriverFilter, 1, 0, $_SESSION['user_id']);
                } else {
                    // else throw error
                    throw new Exception("السائق لا يملك عقد تشغيل فعال على المشروع");
                }
            } else {
                // make sure the driver is not black listed
                if ($tenderDriverResult->data[0]->status == "PENDING") {
                    throw new Exception("لا تستطيع المتابعة ، عقد تشغيل السائق موقوف على المشروع");
                }
            }

            // update driver part
            $driverFilter = [
                ['key' => 'nn', 'val' => $nn],
                ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']
            ];
            $driverResult = $this->_driverCore->searchDriver($driverFilter, 1, 0, 0);
            $tc_details->driver_id = $driverResult->data[0]->id;
            $tc_details->driver_nn = $driverResult->data[0]->nn;
            $tc_details->driver_name = $driverResult->data[0]->name;
            $tc_details->driver_phone = $driverResult->data[0]->phone;
        }

        // update trucking company
        $tc_details->truck_id = $truck_id;
        $tc_details->tn = $tn;
        $tc_details->trn = $trn;
        $tc_details->trailer_id = $trailer_id;
        $tc_details->tender_company_id = $tenderCompanyId;
        $waybillOrderBean->tc_details = $tc_details;
        $this->_waybillOrderCore->updateWaybillOrder($waybillOrderBean, $waybill_order_id, $_SESSION['user_id']);


        // update queue with new driver and trn
        if ($waybillOrderBean->queue_id) {
            $updateBean = new stdClass();
            $updateBean->id = $waybillOrderBean->queue_id;
            if ($tc_details->driver_id) {
                $updateBean->driver_id = $driverResult->data[0]->id;
            }
            if ($trailer_id) {
                $updateBean->trailer_id = $trailer_id;
            }

            $this->_queueCore->updateQueue($updateBean, 0);
        }


        // temp solution
        try {
            $userRolesArray = explode(",", $_SESSION['COMPANY_EMPLOYEE_ROLES']);
            foreach ($userRolesArray as $role) {
                if ($role == 'TC_MANAGER') {
                    $this->_waybillOrderCore->acceptWaybillOrder($waybill_order_id, $_SESSION['user_id']);
                }
            }
        } catch (Exception $e) {
        }

        //return result
        $Result = [];
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "SUCCESSFUL_OPERATION";
        parent::response($Result, 200);
    }

    // --------------------------------------------------------------------------------------------------- //
    // ------------------ close WaybillOrder With Deficit  -------------------------------- //
    // --------------------------------------------------------------------------------------------------- //
    public function closeWaybillOrderWithDeficit()
    {
        $id = $this->_request->id;
        try {

            // write note
            $addNoteCore = new Add_notes_core();
            $note = "اغلاق امر الحركة واحتساب عجز على الشركة ، تمت بواسطة : "  . $_SESSION['u_id'];
            $addNoteCore->addNotes('waybill_order', $id, $note, 0);

            // change status
            $this->_waybillOrderCore->changeStatus($id, 'CLOSED', $_SESSION['user_id']);
            $Result = [];
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "SUCCESSFUL_OPERATION";
            parent::response($Result, 200);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------------------------------------------ //
    // ------------------ Create new waybill order for a bulk companies by uploading xls ---------------------------- //
    // ------------------------------------------------------------------------------------------------------------ //
    public function createManualWaybillOrderByExcel()
    {

        try {
            DBConnection::startTransaction();


            $tender_id = $this->_request->tender_id;
            $tender_order_id = $this->_request->tender_order_id;
            $data = $this->_request->data;

            if (!$tender_id) throw new Exception("tender_id is required");
            if (!$tender_order_id) throw new Exception("tender_order_id is required");
            if (!$data) throw new Exception("data is required");

            $allowCreate = false;
            $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
            foreach ($userRolesArray as $role) {
                if ($role == 'OPERATION_MANAGER' || $role == 'OPERATION_SUPERVISOR') {
                    $allowCreate = true;
                    break;
                }
            }
            if (!$allowCreate) {
                throw new Exception("لا يوجد لديك صلاحية للمتابعة");
            }

            $tenderOrderBean = $this->_tenderCore->getTenderOrderBasic($tender_order_id, 0);

            // loop on xls result
            foreach ($data as $row) {
                $trucking_company_id = explode("-", $row->name)[0];
                $tc_searchFilter = [['key' => 'id', 'val' => $trucking_company_id]];
                $tc_qry = $this->_truckingCompanyCore->searchTruckingCompany($tc_searchFilter, 1, 0, $_SESSION['user_id']);
                $truckingCompanyBean = $tc_qry->data[0];

                $tenderCompanyFilter = [['key' => 'trucking_company_id', 'val' => $truckingCompanyBean->id, 'tender_id' => $tender_id]];
                $tenderCompanyBean = $this->_tenderCompanyCore->searchTenderCompany($tenderCompanyFilter, 1, 0, 0)->data[0];

                $wo_count = $row->count;
                $actual_wo_count = 0;

                for ($i = 0; $i < $wo_count; $i++) {
                    // create waybill order bean
                    $waybillOrderBean = new stdClass();
                    $waybillOrderBean->tender_order_id = $tender_order_id;
                    $waybillOrderBean->cargo_id = $tenderOrderBean->cargo[0];
                    $waybillOrderBean->queue_id = null;
                    $waybillOrderBean->truck_owner_id = null;
                    $waybillOrderBean->create_date = DBConnection::getSystemDate();
                    $waybillOrderBean->status = "NEW";
                    // Fill tc_details in waybill order
                    $tc_details = new stdClass();
                    $tc_details->tn = null;
                    $tc_details->q_id = null;
                    $tc_details->trn = null;
                    $tc_details->truck_id = null;
                    $tc_details->driver_nn = null;
                    $tc_details->tender_id = $tenderOrderBean->tender_id;
                    $tc_details->contact_nn = null;
                    $tc_details->queue_name = null;
                    $tc_details->driver_name = null;
                    $tc_details->tender_name = $tenderOrderBean->tender_name;
                    $tc_details->contact_name = $truckingCompanyBean->name;
                    $tc_details->driver_phone = null;
                    $tc_details->contact_phone = null;
                    $tc_details->tc_company_id = $truckingCompanyBean->id;
                    $tc_details->tender_company_id = $tenderCompanyBean->id;
                    $tc_details->truck_owner_id = null;
                    $tc_details->truck_owner_nn = null;
                    $tc_details->truck_owner_name = null;
                    $tc_details->truck_owner_phone = null;
                    $tc_details->trucking_company_id = $truckingCompanyBean->id;
                    $tc_details->trucking_company_name = $truckingCompanyBean->name;
                    $tc_details->extra_note = $tenderOrderBean->order_notes->extra_note;
                    $waybillOrderBean->tc_details = $tc_details;
                    $waybillOrderResult = DBConnection::insertDB("waybill_order", $waybillOrderBean, 0);

                    $actual_wo_count++;
                }

                // insert quota
                $cargo_id = $tenderOrderBean->cargo[0];
                $this->_tenderCore->saveTenderOrderCompany($tender_order_id, $cargo_id, $tenderCompanyBean->id, $actual_wo_count, 0);

                // inform company
                $cargoName = $this->_cargoCore->getCargoBasic($tenderOrderBean->cargo[0], 0)->name;
                $title =  "حصة $cargoName للشركة";
                $message =  "تم تفعيل حصص بعدد $actual_wo_count على الحمولة $cargoName للشركة , الرجاء تثبيت المعلومات";
                $this->_truckingCompanyCore->informComapanyEmployee($truckingCompanyBean->id, $title, $message);
            }

            DBConnection::commitTransaction();

            //return Success response
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "WAYBILL_ORDER.SUCCESS_OPERATION";
            parent::response($Result, 200);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }

    // --------------------------------------------------------------------------------------------- //
    // ------------------ Create new waybill order for a certain company---------------------------- //
    // --------------------------------------------------------------------------------------------- //
    public function createManualWaybillOrder()
    {

        try {
            DBConnection::startTransaction();

            $allowCreate = false;
            $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
            foreach ($userRolesArray as $role) {
                if ($role == 'OPERATION_MANAGER' || $role == 'OPERATION_SUPERVISOR') {
                    $allowCreate = true;
                    break;
                }
            }
            if (!$allowCreate) {
                throw new Exception("لا يوجد لديك صلاحية للمتابعة");
            }

            $tender_id = $this->_request->tender_id;
            $tender_order_id = $this->_request->tender_order_id;
            $tender_company_id = $this->_request->tender_company_id;
            $send_sms = $this->_request->send_sms;

            $tenderOrderBean = $this->_tenderCore->getTenderOrderBasic($tender_order_id, 0);
            $tenderCompanyFilter = [['key' => 'id', 'val' => $tender_company_id]];
            $tenderCompanyBean = $this->_tenderCompanyCore->searchTenderCompany($tenderCompanyFilter, 1, 0, 0)->data[0];

            // create waybill order bean
            $waybillOrderBean = new stdClass();
            $waybillOrderBean->tender_order_id = $tender_order_id;
            $waybillOrderBean->cargo_id = $tenderOrderBean->cargo[0];
            $waybillOrderBean->queue_id = null;
            $waybillOrderBean->truck_owner_id = null;
            $waybillOrderBean->create_date = DBConnection::getSystemDate();
            $waybillOrderBean->status = "NEW";
            // Fill tc_details in waybill order
            $tc_details = new stdClass();
            $tc_details->tn = null;
            $tc_details->q_id = null;
            $tc_details->trn = null;
            $tc_details->truck_id = null;
            $tc_details->driver_nn = null;
            $tc_details->tender_id = $tenderOrderBean->tender_id;
            $tc_details->contact_nn = null;
            $tc_details->queue_name = null;
            $tc_details->driver_name = null;
            $tc_details->tender_name = $tenderOrderBean->tender_name;
            $tc_details->contact_name = $tenderCompanyBean->name;
            $tc_details->driver_phone = null;
            $tc_details->contact_phone = null;
            $tc_details->tc_company_id = $tenderCompanyBean->trucking_company_id;
            $tc_details->tender_company_id = $tender_company_id;
            $tc_details->truck_owner_id = null;
            $tc_details->truck_owner_nn = null;
            $tc_details->truck_owner_name = null;
            $tc_details->truck_owner_phone = null;
            $tc_details->trucking_company_id = $tenderCompanyBean->trucking_company_id;
            $tc_details->trucking_company_name = $tenderCompanyBean->name;
            $tc_details->extra_note = $tenderOrderBean->order_notes->extra_note;
            $waybillOrderBean->tc_details = $tc_details;
            $waybillOrderResult = DBConnection::insertDB("waybill_order", $waybillOrderBean, 0);

            // insert quota
            $cargo_id = $tenderOrderBean->cargo[0];
            $this->_tenderCore->saveTenderOrderCompany($tender_order_id, $cargo_id, $tender_company_id, 1, 0);

            // inform company
            if ($send_sms) {
                $cargoName = $this->_cargoCore->getCargoBasic($tenderOrderBean->cargo[0], 0)->name;
                $title =  "حصة $cargoName للشركة";
                $message =  "تم تفعيل حصة $cargoName للشركة , الرجاء تثبيت المعلومات";
                $this->_truckingCompanyCore->informComapanyEmployee($tenderCompanyBean->trucking_company_id, $title, $message);
            }

            // inform supervisor
            $socialCore = new SocialCore();
            $wall_message = "تم انشاء أمر حركة يدوي من قبل الموظف " . $_SESSION['u_id'] . " لشركة " . $tenderCompanyBean->name . " على مشروع " . $tenderOrderBean->tender_name;
            $notification_message = $wall_message;
            $supervisor_id = 475;
            $socialCore->informSupervisor('انشاء أمر حركة يدوي', $wall_message, $notification_message, $supervisor_id);

            //return Success response
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "WAYBILL_ORDER.SUCCESS_OPERATION";
            parent::response($Result, 200);

            DBConnection::commitTransaction();
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }





    // --------------------------------------------------------------------------------------------- //
    // --------------- Process waybill order as call back of waybill order poll -------------------- //
    // --------------------------------------------------------------------------------------------- //
    public function processWaybillOrder()
    {

        $waybill_order_id = $this->_request->waybill_order_id;
        $answers = $this->_request->answers;

        $user_answer = "";
        foreach ($answers as $ans) {
            if ($ans->question_id == 0) {
                $user_answer = $ans->value;
            }
        }
        // accept waybill order
        if ($user_answer == 1) {
            // accept the waybill order
            $this->_waybillOrderCore->acceptWaybillOrder($waybill_order_id, $_SESSION['user_id']);

            $addNoteCore = new Add_notes_core();
            $addNoteCore->addNotes('waybill_order', $waybill_order_id, 0, 'قبول أمر الحركة عن طريق الاجابة على الاستبيان');

            // get extra info for waybill order
            $waybillOrderFilter = [['key' => 'id', 'val' => $waybill_order_id]];
            $waybillOrderQry = $this->_waybillOrderCore->searchWaybillOrder($waybillOrderFilter, 1, 0, $_SESSION['user_id']);
            $waybillOrderInfo = $waybillOrderQry->data[0];

            //cancel ticket opened for waybill_order
            if ($waybillOrderInfo->tc_details->ticket_id) {
                //cancel ticket
                $this->_customerCare->changeStatus($waybillOrderInfo->tc_details->ticket_id, 'CANCELED', $user_answer);
            }

            // write a post on user wall
            $user_id = $this->_waybillOrderCore->getWaybillOrderDefaultContact($waybill_order_id);
            $title = "قبول أمر الحركة";
            $msg = "تم قبول أمر الحركة للشاحنة :$waybillOrderInfo->tn+$waybillOrderInfo->trn - الحمل: $waybillOrderInfo->cargo_name - الشركة: $waybillOrderInfo->trucking_company_name";
            $this->_socialCore->createWallEntry($user_id, $title, $msg);

            // Save the trn
            // $trn = $answers[1]->value;
            // $waybillOrderBean = $this->_waybillOrderCore->getWaybillOrderBasic($waybill_order_id , $_SESSION['user_id']);
            // $tc_details = $waybillOrderBean->tc_details;
            // $tc_details->trn = $trn;

            // save the driver
            // $driverObj = new stdClass();
            // $driverObj->phone_nn = $answers[2]->value;
            // $driverResult = $this->_driverCore->driverAutoComplete($driverObj , 0);
            // $tc_details->driver_name = $driverResult->name;
            // $tc_details->driver_nn = $driverResult->nn;
            // $tc_details->driver_phone = $driverResult->phone;

            // save in database
            // $waybillOrderBean->tc_details = $tc_details;
            // $this->_waybillOrderCore->updateWaybillOrder($waybillOrderBean,$waybill_order_id,0);

            //return Success response
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "WAYBILL_ORDER.SUCCESS_OPERATION";
            $Result['ID'] = $waybill_order_id;
            parent::response($Result, 200);
        } elseif ($user_answer == 0) {

            // send cancel alarams to mobile APP
            $this->_waybillOrderCore->cancelWaybillOrderNotification($waybill_order_id);

            // get available delay days            
            $waybillOrderBean = $this->_waybillOrderCore->getWaybillOrderBasic($waybill_order_id, 0);
            $tender_id = $waybillOrderBean->tc_details->tender_id;
            $q_id = $waybillOrderBean->tc_details->q_id;
            $man = $this->_tenderCore->getTenderManifest($tender_id, 0);
            // get delay rules for the selected queue
            foreach ($man['queues'] as $queue) {
                if ($queue['id'] == $q_id) {
                    $delayRules = $queue['delay_rules'];
                }
            }
            if ($delayRules['method'] == 'none') {
                $this->_waybillOrderCore->rejectWaybillOrder($waybill_order_id, -1, "", $_SESSION['user_id']);
                $delay_message = "تمت اعادة الشاحنة لأخر الدور";
            } else {
                // reject the waybill order and delay 1 day
                $this->_waybillOrderCore->rejectWaybillOrder($waybill_order_id, 1, "", $_SESSION['user_id']);
                $delay_message = "تم تأجيل الدور لمدة يوم واحد";
            }


            // get extra info for waybill order
            $waybillOrderFilter = [['key' => 'id', 'val' => $waybill_order_id]];
            $waybillOrderQry = $this->_waybillOrderCore->searchWaybillOrder($waybillOrderFilter, 1, 0, $_SESSION['user_id']);
            $waybillOrderInfo = $waybillOrderQry->data[0];

            // write a post on user wall
            $user_id = $this->_waybillOrderCore->getWaybillOrderDefaultContact($waybill_order_id);
            $title = "رفض أمر الحركة";
            $msg = "تم رفض أمر الحركة للشاحنة :$waybillOrderInfo->tn+$waybillOrderInfo->trn - الحمل: $waybillOrderInfo->cargo_name ";
            $this->_socialCore->createWallEntry($user_id, $title, $msg);

            //return Success response
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "WAYBILL_ORDER.SUCCESS_OPERATION";
            $Result['ID'] = $waybill_order_id;
            parent::response($Result, 200);
        } else {
            throw new Exception("Error Processing Request , invalid user answer : " . $user_answer);
        }
    }



    // --------------------------------------------------------------------------------------------- //
    // --------------- Process waybill order as call back of waybill order poll -------------------- //
    // --------------------------------------------------------------------------------------------- //
    public function processWaybillOrder_fuel()
    {

        $waybill_order_id = $this->_request->waybill_order_id;
        $answers = $this->_request->answers;
        $extra_action =  $this->_request->extra_action;
        $waybillOrderBean = $this->_waybillOrderCore->getWaybillOrderBasic($waybill_order_id, 0);

        // only work on NEW , WAITING waybill orders
        if (in_array($waybillOrderBean->status, ['NEW', 'WAITING'])) {

            $user_answer = "";
            foreach ($answers as $ans) {
                if ($ans->question_id == 0) {
                    $user_answer = $ans->value;
                }
            }

            if ($user_answer == 1) {
                // accept the waybill order
                $this->_waybillOrderCore->acceptWaybillOrder($waybill_order_id, $_SESSION['user_id']);

                $addNoteCore = new Add_notes_core();
                $addNoteCore->addNotes('waybill_order', $waybill_order_id, 0, 'قبول أمر الحركة عن طريق الاجابة على الاستبيان');

                // get extra info for waybill order
                $waybillOrderFilter = [['key' => 'id', 'val' => $waybill_order_id]];
                $waybillOrderQry = $this->_waybillOrderCore->searchWaybillOrder($waybillOrderFilter, 1, 0, $_SESSION['user_id']);
                $waybillOrderInfo = $waybillOrderQry->data[0];

                //cancel ticket opened for waybill_order
                if ($waybillOrderInfo->tc_details->ticket_id) {
                    //cancel ticket
                    $this->_customerCare->changeStatus($waybillOrderInfo->tc_details->ticket_id, 'CANCELED', $user_answer);
                }

                // write a post on user wall
                $user_id = $this->_waybillOrderCore->getWaybillOrderDefaultContact($waybill_order_id);
                $title = "قبول أمر الحركة";
                $msg = "تم قبول أمر الحركة للشاحنة :$waybillOrderInfo->tn+$waybillOrderInfo->trn - الحمل: $waybillOrderInfo->cargo_name - الشركة: $waybillOrderInfo->trucking_company_name";
                $this->_socialCore->createWallEntry($user_id, $title, $msg);

                //return Success response
                $Result['ERRORCODE'] = "0";
                $Result['MESSAGE'] = "WAYBILL_ORDER.SUCCESS_OPERATION";
                $Result['ID'] = $waybill_order_id;
                parent::response($Result, 200);
            } elseif ($user_answer == 0) {

                // send cancel alarams to mobile APP
                $this->_waybillOrderCore->cancelWaybillOrderNotification($waybill_order_id);

                // get available delay days            
                $tender_id = $waybillOrderBean->tc_details->tender_id;
                $q_id = $waybillOrderBean->tc_details->q_id;

                $this->_waybillOrderCore->rejectWaybillOrder($waybill_order_id, -1, "", $_SESSION['user_id']);

                // get extra info for waybill order
                $waybillOrderFilter = [['key' => 'id', 'val' => $waybill_order_id]];
                $waybillOrderQry = $this->_waybillOrderCore->searchWaybillOrder($waybillOrderFilter, 1, 0, $_SESSION['user_id']);
                $waybillOrderInfo = $waybillOrderQry->data[0];

                // write a post on user wall
                $user_id = $this->_waybillOrderCore->getWaybillOrderDefaultContact($waybill_order_id);
                $title = "رفض أمر الحركة";
                $msg = "تم رفض أمر الحركة للشاحنة :$waybillOrderInfo->tn+$waybillOrderInfo->trn - الحمل: $waybillOrderInfo->cargo_name - تمت اعادة الشاحنة لأخر الدور";
                $this->_socialCore->createWallEntry($user_id, $title, $msg);

                // in case the truck has PENDING queue on tender 11 , add note to the message
                $queueSearchFilter = [
                    ['key' => 'tn', 'val' => $waybillOrderInfo->tn],
                    ['key' => 'tender_id', 'val' => 11],
                    ['key' => 'status', 'val' => 'PENDING']
                ];
                $queueTruckResult = $this->_queueCore->searchQueue($queueSearchFilter, 1, 0, 0);

                if ($queueTruckResult->found_rows > 0) {
                    // create new ticket to revoke the queue of crude oil
                    $ticket = new stdClass();
                    $ticket->title = "حذف دور";
                    $ticket->senderName = "مدارج للخدمات اللوجستية";
                    $ticket->type_code = "REVOKE_QUEUE";
                    $ticket->priority = 3;
                    $ticket->company_id = 266770;
                    $ticket->tn = $waybillOrderBean->tc_details->tn;
                    $ticket->trn = $waybillOrderBean->tc_details->trn;
                    $ticket->body = [
                        "tn" => $waybillOrderBean->tc_details->tn,
                        "trn" => $waybillOrderBean->tc_details->trn,
                        "type_code" => "REVOKE_QUEUE",
                        "tender_id" => $waybillOrderBean->tc_details->tender_id,
                        "q_id" => $waybillOrderBean->tc_details->q_id,
                    ];
                    $this->_customerCare->createTicket($ticket);
                }

                //return Success response
                $Result['ERRORCODE'] = "0";
                $Result['MESSAGE'] = "WAYBILL_ORDER.SUCCESS_OPERATION";
                $Result['ID'] = $waybill_order_id;
                parent::response($Result, 200);
            } else {
                throw new Exception("Error Processing Request , invalid user answer : " . $user_answer);
            }
        }
    }




    // ---------------------------------------------------------------------------------- //
    // ------------------ Push certain waybill order into call center ------------------- //
    // ---------------------------------------------------------------------------------- //
    public function pushToCallCenter()
    {

        $waybill_order_id = $this->_request->waybill_order_id;
        $force_manual_mode = $this->_request->force_manual_mode;
        if (!$force_manual_mode) {
            $force_manual_mode = false;
        }
        if ($force_manual_mode == "0" || $force_manual_mode == 0) {
            $force_manual_mode = false;
        }

        $this->_tenderCore->createCallTicket($waybill_order_id, $force_manual_mode);

        //return Success response
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "WAYBILL_ORDER.SUCCESS_OPERATION";
        parent::response($Result, 200);
    }


    // -------------------------------------------------------------------------------------------------------------- //
    // --------------- Search for truck trip by looking for approved waybill_order or New Waybill ------------------- //
    // -------------------------------------------------------------------------------------------------------------- //
    public function searchTruckTripByTerminal()
    {

        // get user params
        $tn = $this->_request->tn;
        $multi_route = true;
        try {

            // search for new waybill
            $filter = [
                ['key' => 'tn', 'val' => $tn]
            ];
            $waybillSearchResult = $this->_waybillCore->searchWaybills($filter, 1, 0,  $_SESSION['user_id']);

            if ($waybillSearchResult->found_rows > 0) {
                $result = $waybillSearchResult->data[0];
                $doc = json_decode($result->document);
                $tender_order_id = $result->order_id;
                $cargo_id = $doc->cargo[0]->cargo_id;

                $getDriverDocument = $this->_driverCore->getDriverDocument($result->driver_id);

                /// clean the object
                $output = new stdClass();
                $output->type = 'WAYBILL';
                $output->waybill_id = $result->id;
                $output->tn = $result->tn;
                $output->truck_id = $result->truck_id;
                $output->trn = $doc->carrier[0]->trailer->tn;
                $output->driver_nn = $doc->carrier[0]->driver->nn;
                $output->driver_name = $doc->carrier[0]->driver->name;
                $output->driver_phone = $doc->carrier[0]->driver->phone;
                $output->driver_document = $getDriverDocument;
                $output->tender_id = $result->tender_id;
                if ($doc->carrier[0]->trailer->minor_tt == 201)
                    $output->trailer_type = 'قلاب';
                else if ($doc->carrier[0]->trailer->minor_tt == 203)
                    $output->trailer_type = 'تريلا';
                else
                    $output->trailer_type = '-';
            }

            // in case no waybill is fonud try to look for waybill order
            else {
                // search for apporved waybill order for the truck
                $filter = [
                    ['key' => 'tn', 'val' => $tn],
                    ['key' => 'status', 'val' => 'APPROVED']
                ];
                $waybillOrderSearchResult = $this->_waybillOrderCore->searchWaybillOrder($filter, 1, 0,  $_SESSION['user_id']);
                if ($waybillOrderSearchResult->found_rows > 0) {
                    $result = $waybillOrderSearchResult->data[0];
                    $getDriverDocument = $this->_driverCore->getDriverDocument($result->driver_id);
                    $tender_order_id = $result->tender_order_id;
                    $cargo_id = $result->cargo_id;
                    // clean the object
                    $output = new stdClass();
                    $output->type = 'WAYBILL_ORDER';
                    $output->waybill_order_id = $result->id;
                    $output->tn = $result->tn;
                    $output->truck_id = $result->truck_id;
                    $output->trn = $result->trn;
                    $output->driver_id = $result->driver_id;
                    $output->driver_nn = $result->driver_nn;
                    $output->driver_name = $result->driver_name;
                    $output->driver_phone = $result->driver_phone;
                    $output->driver_document = $getDriverDocument;
                    $output->tender_id = $result->tender_id;

                    // get trailer type
                    $queueSearchFilter = [['key' => 'id', 'val' => $result->queue_id]];
                    $queueInfo = $this->_queueCore->searchQueue($queueSearchFilter, 1, 0, 0)->data[0];

                    if ($queueInfo->trail_minor_tt == 201)
                        $output->trailer_type = 'قلاب';
                    else if ($queueInfo->trail_minor_tt == 203)
                        $output->trailer_type = 'تريلا';
                    else if ($queueInfo->trail_minor_tt == 303)
                        $output->trailer_type = 'صهريج';
                    else
                        $output->trailer_type = '-';
                }
            }


            // in case no waybill order or waybill is found throw exception
            if (!$output) {
                throw new Exception("رقم الشاحنة غير صحيح");
            }

            //  get cargo and destination
            $cargoBean = $this->_cargoCore->getCargoBasic($cargo_id, 0);
            $output->cargo_name = $cargoBean->name;
            $output->cargo_id = $cargo_id;

            if ($cargoBean->tender_id == 13) {
                $routes = [];
            } else {
                $truck_id = $output->truck_id;
                $routes = $this->_truckRoutingCore->getHighestTruckRoute($tender_order_id, $truck_id, $multi_route, 0);
            }

            $output->routes = [];

            foreach ($routes as $route) {
                $temp = new stdClass();
                if ($route->destination_id) {
                    $temp->destination_name = getLocationName($route->destination_id);
                    $temp->destination_id = $route->destination_id;
                } else {
                    $temp->destination_name = "حسب وجهة المستند";
                    $temp->destination_id = null;
                }

                $temp->id = $route->id;
                array_push($output->routes, $temp);
            }

            //return Success response
            parent::response($output, 200);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------------------------------------- //
    // -------------------- Close Waybill order by terminal and change the trn and driver  ------------------- //
    // ------------------------------------------------------------------------------------------------------- //
    public function closeWaybillOrderByTerminal()
    {

        // get user params
        $waybill_order_id = $this->_request->waybill_order_id;
        $driver_nn = $this->_request->driver_nn;
        $trn = $this->_request->trn;
        $first_trip_ct = $this->_request->first_trip_ct;
        $first_trip_destination_id = $this->_request->first_trip_destination_id;
        $first_trip_type = $this->_request->first_trip_type;
        $entry_location = $this->_request->entry_location;
        $truck_route_id = $this->_request->truck_route_id;
        // validate user params
        if (!$waybill_order_id) {
            throw new Exception("waybill_order_id is required");
        }
        if (!$driver_nn) {
            throw new Exception("الرجاء ادخال الرقم الوطني");
        }
        if (!$trn) {
            throw new Exception("الرجاء ادخال رقم المقطورة");
        }
        //if(!$truck_route_id){throw new Exception("الرجاء تحديد الوجهة"); }

        // get waybill order bean
        $waybillOrderBean = $this->_waybillOrderCore->getWaybillOrderBasic($waybill_order_id, 0);
        if ($waybillOrderBean->status != 'APPROVED') {
            throw new Exception("لا يوجد أمر حركة موافق عليه للشاحنة");
        }
        $tc_details = $waybillOrderBean->tc_details;

        // -------- Phase 1 --------------- //
        // update driver info
        if ($driver_nn && $driver_nn != "null") {

            // validate if the driver is already registered on the tender
            $tenderDriverFilter = [
                ['key' => 'tender_id', 'val' => $tc_details->tender_id],
                ['key' => 'nn', 'val' => $driver_nn],
                ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']
            ];
            $tenderDriverResult = $this->_tenderDriverCore->searchTenderDriver($tenderDriverFilter, 1, 0, 0);

            if ($tenderDriverResult->found_rows == 0) {

                // get the tenderBean
                $man = $this->_tenderCore->getTenderManifest($tc_details->tender_id, 0);
                // if adding driver to tender is set to be auto , add the driver
                if ($man['tender_driver']['allow_add_by_system'] == true) {

                    $driverFilter = [['key' => 'nn', 'val' => $driver_nn], ['key' => 'status', 'val' => 'ACTIVE']];
                    $driver_qry = $this->_driverCore->searchDriver($driverFilter, 1, 0, 0);
                    $driver_id = $driver_qry->data[0]->id;
                    if (!$driver_id) {
                        throw new Exception("لا تستطيع المتابعة، معلومات السائق غير صحيحة");
                    }
                    $tender_driver_id = $this->_tenderDriverCore->create($driver_id, $waybillOrderBean->tc_details->tender_id, 0);
                    $this->_tenderDriverCore->activateTenderDriver($tender_driver_id, 0);

                    $tenderDriverFilter = [
                        ['key' => 'tender_id', 'val' => $waybillOrderBean->tc_details->tender_id],
                        ['key' => 'driver_id', 'val' => $driver_id],
                        ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']
                    ];
                    $tenderDriverResult = $this->_tenderDriverCore->searchTenderDriver($tenderDriverFilter, 1, 0, 0);
                } else {
                    // else throw error
                    throw new Exception("السائق لا يملك عقد تشغيل فعال على المشروع");
                }
            } else {
                // make sure the driver is not black listed
                if ($tenderDriverResult->data[0]->status == "PENDING") {
                    throw new Exception("لا تستطيع المتابعة ، عقد تشغيل السائق موقوف على المشروع");
                }
            }

            // update driver part
            $driverFilter = [
                ['key' => 'nn', 'val' => $driver_nn],
                ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']
            ];
            $driverResult = $this->_driverCore->searchDriver($driverFilter, 1, 0, 0);
            $tc_details->driver_id = $driverResult->data[0]->id;
            $tc_details->driver_nn = $driverResult->data[0]->nn;
            $tc_details->driver_name = $driverResult->data[0]->name;
            $tc_details->driver_phone = $driverResult->data[0]->phone;
        }

        // -------- phase 2-----------
        // update trn
        $trnSearchFilter = [
            ['key' => 'tn', 'val' => $trn],
            ['key' => 'cat', 'val' => ['TRAIL', 'TRAIL-HALF'], 'op' => "in"],
            ['key' => 'status', 'val' => 'ACTIVE']
        ];
        $trailerResult = $this->_truckCore->searchTrucks($trnSearchFilter, 1, 0, 0);
        $trailerBean = $trailerResult->data[0];

        if (!$trailerBean)
            throw new Exception("لا تستطيع المتابعة ، رقم المقطورة غير صحيح");

        $tc_details->trn = $trailerBean->tn;
        $tc_details->trailer_id = $trailerBean->id;

        // phase 3: create waybill , close WO , change destination and cargo then change waybill to approved
        try {


            // update in database
            $waybillOrderBean->tc_details = $tc_details;
            $truck_id = $waybillOrderBean->tc_details->truck_id;

            // close waybill order and create waybill
            $result = $this->_waybillOrderCore->closeWaybillOrder($waybill_order_id, $_SESSION['user_id']);

            // get waybill bean
            $waybillBean = $this->_waybillCore->getWaybillBasic($result['waybill_id'], $_SESSION['user_id']);

            // update trn and driver
            $waybillBean->trailer_id = $tc_details->trailer_id;
            $waybillBean->driver_id = $tc_details->driver_id;
            // update first trip info
            $waybillJson = $waybillBean->document;
            $waybillJson->first_trip = new stdClass();
            $waybillJson->first_trip->ct = $first_trip_ct;
            $waybillJson->first_trip->destination = $first_trip_destination_id;
            $waybillJson->first_trip->type = $first_trip_type;
            $waybillJson->first_trip->entry_location = $entry_location;
            $waybillBean->document = $waybillJson;
            $this->_waybillCore->updateWaybill($waybillBean, $result['waybill_id'], $_SESSION['user_id']);

            // change the destination of the waybill
            if ($truck_route_id) {
                $truck_route = $this->_truckRoutingCore->getTruckRouteBasic($waybillBean->order_id, $truck_route_id, 0);
                if ($truck_route->destination_id) {
                    $this->_waybillCore->changeRoute($result['waybill_id'], $truck_route->destination_id, $_SESSION['user_id']);
                }
                // write truck route id in waybill document
                $waybillBean = $this->_waybillCore->getWaybillBasic($result['waybill_id'], $_SESSION['user_id']);
                $integeration_details = $waybillBean->document->integeration_details;
                $u_id = DBConnection::getUserIdFromSession($_SESSION['user_id']);
                if (!$integeration_details) {
                    $integeration_details = new stdClass();
                    $integeration_details->truck_route = new stdClass();
                    $integeration_details->truck_route->id = $truck_route_id;
                    $integeration_details->truck_route->done_by = $u_id;
                    $integeration_details->truck_route->update_date = date("Y-m-d") . " " . date("h:i:s");
                    $waybillBean->document->integeration_details = $integeration_details;
                } else {
                    $waybillBean->document->integeration_details->truck_route = new stdClass();
                    $waybillBean->document->integeration_details->truck_route->id = $truck_route_id;
                    $waybillBean->document->integeration_details->truck_route->done_by = $u_id;
                    $waybillBean->document->integeration_details->truck_route->update_date = date("Y-m-d") . " " . date("h:i:s");
                }
                // update waybill
                $this->_waybillCore->updateWaybill($waybillBean, $result['waybill_id'], 0);

                //close comleted truck routes
                try {
                    $this->_truckRoutingCore->closeCompletedTruckRoute($waybillOrderBean->tender_order_id, 0);
                } catch (Exception $e) {
                }
            }

            // change status of waybill to approved
            $waybillBean = $this->_waybillCore->getWaybillBasic($result['waybill_id'], $_SESSION['user_id']);
            $this->_waybillCore->changeStatus($result['waybill_id'], "APPROVED", $_SESSION['user_id']);
            // activate the waybill
            $waybillBean = $this->_waybillCore->getWaybillBasic($result['waybill_id'], $_SESSION['user_id']);
            $this->_waybillCore->changeStatus($result['waybill_id'], 'ACTIVE', $_SESSION['user_id']);

            //add truck to Itihad Queue
            if ($tc_details->tender_id == 3) {

                $itihad_queue_for_vessels = 2;
                $this->_queueCore->pushTruckToYard(
                    $waybillBean->tender_id,
                    $itihad_queue_for_vessels,
                    $waybillBean->truck_id,
                    $waybillBean->trailer_id,
                    $waybillBean->driver_id,
                    $waybillBean->id
                );
            }



            //return Success response
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "تمت العملية بنجاح - " . $result['MESSAGE'];
            $Result['waybill_order_id'] = $result['waybill_order_id'];
            $Result['waybill_id'] =  $result['waybill_id'];
            $Result['wn'] =  $result['wn'];
            parent::response($Result, 200);
        } catch (Exception $e) {

            throw new Exception($e->getMessage());
        }
    }


    // --------------------------------------------------------------------------------------- //
    // -------------------- Send Bulk waybill orders to call center system ------------------- //
    // --------------------------------------------------------------------------------------- //
    public function sendBulkToCallCenter()
    {

        $waybill_order_ids = $this->_request->waybill_order_ids;
        if (gettype($waybill_order_ids) == 'string') {
            $waybill_order_ids = json_decode($waybill_order_ids);
        }

        $counter = 0;
        foreach ($waybill_order_ids as $waybill_order_id) {
            $force_manual_mode = true;
            $result = $this->_tenderCore->createCallTicket($waybill_order_id, $force_manual_mode);

            if ($result['id']) {
                $counter++;
            }
        }

        //return Success response
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "تم تحويل $counter أوامر حركة للإتصال الالي";
        parent::response($Result, 200);
    }


    // ------------------------------------------------------------------------------------------------ //
    // -------------------undo cancleation of waybillOrder -------------------------------------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function undoCancelWaybillOrder()
    {

        try {
            $id = $this->_request->id;
            $waybillOrderBean = $this->_waybillOrderCore->getWaybillOrder($id, $_SESSION['user_id']);
            $waybillOrderBean = json_decode($waybillOrderBean);

            // if it is WO for indivuals, nope
            if ($waybillOrderBean->queue_id) {
                throw new Exception('لا يمكن القيام بهذه العملية لأوامر الحركة أفراد');
            }

            if ($waybillOrderBean->activity) {
                foreach ($waybillOrderBean->activity as $activity) {
                    if ($activity->action_code == 'CHANGE_STATUS' && ($activity->object_status_code == 'NEW' || $activity->object_status_code == 'APPROVED') && $activity->object_new_status_code == 'CLOSED') {

                        $revoke_time = strtotime($activity->activity_date);
                        $now = strtotime(DBConnection::getSystemDate());
                        // if the waybill canceled before more than two hours
                        if ($now - $revoke_time > 7200) {

                            $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
                            $isOperationManager = false;
                            foreach ($userRolesArray as $role) {
                                if ($role == 'OPERATION_MANAGER') {
                                    $isOperationManager = true;
                                }
                            }
                            if (!$isOperationManager) {
                                throw new Exception('لا يمكن القيام بهذه العملية بعد مضي أكثر من ساعتين على عملية احتساب العجز');
                            }
                        }

                        // active waybill and change status to NEW
                        $this->_waybillOrderCore->changeStatus($id, 'NEW', $_SESSION['user_id']);

                        $Result['MESSAGE'] = " تم إعادة تفعيل امر الحركة رقم $id";
                        $Result['CODE'] = "تم إعادة تفعيل امر الحركة رقم $id";
                        parent::response($Result);
                        die;
                    }
                }
            }

            throw new Exception("لم يتمكن النظام من اعادة تفعيل امر الحركة");
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }



    // ------------------------------------------------------------------------------------------------ //
    // ------------------- Search for waybill_orders to be sent to tickiting system ------------------- //
    // ------------------------------------------------------------------------------------------------ //
    public function searchWaybillOrderForSendToTicketing()
    {

        // search for new WO wich is for indivisuals
        $filter = [
            ['key' => 'status', 'val' => 'NEW'],
            ['key' => 'queue_id', 'op' => 'is not null']
        ];
        $waybillOrderSearchResult = $this->_waybillOrderCore->searchWaybillOrder($filter, 1000, 0,  $_SESSION['user_id']);


        $result = new stdClass();
        $result->data = [];
        $currentTime = DBConnection::getSystemDate();
        foreach ($waybillOrderSearchResult->data as &$waybillOrder) {
            try {
                $waybillOrder->order_notes = json_decode($waybillOrder->order_notes)->accept_waybill_order_sms;

                $timeDiff = 900000 - difference($waybillOrder->create_date, $currentTime);
                if ($timeDiff < 0) {
                    $result->data[]  = $waybillOrder;
                }
            } catch (Exception $e) {
                $waybillOrder->order_notes = "";
            }
        }

        $result->found_rows = sizeof($result->data);

        //return Success response
        parent::response($result);
    }
}

new Waybill_order_interface();
