<?php
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../../core/queue/queue_core.php");
require_once(dirname(__FILE__) . "/../notes/add_notes_core.php");
require_once(dirname(__FILE__) . "/../../core/waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../../core/cargo/cargo_core.php");
require_once(dirname(__FILE__) . "/../../core/tender/tender_core.php");
require_once(dirname(__FILE__) . "/../../core/user/user_core.php");
require_once(dirname(__FILE__) . "/../../core/notification/notification_core.php");
require_once(dirname(__FILE__) . "/../../core/trx/trx_core.php");
require_once(dirname(__FILE__) . "/../user/user_core.php");
require_once(dirname(__FILE__) . '/../truck_contract/truck_contract_core.php');
require_once(dirname(__FILE__) . "/../taskQueues/taskQueues_core.php");
require_once(dirname(__FILE__) . "/../../core/social/social_core.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/poll.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/customer_care.php");

class WaybillOrderCore
{

    public function __construct()
    {
        DBConnection::getInstance();
        //MongodbConnection::getInstance();

        $this->_queueCore = new QueueCore();
        $this->_addNoteCore = new Add_notes_core();
        $this->_waybillCore = new WaybillCore();
        $this->_cargoCore = new cargoCore();
        $this->_tenderCore = new TenderCore();
        $this->_userCore = new UserCore();
    }

    // ---------------------------------------------------------------------- //
    // --------------------- get info for a certian waybill order ----------- //
    // ---------------------------------------------------------------------- //
    public function getWaybillOrder($id, $user_id)
    {

        $waybillOrderInfo = DBConnection::getObjectBean("waybill_order", $id, $user_id);
        return $waybillOrderInfo;
    }

    // ------------------------------------------------------------------------------- //
    // --------------------- get info for a waybill order whitout activity ----------- //
    // ------------------------------------------------------------------------------- //
    public function getWaybillOrderBasic($id, $user_id)
    {

        $waybillOrderInfo = DBConnection::getBasicObjectBean("waybill_order", $id, $user_id);
        return $waybillOrderInfo;
    }

    // ------------------------------------------------------------------------------- //
    // -------------------search for waybill order using any search filter ----------- //
    // ------------------------------------------------------------------------------- //
    public function searchWaybillOrder($searchFilter, $limit, $offset, $user_id)
    {

        $waybillOrderResult = DBConnection::searchDB("waybill_order", $searchFilter, $limit, $offset, $user_id);
        return $waybillOrderResult;
    }


    // -------------------------------------------------------------- //
    // -------------------create waybill order in database----------- //
    // -------------------------------------------------------------- //
    public function createWaybillOrder($tender_order_id, $cargo_id, $truck_owner_id, $queue_id, $user_id)
    {


        // prepare needed objects
        $queueSearchFilter = [['key' => 'id', 'val' => $queue_id]];
        $queueBean = $this->_queueCore->searchQueue($queueSearchFilter, 1, 0, $user_id)->data[0];
        $tenderOrderBean = $this->_tenderCore->getTenderOrderBasic($tender_order_id, 0);
        $tenderBean = $this->_tenderCore->getTenderBasic($tenderOrderBean->tender_id, 0);

        // prepare waybillOrderBean
        $waybillOrderBean = new stdClass();
        $waybillOrderBean->tender_order_id = $tender_order_id;
        $waybillOrderBean->cargo_id = $cargo_id;
        $waybillOrderBean->queue_id = $queue_id;
        $waybillOrderBean->truck_owner_id = $truck_owner_id;
        $waybillOrderBean->create_date = DBConnection::getSystemDate();
        $waybillOrderBean->status = "NEW";

        // Fill tc_details in waybill order
        $tc_details = new stdClass();
        $tc_details->tn = $queueBean->tn;
        $tc_details->q_id = $queueBean->q_id;
        $tc_details->trn = $queueBean->trn;
        $tc_details->truck_id = $queueBean->truck_id;
        $tc_details->driver_nn = $queueBean->driver_nn;
        $tc_details->tender_id = $queueBean->tender_id;
        $tc_details->contact_nn = $queueBean->contact_nn;
        $tc_details->queue_name = $queueBean->queue_name;
        $tc_details->driver_name = $queueBean->driver_name;
        $tc_details->tender_name = $queueBean->tender_name;

        $contact_name = str_replace("\\t", "", $queueBean->contact_name);
        $contact_name = trim(preg_replace('/\t+/', '',  $contact_name));
        $contact_name = str_replace('"', '', $contact_name);
        $tc_details->contact_name = $contact_name;

        $tc_details->driver_phone = $queueBean->driver_phone;
        $tc_details->contact_phone = $queueBean->contact_phone;
        $tc_details->tc_company_id = $queueBean->trucking_company_id;
        $tc_details->truck_owner_id = $queueBean->truck_owner_id;
        $tc_details->truck_owner_nn = $queueBean->truck_owner_nn;

        $truck_owner_name = str_replace("\\t", "", $queueBean->truck_owner_name);
        $truck_owner_name = trim(preg_replace('/\t+/', '',  $truck_owner_name));
        $truck_owner_name = str_replace('"', '', $truck_owner_name);
        $tc_details->truck_owner_name = $truck_owner_name;

        $tc_details->truck_owner_phone = $queueBean->truck_owner_phone;
        $tc_details->trucking_company_id = $queueBean->trucking_company_id;
        $tc_details->trucking_company_name = str_replace('"', '', $queueBean->trucking_company_name);
        try {
            // if($tenderOrderBean->order_notes && $tenderOrderBean->order_notes->extra_note){
            //     $tc_details->extra_note = $tenderOrderBean->order_notes->extra_note;
            // }else{
            //     $tc_details->extra_note = "";
            // }
        } catch (Exception $e) {
            $tc_details->extra_note = "";
        }

        $waybillOrderBean->tc_details = $tc_details;

        //$this->validateForCreate($waybillOrderBean, $user_id);
        $waybillOrderResult = DBConnection::insertDB("waybill_order", $waybillOrderBean, $user_id);

        // change status of tender order to PENDING when the first waybill order is created
        if ($tenderOrderBean->status != 'PENDING') {
            $this->_tenderCore->changeOrderStatus($tender_order_id, 'PENDING', 0);
        }

        //change the status of the cargo and its tender order when the system starts the cargo asssign process
        $this->_cargoCore->startCargoAssign($waybillOrderBean->cargo_id, $tenderBean);






        // dont hold queue if tender is 11 or 12
        // if($queueBean->tender_id != 11 && $queueBean->tender_id != 12){

        //held the other queues if the driver has more than one
        $queuesToHeldSearchFilter = [
            ['key' => 'truck_id', 'val' => $queueBean->truck_id],
            ['key' => 'status', 'val' => 'ACTIVE'],
            ['key' => 'id', 'val' => [$queue_id], 'op' => 'not in'],
        ];
        $queuesToHeld = $this->_queueCore->searchQueue($queuesToHeldSearchFilter, 1000, 0, $user_id)->data;
        // iterate and change status to HELD for each queue
        foreach ($queuesToHeld as $queue) {
            $this->_queueCore->changeStatus($queue->id, 'HELD', 0, null, null);
            $this->_queueCore->logActivity(
                $queue->id,
                "تجميد الدور",
                "تم تجميد الدور نتيجة انشاء أمر حركة على دور " . $queueBean->queue_name,
                "held_queue",
                0
            );
        }
        // }

        return $waybillOrderResult;
    }

    // --------------------------------------------------------------------------------- //
    // ------------------ Validate for create new waybill order ------------------------ //
    // --------------------------------------------------------------------------------- //
    private function validateForCreate($waybillOrderBean, $user_id)
    {

        // get the active status of the waybill order
        $activeWaybillOrderStatus = DBConnection::getActiveStatus('waybill_order');

        // validate queue record has active waybill order
        $waybillOrderFilter = [
            ['key' => 'queue_id', 'val' => $waybillOrderBean->queue_id],
            ['key' => 'status', 'val' => $activeWaybillOrderStatus, 'op' => 'in'],
        ];

        $waybill_result = $this->searchWaybillOrder($waybillOrderFilter, 1, 0, $user_id);
        if ($waybill_result->found_rows > 0) {
            throw new Exception("الشاحنة لديها أمر تحميل فعال");
        }
    }


    // -------------------------------------------------------------------------- //
    // -------------------accept waybill offer then queue ------------------------ //
    // -------------------------------------------------------------------------- //
    public function acceptWaybillOrder($waybill_order_id, $user_id)
    {

        try {
     
            // get waybillOrder Bean
            $searchFilter = [['key' => 'id', 'val' => $waybill_order_id]];
            $waybillOrderBean = $this->searchWaybillOrder($searchFilter, 1, 0, 0)->data[0];
            $waybillOrderBasicBean = $this->getWaybillOrderBasic($waybill_order_id, 0);

            DBConnection::startTransaction();
            // change waybill order to APPROVED
            $this->changeStatus($waybill_order_id, 'APPROVED', $user_id);

            // change queue status to APPROVED,CLOSED in case it exist
            if ($waybillOrderBean->queue_id) {

                // close queue in case of tender_id = 12
                $tender_id = $waybillOrderBasicBean->tc_details->tender_id;
                if ($tender_id == 12) {
                    $this->_queueCore->changeStatus($waybillOrderBean->queue_id, 'CLOSED', 0);
                } else {
                    $this->_queueCore->changeStatus($waybillOrderBean->queue_id, 'APPROVED', 0);
                }
            }

            //Approve cargo wheather it is container or cargo
            if ($waybillOrderBean->cargo_id)
                $this->_cargoCore->approveCargo($waybillOrderBean->cargo_id);


            DBConnection::commitTransaction();

            // inform user about the change
            $contact_user_id = $this->getWaybillOrderDefaultContact($waybill_order_id);
            if ($contact_user_id) {

                // send in case the enable notification is enabled on the tender
                $tenderManifestJSON = $this->_tenderCore->getTenderManifest($waybillOrderBean->tender_id, 0);
                if ($tenderManifestJSON['enableSendNotification']) {

                    // get the accept SMS message
                    $orderNotes = json_decode($waybillOrderBean->order_notes);
                    $acceptWaybillOrderSMS = $orderNotes->accept_waybill_order_sms;

                    // send notification and SMS but not for Fuel
                    if ($tender_id && $tender_id != 12) {
                        $notificationCore = new NotificationCore();
                        $payload = new stdClass();
                        $payload->type = "set_notification";
                        $payload->id = $waybill_order_id;
                        $payload->message = ' تم قبول أمر الحركة' . $acceptWaybillOrderSMS;
                        //$notificationCore->sendDataMessage($contact_user_id,$payload);

                        // send SMS
                        $tn = $waybillOrderBean->tn;
                        $SMS_message = "$tn" . "-" . "قبول أمر حركة بنجاح" . " " .  $acceptWaybillOrderSMS;
                        //$this->sendSmsToWaybillOrderInvolvedParties($waybill_order_id,$SMS_message);
                    }
                }
            }

            // close poll 
            $pollIntegration = new Poll;
            $poll_id = $waybillOrderBean->tc_detail->poll_id;
            if ($poll_id) {
                $pollIntegration->closePoll($poll_id);
            }

            //cancel ticket opened for waybill_order
            $waybillOrderBeanBasic = $this->getWaybillOrderBasic($waybill_order_id, $user_id);
            if ($waybillOrderBeanBasic->tc_details->ticket_id) {

                //cancel ticket in case it is not completed
                $customerCare = new CustomerCare();
                $ticket_id = $waybillOrderBeanBasic->tc_details->ticket_id;
                $ticketBean = $customerCare->getTicket($ticket_id);
                if ($ticketBean['status'] != 'COMPLETED') {
                    $customerCare->changeStatus($ticket_id, 'CANCELED', 0);
                }
            }
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw $e;
        }

        // attemp to close "tender-order" in case all the "waybill-orders" are approved
        try {
            $this->_tenderCore->closeTenderOrder($waybillOrderBean->tender_order_id);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw $e;
        }
    }

    // ------------------------------------------------------------------------------------------------------------------- //
    // --------------------------- Send SMS to all involved parties for a certain waybill order -------------------------- //
    // ------------------------------------------------------------------------------------------------------------------- //
    public function sendSmsToWaybillOrderInvolvedParties($waybill_order_id, $messageBody)
    {

        // get the default contact phone for waybill order
        $waybillOrderFilter = [['key' => 'id', 'val' => $waybill_order_id]];
        $waybill_result = $this->searchWaybillOrder($waybillOrderFilter, 1, 0, 0);
        $tn = $waybill_result->data[0]->tn;

        // Send SMS to default contact number
        $default_contact_phone = $waybill_result->data[0]->contact_phone;
        if ($default_contact_phone) {
            sendSMS($default_contact_phone, $messageBody);
        }
    }


    private function sendWebsocket($waybillOrderBean)
    {
        // $waybillOrderFilter = [['key'=>'id','val' => $waybillOrderBean->id]];
        // $waybill_result = $this->searchWaybillOrder($waybillOrderFilter,1,0,0) ;

        // $cargoId=$waybillOrderBean->cargo_id;
        // $cargoSubscribed= MongodbConnection::searchCollection(["object_id"=>$cargoId,'status'=>'SUBSCRIBED'],0,100);
        // foreach ($cargoSubscribed as $cargo) {
        //     $result = $this->_userCore->getUserHBObject($cargo->user_id);
        //     if ($result->UUID) {
        //         $data = new stdClass();
        //         $data->value=$waybill_result->data[0];
        //         $uuid= $result->UUID;
        //         $msg_type="CARGO_ASSIGN";
        //         $data_string = urlencode(json_encode($data,JSON_UNESCAPED_UNICODE));
        //         $url = "http://misc.minagate.com:3000/sendJson?id=".$uuid."&type=".$msg_type."&data=".$data_string."";
        //         $curl = curl_init();
        //         curl_setopt($curl, CURLOPT_URL, $url);
        //         curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        //         curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        //         $result = curl_exec($curl);
        //         curl_close($curl);
        //     }
        // }
    }

    // -------------------------------------------------------------------------- //
    // -------------------accept waybill offer then queue ------------------------ //
    // -------------------------------------------------------------------------- //
    public function rejectWaybillOrder($waybill_order_id, $duration, $remarks, $user_id)
    {

        // get waybillOrder Bean and old queue bean
        $searchFilter = [['key' => 'id', 'val' => $waybill_order_id]];
        $waybillOrderBean = $this->searchWaybillOrder($searchFilter, 1, 0, 0)->data[0];
        $waybillOrderBeanBasic = $this->getWaybillOrderBasic($waybill_order_id, 0);

        $tc_details = $waybillOrderBeanBasic->tc_details;
        $queueBean = $this->_queueCore->getQueueBasic($waybillOrderBean->queue_id, 0);
        try {

            DBConnection::startTransaction();

            // change waybill order to REVOKED
            $this->changeStatus($waybill_order_id, 'REVOKED', $user_id);

            if ($duration == -1) {
                // change queue status to INACTIVE
                if ($queueBean && $queueBean->status != 'INACTIVE' && $queueBean && $queueBean->status != 'CLOSED') {
                    $this->_queueCore->changeStatus($waybillOrderBean->queue_id, 'INACTIVE', 0);
                }

                // determine the new queue in order to requeue the truck
                $man = $this->_tenderCore->getTenderManifest($tc_details->tender_id, 0);

                if (strtoupper($man['queues'][$tc_details->q_id]['requeue_rules']['method']) == 'NONE') {

                    // send SMS
                    $tn = $waybillOrderBean->tn;
                    $messageBody = "$tn- تم حذف دور الشاحنة";
                    $this->sendSmsToWaybillOrderInvolvedParties($waybill_order_id, $messageBody);
                } else {

                    $target_queue = $man['queues'][$queueBean->q_id]['requeue_rules']['target_queue'];

                    // get the trailer from the tender_truck
                    $tenderTruckSearchFilter = [
                        ['key' => 'tender_id', 'val' => $queueBean->tender_id],
                        ['key' => 'truck_id', 'val' => $queueBean->truck_id],
                        ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in']
                    ];
                    $tenderTruck = $this->_tenderCore->searchTenderTruck($tenderTruckSearchFilter, 1, 0, 0);
                    $tenderTruck = $tenderTruck->data[0];

                    // add the truck again to the queue
                    $new_queue_id = $this->_queueCore->addQueue(
                        $queueBean->truck_id,
                        $queueBean->driver_id,
                        $tenderTruck->trailer_id,
                        $target_queue,
                        $queueBean->tender_id,
                        $user_id
                    );

                    //check if there is auto action after create
                    $this->_queueCore->changeStatus($new_queue_id, 'ACTIVE', $user_id);

                    // write any remarks if any
                    if ($remarks) {
                        $this->_addNoteCore->addNotes('queue', $new_queue_id, $remarks, 0);
                    }

                    // send SMS
                    $tn = $waybillOrderBean->tn;
                    $messageBody = "$tn-تم إرجاع الشاحنة لأخر الدور بسبب تكرار التأجيل";
                    $this->sendSmsToWaybillOrderInvolvedParties($waybill_order_id, $messageBody);
                }
            } else {

                // validate if user did not exceede the delay limit
                $this->_queueCore->validateDelayQueue($waybillOrderBean->queue_id, 'PENDING', $duration, $user_id);

                // change queue status to PENDING
                $this->_queueCore->changeStatus($waybillOrderBean->queue_id, 'PENDING', $user_id);

                // update queue info
                $updateBean = new stdClass();
                $updateBean->id = $waybillOrderBean->queue_id;
                $updateBean->activation_date = date("Y-m-d", strtotime("+ " . $duration . " day"));
                $updateBean->total_delay = $duration;
                $this->_queueCore->updateQueue($updateBean, $user_id);

                // write any remarks on queue if any
                if ($remarks) {
                    $this->_addNoteCore->addNotes('queue', $waybillOrderBean->queue_id, $remarks, 0);
                }

                // write remark on waybill order
                $this->_addNoteCore->addNotes('waybill_order', $waybill_order_id, ' تم تأجيل الدور للشاحنة لمدة ' . $duration . ' يوم - ' . $remarks, 0);

                try {
                    // inform user about the change
                    $contact_user_id = $this->getWaybillOrderDefaultContact($waybill_order_id);
                    $notificationCore = new NotificationCore();

                    $payload = new stdClass();
                    $payload->type = "set_notification";
                    $payload->id = $waybill_order_id;
                    $payload->message = ' تم رفض أمر الحركة وتأجيل دور الشاحنة لمدة ' . $duration . ' يوم';
                    $notificationCore->sendDataMessage($contact_user_id, $payload);

                    //SEND SMS
                    $tn = $waybillOrderBean->tn;
                    $messageBody = "$tn-تم التأجيل على الدور لمدة $duration يوم";
                    $this->sendSmsToWaybillOrderInvolvedParties($waybill_order_id, $messageBody);
                } catch (Exception $e) {
                    // do nothing
                }
            };

            // close poll 
            $pollIntegration = new Poll;
            $poll_id = $waybillOrderBean->tc_detail->poll_id;
            if ($poll_id)
                $pollIntegration->closePoll($poll_id);

            //cancel ticket opened for waybill_order
            $waybillOrderBeanBasic = $this->getWaybillOrderBasic($waybill_order_id, $user_id);
            if ($waybillOrderBeanBasic->tc_details->ticket_id) {
                //cancel ticket in case it is not completed
                $customerCare = new CustomerCare();
                $ticket_id = $waybillOrderBeanBasic->tc_details->ticket_id;
                $ticketBean = $customerCare->getTicket($ticket_id);
                if ($ticketBean['status'] != 'COMPLETED') {
                    $customerCare->changeStatus($ticket_id, 'CANCELED', 0);
                }
            }

            //activate the other queues if the driver has more than one
            if ($queueBean) {
                $queuesToActivateSearchFilter = [
                    ['key' => 'truck_id', 'val' => $queueBean->truck_id],
                    ['key' => 'status', 'val' => 'HELD'],
                    ['key' => 'id', 'val' => [$waybillOrderBean->queue_id], 'op' => 'not in'],
                ];
                $queuesToActivate = $this->_queueCore->searchQueue($queuesToActivateSearchFilter, 1000, 0, $user_id)->data;

                // iterate and change status to ACTIVE for each queue
                foreach ($queuesToActivate as $queue) {
                    $this->_queueCore->changeStatus($queue->id, 'ACTIVE', 0);
                    // log activity
                    $this->_queueCore->logActivity(
                        $queue->id,
                        "فك تجميد الدور",
                        "تم فك تجميد الدور",
                        "activate_queue",
                        0
                    );
                }
            }

            DBConnection::commitTransaction();
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw $e;
        }

        // try to redistribute the same tender order
        $taskQueuesCore = new TaskQueuesCore();
        $taskQueuesCore->addRedistributeWaybillOrderTask($waybillOrderBean->tender_order_id);
    }


    // ------------------------------------------------------------------------------- //
    // ------------------- close waybill order and create new waybill----------------- //
    // ------------------------------------------------------------------------------- //
    public function closeWaybillOrder($waybill_order_id, $user_id)
    {

        try {

            // get waybillOrder and queue Bean
            $waybillOrderBean = $this->getWaybillOrderBasic($waybill_order_id, $user_id);
            if ($waybillOrderBean->queue_id) {
                $queueBean = $this->_queueCore->getQueueBasic($waybillOrderBean->queue_id, 0);
            } else {
                $queueBean = new stdClass();
                $queueBean->tender_id = $waybillOrderBean->tc_details->tender_id;
                $queueBean->q_id = null;
                $queueBean->truck_id = $waybillOrderBean->tc_details->truck_id;
                $queueBean->trailer_id = $waybillOrderBean->tc_details->trailer_id;
                $queueBean->driver_id = $waybillOrderBean->tc_details->driver_id;
                $queueBean->truck_owner_id = null;
                $queueBean->trucking_company_id = $waybillOrderBean->tc_details->trucking_company_id;
            }

            // if the trailer or driver has changed on waybill order , change them in queue
            if ($queueBean->trailer_id != $waybillOrderBean->tc_details->trailer_id || $queueBean->driver_id != $waybillOrderBean->tc_details->driver_id) {
                if ($waybillOrderBean->tc_details->trailer_id) {
                    $queueBean->trailer_id = $waybillOrderBean->tc_details->trailer_id;
                }
                if ($waybillOrderBean->tc_details->driver_id) {
                    $queueBean->driver_id = $waybillOrderBean->tc_details->driver_id;
                }
            }

            $cargoBean = $this->_cargoCore->getCargoBasic($waybillOrderBean->cargo_id, $user_id);
            $tenderBean = $this->_tenderCore->getTenderBasic($queueBean->tender_id, $user_id);

            $activateWaybillMessage = '';

            DBConnection::startTransaction();



            // if tender_code = JO_PETROL_AQ ,validate the owner of waybillOrder  , tc_company_id 71 is not allowed
            if ($tenderBean->manifest->tender_code == 'JO_PETROL_AQ') {
                $tc_details = $waybillOrderBean->tc_details;
                if ($tc_details->tc_company_id == 71) {
                    throw new Exception("لا تستطيع المتابعة ، يجب تحديد الناقل الفرعي لمستند الشحن");
                }
            }

            if ($tenderBean->manifest->tender_code == 'VESSELS' || $tenderBean->manifest->tender_code == 'JO_PETROL_OIL_DERIVATIVES') {
                $queueBean->trucking_company_id = $cargoBean->waybill_template->carrier[0]->tc_id;
            }

            // validate waybill order has tn
            $tc_details = $waybillOrderBean->tc_details;
             
            if ($tenderBean->manifest->tender_code != "LIGHT_MEDIUM_TRANS") {
                if (!$tc_details->tn || !$tc_details->trn) {
                    throw new Exception("لا تستطيع المتابعة ، يجب تحديد رقم القاطرة والمقطورة ");
                }
            }

            // validate the tender order date against current date
            $tenderOrderBean = $this->_tenderCore->getTenderOrderBasic($waybillOrderBean->tender_order_id, 0);
            $today    =  date_create(date(DBConnection::getSystemDate()));
            $orderDate = date_create(date($tenderOrderBean->order_date));
            $dateDiff = date_diff($orderDate, $today);
            if ($dateDiff->invert > 0) {

                // in case the user is OPERATION MANAGER skip this validation
                if (!isMinagateOperation($user_id)) {
                    throw new Exception("لا تستطيع المتابعة ، حيث ان تاريخ طلبية أمر الحركة أكبر من تاريخ اليوم");
                }
            }

            // change queue status to CLOSED
            if ($waybillOrderBean->queue_id && $queueBean->status != 'CLOSED')
                $this->_queueCore->changeStatus($waybillOrderBean->queue_id, 'CLOSED', $user_id);

            // prepare rest of waybill data
            $waybill_template = $cargoBean->waybill_template;
            $ca_company_id = $waybill_template->cargo[0]->consigner->ca_id;

            $origin_id = prepareLocationValue($waybill_template->negotiable_instructios->route->origin, $cargoBean);
            $destination_id = prepareLocationValue($waybill_template->negotiable_instructios->route->destination, $cargoBean);

            // if destination is Area (ex: city or Jordan) , see if the destination can be taken from order
            if (substr((string) $destination_id, -2, 2) == '00') {
                if ($tenderOrderBean->truck_routing && $tenderOrderBean->truck_routing[0]->destination_id) {
                    $destination_id = $tenderOrderBean->truck_routing[0]->destination_id;
                }
            }

            //  if tender_code = JO_PETROL_AQ , each close to waybill order and create of waybill requires 1 quota
            //  validate if the trucking company has enough quota balance
            //  if it has qouta , deduct it
            if ($tenderBean->manifest->tender_code == 'JO_PETROL_AQ') {
                $tender_id = $tenderBean->id;
                $tc_id = $waybillOrderBean->tc_details->tc_company_id;
                $this->_tenderCore->useCompanyQuota($tender_id, $tc_id, $tenderOrderBean->id);
            }

            if ($tenderBean->manifest->tender_code == 'GRAINS') {

                // get tenderOrderBean origin and destination
                $tenderOrderBean = $this->_tenderCore->getTenderOrderBasic($waybillOrderBean->tender_order_id, 0);

                $questionnaire =  $tenderOrderBean->questionnaire;
                $manifest_questionnaire = $tenderBean->manifest->questionnaire;
                $origin_index_id = 0;
                $destination_index_id = 0;

                foreach ($manifest_questionnaire as $question) {
                    if ($question->question_type == 'ROUTE:DISTINATION') {
                        $destination_index_id = $question->id;
                    }
                    if ($question->question_type == 'ROUTE:ORIGIN') {
                        $origin_index_id = $question->id;
                    }
                }
                $origin_id = $questionnaire[$origin_index_id - 1]->val;
                $destination_id = $questionnaire[$destination_index_id - 1]->val;

                // use quota
                $tender_id = $tenderBean->id;
                $tc_id = $waybillOrderBean->tc_details->tc_company_id;
                $this->_tenderCore->useCompanyQuota($tender_id, $tc_id, $tenderOrderBean->id);
            }


            // create new waybill
            $operation_type = $tenderBean->manifest->operation_type[0]->code;
            $waybill_result = $this->_waybillCore->createWaybill(
                $queueBean->tender_id,
                $queueBean->q_id,
                $waybillOrderBean->tender_order_id,
                $waybillOrderBean->cargo_id,
                $queueBean->truck_id,
                $queueBean->trailer_id,
                $queueBean->driver_id,
                $queueBean->truck_owner_id,
                $queueBean->truck_owner_id,
                $queueBean->trucking_company_id,
                $ca_company_id,
                $origin_id,
                $destination_id,
                $user_id,
                $operation_type
            );

            // write integration details into waybill    
            $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_result->id, $user_id);
            $integeration_details = new stdClass();
            $integeration_details->queue = new stdClass();
            $integeration_details->queue->queue_id = $queueBean->id;
            $integeration_details->queue->q_id = $queueBean->q_id;
            $integeration_details->queue->queue_rank = $queueBean->rank;
            $integeration_details->queue->serial = $queueBean->serial;
            $integeration_details->waybill_order = new stdClass();
            $integeration_details->waybill_order->waybill_order_id = $waybillOrderBean->id;
            $waybillBean->document->integeration_details = $integeration_details;
            $this->_waybillCore->updateWaybill($waybillBean, $waybill_result->id, 0);

            // get the available services for the trucking company
            $tenderCompanyCore = new TenderCompanyCore();
            $trucking_company_id = $queueBean->trucking_company_id;
            $tender_id = $queueBean->tender_id;

            $hasPayment = $tenderCompanyCore->hasPaymentService($tender_id, null, $trucking_company_id);
            if ($hasPayment) {
                $man = $this->_tenderCore->getTenderManifest($queueBean->tender_id, 0);

                // attemp to reserve the waybill ammount
                // $paymentCore = new PaymentCore();
                // $paymentCore->reserveWaybillAmount($waybill_result->id, $queueBean->tender_id);
            }

            // change waybill order to CLOSED
            $this->changeStatus($waybill_order_id, 'CLOSED', $user_id);

            // connect the newly created waybill with the closed waybill order
            $updateBean = new stdClass();
            $updateBean->id = $waybill_order_id;
            $updateBean->waybill_id = $waybill_result->id;
            DBConnection::updateDB("waybill_order", $updateBean, 0);

            // change cargo status
            $this->_cargoCore->arrivedCargoTruck($waybillOrderBean->cargo_id);

            DBConnection::commitTransaction();

            $Result['MESSAGE'] = "";
            $Result['waybill_order_id'] = $waybill_order_id;
            $Result['waybill_id'] =  $waybill_result->id;
            $Result['wn'] =  $waybill_result->wn;

            return $Result;
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw $e;
        }
    }




    // -------------------------------------------------------------------------- //
    // -------------------change status of waybill order ------------------------ //
    // -------------------------------------------------------------------------- //
    public function changeStatus($waybill_order_id, $new_status, $user_id)
    {

        $updateBean = new stdClass();
        $updateBean->id = $waybill_order_id;
        $updateBean->status = $new_status;

        DBConnection::updateDB("waybill_order", $updateBean, $user_id);
    }

    // ------------------------------------------- COMMUNICATION PART ------------------------------------------------- //

    public function sendWaybillOrderNotification($user_id, $waybill_order_id, $type)
    {

        try {
            $notificationCore = new NotificationCore();

            switch ($type) {
                case 'play_alarm':
                    $payload = new stdClass();
                    $payload->type = "play_alarm";
                    $payload->user_id = $user_id;
                    $payload->waybill_order_id = $waybill_order_id;
                    $notificationCore->sendDataMessage($user_id, $payload);
                    break;

                case 'cancel_alarm':
                    $payload = new stdClass();
                    $payload->type = "cancel_alarm";
                    $notificationCore->sendDataMessage($user_id, $payload);
                    break;

                case 'play_ringtone':
                    $payload = new stdClass();
                    $payload->type = "play_ringtone";
                    $payload->waybill_order_id = $waybill_order_id;
                    $payload->user_id = $user_id;
                    $notificationCore->sendDataMessage($user_id, $payload);
                    break;

                case 'play_sound':
                    $payload = new stdClass();
                    $payload->type = "play_sound";
                    $notificationCore->sendDataMessage($user_id, $payload);
                    break;

                case 'cancel_sound':
                    $payload = new stdClass();
                    $payload->type = "cancel_sound";
                    $notificationCore->sendDataMessage($user_id, $payload);
                    break;

                case 'cancel_ringtone':
                    $payload = new stdClass();
                    $payload->type = "cancel_ringtone";
                    $payload->waybill_order_id = $waybill_order_id;
                    $payload->user_id = $user_id;
                    $notificationCore->sendDataMessage($user_id, $payload);
                    break;

                case 'check_waybill_order':
                    $payload = new stdClass();
                    $payload->type = "check_waybill_order";
                    $notificationCore->sendDataMessage($user_id, $payload);
                    break;

                case 'set_sticky_notification':
                    $payload = new stdClass();
                    $payload->type = "set_sticky_notification";
                    $payload->id = intval($waybill_order_id) + intval($user_id);
                    $payload->user_id = $user_id;
                    $payload->message = 'لديك أمر حركة بحاجة إلى الموافقة';
                    $notificationCore->sendDataMessage($user_id, $payload);
                    break;

                case 'set_notification':
                    $payload = new stdClass();
                    $payload->type = "set_notification";
                    $payload->id = $waybill_order_id;
                    $payload->message = 'لديك أمر حركة بحاجة إلى الموافقة';
                    $notificationCore->sendDataMessage($user_id, $payload);
                    break;

                case 'cancel_sticky_notification':
                    $payload = new stdClass();
                    $payload->type = "cancel_sticky_notification";
                    $payload->id = intval($waybill_order_id) + intval($user_id);
                    $payload->user_id = $user_id;
                    $notificationCore->sendDataMessage($user_id, $payload);
                    break;

                case 'vibrate':
                    $payload = new stdClass();
                    $payload->type = "vibrate";
                    $notificationCore->sendDataMessage($user_id, $payload);
                    break;

                default:
                    // Do nothing
                    break;
            }
        } catch (Exception $e) {
            // Do nothing
        }
    }

    // -------------------------------------------------------------------------------------------- //
    // ------------------ Cancel all notifications on user mobile --------------------------------- //
    // -------------------------------------------------------------------------------------------- //
    public function cancelWaybillOrderNotification($waybill_order_id, $cancelStickyNotification = true)
    {

        $user_id = $this->getWaybillOrderDefaultContact($waybill_order_id);

        $this->sendWaybillOrderNotification($user_id, $waybill_order_id, 'cancel_alarm');
        $this->sendWaybillOrderNotification($user_id, $waybill_order_id, 'cancel_ringtone');
        //$this->sendWaybillOrderNotification($user_id,$waybill_order_id, 'cancel_sound');
        if ($cancelStickyNotification) {
            $this->sendWaybillOrderNotification($user_id, $waybill_order_id, 'cancel_sticky_notification');
        }
    }

    // ------------------------------------------------------------------------------------------------------------ //
    // ------------------- get the default contact user id in order to send the notification ---------------------- //
    // ------------------------------------------------------------------------------------------------------------ //
    public function getWaybillOrderDefaultContact($waybill_order_id)
    {

        try {
            $userCore = new UserCore();

            // get the truck owner of the waybill alarm
            $searchFilter = [['key' => 'id', 'val' => $waybill_order_id]];
            $waybillOrderBean = $this->searchWaybillOrder($searchFilter, 1, 0, 0)->data[0];

            if ($waybillOrderBean->contact_nn) {
                // get user_id using contact_nn
                $searchFilter = [
                    ['key' => 'nn', 'val' => $waybillOrderBean->contact_nn],
                    ['key' => 'status', 'val' => 'ACTIVE']
                ];
                $userInfo = $userCore->searchUser($searchFilter, 1, 0, 0)->data;

                $user_id = $userInfo[0]->id;
                return $user_id;
            } else {
                return null;
            }
        } catch (Exception $e) {
            return null;
        }
    }

    //-------------------------------------------------------------------------------//
    //------------------------- calculate waybill Order Timer------------------------//
    //-------------------------------------------------------------------------------//
    public function calculateTimer($waybillOrder)
    {
        if ($waybillOrder->status == "NEW") {
            //to do : the number 900000 should be returned by the database (900000 = 15 min)
            $timeDiff = 900000 - difference($waybillOrder->create_date, DBConnection::getSystemDate());
            $waybillOrder->timer = 0;
            if ($timeDiff > 0) {
                $waybillOrder->timer = $timeDiff;
            }
        } else {
            $waybillOrder->is_app_reachable = null;
        }
        return $waybillOrder;
    }


    // ------------------------------------------------------------------------------------------------------ //
    // ----------------------- Update the info in a certain waybill order ----------------------------------- //
    // ------------------------------------------------------------------------------------------------------ //
    public function updateWaybillOrder($waybillOrderBean, $waybill_order_id, $updated_by)
    {

        // fill update struct and set the target user id
        $waybillOrderBean->id = $waybill_order_id;

        // get basic object bean without any activites
        $DB_Bean = DBConnection::getBasicObjectBean("waybill_order", $waybill_order_id, $updated_by);

        //update driver info only if the driver bean is different than DB bean        
        if (compareObject($waybillOrderBean, $DB_Bean) == false) {

            // map all the new values into the DB_bean
            $waybillOrderBean = mapBeanToDBBean($waybillOrderBean, $DB_Bean);

            // fill update struct and set the target user id
            DBConnection::updateDB("waybill_order", $waybillOrderBean, $updated_by);
        }
    }
}
