<?php
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/waybill_draft_core.php");
require_once(dirname(__FILE__) . "/waybill_draft_integration.php");
require_once(dirname(__FILE__) . "/../../core/waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../../core/voucher/voucher_core.php");
require_once(dirname(__FILE__) . "/../../core/tender/tender_core.php");
require_once(dirname(__FILE__) . "/../../core/account/account_core.php");
require_once(dirname(__FILE__) . "/../../core/company_employee/company_employee_core.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/merchant.php");
class WaybillDraft extends API
{
    private $_waybillCore;
    private $_WaybillDraft;
    private $WaybillDraftIntegration;
    private $_voucherCore;
    private $_tenderCore;
    private $_companyEmployeeCore;
    private $_couponCore;
    private $_accountCore;

    public function __construct()
    {
        // call the super constructur
        $this->_request = parent::__construct();

        $this->_WaybillDraft = new WaybillDraftCore();
        $this->WaybillDraftIntegration = new WaybillDraftIntegration();
        $this->_waybillCore = new WaybillCore();
        $this->_voucherCore = new VoucherCore();
        $this->_tenderCore = new TenderCore();
        $this->_accountCore = new AccountCore();
        $this->_companyEmployeeCore = new CompanyEmployeeCore();
        $this->_couponCore = new MerchantIntegration();


        session_start();
        if (!isset($_SESSION['user_id'])) {
            throw new Exception('No Session!');
        }


        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // -------------------------------------------------------------------------------------------------- //
    // ------------------ get certain waybill draft  ----------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function getWaybillDraft()
    {
        $id = $this->_request->id;
        try {

            // get waybill data
            $waybill_draft = $this->_WaybillDraft->getWaybillDraft($id, $_SESSION['u_id']);

            //search for vouchers for this waybill draft
            $vouchersFilter = [
                ['key' => 'trx_template', 'val' => '"' . $waybill_draft->id . '"', 'op' => 'json unquote', 'node' => '$.waybill_draft_ref_id']
            ];
            $vouchers = $this->_voucherCore->searchVouchers($vouchersFilter, 100, 0, 0, null);

            $Result['waybill_draft'] = $waybill_draft;
            $Result['vouchers'] = $vouchers->data;
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------------------------------------------------------- //
    // ------------------ get certain waybill draft  ----------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function getWaybillDraftBasic()
    {
        $id = $this->_request->id;
        try {
            // get waybill data
            $waybill_draft = $this->_WaybillDraft->getWaybillDraft($id, $_SESSION['u_id']);
            $Result['waybill_draft'] = $waybill_draft;
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------------------------------------------------------- //
    // ------------------ search waybill draft  --------------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function searchWaybillDraft()
    {
        $filter = $this->_request->filter;
        $limit = $this->_request->limit;
        if (!$limit) $limit = 50;

        $offset = $this->_request->offset;
        try {
            // inject allowed tender ids only
            if ($_SESSION['tender_ids'] && $_SESSION['tender_ids'][0] != "*") {
                $allowed_tenders = implode(',', $_SESSION['tender_ids']);
            }

            $waybill_drafts = $this->_WaybillDraft->searchWaybillDraft($filter, $allowed_tenders, $limit, $offset, $_SESSION['u_id']);
            foreach ($waybill_drafts as &$draft) {
                $draft->document = json_decode($draft->document);
            }

            $result['found_rows'] = sizeof($waybill_drafts);
            $result['data'] = $waybill_drafts;
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------------------------------------------------------- //
    // ------------------ create new waybill draft with advance payments -------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function createWaybillDraft()
    {

        // get user params
        $incomingWaybillData = $this->_request;
        $tender_id = $incomingWaybillData->tender_id;
        $bond_number = $incomingWaybillData->bond_number;
        $advance_payment = $this->_request->advance_payments;

        if($tender_id == 17){
            throw new Exception("لا يمكن تقديم أرساليات جديدة");            
        }

        try {
            DBConnection::startTransaction();


            // fitch all waybill drafts with the same bond number
            $incomingWaybillDrafts = $this->_WaybillDraft->autoCompleteForBondNumber($bond_number, $tender_id, $_SESSION['u_id']);


            // check if waybill draft is  in DB
            if ($incomingWaybillDrafts) {
                foreach ($incomingWaybillDrafts as &$draft) {

                    $now = time(); // or your date as well
                    $your_date = strtotime($draft->create_date);
                    $datediff = $now - $your_date;
                    $diffInDays =  round($datediff / (60 * 60 * 24));

                    $bond_id = $draft->bond_number;
                    $destination_id = json_decode($draft->document)->negotiable_instructios->route->destination->id;
                    $origin_id = json_decode($draft->document)->negotiable_instructios->route->origin->id;
                    if ($bond_id == $bond_number  && $destination_id == $incomingWaybillData->destination_id && $origin_id ==  $incomingWaybillData->origin_id && $diffInDays < 60) {
                        throw new Exception("لا تستطيع المتابعة ,يوجد ارسالية بنفس رقم البون وموقع التحميل و التفريغ");
                    }
                }
            }


            // calculate sumation of advance payments
            $total_advance_payment = 0;
            if ($advance_payment  && sizeof($advance_payment) > 0) {
                foreach ($advance_payment as $payment) {
                    // validate the personal advance payment
                    if ($payment->type === 'personal_payment' || $payment->type === 'external_payment') {
                        if (!$payment->account_id) {
                            throw new Exception('account id is required for personal payment');
                        }
                        $total_advance_payment += $payment->value;
                    } else if ($payment->type === 'disel_payment') {
                        $coupon = $this->_couponCore->validateCouponNumber($payment->coupon_number);
                        $total_advance_payment += (int)json_decode($coupon['details'])->amount;
                    }
                }
            }

            //validate tha advance payments
            if ($total_advance_payment > 0) {
                $this->_request->total_advance_payment = $total_advance_payment;
                $this->validateAdvancePayment();
            }

            // create new waybill draft record in DB
            $this->_WaybillDraft->createWaybillDraft($incomingWaybillData, $_SESSION['user_id'], $_SESSION['u_id']);

            $created_waybill_draft = $this->_WaybillDraft->searchLastWaybillDraft($incomingWaybillData->bond_number);
            $created_waybill_draft->document = json_decode($created_waybill_draft->document);

            // ------------------ Financial Part -------------------------------

            // get ledger account id based on tender
            $tenderManifestJSON = $this->_tenderCore->getTenderManifest($incomingWaybillData->tender_id, 0);
            $accounts = $tenderManifestJSON['freight']['accounts'];
            foreach ($accounts as $acc) {
                if ($acc['code'] == 'ledger_account') {
                    $ledger_account_id = $acc['account'];
                }
            }

            // start the advance payments voucher work
            if ($total_advance_payment  > 0) {
                $paymentCore = new PaymentCore();
                $voucher_ids = [];

                if ($incomingWaybillData->tender_id == 17) {
                    $personal_target_account = "777412-60001";      //تكاليف
                    $diesel_payment_account = '777412-19905';       //صندوق كوبونات
                    $diesel_target_account = "777412-60001";        //تكاليف
                } else if ($incomingWaybillData->tender_id == 19) {
                    $personal_target_account = "777412-60003";      //تكاليف
                    $diesel_payment_account = '777412-19905';       //صندوق كوبونات
                    $diesel_target_account = "777412-60003";        //تكاليف
                }

                foreach ($advance_payment as $payment) {

                    // validate the personal advance payment
                    if ($payment->type === 'personal_payment' || $payment->type === 'external_payment') {
                        // build remarks
                        $remarks =  ':سلفة شخصية للشاحنة ' . $created_waybill_draft->tn .
                            ' - السائق: ' . $created_waybill_draft->driver_name .
                            ' - رقم وطني: ' . $created_waybill_draft->driver_nn .
                            ' - ارسالية: ' . $created_waybill_draft->bond_number;

                        // create voucher for this payment
                        $payment_account = $payment->account_id;
                        $target_account = $personal_target_account;
                        $advancePaymentNode = (object) array(
                            "name" => "PERSONAL_PAYMENT",
                            "label" => $remarks,
                            "target_account" => $personal_target_account,
                            "time_stamp" => DBConnection::getSystemDate(),
                            "value" => $payment->value
                        );

                        $payment_account_bean = $this->_accountCore->getAccountBasic($payment_account, 0);
                        $voucher_payment_method = strtoupper($payment_account_bean->payment_channel[0]);

                        $personal_voucher_id = $this->_WaybillDraft->createVoucher(
                            $payment_account,
                            $personal_target_account,
                            $payment->value,
                            $voucher_payment_method,
                            $advancePaymentNode,
                            null,
                            'WAYBILL_DRAFT_EXPORT_PHOSPHATE_PERSONAL',
                            $created_waybill_draft->id,
                            $remarks,
                            $incomingWaybillData->tender_id,
                            "silk_road_voucher"
                        );

                        // change status to pending
                        if ($voucher_payment_method == "EXTERNAL_DEBIT") {
                            $voucherBean = $this->_voucherCore->getVoucherBasic($personal_voucher_id, 0);
                            $voucherBean->status = "PENDING";
                            $voucherBean->payment_method = $voucher_payment_method;
                            $this->_voucherCore->updateVoucherInfo($voucherBean, $personal_voucher_id, 0);
                        } else {
                            $jv_id = $paymentCore->logWaybillAdvancePaymentTrx($payment->value, $ledger_account_id, $payment->account_id, $remarks, $_SESSION['user_id']);
                            // complete it
                            $voucherBean = $this->_voucherCore->getVoucherBasic($personal_voucher_id, 0);
                            $voucherBean->jv_id = $jv_id;
                            $voucherBean->payment_date = DBConnection::getSystemDate();
                            $voucherBean->status = "COMPLETE";
                            $this->_voucherCore->updateVoucherInfo($voucherBean, $personal_voucher_id, 0);
                        }

                        $voucher_ids[] = $personal_voucher_id;
                    } else if ($payment->type === 'disel_payment') {
                        $coupon = $this->_couponCore->validateCouponNumber($payment->coupon_number);
                        $coupon_value = (int)json_decode($coupon['details'])->amount;
                        // build remarks
                        $remarks =  ':سلفة ديزل للشاحنة ' . $created_waybill_draft->tn .
                            ' - السائق: ' . $created_waybill_draft->driver_name .
                            ' - رقم وطني: ' . $created_waybill_draft->driver_nn .
                            ' - كوبون رقم: ' . $payment->coupon_number .
                            ' - ارسالية: ' . $created_waybill_draft->bond_number;

                        // create voucher for this payment                        
                        $value = new stdClass();
                        $value->amount = $coupon_value;
                        $advancePaymentNode = (object) array(
                            "name" => "DISEL_PAYMENT",
                            "label" => $remarks,
                            "target_account" => $diesel_target_account,
                            "time_stamp" => DBConnection::getSystemDate(),
                            "value" => $coupon_value
                        );
                        $note = new stdClass();
                        $note->payment = new stdClass();
                        $note->payment->coupon_number = $coupon['coupon_number'];
                        $disel_voucher_id = $this->_WaybillDraft->createVoucher(
                            $diesel_payment_account,
                            $diesel_target_account,
                            $coupon_value,
                            'CASH',
                            $advancePaymentNode,
                            null,
                            'WAYBILL_DRAFT_EXPORT_PHOSPHATE_DISEL',
                            $created_waybill_draft->id,
                            $remarks,
                            $incomingWaybillData->tender_id,
                            "silk_road_voucher_disel",
                            $note
                        );

                        $voucher_ids[] = $disel_voucher_id;
                        $remarksTRX = "وذلك عن أمر صرف رقم " . $disel_voucher_id . " - كوبون رقم " . $payment->coupon_number;
                        $jv_id = $paymentCore->logWaybillAdvancePaymentTrx($coupon_value, $ledger_account_id, $diesel_payment_account, $remarksTRX, $_SESSION['user_id']);
                        $voucherBean = $this->_voucherCore->getVoucherBasic($disel_voucher_id, 0);

                        // write integration details
                        $integration_details = $voucherBean->integration_details ? $voucherBean->integration_details : new stdClass();
                        $activity = $voucherBean->integration_details->activity ? $voucherBean->integration_details->activity : [];
                        $new_act = new stdClass();
                        $new_act->code = "صرف كوبون رقم " . $payment->coupon_number;
                        $new_act->ref_id = $payment->coupon_number;
                        $new_act->time_stamp = DBConnection::getSystemDate();
                        $activity[] = $new_act;
                        $integration_details->activity = $activity;
                        $voucherBean->integration_details = $integration_details;
                        $this->_voucherCore->updateVoucherInfo($voucherBean, $disel_voucher_id, 0);

                        // complete it                       
                        $voucherBean->jv_id = $jv_id;
                        $voucherBean->payment_date = DBConnection::getSystemDate();
                        $voucherBean->status = "COMPLETE";
                        $this->_voucherCore->updateVoucherInfo($voucherBean, $disel_voucher_id, 0);
                        $this->_couponCore->changeStatus('USED', $coupon['id']);
                    }
                }

                // log advance payment
                $newPayment = new stdClass();
                $newPayment->label = $remarks;
                $newPayment->name = "PERSONAL_PAYMENT";
                $newPayment->value = new stdClass();
                $newPayment->value->amount = $total_advance_payment;
                $newPayment->time_stamp = DBConnection::getSystemDate();
                $this->_WaybillDraft->addWaybillPaymentNode($created_waybill_draft, $newPayment);
            }

            // if all weights and dates provided change the status of waybill draft to closed
            if (
                trim($incomingWaybillData->loading_weight) &&
                trim($incomingWaybillData->loading_weight_timestamp) &&
                trim($incomingWaybillData->discharge_weight) &&
                trim($incomingWaybillData->discharge_weight_timestamp)
            ) {
                $this->_WaybillDraft->changeStatus($created_waybill_draft->id, 'CLOSED');
            }

            DBConnection::commitTransaction();
            $Result['waybill_draft_id'] = $created_waybill_draft->id;
            $Result['voucher_ids'] = $voucher_ids;
            $Result['MESSAGE'] = 'تمت العملية بنجاح';
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();

            if (strpos($e->getMessage(), "100 Insufficient funds account")) {
                throw new Exception('لا تستطيع المتابعة, لايوجد رصيد كافي في الصندوق');
            }
            throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------------------------------------------------------- //
    // ------------------ Change waybill draft to closed and save discharge weight ---------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function closeWaybillDraft()
    {
        try {
            $waybill_draft_id = trim($this->_request->id);
            $loading_weight = trim($this->_request->loading_weight);
            $discharge_weight = trim($this->_request->discharge_weight);
            $loading_weight_timestamp = trim($this->_request->loading_weight_timestamp);
            $discharge_weight_timestamp = trim($this->_request->discharge_weight_timestamp);

            if (!$discharge_weight || !$discharge_weight_timestamp) {
                throw new Exception("يجب ادخال وزن وتاريخ التفريغ بشكل صحيح");
            }

            DBConnection::startTransaction();
            // save waybill data
            $this->_WaybillDraft->closeWaybillDraft($waybill_draft_id, $loading_weight, $discharge_weight, $loading_weight_timestamp, $discharge_weight_timestamp);
            DBConnection::commitTransaction();

            $Result['MESSAGE'] = 'تمت العملية بنجاح';
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------------------------------------------------------- //
    // ------------------ Change the status of the draft to complete and finish financial trx ----------- //
    // -------------------------------------------------------------------------------------------------- //
    public function completeWaybillDraft()
    {
        $waybill_draft_id = $this->_request->id;
        $cash_account_id = $this->_request->cash_account_id;
        $delay_days = $this->_request->delay_days;

        try {
            if (!$cash_account_id) {
                //throw new Exception('الرجاء اختيار الصندوق');
            }

            if (strtoupper($_SESSION['type']) == "CORPORATE") {
                // get tender_ids from company employee
                $company_employee_id = $_SESSION['company_employee_id'];
                $companyEmployeeBean = $this->_companyEmployeeCore->getCompanyEmployeeBasic($company_employee_id, 0);

                if ($companyEmployeeBean->account_ids) {
                    if ($companyEmployeeBean->account_ids == ['*']) {
                        // do nothing
                    } else {
                        $sub_id = explode("-", $this->_request->cash_account_id)[1];
                        if (!in_array($sub_id, $companyEmployeeBean->account_ids)) {
                            throw new Exception("لا يوجد لديك صلاحية لمشاهدة الحساب");
                        }
                    }
                } else {
                    throw new Exception("لا يوجد لديك صلاحية لمشاهدة الحساب");
                }
            }

            DBConnection::startTransaction();

            // save waybill data
            $voucher_id =  $this->_WaybillDraft->completeWaybillDraft(
                $waybill_draft_id,
                $cash_account_id,
                275412,
                $delay_days,
                $_SESSION['user_id']
            );

            DBConnection::commitTransaction();

            $Result['voucher_id'] = $voucher_id;
            $Result['MESSAGE'] = 'تمت العملية بنجاح';
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            if (strpos($e->getMessage(), "100 Insufficient funds account")) {
                throw new Exception('لا تستطيع المتابعة, لايوجد رصيد كافي في الصندوق');
            }
            if (strpos($e->getMessage(), "less than min balance of account")) {
                throw new Exception('لا تستطيع المتابعة, لايوجد رصيد كافي في الصندوق');
            }

            throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------------------------------------------------------- //
    // ------------------ Calculate the freight amount by calling Tagreesh ------------------------------ //
    // -------------------------------------------------------------------------------------------------- //
    public function calculateWaybillDraftFrieght()
    {

        $waybill_draft_id = $this->_request->id;
        $delay_days = $this->_request->delay_days;
        $routeWageCore = new RouteWageCore();
        try {
            $paymentCore = new PaymentCore();
            $waybillBean = $this->_WaybillDraft->getWaybillDraft($waybill_draft_id);
            $waybillBean->document = json_decode($waybillBean->document);
            $waybillBean->destination_id = $waybillBean->document->negotiable_instructios->route->destination->id;
            $waybillBean->cash_box_id = $this->_request->cash_box_id;


            // override loading and dishcharge
            if ($this->_request->loading_weight) {
                $waybillBean->document->cargo[0]->weights->loading->net_weight = $this->_request->loading_weight;
            }
            if ($this->_request->loading_date) {
                $waybillBean->document->cargo[0]->weights->loading->time_stamp = $this->_request->loading_date;
            }
            if ($this->_request->discharge_weight) {
                $waybillBean->document->cargo[0]->weights->discharge->net_weight = $this->_request->discharge_weight;
            }
            if ($this->_request->discharge_date) {
                $waybillBean->document->cargo[0]->weights->discharge->time_stamp = $this->_request->discharge_date;
            }
            if ($this->_request->origin_id) {
                $waybillBean->document->negotiable_instructios->route->origin->id = $this->_request->origin_id;
            }
            if ($this->_request->destination_id) {
                $waybillBean->document->negotiable_instructios->route->destination->id = $this->_request->destination_id;
            }
            if ($this->_request->cargo_id) {
                $waybillBean->document->cargo[0]->cargo_id = $this->_request->cargo_id;
            }

            // search route wage
            $routeWage =  $routeWageCore->searchWageForFreight(
                $waybillBean->tender_id,
                $waybillBean->document->negotiable_instructios->route->origin->id,
                $waybillBean->document->negotiable_instructios->route->destination->id,
                $waybillBean->document->cargo[0]->cargo_id,
                $waybillBean->document->cargo[0]->weights->loading->time_stamp,
                'payable'
            );

            $freight_node = $paymentCore->calculateFreight($waybillBean, null, null, $routeWage);

            // for phosphate project , add late fine
            if ($delay_days && intval($delay_days) > 0) {
                $freight_node->amount->total_fines = intval($delay_days * 10);
                $freight_node->amount->net_amount = doubleVal($freight_node->amount->net_amount - intval($delay_days * 10));
                $freight_node->amount->net_amount = number_format((float)$freight_node->amount->net_amount, 3, '.', '');
            }

            $loading_weight = $waybillBean->document->cargo[0]->weights->loading->net_weight;
            $discharge_weight = $waybillBean->document->cargo[0]->weights->discharge->net_weight;

            $Result['deductions'] = $freight_node->deductions;
            $Result['amount'] = $freight_node->amount;
            $Result['allowed_to_override'] = $freight_node->allowed_to_override;
            $Result['cargo'] = ["loading_weight" => $loading_weight, "discharged_weight" => $discharge_weight];
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------------------------------------------------------------ //
    // ------------------  Revoke the voucher associated with the draft then reverse the trx , then change status of ---------------- //
    // ------------------  the draft to closed in order to change the loading and the discharge weight ------------------------------ //
    // ------------------------------------------------------------------------------------------------------------------------------ //
    public function revokeWaybillDraft()
    {

        try {
            DBConnection::startTransaction();


            // get input params
            $waybill_id = $this->_request->waybill_id;

            // validate auth
            $user_roles = explode(",", $_SESSION['USER_ROLES']);
            $canRevoke = false;
            if (in_array("TELLER_SUPERVISOR", $user_roles) || in_array("OPERATION_MANAGER", $user_roles)) {
                $canRevoke = true;
            }
            if (!$canRevoke) {
                throw new Exception("لا يوجد لديك صلاحية للمتابعة");
            }

            // revoke
            $this->_WaybillDraft->revokeWaybillDraft($waybill_id, $_SESSION['user_id']);

            DBConnection::commitTransaction();

            // return success
            $Result['MESSAGE'] = 'تمت العملية بنجاح';
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }

    // ----------------------------------------------------------------------------------------------------------------------------- //
    // ------------------ validate the maximum amount of advance payment based on estimated final amount of the waybill ------------ //
    // ----------------------------------------------------------------------------------------------------------------------------- //
    public function validateAdvancePayment()
    {
        $incomingWaybillData = $this->_request;
        $advance_payment = $this->_request->total_advance_payment;
        try {
            $tempWaybillBean = new stdClass();
            $paymentCore = new PaymentCore();
            $routeWageCore = new RouteWageCore();
            $tempWaybillBean->document = new stdClass();
            $tempWaybillBean->document->cargo = [];
            $tempWaybillBean->document->cargo[0] = new stdClass();
            $tempWaybillBean->document->cargo[0]->weights = new stdClass();
            $tempWaybillBean->document->cargo[0]->weights->loading = new stdClass();
            $tempWaybillBean->document->cargo[0]->weights->loading->time_stamp = $incomingWaybillData->loading_weight_timestamp;
            $tempWaybillBean->document->cargo[0]->cargo_id = $incomingWaybillData->cargo_id;

            $tempWaybillBean->document->negotiable_instructios = new stdClass();
            $tempWaybillBean->document->negotiable_instructios->route = new stdClass();
            $tempWaybillBean->document->negotiable_instructios->route->destination = new stdClass();
            $tempWaybillBean->document->negotiable_instructios->route->destination->id = $incomingWaybillData->destination_id;
            $tempWaybillBean->document->tender = new stdClass();
            $tempWaybillBean->tender_id = $incomingWaybillData->tender_id;
            $tempWaybillBean->document->tender->id = $incomingWaybillData->tender_id;

            if (!$incomingWaybillData->discharge_weight) {
                $incomingWaybillData->discharge_weight = $incomingWaybillData->loading_weight;
            }

            //search route wage
            $routeWage = $routeWageCore->searchWageForFreight(
                $incomingWaybillData->tender_id,
                $incomingWaybillData->origin_id,
                $incomingWaybillData->destination_id,
                $incomingWaybillData->cargo_id,
                $incomingWaybillData->loading_weight_timestamp,
                'receivable'
            );
            $freight_node = $paymentCore->calculateFreight($tempWaybillBean, $incomingWaybillData->discharge_weight, $incomingWaybillData->loading_weight, $routeWage);
            $maximum_adv_limit = $freight_node->amount->net_amount;
            $maximum_adv_limit = floor($maximum_adv_limit);
            if ($maximum_adv_limit < 0) {
                throw new Exception("القيمة النهائية للمستند أقل من الحد المسموح به لاستلام سلفة");
            }
            if ($advance_payment > $maximum_adv_limit) {
                throw new Exception("بالإعتماد على القيمة التقديرية للمستند فأن السلفة أكبر من الحد المسموح به ، لا يجب ان تتجاوز السلفة  $maximum_adv_limit دينار");
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ----------------------------------------------------------------------------------------------------------- //
    // ------------------ update loading info in certain waybill draft if its status is ONROAD, CLOSED ----------- //
    // ----------------------------------------------------------------------------------------------------------- //
    public function updateLoadingInfo()
    {
        $data = $this->_request;
        $data->user_id = $_SESSION['user_id'];

        // validate the status
        $waybill_draft_id = $data->waybill_draft_id;
        $waybill_draft = $this->_WaybillDraft->getWaybillDraft($waybill_draft_id, $_SESSION['u_id']);
        if ($waybill_draft->status == "COMPLETED") {
            throw new Exception("لا توجد لديك صلاحية");
        }

        if (!$data->loading_weight || trim($data->loading_weight) == "") {
            throw new Exception("وزن التحميل غير صحيح");
        }
        if (!$data->loading_date || trim($data->loading_date) == "") {
            throw new Exception("تاريخ التحميل غير صحيح");
        }

        try {
            $this->_WaybillDraft->updateLoadingInfo($data, $waybill_draft);
            $response['MESSAGE'] = 'تمت العملية بنجاح';
            parent::response($response);
        } catch (Exception $e) {
            parent::exceptionHandler($e);
        }
    }


    // ###############################   auto Complete Methods   ######################################## //

    // -------------------------------------------------------------------------------------------------- //
    // ------------------ get waybill draft based on truck number --------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function autoCompleteForTN()
    {
        $tn = $this->_request->tn;
        try {

            // save waybill data
            $waybill_draft = $this->_WaybillDraft->autoCompleteForTN($tn, $_SESSION['u_id']);
            //search for vouchers for this waybill draft
            $vouchersFilter = [
                ['key' => 'trx_template', 'val' => '"' . $waybill_draft->id . '"', 'op' => 'json unquote', 'node' => '$.waybill_draft_ref_id']
            ];
            $vouchers = $this->_voucherCore->searchVouchers(
                $vouchersFilter,
                100,
                0,
                $_SESSION['user_id'],
                null
            );

            $Result['waybill_draft'] = $waybill_draft;
            $Result['vouchers'] = $vouchers->data;
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------------------------------------------------------- //
    // ------------------ get waybill draft based on driver phone --------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function autoCompleteForDriverPhone()
    {
        $phone = $this->_request->phone;
        try {

            // save waybill data
            $waybill_draft = $this->_WaybillDraft->autoCompleteForDriverPhone($phone, $_SESSION['u_id']);
            //search for vouchers for this waybill draft
            $vouchersFilter = [
                ['key' => 'trx_template', 'val' => '"' . $waybill_draft->id . '"', 'op' => 'json unquote', 'node' => '$.waybill_draft_ref_id']
            ];
            $vouchers = $this->_voucherCore->searchVouchers(
                $vouchersFilter,
                100,
                0,
                $_SESSION['user_id'],
                null
            );

            $Result['waybill_draft'] = $waybill_draft;
            $Result['vouchers'] = $vouchers->data;
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------------------------------- //
    // ------------------ get waybill draft based on driver NN ------------------------------------------ //
    // -------------------------------------------------------------------------------------------------- //
    public function autoCompleteForNN()
    {
        $nn = $this->_request->nn;
        try {

            // save waybill data
            $waybill_draft = $this->_WaybillDraft->autoCompleteForNN($nn);
            //search for vouchers for this waybill draft
            $vouchersFilter = [
                ['key' => 'trx_template', 'val' => '"' . $waybill_draft->id . '"', 'op' => 'json unquote', 'node' => '$.waybill_draft_ref_id']
            ];
            $vouchers = $this->_voucherCore->searchVouchers(
                $vouchersFilter,
                100,
                0,
                $_SESSION['user_id'],
                null
            );

            $Result['waybill_draft'] = $waybill_draft;
            $Result['vouchers'] = $vouchers->data;
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------------------------------------------------------- //
    // ------------------ get waybill draft based on bond number ---------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function autoCompleteForBondNumber()
    {
        $bond_number = $this->_request->bond_number;
        $tender_id = $this->_request->tender_id;

        try {
            // save waybill data
            $waybill_draft = $this->_WaybillDraft->autoCompleteForBondNumber($bond_number, $tender_id, $_SESSION['u_id']);
            $allowAdd = true;
            if ($waybill_draft) {
                foreach ($waybill_draft as &$draft) {

                    $draft->destination_name = json_decode($draft->document)->negotiable_instructios->route->destination->name;
                    $draft->origin_name = json_decode($draft->document)->negotiable_instructios->route->origin->name;
                    if ($draft->status == "NEW" || $draft->status == "CLOSED" || $draft->status == "ONROAD") {
                        $allowAdd = false;
                    }
                }
            }

            $Result['waybill_draft'] = $waybill_draft;
            $Result['allow_add'] = $allowAdd;
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ----------------------------------------------------------------------------------------------- //
    // ------------------ get vouchers of certain waybill draft  ------------------------------------- //
    // ----------------------------------------------------------------------------------------------- //
    public function autoCompleteVouchersForWaybillDraft()
    {

        $waybill_draft_id = $this->_request->waybill_draft_id;

        //search for vouchers for this waybill draft
        $vouchersFilter = [
            ['key' => 'trx_template', 'val' => '"' . $waybill_draft_id . '"', 'op' => 'json unquote', 'node' => '$.waybill_draft_ref_id']
        ];
        $vouchers = $this->_voucherCore->searchVouchers($vouchersFilter, 100, 0, $_SESSION['user_id'], null);

        $Result['vouchers'] = $vouchers;
        parent::response($Result);
    }


    // ######################################   INJAZ Part   ############################################ //

    // -------------------------------------------------------------------------------------------------- //
    // ------------------ create waybill draft Injaz  --------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function createInjazWaybillDraft()
    {
        $incomingWaybillData = $this->_request;
        $amount = $this->_request->amount;
        $img_url =  $this->_request->voucher_photo_url;
        try {

            DBConnection::startTransaction();


            if (!$amount  || $amount <= 0) {
                throw new Exception('الرجاء ادخال مبلغ صحيح');
            }

            if ($amount  && $amount > 100) {
                //throw new Exception('المبلغ يجب ان لا يتجاوز 100 دينار');
            }

            // save waybill data
            //$this->_WaybillDraft->createInjazWaybillDraft($incomingWaybillData, $_SESSION['user_id'], $_SESSION['u_id']);
            $created_waybill_draft = $this->_WaybillDraft->searchLastWaybillDraft();
            $created_waybill_draft->document = json_decode($created_waybill_draft->document);
            // add advance payment
            if ($amount  && $amount  > 0) {
                // build remarks
                $remarks =  ' قيد مستحقات للسائق ' . $created_waybill_draft->driver_name .
                    ' - رقم وطني ' . $created_waybill_draft->driver_nn .
                    ' - رقم هاتف ' . $created_waybill_draft->driver_phone .
                    ' - الشاحنة رقم : ' . $created_waybill_draft->tn;

                // create voucher for this payment
                $payment_account = '590000-19901';
                $target_account = '590000-35004';
                $value = new stdClass();
                $value->amount = $amount;
                $advancePaymentNode = (object) array(
                    "name" => "INJAZ_PAYMENT",
                    "label" => $remarks,
                    "target_account" => $target_account,
                    "time_stamp" => DBConnection::getSystemDate(),
                    "value" => $value
                );


                $injaz_voucher_id = $this->_WaybillDraft->createVoucher(
                    $payment_account,
                    $target_account,
                    $amount,
                    'CASH',
                    $advancePaymentNode,
                    null,
                    'WAYBILL_DRAFT',
                    $created_waybill_draft->id,
                    $remarks,
                    $incomingWaybillData->tender_id,
                    "INJAZ"
                );


                $paymentCore = new PaymentCore();

                // log Advance Payment Trx
                $ledger_account_id = '590000';
                $cash_account_id = '590000-19901';
                $ap_account_id = '590000-35004';
                $claim_account_id = '590000-20284';
                $revinue_account_id = '590000-50003';
                $notes = $remarks;
                $jv_id = $paymentCore->logInjazWaybillCompletePaymentTrx(
                    $amount,
                    $ledger_account_id,
                    $ap_account_id,
                    $cash_account_id,
                    $claim_account_id,
                    $revinue_account_id,
                    null,
                    $notes,
                    $_SESSION['user_id']
                );

                // complete it
                $voucherBean = $this->_voucherCore->getVoucherBasic($injaz_voucher_id, 0);
                $voucherBean->jv_id = $jv_id;
                $voucherBean->payment_date = DBConnection::getSystemDate();
                $voucherBean->status = "COMPLETE";
                $this->_voucherCore->updateVoucherInfo($voucherBean, $injaz_voucher_id, 0);
            }

            DBConnection::commitTransaction();
            $Result['waybill_draft'] = $created_waybill_draft;
            $Result['voucher_id'] = $injaz_voucher_id;
            $Result['MESSAGE'] = 'تمت العملية بنجاح';
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();

            if (strpos($e->getMessage(), "100 Insufficient funds account")) {
                throw new Exception('لا تستطيع المتابعة, لايوجد رصيد كافي في الصندوق');
            }
            throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------------------------------------------------------- //
    // ------------------ search waybill draft  --------------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function updateInjazWaybillDraftAttachment()
    {
        $waybill_draft_id = $this->_request->id;
        $img_url =  $this->_request->voucher_photo_url;
        try {

            $this->_WaybillDraft->updateInjazWaybillDraftAttachment($waybill_draft_id, $img_url, $_SESSION['u_id']);
            $result['MESSAGE'] = 'تمت العملية بنجاح';
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }
}

$silk_road = new WaybillDraft();
