<?php

require_once (dirname(__FILE__)."/../../includes/DBConnection.php");
require_once (dirname(__FILE__)."/../../includes/config.php");

class WaybillDraftIntegration {

    public function __construct(){
        DBConnection::getInstance();
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ get the integration token for customer care System ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    private function getIntegrationToken(){
        return 'zsaT78KFPAqbce4kmdcV7fehHw74ATYNAGDSKf9cneSBTdJNxs7Cdw5LYvHEh2yg';
    }



    // ------------------------------------------------------------------------------------------- //
    // ------------------ create ticket  ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function generatePDF($data){

        $url = Config::$misc_base_url . 'generatePdfReport?';

        $waybill = new stdClass();
        $waybill->document = $data;
        $waybill->notes = 'notes';
        $waybill->title = 'ارسالية طريق الحرير';
        $template = 'waybill';
        $logo = '';
        $temp = new stdClass();
        $temp->template = $template;
        $temp->data = json_encode($waybill);
        $temp->type = 'silk_road_pdf';
        // call the remote endpoint
        $response = $this->curl($url,$temp,'POST');
        return $response;
    }




    // ------------------------------------------------------------------------------------------- //
    // ------------------ create ticket  ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function sendPDFToClient($pdf){

        $url = Config::$silk_road_base_url . 'pdf';

        $temp = new stdClass();
        $temp->pdf_content = $pdf;
        $temp->message_type = 'PDF';
        $temp->token = 'MY_TOKEN';

        // call the remote endpoint
        $response = $this->curl($url,$temp ,'POST');
        return $response;
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------ create ticket  ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function sendMessageToClient($msg){

        $url = Config::$silk_road_base_url . 'autocomlete';

        $temp = new stdClass();
        $temp->data = json_encode($msg);
        $temp->message_type = 'AUTOCOMPLETE_RESULT';
        $temp->token = 'MY_TOKEN';

        // call the remote endpoint
        $response = $this->curl($url,$temp ,'POST');
        return $response;
    }



    // ----------------------------------------------------------------------------------------- //
    // ------------------ call cURL request to CUSTOMER CARE end point ---------------------- //
    // ----------------------------------------------------------------------------------------- //
    private function curl($url,$fields,$method){

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 40);
        if($method =='POST'){
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
            curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));
        }
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'key: '. $this->getIntegrationToken(),
            'Accept: application/json'
        ));

        $result = curl_exec($ch);


        if (curl_errno($ch)) {
            throw new Exception(curl_error($ch) , curl_errno($ch));
        }

        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close ($ch);

        if($http_code != 200){
            throw new Exception("Error Processing Request : " . $result, 1);
        }

        $response = json_decode($result,1);
        if($response){
            return $response;
        }else{
            return $result;
        }
    }


}