<?php

require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once (dirname(__FILE__)."/../../core/tender/tender_core.php");
require_once (dirname(__FILE__)."/../location/location_core.php");
require_once (dirname(__FILE__)."/../../core/account/account_core.php");
require_once (dirname(__FILE__)."/../../core/voucher/voucher_core.php");
require_once (dirname(__FILE__)."/../../core/cargo/cargo_core.php");
require_once (dirname(__FILE__)."/../../core/outgoing_integration/merchant.php");

class WaybillDraftCore
{
    private $_locationCore;
    public function __construct()
    {
        DBConnection::getInstance();
        $this->_tenderCore = new TenderCore();
        $this->_locationCore = new LocationCore();
        $this->_voucherCore = new VoucherCore();
        $this->_cargoCore = new CargoCore();
        $this->_merchantIntegration = new MerchantIntegration();
    }

    // -------------------------------------------------------------------------------------------------- //
    // ------------------ create waybill draft  --------------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function createWaybillDraft($waybill = null, $user_id,$u_id)
    {
        try {

            // generate waybill document json from incoming data
            $waybill_json = $this->generateWaybillDraftDocument($waybill,$user_id);
            // insert waybill
            $sqlQuery = 'INSERT INTO waybill_draft 
            (tn,bond_number,trn,driver_phone,driver_nn,driver_name,document,update_by,status,tender_id) 
            values
            (?,?,?,?,?,?,?,?,?,?);';

            $params = [];
            $params[] = $waybill->tn;
            $params[] = $waybill->bond_number;
            $params[] = $waybill->trn;
            $params[] = $waybill->driver_phone;
            $params[] = $waybill->driver_nn;
            $params[] = $waybill->driver_name;
            $params[] = json_encode($waybill_json);
            $params[] = $u_id;
            $params[] = 'ONROAD';
            $params[] = $waybill->tender_id;
           

            //run 
            $waybillDraft = DBConnection::runBindDatabaseQuery($sqlQuery, $params);
            return $waybillDraft;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }
    // -------------------------------------------------------------------------------------------------- //
    // ------------------ create waybill draft  --------------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function closeWaybillDraft($waybill_draft_id = null,$loading_weight,$discharge_weight,$loading_weight_timestamp,$discharge_weight_timestamp)
    {
        try {

            //get waybill_draft
            $waybillDraftBean = $this->getWaybillDraft($waybill_draft_id);

            //status of waybill draft
            if($waybillDraftBean->status == 'COMPLETED'){
                throw new Exception('لا تستطيع المتابعة, حالة المستند مكتملة بالفعل');
            }

            $document= json_decode($waybillDraftBean->document);
            $cargo_node = $document->cargo[0];
            $cargo_node->weights->loading->net_weight = $loading_weight;
            $cargo_node->weights->discharge->net_weight = $discharge_weight;
            if($loading_weight_timestamp){
                $cargo_node->weights->loading->time_stamp = $discharge_weight_timestamp;
            }
            if($discharge_weight_timestamp){
                $cargo_node->weights->discharge->time_stamp = $discharge_weight_timestamp;
            }
            
            $document->cargo[0] = $cargo_node;
            $document = json_encode($document);

            // insert waybill
            $sqlQuery = "UPDATE waybill_draft SET status='CLOSED', document=? WHERE id = ?;";

            $params = [];
            $params[] = $document;
            $params[] = $waybill_draft_id;
            //run 
            $waybillDraft = DBConnection::runBindDatabaseQuery($sqlQuery, $params);
            return $waybillDraft;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------------------------------- //
    // ------------------ generate json  --------------------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function generateWaybillDraftDocument($waybill = null,$user_id)
    {
        
        // get the tender info
        $tenderBean = json_decode($this->_tenderCore->getTender($waybill->tender_id, 0));

        $waybill_json = new stdClass();
        //--------- Start the process of creating the jSON document ----------

        //------------------- operation type ----------------------
        $waybill_json->operation_type = new stdClass();
        $waybill_json->operation_type->code = $waybill->operation_type;

        // ------------------- Default contact person ----------------
        $waybill_json->default_contact_user_id = null;

        //------------------- Notes ----------------------
        $waybill_json->notes = new stdClass();
       
        // ------------------ cargo -----------------------
        $cargo_node = new stdClass();

        $cargo_Bean = $this->_cargoCore->getCargoBasic($waybill->cargo_id, 0);
        $cargo_node->cargo_id = $waybill->cargo_id;
        $cargo_node->cargo_unit = $tenderBean->manifest->cargo_unit ? $tenderBean->manifest->cargo_unit : "kg";
        $cargo_node->unit_weight = $tenderBean->manifest->unit_weight ? $tenderBean->manifest->unit_weight : "50";
        
        $cargo_node->cargo = new stdClass();
        $cargo_node->cargo->id = $waybill->cargo_id;
        $cargo_node->cargo->name = $cargo_Bean->name;
        $cargo_node->cargo->ct_id = $cargo_Bean->ct_id;
        $cargo_node->cargo->container = $cargo_Bean->container;
        $cargo_node->cargo->ct_id = $cargo_Bean->ct_id;
        $cargo_node->name = $cargo_Bean->name;
        if (isset($waybill->policy)) {
            $cargo_node->policy = $waybill->policy;
        }

        $cargo_node->consigner = new stdClass();
        $cargo_node->consigner->ca = new stdClass();
        
        $cargo_node->consigner->ca->id = $waybill->ca_id ? $waybill->ca_id : null;
        $cargo_node->consigner->ca->name = $waybill->ca_name ? $waybill->ca_name : null;

        $cargo_node->consigner->cargo_owner = new stdClass();
        $cargo_node->consigner->cargo_owner->id = 0;
        $cargo_node->consigner->cargo_owner->name = $cargo_Bean->waybill_template->cargo[0]->consigner->cargo_owner_id;
        $cargo_node->consigner->tc = new stdClass();
        $cargo_node->consigner->tc->id = $cargo_Bean->waybill_template->carrier[0]->tc_id;
        $cargo_node->consigner->tc->name = null;
        $cargo_node->consigner->tc->logo = null;
 
        // loading and discharge
        $cargo_node->weights = new stdClass();
        $cargo_node->weights->loading = new stdClass();
        $cargo_node->weights->discharge = new stdClass();
        $cargo_node->weights->loading->tare_weight = new stdClass();
        $cargo_node->weights->discharge->tare_weight = new stdClass();
        $cargo_node->weights->loading->gross_weight = new stdClass();
        $cargo_node->weights->discharge->gross_weight = new stdClass();
        $cargo_node->weights->loading->net_weight = $waybill->loading_weight;
        $cargo_node->weights->loading->time_stamp = $waybill->loading_weight_timestamp;
        $cargo_node->weights->loading->tare_weight->weight = null;
        $cargo_node->weights->loading->tare_weight->time_stamp = null;
        $cargo_node->weights->loading->tare_weight->location_id = null;
        $cargo_node->weights->loading->tare_weight->weighbridge_id = null;
        $cargo_node->weights->loading->gross_weight->weight = null;
        $cargo_node->weights->loading->gross_weight->time_stamp = null;
        $cargo_node->weights->loading->gross_weight->location_id = null;
        $cargo_node->weights->loading->gross_weight->weighbridge_id = null;
        $cargo_node->weights->discharge->net_weight = $waybill->discharge_weight;
        $cargo_node->weights->discharge->time_stamp = $waybill->discharge_weight_timestamp;
        $cargo_node->weights->discharge->tare_weight->weight = null;
        $cargo_node->weights->discharge->tare_weight->time_stamp = null;
        $cargo_node->weights->discharge->tare_weight->location_id = null;
        $cargo_node->weights->discharge->tare_weight->weighbridge_id = null;
        $cargo_node->weights->discharge->gross_weight->weight = null;
        $cargo_node->weights->discharge->gross_weight->time_stamp = null;
        $cargo_node->weights->discharge->gross_weight->location_id = null;
        $cargo_node->weights->discharge->gross_weight->weighbridge_id = null;
        $cargo_node->allowMultiTruckForCargo = null;

        $waybill_json->cargo = [$cargo_node];
     
        // ------------------ carrier -----------------------
        $carrier_node = new stdClass();
        $carrier_node->truck = new stdClass();
        $carrier_node->truck->id = null;
        $carrier_node->truck->tn = $waybill->tn;
        $carrier_node->trailer = new stdClass();
        $carrier_node->trailer->id = null;
        $carrier_node->trailer->tn = $waybill->trn;
    
        $carrier_node->driver = new stdClass();
        $carrier_node->driver->id = $waybill->driver_id;
        $carrier_node->driver->name = $waybill->driver_name;
        $carrier_node->driver->phone = $waybill->driver_phone;
        $carrier_node->driver->nn = $waybill->driver_nn;
        $carrier_node->truck_owner = new stdClass();
        $carrier_node->truck_owner->id = null;
        $carrier_node->truck_owner->name = null;
        $carrier_node->truck_owner->phone = null;
        $carrier_node->trailer_owner = new stdClass();
        $carrier_node->trailer_owner->id = null;
        $carrier_node->trailer_owner->name = null;
        $carrier_node->tc = new stdClass();
        $carrier_node->tc->id = null;
        $carrier_node->tc->name = null;
        $carrier_node->tc->logo = null;
        $carrier_node->tc->tc_owner_id = null;
     
        $waybill_json->carrier = [$carrier_node];

        // ----------------- waybill_captions ----------------
        $waybill_captions_node = new stdClass();
        $waybill_json->waybill_captions = $tenderBean->manifest->waybill_captions;

        // ----------------- negotiable_instructios ----------
        $negotiable_instructios_node = new stdClass();
        $negotiable_instructios_node->route = new stdClass();
        $negotiable_instructios_node->route->origin = new stdClass();
        $negotiable_instructios_node->route->destination = new stdClass();
        $negotiable_instructios_node->freight = new stdClass();
        $negotiable_instructios_node->special = new stdClass();
        $negotiable_instructios_node->insurance = new stdClass();
        $negotiable_instructios_node->dangerous_goods = new stdClass();
        $negotiable_instructios_node->route->origin->id = $waybill->origin_id;
        if($waybill->origin_id){
            $originBean = $this->_locationCore->getBasicLocation($waybill->origin_id,0);
            $negotiable_instructios_node->route->origin->name = $originBean->name;
        }
        $negotiable_instructios_node->route->remarks = null;
        $negotiable_instructios_node->route->destination->id = $waybill->destination_id;
        if($waybill->destination_id){
            $destinationBean = $this->_locationCore->getBasicLocation($waybill->destination_id,0);
            $negotiable_instructios_node->route->destination->name = $destinationBean->name;
        }
        $negotiable_instructios_node->freight->remarks = null;
        $negotiable_instructios_node->special->remarks = null;
        $negotiable_instructios_node->insurance->remarks = null;
        $negotiable_instructios_node->dangerous_goods->remarks = null;

        $waybill_json->negotiable_instructios = $negotiable_instructios_node;

        // --------------------------- Tender -------------------
        $tender_node = new stdClass();
        $man = $this->_tenderCore->getTenderManifest($waybill->tender_id, 0);
        $tender_node->id = $waybill->tender_id;
        $tender_node->name = $man['name'];
        $waybill_json->tender = $tender_node;

        // --------------------------- Tender -------------------
        $integration_node = new stdClass();
        $integration_node->bond = $waybill->bond;
        $waybill_json->integration_details = $integration_node;

        // ----------------- ltrc section -------------------------
        if($man['ltrc']['submit_waybill']){
            $ltrc_node = new stdClass();
            $ltrc_node->docnum = null;
            $ltrc_node->submit_waybill = false;
            $ltrc_node->waybill_status = null;
            $waybill_json->ltrc = $ltrc_node;
        }
      
        // ---------------- payment_delay --------------------------
        $payment_delay = new stdClass();
        $waybill_json->payment_delay = $payment_delay;

        $order_node = new stdClass();
        $order_node->id = null;
        $waybill_json->order = $order_node;
        // ----------------------generate Freight Node ------------------------//
        try {
            $freightNode = $this->createFreightNode();
            $routeWageCore = new routeWageCore();
            // search route wage
            $routeWage =  $routeWageCore->searchWageForFreight(
                $waybill->tender_id,
                $waybill->origin_id,
                $waybill->destination_id,
                $waybill->cargo_id,
                $waybill->loading_weight_timestamp,
                'receivable'
            );
            $freightNode->route_wage = $routeWage;

            $waybill_json->freight = $freightNode;
        } catch (Exception $e) {
        }

        if ($waybill->service_code) {
            $waybill_json->services = [
                [
                    "service_code" => $waybill->service_code,
                    "service_name" => $waybill->service_name,
                    "service_price" => $waybill->service_price,
                    "service_insurance" => $waybill->service_insurance
                ]
            ];
        }

        $waybill_json->activities = [];
        return  $waybill_json;
    }


    // ------------------------------------------------------------------------------- //
    // -------------------- Create Empty freight Node -------------------------------- //
    // ------------------------------------------------------------------------------- //
    public function createFreightNode()
    {

        $amount = (object) array(
            "base_amount" => null,  // caculated based on discharge weight * price per ton
                                  "net_amount"=>null,  // total amount of payments
                                  "tips"=>null,          // tips if exist
                                  "tips_remarks"=>null,          // tips remarks if exist

                                  "loss_fine"=> null,
                                  "loss_in_kg"=> null,
                                  "tolerance_in_kg"=> null,
                                  "loss_fine_per_kg"=> null,
                                  "total_fines"=> null,

                                  "total_advance_payment" => 0,
                                  "total_deductions" => 0
                                  );
        $payments = [];
        $cargo_info = (object) array ("loading_weight"=>null, "discharged_weight"=> null);
        $route_wage = null;
        $trx_error_logs = [];
        $trx_logs = [];

        $freight_json =  (object) array(
            "amount" => $amount,
                                        "payments"=>$payments,
                                        "cargo_info"=>$cargo_info,
                                        "trx_error_logs"=>$trx_error_logs,
                                        "trx_logs"=>$trx_logs,
            "route_wage" => $route_wage
        );

        return $freight_json;
    }


        // ------------------------------------------------------------------------- //
    // ----------------- generate waybill payment json node  ------------------- //
    // ------------------------------------------------------------------------- //
    public function addWaybillPaymentNode($waybillBean, $payment)
    {

        // add the advance payment to payment section in json
        // push the new payment if it is not exist before
        $has_payment = false;

        $waybill_json = $waybillBean->document;
        $waybill_json->freight = $waybillBean->document->freight;
        $existingPayments = $waybill_json->freight->payments;

        foreach ($existingPayments as $old_payments) {
            if($old_payments->name == $payment->name){
                $has_payment = true;
            }
        }
        if($has_payment)return;
            array_push($existingPayments,$payment);        
            $waybill_json->freight->payments = $existingPayments;

            // update the waybill document (payments)
            $waybillBean->document = $waybill_json;
            // insert waybill
            $sqlQuery = "UPDATE waybill_draft SET document=? WHERE id = ?;";

            $params = [];
            $params[] = json_encode($waybill_json);
            $params[] = $waybillBean->id;
            //run 
            DBConnection::runBindDatabaseQuery($sqlQuery, $params);
        }


    // -------------------------------------------------------------------------------------------------- //
    // ------------------ get waybill draft  --------------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function getWaybillDraft($waybill_id = null)
    {
        try {

            $query = "Select
                        id,
                        bond_number,
                        tn,
                        trn,
                        driver_phone,
                        driver_nn,
                        driver_name,
                        CAST(`document` AS CHAR CHARSET UTF8) AS document,
                        tender_id,
                        status,
                        create_date,
                        update_date,
                        update_by
                        FROM waybill_draft where id = ?";

            $params = [$waybill_id];
            //run 
            $waybillDraft = DBConnection::runBindDatabaseQuery($query, $params);
            if(sizeof($waybillDraft) > 0){
                return $waybillDraft[0];
            }
            return null;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------------------------------- //
    // ------------------ get waybill draft  --------------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function searchLastWaybillDraft()
    {
        try {

            $query = "SELECT
                        id,
                        bond_number,
                        tn,
                        trn,
                        driver_phone,
                        driver_nn,
                        driver_name,
                        CAST(`document` AS CHAR CHARSET UTF8) AS document,
                        tender_id,
                        status,
                        create_date,
                        update_date,
                        update_by
            FROM waybill_draft order by id desc limit 1";
            //run 
            $waybillDraft = DBConnection::runBindDatabaseQuery($query, []);
            if(sizeof($waybillDraft) > 0){
                return $waybillDraft[0];
            }
            return null;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------------------------------- //
    // ------------------ get waybill draft  --------------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function autoCompleteForTN($tn = null)
    {
        try {

            $query = "SELECT id,
                        bond_number,
                        tn,
                        trn,
                        driver_phone,
                        driver_nn,
                        driver_name,
                        CAST(`document` AS CHAR CHARSET UTF8) AS document,
                        tender_id,
                        status,
                        create_date,
                        update_date,
                        update_by
                    FROM waybill_draft
                    where tn = ? and status in ('ONROAD','CLOSED') order by id desc";

            $params = [$tn];
            //run 
            $waybill_drafts = DBConnection::runBindDatabaseQuery($query, $params);
            if (sizeof($waybill_drafts) > 0) {
                return $waybill_drafts[0];
            }
            return null;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------------------------------------------------------- //
    // ------------------ get waybill draft  --------------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function autoCompleteForDriverPhone($phone = null)
    {
        try {

            $query = "SELECT
                        id,
                        bond_number,
                        tn,
                        trn,
                        driver_phone,
                        driver_nn,
                        driver_name,
                        CAST(`document` AS CHAR CHARSET UTF8) AS document,
                        tender_id,
                        status,
                        create_date,
                        update_date,
                        update_by
                    FROM waybill_draft
                    where driver_phone = ? and status in ('ONROAD','CLOSED') order by id desc";

            $params = [$phone];
            //run 
            $waybill_drafts = DBConnection::runBindDatabaseQuery($query, $params);
            if (sizeof($waybill_drafts) > 0) {
                return $waybill_drafts[0];
            }
            return null;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------------------------------------------------------- //
    // ------------------ get waybill draft  --------------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function autoCompleteForNN($nn = null)
    {
        try {

            $query = "SELECT id,
                bond_number,
                tn,
                trn,
                driver_phone,
                driver_nn,
                driver_name,
                CAST(`document` AS CHAR CHARSET UTF8) AS document,
                tender_id,
                status,
                create_date,
                update_date,
                update_by
             FROM waybill_draft where driver_nn = ? and status in ('ONROAD','CLOSED') order by id desc;";
            $params = [$nn];
            //run 
            $waybill_drafts = DBConnection::runBindDatabaseQuery($query, $params);
            if (sizeof($waybill_drafts) > 0) {
                return $waybill_drafts[0];
            }
            return null;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------------------------------- //
    // ------------------ get waybill draft  --------------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function autoCompleteForBondNumber($bond_number ,$tender_id= null)
    {
        try {

            $query = "SELECT
                        id,
                        bond_number,
                        tn,
                        trn,
                        driver_phone,
                        driver_nn,
                        driver_name,
                        CAST(`document` AS CHAR CHARSET UTF8) AS document,
                        tender_id,
                        status,
                        create_date,
                        update_date,
                        update_by
                    FROM
                        waybill.waybill_draft
                    where bond_number = ? and tender_id= ? and status in ('ONROAD','CLOSED','COMPLETED') order by id desc";

            $params = [$bond_number,$tender_id];
            //run 
            $waybill_drafts = DBConnection::runBindDatabaseQuery($query, $params);
            if (sizeof($waybill_drafts) > 0) {
                return $waybill_drafts;
            }
            return null;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------------------------------------------- //
    // ---------------------- complete waybill and process its financial procedure ------------------------------------ //
    // ------------------------------------------------------------------------------------------------------------- //
    public function completeWaybillDraft($waybill_draft_id, $cash_account_id, $company_id, $delay_days, $user_id)
    {

        // init objects
        $paymentAgentCore = new PaymentAgentCore();
        $paymentCore = new PaymentCore();
        $routeWageCore = new RouteWageCore();
        $waybillBean = $this->getWaybillDraft($waybill_draft_id);
        $waybillBean->document= json_decode($waybillBean->document);
        $waybillBean->destination_id = $waybillBean->document->negotiable_instructios->route->destination->id;
        $waybillBean->cash_box_id = $cash_account_id;

        //check the status of waybill_draft
        if($waybillBean->status == 'COMPLETED'){
            //throw new Exception('لا تستطيع المتابعة, المستند مكتمل');
        }

        // get the tender manifest
        $man = $this->_tenderCore->getTenderManifest($waybillBean->tender_id, 0);

        // search route wage
        $routeWage =  $routeWageCore->searchWageForFreight(
            $waybillBean->tender_id,
            $waybillBean->document->negotiable_instructios->route->origin->id,
            $waybillBean->document->negotiable_instructios->route->destination->id,
            $waybillBean->document->cargo[0]->cargo_id,
            $waybillBean->document->cargo[0]->weights->loading->time_stamp,
            'receivable'
        );

  
        // freight node
        $freight_node = $paymentCore->calculateFreight($waybillBean,null,null,$routeWage);
        $total_deductions = 0;

        // for phosphate project , add late fine
        if($delay_days && intval($delay_days) > 0){
            $freight_node->amount->total_fines = intval($delay_days * 10);
            $freight_node->amount->net_amount = doubleVal($freight_node->amount->net_amount - intval($delay_days * 10));
            $freight_node->amount->net_amount = number_format((float)$freight_node->amount->net_amount, 3, '.', '');
            // add to deduction
            $total_deductions += $freight_node->amount->total_fines;
        }

        //validate the creation on voucher
        $vouchersFilter = [
            ['key' => 'trx_template', 'val' => '"' . $waybill_draft_id . '"', 'op' => 'json unquote', 'node' => '$.waybill_draft_ref_id'],
            ['key' => 'status', 'val' => ['REVOKED'], 'op' => 'not in']
        ];
        $vouchers = $this->_voucherCore->searchVouchers(
            $vouchersFilter,
            100,
            0,
            $_SESSION['user_id'],
            null
        );

        if (sizeof($vouchers->data) > 0) {
            $vouchers_amount = 0;
            foreach ($vouchers->data as $voucher) {
                $vouchers_amount += $voucher->amount;
            }
            if ($vouchers_amount >= $freight_node->amount->base_amount) {
                throw new Exception('لا يمكنك المتابعة, المبالغ المصروفة أكثر من المستحقات');
            }
        }

        // save the waybill payment info in waybill doc
        $waybillBean->document->freight->amount = $freight_node->amount;
        $waybillBean->document->freight->deductions = $freight_node->deductions;

        //update the waybillBean with the company_id that completed the waybill
        $paFilter = [
            ['key' => 'company_id', 'val' => $company_id],
                     ['key'=>'status','val' =>['ACTIVE','NEW'], 'op'=>'in' ]
                    ];
        $pa_qry = $paymentAgentCore->searchPaymentAgents($paFilter, 1, 0, 0);
        if($pa_qry->found_rows == 0){
            throw new Exception(" لاتستطيع المتابعة، لا يوجد مكتب صرف معرف على حسابك");
        }

        $waybillBean->document->freight->pa = new stdClass();
        $waybillBean->document->freight->pa->id = $pa_qry->data[0]->id;
        $waybillBean->document->freight->pa->company_id = $pa_qry->data[0]->company_id;
        $waybillBean->document->freight->pa->company_name = $pa_qry->data[0]->name;

        $sqlQuery = "UPDATE waybill_draft SET document=?, status=? WHERE id = ?;";

        $params = [];
        $params[] = json_encode($waybillBean->document);
        $params[] = 'COMPLETED';
        $params[] = $waybillBean->id;
        //run 
        DBConnection::runBindDatabaseQuery($sqlQuery, $params);
        // ------------------------ complete waybill Payment  ------------------------------- //

        // take the payment method from the tender
        $payment_method = $man['freight']['payment_method']['method'];

        // if no payment method is defined , throw exception
        if(!$payment_method){
            throw new Exception("لا تستطيع المتابعة ، لم يتمكن النظام من تحديد اليه تسديد المستند");
        }

        // Method 1: (jv_payment_agent) pay the amount by jv ledger
        if($payment_method == "jv_payment_agent"){
            // create voucher for this payment
            
            $value = new stdClass();
            $advanced_payment = 0;
            if($waybillBean->document->freight && $waybillBean->document->freight->payments){
                foreach($waybillBean->document->freight->payments as $payment){
                    if ($payment->name == 'PERSONAL_PAYMENT'){
                        $advanced_payment =$payment->value->amount;
                    }
                }
            }

            // build remarks
            $remarks =  ' صرف مستحقات  للسائق '. $waybillBean->driver_name .
                        ' - رقم وطني '. $waybillBean->driver_nn .
                        ' - رقم هاتف '. $waybillBean->driver_phone .
                        ' - الشاحنة رقم : ' . $waybillBean->tn .
                        ' - رقم الارسالية : ' . $waybillBean->bond_number ;

            $value->amount = ($freight_node->amount->base_amount - $freight_node->amount->total_deductions - $advanced_payment -$freight_node->amount->total_fines );
            $value->amount = number_format((float)$value->amount, 3, '.', '');

            if($value->amount < 0){
                throw new Exception("لا تستطيع المتابعة قيمة أمر الصرف أقل من 0");                
            }
              
            $advancePaymentNode = (object) array("name"=>"PERSONAL_PAYMENT",
                                            "label"=>$remarks,
                                            "target_account"=>$target_account,
                                            "time_stamp" => DBConnection::getSystemDate(),
                                            "value"=>$value);

            // for export phosphate
            if($waybillBean->tender_id == 19){
                $ref_code = "WAYBILL_DRAFT_EXPORT_PHOSPHATE_COMPLETED";
                $payment_account = $cash_account_id;
                // $payment_account = "777412-30005";
                $target_account = "777412-60003";
            }else{
                $ref_code  = "WAYBILL_DRAFT";
                //$payment_account = $man['freight']['payment_accounts'][0]['account_id'] . "-" . $man['freight']['payment_accounts'][0]['account_sub_id'];            
                $payment_account =  $cash_account_id;
                $target_account = "777412-60001";
            }

            $accountCore = new AccountCore();
            $payment_account_bean = $accountCore->getAccountBasic($payment_account,0);
            if($payment_account_bean && $payment_account_bean->payment_channel && $payment_account_bean->payment_channel[0]){
                $voucher_payment_method = strtoupper($payment_account_bean->payment_channel[0]);
            }
            if(!$voucher_payment_method){
                $voucher_payment_method = "CASH";
            }

            $voucher_type = 'WAYBILL_COMPLETE';
            $personal_voucher_id = $this->createVoucher(
                $payment_account,
                $target_account,
                $value->amount,           
                $voucher_payment_method ,
                $advancePaymentNode,
                null,
                $ref_code,
                $waybillBean->id, 
                $remarks,
                $waybillBean->tender_id, 
                "silk_road_voucher",
                ['voucher_type' => $voucher_type]
            );


            $accounts = $man['freight']['accounts'];
            foreach ($accounts as $acc) {
                if($acc['code'] == 'ledger_account'){
                    $ledger_account_id = $acc['account'];           
                }
            }

            $base_amount = $freight_node->amount->base_amount;
            $net_amount = $freight_node->amount->net_amount;
            $advanced_payment = $freight_node->amount->total_advance_payment;
            $total_deductions = $freight_node->amount->total_deductions;
            $total_fines = $freight_node->amount->total_fines;
            foreach ($freight_node->deductions as $d) {
                $total_deductions += $d['value']['amount'];
            }
            $total_deductions += doubleVal($freight_node->amount->total_fines);

            if($waybillBean->tender_id == 19){

                $ledger_account_id = 777412;               

                // dont log trx in case of debit account
                if($payment_account != "777412-30003"){

                    $claim_account_id = "777412-20436";
                    $remarks = " الشاحنة رقم: $waybillBean->tn - السائق: $waybillBean->driver_name - رقم وطني: $waybillBean->driver_nn - ارسالية: $waybillBean->bond_number";

                    $jv_id = $paymentCore->logCompleteVoucherTrx($net_amount,$base_amount,$advanced_payment, $total_deductions , $total_fines,
                                                                 $ledger_account_id ,$cash_account_id ,$claim_account_id,
                                                                 null, $remarks, $waybillBean->tender_id ,$_SESSION['user_id']);
                }
            }else{
                $claim_account_id = "777412-20436"; //  hard coded
                $remarks = " الشاحنة رقم: $waybillBean->tn - السائق: $waybillBean->driver_name - رقم وطني: $waybillBean->driver_nn - ارسالية: $waybillBean->bond_number";
                $jv_id = $paymentCore->logCompleteVoucherTrx($net_amount,$base_amount,$advanced_payment, $total_deductions , $total_fines,
                                                             $ledger_account_id ,$cash_account_id ,$claim_account_id,
                                                             null, $remarks, $waybillBean->tender_id ,$_SESSION['user_id']);
            }


            // if the payment is from debit account (ex: Go Gas Station, change statue to PENDING not COMPLETE)
            if($payment_account == "777412-30003"){
                $voucherBean = $this->_voucherCore->getVoucherBasic($personal_voucher_id, 0);
                $voucherBean->status = "PENDING";
                $this->_voucherCore->updateVoucherInfo($voucherBean,$personal_voucher_id, 0);
            }else{
                // complete it
                $voucherBean = $this->_voucherCore->getVoucherBasic($personal_voucher_id, 0);
                $voucherBean->jv_id = $jv_id;
                $voucherBean->payment_date = DBConnection::getSystemDate();
                $voucherBean->status = "COMPLETE";
                $this->_voucherCore->updateVoucherInfo($voucherBean,$personal_voucher_id, 0);
            }

            return $personal_voucher_id;
        }else{
            throw new Exception("لا تستطيع المتابعة ، لم يتمكن النظام من تحديد اليه تسديد المستند");
        }
    }

    // -------------------------------------------------------------------------------------------------- //
    // ------------------ update waybill draft  --------------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function updateWaybillDraft($document, $waybill_draft_id)
    {

        try {
            $updateWaybillDraftQuery = "update waybill_draft set document = ? where id = ?";
            $params = [$document,  $waybill_draft_id];

            //run
            DBConnection::runBindDatabaseQuery($updateWaybillDraftQuery, $params);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ---------------------------------------------------------------------------- //
    // -------------------- create new voucher ------------------------------------ //
    // ---------------------------------------------------------------------------- //
    public function createVoucher($from_account, $target_account, $amount,
                                  $payment_method, $payment, $due_date,
                                  $ref_code, $ref_id, $remarks, $tender_id, $template = null, $note = null)
    {

        if (!$from_account) {
            throw new Exception("Invalid account ID in from_account, $from_account");
        }
        if (!$target_account) {
            throw new Exception("Invalid account ID in to_account, $target_account");
        }

        // get accounts bean
        $accountCore = new AccountCore();
        $fromAccountBean = $accountCore->getAccountBasic($from_account,0);
        $targetAccountBean = $accountCore->getAccountBasic($target_account,0);
        if(!$payment_method){
            throw new Exception("لا تستطيع المتابعة ، لم يتم تحديد اّلية الدفع");            
        }


        if($tender_id){
            $tenderCore = new TenderCore();
            $man = $tenderCore->getTenderManifest($tender_id, 0);
            if($template){
              $voucher_template = $template;
            }else{
                $voucher_template = $man['voucher_template'];
            }
        }
        $refcode_vouchertype_map = [
            'WAYBILL' => 'WAYBILL_COMPLETE',
            'WAYBILL_DRAFT_EXPORT_PHOSPHATE_COMPLETED' => 'WAYBILL_COMPLETE',
            'WAYBILL_DRAFT_EXPORT_PHOSPHATE_DISEL' => 'DIESEL_DOWNPAYMENT',
            'WAYBILL_DRAFT_EXPORT_PHOSPHATE_PERSONAL' => 'CASH_DOWNPAYMENT',
            'TIPS' => 'TIPS',
            'WAYBILL_DRAFT' => $tender_id === 18 ? 'TIPS' : 'WAYBILL_COMPLETE',
        ];

        $oldref_newref_map = [
            'WAYBILL' => 'WAYBILL_COMPLETE',
            'WAYBILL_DRAFT_EXPORT_PHOSPHATE_COMPLETED' => 'WAYBILL_DRAFT',
            'WAYBILL_DRAFT_EXPORT_PHOSPHATE_DISEL' => 'WAYBILL_DRAFT',
            'WAYBILL_DRAFT_EXPORT_PHOSPHATE_PERSONAL' => 'WAYBILL_DRAFT',
            'TIPS' => 'TIPS',
            'WAYBILL_DRAFT' => 'WAYBILL_DRAFT'
        ];
        $voucher_type = $refcode_vouchertype_map[$ref_code];
        $new_ref_code = $oldref_newref_map[$ref_code];
        // prepare trx_template
        $trx_template = new stdClass();
        $trx_template->from_account = $from_account;
        $trx_template->from_account_name = $fromAccountBean->name;
        $trx_template->target_account = $target_account;
        $trx_template->target_account_name = $targetAccountBean->name;
        $trx_template->amount = $amount;
        $trx_template->phone = null;
        $trx_template->ref_code = $new_ref_code;
        $trx_template->waybill_draft_ref_id = "$ref_id";
        $trx_template->ref_id = "$ref_id";
        $trx_template->payment = $payment;
        $trx_template->tender_id = $tender_id;
        $trx_template->voucher_type = $voucher_type;

        // calcualate payment commison if exists and insert
        if($fromAccountBean->payment_commission){
            foreach ($fromAccountBean->payment_commission as $com) {
                if($amount >= $com->interval->min && ( !$com->interval->max || $amount < $com->interval->max)){
                    $trx_template->payment_commission = $com->value;
                }
            }
        }

        // prepare voucher bean
        $voucherBean = new stdClass();
        $voucherBean->trx_template = $trx_template;
        $voucherBean->payment_method = $payment_method;
        $voucherBean->notes = $remarks;
        $voucherBean->system_code = $voucher_template;

        if($due_date){
            $voucherBean->due_date = $due_date;
        }else{
            $voucherBean->due_date = DBConnection::getSystemDate();
        }

        $voucherBean->status = 'NEW';

        // create Database record
        $createVoucherResult = DBConnection::insertDB("voucher",$voucherBean,0);
        $voucherProcessMode = "AUTO";
        $voucher_id = $createVoucherResult[0]['@id'];
        return $voucher_id;
    }


    // -------------------------------------------------------------------------------------------------- //
    // ------------------ get waybill draft  ------------------------------------------------------------ //
    // -------------------------------------------------------------------------------------------------- //
    public function changeStatus($waybill_id = null,$new_status)
    {
        try {
            $query = "UPDATE waybill_draft set status='$new_status' where id = ?;";
            $params = [$waybill_id];
            //run
            $waybillDraft = DBConnection::runBindDatabaseQuery($query, $params);
                return $waybillDraft;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------------------------------------------------------------ //
    // ------------------  Revoke the voucher associated with the draft then reverse the trx , then change status of ---------------- //
    // ------------------  the draft to closed in order to change the loading and the discharge weight ------------------------------ //
    // ------------------------------------------------------------------------------------------------------------------------------ //
    public function revokeWaybillDraft($waybill_id , $user_id){

        // init
        $paymentCore = new PaymentCore();

        // get draft bean
        $waybillBean = $this->getWaybillDraft($waybill_id);

        // get all vouchers associated with the draft
        $vouchersFilter = [
            ['key' => 'trx_template', 'val' => '"' . $waybill_id . '"', 'op' => 'json unquote', 'node' => '$.waybill_draft_ref_id'],
            ['key' => 'status', 'val' => ['REVOKED'], 'op'=>'not in']
        ];
        $vouchers = $this->_voucherCore->searchVouchers($vouchersFilter,100,0,$user_id,null);

        // reverse trx of the all vouchers
        foreach ($vouchers->data as $voucher) {

            // get JV of voucher
            $jv_id = $voucher->jv_id;

            if($jv_id){

                $voucherBasicBean = $this->_voucherCore->getVoucherBasic($voucher->id,0);

                //if the voucher payment method == "EXTERNAL_DEBIT" , throw Exception
                if($voucher->payment_method == "EXTERNAL_DEBIT"){
                    throw new Exception("لا تستطيع المتابعة ، يوجد ذمة خارجية على الوصل");
                }

                //if the voucher is DIESEL_DOWNPAYMENT , return the copoun status to ACTIVE
                if($voucherBasicBean->trx_template->payment->name == "DISEL_PAYMENT"){
                    if($voucherBasicBean->integration_details && $voucherBasicBean->integration_details->activity ){
                        $couponNumber  = $voucherBasicBean->integration_details->activity[0]->ref_id;
                        if($couponNumber){
                            $result = $this->_merchantIntegration->changeStatus('ACTIVE',$couponNumber);                            
                        }
                    }
                }

                // get all trx for this jv
                $jv_trx = $this->_voucherCore->getJvTrx($jv_id);
                // generate trx JSON by reversing each trx
                $reverse_trx = [];
                foreach ($jv_trx as $trx) {
                    $temp = new stdClass();
                    $temp->amount =  $trx->amount;
                    $ledger_account_id =  $trx->account_id;
                    $temp->account = $trx->account_id . "-" . $trx->sub_id;
                    if($trx->op == 'C') $temp->op = 'D';
                    if($trx->op == 'D') $temp->op = 'C';
                    $temp->notes =  "عكس الحركة رقم " . $trx->id . " للشاحنة رقم  " . $waybillBean->tn . " ارسالية رقم  " . $waybillBean->bond_number;

                    $reverse_trx[] = $temp;
                }

                // insert trx
                $jv_date = DBConnection::getSystemDate();
                $remarks = "عكس حركات أمر الصرف " . $voucher->id;
                $paymentCore->addJV($ledger_account_id, $jv_date, $reverse_trx , $remarks, $user_id);
            }

            // revoke voucher
            $voucher_id = $voucher->id;
            $updateStruct = new stdClass();
            $updateStruct->id = $voucher_id;
            $updateStruct->jv_id = null;
            $updateStruct->status = 'REVOKED';
            DBConnection::updateDB("voucher", $updateStruct, $user_id);

        }

        if($waybillBean->tender_id == 17 || $waybillBean->tender_id == 19){
            // clear loading,discharge weights, and advanced_payment  in draft
            $document= json_decode($waybillBean->document);
            $cargo_node = $document->cargo[0];
            $cargo_node->weights->loading->net_weight = null;
            $cargo_node->weights->loading->time_stamp = null;
            $cargo_node->weights->discharge->net_weight = null;
            $cargo_node->weights->discharge->time_stamp = null;
            $document->cargo[0] = $cargo_node;
            $route_wage_node = $document->freight->route_wage;
            $freight_node = $this->createFreightNode();
            $freight_node->route_wage = $route_wage_node;
            $document->freight = $freight_node;
            $document = json_encode($document);

            // update waybill
            $sqlQuery = "UPDATE waybill_draft SET document=?,status='NEW' WHERE id = ?;";
            $params = [];
            $params[] = $document;
            $params[] = $waybill_id;
            $waybillDraft = DBConnection::runBindDatabaseQuery($sqlQuery, $params);
        }

        //Injaz tender
        if($waybillBean->tender_id == 18){
            // change status of the draft to INACTIVE
            $this->changeStatus($waybill_id,'INACTIVE');
        }
    }


        // -------------------------------------------------------------------------------------------------- //
    // ------------------ create Injaz waybill draft  --------------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function createInjazWaybillDraft($waybill = null, $user_id,$u_id)
    {

        try {

            // generate waybill document json from incoming data
            $waybill_json = $this->generateInjazWaybillDraftDocument($waybill,$user_id);
            // insert waybill
            $sqlQuery = 'INSERT INTO waybill_draft
            (tn,bond_number,trn,driver_phone,driver_nn,driver_name,document,update_by,status,tender_id)
            values
            (?,?,?,?,?,?,?,?,?,?);';

            $params = [];
            $params[] = $waybill->tn;
            $params[] = $waybill->bond_number;
            $params[] = null;
            $params[] = $waybill->driver_phone;
            $params[] = $waybill->driver_nn;
            $params[] = $waybill->driver_name;
            $params[] = json_encode($waybill_json);
            $params[] = $u_id;
            $params[] = 'COMPLETED';
            $params[] = $waybill->tender_id;

            //run
            $waybillDraft = DBConnection::runBindDatabaseQuery($sqlQuery, $params);
            return $waybillDraft;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }
    // -------------------------------------------------------------------------------------------------- //
    // ------------------ generate json  --------------------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function generateInjazWaybillDraftDocument($waybill = null,$user_id)
    {
        // get the tender info
        $tenderBean = json_decode($this->_tenderCore->getTender($waybill->tender_id, 0));

        $waybill_json = new stdClass();
        //--------- Start the process of creating the jSON document ----------

        $cargo_node = new stdClass();
        $cargo_node->container = $waybill->container_number;
        $cargo_node->secContainerNumber = $waybill->secContainerNumber;
        $cargo_node->clearing_agent = $waybill->clearing_agent;
        $cargo_node->clearing_agent_name = $waybill->clearing_agent_name;
        $cargo_node->cargo_type = $waybill->cargoType;
        $waybill_json->cargo = [$cargo_node];
        //------------------- operation type ----------------------
        $waybill_json->operation_type = new stdClass();
        $waybill_json->operation_type->code = $waybill->operation_type;
        //------------------- Notes ----------------------
        $waybill_json->notes = new stdClass();
        $waybill_json->notes->text = $waybill->notes;

        // ------------------ carrier -----------------------
        $carrier_node = new stdClass();
        $carrier_node->truck = new stdClass();
        $carrier_node->truck->id = null;
        $carrier_node->truck->tn = $waybill->tn;
        $carrier_node->trailer = new stdClass();
        $carrier_node->trailer->id = null;
        $carrier_node->trailer->tn = null;
        $carrier_node->driver = new stdClass();
        $carrier_node->driver->id = $waybill->driver_id;
        $carrier_node->driver->name = $waybill->driver_name;
        $carrier_node->driver->phone = $waybill->driver_phone;
        $carrier_node->driver->nn = $waybill->driver_nn;
        $carrier_node->company = new stdClass();
        $carrier_node->company->id = $waybill->company_id;

        $waybill_json->carrier = [$carrier_node];

        // ----------------- waybill_captions ----------------
        $waybill_captions_node = new stdClass();
        $waybill_json->waybill_captions = $tenderBean->manifest->waybill_captions;

        // --------------------------- Tender -------------------
        $tender_node = new stdClass();
        $man = $this->_tenderCore->getTenderManifest($waybill->tender_id, 0);
        $tender_node->id = $waybill->tender_id;
        $tender_node->name = $man['name'];
        $waybill_json->tender = $tender_node;

        // --------------------------- Tender -------------------
        $integration_node = new stdClass();
        $integration_node->attachment = null;
        if($waybill->voucher_photo_url){
            $integration_node->attachment = new stdClass();
            $integration_node->attachment->code = 'VOUVHER';
            $integration_node->attachment->voucher_photo_url = $waybill->voucher_photo_url;
        }
        $integration_node->voucher = null;
        $integration_node->bond_number = $waybill->bond_number;
        $waybill_json->integration_details = $integration_node;


        // ---------------- payment_delay --------------------------
        $order_node = new stdClass();
        $order_node->id = null;
        $waybill_json->order = $order_node;
        // ----------------------generate Freight Node ------------------------//
        $freight_node = $this->createFreightNode();
        $freight_node->amount->base_amount = $waybill->amount;
        $freight_node->amount->net_amount = $waybill->amount;
        $waybill_json->freight = $freight_node;
        $waybill_json->activities = [];
        return  $waybill_json;
    }

        // -------------------------------------------------------------------------------------------------- //
    // ------------------ generate json  --------------------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function searchWaybillDraft($filter = null,$allowed_tenders=null,$limit,$offset)
    {

        $sqlQuery = "Select
                        id,
                        bond_number,
                        tn,
                        trn,
                        driver_phone,
                        driver_nn,
                        driver_name,
                        CAST(`document` AS CHAR CHARSET UTF8) AS document,
                        tender_id,
                        status,
                        create_date,
                        update_date,
                        update_by
            FROM waybill_draft
        where status != 'INACTIVE'";
        $params = [];
        if($allowed_tenders){
            $sqlQuery .= " and tender_id in ($allowed_tenders) ";
            $params[] = $allowed_tenders;
        }

        //prepare filter
        if($filter){
            if(gettype($filter) == "string"){
                $filter = json_decode($filter, true);
            }
            foreach ($filter as $key => $value) {

                if($key =='date_from'){
                    $sqlQuery .=" AND create_date >= '$value' ";
                }
                elseif($key =='date_to'){
                    $sqlQuery .=" AND create_date < '$value' ";
                }
                elseif($key =='status not in'){
                    $sqlQuery .=" AND status not in ('" . $value . "')"; 
                }
                elseif($key == "cargo_ids"){
                    $sqlQuery .=" AND document->>'$.cargo[0].cargo.id'  in (" . $value . ")"; 
                }
                else{
                    $sqlQuery .=" AND $key='$value'";
                }
                $params[] = $value;
            }
        }

        $sqlQuery .= " order by id desc";
        $sqlQuery .= " limit $limit";
        if($offset){
            $sqlQuery .= " offset $offset";
        }
      
        //run
        $waybillDraft = DBConnection::runBindDatabaseQuery($sqlQuery, $params);

        return $waybillDraft;
            }


    // -------------------------------------------------------------------------------------------------- //
    // ------------------ get waybill draft  ------------------------------------------------------------ //
    // -------------------------------------------------------------------------------------------------- //
    public function updateInjazWaybillDraftAttachment($waybill_id = null,$img_url)
    {
        try {
            // get draft bean
            $waybillBean = $this->getWaybillDraft($waybill_id);
            // clear loading,discharge weights, and advanced_payment  in draft
            $document= json_decode($waybillBean->document);
            $integration_details = $document->integration_details;
            $integration_details->attachment = new stdClass();
            $integration_details->attachment->code = 'VOUCHER';
            $integration_details->attachment->voucher_photo_url = $img_url;
            $document->integration_details = $integration_details;
            $document = json_encode($document);

            // update waybill
            $sqlQuery = "UPDATE waybill_draft SET document=? WHERE id = ?;";
            $params = [];
            $params[] = $document;
            $params[] = $waybill_id;
            $waybillDraft = DBConnection::runBindDatabaseQuery($sqlQuery, $params);
            return $waybillDraft;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------------------------------- //
    // ------------------ update loading info  --------------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function updateLoadingInfo($data,$waybill_draft)
    {
        // get draft bean
        $sqlQuery = "UPDATE waybill_draft SET document = JSON_SET(document, '$.cargo[0].weights.loading.time_stamp', :loading_date,
                                                                            '$.cargo[0].weights.loading.net_weight', :loading_weight,
                                                                            '$.cargo[0].weights.discharge.time_stamp', :discharge_date,
                                                                            '$.cargo[0].weights.discharge.net_weight', :discharge_weight
                                                                            )
                                                                            WHERE id = :waybill_draft_id;";

        $doc = json_decode($waybill_draft->document);

        $params = [
            'waybill_draft_id' => $data->waybill_draft_id,
            'loading_weight' => $data->loading_weight ? $data->loading_weight :$doc->cargo[0]->weights->loading->net_weight,
            'loading_date' => $data->loading_date ? $data->loading_date : $doc->cargo[0]->weights->loading->time_stamp ,
            'discharge_weight' => $data->discharge_weight ? $data->discharge_weight : $doc->cargo[0]->weights->discharge->net_weight,
            'discharge_date' => $data->discharge_date ? $data->discharge_date : $doc->cargo[0]->weights->discharge->time_stamp,
        ];
        return DBConnection::runBindDatabaseQuery($sqlQuery, $params);
    }
}
