<?php
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/waybill_core.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/../../core/tender/tender_core.php");
require_once(dirname(__FILE__) . "/../../core/queue/queue_core.php");
require_once(dirname(__FILE__) . "/../../core/truck_contract/truck_contract_core.php");
require_once(dirname(__FILE__) . "/../../core/payment/payment_core.php");
require_once(dirname(__FILE__) . "/../../core/voucher/voucher_core.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/customer_care.php");
require_once(dirname(__FILE__) . "/../tender_company/tender_company_core.php");
require_once(dirname(__FILE__) . "/../tender/tender_core.php");
require_once(dirname(__FILE__) . "/../cargo/cargo_core.php");
require_once(dirname(__FILE__) . "/../truck/truck_core.php");
require_once(dirname(__FILE__) . "/../user/user_core.php");
require_once(dirname(__FILE__) . "/../queue/queue_core.php");
require_once(dirname(__FILE__) . "/../cargo_type/cargo_type_core.php");
require_once(dirname(__FILE__) . "/../gateway/gateWay_core.php");
require_once(dirname(__FILE__) . "/../location/location_core.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/mg_registrar.php");
require_once(dirname(__FILE__) . "/../taskQueues/taskQueues_core.php");
require_once(dirname(__FILE__) . "/../account/account_core.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/Jo_Petrol.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/merchant.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/mg_tracking.php");
require_once(dirname(__FILE__) . "/../tender_driver/tender_driver_core.php");
require_once(dirname(__FILE__) . "/../../core/truck_routing/truck_routing_core.php");
require_once(dirname(__FILE__) . "/../../core/payment/jppmc.php");
require_once(dirname(__FILE__) . "/../../core/route_wage/route_wage_core.php");
require_once(dirname(__FILE__) . "/../../core/truck_contract/truck_contract_core.php");
require_once(dirname(__FILE__) . "/../../core/registration/registration_core.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/poll.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/FPS.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/Robot_agent.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/container.php");
require_once(dirname(__FILE__) . "/../../core/company/clearing_agent/clearing_agent_core.php");
require_once(dirname(__FILE__) . "/../../core/fps_claim/fps_claim_core.php");
require_once(dirname(__FILE__) . "/../../core/land_trip/land_trip_core.php");





class Waybill_interface extends API
{

    // the request of each call
    private $_request = array();
    private $_waybillCore;
    private $_paymentCore;
    private $_truckCore;
    private $_tenderCompanyCore;
    private $_driverCore;
    private $_gatewayCore;
    private $_locationCore;
    private $_driverCoreuserCore;
    private $_mg_registrar;
    private $_tenderCore;
    private $_cargo_type;
    private $_cargoCore;
    private $_accountCore;
    private $_jo_petrol;
    private $_routeWageCore;
    private $_queueCore;
    private $_voucherCore;
    private $_merchantIntegration;
    private $_tenderDriverCore;
    private $_mg_tracking;
    private $_truckRoutingCore;
    private $_customerCare;
    private $_registrationCore;
    private $_pollIntegration;
    private $_robotIntegration;
    private $_con;
    private $_fpsVoucherCore;
    private $_fps;
    private $_clearingAgentCore;
    private $_landtripCore;

    public function __construct()
    {

        // call the super constructur
        $this->_request = parent::__construct();

        session_start();
        if (!isset($_SESSION['user_id'])) {
            //throw new Exception('No Session!');
        }

        // init the object
        $this->_waybillCore = new WaybillCore();
        $this->_paymentCore = new PaymentCore();
        $this->_truckCore = new TruckCore();
        $this->_tenderCompanyCore = new TenderCompanyCore();
        $this->_driverCore = new DriverCore();
        $this->_userCore = new UserCore();
        $this->_mg_registrar = new MG_registrar();
        $this->_gatewayCore = new GatewayCore();
        $this->_tenderCore = new TenderCore();
        $this->_locationCore = new LocationCore();
        $this->_cargo_type = new CargoTypeCore();
        $this->_cargoCore = new CargoCore();
        $this->_accountCore = new AccountCore();
        $this->_jo_petrol = new Jo_Petrol();
        $this->_queueCore = new QueueCore;
        $this->_voucherCore = new VoucherCore();
        $this->_merchantIntegration = new MerchantIntegration();
        $this->_tenderDriverCore = new TenderDriverCore();
        $this->_mg_tracking = new MG_tracking();
        $this->_truckRoutingCore = new TruckRoutingCore();
        $this->_customerCare = new CustomerCare();
        $this->_registrationCore  = new RegistrationCore();
        $this->_routeWageCore  = new RouteWageCore();
        $this->_fpsVoucherCore  = new Fps_voucher_core();
        $this->_fps = new FPS();
        $this->_pollIntegration = new Poll();
        $this->_robotIntegration = new Robot_agent();
        $this->_con = new Container();
        $this->_clearingAgentCore = new ClearingAgentCore();
        $this->_landtripCore = new LandtripCore();
        

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // --------------------------------------------------------------- //
    // --------------------- get bean for waybill  ------------------- //
    // --------------------------------------------------------------- //
    public function getWaybill()
    {

        $waybillBean = $this->_waybillCore->getWaybillBasic($this->_request->id, $_SESSION['user_id']);

        // get the print template
        $tender_id = $waybillBean->document->tender->id;
        $tenderCore = new TenderCore();
        $tenderManifestJSON = $tenderCore->getTenderManifest($tender_id, 0);

        $waybillPrintTemplateArr = $tenderManifestJSON['waybill_print_template'];

        if ($waybillBean->tender_id == 12  && $waybillBean->document->negotiable_instructios->route->origin->id == 91030024) {
            $tenderManifestJSON = $tenderCore->getTenderManifest(11, 0);
            $waybillPrintTemplateArr = $tenderManifestJSON['waybill_print_template'];
        }

        foreach ($waybillPrintTemplateArr as $temp) {
            if ($temp['status'] == $waybillBean->status) {
                $waybillBean->print_title = $temp['print_title'];
                $waybillBean->print_template = $temp['template'];
                break;
            }
        }

        // get cargo bean
        $cargoBean = $this->_cargoCore->getCargoBasic($waybillBean->document->cargo[0]->cargo_id, $_SESSION['user_id']);

        // change print template in certain conditions
        if ($waybillBean->document->cargo[0]->cargo_unit == "kg-count" && $tenderManifestJSON['tender_code'] == 'VESSELS') {
            $waybillBean->print_template = "vessels_count_waybill";
        }
        if ($waybillBean->document->cargo[0]->consigner->ca->id == $_SESSION['ca_id']) {
            $waybillBean->print_template = "caWaybill";
            $waybillBean->document->cargo[0]->declaration_number = $cargoBean->declaration_number;
            $caBean = $this->_clearingAgentCore->getClearingAgentBasic($waybillBean->document->cargo[0]->consigner->ca->id, $_SESSION['user_id']);
            foreach ($caBean->photos as $photo) {
                if ($photo->type == "logo") {
                    $waybillBean->print_logo = $photo->url;
                }
            }
        }

        // hide the destination name if the tender_id is GRAINS
        if ($tenderManifestJSON['tender_code'] == 'GRAINS') {
            if (in_array($waybillBean->status, ["NEW", "APPROVED", "ACTIVE"])) {
                $waybillBean->document->negotiable_instructios->route->destination->name = "";
            }
        }
        if ($tenderManifestJSON['tender_code'] == 'JO_PETROL_AQ') {
            $jo_petrol = new Jo_Petrol();
            $jo_petrol_raw  = $waybillBean->document->integeration_details->jo_petrol;
            if ($jo_petrol_raw && $jo_petrol_raw != "null") {
                $jo_petrol_raw = json_decode(json_encode($jo_petrol_raw, JSON_UNESCAPED_UNICODE), true);
                $waybillBean->document->integeration_details->jo_petrol = $jo_petrol->mapWaybillInfo($jo_petrol_raw);
            }
        }
        if ($tenderManifestJSON['tender_code'] == 'VESSELS') {
            $filter = [
                ["key" => "trucking_company_id", "val" => $waybillBean->trucking_company_id],
                ["key" => "status", "val" => ["ACTIVE", "NEW"], "op" => "in"],
                ["key" => "tender_id", "val" => 3]
            ];
            $tenderCompany = $this->_tenderCompanyCore->searchTenderCompany($filter, 1, 0, $_SESSION['user_id'])->data;
            if (gettype($tenderCompany[0]->service_list) == 'string') {
                $tenderCompany[0]->service_list = json_decode($tenderCompany[0]->service_list);
            }
            if (sizeof($tenderCompany) > 0) {
                if ($tenderCompany[0]->service_list) {
                    $list = $tenderCompany[0]->service_list;
                    $flag = true;
                    foreach ($list as $service) {
                        if ($service->code === "DISPATCH" && $service->type === "QUEUE") {
                            $flag = false;

                            if ($waybillBean->document->notes) {
                                $waybillBean->document->notes->print_note = "مستند افراد";
                            } else {
                                $waybillBean->document->notes = new stdClass();
                                $waybillBean->document->notes->print_note = "مستند افراد";
                            }
                        }
                    }
                    if ($flag) {
                        if ($waybillBean->document->notes) {
                            $waybillBean->document->notes->print_note = "مستند شركات";
                        } else {
                            $waybillBean->document->notes = new stdClass();
                            $waybillBean->document->notes->print_note = "مستند شركات";
                        }
                    }
                }
            }
        }


        // check if the user has view fiancial auth
        try {
            DBConnection::has_authority($_SESSION['user_id'], 'WAYBILL', 'VIEW_FINANCIAL', $waybillBean->status, $waybillBean->status);

            // add the new,pending vouchers of this waybill
            $voucherCore = new VoucherCore();
            $filter = [['key' => 'trx_template', 'val' => $waybillBean->id, 'op' => 'json', 'node' => 'ref_id']];
            $waybillVouchers = $voucherCore->searchVouchers($filter, 100, 0, $_SESSION['user_id']);

            if ($waybillVouchers->found_rows > 0) {
                $waybillBean->document->freight->vouchers = $waybillVouchers->data;
            }
        } catch (Exception $e) {
            //$waybillBean->document->freight = [];
        }

        $waybillBean->document->hashed_wn = md5($waybillBean->wn);
        $waybillBean->document->vessel_name = $cargoBean->vessel_name;

        parent::response(json_encode($waybillBean, JSON_UNESCAPED_UNICODE));
    }



    // -------------------------------------------------------------- //
    // --------------------- get list of waybills ------------------- //
    // -------------------------------------------------------------- //
    public function searchWaybills()
    {

        if (!$this->_request->preparefilter) {
            $waybillFilter = $this->prepareFilter();
        } else {
            $waybillFilter = [];
            if (gettype($this->_request->filter) == "string") {
                $this->_request->filter = json_decode($this->_request->filter);
            }
            foreach ($this->_request->filter as &$filter) {
                array_push($waybillFilter, ["key" => $filter->key, "val" => $filter->val, "op" => $filter->op]);
            }
        }

        $waybillResult = $this->_waybillCore->searchWaybills(
            $waybillFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        $currentTime = DBConnection::getSystemDate();
        foreach ($waybillResult->data as &$waybill_data) {
            $waybill_data->server_date = $currentTime;
        }


        // remove unwanted info for corporate users
        if ($_SESSION['type'] == "CORPORATE") {
            foreach ($waybillResult->data as &$waybill_data) {
                if ($waybill_data->tender_id == 13) {
                    if (in_array($waybill_data->status, ['NEW', 'APPROVED', 'ACTIVE', 'PENDING'])) {
                        $doc = json_decode($waybill_data->document);
                        $doc->negotiable_instructios->route->destination = null;
                        $waybill_data->document = json_encode($doc, JSON_UNESCAPED_UNICODE);
                        $waybill_data->destination_id = "91000000";
                    }
                    if (in_array($waybill_data->status, ['ONROAD', 'ARRIVED', 'CLOSED', 'COMPLETE'])) {
                        $doc = json_decode($waybill_data->document);
                        $doc->negotiable_instructios->route->destination->id = $doc->negotiable_instructios->route->destination->name;
                        $waybill_data->document = json_encode($doc, JSON_UNESCAPED_UNICODE);
                        $waybill_data->destination_id = $doc->negotiable_instructios->route->destination->name;
                    }

                    if (in_array($waybill_data->status, ['NEW', 'APPROVED', 'ACTIVE', 'PENDING'])) {
                        $waybill_data->destination_id = $doc->negotiable_instructios->route->destination->name;
                    }
                }
            }
        }

        // hide the destination name if the tender_id is GRAINS
        if ($_SESSION['type'] == "INDIVIDUAL") {
            foreach ($waybillResult->data as &$waybill_data) {
                if ($waybill_data->tender_id == 13) {
                    if (in_array($waybill_data->status, ['NEW', 'APPROVED', 'ACTIVE', 'PENDING'])) {
                        $waybill_data->destination_id = "لم يتم تحديد الوجهة";
                    }
                }
            }
        }

        // if the caller is driver
        $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
        $is_driver = false;
        foreach ($userRolesArray as $role) {
            if ($role == 'DRIVER') {
                $is_driver = true;
            }
        }
        if ($is_driver) {

            // get nn
            $user =  $this->_userCore->getUserBasic($_SESSION['u_id'], $_SESSION['user_id']);
            $val = $user->nn;

            // search for latest land_trips of this driver
            $data = new stdClass();
            $data->filter = new stdClass();
            $data->filter->search_index = $val;
            $data->limit = 1;
            $data->offset = 0;

            $result = $this->_con->searchLandTrip($data, 0);

            foreach ($result['data'] as &$land_trip) {
                $land_trip['wn'] = $land_trip->serial;

                $document = json_decode($land_trip['document']);
                $document->cargo = [];
                $cargo = new stdClass();
                $cargo->name = $land_trip['cid'];
                $document->cargo[] = $cargo;
                $land_trip['tn'] = $document->carrier[0]->truck->tn;
                $land_trip['document'] = json_encode($document, JSON_UNESCAPED_UNICODE);

                array_unshift($waybillResult->data, $land_trip);
            }
        }


        //return Success response
        parent::response($waybillResult);
    }

    private function prepareFilter()
    {
        $waybillFilter = [];

        if ($this->_request->filter) {
            if (gettype($this->_request->filter) == "string") {
                $filter = json_decode($this->_request->filter, true);
            } else {
                $filter =  $this->_request->filter;
            }

            foreach ($filter as $key => $value) {
                if ($key == 'create_date') {
                    $tempArr = ['key' => "DATE($key)", 'val' => $value];
                } else if ($key == 'document') {
                    $tempArr = ['key' => $key, 'val' => $value, 'op' => 'like'];
                } else if ($key == 'cargo_id') {
                    $tempArr = ['key' => 'document', 'val' => $value, 'op' => 'json unquote', 'node' => '$.cargo[0].cargo_id'];
                } else if ($key == 'policy_num') {
                    $tempArr = ['key' => 'document', 'val' => $value, 'op' => 'json unquote', 'node' => '$.integeration_details.jo_petrol.nfldnm'];
                } else if ($key == 'create_date_from') {
                    $tempArr = ['key' => 'create_date', 'val' => $value, 'op' => 'date greater than'];
                } else if ($key == 'create_date_to') {
                    $tempArr = ['key' => 'create_date', 'val' => $value, 'op' => 'date less than'];
                } else if ($key == 'loading_date_from') {
                    $tempArr = ['key' => 'loading_date', 'val' => $value, 'op' => 'date greater than'];
                } else if ($key == 'loading_date_to') {
                    $tempArr = ['key' => 'loading_date', 'val' => $value, 'op' => 'date less than'];
                } else if ($key == 'discharge_date_from') {
                    $tempArr = ['key' => 'discharge_date', 'val' => $value, 'op' => 'date greater than'];
                } else if ($key == 'discharge_date_to') {
                    $tempArr = ['key' => 'discharge_date', 'val' => $value, 'op' => 'date less than'];
                } else if ($key == 'created_by') {
                    $tempArr = ['key' => 'document', 'val' => $value, 'op' => 'json', 'node' => '$.service_list.created_by'];
                } else if ($key == 'loading_date') {
                    $tempArr = ['key' => 'loading_date', 'op' => $value];
                } else if ($key == 'active_statuses') {
                    $tempArr = ['key' => 'status', 'val' => $value, 'op' => 'in'];
                } else {
                    $tempArr = ['key' => $key, 'val' => $value];
                }
                array_push($waybillFilter, $tempArr);
            }
        }

        // if the tender list available for user not * (all tenders)
        if ($_SESSION['tender_ids'] && $_SESSION['tender_ids'][0] != "*") {
            $temp = ['key' => 'tender_id', 'val' => $_SESSION['tender_ids'], 'op' => 'in'];
            array_push($waybillFilter, $temp);
        }

        return $waybillFilter;
    }

    public function autoCompleteGrainsWaybillInfo()
    {

        // search for the last closed trip for this truck
        $waybillFilter = $this->prepareFilter();
        $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter, 1, 0, $_SESSION['user_id'], ' order by id desc ');

        // inject nafith Grains info
        if ($waybillResult->found_rows > 0) {
            $tn = $waybillResult->data[0]->tn;
            $filter = [['key' => 'TN', 'value' => $tn]];
            $nafithGrainsPermit = $this->_registrationCore->searchNafithGrainPermit($filter, 1);
            $waybillResult->data[0]->nafith_wn = $nafithGrainsPermit->PN;

            // Continue this to get data from ltrc
            $doc = json_decode($waybillResult->data[0]->document);

            // trailer
            $truckFilter = [['key' => "tn", 'val' => $nafithGrainsPermit->TRN]];
            $trailer_qry = $this->_truckCore->searchTrucks($truckFilter, 1, 0, 0);
            if ($trailer_qry->found_rows > 0) {
                $trailer_id = $trailer_qry->data[0]->id;
                $waybillResult->data[0]->trn = $nafithGrainsPermit->TRN;
                $waybillResult->data[0]->trailer_id = $trailer_id;
                $doc->carrier[0]->trailer->id = $trailer_id;
                $doc->carrier[0]->trailer->trn = $nafithGrainsPermit->TRN;
            }

            // driver
            $driverFilter = [['key' => "nn", 'val' => $nafithGrainsPermit->NNPN]];
            $driver_qry = $this->_driverCore->searchDriver($driverFilter, 1, 0, 0);
            if ($driver_qry->found_rows > 0) {
                $driver_id = $driver_qry->data[0]->id;;
                $waybillResult->data[0]->driver_name = $nafithGrainsPermit->NAME;
                $waybillResult->data[0]->driver_NN = $nafithGrainsPermit->NNPN;
                $doc->carrier[0]->driver->id = $driver_id;
                $doc->carrier[0]->driver->name = $nafithGrainsPermit->NAME;
            }

            $waybillResult->data[0]->document = json_encode($doc, JSON_UNESCAPED_UNICODE);
        }

        parent::response($waybillResult);
    }

    // ------------------------------------------------------------------------------------ //
    // ---------------------- validate if nafith wn is valid or not ----------------------- //
    // ------------------------------------------------------------------------------------ //
    public function validateNafithWN()
    {

        // search for nafith grains record
        $nafith_wn = $this->_request->nafith_wn;
        $trn = $this->_request->trn;
        $nn = $this->_request->nn;

        $nafithGrainsPermit = $this->_registrationCore->getNafithGrainsPermit($nafith_wn);
        if (!$nafithGrainsPermit) {
            throw new Exception("رقم الإرسالية المدخل غير صحيح");
        }

        // match if any of the user input fields are different
        $errorMessage = "";
        if ($nafithGrainsPermit->TRN != $trn) {
            $errorMessage .= "رقم المقطورة غير مطابق لمعلومات الأرسالية" . "($nafithGrainsPermit->TRN)" . " ، ";
        }
        if ($nafithGrainsPermit->NNPN != $nn) {
            $errorMessage .= "الرقم الوطني للسائق غير مطابق لمعلومات الأرسالية" . "($nafithGrainsPermit->NNPN)" . "  ";
        }

        if ($errorMessage != "") {
            throw new Exception($errorMessage);
        }
    }

    // -------------------------------------------------------------------------------------------------- //
    // --------------------- get list of waybills as JSON format similar to WOQ search------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function searchWaybillJSON()
    {

        if ($this->_request->filter) {
            $waybillFilter = json_decode($this->_request->filter);
        } else if ($this->_request->ids) {
            $ids = explode(",", $this->_request->ids);
            $ids = implode("','", $ids);
            $waybillFilter = [['key' => 'id', 'val' => [$ids], 'op' => 'in']];
        }

        // search database
        $waybillFilter = json_decode($this->_request->filter);
        $waybillResult = $this->_waybillCore->searchWaybills(
            $waybillFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        // format the data in a way similar to JSON format in WOQ
        $data = [];
        foreach ($waybillResult->data as $wbl) {
            $doc = json_decode($wbl->document);
            $wblObj = new stdClass();
            $wblObj->id = rand();
            $wblObj->object_code = 'WAYBILL';
            $wblObj->object_id = $wbl->id;
            $objectRecord = new stdClass();
            $objectRecord->id = $wbl->id;
            $objectRecord->tn = $doc->carrier[0]->truck->tn;
            $objectRecord->wn = $wbl->wn;
            $objectRecord->trn = $doc->carrier[0]->trailer->tn;
            $objectRecord->status = $wbl->status;
            $objectRecord->ca_name = $doc->cargo[0]->consigner->ca->name;
            $objectRecord->tc_name = $doc->carrier[0]->tc->name;
            $objectRecord->cargo_id = $doc->cargo[0]->cargo->id;
            $objectRecord->caro_name = $doc->cargo[0]->cargo->name;
            $objectRecord->driver_nn = $doc->carrier[0]->driver->nn; //TODO
            $objectRecord->queue_name = $doc->queue->name;
            $objectRecord->create_date = $wbl->create_date;
            $objectRecord->driver_name = $doc->carrier[0]->driver->name;
            $objectRecord->tender_name = $doc->tender->name;
            $objectRecord->driver_phone = $doc->carrier[0]->driver->phone;
            $objectRecord->truck_owner_nn = $doc->carrier[0]->truck_owner->nn; //TODO
            $objectRecord->cargo_owner_name = $doc->cargo[0]->consigner->cargo_owner->name;
            $objectRecord->truck_owner_name = $doc->carrier[0]->truck_owner->name;
            $objectRecord->truck_owner_phone = $doc->carrier[0]->truck_owner->phone;
            $wblObj->object_record = json_encode($objectRecord, JSON_UNESCAPED_UNICODE);
            $wblObj->object_status = $wbl->status;
            $wblObj->object_keys = null;
            $wblObj->create_date =  $wbl->create_date;
            $wblObj->search_text = '';

            array_push($data, $wblObj);
        }

        $result['data'] = $data;
        $result['found_rows'] = $waybillResult->found_rows;
        parent::response($result);
    }


    // --------------------------------------------DEPRECATED------------------------------------------------------ //
    // --------------------------- Create new temp waybill for companies--------------------------------------------- //
    // -------------------------------------------------------------------------------------------------------------- //
    public function createTempWaybill()
    {

        $tender_id = $this->_request->tender_id;
        $queue_id = $this->_request->queue_id;
        $truck_id = $this->_request->truck_id;
        $trailer_id = $this->_request->trailer_id;
        $driver_id = $this->_request->driver_id;
        $order_id = $this->_request->order_id;
        $tender_company_id = $this->_request->tender_company_id;
        $destination_id = $this->_request->destination_id;

        $tenderCompanyCore = new TenderCompanyCore();
        $cargoCore = new CargoCore();
        $truckCore = new TruckCore();
        $tenderCore = new TenderCore();
        $QueueCore = new QueueCore();

        // get $tender Company
        $tenderCompanyFilter = [['key' => 'id', 'val' => $tender_company_id]];
        $tenderCompaniesReuslt = $tenderCompanyCore->searchTenderCompany($tenderCompanyFilter, 1, 0, $_SESSION['user_id']);

        // get $truck owner_id and trailer owner id
        $truckFilter = [['key' => "id", 'val' => $truck_id]];
        $truckQuery = $truckCore->searchTrucks($truckFilter, 1, 0, $_SESSION['user_id']);
        $truck_owner_id = $truckQuery->data[0]->truck_owner_id;
        $trailer_owner_id = $truck_owner_id;
        $trucking_company_id = $tenderCompaniesReuslt->data[0]->trucking_company_id;

        // get waybill template from cargo and extract the following
        $orderBean = $tenderCore->getTenderOrderBasic($order_id,  $_SESSION['user_id']);
        $cargo_id = $orderBean->cargo[0];
        $cargoBean = $cargoCore->getCargoBasic($cargo_id, $_SESSION['user_id']);
        $waybill_template = $cargoBean->waybill_template;
        $ca_company_id = $waybill_template->cargo[0]->consigner->ca_id;
        $origin_id = prepareLocationValue($waybill_template->negotiable_instructios->route->origin, $cargoBean);
        if (!$destination_id) {
            $destination_id = prepareLocationValue($waybill_template->negotiable_instructios->route->destination, $cargoBean);
        }

        // validate if the truck has pending tender truck
        $tenderTruckSearchFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'truck_id', 'val' => $truck_id],
            ['key' => 'status', 'val' => 'PENDING']
        ];
        $tenderTrucks = $tenderCore->searchTenderTruck($tenderTruckSearchFilter, 1, 0, $_SESSION['user_id']);
        if ($tenderTrucks->found_rows > 0) {
            throw new Exception('عقد تشغيل الشاحنة على المشروع موقوف');
        }

        // validate if the user wants to create waybill for company and the truck has contract with ADEL (395)
        if ($trucking_company_id != 395) {
            $tenderTruckSearchFilter = [
                ['key' => 'tender_id', 'val' => $tender_id],
                ['key' => 'truck_id', 'val' => $truck_id],
                ['key' => 'tender_company_id', 'val' => 197],
                ['key' => 'status', 'val' => 'ACTIVE']
            ];
            $tenderTrucks = $tenderCore->searchTenderTruck($tenderTruckSearchFilter, 1, 0, $_SESSION['user_id']);
            if ($tenderTrucks->found_rows > 0) {
                throw new Exception('لا تستطيع انشاء مستند شركات لشاحنة أفراد');
            }
        }

        $user_id = $_SESSION['user_id'];

        try {
            DBConnection::startTransaction();

            $waybill_result = $this->_waybillCore->createWaybill(
                $tender_id,
                $queue_id,
                $order_id,
                $cargo_id,
                $truck_id,
                $trailer_id,
                $driver_id,
                $truck_owner_id,
                $trailer_owner_id,
                $trucking_company_id,
                $ca_company_id,
                $origin_id,
                $destination_id,
                $user_id
            );

            // decide what to do with the queue of the truck
            $activeQueueStatus = DBConnection::getActiveStatus('queue');
            $queueSearchFilter = [
                ['key' => 'truck_id', 'val' => $truck_id],
                ['key' => 'q_id', 'val' => $queue_id],
                ['key' => 'tender_id', 'val' => $tender_id],
                ['key' => 'status', 'val' => $activeQueueStatus, 'op' => 'in']
            ];
            $queueTruckResult = $QueueCore->searchQueue($queueSearchFilter, 1, 0, $user_id);
            if ($queueTruckResult->found_rows > 0) {

                $truck_queue_id = $queueTruckResult->data[0]->id;
                $queueBean = $QueueCore->getQueuebasic($truck_queue_id,  $_SESSION['user_id']);
                $tenderManifestJSON = $tenderCore->getTenderManifest($tender_id, 0);

                if ($queueBean) {
                    if ($queueBean->status == 'HELD' || $queueBean->status == 'PENDING') {
                        throw new Exception('حالة الشاحنة على الدور لا تسمح بإضافة مستند يدوي');
                    }

                    if ($tenderManifestJSON['manual_waybill_queue_action'] == 'THROW_EXCEPTION') {
                        throw new Exception('لا تستطيع انشاء المستند بسبب وجود الشاحنة على الدور');
                    }

                    if ($tenderManifestJSON['manual_waybill_queue_action'] == 'CLOSE_CURRENT_QUEUE') {
                        $QueueCore->changeStatus($truck_queue_id, 'CLOSED', 0); // Closed By System
                    }
                }
            }

            // add to itihad queue if not exist
            $itihad_queue_for_vessels = 2;

            // add indivisual to yard 2 , and companies to 3
            $tenderCompanyCore = new TenderCompanyCore();
            $service_list = $tenderCompanyCore->getTenderCompanyServices($trucking_company_id, $tender_id);

            $has_queue_service = false;
            if ($service_list) {
                foreach ($service_list as $service) {
                    if ($service->code == 'DISPATCH' && isset($service->type) && $service->type == 'QUEUE') {
                        $has_queue_service = true;
                    }
                }
            }
            if ($has_queue_service) {
                $itihad_queue_for_vessels = 2; // indivisual
            } else {
                $itihad_queue_for_vessels = 3; // company
            }

            $this->_queueCore->pushTruckToYard(
                $tender_id,
                $itihad_queue_for_vessels,
                $truck_id,
                $trailer_id,
                $driver_id,
                $waybill_result->id
            );

            DBConnection::commitTransaction();

            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
            $Result['WN'] = $waybill_result;
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();

            if (strpos($e->getMessage(), '1172 Result consisted of more than one row') !== false) {
                throw new Exception("لا تستطيع المتابعة ، الشاحنة مسجلة على العطاء مع شركتين مختلفتين");
            } else {
                throw new Exception($e->getMessage());
            }
        }
    }

    // --------------------------------------------------------------------------------------------------------- //
    // --------------------------- Create new waybill for companies--------------------------------------------- //
    // --------------------------- DEPRECATED ------------------------------------------------------------------ //
    // --------------------------------------------------------------------------------------------------------- //
    public function createWaybill()
    {
        // prepare data
        $tender_id = $this->_request->tender_id;
        $queue_id = $this->_request->queue_id;
        $order_id = $this->_request->order_id;
        $cargo_id = $this->_request->cargo_id;
        $truck_id = $this->_request->truck_id;
        $trailer_id = $this->_request->trailer_id;
        $driver_id = $this->_request->driver_id;
        $tender_company_id = $this->_request->tender_company_id;


        $truckContractCore = new TruckContractCore();
        $tenderCompanyCore = new TenderCompanyCore();
        $cargoCore = new CargoCore();
        $truckOwnerCore = new TruckOwnerCore();

        // get trucking_company_id
        $tenderCompanyFilter = [['key' => 'id', 'val' => $tender_company_id]];
        $tenderCompaniesReuslt = $tenderCompanyCore->searchTenderCompany($tenderCompanyFilter, 1, 0, $_SESSION['user_id']);

        $trucking_company_id = $tenderCompaniesReuslt->data[0]->trucking_company_id;
        $company_id = $tenderCompaniesReuslt->data[0]->company_id;

        // get $truck_owner_id
        $truckOwnerFilter = [['key' => "user_id", 'val' => $company_id]];
        $truckOwnerQuery = $truckOwnerCore->searchTruckOwner($truckOwnerFilter, 1, 0, $_SESSION['user_id']);
        $truck_owner_id = $truckOwnerQuery->data[0]->id;
        $trailer_owner_id = $truckOwnerQuery->data[0]->id;

        // get waybill template from cargo and extract the following
        $cargoBean = $cargoCore->getCargoBasic($cargo_id, $_SESSION['user_id']);
        $waybill_template = $cargoBean->waybill_template;
        $ca_company_id = $waybill_template->cargo[0]->consigner->ca_id;
        $origin_id = prepareLocationValue($waybill_template->negotiable_instructios->route->origin, $cargoBean);
        $destination_id = prepareLocationValue($waybill_template->negotiable_instructios->route->destination, $cargoBean);

        // create waybill
        $waybill_result = $this->_waybillCore->createWaybill(
            $tender_id,
            $queue_id,
            $order_id,
            $cargo_id,
            $truck_id,
            $trailer_id,
            $driver_id,
            $truck_owner_id,
            $trailer_owner_id,
            $trucking_company_id,
            $ca_company_id,
            $origin_id,
            $destination_id,
            $_SESSION['user_id']
        );

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
        $Result['WN'] = $waybill_result;
        parent::response($Result);
    }


    // ------------------------------------------------------------------------- //
    // ------------------- change status of waybill ---------------------------- //
    // ------------------------------------------------------------------------- //
    public function changeStatus()
    {

        // validate if the trailer number is not saved in waybill
        $waybillBean = $this->_waybillCore->getWaybillBasic($this->_request->id, $_SESSION['user_id']);
        $trn = $waybillBean->document->carrier[0]->trailer->tn;

        if (!$trn && $waybillBean->document->tender->id != 22) {

            $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
            $allowChangeStatusWithoutTrn = false;
            foreach ($userRolesArray as $role) {
                if ($role == 'OPERATION_MANAGER') {
                    $allowChangeStatusWithoutTrn = true;
                    break;
                }
            }
            if (!$allowChangeStatusWithoutTrn) {

                // if the truck is signal ignore this validation
                $tn = $waybillBean->document->carrier[0]->truck->tn;
                $truckFilter = [['key' => "tn", 'val' => $tn], ['key' => "status", 'val' => ['INACTIVE'], 'op' => 'not in']];
                $truckQuery = $this->_truckCore->searchTrucks($truckFilter, 1, 0, 0);
                if ($truckQuery->data[0]->cat != "TRUCK-SINGLE") {
                    throw new Exception("لا تستطيع المتابعة ، رقم المقطورة غير موجود");
                }
            }
        }

        try {
            // in case the new status is complete, and the user asked to change delay option
            if ($this->_request->new_status == "COMPLETE") {

                $waybillJson = $waybillBean->document;

                // save the assets account_id to be used in payment
                $assets_account_id = $this->_request->assets_account_id;

                // TODO: fix this
                if (!$assets_account_id) {
                    if ($waybillBean->document->tender->id == 17) {
                        $assets_account_id = "777412-19901";
                    }
                }

                $waybillJson->freight->assets_account_id = $assets_account_id;
                if ($this->_request->check_number)
                    $waybillJson->freight->check_number = $this->_request->check_number;
                if ($this->_request->bank_branch)
                    $waybillJson->freight->bank_branch = $this->_request->bank_branch;

                // save payment delay if exists
                if ($this->_request->payment_delay) {
                    $waybillJson->payment_delay = $this->_request->payment_delay;
                }

                // update database
                $waybillBean->document = $waybillJson;
                $this->_waybillCore->updateWaybill($waybillBean, $this->_request->id, $_SESSION['user_id']);
            }

            DBConnection::startTransaction();

            // change w3aybill status
            $this->_waybillCore->changeStatus(
                $this->_request->id,
                $this->_request->new_status,
                $_SESSION['user_id'],
                $this->_request->advance_payments_values,
                $this->_request->extraFees
            );

            // in case the new status is complete, and the user asked to change delay option
            if ($this->_request->new_status == "CLOSED") {

                // make sure the waybill has no payment
                if ($waybillBean->document->freight->payments && sizeof($waybillBean->document->freight->payments) > 0) {
                    $allowTabweesh = false;
                    $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
                    foreach ($userRolesArray as $role) {
                        if ($role == 'OPERATION_MANAGER' || $role == 'TELLER_SUPERVISOR' || $role == 'OPERATION_SUPERVISOR') {
                            $allowTabweesh = true;
                            break;
                        }
                    }
                    if (!$allowTabweesh) {
                        throw new Exception("لا تستطيع المتابعة ، الشاحنة عليها ذمة مالية ، الرجاء مراجعة مدير العمليات");
                    }
                }

                // if the waybill on tender 3 ,  make sure it loading time is larger than 24 hours
                $allowTabweesh = false;
                if ($waybillBean->tender_id == 3 && $waybillBean->loading_date) {

                    $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
                    foreach ($userRolesArray as $role) {
                        if ($role == 'OPERATION_MANAGER' || $role == 'OPERATION_SUPERVISOR') {
                            $allowTabweesh = true;
                            break;
                        }
                    }
                    $loadingDate = strtotime($waybillBean->loading_date);
                    $currentTime = strtotime(DBConnection::getSystemDate());
                    // diff in hours
                    $diff = ($currentTime - $loadingDate) / (24 * 60);
                    if ($diff < 12) {
                        if (!$allowTabweesh) {
                            throw new Exception("لا تستطيع المتابعة ، لم يمض 12 ساعة على تحميل المستند");
                        }
                    }
                }

                $waybillBean = $this->_waybillCore->getWaybillBasic($this->_request->id, $_SESSION['user_id']);
                $revokeReason = $this->_request->reason;

                // add remarks to activity
                $addNoteCore = new Add_notes_core();
                $addNoteCore->addNotes('waybill', $this->_request->id, $revokeReason . " - " . $this->_request->remarks, $_SESSION['user_id']);

                // add note to waybill document
                $waybillJson = $waybillBean->document;
                $waybillJson->closedReason = new stdClass();

                $waybillJson->closedReason->reason = $revokeReason;
                $waybillJson->closedReason->remarks = $this->_request->remarks;
                $waybillBean->document = $waybillJson;
                $this->_waybillCore->updateWaybill($waybillBean, $this->_request->id, $_SESSION['user_id']);
                $this->_waybillCore->logActivity($this->_request->id, " إغلاق المستند ", "السبب : " . $revokeReason . " - " . $this->_request->remarks, "CLOSED_WAYBILL", $_SESSION['user_id']);

                //activate the other queues if the truck has more than one
                $q_id = $waybillJson->integeration_details->queue->q_id;
                $queuesToActivateSearchFilter = [
                    ['key' => 'truck_id', 'val' => $waybillBean->truck_id],
                    ['key' => 'status', 'val' => 'HELD'],
                    ['key' => 'tender_id', 'val' => [$waybillBean->tender_id], 'op' => 'not in'],
                    ['key' => 'q_id', 'val' => [$q_id], 'op' => 'not in']
                ];

                $queuesToActivate = $this->_queueCore->searchQueue($queuesToActivateSearchFilter, 1000, 0, $_SESSION['user_id'])->data;
                // iterate and change status to HELD for each queue
                foreach ($queuesToActivate as $queue) {
                    $this->_queueCore->changeStatus($queue->id, 'ACTIVE', 0);
                    $this->_queueCore->logActivity(
                        $queue->id,
                        "فك تجميد الدور",
                        "تم فك تجميد الدور",
                        "activate_queue",
                        0
                    );
                }
            }

            if ($this->_request->new_status == "PENDING") {
                $this->_waybillCore->logActivity($this->_request->id, " دخول الى موقع التحميل", "", "CARGO_ORIGIN_ENTER", $_SESSION['user_id']);
            }

            if ($this->_request->new_status == "ONROAD") {
                // for the vessels , grains waybill , close it after 12 hours of leaving port
                if ($waybillBean->tender_id == 3 || $waybillBean->tender_id == 13) {
                    $taskQueuesCore = new TaskQueuesCore();
                    $taskQueuesCore->createCloseWaybillTask($waybillBean->id, 10, "اغلاق المستند بسبب مرور 10 ساعات على التحميل");
                }
            }

            if ($this->_request->new_status == "ARRIVED") {
                $this->_waybillCore->logActivity($this->_request->id, " دخول الى موقع التفريغ", "", "CARGO_DESTINATION_ENTER", $_SESSION['user_id']);
            }

            DBConnection::commitTransaction();

            //return Success reponse
            $Result = [];
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            // log trx error here in case the error is financial related

            if (strpos($e->getMessage(), 'UK_QUEUE_TRUCK') !== false) {
                throw new Exception("لا يمكن المتابعة حيث أن الشاحنة مضافة مسبقا على الدور ولا يمكن اضافتها مرة أخرى");
            }
            if ($e->getCode() == 555) {
                $this->_waybillCore->logTrxError($this->_request->id, $e->getMessage(), 0);
            }
            throw new Exception($e->getMessage());
        }
    }

    // ---------------------------------------------------------------------------------- //
    // ------------------- change status of waybill to REVOKED (Tabweesh) --------------- //
    // ------------------- params: id, revokeReason, remarks ---------------------------- //
    // ---------------------------------------------------------------------------------- //
    public function revokeWaybillByTabweesh()
    {

        // get the waybill bean
        $waybillBean = $this->_waybillCore->getWaybillBasic($this->_request->id, $_SESSION['user_id']);
        $revokeReason = $this->_request->revokeReason;

        // prepare params
        if ($revokeReason == 'rejectFromDriver') {
            $revokeReason = ' تم تبويش الحمل بسبب رفض السائق للحمل أو الوجهة ';
            $newStatus = 'REVOKED';
        } else if ($revokeReason == 'truckMalfunction') {
            $revokeReason = '  تم تبويش الحمل بسبب عطل في الشاحنة ';
            $newStatus = 'INACTIVE';
        } else if ($revokeReason == 'overflowAmount') {
            $revokeReason = ' تم تبويش الحمل بسبب انتهاء الكمية على الباخرة ';
            $newStatus = 'INACTIVE';
        } else if ($revokeReason == 'wrongTruckingCompany') {
            $revokeReason = 'تم الغاء المستند بسبب تقديمه على شركة نقل خطأ';
            $newStatus = 'INACTIVE';
        } else {
            $revokeReason = 'تم الغاء المستند بسبب ';
            $newStatus = 'INACTIVE';
        }

        // make sure the waybill has no payment
        if ($waybillBean->document->freight->payments && sizeof($waybillBean->document->freight->payments) > 0) {
            $allowTabweesh = false;
            $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
            foreach ($userRolesArray as $role) {
                if ($role == 'OPERATION_MANAGER' || $role == 'TELLER_SUPERVISOR' || $role == 'OPERATION_SUPERVISOR') {
                    $allowTabweesh = true;
                    break;
                }
            }
            if (!$allowTabweesh) {
                throw new Exception("لا تستطيع المتابعة ، الشاحنة عليها ذمة مالية ، الرجاء مراجعة مدير العمليات");
            }
        }

        // requee waybill in case the waybill status is new
        if ($waybillBean->status == 'NEW') {
            $QueueCore = new QueueCore();
            $tenderCore = new TenderCore();

            $man = $tenderCore->getTenderManifest($waybillBean->tender_id, 0);
            $target_queue = $man['queues'][$waybillBean->document->queue->id]['requeue_rules']['target_queue'];
            if (!$target_queue) {
                $target_queue = 1;  // TEMP
            }

            // if the waybill is being revoked from new , and the tender is Crude Oil
            if ($waybillBean->tender_id == 11) {
                // get tender_order_company id
                $sqlQuery = "SELECT
                                toc.id
                            FROM
                                tender_order_company toc,
                                tender_company_view t
                            WHERE
                                toc.STATUS = 'ACTIVE'
                                    AND toc.tender_company_id = t.id
                                    AND t.tender_id = ?
                                    AND tender_order_id = ?
                                    AND t.trucking_company_id = ?";
                $param = [$waybillBean->tender_id, $waybillBean->document->order->id, $waybillBean->trucking_company_id];
                $result = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

                // decrease number of used waybill in tender_order_company
                if ($result[0]->id) {
                    $sqlQuery2 = "UPDATE
                                    tender_order_company toc
                                SET waybills = waybills-1
                                WHERE
                                    toc.id = ?";
                    $param2 = [$result[0]->id];
                    $result2 = DBConnection::runBindDatabaseQuery($sqlQuery2, $param2);
                }
            } else {
                // add the truck to queue again in case it has no queue, unless for tender JO_PETROL
                $queuesInfoFilter = [
                    ['key' => 'truck_id', 'val' => $waybillBean->truck_id],
                    ['key' => 'rank', 'op' => 'is not null'],
                    ['key' => 'tender_id', 'val' => $waybillBean->tender_id],
                    ['key' => 'q_id', 'val' => $target_queue]
                ];

                $queuesInfo = $this->_queueCore->searchQueue($queuesInfoFilter, 1, 0, 0);
                if ($queuesInfo->found_rows == 0) {
                    $new_queue_id = $QueueCore->addQueue(
                        $waybillBean->truck_id,
                        $waybillBean->driver_id,
                        $waybillBean->trailer_id,
                        $target_queue,
                        $waybillBean->tender_id,
                        $_SESSION['user_id']
                    );
                }
            }
        }

        // if the waybill is ACTIVE and crude oil , then delete it from JO_PETROL
        if ($waybillBean->status == 'ACTIVE') {
            if ($waybillBean->tender_id == 11) {
                $jo_petrol_integration = new Jo_Petrol();
                $jo_petrol_integration->deleteWaybill($waybillBean->id);
            }
        }


        // change status
        $this->_waybillCore->changeStatus($this->_request->id, $newStatus, $_SESSION['user_id']);

        // add remarks to activity
        $addNoteCore = new Add_notes_core();
        $addNoteCore->addNotes('waybill', $this->_request->id, $revokeReason . " - " . $this->_request->remarks, $_SESSION['user_id']);

        // add note to waybill document
        $waybillJson = $waybillBean->document;
        $waybillJson->revokeReason = new stdClass();
        $waybillJson->revokeReason->reason = $this->_request->revokeReason;
        $waybillJson->revokeReason->reason_caption = $revokeReason;
        $waybillJson->revokeReason->remarks = $this->_request->remarks;
        // unlock waybill tender claim
        $waybillJson->tender_claim = null;
        $waybillBean->document = $waybillJson;

        // if the waybill has external service node, clear it
        if ($waybillJson->service_list) {
            $waybillJson->service_list = new stdClass();
        }
        $this->_waybillCore->updateWaybill($waybillBean, $this->_request->id, $_SESSION['user_id']);
        $this->_waybillCore->logActivity(
            $this->_request->id,
            "الغاء المستند",
            $revokeReason . " " . $this->_request->remarks,
            "Waybill_Inactive",
            $_SESSION['user_id']
        );

        //activate the other queues if the truck has more than one
        $q_id = $waybillJson->integeration_details->queue->q_id;
        $queuesToActivateSearchFilter = [
            ['key' => 'truck_id', 'val' => $waybillBean->truck_id],
            ['key' => 'status', 'val' => 'HELD'],
            ['key' => 'tender_id', 'val' => [$waybillBean->tender_id], 'op' => 'not in'],
            ['key' => 'q_id', 'val' => [$q_id], 'op' => 'not in']
        ];
        $queuesToActivate = $this->_queueCore->searchQueue($queuesToActivateSearchFilter, 1000, 0, $_SESSION['user_id'])->data;

        // iterate and change status to HELD for each queue
        foreach ($queuesToActivate as $queue) {
            $this->_queueCore->changeStatus($queue->id, 'ACTIVE', 0);
            $this->_queueCore->logActivity(
                $queue->id,
                "فك تجميد الدور",
                "تم فك تجميد الدور",
                "activate_queue",
                0
            );
        }


        //remove truck from Ithad queue
        if ($waybillBean->tender_id == 3) {
            $ithadQueueuFilter = [
                ['key' => 'truck_id', 'val' => $waybillBean->truck_id],
                ['key' => 'tender_id', 'val' => 3],
                ['key' => 'status', 'val' => 'ACTIVE'],
                ['key' => 'q_id', 'val' => 2]
            ];
            $ithadQueue = $this->_queueCore->searchQueue($ithadQueueuFilter, 1000, 0, $_SESSION['user_id'])->data;
            // remove ithad queue
            foreach ($ithadQueue as $queue) {
                $this->_queueCore->changeStatus($queue->id, 'INACTIVE', $_SESSION['user_id']);
                $this->_queueCore->logActivity(
                    $queue->id,
                    "حذف الشاحنة عن الدور",
                    "تم حذف الشاحنة عن دور الاتحاد",
                    "delete_queue",
                    $_SESSION['u_id']
                );
            }
        }
        // return message
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
        parent::response($Result);
    }


    // ------------------------------------------------------------------------------------------ //
    // ------------------- Print the waybill and attemp to chnage its status -------------------- //
    // ------------------- Param: waybill_id ---------------------------------------------------- //
    // ------------------------------------------------------------------------------------------ //
    public function printWaybill()
    {
        try {
            // get the waybill bean
            $waybillBean = $this->_waybillCore->getWaybillBasic($this->_request->waybill_id, $_SESSION['user_id']);

            // if the user who asked for print is ca,  make sure the waybill has loading date in order to allow print
            if ($waybillBean->document->cargo[0]->consigner->ca->id == $_SESSION['ca_id']) {
                $lnw = $waybillBean->document->cargo[0]->weights->loading->net_weight;

                if (!$lnw) {
                    throw new Exception("لا تستطيع طباعة البون بدون وجود وزن التحميل");
                }
            }


            // validate if the trailer number is not saved in waybill
            $trn = $waybillBean->document->carrier[0]->trailer->tn;
            if (!$trn && $waybillBean->document->tender->id != 22) {

                // if the truck is signal ignore this validation
                $tn = $waybillBean->document->carrier[0]->truck->tn;
                $truckFilter = [['key' => "tn", 'val' => $tn], ['key' => "status", 'val' => ['INACTIVE'], 'op' => 'not in']];
                $truckQuery = $this->_truckCore->searchTrucks($truckFilter, 1, 0, 0);
                if ($truckQuery->data[0]->cat != "TRUCK-SINGLE") {
                    throw new Exception("لا تستطيع المتابعة ، رقم المقطورة غير موجود");
                }
            }

            $tn = $waybillBean->document->carrier[0]->truck->tn;

            // validate if the truck owner has delayed claim
            $MGPAY_tender = $this->_tenderCore->getMgPayTender();
            $tenderTruckSearchFilter = [
                ['key' => 'tender_id', 'val' => $MGPAY_tender->id],
                ['key' => 'truck_id', 'val' => $waybillBean->truck_id],
                ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in']
            ];
            $tenderTruckResult = $this->_tenderCore->searchTenderTruck($tenderTruckSearchFilter, 1, 0, 0);
            if ($tenderTruckResult->found_rows > 0) {
                $financial_details = $tenderTruckResult->data[0]->financial_details;
                $financial_details = json_decode($financial_details);
                $payee_reference_value = $financial_details->truck_owner->id;

                $request = new stdClass();
                $request->filter = new stdClass();
                $request->filter->status_in = ["ACTIVE"];
                $request->filter->payee_reference_value = $payee_reference_value;
                $request->filter->payee_reference_code = "TRUCK_OWNER";

                $claimsReuslt = $this->_fps->searchClaims($request, 0);
                // search if the truck_owner has any delayed claims, stop it here
                foreach ($claimsReuslt['data'] as $claim) {
                    $claim_details = json_decode($claim['claim_details']);
                    if (isset($claim_details->is_delayed) && $claim_details->is_delayed) {

                        $userRolesArray = explode(",", $_SESSION['USER_ROLES']);

                        if ($_SESSION['type'] == "CORPORATE") {
                            $userRolesArray = explode(",", $_SESSION['COMPANY_EMPLOYEE_ROLES']);
                        } else {
                            $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
                        }

                        $can_continue = false;
                        foreach ($userRolesArray as $role) {
                            if ($role == 'OPERATION_MANAGER' || $role == 'CA_LOADING_OPERATOR') {
                                $can_continue = true;
                            }
                        }
                        if (!$can_continue) {
                            throw new Exception("لا تستطيع المتابعة، مالك الشاحنة عليه سلفة متعثرة");
                        }
                    }
                }
            }

            // validate if the truck still has NEW MG_PAY contract
            $tenderTruckSearchFilter = [
                ['key' => 'tender_id', 'val' => $MGPAY_tender->id],
                ['key' => 'truck_id', 'val' => $waybillBean->truck_id],
                ['key' => 'status', 'val' => ['NEW'], 'op' => 'in']
            ];
            $mg_payTenderTruck = $this->_tenderCore->searchTenderTruck($tenderTruckSearchFilter, 1, 0, 0);
            if ($mg_payTenderTruck->found_rows) {
                if ($claimsReuslt['found_rows'] > 0) {
                    throw new Exception("الشاحنة معرفة على مشروع السلف ولديها سلفة ديزل ولم يتم تفعيل عقدها بعد");
                }
            }

            // check if there is auto action followed by print to make the waybill active
            if ($waybillBean->status != 'ACTIVE' && $waybillBean->status != 'COMPLETE'  && $waybillBean->status != 'ONROAD') {
                $autoAction_1 = getAutoAction('WAYBILL', $waybillBean->status, 'ACTIVE', $_SESSION['user_id'], $_SESSION['u_id']);
                if ($autoAction_1) {
                    $this->_waybillCore->changeStatus($this->_request->waybill_id, 'ACTIVE', $_SESSION['user_id']);
                }
            }
            $this->_waybillCore->logActivity($this->_request->waybill_id, " طباعة مستند", "", "print_waybill", $_SESSION['user_id']);

            //return Success reponse
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
            parent::response($Result);
        } catch (Exception $e) {
            // log trx error here in case the error is financial related
            if ($e->getCode() == 555) {
                $this->_waybillCore->logTrxError($this->_request->waybill_id, $e->getMessage(), 0);
            }
            DBConnection::rollBackTransaction();
            throw $e;
        }
    }

    // ------------------------------------------------------------------------------------------ //
    // ------------------- approve then Print the waybill ------------------- //
    // ------------------- Param: waybill_id ---------------------------------------------------- //
    // ------------------------------------------------------------------------------------------ //
    public function approveAndPrint()
    {
        try {
            // get the waybill bean
            $waybillBean = $this->_waybillCore->getWaybillBasic($this->_request->waybill_id, $_SESSION['user_id']);

            // validate if the trailer number is not saved in waybill
            $trn = $waybillBean->document->carrier[0]->trailer->tn;
            if (!$trn) {

                // if the truck is signal ignore this validation
                $tn = $waybillBean->document->carrier[0]->truck->tn;
                $truckFilter = [['key' => "tn", 'val' => $tn], ['key' => "status", 'val' => ['INACTIVE'], 'op' => 'not in']];
                $truckQuery = $this->_truckCore->searchTrucks($truckFilter, 1, 0, 0);
                if ($truckQuery->data[0]->cat != "TRUCK-SINGLE") {
                    throw new Exception("لا تستطيع المتابعة ، رقم المقطورة غير موجود");
                }
            }

            DBConnection::startTransaction();
            // approve waybill
            $this->_waybillCore->changeStatus($this->_request->waybill_id, 'APPROVED', $_SESSION['user_id']);

            // activate waybill
            $this->_waybillCore->changeStatus($this->_request->waybill_id, 'ACTIVE', $_SESSION['user_id']);

            // log print
            $this->_waybillCore->logActivity($this->_request->waybill_id, " طباعة مستند", "", "print_waybill", $_SESSION['user_id']);

            DBConnection::commitTransaction();

            //return Success reponse
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
            parent::response($Result);
        } catch (Exception $e) {
            // log trx error here in case the error is financial related
            if ($e->getCode() == 555) {
                $this->_waybillCore->logTrxError($this->_request->waybill_id, $e->getMessage(), 0);
            }
            DBConnection::rollBackTransaction();
            throw $e;
        }
    }

    // --------------------------------------------------------------------------------------- //
    // ---------------------- validate if the weight request is valid ------------------------ //
    // --------------------------------------------------------------------------------------- //
    public function validateWeighing($weight_type, $waybill_id, $weight_value, $confirm)
    {

        // validate params
        if (!$weight_type) {
            throw new Exception("WAYBILL.MISSING_WEIGHT_TYPE");
        }

        // get the waybill bean
        $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);
        if (!$waybillBean) {
            throw new Exception("WAYBILL.INVALID_WAYBILL");
        }

        // validate to see if the weight has fines or not
        if (strtoupper($weight_type) == "DNW") {
            if (!$confirm || $confirm == "false") {

                $paymentCore = new PaymentCore();
                $dischargeFine = $paymentCore->calculateDischargeFine($waybill_id, null, $weight_value);

                if ($dischargeFine->total_fines > 0) {
                    $tn = $waybillBean->document->carrier[0]->truck->tn;
                    $discharge_fine = $dischargeFine->fine_loss_in_kg;

                    $fineMessage = "سيترتب على عملية التفريغ للشاحنة رقم $tn " .
                        " غرامة نقص بقيمة $dischargeFine->total_fines دينار " .
                        " وذلك لوجود نقص  مغرم $discharge_fine كيلو ";

                    throw new Exception("DISCHARGE.FINES_" . $dischargeFine->warning_level . "_" . $fineMessage);
                }
            }
        }
    }


    // -------------------------------------------------------------------------------------------------- //
    // ------------------- update the weight for a certain waybill -------------------------------------- //
    // ------------------- weight_type , weight_value, waybill_id , confirm ----------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function setWeight()
    {

        try {
            // init objects
            $paymentCore = new PaymentCore();
            $cargoCore = new CargoCore();
            $tenderCore = new TenderCore();
            $destination_id = $this->_request->destination_id;

            // validate weighing process
            $this->validateWeighing($this->_request->weight_type, $this->_request->waybill_id, $this->_request->weight_value, $this->_request->confirm);

            // complete any auto action before loading or discharge
            $waybillBean = $this->_waybillCore->getWaybillBasic($this->_request->waybill_id, $_SESSION['user_id']);

            $cargo_id = $waybillBean->document->cargo[0]->cargo_id;
            $tn = $waybillBean->document->carrier[0]->truck->tn;
            $cargoBean = $this->_cargoCore->getCargo($cargo_id, $_SESSION['user_id']);
            $cargo_name = json_decode($cargoBean)->name;


            $driver_id = $waybillBean->driver_id;
            $driverBean = $this->_driverCore->getDriver($driver_id, $_SESSION['user_id']);
            $user_id = json_decode($driverBean)->user_id;
            $userBean = $this->_userCore->getUser($user_id, $_SESSION['user_id']);

            $poll_id = json_decode($cargoBean)->waybill_template->discharge_report ? json_decode($cargoBean)->waybill_template->discharge_report->poll_id : null;
            if ($poll_id) {
                $userBean = json_decode($userBean);
                $recipients = [];

                $rec['user_id'] = $userBean->id;
                $rec['bind_params'] = json_encode(array('wn' => $waybillBean->wn, 'cargo_name' => $cargo_name, 'tn' => $tn, 'waybill_id' => $this->_request->waybill_id));
                $rec['communication_channels'] = [
                    ['channel' => 'FCM', 'details' => ['fcm_registration_id' => $userBean->notification_token], 'status' => 'ACTIVE', 'priority' => 1],
                ];
                $recipients[] = $rec;
                $this->_pollIntegration->appendRecipientToPoll($poll_id, $recipients);
            }

            switch (strtoupper($this->_request->weight_type)) {
                case "LNW": {
                        // in case the waybill is ACTIVE and user can change it is to PENDING, do it on behafe of him
                        if ($waybillBean->status == "ACTIVE") {
                            $autoAction = getAutoAction('WAYBILL', 'ACTIVE', 'PENDING', $_SESSION['user_id'], $_SESSION['u_id']);
                            if ($autoAction) {
                                $this->_waybillCore->changeStatus($this->_request->waybill_id, 'PENDING', $_SESSION['user_id']);
                                $this->_waybillCore->logActivity($this->_request->waybill_id, " دخول الى موقع التحميل", "", "CARGO_ORIGIN_ENTER", $_SESSION['user_id']);
                            }
                        }
                        break;
                    }
                case "DNW": {
                        // in case the waybill is ONROAD and user can change it is to ARRIVED, do it on behafe of him
                        if ($waybillBean->status == "ONROAD") {
                            $autoAction = getAutoAction('WAYBILL', 'ONROAD', 'ARRIVED', $_SESSION['user_id'], $_SESSION['u_id']);
                            if ($autoAction) {
                                $this->_waybillCore->changeStatus($this->_request->waybill_id, 'ARRIVED', $_SESSION['user_id']);
                                $this->_waybillCore->logActivity($this->_request->waybill_id, " دخول الى موقع التفريغ", "", "CARGO_DESTINATION_ENTER", $_SESSION['user_id']);
                            }
                        }

                        if ($waybillBean->status == "ONROAD" && $waybillBean->tender_id == 22) {
                            $this->_waybillCore->changeStatus($this->_request->waybill_id, 'ARRIVED', $_SESSION['user_id']);
                            $this->_waybillCore->logActivity($this->_request->waybill_id, " دخول الى موقع التفريغ", "", "CARGO_DESTINATION_ENTER", $_SESSION['user_id']);
                        }

                        break;
                    }
            }

            DBConnection::startTransaction();

            $waybillBean = $this->_waybillCore->getWaybillBasic($this->_request->waybill_id, $_SESSION['user_id']);

            // fill the weight in the correct place in waybill document
            $cargoJSON = $waybillBean->document->cargo[0];

            switch (strtoupper($this->_request->weight_type)) {
                case "LNW": {

                        if (strpos(strtoupper($cargoJSON->cargo_unit), 'KG') !== false) {
                            $cargoJSON->weights->loading->net_weight = trim($this->_request->weight_value);
                        }
                        if (strpos(strtoupper($cargoJSON->cargo_unit), 'COUNT') !== false) {
                            $cargoJSON->weights->loading->count = trim($this->_request->input_count);
                        }

                        $loading_datetime = DBConnection::getSystemDate();
                        if ($this->_request->loading_date) {
                            $loading_datetime = $this->_request->loading_date;
                        }

                        $cargoJSON->weights->loading->time_stamp = $loading_datetime;
                        break;
                    }
                case "DNW": {
                        if (strpos(strtoupper($cargoJSON->cargo_unit), 'KG') !== false) {
                            $cargoJSON->weights->discharge->net_weight = trim($this->_request->weight_value);
                        }
                        if (strpos(strtoupper($cargoJSON->cargo_unit), 'COUNT') !== false) {
                            $cargoJSON->weights->discharge->count = trim($this->_request->input_count);
                        }

                        $discharge_datetime = DBConnection::getSystemDate();
                        if ($this->_request->discharge_date) {
                            $discharge_datetime = $this->_request->discharge_date;
                        }
                        $cargoJSON->weights->discharge->time_stamp = $discharge_datetime;
                        break;
                    }
                default: {
                        throw new Exception("WAYBILL.INVALID_WEIGHT_TYPE");
                    }
            }

            // save gross weight
            if ($this->_request->gross_weight) {
                $cargoJSON->weights->loading->gross_weight->weight = $this->_request->gross_weight;
                $cargoJSON->weights->loading->gross_weight->time_stamp = DBConnection::getSystemDate();
            }

            $waybillBean->document->cargo[0] = $cargoJSON;

            // save the loading or discharge weight and time_stamp in the waybill bean document
            $this->_waybillCore->updateWeight($waybillBean, $_SESSION['user_id']);
            // get fresh copy of waybill
            $waybillBean = $this->_waybillCore->getWaybillBasic($this->_request->waybill_id, $_SESSION['user_id']);


            // ----------------------- Waybill change status section ------------------------------------ //
            // if the loading weights are filled , chnage the waybill status
            switch (strtoupper($this->_request->weight_type)) {

                    // --------------------------- Load Net Weight (تحميل) -------------------------------- //
                case "LNW": {
                        $weight_value = trim($this->_request->weight_value);
                        if ($waybillBean->status == 'PENDING' || $waybillBean->status == 'ACTIVE') {
                            $this->_waybillCore->changeStatus($this->_request->waybill_id, 'ONROAD', $_SESSION['user_id']);
                            // send SMS to truck owner
                            $tn = $waybillBean->document->carrier[0]->truck->tn;
                            $trn = $waybillBean->document->carrier[0]->trailer->tn;

                            $man = $tenderCore->getTenderManifest($waybillBean->document->tender->id, 0);
                            if ($man['INFORM_OWNER_BY_SMS'] && $man['INFORM_OWNER_BY_SMS'] == "true") {
                                $this->_truckCore->informTruckOwner($waybillBean->truck_id, "تحميل الشاحنة رقم $tn بوزن $weight_value كيلو");
                            }
                        }

                        if ($waybillBean->tender_id == 3 || $waybillBean->tender_id == 13) {
                            $taskQueuesCore = new TaskQueuesCore();
                            $taskQueuesCore->createCloseWaybillTask($waybillBean->id, 12, "اغلاق المستند بسبب مرور 12 ساعة على التحميل");
                        }

                        // record this weight in cargo
                        $cargo_id = $cargoJSON->cargo->id;
                        if (!$cargo_id) {
                            $cargo_id = $cargoJSON->cargo_id;
                        }
                        $weight_type = 'loading';

                        // record the loaded/disharged weight in cargo bean to be added to the accumulated weight
                        $original_lnw = $waybillBean->document->cargo[0]->weights->loading->net_weight;
                        $cargoCore->recordWeightInCargo($weight_value, $weight_type, $cargo_id, $original_lnw);
                        $this->_waybillCore->logActivity($this->_request->waybill_id, "تحميل", "وزن التحميل : " . $weight_value . " كغم ", "LOAD_CARGO", $_SESSION['user_id']);

                        $wallEntry = new stdClass();
                        $wallEntry->title = "تحميل الشاحنة $tn";
                        $wallEntry->msg = "تم تحميل الشاحنة :$tn+$trn - بوزن: " . $weight_value;
                        $this->_waybillCore->informWaybillContactPerson($waybillBean->id, $wallEntry);

                        // reply to ticket
                        $ticket = $waybillBean->document->integeration_details->ticket;
                        if ($ticket) {
                            $note = [
                                "senderName" =>  'مدارج للخدمات اللوجستية' . " - " . $_SESSION['employee_id'],
                                "title" => "تحديث وضع الإرسالية $waybillBean->wn ",
                                "body" =>  "تم تحميل الشاحنة :$tn+$trn - بوزن: " . $weight_value
                            ];

                            if (gettype($ticket) == "array") {
                                foreach ($ticket as $t) {
                                    $this->_customerCare->replyToTicket($t->ticket_id, $note);
                                }
                            } else {
                                $this->_customerCare->replyToTicket($ticket->ticket_id, $note);
                            }
                        }


                        break;
                    }

                    // --------------------------- Discharge Net Weight (تفريغ) -------------------------------- //
                case "DNW": {
                        $this->_waybillCore->changeStatus($this->_request->waybill_id, 'CLOSED', $_SESSION['user_id']);

                        $tn = $waybillBean->document->carrier[0]->truck->tn;
                        $trn = $waybillBean->document->carrier[0]->trailer->tn;
                        $weight_value = trim($this->_request->weight_value);

                        // send SMS to truck owner
                        $man = $tenderCore->getTenderManifest($waybillBean->document->tender->id, 0);
                        if ($man['INFORM_OWNER_BY_SMS'] && $man['INFORM_OWNER_BY_SMS'] == "true") {
                            $this->_truckCore->informTruckOwner($waybillBean->truck_id, "تفريغ حمولة الشاحنة رقم $tn بوزن $weight_value كيلو");
                        }

                        // record the loaded/disharged weight in cargo bean to be added to the accumulated weight
                        $cargo_id = $cargoJSON->cargo->id;
                        if (!$cargo_id) {
                            $cargo_id = $cargoJSON->cargo_id;
                        }

                        $weight_type = 'discharge';
                        $original_dnw = $waybillBean->document->cargo[0]->weights->discharge->net_weight;
                        $cargoCore->recordWeightInCargo($weight_value, $weight_type, $cargo_id, $original_dnw);

                        $this->_waybillCore->logActivity($this->_request->waybill_id, "تفريغ", "وزن التفريغ : " . $weight_value . " كغم ", "DISCHARGE_CARGO", $_SESSION['user_id']);

                        $wallEntry = new stdClass();
                        $wallEntry->title = "تفريغ الشاحنة $tn";
                        $wallEntry->msg = "تم تفريغ الشاحنة :$tn+$trn - بوزن: " . $weight_value;
                        $this->_waybillCore->informWaybillContactPerson($waybillBean->id, $wallEntry);

                        break;
                    }
            }

            if ($destination_id) {
                $this->_waybillCore->changeRoute($this->_request->waybill_id, $destination_id, $_SESSION['user_id']);
            }

            DBConnection::commitTransaction();

            //return Success reponse
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();

            // log trx error here in case the error is financial related
            if ($e->getCode() == 555) {
                $this->_waybillCore->logTrxError($this->_request->waybill_id, $e->getMessage(), 0);
            }
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------------------- //
    // ------------------- Change destination id for a certain waybill --------------------- //
    // ------------------- waybill_id , destination_id , ----------------------------------- //
    // ------------------------------------------------------------------------------------- //
    public function changeRoute()
    {

        if ($this->_request->destination_id == 91000000) {
            throw new Exception("لا تستطيع تحديد الأردن كوجهة للمستند");
        }

        $this->_waybillCore->changeRoute($this->_request->waybill_id, $this->_request->destination_id, $_SESSION['user_id']);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
        parent::response($Result);
    }

    // ------------------------------------------------------------------------------------- //
    // ------------------- update waybill driver and trailer number ------------------------ //
    // ------------------- id , driver_id , trailer_id , ----------------------------------- //
    // ------------------------------------------------------------------------------------- //
    public function updateWaybill()
    {

        try {
            // convert user input from JSON to Object
            $waybillBean = new stdClass();
            $waybillBean->id = $this->_request->id;
            $waybillBean->driver_id = $this->_request->driver_id;
            $nafith_wn = $this->_request->nafith_wn;
            if ($this->_request->trailer_id) {
                $waybillBean->trailer_id = $this->_request->trailer_id;
            }
            if ($this->_request->trn) {
                $truckCore = new TruckCore();
                $truckFilter = [['key' => "tn", 'val' => $this->_request->trn], ['key' => "status", 'val' => ['INACTIVE'], 'op' => 'not in']];
                $truckQuery = $truckCore->searchTrucks($truckFilter, 1, 0, $_SESSION['user_id']);
                if ($truckQuery->found_rows == 0) {
                    throw new Exception("رقم المقطورة غير صحيح");
                }
                $waybillBean->trailer_id = $truckQuery->data[0]->id;
            }
            if ($this->_request->truck_owner_id) {
                $waybillBean->truck_owner_id = $this->_request->truck_owner_id;
            }

            //tn
            if ($this->_request->tn) {
                $truckCore = new TruckCore();
                $truckFilter = [['key' => "tn", 'val' => $this->_request->tn], ['key' => "status", 'val' => ['INACTIVE'], 'op' => 'not in']];
                $truckQuery = $truckCore->searchTrucks($truckFilter, 1, 0, $_SESSION['user_id']);
                if ($truckQuery->found_rows == 0) {
                    throw new Exception("رقم الشاحنة غير صحيح");
                }
                $waybillBean->tn = $this->_request->tn;
                $waybillBean->truck_id = $truckQuery->data[0]->id;
            }

            if ($nafith_wn) {
                $waybillBean->nafith_wn = $nafith_wn;
            }


            // update create_date
            if ($this->_request->create_date) {
                $waybillBean->create_date = $this->_request->create_date;
            }
            $this->_waybillCore->updateWaybill($waybillBean, $this->_request->id, $_SESSION['user_id']);

            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
            parent::response($Result);
        } catch (Exception $e) {
            if (strpos($e->getMessage(), "uk_waybill_active_driver")) {
                throw new Exception("لا تستطيع المتابعة ، السائق لديه رحلة غير منتهية");
            } else {
                throw new Exception($e->getMessage());
            }
        }
    }

    // --------------------------------------------DEPRECATED------------------------------------------------------------ //
    // ---------------------- create single waybill be providing truck_queue_id, order_id, and cargo_id ----------------- //
    // ------------------------------------------------------------------------------------------------------------------ //
    public function createWaybillByEndUser()
    {

        try {

            //TODO: make the proper security validation here


            // prepare beans
            $QueueCore = new QueueCore();
            $CargoCore = new CargoCore();
            $TenderCore = new TenderCore();
            $queueBean = $QueueCore->getQueuebasic($this->_request->id,  $_SESSION['user_id']);
            $cargoBean = $CargoCore->getCargobasic($this->_request->cargo_id,  $_SESSION['user_id']);
            $orderBean = $TenderCore->getTenderOrderBasic($this->_request->order_id,  $_SESSION['user_id']);

            // prepare data for create waybill method
            $tender_id = $queueBean->tender_id;
            $queue_id = $queueBean->q_id;
            $order_id = $this->_request->order_id;
            $cargo_id = $this->_request->cargo_id;
            $truck_id = $queueBean->truck_id;
            $trailer_id = $queueBean->trailer_id;
            $driver_id = $queueBean->driver_id;
            $truck_owner_id = $queueBean->truck_owner_id;
            $trailer_owner_id = $queueBean->truck_owner_id;
            $trucking_company_id = '395'; //TODO: fix this
            $ca_company_id = $cargoBean->waybill_template->cargo[0]->consigner->ca_id;
            $origin_id = prepareLocationValue($cargoBean->waybill_template->negotiable_instructios->route->origin, $cargoBean);
            $destination_id = prepareLocationValue($cargoBean->waybill_template->negotiable_instructios->route->destination, $cargoBean);
            $user_id =  $_SESSION['user_id'];

            // create waybill
            DBConnection::startTransaction();
            $waybill_result = $this->_waybillCore->createWaybill(
                $tender_id,
                $queue_id,
                $order_id,
                $cargo_id,
                $truck_id,
                $trailer_id,
                $driver_id,
                $truck_owner_id,
                $trailer_owner_id,
                $trucking_company_id,
                $ca_company_id,
                $origin_id,
                $destination_id,
                $user_id
            );

            // change queue record status to CLOSE
            $QueueCore->changeStatus($queueBean->id, 'CLOSED', 0); // Closed By System

            DBConnection::commitTransaction();

            $Result['ERRORCODE'] = "0";
            $Result['waybill_id'] = $waybill_result->id;
            $Result['wn'] = $waybill_result->wn;
            $Result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------- //
    // ---------------------- change cargo on selected waybill ----------------- //
    // ---------------------- cargo_id, waybill_id ----------------------------- //
    // ------------------------------------------------------------------------- //
    public function changeCargo()
    {

        $this->_waybillCore->changeCargo($this->_request->id, $this->_request->cargo_id, $_SESSION['user_id']);

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
        parent::response($Result);
    }


    // ------------------------------------------------------------------------- //
    // -----------------Create json file for waybill invoices ------------------ //
    // ---------------------- params: filter ----------------------------------- //
    // ------------------------------------------------------------------------- //
    public function createWaybillInvoiceJson()
    {

        // filter only the request comming from Minagate Office
        $client_ip_address = get_client_ip();
        if ($client_ip_address != '82.212.125.144') {  // Minagate office IP
            throw new Exception('ACCESS_DENIED');
        }

        // prepare the filter
        $jsonFilter = $this->prepareFilter();

        // call the API to get the json
        $Result = $this->_waybillCore->createWaybillInvoiceJson($this->_request->title, $this->_request->sub_title, $jsonFilter);
        parent::response($Result);
    }


    // --------------------------------------------------------------------------------------- //
    // --------------------- Validate truck in order to submit manual waybill----------------- //
    // --------------------------------------------------------------------------------------- //
    public function validateTruckForManualWaybill()
    {

        $truck_id = $this->_request->truck_id;
        $tenderCore = new TenderCore();

        // searchy for truck tender truck status
        // validate if the truck has pending tender truck
        $tenderTruckSearchFilter = [
            ['key' => 'tender_id', 'val' => 3],
            ['key' => 'truck_id', 'val' => $truck_id],
            ['key' => 'status', 'val' => 'PENDING']
        ];
        $tenderTrucks = $tenderCore->searchTenderTruck($tenderTruckSearchFilter, 1, 0, $_SESSION['user_id']);
        if ($tenderTrucks->found_rows > 0) {
            throw new Exception('عقد تشغيل الشاحنة على المشروع موقوف');
        }
    }


    // ------------------------------------------------------------------------------------- //
    // --------------------- get last 2 trips for a certain truck on البواخر----------------- //
    // -------------------------------------------------------------------------------------- //
    public function getLastTrips()
    {

        $tn = $this->_request->tn;

        // prepare filter
        $waybillFilter = [
            ['key' => 'tn', 'val' => $tn],
            ['key' => 'status', 'val' => 'CLOSED'],
            ['key' => 'tender_id', 'val' => '3']
        ];

        // search for the last 2 waybills
        $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter, 2, 0, $_SESSION['user_id']);

        // prepare result
        $result = [];
        foreach ($waybillResult->data as $wabill) {
            $doc = json_decode($wabill->document);
            $temp = new stdClass();
            $temp->wn = $wabill->wn;
            $temp->destination = $doc->negotiable_instructios->route->destination->name . " (" . $doc->cargo[0]->weights->loading->net_weight . " كغم)";
            $temp->date = $wabill->create_date;

            array_push($result, $temp);
        }
        parent::response($result);
    }


    // --------------------------------------------------------------------------------------------------- //
    // --------------------- get last 2 trips for a certain truck on البواخر + gc permit ----------------- //
    // --------------------------------------------------------------------------------------------------- //
    public function getLastTripswithgcPermit()
    {

        $tn = $this->_request->tn;
        $tender_id = $this->_request->tender_id;
        $tender_id = 3;

        // prepare filter
        $waybillFilter = [
            ['key' => 'tn', 'val' => $tn],
            ['key' => 'status', 'val' => 'CLOSED'],
            ['key' => 'tender_id', 'val' => $tender_id]
        ];

        // search for the last 2 waybills
        $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter, 2, 0, $_SESSION['user_id']);

        // get GC Permit in LTRC System
        $GC_result = $this->_mg_registrar->getGcPermit($tn, $tender_id);

        // prepare result
        $result = [];
        if (gettype($GC_result) == "string") {
            $result['gc_permit'] = $GC_result;
        } else {
            $result['gc_permit'] = $GC_result['CODE'];
        }

        foreach ($waybillResult->data as $wabill) {
            $doc = json_decode($wabill->document);
            $temp = new stdClass();
            $temp->wn = $wabill->wn;
            $temp->destination = $doc->negotiable_instructios->route->destination->name . " (" . $doc->cargo[0]->weights->loading->net_weight . " كغم)";
            $temp->date = $wabill->create_date;

            array_push($result, $temp);
        }
        parent::response($result);
    }


    // -------------------------------------------------------------------------- //
    // --------- Search for the submit page on gltrc system --------------------- //
    // -------------------------------------------------------------------------- //
    public function getGrainsLtrcPermitNumber()
    {

        // get user params
        $tn = $this->_request->tn;

        // call robot to search for LTRC permit number
        $result = $this->_robotIntegration->getGrainsLtrcPermitNumber($tn);

        parent::response($result);
    }


    // -------------------------------------------------------------------------- //
    // --------- Search for the submit page on gltrc system --------------------- //
    // -------------------------------------------------------------------------- //
    public function getLtrcSubmitPermit()
    {

        $tn = $this->_request->tn;
        $tender_id = $this->_request->tender_id;
        if (!$tender_id)
            $tender_id = 3;

        // get GC Permit in LTRC System
        $GC_result = $this->_mg_registrar->getGcPermit($tn, $tender_id);

        $result = [];
        $result['gc_permit'] = $GC_result;
        parent::response($result);
    }


    // ----------------------------------------------------------------------------------------- //
    // ------------------ Search for al arabyia clearing agent waybills ------------------------ //
    // ----------------------------------------------------------------------------------------- //
    public function searchAlarabyiaWaybills()
    {

        // TODO: validate IP_address
        // throw new Exception("ACCESS_DENIED");

        // search waybill
        $wn = $this->_request->wn;
        $waybillFilter = [['key' => 'wn', 'val' => $wn]];
        $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter, 1, 0, $_SESSION['user_id']);

        if ($waybillResult->found_rows > 0) {
            // create follow up task

            // format data
            $doc = json_decode($waybillResult->data[0]->document);

            $result = new stdClass();
            $result->wn = $waybillResult->data[0]->wn;
            $result->driver_id = $doc->carrier[0]->driver->id;
            $result->driver_name = $doc->carrier[0]->driver->name;
            $result->driver_phone = $doc->carrier[0]->driver->phone;
            $result->plate_number = $doc->carrier[0]->truck->tn;
            $result->destination_id = $doc->negotiable_instructios->route->destination->id;
            $result->destination_name = $doc->negotiable_instructios->route->destination->name;
            if ($doc->carrier[0]->truck->tt) {
                $result->truck_type_code = $doc->carrier[0]->truck->tt;
                $result->truck_type_caption = $doc->carrier[0]->truck->tt;
            } else {
                $truckCore = new TruckCore();
                $truckBean = $truckCore->getTruckBasic($doc->carrier[0]->trailer->id, 0);
                $result->truck_type_code = $truckBean->minor_tt;

                if ($truckBean->minor_tt == 201) {
                    $result->truck_type_caption = "قلاب";
                } else if ($truckBean->minor_tt == 203) {
                    $result->truck_type_caption = "تريلا";
                }
            }

            // return it
            parent::response($result);
        } else {
            throw new Exception("NO_DATA_FOUND");
        }
    }


    // --------------------------------------------------------------------------------- //
    // ----------------- Fill waybill info and location info into 1 object ------------- //
    // --------------------------------------------------------------------------------- //
    private function prepareLocationNode($location)
    {

        // // prepare the empty objetcs
        // $locationInfo = $location;
        // $waybillInfo = new stdClass();

        // // get the waybill info
        // $doc = json_decode($wbl->document);
        // $waybillInfo->tn = $wbl->tn;
        // $waybillInfo->trn = $doc->carrier[0]->trailer->tn;
        // $waybillInfo->driver_name = $doc->carrier[0]->driver->name;
        // $waybillInfo->driver_phone = $doc->carrier[0]->driver->phone;
        // $waybillInfo->driver_image = null;
        // if ($wbl->driver_user_id) {
        //     $photos = json_decode($wbl->driver_image);
        //     if ($photos) {
        //         foreach ($photos as $img) {
        //             if ($img->type == 'personal_photo') {
        //                 $waybillInfo->driver_image = $img->url;
        //             }
        //         }
        //     }
        // }
        // $waybillInfo->loading_location = $doc->negotiable_instructios->route->origin->name;
        // $waybillInfo->loading_timestamp = $doc->cargo[0]->weights->loading->time_stamp;
        // $waybillInfo->discharge_location = $doc->negotiable_instructios->route->destination->name;
        // $waybillInfo->discharge_time_stamp = $doc->cargo[0]->weights->discharge->time_stamp;
        // $waybillInfo->tender_name = $doc->tender->name;
        // $waybillInfo->cargo_name = $doc->cargo[0]->name;

        // // use only the location if its newer than waybill create date
        // $waybill_create_date = date_create($wbl->create_date);
        // $location_create_date = date_create($location['location_date']);
        // $dateDiff = date_diff($location_create_date, $waybill_create_date);
        // if ($dateDiff->invert > 0) {
        //     $loc = new stdClass();
        //     $loc->x = $location['long'];
        //     $loc->y = $location['lat'];
        //     $locationInfo['loc'] = $loc;
        // }

        // $result = new stdClass();
        // $result->waybillInfo = $waybillInfo;
        // $result->locationInfo = $locationInfo;
        // return $result;
    }


    // ------------------------------------------------------------------------------------------------------------------------------------- //
    // --------------------------- Get a list of each active waybill , this method is used by tc manager map ------------------------------- //
    // ------------------------------------------------------------------------------------------------------------------------------------- //
    public function getWaybillLatestLocation()
    {
        // in case user provided a search filter
        $waybillFilter = [];
        if ($this->_request->filter) {
            $waybillFilter = json_decode($this->_request->filter);
        }

        // inject the tender_id in case the user is defined on certain tenders
        if ($_SESSION['tender_ids'] && $_SESSION['tender_ids'][0] != "*") {
            $temp = ['key' => 'tender_id', 'val' => $_SESSION['tender_ids'], 'op' => 'in'];
            array_push($waybillFilter, $temp);
        }



        // get active waybills only
        $activeWaybillStatus = DBConnection::getActiveStatus('waybill');

        $waybillFilter[] = ['key' => 'status', 'val' => $activeWaybillStatus, 'op' => 'in'];
        $waybillResult = DBConnection::searchReport("waybill", "02", $waybillFilter, 2000, 0, $_SESSION['user_id']);
        // loop on waybills to extract the driver user_ids
        foreach ($waybillResult->data as &$waybill) {
            $wns[] = $waybill->wn;
            unset($waybill->search_index);
            $waybill_numbers[$waybill->wn] = $waybill;
        }
        // call Minagate tracking system to get the last location of these devices
        $result = [];
        if ($wns && sizeof($wns) > 0) {
            $location_result = $this->_mg_tracking->getLocations_new($wns);

            foreach ($location_result['data'] as $wbl) {
                $temp = [];

                $temp['tn'] = $wbl['tn'];
                $document = json_decode($waybill_numbers[$wbl['waybill_number']]->document);
                $temp['trn'] = $document->carrier[0]->trailer->tn;
                $temp['driver_name'] = $document->carrier[0]->driver->name;
                $temp['driver_phone'] = $document->carrier[0]->driver->phone;
                $temp['wn'] = $wbl['waybill_number'];
                $temp['long'] = $wbl['long'];
                $temp['lat'] = $wbl['lat'];
                $temp['location_date'] = $wbl['location_date'];

                if ($temp['tn'] && $temp['long'] && $temp['lat'])
                    $result[] = $temp;
            }
        }

        // search for land trips
        // call Minagate tracking system to get the last location of these devices
        $data = new stdClass();
        $data->limit = 5000;

        $data->filter = [];
        if ($this->_request->filter) {
            if ($waybillFilter[0]->val && $waybillFilter[0]->val != "NULL") {
                $data->filter[] = ['key' => 'tn', 'val' => $waybillFilter[0]->val];
            }
        }

        $data->method = "getLandTripsDriverNotificanTocken";
        $end_point = '/landtrip';
        $landTripResult = $this->_con->callContainer($end_point, $data, 0);

        if ($landTripResult) {
            $land_trips = [];
            foreach ($landTripResult['data'] as $landTrip) {
                $land_trips[] = $landTrip['serial'];
            }
            $location_result2 = $this->_mg_tracking->getLocations_landtrip($land_trips);

            foreach ($location_result2['data'] as $lt) {

                $trip_details = json_decode($lt['trip_details']);
                if ($trip_details) {
                    $temp = [];
                    $temp['tn'] = $lt['tn'];
                    $temp['trn'] = $trip_details->trn;
                    $temp['cid'] = $trip_details->cid;
                    $temp['serial'] = $lt['land_trip'];
                    $temp['ca_id'] = $trip_details->ca_id;
                    $temp['ca_name'] = $trip_details->ca_name;
                    $temp['iso'] = $trip_details->iso;
                    $temp['destination'] = $trip_details->destination;
                    $temp['driver_name'] = $trip_details->driver_name;
                    $temp['driver_phone'] = $trip_details->driver_phone;
                    $temp['driver_nn'] = $trip_details->driver_nn;
                    $temp['declaration_number'] = $trip_details->declaration_number;
                    $temp['trip_type'] = $trip_details->trip_type;
                    $temp['long'] = $lt['long'];
                    $temp['lat'] = $lt['lat'];
                    $temp['location_date'] = $lt['location_date'];

                    if ($temp['tn'] && $temp['long'] && $temp['lat']) {
                        if ($_SESSION['ca_id']) {
                            // in case the ca is searching,  only show his trucks (trucks that has same ca_id boned)
                            if ($temp['ca_id'] == $_SESSION['ca_id']) {
                                $result[] = $temp;
                            }
                        } else {
                            $result[] = $temp;
                        }
                    }
                }
            }
        }


        //return the result to user
        parent::response([
            "tracked_waybills" => $result,
            "total_waybills_count" => sizeof($result)
        ]);
    }

    // -------------------------------------------------------------------------------------------------------------------------------------- //
    // ----------------- Get GPS info for a certain trip , like the activity time line , mobile app version -------------------- //
    // -------------------------------------------------------------------------------------------------------------------------------------- //
    public function getTripGpsInfo()
    {

        // get user params
        $wn = $this->_request->wn;
        $serial = $this->_request->serial;

        if ($wn) {
            // get waybill bean
            $waybillFilter = [['key' => 'wn', 'val' => $wn]];
            $waybillResult = DBConnection::searchReport("waybill", "02", $waybillFilter, 1, 0, $_SESSION['user_id']);
            $waybillInfo = $waybillResult->data[0];
            $driverImages = json_decode($waybillInfo->driver_image);
            $waybillInfo->driver_image = null;

            if ($driverImages) {
                foreach ($driverImages as $img) {
                    if ($img->type == 'personal_photo') {
                        $waybillInfo->driver_image = $img->url;
                    }
                }
            }

            // get waybill activities to generate timeline
            $waybillBean = $this->_waybillCore->getWaybill($waybillInfo->id, $_SESSION['user_id']);
            $waybillBean = json_decode($waybillBean);
            $waybillActivities = $waybillBean->activity;
            $waybillBean->activity = null;
            $timeLine = [];
            $timeLine['create_date'] = $waybillBean->create_date;
            foreach ($waybillActivities as $act) {
                if ($act->action_code == 'CHANGE_STATUS' && $act->object_new_status_code == 'ACTIVE') {
                    $timeLine['activation_date'] = $act->activity_date;
                }
            }
            $timeLine['loading_date'] = $waybillBean->loading_date;
            $timeLine['discharge_date'] = $waybillBean->discharge_date;
            foreach ($timeLine as $key => $val) {
                if (!$val) continue;
                $timeLine[$key] = date('Y-m-d H:i', strtotime($val));
            }

            // get mobile app version
            $userSearchFilter = [
                ['key' => 'id', 'val' => $waybillInfo->driver_user_id],
                ['key' => 'status', 'val' => 'ACTIVE']
            ];
            $userBean = $this->_userCore->searchUser($userSearchFilter, 1, 0, 0)->data[0];
            $raw_HB = json_decode($userBean->hb)[0];
            $HB = new stdClass();
            $HB->os = $raw_HB->os;
            $HB->brand = $raw_HB->brand;
            $HB->UUID = $raw_HB->UUID;
            $HB->last_seen = $raw_HB->last_seen;
            $HB->app_version = $raw_HB->app_version;
            $HB->android_version = $raw_HB->android_version;
            $HB->model = $raw_HB->platform->constants->Model;

            $result = new stdClass();
            $result->waybillInfo = $waybillInfo;
            $result->timeLine = $timeLine;
            $result->hb = $HB;
        }

        if ($serial) {

            // get landTripInfo
            $userFilter = ['serial' => $serial];
            $data = new stdClass();
            $data->filter = $userFilter;
            $data->limit = 1;
            $data->offset = 0;
            $con = new Container();
            $landTripsResult = $con->searchLandTrip($data, 0);
            if ($landTripsResult['data'][0]) {
                $landTripInfo = json_decode($landTripsResult['data'][0]['document']);
            }

            // get time line
            // $data = new stdClass();
            // $serviceFilter = ['land_trip_id' => $landTripInfo->id, 'code' => 'BOND_DELIVERY'];
            // $data->filter  = $serviceFilter;
            // $data->method = "searchLandTripService";
            // $end_point = '/land_trip';
            // $service_res = $con->callContainer($end_point, $data, $_SESSION['user_id']);

            $timeLine = [];
            $timeLine['bond_delivery'] = null;
            $timeLine['cargo_delivery'] = null;
            $timeLine['container_delivery'] = null;

            // get mobile app version
            $userSearchFilter = [
                ['key' => 'nn', 'val' => $landTripInfo->carrier[0]->driver->nn],
                ['key' => 'status', 'val' => 'ACTIVE']
            ];
            $userBean = $this->_userCore->searchUser($userSearchFilter, 1, 0, 0)->data[0];
            $raw_HB = json_decode($userBean->hb)[0];
            $HB = new stdClass();
            $HB->os = $raw_HB->os;
            $HB->brand = $raw_HB->brand;
            $HB->UUID = $raw_HB->UUID;
            $HB->last_seen = $raw_HB->last_seen;
            $HB->app_version = $raw_HB->app_version;
            $HB->android_version = $raw_HB->android_version;
            $HB->model = $raw_HB->platform->constants->Model;


            $result = new stdClass();
            $result->landTripInfo = $landTripInfo;
            $result->timeLine = $timeLine;
            $result->hb = $HB;
        }

        //return the result to user
        parent::response($result);
    }

    // ------------------------------------------------------------- //
    // ----------------- Get Trip path for certain waybill ---------- //
    // -------------------------------------------------------------- //
    public function getTripPath()
    {

        // get user params
        $wn = $this->_request->wn;
        $accuracy = $this->_request->accuracy;

        // get waybill bean
        $waybillFilter = [['key' => 'wn', 'val' => $wn]];
        $waybillResult = DBConnection::searchReport("waybill", "02", $waybillFilter, 1, 0, $_SESSION['user_id']);
        $waybillBean = $waybillResult->data[0];

        $path_result = $this->_mg_tracking->getTripPath($waybillBean->driver_user_id, $waybillBean->create_date, DBConnection::getSystemDate(), $accuracy);

        parent::response($path_result);
    }


    // ------------------------------------------------------------------------------------ //
    // ----------------------- get list of active waybills -------------------------------- //
    // ------------------------------------------------------------------------------------ //
    public function getActiveWaybills()
    {
        $activeWaybillStatus = DBConnection::getActiveStatus('waybill');
        $activeWaybillCount = [];
        foreach ($activeWaybillStatus as $status) {
            $activeWaybillCount[$status] = 0;
        }
        $waybillFilter[] = ['key' => 'status', 'val' => $activeWaybillStatus, 'op' => 'in'];
        $result = new stdClass();

        // search for waybills
        $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter, 1000, 0, $_SESSION['user_id']);


        foreach ($waybillResult->data as &$waybill) {
            $activeWaybillCount[$waybill->status] += 1;
        }
        $result->activeWaybillCount = $activeWaybillCount;
        $result->size = count($waybillResult->data);

        parent::response($result);
    }


    // ---------------------------------------------------------------------------------- //
    // ------------------ Submit new LTRC waybill --------------------------------------- //
    // ---------------------------------------------------------------------------------- //
    public function submitLTRCWaybill()
    {

        // add remarks
        $addNoteCore = new Add_notes_core();
        $addNoteCore->addNotes('waybill', $this->_request->id, ' تم ارسال معاملة انشاء وثيقة نقل الهيئة لموظفي عمان', $_SESSION['user_id']);
        $this->_waybillCore->logActivity($this->_request->id, "تقديم وثيقة نقل الهيئة", ' تم ارسال معاملة انشاء وثيقة نقل الهيئة لموظفي عمان', "SUBMIT_LTRC", $_SESSION['user_id']);

        // submit ltrc waybill
        $send_SMS = $this->_request->send_sms;
        $ltrc_result = $this->_mg_registrar->submitLTRCWaybill($this->_request->id, $send_SMS, $_SESSION['user_id']);

        // return response
        $Result['ERRORCODE'] = "0";
        $Result['LTRC'] = $ltrc_result;
        $Result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
        parent::response($Result);
    }


    // ----------------------------------------------------------------------- //
    // ------------------ Search Grains Waybill ------------------------------ //
    // ----------------------------------------------------------------------- //
    public function autoCompleteGrainsTn()
    {

        $result = $this->_mg_registrar->searchGrainsWaybill($this->_request->tn, $_SESSION['user_id']);

        // return response
        parent::response($result);
    }

    // ----------------------------------------------------------------------- //
    // ------------------ create Phosphate Waybill --------------------------- //
    // ----------------------------------------------------------------------- //
    public function createPhosphateWaybill()
    {

        try {

            // parse incoming data
            $tender_id = $this->_request->tender_id;
            $tn = $this->_request->tn;
            $trn = $this->_request->trn;
            $nn = $this->_request->nn;
            $cargo_id = $this->_request->cargo_id;
            $loading_weight = $this->_request->loading_weight;
            $loading_date = $this->_request->loading_date;
            $trucking_company_id = $this->_request->trucking_company_id;
            $operation_type = $this->_request->operation_type;
            $bond_id = json_decode($this->_request->bond)->number;
            $bond_photo = json_decode($this->_request->bond)->photo;
            $add_personal_advance_payment = $this->_request->add_personal_advance_payment;
            $add_diesel_advance_payment = $this->_request->add_diesel_advance_payment;
            $coupon_number = $this->_request->coupon_number;

            //if diesel advance payment choosed validate the coupon number
            if ($add_diesel_advance_payment) {

                if (!$coupon_number) {
                    throw new Exception('رقم الكوبون مطلوب');
                }

                // validate coupon number is exist and not used
                $coupon = $this->_merchantIntegration->validateCouponNumber($coupon_number);
            }

            // prepare tender manifest
            $tenderManifestJSON = $this->_tenderCore->getTenderManifest($tender_id, 0);

            // prepare truck data
            $activeTruckStatus = DBConnection::getActiveStatus('truck');
            $tnSearchFilter = [
                ['key' => 'tn', 'val' => $tn],
                ['key' => 'cat', 'val' => ['TRUCK', 'TRUCK_SINGLE'], 'op' => "in"],
                ['key' => 'status', 'val' => $activeTruckStatus, 'op' => 'in']
            ];

            $truckResult = $this->_truckCore->searchTrucks($tnSearchFilter, 1, 0, $_SESSION['user_id']);
            if ($truckResult->found_rows == 0) {
                throw new Exception("الشاحنة غير صحيحة");
            } else {
                $truck_id = $truckResult->data[0]->id;
            }

            // prepare trailer data
            $activeTruckStatus = DBConnection::getActiveStatus('truck');
            $trnSearchFilter = [
                ['key' => 'tn', 'val' => $trn],
                ['key' => 'cat', 'val' => ['TRAIL', 'TRAIL-HALF'], 'op' => "in"],
                ['key' => 'status', 'val' => $activeTruckStatus, 'op' => 'in']
            ];
            $trailerResult = $this->_truckCore->searchTrucks($trnSearchFilter, 1, 0, $_SESSION['user_id']);
            if ($trailerResult->found_rows == 0) {
                throw new Exception("المقطورة غير صحيحة");
            } else {
                $trailer_id = $trailerResult->data[0]->id;
            }

            // prepare driver data
            $driverActiveStatus = DBConnection::getActiveStatus('driver');
            $driverFilter = [
                ['key' => 'nn', 'val' => $nn],
                ['key' => 'status', 'val' => $driverActiveStatus, 'op' => 'in']
            ];
            $driver_result = $this->_driverCore->searchDriver($driverFilter, 1, 0, $_SESSION['user_id']);
            if ($driver_result->found_rows == 0) {
                throw new Exception("السائق غير صحيح");
            } else {
                $driver_id = $driver_result->data[0]->id;
            }

            // prepare owner data
            $truck_owner_id = $truckResult->data[0]->truck_owner_id;
            $trailer_owner_id = $trailerResult->data[0]->truck_owner_id;
            $userActiveStatus = DBConnection::getActiveStatus('user');
            $userSearchFilter = [
                ['key' => 'truck_owner_id', 'val' => $truck_owner_id],
                ['key' => 'status', 'val' => $userActiveStatus, 'op' => 'in']
            ];
            $userBean = $this->_userCore->searchUser($userSearchFilter, 1, 0, 0)->data[0];
            $owner_account_id = $userBean->account_id;

            // prepare tenderCompany id
            $tenderCompanySearchFilter = [
                ['key' => 'tender_id', 'val' => $tender_id],
                ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in'],
                ['key' => 'trucking_company_id', 'val' => $trucking_company_id]
            ];
            $tenderCompaniesReuslt = $this->_tenderCompanyCore->searchTenderCompany($tenderCompanySearchFilter, 1, 0, $_SESSION['user_id']);
            $tender_company_id = $tenderCompaniesReuslt->data[0]->id;

            // rest of fields
            $queue_id = null;
            $order_id = null;
            $ca_company_id = 10100;         // شركة مناجم الفوسفات الاردنية
            $origin_id =  $tenderManifestJSON['origin'][0];
            $destination_id = $tenderManifestJSON['destination'][0];
            $user_id = $_SESSION['user_id'];

            // Tender Truck
            // search for truck in tender truck
            $tenderTruckActiveStatus = DBConnection::getActiveStatus('tender_truck');
            $tenderTruckFilter = [
                ['key' => 'truck_id', 'val' => $truck_id],
                ['key' => 'tender_id', 'val' => $tender_id],
                ['key' => 'status', 'val' => ['ACTIVE'], 'op' => 'in']
            ];
            $tenderTruckResult = $this->_tenderCore->searchTenderTruck($tenderTruckFilter, 1, 0, $_SESSION['user_id']);

            //if tender_truck does not exist, create it
            if ($tenderTruckResult->found_rows == 0) {

                $tenderTruck = new stdClass();
                $tenderTruck->truck_id = $truck_id;
                $tenderTruck->trailer_id = $trailer_id;
                $tenderTruck->tender_id = $tender_id;
                $tenderTruck->q_id = null;
                $tenderTruck->tender_company_id = $tender_company_id;
                $tenderTruck->questionnaire = [];
                $tenderTruck->photos = [];
                $financial = new stdClass();
                $financial->waybill_beneficiary_account = $owner_account_id;
                $financial->advance_payment_account = [];
                $financial->payment_channel = "CASH";
                $tenderTruck->financial_details = $financial;
                $tender_truck_id = $this->_tenderCore->createTenderTruck($tenderTruck, 0);

                // activate it
                $this->_tenderCore->changeTruckStatus($tender_truck_id, 'ACTIVE', 0);
            } else {
                $tender_truck_id = $tenderTruckResult->data[0]->id;
            }

            DBConnection::startTransaction();

            //call core to create the waybill
            $waybill_result = $this->_waybillCore->createWaybill(
                $tender_id,
                $queue_id,
                $order_id,
                $cargo_id,
                $truck_id,
                $trailer_id,
                $driver_id,
                $truck_owner_id,
                $trailer_owner_id,
                $trucking_company_id,
                $ca_company_id,
                $origin_id,
                $destination_id,
                $user_id,
                $operation_type
            );


            $waybill_id = $waybill_result->id;
            $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);

            // generate available advance payment
            $advancePayments = $this->_paymentCore->generateWaybillAdvancePaymentNode($waybillBean->id);

            // save bond info in notes node
            $doc = $waybillBean->document;
            $notes = $doc->notes;
            $notes->bond = new stdClass();
            $notes->bond->id = $bond_id;
            $notes->bond->photo = $bond_photo;
            $waybillBean->document->notes = $notes;
            $this->_waybillCore->updateWaybill($waybillBean, $waybillBean->id, $_SESSION['user_id']);

            // change the status to ACTIVE
            $this->_waybillCore->changeStatus($waybillBean->id, 'ACTIVE', 0);

            // change the status to PENDING
            $this->_waybillCore->changeStatus($waybillBean->id, 'PENDING', 0);

            // Load it
            $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_result->id, $_SESSION['user_id']);
            $doc = $waybillBean->document;
            $cargoBean = $doc->cargo[0];
            $cargoBean->weights->loading->net_weight = $loading_weight;
            $cargoBean->weights->loading->time_stamp = $loading_date;
            $waybillBean->document->cargo[0] = $cargoBean;

            $this->_waybillCore->updateWeight($waybillBean, $_SESSION['user_id']);

            $this->_waybillCore->logActivity(
                $waybillBean->id,
                "تثبيت وزن التحميل",
                "وزن التحميل : " . $loading_weight . " كغم ",
                "LOAD_CARGO",
                $_SESSION['u_id']
            );


            // change status to ONROAD
            $this->_waybillCore->changeStatus($waybillBean->id, 'ONROAD', 0);

            // loop on advance payments
            foreach ($advancePayments as $payment) {
                // in case the user wants Personal advance payment
                if (strtoupper($payment['name']) == "PERSONAL" && $add_personal_advance_payment) {

                    // log advance payment
                    $newPayment = new stdClass();
                    $newPayment->label = "سلفة شخصية";
                    $newPayment->name = "PERSONAL_PAYMENT";
                    $newPayment->value = new stdClass();
                    $newPayment->value->amount = $payment['value']['amount'];
                    $newPayment->time_stamp = DBConnection::getSystemDate();
                    $this->_waybillCore->addWaybillPaymentNode($waybillBean->id, $newPayment);

                    // create voucher for this payment
                    $payment_account = $tenderManifestJSON['freight']['accounts'][0]['account'] . "-0";
                    $target_account = $this->_accountCore->getDriverAccount($driver_id) . "-0";
                    $value = new stdClass();
                    $value->amount = $payment['value']['amount'];
                    $advancePaymentNode = (object) array(
                        "name" => "PERSONAL_PAYMENT",
                        "label" => 'سلفة شخصية',
                        "target_account" => $target_account,
                        "time_stamp" => DBConnection::getSystemDate(),
                        "value" => $value
                    );

                    $remarks =  'قيد سلفة شخصية عن مستند الشحن رقم ' . $waybillBean->wn .
                        ' - الشاحنة رقم : ' . $waybillBean->document->carrier[0]->truck->tn .
                        ' - الحمولة : ' . $waybillBean->document->cargo[0]->name .
                        ' - القيمة : ' . $payment['value']['amount'];

                    $voucher_id_1 = $this->_voucherCore->createVoucher(
                        $payment_account,
                        $target_account,
                        $payment['value']['amount'],
                        $payment['payment_channel'],
                        $advancePaymentNode,
                        null,
                        'WAYBILL',
                        $waybillBean->id,
                        $remarks,
                        $waybillBean->tender_id,
                        "PERSONAL"
                    );

                    // change voucher status to make it available to read
                    $this->_voucherCore->changeStatus($voucher_id_1, 'PENDING', 0);

                    $this->_waybillCore->logActivity(
                        $waybillBean->id,
                        "إضافة شروحات",
                        "قيد سلفة شخصية بقيمة " . $payment['value']['amount'] . " - بموجب أمر صرف رقم " . $voucher_id_1,
                        "ADD_NOTES",
                        $_SESSION['u_id']
                    );
                }

                // in case the user wants Diesil advance payment
                if (strtoupper($payment['name']) == "DIESIL_POST_LOAD" && $add_diesel_advance_payment) {

                    // log advance payment
                    $newPayment = new stdClass();
                    $newPayment->label = "سلفة ديزل";
                    $newPayment->name = "DIESIL_POST_LOAD";
                    $newPayment->value = new stdClass();
                    $newPayment->value->amount = $payment['value']['amount'];
                    $newPayment->time_stamp = DBConnection::getSystemDate();
                    $this->_waybillCore->addWaybillPaymentNode($waybillBean->id, $newPayment);

                    // create voucher for this payment
                    $payment_account = $tenderManifestJSON['freight']['accounts'][0]['account'] . "-0";
                    $target_account = $this->_accountCore->getDriverAccount($driver_id) . "-0";
                    $value = new stdClass();
                    $value->amount = $payment['value']['amount'];
                    $advancePaymentNode = (object) array(
                        "name" => "DIESIL_POST_LOAD",
                        "label" => 'سلفة ديزل',
                        "target_account" => $target_account,
                        "time_stamp" => DBConnection::getSystemDate(),
                        "value" => $value
                    );

                    $remarks =  'قيد سلفة ديزل عن مستند الشحن رقم ' . $waybillBean->wn .
                        ' - الشاحنة رقم : ' . $waybillBean->document->carrier[0]->truck->tn .
                        ' - الحمولة : ' . $waybillBean->document->cargo[0]->name .
                        ' - القيمة : ' . $payment['value']['amount'];
                    $voucher_id_2 = $this->_voucherCore->createVoucher(
                        $payment_account,
                        $target_account,
                        $payment['value']['amount'],
                        $payment['payment_channel'],
                        $advancePaymentNode,
                        null,
                        'WAYBILL',
                        $waybillBean->id,
                        $remarks,
                        $waybillBean->tender_id,
                        "DIESIL_POST_LOAD"
                    );

                    // complete this voucher
                    $this->_voucherCore->completeVoucher($voucher_id_2, 0);

                    // details to add to coupon  provided for Diesil

                    $details =  json_decode($coupon['details']);
                    $details->waybill_id = $waybill_id;
                    $details->wn = $waybillBean->wn;
                    $details->tn = $waybillBean->document->carrier[0]->truck->tn;

                    // use the coupon (change status and add waybill to details)
                    $this->_merchantIntegration->useCoupon($coupon['id'], $details);
                }
            }

            DBConnection::commitTransaction();

            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['WAYBILL_ID'] = $waybillBean->id;
            $Result['VOUCHER_ID_1'] = $voucher_id_1;
            $Result['VOUCHER_ID_2'] = $voucher_id_2;
            $Result['MESSAGE'] = "تم انشاء الأرسالية رقم $waybillBean->wn بنجاح";
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------------------------- //
    // ------------------ create Phosphate Waybill for silk road project--------------------------- //
    // -------------------------------------------------------------------------------------------- //
    public function createSilkRoadPhosphateWaybill()
    {

        try {

            // parse incoming data
            $tender_id = $this->_request->tender_id;
            $tn = $this->_request->tn;
            $trn = $this->_request->trn;
            $nn = $this->_request->nn;
            $cargo_id = $this->_request->cargo_id;
            $loading_weight = $this->_request->loading_weight;
            $loading_date = $this->_request->loading_date;
            $discharge_weight = $this->_request->discharge_weight;
            $discharge_date = $this->_request->discharge_date;
            $trucking_company_id = $this->_request->trucking_company_id;
            $operation_type = $this->_request->operation_type;
            $bond_id = json_decode($this->_request->bond)->number;
            $bond_photo = json_decode($this->_request->bond)->photo;
            $origin_id = $this->_request->origin_id;
            $destination_id = $this->_request->destination_id;
            $personal_advance_payment = $this->_request->advance_payment;

            if ($discharge_weight && $personal_advance_payment && $personal_advance_payment > 0) {
                throw new Exception("لا تستطيع صرف سلفة شخصية في حال تثبيت وزن التفريغ");
            }

            // prepare tender manifest
            $tenderManifestJSON = $this->_tenderCore->getTenderManifest($tender_id, 0);

            // prepare truck data
            $activeTruckStatus = DBConnection::getActiveStatus('truck');
            $tnSearchFilter = [
                ['key' => 'tn', 'val' => $tn],
                ['key' => 'cat', 'val' => ['TRUCK', 'TRUCK_SINGLE'], 'op' => "in"],
                ['key' => 'status', 'val' => $activeTruckStatus, 'op' => 'in']
            ];

            $truckResult = $this->_truckCore->searchTrucks($tnSearchFilter, 1, 0, 0);
            if ($truckResult->found_rows == 0) {
                throw new Exception("الشاحنة غير صحيحة");
            } else {
                $truck_id = $truckResult->data[0]->id;
            }

            // prepare trailer data
            if ($truckResult->data[0]->cat == "TRUCK-SINGLE" || $truckResult->data[0]->cat == "SINGLE") {
                $trailer_id = $truck_id;
            } else {
                $activeTruckStatus = DBConnection::getActiveStatus('truck');
                $trnSearchFilter = [
                    ['key' => 'tn', 'val' => $trn],
                    ['key' => 'cat', 'val' => ['TRAIL', 'TRAIL-HALF'], 'op' => "in"],
                    ['key' => 'status', 'val' => $activeTruckStatus, 'op' => 'in']
                ];
                $trailerResult = $this->_truckCore->searchTrucks($trnSearchFilter, 1, 0, 0);
                if ($trailerResult->found_rows == 0) {
                    throw new Exception("المقطورة غير صحيحة");
                } else {
                    $trailer_id = $trailerResult->data[0]->id;
                }
            }

            // prepare driver data
            $driverActiveStatus = DBConnection::getActiveStatus('driver');
            $driverFilter = [
                ['key' => 'nn', 'val' => $nn],
                ['key' => 'status', 'val' => $driverActiveStatus, 'op' => 'in']
            ];
            $driver_result = $this->_driverCore->searchDriver($driverFilter, 1, 0, 0);
            if ($driver_result->found_rows == 0) {
                throw new Exception("السائق غير صحيح");
            } else {
                $driver_id = $driver_result->data[0]->id;
            }

            // prepare owner data
            $truck_owner_id = $truckResult->data[0]->truck_owner_id;
            $trailer_owner_id = $trailerResult->data[0]->truck_owner_id;
            $userActiveStatus = DBConnection::getActiveStatus('user');
            $userSearchFilter = [
                ['key' => 'truck_owner_id', 'val' => $truck_owner_id],
                ['key' => 'status', 'val' => $userActiveStatus, 'op' => 'in']
            ];
            $userBean = $this->_userCore->searchUser($userSearchFilter, 1, 0, 0)->data[0];
            $owner_account_id = $userBean->account_id;

            // prepare tenderCompany id
            $tenderCompanySearchFilter = [
                ['key' => 'tender_id', 'val' => $tender_id],
                ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in'],
                ['key' => 'trucking_company_id', 'val' => $trucking_company_id]
            ];
            $tenderCompaniesReuslt = $this->_tenderCompanyCore->searchTenderCompany($tenderCompanySearchFilter, 1, 0, $_SESSION['user_id']);
            $tender_company_id = $tenderCompaniesReuslt->data[0]->id;

            // rest of fields
            $queue_id = null;
            $order_id = null;
            $ca_company_id = 10100;         // شركة مناجم الفوسفات الاردنية
            $user_id = $_SESSION['user_id'];

            // Tender Truck
            // search for truck in tender truck
            $tenderTruckActiveStatus = DBConnection::getActiveStatus('tender_truck');
            $tenderTruckFilter = [
                ['key' => 'truck_id', 'val' => $truck_id],
                ['key' => 'tender_id', 'val' => $tender_id],
                ['key' => 'status', 'val' => ['ACTIVE'], 'op' => 'in']
            ];
            $tenderTruckResult = $this->_tenderCore->searchTenderTruck($tenderTruckFilter, 1, 0, $_SESSION['user_id']);

            //if tender_truck does not exist, create it
            if ($tenderTruckResult->found_rows == 0) {

                $tenderTruck = new stdClass();
                $tenderTruck->truck_id = $truck_id;
                $tenderTruck->trailer_id = $trailer_id;
                $tenderTruck->tender_id = $tender_id;
                $tenderTruck->q_id = null;
                $tenderTruck->tender_company_id = $tender_company_id;
                $tenderTruck->questionnaire = [];
                $tenderTruck->photos = [];
                $financial = new stdClass();
                $financial->waybill_beneficiary_account = $owner_account_id;
                $financial->advance_payment_account = [];
                $financial->payment_channel = "CASH";
                $tenderTruck->financial_details = $financial;
                $tender_truck_id = $this->_tenderCore->createTenderTruck($tenderTruck, 0);

                // activate it
                $this->_tenderCore->changeTruckStatus($tender_truck_id, 'ACTIVE', 0);
            } else {
                $tender_truck_id = $tenderTruckResult->data[0]->id;
            }

            DBConnection::startTransaction();

            //call core to create the waybill
            $waybill_result = $this->_waybillCore->createWaybill(
                $tender_id,
                $queue_id,
                $order_id,
                $cargo_id,
                $truck_id,
                $trailer_id,
                $driver_id,
                $truck_owner_id,
                $trailer_owner_id,
                $trucking_company_id,
                $ca_company_id,
                $origin_id,
                $destination_id,
                $user_id,
                $operation_type
            );


            $waybill_id = $waybill_result->id;
            $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);

            // save bond info in notes node
            $doc = $waybillBean->document;
            $notes = $doc->notes;
            $notes->bond = new stdClass();
            $notes->bond->id = $bond_id;
            $notes->bond->photo = $bond_photo;
            $waybillBean->document->notes = $notes;
            $this->_waybillCore->updateWaybill($waybillBean, $waybillBean->id, $_SESSION['user_id']);

            // change the status to ACTIVE
            $this->_waybillCore->changeStatus($waybillBean->id, 'ACTIVE', 0);

            // change the status to PENDING
            $this->_waybillCore->changeStatus($waybillBean->id, 'PENDING', 0);

            // Load it
            $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_result->id, 0);
            $doc = $waybillBean->document;

            $cargoBean = $doc->cargo[0];
            $cargoBean->weights->loading->net_weight = $loading_weight;
            $cargoBean->weights->loading->time_stamp = $loading_date;
            $waybillBean->document->cargo[0] = $cargoBean;
            $this->_waybillCore->updateWeight($waybillBean, 0);

            $this->_waybillCore->logActivity(
                $waybillBean->id,
                "تثبيت وزن التحميل",
                "وزن التحميل : " . $loading_weight . " كغم بواسطة " . $_SESSION['u_id'],
                "LOAD_CARGO",
                0
            );

            // change status to ONROAD
            $this->_waybillCore->changeStatus($waybillBean->id, 'ONROAD', 0);

            // add advance payment
            if ($personal_advance_payment && $personal_advance_payment > 0) {

                // log advance payment
                $newPayment = new stdClass();
                $newPayment->label = "سلفة شخصية";
                $newPayment->name = "PERSONAL_PAYMENT";
                $newPayment->value = new stdClass();
                $newPayment->value->amount = $personal_advance_payment;
                $newPayment->time_stamp = DBConnection::getSystemDate();
                $this->_waybillCore->addWaybillPaymentNode($waybillBean->id, $newPayment);

                // create voucher for this payment
                $payment_account = $tenderManifestJSON['freight']['payment_accounts'][0]['account_id'] . "-" . $tenderManifestJSON['freight']['payment_accounts'][0]['account_sub_id'];
                $target_account = $this->_accountCore->getDriverAccount($driver_id) . "-0";;
                $value = new stdClass();
                $value->amount = $personal_advance_payment;
                $advancePaymentNode = (object) array(
                    "name" => "PERSONAL_PAYMENT",
                    "label" => 'سلفة شخصية',
                    "target_account" => $target_account,
                    "time_stamp" => DBConnection::getSystemDate(),
                    "value" => $value
                );

                $remarks =  'قيد سلفة شخصية عن مستند الشحن رقم ' . $waybillBean->wn .
                    ' - الشاحنة رقم : ' . $waybillBean->document->carrier[0]->truck->tn .
                    ' - الحمولة : ' . $waybillBean->document->cargo[0]->name .
                    ' - القيمة : ' . $personal_advance_payment;

                $personal_voucher_id = $this->_voucherCore->createVoucher(
                    $payment_account,
                    $target_account,
                    $personal_advance_payment,
                    'CASH',
                    $advancePaymentNode,
                    null,
                    'WAYBILL',
                    $waybillBean->id,
                    $remarks,
                    $waybillBean->tender_id,
                    "PERSONAL"
                );

                $this->_waybillCore->logActivity(
                    $waybillBean->id,
                    "إضافة شروحات",
                    "قيد سلفة شخصية بقيمة " . $personal_advance_payment . " - بموجب أمر صرف رقم " . $personal_voucher_id,
                    "ADD_NOTES",
                    0
                );
            }

            // discharge it
            if ($discharge_weight && $discharge_date) {

                $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_result->id, 0);
                $doc = $waybillBean->document;
                $cargoBean = $doc->cargo[0];
                $cargoBean->weights->discharge->net_weight = $discharge_weight;
                $cargoBean->weights->discharge->time_stamp = $discharge_date;
                $waybillBean->document->cargo[0] = $cargoBean;
                $this->_waybillCore->updateWeight($waybillBean, 0);
                $this->_waybillCore->logActivity(
                    $waybillBean->id,
                    "تثبيت وزن التفريغ",
                    "وزن التفريغ : " . $discharge_weight . " كغم بواسطة " . $_SESSION['u_id'],
                    "DISCHARGE_CARGO",
                    0
                );

                // change status to CLOSED
                $this->_waybillCore->changeStatus($waybillBean->id, 'CLOSED', 0);
            }


            DBConnection::commitTransaction();

            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['personal_voucher_id'] = $personal_voucher_id;
            $Result['waybill_id'] = $waybillBean->id;
            $Result['MESSAGE'] = "تم انشاء الأرسالية رقم $waybillBean->wn بنجاح";
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }

    // ----------------------------------------------------------------------- //
    // ------------------ create External Waybill ---------------------------- //
    // ----------------------------------------------------------------------- //
    public function createExternalWaybill()
    {

        // parse incoming data
        $tender_id = $this->_request->tender_id;
        $tn = $this->_request->tn;
        $trn = $this->_request->trn;
        $nn = $this->_request->nn;
        $service_id = $this->_request->service_id;
        $cargo_id = $this->_request->cargo_id;
        $payment_method = $this->_request->payment_method;
        $bond_photo = json_decode($this->_request->bond)->photo;
        $create_ticket = $this->_request->create_ticket;
        $entry_point_id = $this->_request->entry_point_id;
        $exit_point_id = $this->_request->exit_point_id;
        $discharge_location_id = $this->_request->discharge_location_id;

        // prepare externalWaybillBean
        $externalWaybillBean = new stdClass();
        $externalWaybillBean->tn = $tn;
        $externalWaybillBean->trn = $trn;
        $externalWaybillBean->nn = $nn;
        $externalWaybillBean->tender_id = $tender_id;
        $externalWaybillBean->service_id = $service_id;
        $externalWaybillBean->trucking_company_id = 395;  // ADEL
        $externalWaybillBean->ca_id = 1;  // dummy CA
        $externalWaybillBean->cargo_id = $cargo_id;
        $externalWaybillBean->origin_id = 91000000;       // JORDAN
        $externalWaybillBean->destination_id = 91000000;  // JORDAN
        $externalWaybillBean->payment_method = $payment_method;
        $externalWaybillBean->bond_photo = $bond_photo;
        $externalWaybillBean->entry_point_id = $entry_point_id;
        $externalWaybillBean->exit_point_id = $exit_point_id;
        $externalWaybillBean->discharge_location_id = $discharge_location_id;

        // call core to create the waybill
        $waybill_result = $this->_waybillCore->createExternalWaybill($externalWaybillBean, $_SESSION['user_id']);

        // change the status to ACTIVE
        $this->_waybillCore->changeStatus($waybill_result->id, 'ACTIVE', 0);

        // add new task to close the waybill after 12 hours
        //$taskQueuesCore = new TaskQueuesCore();
        //$taskQueuesCore->createCloseWaybillTask($response->id, 12, "اغلاق لتصريح الخارجي بسبب مرور 12 ساعة من وقت الإنشاء");

        // Create a permit ticket
        if ($create_ticket) {
            $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_result->id, 0);
            $ticket = $this->_waybillCore->createPermitTicket($waybillBean->id);
        }

        // return response
        $Result['WN'] = $waybill_result->wn;
        $Result['VOUCHER_ID'] = $waybill_result->voucher_id;
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "تم انشاء تصريح خارجي  " . $waybill_result->wn . " للشاحنة بنجاح";
        parent::response($Result);
    }


    // -------------------------------------------------------------------------------- //
    // ----------------- Get info from last waybill for certain truck------------------ //
    // -------------------------------------------------------------------------------- //
    public function getLastWaybillInfo()
    {

        //Parse incoming params
        $tn = $this->_request->tn;
        $tender_id = $this->_request->tender_id;
        $userId = $_SESSION['user_id'];

        //Handle tn is not sent
        if (!$tn)
            throw new Exception("API expected param[tn: Ineger] to be sent");

        // Prepare filters
        $lastWaybillFilter = [
            ["key" => "tn", "val" => $tn],
            ["key" => "tender_id", "val" => $tender_id],
            ['key' => 'status', 'val' => ['CLOSED', 'COMPLETE'], 'op' => 'in']
        ];
        $autoComplete = new stdClass();

        // Get the last waybill in case there is
        $waybillResult = $this->_waybillCore->searchWaybills($lastWaybillFilter, 1, 0, $userId, ' order by id desc ');
        if ($waybillResult->found_rows > 0) {
            $waybillBean = $waybillResult->data[0];
            $doc = json_decode($waybillBean->document);

            // Prepare the response
            $autoComplete->tn = $waybillBean->tn;
            $autoComplete->trn = $waybillBean->trn;
            $autoComplete->driver_nn = $doc->carrier[0]->driver->nn;
            $autoComplete->driver_name = $doc->carrier[0]->driver->name;
            $autoComplete->driver_phone = $doc->carrier[0]->driver->phone;
        }

        // if no waybill found
        else {
            // for the tender 17 ("فوسفات طريق الحرير")
            if ($tender_id == 17) {

                // get truck bean
                $activeTnStatus = DBConnection::getActiveStatus('truck');
                $truckFilter = [['key' => "tn", 'val' => $tn], ['key' => 'status', 'val' => $activeTnStatus, 'op' => 'in']];
                $truckQuery = $this->_truckCore->searchTrucks($truckFilter, 1, 0, 0);

                if ($truckQuery->found_rows > 0) {

                    // if the truck is single, set the trn to be the same as truck
                    $truckBean = $truckQuery->data[0];
                    if ($truckBean->cat == "SINGLE" || $truckBean->cat == "TRUCK-SINGLE") {
                        $autoComplete->tn = $truckBean->tn;
                        $autoComplete->trn = $truckBean->tn;
                    }
                }
            }
        }


        parent::response($autoComplete);
    }


    // ----------------------------------------------------------------------- //
    // ------------------ create Grains Waybill ------------------------------ //
    // ----------------------------------------------------------------------- //
    public function createGrainsWaybill()
    {

        // parse incoming data
        $tender_id = $this->_request->tender_id;
        $cargo_type = $this->_request->cargo_type;
        $truck = $this->_request->truck;
        $trailer = $this->_request->trailer;
        $permit = $this->_request->permit;
        $first_trip_ct = $this->_request->first_trip_ct;
        $first_trip_destination_id = $this->_request->first_trip_destination_id;
        $bond = $this->_request->bond;
        $shift_id = $this->_request->shift_id;

        //validate if the truck has already grains waybill in active status
        $activeWaybillStatus = DBConnection::getActiveStatus('waybill');
        $waybillFilter = [
            ['key' => 'tn', 'val' => json_decode($truck)->tn],
            ['key' => 'status', 'val' => $activeWaybillStatus, 'op' => 'in']
        ];
        $waybill_result = $this->_waybillCore->searchWaybills($waybillFilter, 1, 0, $_SESSION['user_id']);

        if ($waybill_result->found_rows > 0) {
            throw new Exception("الشاحنة لديها مستند فعال برقم " . $waybill_result->data[0]->wn);
        }

        // fill the integration details info

        $tender_company_id = "70";
        $trucking_company_id = "395";
        $origin_id = "91090000";            // AQABA
        $destination_id = "91000000";       // JORDAN
        $ca_company_id = "10184";           // وزارة الصناعة والتجارة
        if ($cargo_type == "BULK") {
            $cargo_id = "1910000035";
            $q_id = "1";
        }
        if ($cargo_type == "PACKED") {
            $cargo_id = "1910000034";
            $q_id = "2";
        }
        $integration_token = "Fc8nbSsp78gzCVRkt2BSnkEbB2QWRUVt97Geam8sWDe3AfbhJC529DJb65dU6d9F";

        // call the waybill integration "createGrainsWaybill" by cURL
        $url = Config::$minagate_waybill_base_url . "/waybill/integration";
        $fields = array(
            'method' => "createGrainsWaybill",
            'tender_id' => $tender_id,
            'q_id' => $q_id,
            'tender_company_id' => $tender_company_id,
            'cargo_id' => $cargo_id,
            'trucking_company_id' => $trucking_company_id,
            'origin_id' => $origin_id,
            'destination_id' => $origin_id,
            'ca_company_id' => $ca_company_id,
            'truck' => $truck,
            'trailer' => $trailer,
            'permit' => $permit,
            'first_trip_ct' => $first_trip_ct,
            'first_trip_destination_id' => $first_trip_destination_id,

            'integration_token' => $integration_token
        );

        $response = callCurl($url, $fields);

        if (!$response) {
            throw new Exception("WAYBILL.CANT_SUBMIT_GRAINS_WAYBILL");
        }
        $response = json_decode($response);

        if ($response->ERRORCODE != 0) {
            throw new Exception($response->MESSAGE);
        }


        // update bond info
        $bond_number = json_decode($this->_request->bond)->number;
        $bond_photo = json_decode($this->_request->bond)->photo;
        $waybillBean = $this->_waybillCore->getWaybillBasic($response->ID, $_SESSION['user_id']);
        $waybillJson = $waybillBean->document;

        $notes = $waybillJson->notes;
        if (!$notes) {
            $notes = new stdClass();
        }
        $notes->bond = new stdClass();
        $notes->bond->id = $bond_number;
        $notes->bond->photo = $bond_photo;
        $waybillJson->notes = $notes;
        $waybillBean->document = $waybillJson;
        $this->_waybillCore->updateWaybill($waybillBean, $waybillBean->id, $_SESSION['user_id']);

        // return response
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "تم انشاء مستند التموين " . $response->WN . " للشاحنة بنجاح";
        parent::response($Result);
    }

    // -------------------------------------------------------------------------------- //
    // ------------------- get list of payment methods for certain service ------------ //
    // -------------------------------------------------------------------------------- //
    public function getServicePaymentMethods()
    {
        $service_id = $this->_request->service_id;
        $serviceBean = $this->_waybillCore->getService($service_id, $_SESSION['user_id']);
        $result = [];

        if ($serviceBean->trx_template) {
            foreach ($serviceBean->trx_template as $template) {
                $temp = new stdClass();
                $temp->code =  $template->code;
                $temp->caption =  $template->caption;
                $result[] = $temp;
            }
        } else {
            $temp = new stdClass();
            $temp->code = "MINAGATE_CASH";
            $temp->caption =  "دفع كاش لشركة مدارج";
            $result[] = $temp;
        }

        parent::response($result);
    }

    // ------------------------------------------------------------------- //
    // ------------------ Create Grains Waybill API --------------------- //
    // ------------------------------------------------------------------- //
    public function createLtrcDocument()
    {
        try {
            $trucks = $this->_request->trucksSelected;

            foreach ($trucks as $value) {
                $tn = $value->tn;
                $trn = $value->trn;
                $nn = $value->nn;
                $service_id = $this->_request->service_id;
                try {
                    if ($service_id == "0") {
                        // if there is no service
                        //code...
                        $this->_robotIntegration->submitLtrcGransWaybill($tn, $trn, $nn, 'single');
                        $result = [];
                        $result['ERRORCODE'] = "0";
                        $result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
                        parent::response($result);
                    } else if ($service_id == "1") {
                        // if the service duoble
                        $this->_robotIntegration->submitLtrcGransWaybill($tn, $trn, $nn, '');
                        $result = [];
                        $result['ERRORCODE'] = "0";
                        $result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
                        parent::response($result);
                    }
                } catch (Exception $e) {

                    throw new Exception($e->getMessage());
                }
            }
        } catch (Exception $e) {

            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------- //
    // ------------------ Create Grains Waybill API --------------------- //
    // ------------------------------------------------------------------- //
    public function createTamweenWaybill()
    {

        try {
            DBConnection::startTransaction();
            // prepare the needed data
            $tn = $this->_request->tn;
            $trn = $this->_request->trn;
            $nn = $this->_request->nn;
            $tender_id = $this->_request->tender_id;
            $tender_order_id = $this->_request->order_id;
            $tender_shift_id = $this->_request->shift_id;
            $tender_company_id = $this->_request->tender_company_id;
            $origin_id = "91090000";            // AQABA
            $destination_id = "91000000";
            $service_id = $this->_request->service_id;
            $service_payment_method = $this->_request->service_payment_method;
            $nafith_wn = $this->_request->nafith_wn;
            $account_id = $this->_request->account;
            $ltrcGrainsWaybill = $this->_request->ltrcGrainsWaybill;
            $result = null;

            //-------------------Robot Create LTRC Waybill--------------------//
            if ($service_id == 0 && $ltrcGrainsWaybill == true) {
                // if there is no service
                $result = $this->_robotIntegration->submitLtrcGrainsWaybill($tn, $trn, $nn, 'single');
            } else if ($service_id == 1 && $ltrcGrainsWaybill == true) {
                // if the service duoble
                $result = $this->_robotIntegration->submitLtrcGrainsWaybill($tn, $trn, $nn, '');
            }

            // ---------------- TRUCK --------------------------- //
            //check if truck already exists
            $truckActiveStatus = DBConnection::getActiveStatus('truck');
            $truckSearchFilter = [['key' => 'tn', 'val' => $tn], ['key' => 'status', 'val' => $truckActiveStatus, 'op' => 'in']];
            $truckResult = $this->_truckCore->searchTrucks($truckSearchFilter, 1, 0, $_SESSION['user_id']);
            //if truck does not exist, create it
            if ($truckResult->found_rows == 0) {
                throw new Exception("رقم الشاحنة غير صحيح");
            } else {
                $truck_id = $truckResult->data[0]->id;
            }

            // -------------- Trailer --------------------------------- //
            //check if trailer already exists
            $truckActiveStatus = DBConnection::getActiveStatus('truck');
            $trailerSearchFilter = [['key' => 'tn', 'val' => $trn], ['key' => 'status', 'val' => $truckActiveStatus, 'op' => 'in']];
            $trailerResult = $this->_truckCore->searchTrucks($trailerSearchFilter, 1, 0, $_SESSION['user_id']);

            //if truck does not exist, create it
            if ($trailerResult->found_rows == 0) {
                throw new Exception("رقم المقطورة غير صحيح");
            } else {
                $trailer_id = $trailerResult->data[0]->id;
            }

            // --------------------- Driver User ------------------------------------- //
            // search for driver user
            $userActiveStatus = DBConnection::getActiveStatus('user');
            $userSearchFilter = [
                ['key' => 'nn', 'val' => $nn],
                ['key' => 'status', 'val' => $userActiveStatus, 'op' => 'in']
            ];
            $userSearchResult = $this->_userCore->searchUser($userSearchFilter, 1, 0, 0);

            // in case the driver user does noit exists, create it
            if ($userSearchResult->found_rows == 0) {
                throw new Exception("الرقم الوطني غير صحيح");
            } else {
                $user_id = $userSearchResult->data[0]->id;
            }

            // --------------------- Driver ------------------------------------- //

            $driverActiveStatus = DBConnection::getActiveStatus('driver');
            $driverFilter = [
                ['key' => 'nn', 'val' => $nn],
                ['key' => 'status', 'val' => $driverActiveStatus, 'op' => 'in']
            ];
            $driver_result = $this->_driverCore->searchDriver($driverFilter, 1, 0, $_SESSION['user_id']);

            // in case the driver does not exist , create it
            if ($driver_result->found_rows == 0) {
                throw new Exception("السائق غبر مسجل على النظام");
            } else {
                $driver_id = $driver_result->data[0]->id;
            }

            // --------------------- Tender Truck ------------------------------- //
            // search for truck in tender truck
            $tenderTruckFilter = [
                ['key' => 'truck_id', 'val' => $truck_id],
                ['key' => 'tender_id', 'val' => $tender_id],
                ['key' => 'status', 'val' => ['ACTIVE'], 'op' => 'in']
            ];
            $tenderTruckResult = $this->_tenderCore->searchTenderTruck($tenderTruckFilter, 1, 0, $_SESSION['user_id']);

            //if tender_truck does not exist, create it
            if ($tenderTruckResult->found_rows == 0) {
                throw new Exception("عقد تشغيل الشاحنة غير موجود على المشروع");
            }

            //-----------------------------tenderCompany------------------------------//
            $tenderCompanyCore = new TenderCompanyCore();
            $tenderCompanyFilter = [['key' => 'id', 'val' => $tender_company_id]];
            $tenderCompaniesReuslt = $tenderCompanyCore->searchTenderCompany($tenderCompanyFilter, 1, 0, $_SESSION['user_id']);
            $trucking_company_id = $tenderCompaniesReuslt->data[0]->trucking_company_id;
            //--------------------------tenderOrder ----------------------------------------//
            $tenderOrderBean = $this->_tenderCore->getTenderOrderBasic($tender_order_id, 0);
            if (!$tenderOrderBean) {
                throw new Exception("الطلبية غير صحيحة");
            } else {
                $cargo_id = $tenderOrderBean->cargo[0];
                $cargoCore = new CargoCore();
                $cargoBean = $cargoCore->getCargoBasic($cargo_id, 0);
                $ca_company_id = $cargoBean->ca_id;
            }

            // ------------------------Waybill -------------------------------------- //
            $waybillActiveStatus = DBConnection::getActiveStatus('waybill');
            $waybillFilter = [
                ['key' => 'truck_id', 'val' => $truck_id],
                ['key' => 'status', 'val' => $waybillActiveStatus, 'op' => 'in']
            ];
            $waybill_result = $this->_waybillCore->searchWaybills($waybillFilter, 1, 0, $_SESSION['user_id']);

            if (sizeof($waybill_result->data) > 0) {
                throw new Exception("لا تستطيع المتابعة, يوجد رحلات غير منتهية للشاحنة");
            }

            $waybill_result = $this->_waybillCore->createWaybill(
                $tender_id,
                null,
                $tender_order_id,
                $cargo_id,
                $truck_id,
                $trailer_id,
                $driver_id,
                $truckResult->data[0]->truck_owner_id,
                $trailerResult->data[0]->trailer_owner_id,
                $trucking_company_id,
                $ca_company_id,
                $origin_id,
                $destination_id,
                $_SESSION['user_id'],
                'IMPORT',
                $nafith_wn
            );
            $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_result->id, 0);

            if ($tender_shift_id) {
                $res = $this->updateWaybillTenderShift($waybill_result->id, $tender_shift_id);
            }

            if ($service_id) {
                $res = $this->updateWaybillService($waybill_result->id, $service_id, $account_id, $service_payment_method);
            }

            // remove from queue
            $queueuFilter = [
                ['key' => 'truck_id', 'val' => $waybillBean->truck_id],
                ['key' => 'tender_id', 'val' => 13],
                ['key' => 'rank', 'op' => 'is not null'],
                ['key' => 'q_id', 'val' => $tenderOrderBean->q_id]
            ];

            $queueResult = $this->_queueCore->searchQueue($queueuFilter, 1000, 0, 0);
            if ($queueResult->found_rows > 0) {
                $this->_queueCore->changeStatus($queueResult->data[0]->id, 'CLOSED', 0);
            }


            // update the grns table to add nafith pn and MG
            $tn = $waybillBean->document->carrier[0]->truck->tn;

            // TODO : temp fix
            // $nafith_info = $this->_registrationCore->getNafithAsezaPermit($tn);
            // $nafith_pn = $nafith_info->PN;
            // if ($nafith_pn) {
            //     $this->_registrationCore->updateGrainsRecord($nafith_wn, $waybillBean->wn, $nafith_pn);
            // }

            DBConnection::commitTransaction();
            // return response

            $result = [];
            $result['ERRORCODE'] = "0";
            $result['ID'] = $waybill_result->id;
            $result['WN'] = $waybill_result->wn;
            $result['VOUCHER_ID'] = $res["VOUCHER_ID"];
            $result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
            parent::response($result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }

    // ----------------------------------------------------------------------- //
    // ------------------ create External Cargo Waybill ------------------------------ //
    // ----------------------------------------------------------------------- //
    public function createExternalGeneralCargoWaybill()
    {

        $tender_id = $this->_request->tender_id;
        $queue_id = $this->_request->queue_id;
        $q_id = $this->_request->q_id ? $this->_request->q_id : 1;
        $trn = $this->_request->trn;
        $nn = $this->_request->nn;
        $order_id = $this->_request->order_id;
        $tender_order_company_id = $this->_request->tender_order_company_id;

        $truckContractCore = new TruckContractCore();
        $tenderCompanyCore = new TenderCompanyCore();
        $cargoCore = new CargoCore();
        $truckOwnerCore = new TruckOwnerCore();
        $truckCore = new TruckCore();
        $tenderCore = new TenderCore();
        $QueueCore = new QueueCore();

        // get queue bean for truck_id
        $queueBean = $QueueCore->getQueuebasic($queue_id,  $_SESSION['user_id']);
        $truck_id = $queueBean->truck_id;

        // get trailer bean for trailer_id
        $activeTnStatus = DBConnection::getActiveStatus('truck');
        $trailerFilter = [['key' => "tn", 'val' => $trn], ['key' => 'status', 'val' => $activeTnStatus, 'op' => 'in']];
        $truckQuery = $truckCore->searchTrucks($trailerFilter, 1, 0, $_SESSION['user_id']);
        if ($truckQuery->found_rows == 0) {
            throw new Exception("رقم المقطورة غير صحيح");
        }
        $trailer_id = $truckQuery->data[0]->id;

        // get driver bean for driver_id
        if ($nn) {
            $activeDriverStatus = DBConnection::getActiveStatus('driver');
            $driverFilter = [["key" => "nn", "val" => $nn], ['key' => 'status', 'val' => $activeDriverStatus, 'op' => 'in']];
            $driverQuery = $this->_driverCore->searchDriver($driverFilter, 1, 0, $_SESSION['user_id'])->data[0];
            $driver_id = $driverQuery->id;
        } else {
            $driver_id = $queueBean->driver_id;
        }

        // get $tender Company
        $tenderCompanyFilter = [['key' => 'tender_id', 'val' => $tender_id]];
        $tenderCompaniesReuslt = $tenderCompanyCore->searchTenderCompany($tenderCompanyFilter, 1, 0, $_SESSION['user_id']);

        // get $truck owner_id and trailer owner id
        $truckFilter = [['key' => "id", 'val' => $truck_id]];
        $truckQuery = $truckCore->searchTrucks($truckFilter, 1, 0, $_SESSION['user_id']);
        $truck_owner_id = $truckQuery->data[0]->truck_owner_id;
        $trailer_owner_id = $truck_owner_id;
        $trucking_company_id = $tenderCompaniesReuslt->data[0]->trucking_company_id;
        // get waybill template from cargo and extract the following
        $orderBean = $tenderCore->getTenderOrderBasic($order_id,  $_SESSION['user_id']);
        $cargo_id = $orderBean->cargo[0];
        $cargoBean = $cargoCore->getCargoBasic($cargo_id, $_SESSION['user_id']);

        $waybill_template = $cargoBean->waybill_template;
        $ca_company_id = $waybill_template->cargo[0]->consigner->ca_id;
        $origin_id = prepareLocationValue($waybill_template->negotiable_instructios->route->origin, $cargoBean);
        $destination_id = prepareLocationValue($waybill_template->negotiable_instructios->route->destination, $cargoBean);


        // get destination_id
        $destination_id = $orderBean->questionnaire[0]->val;

        // validate if the truck has pending tender truck
        $tenderTruckSearchFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'truck_id', 'val' => $truck_id],
            ['key' => 'status', 'val' => 'PENDING']
        ];
        $tenderTrucks = $tenderCore->searchTenderTruck($tenderTruckSearchFilter, 1, 0, $_SESSION['user_id']);
        if ($tenderTrucks->found_rows > 0) {
            throw new Exception('عقد تشغيل الشاحنة على المشروع موقوف');
        }

        $user_id = $_SESSION['user_id'];

        try {
            DBConnection::startTransaction();

            $waybill_result = $this->_waybillCore->createWaybill(
                $tender_id,
                $queue_id,
                $order_id,
                $cargo_id,
                $truck_id,
                $trailer_id,
                $driver_id,
                $truck_owner_id,
                $trailer_owner_id,
                $trucking_company_id,
                $ca_company_id,
                $origin_id,
                $destination_id,
                $user_id,
                "IMPORT"
            );

            // write integration details into waybill
            $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_result->id, $user_id);
            $integeration_details = new stdClass();
            $integeration_details->queue = new stdClass();
            $integeration_details->queue->queue_id = $queueBean->id;
            $integeration_details->queue->q_id = $queueBean->q_id;
            $integeration_details->queue->queue_rank = $queueBean->rank;
            $integeration_details->queue->serial = $queueBean->serial;
            $integeration_details->waybill_order = new stdClass();
            $integeration_details->waybill_order->waybill_order_id = null;
            $waybillBean->document->notes = new stdClass();
            $waybillBean->document->notes->print_note = $queueBean->name;
            $waybillBean->document->integeration_details = $integeration_details;
            $this->_waybillCore->updateWaybill($waybillBean, $waybill_result->id, 0);

            // decide what to do with the queue of the truck
            $QueueCore->changeStatus($queue_id, 'CLOSED', 0); // Closed By System

            DBConnection::commitTransaction();

            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
            $Result['WN'] = $waybill_result;
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }

    // ---------------------------------------------------------------------------------------------------- //
    // --------------------------- Create new grains waybill for reserved queue  -------------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function createGrainsReservedlWaybill()
    {

        $tender_id = $this->_request->tender_id;
        $queue_id = $this->_request->queue_id;
        $q_id = $this->_request->q_id ? $this->_request->q_id : 1;
        $trn = $this->_request->trn;
        $nn = $this->_request->nn;
        $order_id = $this->_request->order_id;
        $tender_order_company_id = $this->_request->tender_order_company_id;

        $truckContractCore = new TruckContractCore();
        $tenderCompanyCore = new TenderCompanyCore();
        $cargoCore = new CargoCore();
        $truckOwnerCore = new TruckOwnerCore();
        $truckCore = new TruckCore();
        $tenderCore = new TenderCore();
        $QueueCore = new QueueCore();

        // get queue bean for truck_id
        $queueBean = $QueueCore->getQueuebasic($queue_id,  $_SESSION['user_id']);
        $truck_id = $queueBean->truck_id;

        // get trailer bean for trailer_id
        $activeTnStatus = DBConnection::getActiveStatus('truck');
        $trailerFilter = [['key' => "tn", 'val' => $trn], ['key' => 'status', 'val' => $activeTnStatus, 'op' => 'in']];
        $truckQuery = $truckCore->searchTrucks($trailerFilter, 1, 0, $_SESSION['user_id']);
        if ($truckQuery->found_rows == 0) {
            throw new Exception("رقم المقطورة غير صحيح");
        }
        $trailer_id = $truckQuery->data[0]->id;

        // get driver bean for driver_id
        if ($nn) {
            $activeDriverStatus = DBConnection::getActiveStatus('driver');
            $driverFilter = [["key" => "nn", "val" => $nn], ['key' => 'status', 'val' => $activeDriverStatus, 'op' => 'in']];
            $driverQuery = $this->_driverCore->searchDriver($driverFilter, 1, 0, $_SESSION['user_id'])->data[0];
            $driver_id = $driverQuery->id;
        } else {
            $driver_id = $queueBean->driver_id;
        }

        // get $tender Company
        $tenderCompanyFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ["key" => "status", "val" => ["ACTIVE", "NEW"], "op" => "in"],
            ['key' => 'trucking_company_id', 'val' => '395']
        ];
        $tenderCompaniesReuslt = $tenderCompanyCore->searchTenderCompany($tenderCompanyFilter, 1, 0, $_SESSION['user_id']);

        // get $truck owner_id and trailer owner id
        $truckFilter = [['key' => "id", 'val' => $truck_id]];
        $truckQuery = $truckCore->searchTrucks($truckFilter, 1, 0, $_SESSION['user_id']);
        $truck_owner_id = $truckQuery->data[0]->truck_owner_id;
        $trailer_owner_id = $truck_owner_id;
        $trucking_company_id = $tenderCompaniesReuslt->data[0]->trucking_company_id;
        // get waybill template from cargo and extract the following
        $orderBean = $tenderCore->getTenderOrderBasic($order_id,  $_SESSION['user_id']);
        $cargo_id = $orderBean->cargo[0];
        $cargoBean = $cargoCore->getCargoBasic($cargo_id, $_SESSION['user_id']);

        $waybill_template = $cargoBean->waybill_template;
        $ca_company_id = $waybill_template->cargo[0]->consigner->ca_id;

        $origin_id = $orderBean->questionnaire[1]->val;
        //$origin_id = prepareLocationValue($waybill_template->negotiable_instructios->route->origin, $cargoBean);
        $destination_id = prepareLocationValue($waybill_template->negotiable_instructios->route->destination, $cargoBean);


        // get destination_id
        $destination_id = $orderBean->questionnaire[0]->val;

        // validate if the truck has pending tender truck
        $tenderTruckSearchFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'truck_id', 'val' => $truck_id],
            ['key' => 'status', 'val' => 'PENDING']
        ];
        $tenderTrucks = $tenderCore->searchTenderTruck($tenderTruckSearchFilter, 1, 0, $_SESSION['user_id']);
        if ($tenderTrucks->found_rows > 0) {
            throw new Exception('عقد تشغيل الشاحنة على المشروع موقوف');
        }

        $user_id = $_SESSION['user_id'];

        try {
            DBConnection::startTransaction();

            $waybill_result = $this->_waybillCore->createWaybill(
                $tender_id,
                $queue_id,
                $order_id,
                $cargo_id,
                $truck_id,
                $trailer_id,
                $driver_id,
                $truck_owner_id,
                $trailer_owner_id,
                $trucking_company_id,
                $ca_company_id,
                $origin_id,
                $destination_id,
                $user_id,
                "IMPORT"
            );

            // write integration details into waybill
            $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_result->id, $user_id);
            $integeration_details = new stdClass();
            $integeration_details->queue = new stdClass();
            $integeration_details->queue->queue_id = $queueBean->id;
            $integeration_details->queue->q_id = $queueBean->q_id;
            $integeration_details->queue->queue_rank = $queueBean->rank;
            $integeration_details->queue->serial = $queueBean->serial;
            $integeration_details->waybill_order = new stdClass();
            $integeration_details->waybill_order->waybill_order_id = null;
            $waybillBean->document->integeration_details = $integeration_details;
            $this->_waybillCore->updateWaybill($waybillBean, $waybill_result->id, 0);

            // decide what to do with the queue of the truck
            $QueueCore->changeStatus($queue_id, 'CLOSED', 0); // Closed By System

            DBConnection::commitTransaction();

            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
            $Result['WN'] = $waybill_result;
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }


    // ----------------------------------------------------------------------------------------------------- //
    // --------------------------- Create new waybill for Light and Medium Transporttion ------------------- //
    // ----------------------------------------------------------------------------------------------------- //
    public function createLightMediumTransportWaybill()
    {

        $cargoCore = new CargoCore();
        $truckCore = new TruckCore();
        $tenderCore = new TenderCore();
        $QueueCore = new QueueCore();

        // get user input
        $tender_id = $this->_request->tender_id;
        $queue_id = $this->_request->queue_id;
        $q_id = $this->_request->q_id ? $this->_request->q_id : 1;
        $nn = $this->_request->nn;
        $order_id = $this->_request->order_id;
        $trailer_id =  null;
        $trailer_owner_id = null;

        // get queue bean for truck_id
        $queueBean = $QueueCore->getQueuebasic($queue_id,  $_SESSION['user_id']);

        $truck_id = $queueBean->truck_id;
        $truckBean = $truckCore->getTruckbasic($truck_id,  0);
        $truck_owner_id = $truckBean->truck_owner_id;


        // get driver bean for driver_id
        if ($nn) {
            $activeDriverStatus = DBConnection::getActiveStatus('driver');
            $driverFilter = [["key" => "nn", "val" => $nn], ['key' => 'status', 'val' => $activeDriverStatus, 'op' => 'in']];
            $driverQuery = $this->_driverCore->searchDriver($driverFilter, 1, 0, $_SESSION['user_id'])->data[0];
            $driver_id = $driverQuery->id;
        } else {
            $driver_id = $queueBean->driver_id;
        }


        // get waybill template from cargo and extract the following
        $orderBean = $tenderCore->getTenderOrderBasic($order_id,  $_SESSION['user_id']);

        $cargo_id = $orderBean->cargo[0];
        $cargoBean = $cargoCore->getCargoBasic($cargo_id,  $_SESSION['user_id']);
        $trucking_company_id = $cargoBean->waybill_template->carrier[0]->tc_id;
        $ca_company_id = $cargoBean->ca_id;
        $origin_id = prepareLocationValue($cargoBean->waybill_template->negotiable_instructios->route->origin, $cargoBean);
        $destination_id = prepareLocationValue($cargoBean->waybill_template->negotiable_instructios->route->destination, $cargoBean);

        // validate if the truck has pending tender truck
        $tenderTruckSearchFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'truck_id', 'val' => $truck_id],
            ['key' => 'status', 'val' => 'PENDING']
        ];
        $tenderTrucks = $tenderCore->searchTenderTruck($tenderTruckSearchFilter, 1, 0, $_SESSION['user_id']);
        if ($tenderTrucks->found_rows > 0) {
            throw new Exception('عقد تشغيل الشاحنة على المشروع موقوف');
        }

        $user_id = $_SESSION['user_id'];
        try {
            DBConnection::startTransaction();
            $waybill_result = $this->_waybillCore->createWaybill(
                $tender_id,
                $queue_id,
                $order_id,
                $cargo_id,
                $truck_id,
                $trailer_id,
                $driver_id,
                $truck_owner_id,
                $trailer_owner_id,
                $trucking_company_id,
                $ca_company_id,
                $origin_id,
                $destination_id,
                $user_id,
                "EXPORT"
            );

            // write integration details into waybill
            $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_result->id, $user_id);
            $integeration_details = new stdClass();
            $integeration_details->queue = new stdClass();
            $integeration_details->queue->queue_id = $queueBean->id;
            $integeration_details->queue->q_id = $queueBean->q_id;
            $integeration_details->queue->queue_rank = $queueBean->rank;
            $integeration_details->queue->serial = $queueBean->serial;
            $integeration_details->waybill_order = new stdClass();
            $integeration_details->waybill_order->waybill_order_id = null;
            $waybillBean->document->integeration_details = $integeration_details;
            $this->_waybillCore->updateWaybill($waybillBean, $waybill_result->id, 0);

            // decide what to do with the queue of the truck
            $QueueCore->changeStatus($queue_id, 'CLOSED', 0); // Closed By System

            DBConnection::commitTransaction();

            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
            $Result['WN'] = $waybill_result;
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            if (strpos($e->getMessage(), "uk_waybill_active_truck")) {
                throw new Exception("لا تستطيع المتابعة ، الشاحنة لديها رحلة غير منتهية");
            } else if (strpos($e->getMessage(), "uk_waybill_active_trailer")) {
                throw new Exception("لا تستطيع المتابعة ، المقطورة لديها رحلة غير منتهية");
            } else if (strpos($e->getMessage(), "uk_waybill_active_driver")) {
                throw new Exception("لا تستطيع المتابعة ، السائق لديه رحلة غير منتهية");
            } else {
                throw new Exception($e->getMessage());
            }
        }
    }

    // ---------------------------------------------------------------------------------------------------- //
    // --------------------------- Create new fuel waybill  -------------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function createFuelWaybill()
    {

        $tender_id = $this->_request->tender_id;
        $queue_id = $this->_request->queue_id;
        $q_id = $this->_request->q_id ? $this->_request->q_id : 1;
        $trn = $this->_request->trn;
        $nn = $this->_request->nn;
        $order_id = $this->_request->order_id;
        $tender_order_company_id = $this->_request->tender_order_company_id;
        $truck_axis = $this->_request->truck_axis;
        $trailer_axis = $this->_request->trailer_axis;

        $truckContractCore = new TruckContractCore();
        $tenderCompanyCore = new TenderCompanyCore();
        $cargoCore = new CargoCore();
        $truckOwnerCore = new TruckOwnerCore();
        $truckCore = new TruckCore();
        $tenderCore = new TenderCore();
        $QueueCore = new QueueCore();

        // get queue bean for truck_id
        $queueBean = $QueueCore->getQueuebasic($queue_id,  $_SESSION['user_id']);
        $truck_id = $queueBean->truck_id;

        // get trailer bean for trailer_id
        $activeTnStatus = DBConnection::getActiveStatus('truck');
        $trailerFilter = [['key' => "tn", 'val' => $trn], ['key' => 'status', 'val' => $activeTnStatus, 'op' => 'in']];
        $truckQuery = $truckCore->searchTrucks($trailerFilter, 1, 0, $_SESSION['user_id']);
        if ($truckQuery->found_rows == 0) {
            throw new Exception("رقم المقطورة غير صحيح");
        }
        $trailer_id = $truckQuery->data[0]->id;

        // get driver bean for driver_id
        if ($nn) {
            $activeDriverStatus = DBConnection::getActiveStatus('driver');
            $driverFilter = [["key" => "nn", "val" => $nn], ['key' => 'status', 'val' => $activeDriverStatus, 'op' => 'in']];
            $driverQuery = $this->_driverCore->searchDriver($driverFilter, 1, 0, $_SESSION['user_id'])->data[0];
            $driver_id = $driverQuery->id;
        } else {
            $driver_id = $queueBean->driver_id;
        }

        // validate axis
        if (!$truck_axis || !$trailer_axis) {
            throw new Exception("الأحمال المحورية غير موجودة");
        }

        // get $tender Company
        $tenderCompanyFilter = [['key' => 'tender_id', 'val' => $tender_id]];
        $tenderCompaniesReuslt = $tenderCompanyCore->searchTenderCompany($tenderCompanyFilter, 1, 0, $_SESSION['user_id']);

        // get $truck owner_id and trailer owner id
        $truckFilter = [['key' => "id", 'val' => $truck_id]];
        $truckQuery = $truckCore->searchTrucks($truckFilter, 1, 0, $_SESSION['user_id']);
        $truck_owner_id = $truckQuery->data[0]->truck_owner_id;
        $trailer_owner_id = $truck_owner_id;
        $trucking_company_id = $tenderCompaniesReuslt->data[0]->trucking_company_id;

        // get waybill template from cargo and extract the following
        $orderBean = $tenderCore->getTenderOrderBasic($order_id,  $_SESSION['user_id']);

        // if the tender order destination is 91030015 = "مصفاة البترول / بئر حمزة"
        if ($orderBean->questionnaire[0]->val == 91030015) {
            $cargo_id = 2010000003; // النفط الخام
            $cargoBean = $cargoCore->getCargoBasic($cargo_id, 0);
            $origin_id = 91030024;
            $destination_id = 91030015;
            $waybill_template = $cargoBean->waybill_template;
            $ca_company_id = $waybill_template->cargo[0]->consigner->ca_id;
        } else {
            $cargo_id = $orderBean->cargo[0];
            $cargoBean = $cargoCore->getCargoBasic($cargo_id, $_SESSION['user_id']);
            $waybill_template = $cargoBean->waybill_template;
            $ca_company_id = $waybill_template->cargo[0]->consigner->ca_id;
            $origin_id = prepareLocationValue($waybill_template->negotiable_instructios->route->origin, $cargoBean);
            $destination_id = prepareLocationValue($waybill_template->negotiable_instructios->route->destination, $cargoBean);
            // get destination_id
            $destination_id = $orderBean->questionnaire[0]->val;
        }

        // validate if the truck has pending tender truck
        $tenderTruckSearchFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'truck_id', 'val' => $truck_id],
            ['key' => 'status', 'val' => 'PENDING']
        ];
        $tenderTrucks = $tenderCore->searchTenderTruck($tenderTruckSearchFilter, 1, 0, $_SESSION['user_id']);
        if ($tenderTrucks->found_rows > 0) {
            throw new Exception('عقد تشغيل الشاحنة على المشروع موقوف');
        }

        $user_id = $_SESSION['user_id'];

        try {
            DBConnection::startTransaction();
            $waybill_result = $this->_waybillCore->createWaybill(
                $tender_id,
                $queue_id,
                $order_id,
                $cargo_id,
                $truck_id,
                $trailer_id,
                $driver_id,
                $truck_owner_id,
                $trailer_owner_id,
                $trucking_company_id,
                $ca_company_id,
                $origin_id,
                $destination_id,
                $user_id,
                "EXPORT"
            );

            // write integration details into waybill
            $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_result->id, $user_id);
            $integeration_details = new stdClass();
            $integeration_details->queue = new stdClass();
            $integeration_details->queue->queue_id = $queueBean->id;
            $integeration_details->queue->q_id = $queueBean->q_id;
            $integeration_details->queue->queue_rank = $queueBean->rank;
            $integeration_details->queue->serial = $queueBean->serial;
            $integeration_details->waybill_order = new stdClass();
            $integeration_details->waybill_order->waybill_order_id = null;
            $waybillBean->document->integeration_details = $integeration_details;
            // Log ticket id in the waybill details
            $ticketId = json_decode($orderBean->order_notes)->ticket_id;
            if ($ticketId) {
                $waybillBean->document = $this->_waybillCore->appendTicketToDocument($waybillBean->document, $ticketId, "CLINET", "FUEL_TENDER_ORDER");

                // reply to ticket
                $tn = $waybillBean->document->carrier[0]->truck->tn;
                $note = [
                    "senderName" =>  'مدارج للخدمات اللوجستية' . " - " . $_SESSION['employee_id'],
                    "title" => "تحديث وضع الطلبية",
                    "body" =>  "تم إشاء إرسالية رقم $waybill_result->wn للشاحنة رقم $tn+$trn"
                ];
                $this->_customerCare->replyToTicket($ticketId, $note);
            }
            $this->_waybillCore->updateWaybill($waybillBean, $waybill_result->id, 0);

            // decide what to do with the queue of the truck
            $QueueCore->changeStatus($queue_id, 'CLOSED', 0); // Closed By System

            // save axial loads for truck and trailer
            $truckBean = $this->_truckCore->getTruckBasic($truck_id, $user_id);
            $truckBean->axis = $truck_axis;
            $this->_truckCore->updateTruckInfo($truckBean, $truck_id, $user_id);

            $trailerBean = $this->_truckCore->getTruckBasic($trailer_id, $user_id);
            $trailerBean->axis = $trailer_axis;
            $this->_truckCore->updateTruckInfo($trailerBean, $trailer_id, $user_id);

            DBConnection::commitTransaction();

            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
            $Result['WN'] = $waybill_result;
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            if (strpos($e->getMessage(), "uk_waybill_active_truck")) {
                throw new Exception("لا تستطيع المتابعة ، الشاحنة لديها رحلة غير منتهية");
            } else if (strpos($e->getMessage(), "uk_waybill_active_trailer")) {
                throw new Exception("لا تستطيع المتابعة ، المقطورة لديها رحلة غير منتهية");
            } else if (strpos($e->getMessage(), "uk_waybill_active_driver")) {
                throw new Exception("لا تستطيع المتابعة ، السائق لديه رحلة غير منتهية");
            } else {
                throw new Exception($e->getMessage());
            }
        }
    }

    // ---------------------------------------------------------------------------------------------------- //
    // --------------------------- Create Oil Derivatives waybill  -------------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function createOilDerivativesWaybill()
    {

        $tender_id = $this->_request->tender_id;
        $queue_id = $this->_request->queue_id;
        $trn = $this->_request->trn;
        $nn = $this->_request->nn;
        $order_id = $this->_request->order_id;
        $tender_order_company_id = $this->_request->tender_order_company_id;
        $truck_axis = $this->_request->truck_axis;
        $trailer_axis = $this->_request->trailer_axis;
        $skip_queue = $this->_request->skip_queue;

        $truckContractCore = new TruckContractCore();
        $tenderCompanyCore = new TenderCompanyCore();
        $cargoCore = new CargoCore();
        $truckOwnerCore = new TruckOwnerCore();
        $truckCore = new TruckCore();
        $tenderCore = new TenderCore();
        $QueueCore = new QueueCore();

        // get queue bean for truck_id
        $queueBean = $QueueCore->getQueuebasic($queue_id,  $_SESSION['user_id']);
        $truck_id = $queueBean->truck_id;

        // get trailer bean for trailer_id
        $activeTnStatus = DBConnection::getActiveStatus('truck');
        $trailerFilter = [['key' => "tn", 'val' => $trn], ['key' => 'status', 'val' => $activeTnStatus, 'op' => 'in']];
        $truckQuery = $truckCore->searchTrucks($trailerFilter, 1, 0, $_SESSION['user_id']);
        if ($truckQuery->found_rows == 0) {
            throw new Exception("رقم المقطورة غير صحيح");
        }
        $trailer_id = $truckQuery->data[0]->id;

        // get driver bean for driver_id
        if ($nn) {
            $activeDriverStatus = DBConnection::getActiveStatus('driver');
            $driverFilter = [["key" => "nn", "val" => $nn], ['key' => 'status', 'val' => $activeDriverStatus, 'op' => 'in']];
            $driverQuery = $this->_driverCore->searchDriver($driverFilter, 1, 0, $_SESSION['user_id'])->data[0];
            $driver_id = $driverQuery->id;
        } else {
            $driver_id = $queueBean->driver_id;
        }

        // if no driver is defined, see if there is a driver on the last truck waybill
        if (!$driver_id) {
            $lastWaybillFilter = [
                ['key' => 'tender_id', 'val' => $queueBean->tender_id],
                ['key' => 'truck_id', 'val' => $truck_id],
                ['key' => 'status', 'val' => ['CLOSED', 'COMPLETE'], 'op' => 'in']
            ];
            $waybillResult = $this->_waybillCore->searchWaybills($lastWaybillFilter, 1, 0, $_SESSION['user_id'], ' order by id desc ');
            if ($waybillResult->found_rows > 0) {
                $driver_id = $waybillResult->data[0]->driver_id;
            }
        }

        // get $truck owner_id and trailer owner id
        $truckFilter = [['key' => "id", 'val' => $truck_id]];
        $truckQuery = $truckCore->searchTrucks($truckFilter, 1, 0, $_SESSION['user_id']);
        $truck_owner_id = $truckQuery->data[0]->truck_owner_id;
        $trailer_owner_id = $truck_owner_id;

        // get waybill template from cargo and extract the following
        $orderBean = $tenderCore->getTenderOrderBasic($order_id,  $_SESSION['user_id']);
        $cargo_id = $orderBean->cargo[0];
        $cargoBean = $cargoCore->getCargoBasic($cargo_id, $_SESSION['user_id']);

        $waybill_template = $cargoBean->waybill_template;
        $ca_company_id = $waybill_template->cargo[0]->consigner->ca_id;
        $trucking_company_id = $waybill_template->carrier[0]->tc_id;
        $destination_id = prepareLocationValue($waybill_template->negotiable_instructios->route->destination, $cargoBean);


        // get destination_id
        $destination_id = $orderBean->questionnaire[0]->val;
        $origin_id = $orderBean->questionnaire[1]->val;

        // validate if the truck has pending tender truck
        $tenderTruckSearchFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'truck_id', 'val' => $truck_id],
            ['key' => 'status', 'val' => 'PENDING']
        ];
        $tenderTrucks = $tenderCore->searchTenderTruck($tenderTruckSearchFilter, 1, 0, $_SESSION['user_id']);
        if ($tenderTrucks->found_rows > 0) {
            throw new Exception('عقد تشغيل الشاحنة على المشروع موقوف');
        }

        $user_id = $_SESSION['user_id'];

        try {
            DBConnection::startTransaction();

            $waybill_result = $this->_waybillCore->createWaybill(
                $tender_id,
                $queue_id,
                $order_id,
                $cargo_id,
                $truck_id,
                $trailer_id,
                $driver_id,
                $truck_owner_id,
                $trailer_owner_id,
                $trucking_company_id,
                $ca_company_id,
                $origin_id,
                $destination_id,
                $user_id,
                "EXPORT"
            );

            // write integration details into waybill
            $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_result->id, $user_id);
            $integeration_details = new stdClass();
            $integeration_details->queue = new stdClass();
            $integeration_details->queue->queue_id = $queueBean->id;
            $integeration_details->queue->q_id = $queueBean->q_id;
            $integeration_details->queue->queue_rank = $queueBean->rank;
            $integeration_details->queue->serial = $queueBean->serial;
            $integeration_details->waybill_order = new stdClass();
            $integeration_details->waybill_order->waybill_order_id = null;
            $waybillBean->document->integeration_details = $integeration_details;

            //add vaporization note node
            $last_waybill = $this->_waybillCore->searchWaybills($lastWaybillFilter, 1, 0, $_SESSION['user_id'], ' order by id desc ');
            if ($last_waybill->found_rows == 0) {
                $waybillBean->document->notes->print_note = "";
            } else {
                $result_cargo_id = json_decode($last_waybill->data[0]->document)->cargo[0]->cargo_id;
                // chaeck if last trip cargo is the same or different
                if ($result_cargo_id != $cargo_id) {
                    $waybillBean->document->notes->print_note = "الرجاء التأكد من وجود شهادة التبخير";
                } else {
                    $waybillBean->document->notes->print_note = "";
                }
            }

            //update waybill
            $this->_waybillCore->updateWaybill($waybillBean, $waybill_result->id, 0);


            if ($skip_queue && $skip_queue == true) {
                $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
                $can_continue = false;
                foreach ($userRolesArray as $role) {
                    if ($role == 'OPERATION_MANAGER') {
                        $can_continue = true;
                    }
                }
                if (!$can_continue) {
                    throw new Exception("لا توجد لديك صلاحية");
                }

                // skip queue
            } else {
                // decide what to do with the queue of the truck
                $QueueCore->changeStatus($queue_id, 'CLOSED', 0); // Closed By System

                // re-queue it
                $q_id = $queueBean->q_id;
                $new_queue_id = $QueueCore->addQueue($truck_id, $driver_id, $trailer_id, $q_id, $tender_id, 0);
            }

            DBConnection::commitTransaction();

            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
            $Result['WN'] = $waybill_result;
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            if (strpos($e->getMessage(), "uk_waybill_active_truck")) {
                throw new Exception("لا تستطيع المتابعة ، الشاحنة لديها رحلة غير منتهية");
            } else if (strpos($e->getMessage(), "uk_waybill_active_trailer")) {
                throw new Exception("لا تستطيع المتابعة ، المقطورة لديها رحلة غير منتهية");
            } else if (strpos($e->getMessage(), "uk_waybill_active_driver")) {
                throw new Exception("لا تستطيع المتابعة ، السائق لديه رحلة غير منتهية");
            } else {
                throw new Exception($e->getMessage());
            }
        }
    }


    // ---------------------------------------------------------------------------------------------------- //
    // --------------------------- Create new crude oil waybill  -------------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function createCruideOilWaybill()
    {

        // get user input
        $tender_id = $this->_request->tender_id;
        $queue_id = $this->_request->queue_id;
        $q_id = $this->_request->q_id ? $this->_request->q_id : 1;
        $trn = $this->_request->trn;
        $nn = $this->_request->nn;
        $tender_order_company_id = $this->_request->tender_order_company_id;
        $entry_point_id = $this->_request->origin_id;
        $without_requeue = $this->_request->without_requeue;
        $with_ltrc_submit = true;

        // init objects
        $truckContractCore = new TruckContractCore();
        $tenderCompanyCore = new TenderCompanyCore();
        $cargoCore = new CargoCore();
        $truckOwnerCore = new TruckOwnerCore();
        $truckCore = new TruckCore();
        $tenderCore = new TenderCore();
        $QueueCore = new QueueCore();

        // validate if the queue_id is minimum rank on queue
        $queueResult = $this->_queueCore->getNextTruck($tender_id, $q_id);
        if ($queueResult->found_rows == 0) {
            throw new Exception("لا توجد اي شاحنة على الدور");
        }
        $database_queue_id = $queueResult->data[0]->id;

        // in case the database queue_id does not equal to user params "queue_id" throw exception except for operation manager
        if ($database_queue_id != $queue_id) {
            $allowOvveride = false;
            $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
            foreach ($userRolesArray as $role) {
                if ($role == 'OPERATION_MANAGER') {
                    $allowOvveride = true;
                    break;
                }
            }
            if (!$allowOvveride) {
                throw new Exception("لا تستطيع المتابعة ، الشاحنة ليست على رأس الدور");
                die;
            }
        }

        // get queue bean for truck_id
        $queueBean = $QueueCore->getQueuebasic($queue_id,  $_SESSION['user_id']);
        $truck_id = $queueBean->truck_id;

        // get trailer bean for trailer_id
        $activeTnStatus = DBConnection::getActiveStatus('truck');
        $trailerFilter = [['key' => "tn", 'val' => $trn], ['key' => 'status', 'val' => $activeTnStatus, 'op' => 'in']];
        $truckQuery = $truckCore->searchTrucks($trailerFilter, 1, 0, $_SESSION['user_id']);
        if ($truckQuery->found_rows == 0) {
            throw new Exception("رقم المقطورة غير صحيح");
        }
        $trailer_id = $truckQuery->data[0]->id;

        // get driver bean for driver_id
        if ($nn) {
            $activeDriverStatus = DBConnection::getActiveStatus('driver');
            $driverFilter = [["key" => "nn", "val" => $nn], ['key' => 'status', 'val' => $activeDriverStatus, 'op' => 'in']];
            $driverQuery = $this->_driverCore->searchDriver($driverFilter, 1, 0, $_SESSION['user_id'])->data[0];
            $driver_id = $driverQuery->id;
        }

        // if the driver is not exist, take it from the last queue
        if (!$driver_id) {
            $driver_id = $queueBean->driver_id;
        }
        // if the driver is not exist, take it from the last waybill
        if (!$driver_id) {
            $lastWaybillFilter = [
                ['key' => 'tender_id', 'val' => $queueBean->tender_id],
                ['key' => 'truck_id', 'val' => $truck_id],
                ['key' => 'status', 'val' => ['CLOSED', 'COMPLETE'], 'op' => 'in']
            ];
            $waybillResult = $this->_waybillCore->searchWaybills($lastWaybillFilter, 1, 0, $_SESSION['user_id'], ' order by id desc ');
            if ($waybillResult->found_rows > 0) {
                $driver_id = $waybillResult->data[0]->driver_id;
            }
        }

        // validate if the driver is black listed
        $filter = [
            ['key' => 'driver_id', 'val' => $driver_id],
            ['key' => 'status', 'val' => 'PENDING'],
            ['key' => 'tender_id', 'val' => 11]
        ];
        $tenderDriverSearchResult = $this->_tenderDriverCore->searchTenderDriver($filter, 1, 0, 1);

        if ($tenderDriverSearchResult->found_rows > 0) {
            throw new Exception("لا تستطيع المتابعة، عقد تشغيل السائق على المشروع موقوف");
        }

        // use quota
        $sqlQuery = "SELECT
                        toc.*, tc.trucking_company_id as tc_id
                    FROM
                        tender_order_company toc
                            JOIN
                        tender_company tc ON tc.id = toc.tender_company_id
                    WHERE
                        toc.id = ?";
        $param = [$tender_order_company_id];
        $result = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
        $order_id = $result[0]->tender_order_id;

        // get $tender Company
        $tenderCompanyFilter = [['key' => 'tender_id', 'val' => $tender_id]];
        $tenderCompaniesReuslt = $tenderCompanyCore->searchTenderCompany($tenderCompanyFilter, 1, 0, 0);

        // get $truck owner_id and trailer owner id
        $truckFilter = [['key' => "id", 'val' => $truck_id]];
        $truckQuery = $truckCore->searchTrucks($truckFilter, 1, 0, $_SESSION['user_id']);
        $truck_owner_id = $truckQuery->data[0]->truck_owner_id;
        $trailer_owner_id = $truck_owner_id;

        $trucking_company_id = $result[0]->tc_id;

        // get waybill template from cargo and extract the following
        $orderBean = $tenderCore->getTenderOrderBasic($order_id,  0);
        $cargo_id = $orderBean->cargo[0];
        $cargoBean = $cargoCore->getCargoBasic($cargo_id, 0);

        $waybill_template = $cargoBean->waybill_template;
        $ca_company_id = $waybill_template->cargo[0]->consigner->ca_id;

        $origin_id = prepareLocationValue($waybill_template->negotiable_instructios->route->origin, $cargoBean);

        $destination_id = 91030015;

        // validate if the truck has pending tender truck
        $tenderTruckSearchFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'truck_id', 'val' => $truck_id],
            ['key' => 'status', 'val' => 'PENDING']
        ];
        $tenderTrucks = $tenderCore->searchTenderTruck($tenderTruckSearchFilter, 1, 0, 0);
        if ($tenderTrucks->found_rows > 0) {
            throw new Exception('عقد تشغيل الشاحنة على المشروع موقوف');
        }
        $user_id = $_SESSION['user_id'];

        // validate lock status
        $db_query = "select * from crude_oil_lock where id = 1";
        $lock_result =  DBConnection::runDatabaseQuery($db_query);
        if ($lock_result[0]->lock_status != "FREE") {
            if ($_SESSION['u_id'] == 475) {
                // continue;
            } else {
                throw new Exception("لا تستطيع المتابعة الرجاء الاتصال بقسم العمليات");
                die;
            }
        }


        try {
            DBConnection::startTransaction();

            // use 1 company quota
            $this->_tenderCore->useCompanyQuota($tender_id, $result[0]->tc_id, $result[0]->tender_order_id);

            // create waybill
            $crude_oil_waybill_result = $this->_waybillCore->createWaybill(
                $tender_id,
                $queue_id,
                $order_id,
                $cargo_id,
                $truck_id,
                $trailer_id,
                $driver_id,
                $truck_owner_id,
                $trailer_owner_id,
                $trucking_company_id,
                $ca_company_id,
                $origin_id,
                $destination_id,
                0,
                "IMPORT"
            );

            if (!$crude_oil_waybill_result || !isset($crude_oil_waybill_result->id) || !$crude_oil_waybill_result->id || $crude_oil_waybill_result->id == "") {
                throw new Exception("لم يتمكن النظام من انشاء ارسالية للشاحنة");
            }


            // lock
            $lock_query = "update crude_oil_lock set lock_status='LOCKED' where id = 1";
            DBConnection::runBindDatabaseQuery($lock_query, []);

            $user_roles = explode(",", $_SESSION['USER_ROLES']);
            $canRequeue = false;
            if (in_array("OPERATION_MANAGER", $user_roles)) {
                $canRequeue = true;
            }
            if ($without_requeue && !$canRequeue) {
                throw new Exception("لا يوجد لديك صلاحية لإنشاء مستند بدون ارجاع على اخر الدور");
            }

            // remove from T1 queue
            if (!$without_requeue) {
                $QueueCore->changeStatus($queue_id, 'CLOSED', 0); // Closed By System
                $checkPoint = 2;

                // add the truck again to the queue
                $new_queue_id = $QueueCore->addQueue($truck_id, $driver_id, $trailer_id, 1, $tender_id, 0);
                $newQueueBean = $QueueCore->getQueuebasic($new_queue_id,  $_SESSION['user_id']);
                $checkPoint = 3;
            }

            // remove Fuel queue
            $activeQueueStatus = DBConnection::getActiveStatus('queue');
            $queueSearchFilter = [
                ['key' => 'truck_id', 'val' => $truck_id],
                ['key' => 'q_id', 'val' => 1],
                ['key' => 'tender_id', 'val' => 12],
                ['key' => 'status', 'val' => $activeQueueStatus, 'op' => 'in']
            ];
            $queueTruckResult = $QueueCore->searchQueue($queueSearchFilter, 1, 0, 0);
            if ($queueTruckResult->found_rows > 0) {

                $fuel_queue_id = $queueTruckResult->data[0]->id;
                $QueueCore->changeStatus($fuel_queue_id, 'CLOSED', 0); // Closed By System
                $checkPoint = 4;

                // re-queue it
                $new_queue_id = $QueueCore->addQueue($truck_id, $driver_id, $trailer_id, 1, 12, 0);
                $checkPoint = 5;
            } else {
                // validate if the truck has feul tender truck
                $tenderTruckSearchFilter = [
                    ['key' => 'tender_id', 'val' => 12],
                    ['key' => 'truck_id', 'val' => $truck_id],
                    ['key' => 'status', 'val' => 'ACTIVE']
                ];
                $tenderTrucks = $tenderCore->searchTenderTruck($tenderTruckSearchFilter, 1, 0, 0);
                $checkPoint = 6;
                if ($tenderTrucks->found_rows) {
                    $new_queue_id = $QueueCore->addQueue($truck_id, $driver_id, $trailer_id, 1, 12, 0);
                    $checkPoint = 7;
                }
            }

            // unlock create
            $unlock_query = "update crude_oil_lock set lock_status='FREE' where id = 1";
            DBConnection::runBindDatabaseQuery($unlock_query, []);
            DBConnection::commitTransaction();

            // generate downpayment poll
            // $crude_oil_waybill_id = $crude_oil_waybill_result->id;
            // $source = "waybill";
            // $this->_pollIntegration->generateDownPaymentPoll($crude_oil_waybill_id , $source);

        } catch (Exception $e) {

            DBConnection::rollBackTransaction();

            // inform Hamzah
            $socialCore = new SocialCore();
            $data =  json_encode($this->_request, JSON_UNESCAPED_UNICODE);
            $socialCore->informSupervisor('خطأ انشاء مستند نفط خام', $checkPoint . " : " . $e->getMessage() . "-" . $data, $e->getMessage(), 2);

            if ($e->getMessage() == "لا تستطيع المتابعة ، لا يوجد حصة متبقية لشركة النقل") {
                // unlock create
                $unlock_query = "update crude_oil_lock set lock_status='FREE' where id = 1";
                DBConnection::runBindDatabaseQuery($unlock_query, []);
                $errorMessage =  $e->getMessage();
            } else if (strpos($e->getMessage(), "uk_waybill_active_truck")) {
                $errorMessage =  "لا تستطيع المتابعة ، الشاحنة لديها رحلة غير منتهية";
            } else if (strpos($e->getMessage(), "uk_waybill_active_trailer")) {
                $errorMessage = "لا تستطيع المتابعة ، المقطورة لديها رحلة غير منتهية";
            } else if (strpos($e->getMessage(), "uk_waybill_active_driver")) {
                $errorMessage = "لا تستطيع المتابعة ، السائق لديه رحلة غير منتهية";
            } else {
                $errorMessage = $e->getMessage();
            }

            throw new Exception($errorMessage);
        }


        try {
            if ($crude_oil_waybill_result->id) {

                // write integration details into waybill
                $new_integeration_details = new stdClass();
                if (!isset($new_integeration_details)) $new_integeration_details = new stdClass();
                $new_integeration_details->queue =  new stdClass();
                if (!isset($new_integeration_details->queue)) $new_integeration_details->queue = new stdClass();
                $new_integeration_details->queue->queue_id = $queueBean->id;
                $new_integeration_details->queue->queue_rank = $queueBean->rank;
                $new_integeration_details->queue->serial = $queueBean->serial;
                $new_integeration_details->queue->new_queue_rank = $newQueueBean->rank;
                $new_integeration_details->queue->new_serial = $newQueueBean->serial;
                $new_integeration_details->queue->entry_point_id = $entry_point_id;
                $new_integeration_details->queue->q_id = $newQueueBean->q_id;
                $waybillBean_2 = $this->_waybillCore->getWaybillBasic($crude_oil_waybill_result->id, 0);
                $waybillBean_2->document->integeration_details = $new_integeration_details;
                $this->_waybillCore->updateWaybill($waybillBean_2, $crude_oil_waybill_result->id, 0);

                // create LTRC permit if the user chosed that
                if ($with_ltrc_submit) {

                    $robot_param = new stdClass();
                    $robot_param->tn = $truckQuery->data[0]->tn;
                    $robot_param->driver_nn = $nn;
                    $robot_param->tc_id = $trucking_company_id;
                    $robot_param->trn = $trn;
                    $robot_param->waybill_id = $crude_oil_waybill_result->id;

                    $taskQueuesCore = new TaskQueuesCore();
                    $taskQueuesCore->createRobotTask("submitLtrcCrudeOilWaybill", $robot_param, 1);
                }


                $userResult = [];
                $userResult['ERRORCODE'] = "0";
                $userResult['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
                $userResult['WN'] = $crude_oil_waybill_result;
                parent::response($userResult);
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ---------------------------------------------------------------------------------------------------------------------- //
    // ------------------ get a list of late truck, these trucks have loading weight and no discharge weight ---------------- //
    // ------------------ and late for certain period of time --------------------------------------------------------------- //
    // ------------------ param: tender_id, late_hours , destination_id---------------------------------------------------------------------- //
    // ---------------------------------------------------------------------------------------------------------------------- //
    public function getLateWaybills()
    {

        // search for ONROAD waybills
        $tender_id = $this->_request->tender_id;
        $destination_id = $this->_request->destination_id;
        $waybillFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'destination_id', 'val' => $destination_id],
            ['key' => 'status', 'val' => 'ONROAD']
        ];
        $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter, 10000, 0, $_SESSION['user_id']);

        // loop on each waybill and calculate time elapsed since loading
        $currentTime = DBConnection::getSystemDate();
        $currentTime = date_create($currentTime);

        $result = [];
        foreach ($waybillResult->data as &$waybill_data) {
            $doc = json_decode($waybill_data->document);
            $loadingTime = $doc->cargo[0]->weights->loading->time_stamp;
            $loadingTime = date_create($loadingTime);
            $dateDiff = date_diff($loadingTime, $currentTime);
            $elapsedTime = $dateDiff->h + ($dateDiff->d * 24);

            // if elapsedTime > requested late_hours, push it to result array
            if ($elapsedTime > $this->_request->late_hours) {
                if ($dateDiff->d > 0) {
                    $waybill_data->elapsedTime = $dateDiff->d . " يوم و " . $dateDiff->h . " ساعة";
                } else {
                    $waybill_data->elapsedTime = $dateDiff->h . " ساعة";
                }

                $waybill_data->trn = $doc->carrier[0]->trailer->tn;
                $waybill_data->cargo_name = $doc->cargo[0]->cargo->name;
                $waybill_data->origin = $doc->negotiable_instructios->route->origin->name;
                $waybill_data->destination = $doc->negotiable_instructios->route->destination->name;
                $result[] = $waybill_data;
            }
        }

        parent::response($result);
    }


    // --------------------------------------------------------------------------------------------------- //
    // ------------------ get a list of complete waybills with financial data  --------------------------- //
    // ------------------ param: tender_id, trucking_company_id, loading_date_from, loading_date_to ------ //
    // --------------------------------------------------------------------------------------------------- //
    public function getWaybillsFinancialData()
    {

        //parse inputs
        $tender_id = $this->_request->tender_id;
        $trucking_company_id = $this->_request->trucking_company_id;
        $loading_date_from = $this->_request->loading_date_from;
        $loading_date_to = $this->_request->loading_date_to;
        $cargo_id = $this->_request->cargo_id;

        // validate auth
        $this->_tenderCore->validateTenderReportAuth($tender_id, 'waybills_report', $_SESSION['USER_ROLES']);

        // get list of complete waybills
        $waybillFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'trucking_company_id', 'val' => $trucking_company_id],
            ['key' => 'status', 'val' => ['COMPLETE', 'CLOSED'], 'op' => 'in']
        ];
        if ($loading_date_from) {
            $waybillFilter[] = ['key' => 'loading_date', 'val' => $loading_date_from, 'op' => 'greater than'];
            $waybillFilter[] = ['key' => 'loading_date', 'val' => $loading_date_to, 'op' => 'less than'];
        }
        if ($cargo_id) {
            $waybillFilter[] = ['key' => 'document', 'val' => $cargo_id, 'op' => 'json', 'node' => '$.cargo[0].cargo_id'];
        }

        $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter, 10000, 0, $_SESSION['user_id']);

        // prepare data
        $result = [];
        foreach ($waybillResult->data as $waybill_data) {
            $data = new stdClass();
            $doc = json_decode($waybill_data->document);
            $waybill_data->document = $doc;

            // waybill info
            $data->wn = $waybill_data->wn;
            $data->tn = $waybill_data->tn;
            $data->trn = $doc->carrier[0]->trailer->tn;
            $data->driver_name = $doc->carrier[0]->driver->name;
            $data->company = $doc->carrier[0]->tc->name;
            $data->cargo_name = $doc->cargo[0]->cargo->name;
            $data->origin = $doc->negotiable_instructios->route->origin->name;
            $data->destination = $doc->negotiable_instructios->route->destination->name;

            // waybridge info
            $data->loading_weight = $doc->cargo[0]->weights->loading->net_weight;
            $data->loading_time = $doc->cargo[0]->weights->loading->time_stamp;
            $data->discharge_weight = $doc->cargo[0]->weights->discharge->net_weight;
            $data->discharge_time = $doc->cargo[0]->weights->discharge->time_stamp;
            $data->loss = $data->discharge_weight - $data->loading_weight;

            // wages
            $data->wage_plan = $doc->freight->route_wage->plan;
            $data->wage_per_ton = $doc->freight->route_wage->wage_per_ton;

            // fines
            $data->loss_fine = $doc->freight->amount->loss_fine;
            $data->loss_fine_per_kg = $doc->freight->amount->loss_fine_per_kg;
            $data->loss_in_kg = $doc->freight->amount->loss_in_kg;

            // deductions
            $data->late_days = $this->_waybillCore->calculateExtraFeesLateDays($waybill_data, $doc->tender->id);
            $data->late_fine = $this->_waybillCore->calculateExtraFees($waybill_data, $doc->tender->id, 'LOADING_DATE_DELAY');
            $data->total_deductions = $doc->freight->amount->total_deductions;

            // bond info
            $data->bond_number = $doc->notes->bond->id;

            // net amount
            $data->net_amount = $doc->freight->amount->net_amount;
            $data->base_amount = $doc->freight->amount->base_amount;

            $result[] = $data;
        }

        parent::response($result);
    }


    // --------------------------------------------------------------------------------------------------- //
    // ------------------ get a list of complete waybills with financial data  --------------------------- //
    // ------------------ param: tender_id, trucking_company_id, loading_date_from, loading_date_to ------ //
    // --------------------------------------------------------------------------------------------------- //
    public function getRevokedWaybillsReport()
    {

        //parse inputs
        $tender_id = $this->_request->tender_id;
        $create_date_from = $this->_request->create_date_from;
        $create_date_to = $this->_request->create_date_to;

        // validate auth
        $this->_tenderCore->validateTenderReportAuth($tender_id, 'revoked_waybill_report', $_SESSION['USER_ROLES']);

        // get list of revoked waybills
        $waybillFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'status', 'val' => ['INACTIVE', 'REVOKED'], 'op' => 'in'],
            ['key' => 'create_date', 'val' => $create_date_from, 'op' => 'greater than'],
            ['key' => 'create_date', 'val' => $create_date_to, 'op' => 'less than']
        ];
        $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter, 10000, 0, $_SESSION['user_id']);

        // prepare data
        $result = [];
        foreach ($waybillResult->data as $waybill_data) {
            $data = new stdClass();
            $doc = json_decode($waybill_data->document);

            // waybill info
            $data->wn = $waybill_data->wn;
            $data->tn = $waybill_data->tn;
            $data->trn = $doc->carrier[0]->trailer->tn;
            $data->destination = $doc->negotiable_instructios->route->destination->name;
            $data->cargo_name = $doc->cargo[0]->cargo->name;
            $data->owner_name = $doc->carrier[0]->truck_owner->name;

            // activity info
            $waybillBean = $this->_waybillCore->getWaybill($waybill_data->id, $_SESSION['user_id']);
            $waybillBean = json_decode($waybillBean);

            foreach ($waybillBean->activity as $activity) {
                if ($activity->action_code == 'ADD_NOTE' && ($activity->object_status_code == 'REVOKED' || $activity->object_status_code == 'INACTIVE')) {
                    $data->revoke_reason = $activity->notes;
                    $data->revoke_date = date('Y-m-d H:i', strtotime($activity->activity_date));
                    $data->revoke_by = $activity->u_id;
                }
            }

            $result[] = $data;
        }

        parent::response($result);
    }

    // -------------------------------------------------------------------------------- //
    // -------------------- Render queue info to mobile --------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function renderWaybillInfo()
    {

        $result = new stdClass();

        if ($this->_request->waybill_id < 2200000000) {

            $waybill = $this->_waybillCore->searchWaybills(
                [['key' => 'id', 'val' => $this->_request->waybill_id]],
                1,
                0,
                $_SESSION['user_id']
            );
        }

        // the id is land trip id
        else {
            $container_data = new stdClass();
            $container_data->filter = json_encode(['id' => $this->_request->waybill_id]);
            $waybill = $this->_con->searchLandTrip($container_data, 0)['data'][0];
            $temp = json_decode(json_encode($waybill));
            $temp->tender_id = 21;

            $waybill = new stdClass();
            $waybill->data = [$temp];
            $waybill->found_rows = 1;
        }

        if ($waybill->found_rows == 0) {
            // if
            $waybillInfoHtml = $this->_waybillCore->renderInvalidWaybill();
            $result->ERRORCODE = 1;
            $result->waybillInfoHtml = $waybillInfoHtml;
        } else {
            $waybillBean = $waybill->data[0];

            switch ($waybillBean->tender_id) {
                case 3:    // "البواخر"
                    $waybillInfoHtml = $this->_waybillCore->renderAdelWaybill($waybillBean);
                    $financialInfoHtml = $this->_waybillCore->renderAdelFinancial($waybillBean);
                    break;

                case 11:    // "النفط ومشتقاته"
                    $waybillInfoHtml = $this->_waybillCore->renderCrudeOilWaybill($waybillBean);

                    $document = json_decode($waybillBean->document);
                    // if($_SESSION['u_id'] == 2 || $_SESSION['u_id'] == 475){
                    $financialInfoHtml = $this->_waybillCore->renderNewTotalPayments($document->freight, $document->activities);
                    // }
                    // else{
                    //     $financialInfoHtml = $this->_waybillCore->renderTotalPayments($document->freight);
                    // }

                    //$financialInfoHtml= $this->_waybillCore->renderInvalidFinancial();

                    break;

                case 12:   // الفيول
                    $waybillInfoHtml = $this->_waybillCore->renderFuelWaybill($waybillBean);
                    $financialInfoHtml = $this->_waybillCore->renderInvalidFinancial();
                    break;

                case 13:    // "التموين"
                    $waybillInfoHtml = $this->_waybillCore->renderGrainWaybill($waybillBean);
                    $financialInfoHtml = $this->_waybillCore->renderGrainFinancial($waybillBean);
                    break;
                case 15:    // "المسشتقات"
                    $waybillInfoHtml = $this->_waybillCore->renderCrudeOilWaybill($waybillBean);
                    $financialInfoHtml = $this->_waybillCore->renderInvalidFinancial($waybillBean);
                    break;
                case 21:    // "الحاويات"
                    $waybillInfoHtml = $this->_landtripCore->renderContainerLandTrip($waybillBean);
                    // $financialInfoHtml = $this->_waybillCore->renderInvalidFinancial($waybillBean);
                    break;
                default:
                    $waybillInfoHtml =  $this->_waybillCore->renderInvalidWaybill();;
                    $financialInfoHtml =  $this->_waybillCore->renderInvalidFinancial();
                    break;
            }
            $result->ERRORCODE = 0;
            $result->tabs = [
                "waybill_info" => $waybillInfoHtml,
                "financial_info" => $financialInfoHtml,
            ];
        }

        parent::response($result);
    }


    // ----------------------------------------------------------------------------------------- //
    // ------------------ Update the first trip node in waybill document ----------------------- //
    // ----------------------------------------------------------------------------------------- //
    public function updateWaybillFirstTrip()
    {
        $destination_id = $this->_request->destination_id;
        $entry_location = $this->_request->entry_location;
        $trip_type = $this->_request->trip_type;
        $id = $this->_request->id;


        if ($trip_type == "export" || $trip_type == "import_export") {
            if (!$destination_id) {
                throw new Exception("موقع التفريغ مطلوب");
            }
            // TODO : get caption of destination and ct
            $destinationBean = $this->_locationCore->getBasicLocation(
                $destination_id,
                $_SESSION['user_id']
            );
        }

        if (!$entry_location) {
            throw new Exception("مركز الدخول مطلوب");
        }
        if (!$trip_type) {
            throw new Exception("نوع العملية مطلوب");
        }

        $waybillBean = $this->_waybillCore->getWaybillBasic($id, $_SESSION['user_id']);
        // add note to waybill document
        $waybillJson = $waybillBean->document;
        if (!$waybillJson->first_trip) {
            $waybillJson->first_trip = new stdClass();
        }

        $waybillJson->first_trip->type = $trip_type;
        if ($destination_id) {
            $waybillJson->first_trip->destination = $destination_id;
        }
        $waybillJson->first_trip->entry_location = $entry_location;
        $waybillBean->document = $waybillJson;
        $this->_waybillCore->updateWaybill($waybillBean, $id, $_SESSION['user_id']);
        if ($trip_type == 'export') {
            $temp = 'تصدير';
        } else if ($trip_type == 'import') {
            $temp = 'استيراد';
        } else if ($trip_type == 'import_export') {
            $temp = 'استيراد-تصدير';
        }

        $entryLocationBean = $this->_locationCore->getBasicLocation(
            $entry_location,
            $_SESSION['user_id']
        );

        $this->_waybillCore->logActivity(
            $this->_request->id,
            "تعديل بيانات الرحلة الاولى",
            "العملية : " . $temp . " مركز التفريغ" . $destinationBean->name . "مركز الدخول " . $entryLocationBean->name,
            "updateWaybillFirstTrip",
            $_SESSION['user_id']
        );
        // return result
        $Result = [];
        $Result['ERRORCODE'] = '0';
        $Result['MESSAGE'] = 'WAYBILL.SUCCESS_OPERATION';
        parent::response($Result);
    }




    // --------------------------------------------------------------------------------------- //
    // ------------------- get last waybill info by tn(truck number)-------------------------- //
    // ------------------- Params: tn -------------------------------------------------------- //
    // --------------------------------------------------------------------------------------- //
    public function getExternalLastWaybillInfo()
    {
        //Parse request params
        $tn = $this->_request->tn;
        $userId = $_SESSION['user_id'];
        //Handle tn is not sent
        if (!$tn)
            throw new Exception("API expected param[tn: Ineger] to be sent");
        // If tn is sent
        else {
            // Prepare filters
            $waybillFilter = [
                ["key" => "tn", "val" => $tn],
                ['key' => 'status', 'val' => ['CLOSED', 'COMPLETE'], 'op' => 'in']
            ];
            $bon_numbers = [];
            // Get the first carrier object from the waybills` document
            $waybills = $this->_waybillCore->searchWaybills($waybillFilter, 1000, 0, $userId);
            $carrier = json_decode($waybills->data[0]->document)->carrier[0];
            // Get driver national number (nn)
            $driverFilter = [
                ["key" => "phone", "val" => $carrier->driver->phone]
            ];

            $driverNN = $this->_driverCore->searchDriver($driverFilter, 1, 0, $userId)->data[0]->nn;
            foreach ($waybills->data as $waybill) {
                $document = json_decode($waybill->document);
                if ($document->notes && $document->notes->bond->id) {
                    $bond_object = new stdClass();
                    $bond_object->id = $document->notes->bond->id . "";
                    $bond_object->create_date = $waybill->create_date;
                    array_push($bon_numbers, $bond_object);
                }
            }

            // Prepare the response
            $autoComplete = new stdClass();
            $autoComplete->tn = $carrier->truck->tn;
            $autoComplete->trn = $carrier->trailer->tn;
            $autoComplete->driver_nn = $driverNN;
            $autoComplete->driver_name = $carrier->driver->name;
            $autoComplete->driver_phone = $carrier->driver->phone;
            $autoComplete->bond_numbers = $bon_numbers;

            parent::response($autoComplete);
        }
    }



    // Comparator function used for comparator
    public static function comparator($object1, $object2)
    {
        return $object1->total_waybill < $object2->total_waybill;
    }


    // ----------------------------------------------------------------------------------------------- //
    // ------------------- Get Vessel Loading performance report ------------------------------------- //
    //-------------------- Params: tender_id, [cargo_id] --------------------------------------------- //
    // ----------------------------------------------------------------------------------------------- //
    public function getVesselLoadingPerformanceReport()
    {

        // parse incoming params
        $tender_id = $this->_request->tender_id;
        $cargo_ids = explode(",", $this->_request->cargo_ids);
        $cargo_ids[] = 0;

        $waybillFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'loading_date', 'op' => 'is not null'],
            ['key' => 'cargo_id', 'val' => $cargo_ids, 'op' => 'in'],
            ['key' => 'status', 'val' => ['INACTIVE', 'REVOKED'], 'op' => 'not in']
        ];

        $order_by = " order by loading_date ";
        $waybillResult = DBConnection::searchReport("waybill", "01", $waybillFilter, 10000, 0, $_SESSION['user_id'], $order_by);

        // get the origin of each cargo
        $cargoSearchFilter = [['key' => 'id', 'val' => $cargo_ids, 'op' => 'in']];
        $searchCargoResult = $this->_cargoCore->searchCargo($cargoSearchFilter, 50, 0, $_SESSION['user_id']);
        $cargoLocation = [];
        $vesselNames = [];
        $cargoWeight = 0;
        foreach ($searchCargoResult->data as $cargo) {
            $locationBean = $this->_locationCore->getBasicLocation($cargo->location_id, $_SESSION['user_id']);
            $cargoLocation[] = $locationBean->name;
            $cargoWeight += $cargo->weight_total;
            $vesselNames[] = $cargo->vessel_name;
        }

        if ($waybillResult->found_rows == 0) {
            $Result = [];
            $Result['cargoWeight'] = 0;
            $Result['waybillWeight'] = 0;
            $Result['cargoLocation'] = "";
            $Result['firstLoad'] = 0;
            $Result['lastLoad'] = 0;
            $Result['elapsed_time_in_days'] = 0;
            $Result['elapsed_time_in_hours'] = 0;
            $Result['total_waybills'] = 0;
            $Result['daily_loading_trucks_avg'] = 0;
            parent::response($Result);
            die;
        } else {
            $waybillWeight = 0;
            $avgWaybillWeight = 0;
            $counter = 0;
            foreach ($waybillResult->data as $wbl) {
                $counter++;
                $loading_weight = $wbl->loading_weight;
                $waybillWeight += $loading_weight;
                $avgWaybillWeight = $waybillWeight / $counter;
            }
            $avgWaybillWeight = round($avgWaybillWeight);
        }

        // get the expected number of waybills
        if ($avgWaybillWeight > 0) {
            $expectedWaybills = round($cargoWeight / $avgWaybillWeight);
        } else {
            $expectedWaybills = "غير متوفر";
        }

        // get first loadiong and last loading times
        $firstLoad = "";
        foreach ($waybillResult->data as $tempWaybill) {
            if (strpos($tempWaybill->loading_date, '00:00') !== false) {
                // skip
            } else {
                $firstLoad = $tempWaybill->loading_date;
                break;
            }
        }

        $lastLoad = $waybillResult->data[sizeof($waybillResult->data) - 1]->loading_date;

        // get the elapsed time between first and last waybil
        $firstLoadDate = date_create(date($firstLoad));
        $lastLoadDate  = date_create(date($lastLoad));
        $dateDiff = date_diff($lastLoadDate, $firstLoadDate);

        // prepare result for user
        $Result = [];
        $Result['cargoWeight'] = $cargoWeight;
        $Result['waybillWeight'] = $waybillWeight;
        $Result['avgWaybillWeight'] = $avgWaybillWeight;
        $Result['cargoLocation'] = implode("-", array_unique($cargoLocation));
        $Result['vesselName'] = implode(",", array_unique($vesselNames));;
        $Result['firstLoad'] = $firstLoad;
        $Result['lastLoad'] = $lastLoad;
        $Result['elapsed_time_in_days'] = $dateDiff->d;
        $Result['elapsed_time_in_hours'] = $dateDiff->h;
        $Result['total_waybills'] = $waybillResult->found_rows;
        $Result['expected_waybills'] = $expectedWaybills;
        $Result['daily_loading_trucks_avg'] = $dateDiff->d == 0 ? $waybillResult->found_rows :
            round($waybillResult->found_rows / ($dateDiff->d + ($dateDiff->h / 24)));
        $Result['daily_loading_avg'] = round(($Result['daily_loading_trucks_avg'] / $waybillResult->found_rows) * 100, 1) . "%";

        parent::response($Result);
    }


    // ----------------------------------------------------------------------------- //
    // --------------------- Sync Jo Petrol waybill -------------------------------- //
    // ----------------------------------------------------------------------------- //
    public function syncJoPetrolWaybill()
    {

        $waybill_id = $this->_request->waybill_id;
        $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);

        $jo_petrol_integration = new Jo_Petrol();

        try {
            // $jo_petrol_integration->deleteWaybill($waybill_id);
        } catch (Exception $e) {
        }

        $jo_petrol_integration->insertWaybill($waybillBean);

        $Result = [];
        $Result['ERRORCODE'] = '0';
        $Result['MESSAGE'] = 'WAYBILL.SUCCESS_OPERATION';
        parent::response($Result);
    }


    // --------------------------------------------------------------------------------------- //
    // ----------------------- Resend grains waybill ----------------------------------------- //
    // --------------------------------------------------------------------------------------- //
    public function resendGrainsWaybill()
    {

        // $waybill_id = $this->_request->waybill_id;
        // $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);

        // $grains = new Grains();
        // $grains->insertAqabaWaybill($waybillBean);

        // $Result = [];
        // $Result['ERRORCODE'] = '0';
        // $Result['MESSAGE'] = 'WAYBILL.SUCCESS_OPERATION';
        // parent::response($Result);
    }


    // --------------------------------------------------------------------------------------- //
    // ----------------------- Save the permit number of nafith in the waybill --------------- //
    // --------------------------------------------------------------------------------------- //
    public function saveNafithPermitNumber()
    {

        try {
            $waybill_id = $this->_request->waybill_id;
            $nafith_pn = $this->_request->permit_number;

            // save nafith permit number
            $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);
            $integeration_details = $waybillBean->document->integeration_details;
            $integeration_details->nafith = new stdClass();
            $integeration_details->nafith->permit_number = $nafith_pn;
            $integeration_details->nafith->time_stamp = DBConnection::getSystemDate();
            $waybillBean->document->integeration_details = $integeration_details;
            $this->_waybillCore->updateWaybill($waybillBean, $waybill_id, 0);

            // log event
            $this->_waybillCore->logActivity($waybill_id, "تقديم تصريح نافذ", "رقم التصريح :" . $nafith_pn, "ADD_NOTES", $_SESSION['u_id']);

            // send SMS to driver
            $tn = $waybillBean->document->carrier[0]->truck->tn;
            $driver_phone = $waybillBean->document->carrier[0]->driver->phone;
            $messageRecipient = $driver_phone;
            $messageBody = "$tn-تم تقديم التصريح الرجاء التوجه نحو المكتب لأستلام الإرسالية";
            $result = sendSMS($messageRecipient, $messageBody);

            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'WAYBILL.SUCCESS_OPERATION';
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // --------------------------------------------------------------------------------------- //
    // ----------- search for waybill info in Jo petrol system ------------------------------- //
    // --------------------------------------------------------------------------------------- //
    public function getJoPetrolWaybillInfo()
    {

        $input = $this->_request->waybill_id;


        // if the input format is WN
        if (strlen($input) == 10 && (substr($input, 0, 2) == "20" || substr($input, 0, 2) == "21")) {
            // query to get waybill id
            $waybillFilter = [
                ['key' => 'wn', 'val' => $input],
                ['key' => 'tender_id', 'val' => [11, 12], 'op' => 'in'],
                ['key' => 'create_date', 'val' => '2020-01-01', 'op' => 'date greater than']
            ];

            $waybill_qry = $this->_waybillCore->searchWaybills($waybillFilter, 1, 0, $_SESSION['user_id']);
        } else {
            // try to search for policy number
            $two_months_from_now =  date('Y-m-d', strtotime(DBConnection::getSystemdate() . "-2 months"));
            $waybillFilter = [
                ['key' => 'document', 'val' => $input, 'op' => 'json unquote', 'node' => '$.integeration_details.jo_petrol.nfldnm'],
                ['key' => 'tender_id', 'val' => 11],
                ['key' => 'create_date', 'val' => $two_months_from_now, 'op' => 'date greater than'],
            ];
            $waybill_qry = $this->_waybillCore->searchWaybills($waybillFilter, 1, 0, $_SESSION['user_id']);

            // if the search in the past 2 months return 0 result, try to search in the whole interval
            if ($waybill_qry->found_rows == 0) {
                $waybillFilter = [
                    ['key' => 'document', 'val' => $input, 'op' => 'json unquote', 'node' => '$.integeration_details.jo_petrol.nfldnm'],
                    ['key' => 'tender_id', 'val' => 11]
                ];
                $waybill_qry = $this->_waybillCore->searchWaybills($waybillFilter, 1, 0, $_SESSION['user_id']);
            }
        }


        if ($waybill_qry->found_rows == 0) {
            throw new Exception("لا توجد معلومات");
        }

        $jo_petrol_integration = new Jo_Petrol();
        $waybill = $jo_petrol_integration->QueryOnWayBill($waybill_qry->data[0]->id);

        // refresh local weights in case it is not saved
        $waybill_id = $waybill_qry->data[0]->id;
        $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);

        if (!$waybillBean->document->cargo[0]->loading->net_weight || !$waybillBean->document->cargo[0]->loading->net_weight == "") {
            // format $loading_time_stamp;
            $waybill['loading_weight'] = doubleval($waybill['loading_weight']);
            $loading_weight = doubleval($waybill['loading_weight'] / 1000);

            $cargoBean = $waybillBean->document->cargo[0];
            $loading_time_stamp = $waybill['loading_date'] . " " . $waybill['loading_time'];
            if (!$loading_time_stamp || $loading_time_stamp == " " || $loading_time_stamp == "") {
                $loading_time_stamp = DBConnection::getSystemDate();
                $cargoBean->weights->loading->time_stamp_source = "MINAGATE";
            }

            // write down the loading weights
            $cargoBean->weights->loading->net_weight = $loading_weight;
            $cargoBean->weights->loading->time_stamp = $loading_time_stamp;

            $waybillBean->document->cargo[0] = $cargoBean;
            $this->_waybillCore->updateWeight($waybillBean, $_SESSION['user_id']);

            // if the loading weight in waybill is different than integration weight
            $original_loading_weight = $cargoBean->weights->loading->net_weight;
            if ($original_loading_weight && $original_loading_weight != $loading_weight) {
                $this->_waybillCore->logActivity(
                    $waybillBean->id,
                    "تغير وزن التحميل - ربط إلكتروني",
                    "وزن التحميل القديم: " . $original_loading_weight . "  - الوزن الجديد : " . $loading_weight . " كغم",
                    "LOAD_CARGO",
                    0
                );
            } else {
                // write down note
                $this->_waybillCore->logActivity(
                    $waybillBean->id,
                    " تثبيت وزن التحميل - ربط الكتروني ",
                    "وزن التحميل : " . $loading_weight . " كغم ",
                    "LOAD_CARGO",
                    0
                );
            }

            if (!$waybillBean->document->integeration_details->jo_petrol) {
                $waybillBean->document->integeration_details->jo_petrol = new stdClass();
            }
            $waybillBean->document->integeration_details->jo_petrol = $waybill;
            $this->_waybillCore->updateWaybill($waybillBean, $waybillBean->id, 0);
        }


        if (!$waybillBean->document->cargo[0]->discharge->net_weight || !$waybillBean->document->cargo[0]->discharge->net_weight == "") {
            // format $discharge_time_stamp;
            $waybill['discharge_weight'] = doubleval($waybill['discharge_weight']);
            $discharge_weight = doubleval($waybill['discharge_weight'] / 1000);

            $cargoBean = $waybillBean->document->cargo[0];
            $discharge_time_stamp = $waybill['discharge_date'] . " " . $waybill['discharge_date'];
            if (!$discharge_time_stamp || $discharge_time_stamp == " " || $discharge_time_stamp == "") {
                $discharge_time_stamp = DBConnection::getSystemDate();
                $cargoBean->weights->discharge->time_stamp_source = "MINAGATE";
            }

            // write down the discharge weights
            $cargoBean->weights->discharge->net_weight = $discharge_weight;
            $cargoBean->weights->discharge->time_stamp = $discharge_time_stamp;

            $waybillBean->document->cargo[0] = $cargoBean;
            $this->_waybillCore->updateWeight($waybillBean, $_SESSION['user_id']);

            // if the discharge weight in waybill is different than integration weight
            $original_discharge_weight = $cargoBean->weights->discharge->net_weight;
            if ($original_discharge_weight && $original_discharge_weight != $discharge_weight) {
                $this->_waybillCore->logActivity(
                    $waybillBean->id,
                    "تغير وزن التفريغ - ربط إلكتروني",
                    "وزن التفريغ القديم: " . $original_discharge_weight . "  - الوزن الجديد : " . $discharge_weight . " كغم",
                    "LOAD_CARGO",
                    0
                );
            } else {
                // write down note
                $this->_waybillCore->logActivity(
                    $waybillBean->id,
                    " تثبيت وزن التفريغ - ربط الكتروني ",
                    "وزن التحميل : " . $discharge_weight . " كغم ",
                    "LOAD_CARGO",
                    0
                );
            }

            if (!$waybillBean->document->integeration_details->jo_petrol) {
                $waybillBean->document->integeration_details->jo_petrol = new stdClass();
            }
            $waybillBean->document->integeration_details->jo_petrol = $waybill;
            $this->_waybillCore->updateWaybill($waybillBean, $waybillBean->id, 0);
        }

        parent::response($waybill);
    }


    // --------------------------------------------------------------------------------------- //
    // ----------- delete waybill from Jo petrol system ------------------------------- //
    // --------------------------------------------------------------------------------------- //
    public function deleteJoPetrolInfo()
    {

        $waybill_id = $this->_request->waybill_id;
        $jo_petrol_integration = new Jo_Petrol();
        $Result = $jo_petrol_integration->deleteWaybill($waybill_id);

        parent::response($Result);
    }


    // ---------------------------------------------------------------------------------------------------- //
    // -------------------- activate Waybill by terminal and change the trn and driver  ------------------- //
    // ---------------------------------------------------------------------------------------------------- //
    public function activateWaybillByTerminal()
    {

        // get user params
        $waybill_id = $this->_request->waybill_id;
        $driver_nn = $this->_request->driver_nn;
        $trn = $this->_request->trn;
        $first_trip_ct = $this->_request->first_trip_ct;
        $first_trip_destination_id = $this->_request->first_trip_destination_id;
        $first_trip_type = $this->_request->first_trip_type;
        $entry_location = $this->_request->entry_location;
        $truck_route_id = $this->_request->truck_route_id;

        // validate user params
        if (!$waybill_id) {
            throw new Exception("waybill_id is required");
        }
        if (!$driver_nn) {
            throw new Exception("الرجاء ادخال الرقم الوطني");
        }
        if (!$trn) {
            throw new Exception("الرجاء ادخال رقم المقطورة");
        }
        //if(!$truck_route_id){throw new Exception("الرجاء تحديد الوجهة"); }

        // get waybill bean
        $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);
        $truck_id = $waybillBean->document->carrier[0]->truck->id;
        // validate waybill bean
        if ($waybillBean->status != 'NEW') {
            throw new Exception("حالة مستند الشحن غير صحيحة ، الرجاء مراجعة قسم العمليات");
        }

        // driver
        if ($driver_nn && $driver_nn != "null") {

            // validate if the driver is already registered on the tender
            $tenderDriverFilter = [
                ['key' => 'tender_id', 'val' => $waybillBean->tender_id],
                ['key' => 'nn', 'val' => $driver_nn],
                ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']
            ];
            $tenderDriverResult = $this->_tenderDriverCore->searchTenderDriver($tenderDriverFilter, 1, 0, 0);

            if ($tenderDriverResult->found_rows == 0) {

                // get the tenderBean
                $man = $this->_tenderCore->getTenderManifest($waybillBean->tender_id, 0);

                // if adding driver to tender is set to be auto , add the driver
                if ($man['tender_driver']['allow_add_by_system'] == true) {

                    $driverFilter = [['key' => 'nn', 'val' => $driver_nn], ['key' => 'status', 'val' => 'ACTIVE']];
                    $driver_qry = $this->_driverCore->searchDriver($driverFilter, 1, 0, 0);
                    $driver_id = $driver_qry->data[0]->id;
                    if (!$driver_id) {
                        throw new Exception("لا تستطيع المتابعة، معلومات السائق غير صحيحة");
                    }
                    $tender_driver_id = $this->_tenderDriverCore->create($driver_id, $waybillBean->tender_id, 0);
                    $this->_tenderDriverCore->activateTenderDriver($tender_driver_id, 0);

                    $tenderDriverFilter = [
                        ['key' => 'tender_id', 'val' => $waybillBean->tender_id],
                        ['key' => 'driver_id', 'val' => $driver_id],
                        ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']
                    ];
                    $tenderDriverResult = $this->_tenderDriverCore->searchTenderDriver($tenderDriverFilter, 1, 0, 0);
                } else {
                    // else throw error
                    throw new Exception("السائق لا يملك عقد تشغيل فعال على المشروع");
                }
            } else {
                // make sure the driver is not black listed
                if ($tenderDriverResult->data[0]->status == "PENDING") {
                    throw new Exception("لا تستطيع المتابعة ، عقد تشغيل السائق موقوف على المشروع");
                }
            }

            // update driver part
            $driverFilter = [
                ['key' => 'nn', 'val' => $driver_nn],
                ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']
            ];
            $driverResult = $this->_driverCore->searchDriver($driverFilter, 1, 0, 0);
            $driver_id = $driverResult->data[0]->id;
            $driver_nn = $driverResult->data[0]->nn;
            $driver_name = $driverResult->data[0]->name;
            $driver_phone = $driverResult->data[0]->phone;
        }

        // trailer
        $trnSearchFilter = [
            ['key' => 'tn', 'val' => $trn],
            ['key' => 'cat', 'val' => ['TRAIL', 'TRAIL-HALF'], 'op' => "in"],
            ['key' => 'status', 'val' => 'ACTIVE']
        ];
        $trailerResult = $this->_truckCore->searchTrucks($trnSearchFilter, 1, 0, 0);
        $trailerBean = $trailerResult->data[0];
        if (!$trailerBean)
            throw new Exception("لا تستطيع المتابعة ، رقم المقظورة غير صحيح");
        $trailer_id = $trailerBean->id;

        try {
            DBConnection::startTransaction();

            // update trn and driver
            $waybillBean->trailer_id = $trailer_id;
            $waybillBean->driver_id = $driver_id;

            // update first trip info
            $waybillJson = $waybillBean->document;
            $waybillJson->first_trip = new stdClass();
            $waybillJson->first_trip->ct = $first_trip_ct;
            $waybillJson->first_trip->destination = $first_trip_destination_id;
            $waybillJson->first_trip->type = $first_trip_type;
            $waybillJson->first_trip->entry_location = $entry_location;
            $waybillBean->document = $waybillJson;
            $this->_waybillCore->updateWaybill($waybillBean, $waybillBean->id, 0);

            if ($truck_route_id) {
                // change the destination of the waybill
                $truck_route = $this->_truckRoutingCore->getTruckRouteBasic($waybillBean->order_id, $truck_route_id, $_SESSION['user_id']);
                if ($truck_route->destination_id) {
                    $this->_waybillCore->changeRoute($waybill_id, $truck_route->destination_id, $_SESSION['user_id']);
                }
                $this->_truckRoutingCore->closeCompletedTruckRoute($waybillBean->order_id, $_SESSION['user_id']);

                // write truck route id in waybill document
                $waybillBean = $this->_waybillCore->getWaybillBasic($waybillBean->id, $_SESSION['user_id']);
                $integeration_details = $waybillBean->document->integeration_details;
                $u_id = DBConnection::getUserIdFromSession($_SESSION['user_id']);
                if (!$integeration_details) {
                    $integeration_details = new stdClass();
                    $integeration_details->truck_route = new stdClass();
                    $integeration_details->truck_route->id = $truck_route_id;
                    $integeration_details->truck_route->done_by = $u_id;
                    $integeration_details->truck_route->update_date = DBConnection::getSystemDate();
                    $waybillBean->document->integeration_details = $integeration_details;
                } else {
                    $waybillBean->document->integeration_details->truck_route = new stdClass();
                    $waybillBean->document->integeration_details->truck_route->id = $truck_route_id;
                    $waybillBean->document->integeration_details->truck_route->done_by = $u_id;
                    $waybillBean->document->integeration_details->truck_route->update_date = DBConnection::getSystemDate();
                }
                $this->_waybillCore->updateWaybill($waybillBean, $waybillBean->id, $_SESSION['user_id']);
            }

            // change status of waybill to approved
            $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);
            $this->_waybillCore->changeStatus($waybill_id, "APPROVED", $_SESSION['user_id']);

            // activate the waybill
            $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);
            $this->_waybillCore->changeStatus($waybill_id, 'ACTIVE', $_SESSION['user_id']);

            //add truck to Itihad Queue if not exists
            if ($waybillBean->tender_id == 3) {

                // add indivisual to yard 2 , and companies to 3
                $tenderCompanyCore = new TenderCompanyCore();
                $service_list = $tenderCompanyCore->getTenderCompanyServices($waybillBean->trucking_company_id, $waybillBean->tender_id);
                $has_queue_service = false;
                if ($service_list) {
                    foreach ($service_list as $service) {
                        if ($service->code == 'DISPATCH' && isset($service->type) && $service->type == 'QUEUE') {
                            $has_queue_service = true;
                        }
                    }
                }
                if ($has_queue_service) {
                    $itihad_queue_for_vessels = 2;
                } else {
                    $itihad_queue_for_vessels = 3;
                }

                $this->_queueCore->pushTruckToYard(
                    $waybillBean->tender_id,
                    $itihad_queue_for_vessels,
                    $waybillBean->truck_id,
                    $waybillBean->trailer_id,
                    $waybillBean->driver_id,
                    $waybillBean->id
                );
            }

            if ($waybillBean->tender_id == 13) {
                $itihad_queue_for_grains = 5;
                $this->_queueCore->pushTruckToYard(
                    $waybillBean->tender_id,
                    $itihad_queue_for_grains,
                    $waybillBean->truck_id,
                    $waybillBean->trailer_id,
                    $waybillBean->driver_id,
                    $waybillBean->id
                );
            }


            DBConnection::commitTransaction();


            try {
                // check if the route wage is defined for the cargo_id and origin and destination
                $routeWageFilter = [
                    ['key' => 'destination_id', 'val' => $waybillBean->destination_id],
                    ['key' => 'tender_id', 'val' => $waybillBean->tender_id],
                    ['key' => 'cargo_id', 'val' => $waybillBean->document->cargo[0]->cargo_id],
                    ['key' => 'start_date', 'val' =>  $waybillBean->create_date, 'op' => 'less than'],
                    ['key' => 'end_date', 'val' =>  $waybillBean->create_date, 'op' => 'greater than'],
                    ['key' => 'status', 'val' => 'ACTIVE']
                ];
                $routeWageInfo = $this->_routeWageCore->searchRouteWage($routeWageFilter, 1, 0, 0);

                // if the route wage is not found
                if ($routeWageInfo->found_rows == 0) {

                    // check if there is already a ticket for the given input, so dont create
                    $filter = [];
                    $filter['data->body->tender_id'] = $waybillBean->tender_id;
                    $filter['data->body->destination_id'] = $waybillBean->destination_id;
                    $filter['data->body->cargo_id'] = $waybillBean->document->cargo[0]->cargo_id;
                    $filter['type_code'] = 'ADD_ROUTE_WAGE';
                    $filter['status'] = "NEW";
                    $tickets = $this->_customerCare->searchTickets($filter, 1, 1000, null);

                    // else  create new ticket of type ADD_ROUTE_WAGE
                    if (sizeof($tickets['data']) == 0) {
                        $ticket = new stdClass();
                        $ticket->title = "انشاء تسعيرة";
                        $ticket->senderName = "مدارج للخدمات اللوجستية";
                        $ticket->type_code = "ADD_ROUTE_WAGE";
                        $ticket->priority = 3;
                        $ticket->company_id = 266770;
                        $ticket->type = "OBJECT";
                        $ticket->body = [
                            "cargo_id" => $waybillBean->document->cargo[0]->cargo_id,
                            "cargo_name" => $waybillBean->document->cargo[0]->name,
                            "destination_id" => $waybillBean->destination_id,
                            "destination_name" => $waybillBean->document->negotiable_instructios->route->destination->name,
                            "origin_id" => $waybillBean->origin_id,
                            "origin_name" => $waybillBean->document->negotiable_instructios->route->origin->name,
                            "tender_id" => $waybillBean->tender_id,
                            "tender_name" => $waybillBean->document->tender->name
                        ];
                        $this->_customerCare->createTicket($ticket);
                    }
                }
            } catch (Exception $e) {
                throw new Exception($e->getMessage());
            }

            //return Success response
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "تمت العملية بنجاح";
            $Result['waybill_id'] =  $waybillBean->id;
            $Result['wn'] =  $waybillBean->wn;
            parent::response($Result, 200);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }

    // ---------------------------------------------------------------------------------------------------- //
    // -------------------- Search waybills by ticket id  ------------------------------------------------- //
    // ---------------------------------------------------------------------------------------------------- //
    public function searchTicketWaybill()
    {
        $ticketId = $this->_request->ticket_id;
        if (!$ticketId) {
            throw new Exception("ticket_id is required");
        }
        $filters = [
            ["key" => "document", "val" => $ticketId, 'op' => 'json unquote', 'node' => '$.integeration_details.ticket.ticket_id'],
            ["key" => "status", "op" => "not in", "val" => ["REVOKED", "INACTIVE"]]
        ];
        $waybills =  $this->_waybillCore->searchWaybills($filters, 1000, 0, 0);
        parent::response($waybills);
    }

    // ---------------------------------------------------------------------------------------------------- //
    // -------------------- validate if there is vaporization paper  ------------------------------------------ //
    // ---------------------------------------------------------------------------------------------------- //

    public function validatVaporizationPaper()
    {
        try {
            // get waybill bean
            $waybill_id = $this->_request->waybill_id;
            $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);
            $waybill_cargo_id = $waybillBean->document->cargo[0]->cargo_id;
            $truck_id = $waybillBean->truck_id;

            // query to get last two waybills for the truck
            $lastWaybillFilter = [
                ['key' => 'tender_id', 'val' => $waybillBean->tender_id],
                ['key' => 'truck_id', 'val' => $truck_id],
                ['key' => 'status', 'val' => ['CLOSED', 'COMPLETE'], 'op' => 'in']
            ];
            $last_waybill = $this->_waybillCore->searchWaybills($lastWaybillFilter, 1, 0, $_SESSION['user_id'], ' order by id desc ');

            // if there is no previous trip no need for paper
            if ($last_waybill->found_rows == 0) {
                parent::response(null);
            } else {
                $result_cargo_id = json_decode($last_waybill->data[0]->document)->cargo[0]->cargo_id;
                // chaeck if last trip cargo is the same or different
                if ($result_cargo_id != $waybill_cargo_id) {
                    parent::response(true);
                } else {
                    parent::response(null);
                }
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------------------------------------------------- //
    // -------------------update weight in closed waybill ----------------------------------------- //
    // -------------------------------------------------------------------------------------------- //
    public function updateClosedWaybillWeight()
    {

        $id = $this->_request->id;
        $loading_weight = $this->_request->loading_weight;
        $loading_date = $this->_request->loading_date;
        $discharge_weight = $this->_request->discharge_weight;
        $discharge_date = $this->_request->discharge_date;
        $gross_weight = $this->_request->gross_weight;
        $waybillBean = $this->_waybillCore->getWaybillBasic($id, 0);

        // start to work on the cargoJSON node
        $cargoJSON = $waybillBean->document->cargo[0];

        // update discharge_weight in document
        if ($cargoJSON->weights->discharge && $discharge_weight) {
            $cargoJSON->weights->discharge->net_weight = $discharge_weight;
        }
        // update discharge_date in document
        if ($cargoJSON->weights->discharge && $discharge_date) {
            $cargoJSON->weights->discharge->time_stamp = $discharge_date;
        }
        // update loading_date in document
        if ($cargoJSON->weights->loading && $loading_date) {
            $cargoJSON->weights->loading->time_stamp = $loading_date;
        }
        // update loading_weight in document
        if ($cargoJSON->weights->loading && $loading_weight) {
            $cargoJSON->weights->loading->net_weight = $loading_weight;
        }
        // update gross_loading_weight in document
        if ($cargoJSON->weights->loading && $gross_weight) {
            $cargoJSON->weights->loading->gross_weight->weight = $gross_weight;
        }


        $waybillBean->document->cargo[0] = $cargoJSON;
        DBConnection::updateDB("waybill", $waybillBean, 0);
    }


    // -------------------------------------------------------------------------------------------- //
    // -------------------undo cancleation of waybill -------------------------------------------- //
    // -------------------------------------------------------------------------------------------- //
    public function undoCancelWaybill()
    {

        $id = $this->_request->id;
        $waybillBean = $this->_waybillCore->getWaybill($id, $_SESSION['user_id']);
        $waybillBean = json_decode($waybillBean);
        $note = $this->_request->note;

        // validate auth
        $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
        $can_edit = false;
        foreach ($userRolesArray as $role) {
            if ($role == 'OPERATION_MANAGER') {
                $can_edit = true;
                break;
            }
        }
        if (!$can_edit) {
            throw new Exception('لا تستطيع المتابعة ، لا يوجد لديك صلاحية كافية');
        }

        $changeStatusIsDone = false;
        if ($waybillBean->activity) {
            foreach ($waybillBean->activity as $activity) {
                if ($activity->action_code == 'CHANGE_STATUS' && ($activity->object_new_status_code == 'REVOKED' || $activity->object_new_status_code == 'INACTIVE')) {
                    $revoke_time = strtotime($activity->activity_date);
                    $now = strtotime(DBConnection::getSystemDate());
                    // if the waybill canceled before more than two hours
                    if ($now - $revoke_time > 7200) {
                        throw new Exception('لا يمكن القيام بهذه العملية بعد مضي أكثر من ساعتين على عملية الإلغاء');
                    }

                    // active waybill and change status to last status before cancelation
                    $previous_waybill_status = $activity->object_status_code;
                    $this->_waybillCore->changeStatus($id, $previous_waybill_status, $_SESSION['user_id']);

                    // add remarks
                    $addNoteCore = new Add_notes_core();
                    $addNoteCore->addNotes('waybill', $id, $note, $_SESSION['user_id']);
                    $this->_waybillCore->logActivity($id, "اعادة تفعيل المستند", $note, "update", $_SESSION['user_id']);

                    $changeStatusIsDone = true;
                }
            }
        }

        if ($changeStatusIsDone) {
            $wn = $waybillBean->wn;
            $Result['MESSAGE'] = " تم إعادة تفعيل المستند رقم $wn";
            $Result['CODE'] = " تم إعادة تفعيل المستند رقم $wn";
        } else {
            $Result['MESSAGE'] = "لا يمكن اعادة تفعيل المستند ، الرجاء مراجعة العمليات";
            $Result['MESSAGE'] = "لا يمكن اعادة تفعيل المستند ، الرجاء مراجعة العمليات";
        }


        parent::response($Result);
    }



    // ---------------------------------------------------------------------------- //
    // ------------------ Update the serial in waybill queue node ----------------- //
    // ---------------------------------------------------------------------------- //
    public function updateWaybillSerial()
    {

        // get input params
        $id = $this->_request->id;
        $serial = $this->_request->serial;
        $new_serial = $this->_request->new_serial;

        // get waybill bean
        $waybillBean = $this->_waybillCore->getWaybillBasic($id, $_SESSION['user_id']);

        // validate auth
        $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
        $can_edit = false;
        foreach ($userRolesArray as $role) {
            if ($role == 'OPERATION_MANAGER') {
                $can_edit = true;
                break;
            }
        }
        if (!$can_edit) {
            throw new Exception('لا تستطيع المتابعة ، لا يوجد لديك صلاحية كافية');
        }

        // update serial in document
        $integeration_details = $waybillBean->document->integeration_details;
        $integeration_details->queue->serial = $serial;
        $integeration_details->queue->new_serial = $new_serial;

        $waybillBean->document->integeration_details = $integeration_details;
        $this->_waybillCore->updateWaybill($waybillBean, $waybillBean->id, $_SESSION['user_id']);

        $Result['MESSAGE'] = " تمت العملية بنجاح ";
        $Result['CODE'] = " تمت العملية بنجاح ";
        parent::response($Result);
    }



    // -------------------------------------------------------------------------------------------- //
    // -------------------undo cancleation of waybill -------------------------------------------- //
    // -------------------------------------------------------------------------------------------- //
    public function reactivateClosedWaybill()
    {
        try {
            $id = $this->_request->id;
            $note = $this->_request->note;
            if (!$id || !$note) {
                throw new Exception("waybill_id and note is required ");
            }
            // validate auth
            $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
            $can_edit = false;
            foreach ($userRolesArray as $role) {
                if ($role == 'OPERATION_MANAGER') {
                    $can_edit = true;
                    break;
                }
            }
            if (!$can_edit) {
                throw new Exception('لا تستطيع المتابعة ، لا يوجد لديك صلاحية كافية');
            }

            $changeStatusIsDone = false;
            $waybillBean = $this->_waybillCore->getWaybill($id, $_SESSION['user_id']);
            $waybillBean = json_decode($waybillBean);
            if ($waybillBean->activity) {
                foreach ($waybillBean->activity as $activity) {
                    if ($activity->action_code == 'CHANGE_STATUS' && ($activity->object_new_status_code == 'CLOSED' || $activity->object_new_status_code == 'INACTIVE' || $activity->object_new_status_code == 'REVOKLED')) {
                        // active waybill and change status to last status before cancelation
                        $previous_waybill_status = $activity->object_status_code;
                        $this->_waybillCore->changeStatus($id, $previous_waybill_status, $_SESSION['user_id']);
                        // add remarks
                        $addNoteCore = new Add_notes_core();
                        $addNoteCore->addNotes('waybill', $id, $note, $_SESSION['user_id']);
                        $this->_waybillCore->logActivity($id, "اعادة تفعيل المستند", $note, "update", $_SESSION['user_id']);

                        $changeStatusIsDone = true;
                    }
                }
            }

            if ($changeStatusIsDone) {
                $wn = $waybillBean->wn;
                $Result['MESSAGE'] = " تمت إعادة تفعيل المستند رقم $wn";
                $Result['CODE'] = " تمت إعادة تفعيل المستند رقم $wn";
            } else {
                $Result['MESSAGE'] = "لا يمكن اعادة تفعيل المستند ، الرجاء مراجعة العمليات";
                $Result['MESSAGE'] = "لا يمكن اعادة تفعيل المستند ، الرجاء مراجعة العمليات";
            }

            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------------------------- //
    // ----------------------------- Get Diesel log ---------------------------------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function getDieselLog()
    {
        if (!$this->_request->tn)
            throw new Exception('Truck Number is required!');
        $tn = $this->_request->tn;

        $jppmc = new JPPMC();
        $jppmc->fetchDieselLog();
        $log = $jppmc->searchDieselLog($tn);

        parent::response($log);
    }

    // ------------------------------------------------------------------------------------------- //
    // ----------------------------- Get SERVICES LIST ---------------------------------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function getServiceList()
    {
        // get user params
        $tender_id = $this->_request->tender_id;
        $waybill_id = $this->_request->waybill_id;

        // get all services for a certain tender
        $filter = [];
        $filter[] = ["key" => "tender_id", "val" => $tender_id];
        $tenderServices = $this->_waybillCore->searchWaybillServices($filter, 100, 0, $_SESSION['user_id']);

        $result = [];
        // filter the services based on waybill filter if exist
        foreach ($tenderServices->data as $service) {
            $filter = $service->filter;
            if (gettype($filter) == "string" && $filter == '["*"]') {
                $result[] = $service;
            } else {
                // in this case, the service is available when the filter is matched
                $filter = json_decode($filter);
                if ($waybill_id) {
                    $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, 0);
                    $truckBean = $this->_truckCore->getTruckBasic($waybillBean->truck_id, 0);

                    foreach ($filter as $key => $value) {
                        if ($truckBean->$key == $value) {
                            $result[] = $service;
                        }
                    }
                }
            }
        }

        parent::response($result);
    }




    // ------------------------------------------------------------------- //
    // ------------------ Create Grains Waybill API --------------------- //
    // ------------------------------------------------------------------- //
    public function addServiceToWaybill()
    {

        try {

            DBConnection::startTransaction();

            $waybill_id = $this->_request->waybill_id;
            $service_id = $this->_request->service_id;
            $account_id = $this->_request->account_id;
            $service_payment_method = $this->_request->service_payment_method;
            $res = $this->updateWaybillService($waybill_id, $service_id, $account_id, $service_payment_method);

            DBConnection::commitTransaction();

            // return response
            $result = [];
            $result['ERRORCODE'] = "0";
            $result['ID'] = $res["ID"];
            $result['VOUCHER_ID'] = $res["VOUCHER_ID"];
            $result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
            parent::response($result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }


    private function updateWaybillTenderShift($waybill_id, $tender_shift_id)
    {

        $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, 0);
        $waybillBean->document->order->shift_id = $tender_shift_id;
        $this->_waybillCore->updateWaybill($waybillBean, $waybillBean->id, $_SESSION['user_id']);
    }

    private function updateWaybillService($waybill_id, $service_id, $account_id, $service_payment_method)
    {

        try {

            // prepare the needed data
            if (!$service_id) {
                throw new Exception("الرجاء اختيار الخدمة المراد اضافتها");
            }

            // get Waybill
            $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, 0);
            $doc =  $waybillBean->document;

            // get Service
            $serviceBean = $this->_waybillCore->getService($service_id, $_SESSION['user_id']);
            if (!$serviceBean) {
                throw new Exception("الخدمة المراد اضافتها على المستند غير موجودة على النظام");
            }
            $service_name = $serviceBean->caption;;

            // the following section if the receipt services
            if ($serviceBean->voucher_type == 'receipt') {

                // prepare the from and to account for the voucher
                $payment_account = $account_id;

                if ($serviceBean->trx_template) {
                    foreach ($serviceBean->trx_template as $temp) {
                        if ($temp->code == $service_payment_method) {
                            $PaymentFlag = $temp->add_payment;
                            $voucherFlag = $temp->add_voucher;
                            $target_account = $temp->template->AP->value[0];
                            if (!$target_account) {
                                $target_account = $temp->template->AR->value[0];
                            }
                            break;
                        }
                    }
                }
                if (!$target_account) {
                    throw new Exception("INVALID target_account");
                }

                // get service price
                $value = new stdClass();
                if (intval($serviceBean->price) == "*") {
                    if (!$this->_request->price) {
                        throw new Exception("الرجاء التاكد من ادخال مبلغ صحيح");
                    }
                    $value->amount = $this->_request->price;
                } else {
                    $value->amount = $serviceBean->price;
                }

                // create voucher
                if ($voucherFlag) {

                    // prepare voucher bean
                    $value = new stdClass();
                    $value->amount = $serviceBean->price;
                    $PaymentNode = (object) array(
                        "name" => $serviceBean->voucher_type,
                        "label" => " سند قبض بدل " . $service_name,
                        "target_account" => $target_account,
                        "time_stamp" => DBConnection::getSystemDate(),
                        "value" => $value,
                        "service_id" => $service_id
                    );


                    $tn = $doc->carrier[0]->truck->tn;
                    $remarks =  "سند قبض بدل خدمة $service_name - للشاحنة $tn - المستند $waybillBean->wn ";
                    $voucher_id = $this->_voucherCore->createVoucher(
                        $payment_account,                                   // from_account
                        $target_account,                                    // target_account
                        $serviceBean->price,                                // amount
                        $service_payment_method,                            // payment_method
                        $PaymentNode,                                       // payment
                        null,                                               // due_date
                        $PaymentNode->name,                                 // ref_code
                        $waybill_id,                                        // ref_id
                        $remarks,                                           // remarks
                        $waybillBean->tender_id,                            // tender_id
                        "payment_voucher",                                  // print template
                        $_SESSION['user_id']                                // user_id
                    );
                };


                // add the payment to payment section in json
                if ($PaymentFlag) {
                    $payment = new stdClass();
                    $payment->name = "ADEL_DEBIT";
                    $payment->label = "قيد ذمة على المستند بدل اضافة خدمة " . $serviceBean->caption;
                    $payment->value = new stdClass();
                    $payment->value->amount = $serviceBean->price;
                    $payment->time_stamp = DBConnection::getSystemDate();
                    $payment->payment_method = $service_payment_method;
                    $this->_waybillCore->addWaybillPaymentNode($waybillBean->id, $payment);

                    // update advance payment
                    $waybillBeanPayment = $this->_waybillCore->getWaybillBasic($waybill_id, 0);
                    $Totla_advance_payment = $waybillBeanPayment->document->freight->amount->total_advance_paymen;
                    $Totla_advance_payment = $Totla_advance_payment + $serviceBean->price;
                    $waybillBeanPayment->document->freight->amount->total_advance_payment = $Totla_advance_payment;
                    $this->_waybillCore->updateWaybill($waybillBeanPayment, $waybillBean->id, $_SESSION['user_id']);
                }
            } else if ($serviceBean->voucher_type == 'payable') {

                // create voucher for this payment
                if ($waybillBean->tender_id == 12) {
                    $payment_account = $account_id; //حساب الفيول;
                    $target_account = "590000-50008"; // حساب الفيول;
                }

                $value = new stdClass();
                if (intval($serviceBean->price) == -1) {
                    if (!$this->_request->price) {
                        throw new Exception("الرجاء التاكد من ادخال مبلغ صحيح");
                    }
                    $value->amount = $this->_request->price;
                } else {
                    $value->amount = $serviceBean->price;
                }
                $PaymentNode = (object) array(
                    "name" => "PAYABLE_VOUCHER",
                    "label" => "أمر صرف عن $service_name",
                    "target_account" => $target_account,
                    "time_stamp" => DBConnection::getSystemDate(),
                    "value" => $value,
                    "service_id" => $service_id
                );


                $tn = $doc->carrier[0]->truck->tn;
                $driverName = $doc->carrier[0]->driver->name;
                $remarks =  "أمر صرف عن  $service_name - للشاحنة $tn - المستند $waybillBean->wn - السائق $driverName ";
                $voucher_id = $this->_voucherCore->createVoucher(
                    $payment_account,
                    $target_account,
                    $serviceBean->price,
                    "CASH",
                    $PaymentNode,
                    null,
                    'PAYABLE_VOUCHER',
                    $waybill_id,
                    $remarks,
                    $waybillBean->tender_id,
                    "payment_voucher",
                    $_SESSION['user_id']
                );
            } else {
                // add this payment as advance payment on waybill
                if ($serviceBean->name == "permit_fees") {
                    $payment = [];
                    $payment['name'] = $serviceBean->name;
                    if (intval($serviceBean->price) == -1) {
                        if (!$this->_request->price) {
                            throw new Exception("الرجاء التاكد من ادخال مبلغ صحيح");
                        } else {
                            $payment['amount'] = $this->_request->price;
                        }
                    } else {
                        $payment['amount'] = $serviceBean->price;
                    }
                    $this->_waybillCore->addAdvancePayment($waybillBean, $payment);
                }
            }


            // get fresh copy of waybill
            $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, 0);
            $doc =  $waybillBean->document;

            $service_node = new stdClass();
            $service_node->service_id = $service_id;
            $service_node->service_name = $serviceBean->caption;
            if (intval($serviceBean->price) == -1) {
                if (!$this->_request->price) {
                    throw new Exception("الرجاء التاكد من ادخال مبلغ صحيح");
                } else {
                    $service_node->service_price = $this->_request->price;
                }
            } else {
                $service_node->service_price = $serviceBean->price;
            }

            $service_node->payment_method = $service_payment_method;

            if ($voucher_id) {
                $service_node->service_voucher_id = $voucher_id;
            }
            $service_node->update_by = $_SESSION['u_id'];
            $service_node->update_date = DBConnection::getSystemDate();
            if ($doc->service_list) {
                $doc->service_list[] =  $service_node;
            } else {
                $doc->service_list = [$service_node];
            }
            $waybillBean->document = $doc;
            $this->_waybillCore->updateWaybill($waybillBean, $waybillBean->id, $_SESSION['user_id']);


            // // write trx if exist
            // $jv_trx_service_note = " بدل خدمة " . $serviceBean->caption . " على المستند رقم " . $waybillBean->wn;
            // if ($serviceBean->trx_template) {
            //     $serviceTemplat = json_decode(json_encode($serviceBean->trx_template[0]->template), true);
            //     if (intval($serviceBean->price) == -1) {
            //         if (!$this->_request->price) {
            //             throw new Exception("الرجاء التاكد من ادخال مبلغ صحيح");
            //         } else {
            //             $service_price = $this->_request->price;
            //         }
            //     } else {
            //         $service_price = $serviceBean->price;
            //     }
            //     $jv_trx = [];
            //     foreach ($serviceTemplat as $trans) {
            //         $jv_trx[] = array(
            //             "account" => $trans["value"][0],
            //             "amount" => $service_price,
            //             "op" => $trans["op"],
            //             "notes" => $jv_trx_service_note
            //         );
            //     }
            //     $jv_date = DBConnection::getSystemDate();
            //     $jv_service_account = explode("-", $jv_trx[0]["account"])[0];
            //     $jv_id = $this->_paymentCore->addJV($jv_service_account, $jv_date, $jv_trx, $jv_trx_service_note, 0);
            // }

            // return response
            $result = [];
            $result['ERRORCODE'] = "0";
            $result['ID'] = $waybill_id;
            if ($voucherFlag) {
                $result['VOUCHER_ID'] = $voucher_id;
            }
            $result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
            return $result;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }
    // ------------------------------------------------------------------------------------------- //
    // ----------------------------- Get status of certain driver on Jo Petrol System ------------ //
    // ------------------------------------------------------------------------------------------- //
    public function getDriverStatus()
    {

        $nn = $this->_request->nn;

        $jo_petrol_integration = new Jo_Petrol();
        $jo_petrol_driver = $jo_petrol_integration->QueryOnDriverStatus($nn);

        parent::response($jo_petrol_driver);
    }


    // --------------------------------------------------------------------------------------------- //
    // ------------------- Cancel a service for certain waybill ------------------------------------ //
    // --------------------------------------------------------------------------------------------- //
    public function cancelService()
    {

        // get user param
        $waybill_id = $this->_request->waybill_id;
        $service_voucher_id = $this->_request->service_voucher_id;

        // validate auth
        $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
        $allow = false;
        foreach ($userRolesArray as $role) {
            if ($role == 'OPERATION_MANAGER' || $role == 'OPERATION_SUPERVISOR_AQ') {
                $allow = true;
                break;
            }
        }
        if (!$allow) {
            throw new Exception("لا تستطيع المتابعة ، الرجاء مراجعة مدير العمليات");
        }

        try {
            DBConnection::startTransaction();
            // get waybill bean
            $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, 0);

            // change status of the service
            $service_list = $waybillBean->document->service_list;
            foreach ($service_list as &$service) {
                if ($service->service_voucher_id == $service_voucher_id) {
                    $service->status = 'INACTIVE';
                    $service_name = $service->service_name;
                    break;
                }
            }
            $this->_waybillCore->updateWaybill($waybillBean, $waybill_id, $_SESSION['user_id']);

            // get the voucher
            $voucher_id = $service->service_voucher_id;


            // change its status
            $revoke_jv_id = $this->_voucherCore->changeStatus($voucher_id, 'REVOKED', 0);

            // add note on waybill
            $this->_request->remarks .= ", jv_id=" . $revoke_jv_id;
            $this->_waybillCore->logActivity($waybill_id, 'الغاء خدمة', 'تم الغاء خدمة ' . $service->service_name .  $this->_request->remarks, "ADD_NOTES", $_SESSION['user_id']);

            DBConnection::commitTransaction();

            // return success message
            $result = [];
            $result['ERRORCODE'] = "0";
            $result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
            parent::response($result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }


    // --------------------------------------------------------------------------------------------- //
    // ------------------- Cancel a service for certain waybill ------------------------------------ //
    // --------------------------------------------------------------------------------------------- //
    public function addExtraAdvPayments()
    {
        try {
            DBConnection::startTransaction();
            $cargoCore = new CargoCore();
            $waybill_id = $this->_request->waybill_id;
            $adv_payments = $this->_request->adv_payments;

            // get waybill
            $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);

            //get cargo
            $cargoBean = $cargoCore->getCargoBasic($waybillBean->document->cargo[0]->cargo_id, 0);

            // adv payments template
            $cargo_adv_template = $cargoBean->waybill_template->negotiable_instructios->freight->advance_payment;
            $available_payments = [];
            foreach ($cargo_adv_template as $temp) {
                $available_payments[] = $temp->name;
            }

            $requested_adv_name = [];
            foreach ($adv_payments as $adv) {
                $requested_adv_name[] = $adv->name;
            }

            // make sure the requested payments on cargo
            foreach ($requested_adv_name as $adv) {
                if (!(array_search($adv, $available_payments) > -1)) {
                    throw new Exception("لا يمكن صرف سلفة غير معرفة على الحمل");
                }
            }


            // get waybill payments
            $waybill_payments = $waybillBean->document->freight->payments;
            foreach ($waybill_payments as $way_payment) {
                if (array_search(strtolower($way_payment->name), $requested_adv_name) > -1) {
                    throw new Exception("لا يمكن صرف السلفة من نوع $way_payment->name مرة أخرى.");
                }
            }

            // create voucher for requested adv payments
            $driverCore = new DriverCore();
            $accountCore = new AccountCore();
            $voucherCore = new VoucherCore();
            foreach ($cargo_adv_template as $temp) {
                if (array_search(strtolower($temp->name), $requested_adv_name) > -1) {

                    $driver_name = $waybillBean->document->carrier[0]->driver->name;
                    $driver_id = $waybillBean->document->carrier[0]->driver->id;
                    $driverBean = $driverCore->getDriverBasic($driver_id, 0);
                    $tn = $waybillBean->document->carrier[0]->truck->tn;
                    $voucherNotes = "بدلات أجور سائق - المستفيد $driver_name - الشاحنة $tn - المستند $waybillBean->wn";
                    $payment_method = $temp->payment_channel;
                    $from_account = "590001,19902";
                    $wallet_id = $temp->wallet_id;

                    foreach ($adv_payments as $adv) {
                        if ($adv->name == strtolower($temp->name)) {
                            if (is_numeric($adv->value) && $adv->value >= 50 && $adv->value <= 70) {
                                if ($temp->payment_channel_commission) {
                                    $voucher_amount = $adv->value - $temp->payment_channel_commission;
                                } else {
                                    $voucher_amount = $adv->value;
                                }
                            } else {
                                throw new Exception("قيمة غير صحيحة, يجب ادخال قيمة بين 50 و 70 دينار");
                            }
                        }
                    }


                    // get target account
                    $searchFilter = [['key' => "user_id", 'val' => $driverBean->user_id]];
                    $account_qry = $accountCore->searchAccount($searchFilter, 1, 0, 0);
                    $target_account = $account_qry->data[0]->id . "," .  $account_qry->data[0]->sub_id;


                    $clientPayment = (object) array(
                        "name" => 'CASH_DOWNPAYMENT',
                        "label" => $voucherNotes,
                        "target_account" => $target_account,
                        "wallet_id" => $wallet_id,
                        "time_stamp" => DBConnection::getSystemDate(),
                        "value" => $voucher_amount
                    );

                    // create Voucher
                    $voucher_id = $voucherCore->createVoucher(
                        $from_account,
                        $target_account,
                        $voucher_amount,
                        strtoupper($payment_method),
                        $clientPayment,
                        null,
                        'WAYBILL_DOWNPAYMENT',
                        $waybillBean->id,
                        $voucherNotes,
                        $waybillBean->tender_id
                    );

                    // add the payment to the waybill
                    $newPayment = new stdClass();
                    $newPayment->label = strtoupper($temp->name);
                    $newPayment->name = strtoupper($temp->name);
                    $newPayment->value = new stdClass();
                    $newPayment->value->amount = $voucher_amount;
                    $newPayment->time_stamp = DBConnection::getSystemDate();
                    $this->_waybillCore->addWaybillPaymentNode($waybillBean->id, $newPayment);

                    // log the activity
                    $this->_waybillCore->logActivity(
                        $waybillBean->id,
                        "صرف بدلات أجور سائق",
                        $voucherNotes . " - أمر صرف رقم $voucher_id",
                        "check",
                        $_SESSION['user_id']
                    );
                }
            }

            DBConnection::commitTransaction();

            $result['MESSAGE'] = "تم عملية الصرف بنجاح";
            $result['voucher_id'] = $voucher_id;
            parent::response($result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }




    // --------------------------------------------------------------------- //
    // ----------------- Get all advance payments to monitor --------------- //
    // --------------------------------------------------------------------- //
    public function monitorAdvancePayment()
    {

        // init objects
        $fps = new FPS();

        // collect all active claims on fps
        $data = new stdClass();
        if ($this->_request->filter)
            $data->filter = $this->_request->filter;

        $claimsReuslt =  $fps->searchActiveClaimReport($data, $_SESSION['user_id']);

        if ($claimsReuslt['found_rows'] == 0) {
            parent::response([]);
            die;
        }

        $truckOwnerCore = new TruckOwnerCore();
        // match waybill to claim
        foreach ($claimsReuslt['data'] as &$claim) {

            $truckOwnerFilter = [['key' => "id", 'val' => $claim['truck_owner_id']]];
            $truckOwnerQuery = $truckOwnerCore->searchTruckOwner($truckOwnerFilter, 1, 0, $_SESSION['user_id']);
            $claim['name'] = $truckOwnerQuery->data[0]->name;
            $claim['time_lapsed'] = 0;
        }

        parent::response($claimsReuslt['data']);
    }


    public function getWaybillWithDownpaymentVouchers()
    {
        // init objects
        $fps = new FPS();
        $jo_petrol_integration = new Jo_Petrol();

        // collect all active claims on fps
        $filterObj = new stdClass();
        $filterObj->filter = new stdClass();
        $filterObj->filter->status = "ACTIVE";
        $filterObj->filter->payee_reference_code = "TN";

        $filterObj->limit = 10000;
        $claimsReuslt =  $fps->searchClaims($filterObj, $_SESSION['user_id']);

        $dataResult = [];
        $tns = [];

        // loop on claims , if the claim is waybill claim, then collect the tn for later compare, and if its a queue claim collect tn to show for user
        foreach ($claimsReuslt['data'] as $claim) {

            $claimDetailsd = json_decode($claim['claim_details']);

            // colloct tn for waybill claims
            $tn = $claimDetailsd->tn;
            $tns[] = $tn;
        }

        // search for CLOSED Waybills , then active waybills
        $waybillFilter = [
            ['key' => 'tn', 'val' => $tns, 'op' => 'in'],
            ['key' => 'tender_id', 'val' => ["11"], 'op' => 'in'],
            ['key' => 'status', 'val' => ['CLOSED'], 'op' => 'in']
        ];
        $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter, 1000, 0, $_SESSION['user_id'], ' order by discharge_date ');
        $waybills_1 = $waybillResult->data;
        $waybillFilter = [
            ['key' => 'tn', 'val' => $tns, 'op' => 'in'],
            ['key' => 'tender_id', 'val' => ["11"], 'op' => 'in'],
            ['key' => 'status', 'val' => ['ACTIVE', 'ONROAD'], 'op' => 'in']
        ];
        $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter, 1000, 0, $_SESSION['user_id'], ' order by id  ');
        $waybills_2 = $waybillResult->data;
        $waybills = array_merge($waybills_1, $waybills_2);

        //search for JO Petrol waybill (status 6)
        $jo_petrol_waybills_6 = $jo_petrol_integration->fetchWaybills(6);
        // loop on Minagate Waybills and match them with Jo petrol waybills
        foreach ($waybills as &$waybill) {
            $waybill->jp_correct_status = true;
            if ($waybill->status == 'CLOSED') {
                $waybill->jp_correct_status = false;
                foreach ($jo_petrol_waybills_6['data'] as $jp_waybill) {
                    if ($jp_waybill['nf55doco'] == $waybill->id) {
                        $waybill->jp_correct_status = true;
                    }
                }
            }
        }

        // loop on waybills to give them levels of danger
        foreach ($waybills as $waybillBean) {

            $monitorObj = [];
            $monitorObj['id'] = $waybillBean->id;
            $monitorObj['wn'] = $waybillBean->wn;
            $monitorObj['status'] = $waybillBean->status;
            $monitorObj['tn'] = $waybillBean->tn;
            $monitorObj['phone'] = json_decode($waybillBean->document)->carrier[0]->driver->phone;
            $monitorObj['name'] = json_decode($waybillBean->document)->carrier[0]->driver->name;
            $monitorObj['discharge_date'] = $waybillBean->discharge_date;
            $monitorObj['current_date'] = DBConnection::getSystemDate();
            if ($waybillBean->status == "CLOSED") {
                $timeFirst  = date_create($monitorObj['discharge_date']);
                $timeSecond = date_create($monitorObj['current_date']);
                $diff = date_diff($timeFirst, $timeSecond);
                $time_lapsed = "";
                if ($diff->d > 0) $time_lapsed = $diff->d . " يوم ";
                $monitorObj['time_lapsed'] = $time_lapsed .  str_pad($diff->h, 2, "0", STR_PAD_LEFT) . ":" . str_pad($diff->i, 2, "0", STR_PAD_LEFT);
            }
            if ($waybillBean->status == "ACTIVE") {
                $monitorObj['warning_color'] = "light grey";
            } else if ($waybillBean->status == "ONROAD") {
                $monitorObj['warning_color'] = "grey";
            } else if ($waybillBean->jp_correct_status) {
                $monitorObj['warning_color'] = "#FFCC00"; // orange
            } else if (!$waybillBean->jp_correct_status) {
                $monitorObj['warning_color'] = "red";
            }
            $dataResult[$waybillBean->tn] = $monitorObj;
        }

        // append the claims that has not been in waybills yet
        foreach ($claimsReuslt['data'] as $claim) {

            $claimDetailsd = json_decode($claim['claim_details']);

            // append result to final result
            if ($claimDetailsd->queue_id) {

                // get queue info
                $queueSearchFilter = [['key' => 'id', 'val' => $claimDetailsd->queue_id]];
                $queueTruckResult = $this->_queueCore->searchQueue($queueSearchFilter, 1, 0, 0);

                $queueInfo = $queueTruckResult->data[0];
                $monitorObj = [];
                $monitorObj['id'] = $queueInfo->id;
                $monitorObj['tn'] = $claimDetailsd->tn;
                $monitorObj['claim_amount'] = $claim['claim_amount'];
                $monitorObj['phone'] = $queueInfo->driver_phone ? $queueInfo->driver_phone : "-";
                $monitorObj['name'] = $queueInfo->driver_name ? $queueInfo->driver_name : "-";

                // add the item only if its not already in the list
                if (!in_array($claimDetailsd->tn, array_keys($dataResult))) {
                    $dataResult[$claimDetailsd->tn] = $monitorObj;
                }
            }
        }


        parent::response(array_values($dataResult));
    }


    public function get_waybill_info_for_terminal()
    {

        $tn =  $this->_request->tn;

        $result = new stdClass();
        if ($tn == "2396929" || $tn == "96929") {
            $result->WAYBILL_ACTIVE_STATUS = true;
            $result->trn = "700001";
            $result->driverName = "محمد أحمد علي";
            $result->driverImage = "https://t4.ftcdn.net/jpg/02/45/56/35/360_F_245563558_XH9Pe5LJI2kr7VQuzQKAjAbz9PAyejG1.jpg";
            $result->cargo = "نفط خام";
        } else {
            $result->WAYBILL_INACTIVE_STATUS = true;
        }
    }


    // --------------------------------------------------------------------------------------------------------------- //
    // ----------------------- Close certain waybill by payment agent, this creates a voucher for pa ----------------- //
    // ----------------------- then store the payment and the weightin the waybill ----------------------------------- //
    // --------------------------------------------------------------------------------------------------------------- //
    public function closeWaybillByPaymentAgent()
    {

        //init
        $fps = new FPS();

        // get user params
        $done_by = $_SESSION['user_id'];

        $pa_id = $_SESSION['pa_id'];
        $recipient_company_id = $_SESSION['company_id'];
        $waybill_id = $this->_request->waybill_id;
        $origin_id = $this->_request->origin_id;
        $destination_id = $this->_request->destination_id;
        $discharge_weight = $this->_request->discharge_weight;
        $loading_weight = $this->_request->loading_weight;
        $loading_date = $this->_request->loading_date;
        $discharge_date = $this->_request->discharge_date;
        $cash_value =  $this->_request->cash_value;
        $cargo_id =  $this->_request->cargo_id;

        // get waybill
        $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $done_by);

        // fill stamps for tamween
        if ($waybillBean->document->tender->id == 13) {
            $ministry_stamp =  $this->_request->ministry_stamp;
            $change_destination_stamp =  $this->_request->change_destination_stamp;
            $silo_stamp =  $this->_request->silo_stamp;

            $waybillBean->document->stamps = new stdClass();
            $waybillBean->document->stamps->ministry_stamp = $ministry_stamp;
            $waybillBean->document->stamps->change_destination_stamp = $change_destination_stamp;
            $waybillBean->document->stamps->silo_stamp = $silo_stamp;
        }

        // validate if the waybill has been payed before
        if ($waybillBean->document->has_full_payment == true) {
            throw new Exception("لا تستطيع المتابعة ، تم دفع مستحقات المستند مسبقا");
        }

        $tn = $waybillBean->document->carrier[0]->truck->tn;;
        $recipient_account_id = "590000-" . $tn;
        $tender_id = $waybillBean->tender_id;
        $notes = "أمر صرف مستحقات المستند رقم " . $waybillBean->wn . " للشاحنة رقم " . $tn;
        if (!$cargo_id) {
            $cargo_id = $waybillBean->document->cargo[0]->cargo_id;
        }

        // calculate voucher amount
        $routeWage =  $this->_routeWageCore->searchWageForFreight(
            $tender_id,
            $origin_id,
            $destination_id,
            $cargo_id,
            $loading_date,
            'payable',
            true,
            $waybillBean,
            $_SESSION['pa_id']
        );

        $waybillBean->document->negotiable_instructios = new stdClass();
        $waybillBean->document->negotiable_instructios->route = new stdClass();
        $waybillBean->document->negotiable_instructios->route->destination = new stdClass();
        $waybillBean->document->negotiable_instructios->route->destination->id = $destination_id;
        $waybillBean->document->negotiable_instructios->route->destination->name = getLocationName($destination_id);
        $pa_id = null;
        if (isset($_SESSION['pa_id']) && $_SESSION['pa_id']) {
            $pa_id = $_SESSION['pa_id'];
        }
        $frieght = $this->_paymentCore->calculateFreight($waybillBean, $discharge_weight, $loading_weight, $routeWage, null, $pa_id);
        $voucher_amount = $frieght->amount->net_amount;
        if (!$cash_value) $cash_value = $voucher_amount;

        // validate maximum value
        if ($cash_value > $voucher_amount) {
            throw new Exception(" قيمة المبلغ النقدي أكبر من قيمة الوصل " . $voucher_amount);
        }

        // caculate diesel value
        $diesel_value = $voucher_amount - $cash_value;

        // give the user part of the money as diesel
        if ($diesel_value > 0) {

            $payment_method_code = "MG_FUEL";
            $voucher_type = "MG_FUEL";
            $voucher_amount = $diesel_value;
            $voucher1_data = $this->prepareVoucherData(
                $recipient_account_id,
                $tender_id,
                $done_by,
                $pa_id,
                $voucher_type,
                $voucher_amount,
                $notes,
                $recipient_company_id,
                $waybillBean,
                $origin_id,
                $destination_id,
                $loading_weight,
                $loading_date,
                $discharge_weight,
                $discharge_date,
                $payment_method_code
            );

            unset($voucher1_data->integration_details);

            // save this amount as advance payment
            $newPayment = new stdClass();
            $newPayment->label = "سلفة ديزل";
            $newPayment->name = "WATANIAH_DEISIL_PRE_LOAD";
            $newPayment->value = new stdClass();
            $newPayment->value->amount = $voucher_amount;
            $newPayment->time_stamp = DBConnection::getSystemDate();
            $this->_waybillCore->addWaybillPaymentNode($waybillBean->id, $newPayment);
        }

        // the cash part
        $payment_method_code = "CASH";
        $voucher_type = "WAYBILL_COMPLETE";
        $voucher_amount = $cash_value;
        $voucher2_data = $this->prepareVoucherData(
            $recipient_account_id,
            $tender_id,
            $done_by,
            $pa_id,
            $voucher_type,
            $voucher_amount,
            $notes,
            $recipient_company_id,
            $waybillBean,
            $origin_id,
            $destination_id,
            $loading_weight,
            $loading_date,
            $discharge_weight,
            $discharge_date,
            $payment_method_code
        );

        $voucher2_data->route_wage_type = $routeWage->route_wage_type;
        $voucher2_data->route_wage_id = $routeWage->id;
        $voucher2_data->waybill_id = $waybillBean->id;

        // create voucher
        $fields = new stdClass();
        $fields->voucher1_data = $voucher1_data;
        $fields->voucher2_data = $voucher2_data;

        //search for active claims for the owner, and store its value in waybilll as adv payment
        // if ($waybillBean->document->freight->amount->total_advance_payment > 0) {
        $mgPay_tender_id = $this->_tenderCore->getMgPayTender()->id;
        $tenderFilter = [
            ['key' => 'tn', 'val' => $waybillBean->document->carrier[0]->truck->tn],
            ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in'],
            ['key' => 'tender_id', 'val' => $mgPay_tender_id]
        ];
        $tenderTruck_qry = $this->_tenderCore->searchTenderTruck($tenderFilter, 1, 0, 0);
        $tenderTruckBean = $tenderTruck_qry->data[0];
        $financial_details = $tenderTruckBean->financial_details;
        $financial_details = json_decode($financial_details);
        $truck_owner_id = $financial_details->truck_owner->id;

        if ($truck_owner_id) {
            $request = new stdClass();
            $request->filter = new stdClass();
            $request->filter->status_in = ["ACTIVE"];
            $request->filter->payee_reference_value = $truck_owner_id;
            $request->filter->payee_reference_code = "TRUCK_OWNER";
            $claimsReuslt = $fps->searchClaims($request, 0);
            if ($claimsReuslt['found_rows'] > 0) {

                $claimAmount = 0;
                foreach ($claimsReuslt['data'] as $claim) {
                    $claimAmount +=  $fps->getClaimRemainingAmount($claim['id'], 0);
                }

                $advPaymentValue = $claimAmount;
                // if the net_amount + advance_payment is less than claim_amount, make partial payment
                if ($frieght->amount->net_amount + $frieght->amount->total_advance_payment < $claimAmount) {
                    $advPaymentValue = $frieght->amount->net_amount;
                }

                $newPayment = new stdClass();
                $newPayment->label = "سلفة ديزل";
                $newPayment->name = "WATANIAH_DEISIL_PRE_LOAD";
                $newPayment->value = new stdClass();
                $newPayment->value->amount = $advPaymentValue;
                $newPayment->time_stamp = DBConnection::getSystemDate();
                $this->_waybillCore->addWaybillPaymentNode($waybillBean->id, $newPayment);
            }
        }

        $voucher_ids = $fps->closeWaybillByPaymentAgent($fields, $done_by);

        // TODO save tagreesh
        // $this->_waybillCore->saveTagreeshData($waybillBean, $_SESSION['user_id'], $_SESSION['pa_id']);

        // get fresh copy
        $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $done_by);

        // save flag in waybill to lock it from being complete again
        $waybillBean->document->has_full_payment = true;
        $this->_waybillCore->updateWaybill($waybillBean, $waybillBean->id, 0);

        // add new payment to truck claim in case it has
        $fps_claim_core = new Fps_claim_core();
        $payment_amount = $advPaymentValue;
        if ($payment_amount && $payment_amount > 0 && $truck_owner_id) {
            $fps_claim_core->addPaymentToTruckOwnerClaim($payment_amount, $truck_owner_id, "سداد قيمة السلفة من رحلة المستند رقم " . $waybillBean->wn, 0);
        }

        // change status of waybill to complete
        $this->_waybillCore->completeWaybillByMerchanht($waybillBean->id, $_SESSION['pa_id'], $cash_value, 0);

        // create trx to finish the payment cycle
        if ($payment_amount > 0 && $truck_owner_id) {
            $MGPAY_tender_id = $this->_tenderCore->getMgPayTender()->id;
            $tender_bean = $this->_tenderCore->getTenderBasic($MGPAY_tender_id, 0);
            $account_ledger_id = $tender_bean->manifest->account_ledger_id;
            $accountFilter = new stdClass();
            $accountFilter->filter = ["id" => $account_ledger_id, "truck_owner_id" => $truck_owner_id];
            $accountFilter->filter = json_encode($accountFilter->filter);
            $owner_account_qry =  $this->_fps->searchAccount($accountFilter, 0);
            $generateFpsVoucherTrxData = new stdClass();
            $generateFpsVoucherTrxData->net_amount = $payment_amount;
            $generateFpsVoucherTrxData->truck_owner_account =  $owner_account_qry['data'][0]['id'] . "-" .  $owner_account_qry['data'][0]['sub_id'];
            $generateFpsVoucherTrxData->debit_note = "سداد قيمة السلفة من رحلة المستند رقم " . $waybillBean->wn;

            $template_id = 4;   //4= سداد السلفة
            $jv_trx_2 = $this->_fpsVoucherCore->generateFpsVoucherTrx(
                $template_id,
                $generateFpsVoucherTrxData,
                $recipient_company_id,
                "سداد قيمة السلفة من رحلة المستند رقم " . $waybillBean->wn,
                true
            );
            $data = new stdClass();
            $data->ledger_account_id = $account_ledger_id;
            $data->jv_date = DBConnection::getSystemDate();
            $data->remarks = "سداد قيمة السلفة من رحلة المستند رقم " . $waybillBean->wn;
            $data->trx = $jv_trx_2;
            $fps->createTrx($data, 0);
        }

        $result = [];
        $result["message"] = "تمت العملية بنجاح";
        if ($voucher_ids['voucher1_id'] && $voucher_ids['voucher2_id']) {
            $result["voucher_id"] = [$voucher_ids['voucher1_id'], $voucher_ids['voucher2_id']];
        } else  if ($voucher_ids['voucher1_id']) {
            $result["voucher_id"] = [$voucher_ids['voucher1_id']];
        } else  if ($voucher_ids['voucher2_id']) {
            $result["voucher_id"] = [$voucher_ids['voucher2_id']];
        }

        parent::response($result);
    }



    private function prepareVoucherData(
        $recipient_account_id,
        $tender_id,
        $done_by,
        $pa_id,
        $voucher_type,
        $voucher_amount,
        $notes,
        $recipient_company_id,
        $waybillBean,
        $origin_id,
        $destination_id,
        $loading_weight,
        $loading_date,
        $discharge_weight,
        $discharge_date,
        $payment_method_code,
        $claim_id = null
    ) {

        $fpsVoucherCore = new Fps_voucher_core();
        $target_company_id = $_SESSION['company_id'];

        if ($voucher_amount == 0) {
            $voucher_amount = 0.001;
        }

        //----------- Create Voucher of type waybill_complete
        $voucherBasicInfo = $fpsVoucherCore->generateMGPayVoucherBasicInfo($recipient_account_id, $tender_id, $done_by);
        $voucherTrxInfo = $fpsVoucherCore->generateMGPayVoucherTrxTemplate($tender_id, $pa_id, $voucher_type, $voucher_amount, $notes, $target_company_id, $done_by);
        $auth = $fpsVoucherCore->generateMGPayVoucherAuthorityInfo($voucherTrxInfo['trx_template'], null, $recipient_company_id, $done_by);

        // generate vouhcer integration info
        $integerationDetails = new stdClass();
        $integerationDetails->waybill_id = $waybillBean->id;
        $integerationDetails->amount = $voucher_amount;
        $integerationDetails->origin_id = $origin_id;
        $integerationDetails->destination_id = $destination_id;
        $integerationDetails->loading_weight = $loading_weight;
        $integerationDetails->loading_date = $loading_date;
        $integerationDetails->discharge_weight = $discharge_weight;
        $integerationDetails->discharge_date = $discharge_date;
        $integerationDetails->claim_id = $claim_id;
        $integerationInfo = $fpsVoucherCore->generateVoucherIntegrationInfo($voucher_type, $integerationDetails, $done_by);

        // combinbe all into voucher data
        $voucher_data = new stdClass();
        $voucher_data->authority = $auth['authority'];
        $voucher_data->voucher_destination = [$auth['destination']];
        $voucher_data->jv_template = $voucherTrxInfo;
        $voucher_data->amount = $voucher_amount;
        $voucher_data->payment_method_code = $payment_method_code;
        $voucher_data->recipient_name = "";
        $voucher_data->tn = $voucherBasicInfo->tn;
        $voucher_data->pa_id = $pa_id;
        $voucher_data->recipient_user_id = null;
        $voucher_data->recipient_nn = null;
        $voucher_data->integration_details = $integerationInfo;

        return $voucher_data;
    }

    // --------------------------------------------------------------------------------------------------------------- //
    // ----------------------- Update weights in waybill and add new payment in document ----------------------------- //
    // --------------------------------------------------------------------------------------------------------------- //
    public function saveWaybillMissingArgs()
    {

        $params = $this->_request->params;
        $waybill_id = $params->waybill_id;

        // get waybill bean
        $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);
        $cargoBean = $waybillBean->document->cargo[0];
        $cargoBean->weights->loading->net_weight = $params->loading_weight;
        $cargoBean->weights->loading->time_stamp = $params->loading_date;
        $cargoBean->weights->discharge->net_weight = $params->discharge_weight;
        $cargoBean->weights->discharge->time_stamp = $params->discharge_date;

        // todo: change route id it is changed
        $waybillBean->document->negotiable_instructios->route->origin->id = $params->origin_id;
        $waybillBean->document->negotiable_instructios->route->origin->name = getLocationName($params->origin_id);
        $waybillBean->document->negotiable_instructios->route->destination->id = $params->destination_id;
        $waybillBean->document->negotiable_instructios->route->destination->name = getLocationName($params->destination_id);

        // update the weight in the bean
        $waybillBean->document->cargo[0] = $cargoBean;
        $this->_waybillCore->updateWeight($waybillBean, $_SESSION['user_id']);

        // save tagreesh
        $this->_waybillCore->saveTagreeshData($waybillBean, $_SESSION['user_id'], $_SESSION['pa_id']);

        // add remarks
        $this->_waybillCore->logActivity(
            $waybillBean->id,
            "تثبيت معلومات التقريش",
            "",
            "ADD_NOTES",
            $_SESSION['u_id']
        );

        parent::response("success");
    }

    // --------------------------------------------------------------------------------------------------------------- //
    // ----------------------- Update weights in waybill and add new payment in document ----------------------------- //
    // --------------------------------------------------------------------------------------------------------------- //
    public function addWaybillCompleteData()
    {

        $params = $this->_request->params;
        $waybill_id = $params->waybill_id;

        if ($_SESSION['user_name'] == "FPS System" || $_SESSION['integration_token']) {
            // allow
        } else {
            throw new Exception("No Authority");
        }

        // get waybill bean
        $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);

        $cargoBean = $waybillBean->document->cargo[0];

        // fill waybill with loading/discharge info
        if (!$cargoBean->weights) $cargoBean->weights = new stdClass();
        if (!$cargoBean->weights->loading) $cargoBean->weights->loading = new stdClass();
        $cargoBean->weights->loading->net_weight = $params->loading_weight;
        $cargoBean->weights->loading->time_stamp = $params->loading_date;
        $cargoBean->weights->discharge->net_weight = $params->discharge_weight;
        $cargoBean->weights->discharge->time_stamp = $params->discharge_date;

        // todo: change route id it is changed
        if (!$waybillBean->document->negotiable_instructios) $waybillBean->document->negotiable_instructios = new stdClass();
        if (!$waybillBean->document->negotiable_instructios->route) $waybillBean->document->negotiable_instructios->route = new stdClass();
        if (!$waybillBean->document->negotiable_instructios->route->origin) $waybillBean->document->negotiable_instructios->route->origin = new stdClass();
        if (!$waybillBean->document->negotiable_instructios->route->destination) $waybillBean->document->negotiable_instructios->route->destination = new stdClass();

        $waybillBean->document->negotiable_instructios->route->origin->id = $params->origin_id;
        $waybillBean->document->negotiable_instructios->route->origin->name = getLocationName($params->origin_id);
        $waybillBean->document->negotiable_instructios->route->destination->id = $params->destination_id;
        $waybillBean->document->negotiable_instructios->route->destination->name = getLocationName($params->destination_id);

        // update the weight in the bean
        $waybillBean->document->cargo[0] = $cargoBean;
        $this->_waybillCore->updateWeight($waybillBean, 0);

        // save tagreesh
        // $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);
        // $this->_waybillCore->saveTagreeshData($waybillBean, 0 ,$_SESSION['pa_id']);

        parent::response("success");
    }
    private function tamweenTemplateForMerchant()
    {
        return '[{"title":"معلومات التحميل ","component":[{"key":"loading_weight","label":"وزن التحميل","value":"_$_loading_weight_$_","call_back_api":null,"type":"int","mandatory":true,"reg_exp":"[0-9]","min_value":5,"max_value":99999},{"key":"origin_id","label":"موقع التحميل ","value":"_$_origin_id_$_","type":"list","lookup_name":"origin_ids","mandatory":true,"reg_exp":"[*]","call_back_api":null,"min_value":null,"max_value":null},{"key":"loading_timestamp","label":"تاريخ التحميل","value":"_$_loading_timestamp_$_","type":"date_time","call_back_api":null,"mandatory":true,"reg_exp":"[*]","min_value":"2021-01-01 00:00:00","max_value":null},{"key":"cargo_id","label":"نوع الحمولة  ","value":"_$_cargo_id_$_","type":"list","call_back_api":null,"lookup_name":"cargo_ids","mandatory":true,"reg_exp":"[*]","min_value":null,"max_value":null},{"key":"policy_num","label":"رقم البوليصة","value":"","type":"int","mandatory":false,"reg_exp":"[*]","min_value":null,"max_value":null}]},{"title":"معلومات الوصول ","component":[{"key":"arrival_timestamp","label":"تاريخ الوصول","value":"_$_arrival_timestamp_$_","type":"date_time","call_back_api":null,"mandatory":true,"reg_exp":"[*]","min_value":"2021-01-01 00:00:00","max_value":null}]},{"title":"معلومات التفريغ","component":[{"key":"discharge_weight","label":"وزن التفريغ","call_back_api":null,"type":"int_with_steps","step_value":10,"value":"_$_discharge_weight_$_","mandatory":true,"reg_exp":"[*]","min_value":1,"max_value":99999},{"key":"destination_id","label":"موقع التفريغ","value":"_$_destination_id_$_","type":"list","call_back_api":null,"lookup_name":"distenation_ids","mandatory":true,"reg_exp":"[*]","min_value":null,"max_value":null},{"key":"discharge_timestamp","label":"تاريخ التفريغ","value":"_$_discharge_timestamp_$_","type":"date_time","call_back_api":null,"mandatory":true,"reg_exp":"[*]","min_value":"2021-01-01 00:00:00","max_value":null}]},{"title":"أختام الغرامات","call_back_api":null,"component":[{"key":"ministry_stamp","label":"  ختم الأشغال","value":"","type":"list","call_back_api":null,"lookup_name":"stamp_values","mandatory":true,"reg_exp":"[*]","min_value":null,"max_value":null},{"key":"change_destination_stamp","label":"  ختم تغيير وجهة","value":"","type":"list","call_back_api":null,"lookup_name":"stamp_values","mandatory":true,"reg_exp":"[*]","min_value":null,"max_value":null},{"key":"silo_stamp","label":"  ختم مخزون","value":"","type":"list","call_back_api":null,"lookup_name":"stamp_values","mandatory":false,"reg_exp":"[*]","min_value":null,"max_value":null}]}]';
    }
    private function vesselsTemplateForMerchant()
    {
        return '[{"title":"معلومات التحميل ","call_back_api":null,"component":[{"key":"loading_weight","label":"وزن التحميل","value":"_$_loading_weight_$_","type":"int","mandatory":true,"reg_exp":"[0-9]","min_value":5,"max_value":99999},{"key":"loading_timestamp","label":"تاريخ التحميل","value":"_$_loading_timestamp_$_","type":"date_time","mandatory":true,"reg_exp":"[*]","min_value":"2021-01-01 00:00:00","max_value":null}]},{"title":"معلومات التفريغ","call_back_api":null,"component":[{"key":"discharge_weight","label":"وزن التفريغ","type":"int_with_steps","step_value":10,"value":"_$_discharge_weight_$_","mandatory":true,"reg_exp":"[*]","min_value":1,"max_value":99999},{"key":"discharge_timestamp","label":"تاريخ التفريغ","value":"_$_discharge_timestamp_$_","type":"date_time","mandatory":true,"reg_exp":"[*]","min_value":"2021-01-01 00:00:00","max_value":null}]},{"title":"معلومات الحمولة","call_back_api":null,"component":[{"key":"destination_id","label":"موقع التفريغ","value":"_$_destination_id_$_","type":"list","lookup_name":"distenation_ids","mandatory":true,"reg_exp":"[*]","min_value":null,"max_value":null},{"key":"origin_id","label":"موقع التحميل ","value":"_$_origin_id_$_","type":"list","lookup_name":"origin_ids","mandatory":true,"reg_exp":"[*]","min_value":null,"max_value":null},{"key":"cargo_id","label":"نوع الحمولة  ","value":"_$_cargo_id_$_","type":"list","lookup_name":"cargo_ids","mandatory":true,"reg_exp":"[*]","min_value":null,"max_value":null}]}]';
    }


    public function getMissingTagreshArgs()
    {
        try {
            $waybillDraft = new waybillDraftCore();
            $waybillBean = $this->_waybillCore->getWaybillBasic($this->_request->id, $_SESSION['user_id']);

            if ($waybillBean->id != '') {
                $waybill_object = new stdClass();

                $obj = [];
                $obj['_$_loading_timestamp_$_'] = $waybillBean->loading_date
                    ? $waybillBean->loading_date :
                    date('Y-m-d h:i:00', strtotime($waybillBean->create_date . "+1 days"));

                $obj['_$_loading_weight_$_'] = $waybillBean->document->cargo[0]->weights->loading->net_weight;
                $obj['_$_discharge_timestamp_$_'] = $waybillBean->discharge_date
                    ? $waybillBean->discharge_date : date('Y-m-d h:i:00', strtotime($obj['_$_loading_timestamp_$_'] . "+1 days"));
                $obj['_$_discharge_weight_$_'] = $waybillBean->document->cargo[0]->weights->discharge->net_weight;

                if ($obj['_$_discharge_weight_$_'] == "" || !$obj['_$_discharge_weight_$_']) {
                    $obj['_$_discharge_weight_$_'] = $waybillBean->document->cargo[0]->weights->loading->net_weight;
                }
                $obj['_$_cargo_id_$_'] = $waybillBean->document->cargo[0]->cargo->id;
                $obj['_$_destination_id_$_'] = $waybillBean->destination_id;
                $obj['_$_origin_id_$_'] = $waybillBean->origin_id;

                if ($waybillBean->tender_id == 13) { //تموين
                    $obj['_$_arrival_timestamp_$_'] = $waybillBean->discharge_date
                        ?  $waybillBean->discharge_date : date('Y-m-d h:i:00', strtotime($obj['_$_loading_timestamp_$_'] . "+1 days"));
                    // other Missing_requirments
                    $obj['_$_late_fine_$_'] = '0';
                    $obj['_$_loss_fine_$_'] = '0';
                    $obj['_$_compensation_$_'] = '';
                    $obj['_$_destination_wage_differance_$_'] = '';

                    $txt = $this->tamweenTemplateForMerchant();
                } else if ($waybillBean->tender_id == 12) { //فيول
                    // loading Missing_requirments
                    $obj['_$_gross_weight_$_'] = $waybillBean->document->cargo[0]->weights->loading->gross_weight->weight;
                    // other Missing_requirments
                    $obj['_$_late_fine_$_'] = '';
                    $obj['_$_gross_weight_fine_$_'] = '';
                    $obj['_$_tips_$_'] = '';
                } else if ($waybillBean->tender_id == 3) { //بواخر
                    // other Missing_requirments

                    $obj['_$_late_fine_$_'] = '';
                    $obj['_$_loss_fine_$_'] = '';
                    $obj['_$_compensation_$_'] = '';
                    $obj['_$_destination_wage_differance_$_'] = '';

                    $txt = $this->vesselsTemplateForMerchant();
                } else if ($waybillBean->tender_id == 11) { //نفط
                    // other Missing_requirments
                    $obj['_$_loss_fine_$_'] = '';
                    $obj['_$_tips_$_'] = '';
                } else if ($waybillBean->tender_id == 17 || $waybillBean->tender_id == 19) { //فوسفات داخلي / خارجي
                    // other Missing_requirments
                    $obj['_$_late_fine_$_'] = '';
                    $obj['_$_loss_fine_$_'] = '';
                }
                foreach ($obj as $key => $value) {
                    $txt =  str_replace($key, $value, $txt);
                }
            } else {
                throw new Exception('الرجاء التاكد من رقم المستند');
            }
            $tender_id = $waybillBean->tender_id;
            $origins = $this->_tenderCore->getTenderOrigin($tender_id, $_SESSION['user_id']);
            $origins[] = ["id" => null, "name" => "الرجاء الإختيار"];

            $destinations = $this->_tenderCore->getTenderOriginForMerchant($tender_id, $_SESSION['user_id']);

            $cargoFilter = [
                ["key" => "tender_id", "val" => $tender_id]
            ];

            $cargoResult = $this->_cargoCore->searchCargo($cargoFilter, 100, 0, 0);
            $cargos = [];
            foreach ($cargoResult->data as $value) {
                $carObj = new stdClass();
                $carObj->id = $value->id;
                $carObj->name = $value->name;
                $cargos[] = $carObj;
            }

            $stamp_values = [];
            $stampObject = new stdClass();
            $stampObject->id = null;
            $stampObject->name = "-";
            $stamp_values[] = $stampObject;

            $stampObject = new stdClass();
            $stampObject->id = 1;
            $stampObject->name = "الختم موجود";
            $stamp_values[] = $stampObject;

            $stampObject = new stdClass();
            $stampObject->id = 2;
            $stampObject->name = "الختم غير موجود على المستند";
            $stamp_values[] = $stampObject;


            $data = new stdClass();
            $data->missing_args = json_decode($txt);

            foreach ($data->missing_args  as $missing) {
                foreach ($missing->component  as &$comp) {
                    $comp->is_focus = false;
                    if ($comp->mandatory == true && ($comp->value == "" || !$comp->value)) {
                        $comp->is_focus = true;
                        break;
                    }
                }
            }

            $data->info = new stdClass();
            $data->info->sub_title =  $waybillBean->document->cargo[0]->cargo->name . "  -  " . $waybillBean->document->tender->name;
            $data->info->waybill_id = $waybillBean->id;
            $data->info->title = $waybillBean->document->carrier[0]->truck->tn;

            if ($waybillBean->tender_id == 13) {
                $data->info->final_api_method = "appendWaybillToARClaimForMobile";
                $data->info->final_api_end_point = "tender_claim";
            } else if ($waybillBean->tender_id == 3) {
                $data->info->final_api_method = "appendWaybillToARClaimForMobile";
                $data->info->final_api_end_point = "fps_claim";
            }


            $data->lookups = new stdClass();
            $data->lookups->origin_ids = $origins;
            $data->lookups->distenation_ids = $destinations;
            $data->lookups->cargo_ids = $cargos;
            $data->lookups->stamp_values = $stamp_values;

            parent::response($data);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }



    public function searchinquiry()
    {
        try {

            $val = convertArabicNumbers($this->_request->value); // if value arabic numbers converted to english

            $data = new stdclass();
            $data->filter = new stdClass();
            $data->filter->search_index = $val;
            $data->limit = $this->_request->limit;
            $data->offset = $this->_request->offset;

            $result = $this->_con->searchLandTrip($data, 0);

            $list = [];

            foreach ($result['data'] as  $value) {
                $TempData = new stdClass();

                $TempData->data = new stdClass();
                $TempData->key = $value['id'];
                $item1 = new stdClass();
                $item1->label = $value['cid'];
                $TempData->data->item1 = $item1;

                $item2 = new stdClass();
                $item2->label = json_decode($value["document"])->shipping_line->name;
                $TempData->data->item2 = $item2;

                $item3 = new stdClass();
                $item3->label = json_decode($value["document"])->container->iso;
                $TempData->data->item3 = $item3;

                $item4 = new stdClass();
                $item4->label = json_decode($value["document"])->declaration->ca->name;
                $TempData->data->item4 = $item4;

                $list[] = $TempData;
            }

            parent::response($list);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------------------------------------- //
    // ------------------ After Reading QR code , the user can create new voucher based on QR info ----------- //
    // ------------------------------------------------------------------------------------------------------- //
    public function createVoucherBasedOnQR()
    {
        // read input from params
        $hash_key =  $this->_request->hash_key;
        // search for item and get its value
        $filterObj = new stdClass();
        $filterObj->filter = new stdClass();
        $filterObj->filter->status = "NEW";
        $filterObj->filter->payee_reference_code = "TRUCK_OWNER";
        $filterObj->limit = 10000;
        $fps = new FPS();
        $claimsQry =  $fps->searchMGClaims($filterObj, 0);

        // take the ids and then search for its claim items
        $claim_ids = [];
        foreach ($claimsQry['data'] as $claim) {
            $claim_ids[] = $claim["id"];
        }
        if (sizeOf($claim_ids) == 0) {
            throw new Exception("لا يمكن المتابعة ، رقم أمر الصرف غير صحيح");
        }

        // search for claim_items
        $data = new stdClass();
        $filter = new stdClass();
        $filter->claim_ids_in = $claim_ids;
        $data->filter = $filter;
        $claimItemsQry = $fps->searchClaimItems($data, $_SESSION['user_id']);

        // loop on them and has each id to match it with requested private_key
        foreach ($claimItemsQry['data'] as $claimItem) {
            $hash_claim_item_id = md5($claimItem["id"]);

            // when found , extract the needed info
            $value1 = substr($hash_claim_item_id, 0, 20);
            $value2 = substr($hash_key, 0, 20);
            if ($value1 == $value2) {
                $claimResult = $claimItem;
            }
        }
        $details = json_decode($claimResult['details']);


        // prepare voucher data
        $voucher_amount = $claimResult['approved_amount'];
        $recipient_account_id = "590000-" . $details->truck_owner_id;
        $tender_id = $details->tender_id;
        $done_by = $_SESSION['user_id'];
        $pa_id = $_SESSION['pa_id'];
        $payment_method_code = "MG_FUEL";
        $voucher_type = "MG_FUEL";
        $notes = "سلفة ديزل للشاحنة رقم " . $details->tn;
        $recipient_company_id = $_SESSION['company_id'];
        $waybillBean = null;
        $origin_id = null;
        $destination_id = null;
        $loading_weight = null;
        $loading_date = null;
        $discharge_weight = null;
        $discharge_date = null;
        $claim_id = $claimResult["claim_id"];

        $voucher1_data = $this->prepareVoucherData(
            $recipient_account_id,
            $tender_id,
            $done_by,
            $pa_id,
            $voucher_type,
            $voucher_amount,
            $notes,
            $recipient_company_id,
            $waybillBean,
            $origin_id,
            $destination_id,
            $loading_weight,
            $loading_date,
            $discharge_weight,
            $discharge_date,
            $payment_method_code,
            $claim_id
        );

        $done_by = ""; //$_SESSION['user_id'];

        $data = new stdClass();
        $data->filter  = new stdClass();
        $account_qry = $this->_fps->searchAccount($data, $_SESSION['user_id']);
        $generateFpsVoucherTrxData = new stdClass();
        $generateFpsVoucherTrxData->net_amount = $voucher_amount;
        $generateFpsVoucherTrxData->mg_debit_account = $account_qry['data'][0]['id'];
        $generateFpsVoucherTrxData->src_account = $account_qry['data'][0]['id'] . "-" . $account_qry['data'][0]['sub_id'];
        $template_id = 2;   //2= استلام السلفة
        $jv_trx = $this->_fpsVoucherCore->generateFpsVoucherTrx(
            $template_id,
            $generateFpsVoucherTrxData,
            $recipient_company_id,
            "استلام سلفة الديزل للشاحنة رقم $details->tn",
            true
        );
        $voucher1_data->jv_template['trx_template'] = $jv_trx;
        $tender_bean = $this->_tenderCore->getTenderBasic($details->tender_id, $_SESSION['user_id']);
        $account_ledger_id = $tender_bean->manifest->account_ledger_id;

        // add due_date
        $voucher1_data->allow_days = $details->allow_days;

        // update claim item trx
        $accountFilter = new stdClass();
        $accountFilter->filter = ["id" => $account_ledger_id, "truck_owner_id" => $details->truck_owner_id];
        $accountFilter->filter = json_encode($accountFilter->filter);
        $owner_account_qry =  $this->_fps->searchAccount($accountFilter, 0);
        $generateFpsVoucherTrxData = new stdClass();
        $generateFpsVoucherTrxData->net_amount = $voucher_amount;
        $generateFpsVoucherTrxData->truck_owner_account =  $owner_account_qry['data'][0]['id'] . "-" .  $owner_account_qry['data'][0]['sub_id'];
        $generateFpsVoucherTrxData->debit_note = "تفعيل سلفة الديزل للشاحنة رقم " . $details->tn;

        $template_id = 3;   //3= تفعيل السلفة
        $jv_trx_2 = $this->_fpsVoucherCore->generateFpsVoucherTrx(
            $template_id,
            $generateFpsVoucherTrxData,
            $recipient_company_id,
            "تفعيل سلفة الديزل للشاحنة رقم " . $details->tn,
            true
        );

        $appovedInfo = new stdClass();
        $appovedInfo->claim_item_id = $claimResult['id'];
        $appovedInfo->jv_template = $jv_trx_2;
        $appovedInfo->voucher_id = null;
        $this->_fps->updateClaimItemApprovedInfo($appovedInfo, $_SESSION['user_id']);

        // create and process voucher
        $fields = new stdClass();
        $fields->voucher1_data = $voucher1_data;
        $fields->voucher2_data = null;
        $voucher_ids = $fps->closeWaybillByPaymentAgent($fields, $done_by);

        // update claim item voucher_id
        $appovedInfo = new stdClass();
        $appovedInfo->claim_item_id = $claimResult['id'];
        $appovedInfo->jv_template = $jv_trx_2;
        $appovedInfo->voucher_id = $voucher_ids['voucher1_id'];
        $this->_fps->updateClaimItemApprovedInfo($appovedInfo, $_SESSION['user_id']);

        // send SMS to driver
        $message = "تعبئة ديزل بقيمة " . $voucher_amount . "د سيتم اقتطاع المبلغ بعد التفريغ وتسليم الارسالية";

        parent::response($voucher_ids);
    }

    // ------------------------------------------------------------------------------------------------------- //
    // ------------------ Search for waybills to be rendered on mobile app for payment agents ----------- //
    // ------------------------------------------------------------------------------------------------------- //
    public function searchWaybillByPa()
    {
        $query = $this->_request->query;

        $waybillFilter = [];


        if (substr($query, 0, 2) == "60") {
            $waybillFilter[] = ['key' => 'tn', 'val' => $query];
        } else if (substr($query, 0, 1) == "2" and strlen($query) == 10) {
            $waybillFilter[] = ['key' => 'wn', 'val' => $query];
        }

        $waybillFilter[] = ['key' => 'status', 'val' => ["NEW", "ONROAD", "APPROVED", "ACTIVE", "PENDING", "CLOSED"], 'op' => 'in'];
        $waybillFilter[] = ['key' => 'create_date', 'val' =>  date('Y-m-d', strtotime(DBConnection::getSystemDate() . ' - 5 months')), 'op' => 'date greater than'];

        $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter, 1000, 0, $_SESSION['user_id'], ' order by id  ');

        $list = [];
        foreach ($waybillResult->data as  $value) {
            $doc = json_decode($value->document);

            if ($doc->has_full_payment == true) {
                //continue;
            }

            $response = new stdClass();
            $response->waybill_id = $value->id;
            $response->tender_id = $value->tender_id;

            if ($value->tender_id == 3) {
                $response->background_color = "#c4dfe7";
                $response->font_color = "#000";
            } else {
                $response->background_color = "#b6f0b6";
                $response->font_color = "#000";
            }

            $components = [];
            $item_1 = new stdClass();
            $item_1->label = $value->tn;
            $item_1->value = $value->trn;
            $components[] = $item_1;

            $item_2 = new stdClass();
            $item_2->label = " المستند ";
            $item_2->value = $value->wn;
            $components[] = $item_2;

            $item_3 = new stdClass();
            $item_3->label = $doc->cargo[0]->cargo->name;
            $item_3->value = "";
            $components[] = $item_3;

            $item_4 = new stdClass();
            $item_4->label = $doc->negotiable_instructios->route->destination->name;
            $item_4->value = date('Y-m-d', strtotime($value->create_date));;
            $components[] = $item_4;

            $response->components = $components;

            $list[] = $response;
        }

        $Result = [];
        $result['data'] = $list;
        $result['found_rows'] = sizeOf($list);
        parent::response($result);
    }


    // ------------------------------------------------------- //
    // -------------- Calculate Fright by PA ----------------- //
    // ------------------------------------------------------- //
    public function calculateFreightByPa()
    {
        try {

            $waybill_id = $this->_request->waybill_id;
            $discharge_weight = $this->_request->discharge_weight;
            $loading_weight = $this->_request->loading_weight;
            $loading_date = $this->_request->loading_timestamp;
            $discharge_date = $this->_request->discharge_timestamp;
            $arrival_date = $this->_request->arrival_timestamp;
            $type = "payable";
            $pa_id = $_SESSION['pa_id'];
            $cargo_id = $this->_request->cargo_id;
            $destination_id = $this->_request->destination_id;
            $origin_id = $this->_request->origin_id;

            // curl to waybill input validate
            $pass = $this->_paymentCore->validateCalculateFreightInputs($this->_request);

            if ($pass === "SUCCESS" || $this->_request->override_warning) {
                // curl to payment calculate freight

                $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);

                $routeWage = null;
                $gross_weight = null;
                if ($cargo_id) {
                    $waybillBean->document->cargo[0]->cargo_id = $cargo_id;
                }
                if (!$destination_id) {
                    $destination_id  = $waybillBean->destination_id;
                } else {
                    $waybillBean->document->negotiable_instructios->route->destination->id = $destination_id;
                }
                if (!$origin_id) {
                    $origin_id  = $waybillBean->origin_id;
                } else {
                    $waybillBean->document->negotiable_instructios->route->origin->id = $origin_id;
                }
                $waybillBean->document->cargo[0]->weights->loading->time_stamp = $loading_date;
                $waybillBean->document->cargo[0]->weights->discharge->time_stamp = $discharge_date;
                $waybillBean->document->cargo[0]->weights->arrival = new stdClass();
                $waybillBean->document->cargo[0]->weights->arrival->time_stamp = $arrival_date;

                $routeWage = $this->_routeWageCore->searchWageForFreight($waybillBean->document->tender->id, $origin_id, $destination_id, $cargo_id, $loading_date, $type, true, null);
                $frieght_node = $this->_paymentCore->calculateFreight($waybillBean, $discharge_weight, $loading_weight, $routeWage, $gross_weight, $pa_id);
            }


            $result = new stdClass();
            $result->title = 'تم تقريش المستند حسب المعلومات التالية ';
            $result->component = [];
            $result->net_amount = new stdClass();

            $netAmount = $frieght_node->amount->net_amount;
            $dieselValue = 0;
            $cashValue = round($netAmount - $dieselValue, 3);
            if ($cashValue < 0) $cashValue = 0;

            $result->net_amount->component = [];

            $com1 = new stdClass();
            $com1->key = "cash_value";
            $com1->label = "المبلغ المراد دفعة نقدا";
            $com1->value = $cashValue;
            $com1->isEdit = true;
            $com1->max_value = $netAmount;
            $result->net_amount->component[] = $com1;

            $amount = $frieght_node->amount;

            $temp_object = new stdClass();
            $temp_object->key = 'base_amount';
            $temp_object->label = 'المبلغ المترتب من التفريغ';
            $temp_object->val = $amount->base_amount;
            $result->component[] = $temp_object;

            $temp_object = new stdClass();
            $temp_object->key = 'wage_per_ton';
            $temp_object->label = 'سعر الطن';
            $temp_object->val = $amount->wage_per_ton;
            $result->component[] = $temp_object;

            $temp_object = new stdClass();
            $temp_object->key = 'affected_loss';
            $temp_object->label = 'النقص المغرم';
            $temp_object->val = $amount->affected_loss;
            $result->component[] = $temp_object;

            $temp_object = new stdClass();
            $temp_object->key = 'total_deductions';
            $temp_object->label = 'مجموع الاقتطاعات';
            $temp_object->val = $amount->total_deductions;
            $result->component[] = $temp_object;

            $temp_object = new stdClass();
            $temp_object->key = 'total_advance_payment';
            $temp_object->label = 'ذمة الشاحنة المستحقة';
            $temp_object->val = $amount->total_advance_payment;
            $result->component[] = $temp_object;

            $temp_object = new stdClass();
            $temp_object->key = 'net_amount';
            $temp_object->label = 'صافي المبلغ';
            $temp_object->val = $amount->net_amount;
            $temp_object->is_bold = true;
            $result->component[] = $temp_object;

            $this->response($result);
        } catch (Exception $e) {

            $err = [];
            if (strpos($e->getMessage(), "خطأ في احتساب") !== false || strpos($e->getMessage(), "لا يوجد تسعيرة") !== false) {
                $err["MASSAGE"] = json_decode(explode("Error Processing Request : ", $e->getMessage())[1])->MESSAGE;
            } else {
                $err["MASSAGE"] = "لا تستطيغ المتابعة خطا في احتساب المستحقات, الرجاء التاكد من المعلومات السابقة ثم التقريش مرة اخرى  ";
            }
            throw new Exception($err["MASSAGE"]);
        }
    }

    public function testTagreesh()
    {

        $Result = [];
        $result['message'] = "تمت العملية بنجاح";
        parent::response($result);
    }

    // log discharge report in waybill->document
    public function createDischargeReport()
    {

        $waybill_id = $this->_request->waybill_id;
        $answers = $this->_request->answers;

        end($answers);
        $last_ele_array = key($answers);

        $remarks = $answers[$last_ele_array]['value'];
        $attachments = [];
        foreach ($answers as $answer) {
            if (strpos($answer['value'], "storage.googleapis.com") !== false) {
                $attachments[] = $answer['value'];
            }
        }
        $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);

        // get user basic and get the name and other information
        $user =  $this->_userCore->getUserBasic($_SESSION['u_id'], $_SESSION['user_id']);

        $waybillBean->document->discharge_report = [
            "attachments" => $attachments,
            'user_id' => $_SESSION['u_id'],
            'user_name' => $user->name,
            'date' => DBConnection::getSystemDate(),
            'remarks' => $remarks
        ];

        $this->_waybillCore->updateWaybill($waybillBean, $waybill_id, $_SESSION['user_id']);
        // parent::response($waybillBean);
    }
}


$waybill_interface = new Waybill_interface();
