<?php
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/waybill_core.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/../../core/truck/truck_core.php");
require_once(dirname(__FILE__) . "/../../core/truck_contract/truck_contract_core.php");
require_once(dirname(__FILE__) . "/../../core/truck_owner/truck_owner_core.php");

require_once(dirname(__FILE__) . "/../../core/truck_owner/truck_owner_core.php");
require_once(dirname(__FILE__) . "/../../core/user/user_core.php");
require_once(dirname(__FILE__) . "/../../core/driver/driver_core.php");
require_once(dirname(__FILE__) . "/../../core/tender/tender_core.php");
require_once(dirname(__FILE__) . "/../../core/queue/queue_core.php");
require_once(dirname(__FILE__) . "/../../core/cargo/cargo_core.php");
require_once(dirname(__FILE__) . "/../../core/waybill_order/waybill_order_core.php");
require_once(dirname(__FILE__) . "/../../core/waybill_order/waybill_order_core.php");
require_once(dirname(__FILE__) . "/../../core/truck_routing/truck_routing_core.php");

require_once(dirname(__FILE__) . "/../../core/location/location_core.php");
require_once(dirname(__FILE__) . "/../../core/payment/payment_core.php");
require_once(dirname(__FILE__) . "/../../core/taskQueues/taskQueues_core.php");
require_once(dirname(__FILE__) . "/../../core/notification/notification_core.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/Jo_Petrol.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/mg_tracking.php");



class Waybill_integeratrion extends API
{

    // the request of each call
    private $_request = array();
    private $_waybillCore;
    private $_truckCore;
    private $_truckOwnerCore;
    private $_truckContractCore;
    private $_tenderCore;
    private $_queueCore;
    private $_waybillOrderCore;
    private $_cargoCore;
    private $_userCore;
    private $_driverCore;
    private $_locationCore;
    private $_mg_tracking;
    private $_truckRoutingCore;

    public function __construct()
    {

        // call the super constructur
        $this->_request = parent::__construct();

        session_start();
        if (!isset($_SESSION['user_id'])) {
            throw new Exception('No Session!');
        }

        // init the object
        $this->_waybillCore = new WaybillCore();
        $this->_truckCore = new TruckCore();
        $this->_truckOwnerCore = new TruckOwnerCore();
        $this->_truckContractCore = new TruckContractCore();
        $this->_tenderCore = new TenderCore();
        $this->_queueCore = new QueueCore();
        $this->_waybillOrderCore = new WaybillOrderCore();
        $this->_cargoCore = new CargoCore();
        $this->_userCore = new UserCore();
        $this->_driverCore = new DriverCore();
        $this->_jo_petrol = new Jo_Petrol();
        $this->_mg_tracking = new MG_tracking();
        $this->_locationCore = new LocationCore();
        $this->_truckRoutingCore = new TruckRoutingCore();



        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    private function prepareFilter()
    {
        $waybillFilter = [];

        switch ($_SESSION['company_id']) {

                // Alarabiya Filters
            case '34196':
                if ($this->_request->wn)
                    $tempArr = ['key' => 'wn', 'val' => $this->_request->wn];
                else if ($this->_request->waybill_id)
                    $tempArr = ['key' => 'id', 'val' => $this->_request->waybill_id];
                else
                    throw new Exception("WAYBILL_NUMBER_IS_NOT_PROVIDED");

                array_push($waybillFilter, $tempArr);
                $tempArr = ['key' => 'ca_id', 'val' => '68'];
                array_push($waybillFilter, $tempArr);
                break;

                // Shaaban Filters
            case '900998':
                if ($this->_request->wn) {
                    $tempArr = ['key' => 'wn', 'val' => $this->_request->wn];
                    array_push($waybillFilter, $tempArr);
                }

                // in case user provided a filter
                $filter = $this->_request->filter;
                if ($filter) {
                    $filter = json_decode($this->_request->filter, true);
                    foreach ($filter as $key => $value) {
                        $tempArr = ['key' => $key, 'val' => $value];
                        array_push($waybillFilter, $tempArr);
                    }
                }

                // auto inject cargo_agent_id
                $tempArr = ['key' => 'cargo_agent_id', 'val' => '24'];
                array_push($waybillFilter, $tempArr);
                break;

            default:
                throw new Exception("INVALID_REQUEST");
                break;
        }

        // validate search filter
        if ($waybillFilter == []) {
            throw new Exception("INVALID_SEARCH");
        }

        return $waybillFilter;
    }

    private function prepareCargoFilter()
    {
        $cargoFilterFilter = [];

        switch ($_SESSION['company_id']) {

                // Shaaban Filters
            case '900998':

                $tempArr = ['key' => 'status', 'val' => 'ACTIVE'];
                array_push($cargoFilterFilter, $tempArr);

                // auto inject  agent_id
                $tempArr = ['key' => 'agent_id', 'val' => '24'];
                array_push($cargoFilterFilter, $tempArr);
                break;

            default:
                throw new Exception("INVALID_REQUEST");
                break;
        }

        // validate search filter
        if ($cargoFilterFilter == []) {
            throw new Exception("INVALID_SEARCH");
        }

        return $cargoFilterFilter;
    }

    // ------------------------------------------------------------------------------------------------------ //
    // ------------------ Search for waybills based on server to server integeration ------------------------ //
    // ------------------------------------------------------------------------------------------------------ //
    public function searchWaybills()
    {

        // validate the incoming request
        $this->validateIntegerationRequest();

        //prepare search filter
        $waybillFilter = $this->prepareFilter();

        // search waybill
        $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter, 10000, 0, $_SESSION['user_id']);

        if ($waybillResult->found_rows > 0) {

            // format search result
            $result = $this->formatData($waybillResult);

            // return it
            parent::response($result);
        } else {
            throw new Exception("NO_DATA_FOUND");
        }

        // TODO: create follow up task
    }


    // ------------------------------------------------------------------------------------------------------ //
    // ------------------ update waybill loading and descharge weights alongsie any extra info--------------- //
    // ------------------ param: wn , pod, weighbridge_no, weight_loaded, destination_name ------------------ //
    // ------------------        destination_address -------------------------------------------------------- //
    // ------------------------------------------------------------------------------------------------------ //
    public function updateLoadingWeight()
    {

        // validate the incoming request
        $this->validateIntegerationRequest();

        // search for waybill bean
        $waybillFilter = $this->prepareFilter();

        $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter, 1, 0, $_SESSION['user_id']);

        if ($waybillResult->found_rows == 0)
            throw new Exception("NO_DATA_FOUND");
        $waybillBean = $this->_waybillCore->getWaybillBasic($waybillResult->data[0]->id, $_SESSION['user_id']);


        // prepare the cargo bean
        $doc = json_decode($waybillResult->data[0]->document);
        $cargoBean = $doc->cargo[0];

        $waybill_id = $waybillBean->id;

        // Loading request
        if ($this->_request->weight_loaded) {
            try {
                DBConnection::startTransaction();

                // in case the truck is ACTIVE , change its status to PENDING (وصول موقع التحميل)
                if ($waybillBean->status == 'ACTIVE') {
                    $this->_waybillCore->changeStatus($waybill_id, 'PENDING', $_SESSION['user_id']);

                    // log the activity
                    $this->_waybillCore->logActivity(
                        $waybill_id,
                        " وصول موقع التحميل - ربط الكتروني بواسطة " . $_SESSION['u_id'],
                        "",
                        "CARGO_ORIGIN_ENTER",
                        0
                    );
                }


                if (intval($this->_request->weight_loaded) < 999) {
                    $this->_request->weight_loaded = $this->_request->weight_loaded * 1000;
                }

                // get a fresh copy
                $waybillBean = $this->_waybillCore->getWaybillBasic($waybillResult->data[0]->id, $_SESSION['user_id']);

                $cargoBean->weights->loading->net_weight = $this->_request->weight_loaded;
                $cargoBean->weights->loading->time_stamp = DBConnection::getSystemDate();

                // update the weight in the bean
                $waybillBean->document->cargo[0] = $cargoBean;
                $this->_waybillCore->updateWeight($waybillBean, $_SESSION['user_id']);

                // log the activity
                $this->_waybillCore->logActivity(
                    $waybill_id,
                    "تحميل - ربط الكتروني بواسطة " . $_SESSION['u_id'],
                    "وزن التحميل : " . $this->_request->weight_loaded . " كغم ",
                    "LOAD_CARGO",
                    0
                );
                // get a fresh copy
                $waybillBean = $this->_waybillCore->getWaybillBasic($waybillResult->data[0]->id, $_SESSION['user_id']);

                // save the extra info from other integeration side
                $existing_integration_details = $waybillBean->document->integeration_details;
                if ($existing_integration_details) {
                    $waybillBean->document->integeration_details = $existing_integration_details;
                    $waybillBean->document->integeration_details->ca = new stdClass();
                } else {
                    $waybillBean->document->integeration_details = new stdClass();
                    $waybillBean->document->integeration_details->ca = new stdClass();
                }

                $waybillBean->document->integeration_details->ca->pod = $this->_request->pod;
                $waybillBean->document->integeration_details->ca->weighbridge_no = $this->_request->weighbridge_no;
                $waybillBean->document->integeration_details->ca->destination_name = $this->_request->destination_name;
                $waybillBean->document->integeration_details->ca->destination_address = $this->_request->destination_address;
                $waybillBean->document->integeration_details->ca->weight_unit = $this->_request->unit;

                $this->_waybillCore->updateWaybill($waybillBean, $waybill_id, 0);

                // change waybill status
                $this->_waybillCore->changeStatus($waybill_id, 'ONROAD', $_SESSION['user_id']);

                $taskQueuesCore = new TaskQueuesCore();
                $taskQueuesCore->createCloseWaybillTask($waybill_id, 12, "اغلاق المستند بسبب مرور 12 ساعة على التحميل");

                DBConnection::commitTransaction();
            } catch (Exception $e) {
                DBConnection::rollBackTransaction();
                $socialCore = new SocialCore();
                $socialCore->informSupervisor('خطأ في الربط الألكتروني مع العربية', $e->getMessage(), $e->getMessage(), 2);

                throw new Exception("CANT_COMPLETE_YOUR_REQUEST." . $e->getMessage());
            }
        } else {
            throw new Exception("INVALID_REQUEST.weight_loaded_not_defined");
        }

        // return response
        $result = [];
        $result['ERRORCODE'] = "0";
        $result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
        parent::response($result);
    }

    // ------------------------------------------------------------------------------------------------------ //
    // ------------------ update waybill loading and descharge weights alongsie any extra info--------------- //
    // ------------------ param: waybill_id , pod, weighbridge_no, destination_name ------------------------- //
    // ------------------        destination_address, received, weight_received ----------------------------- //
    // ------------------------------------------------------------------------------------------------------ //
    public function updateDischargeWeight()
    {

        // validate the incoming request
        $this->validateIntegerationRequest();

        // search for waybill bean
        $waybillFilter = $this->prepareFilter();
        $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter, 1, 0, $_SESSION['user_id']);

        if ($waybillResult->found_rows == 0)
            throw new Exception("NO_DATA_FOUND");
        $waybillBean = $this->_waybillCore->getWaybillBasic($waybillResult->data[0]->id, $_SESSION['user_id']);

        // prepare the cargo bean
        $doc = json_decode($waybillResult->data[0]->document);
        $cargoBean = $doc->cargo[0];

        $waybill_id = $waybillBean->id;

        // discharge request
        if ($this->_request->received && $this->_request->weight_received) {
            try {
                //DBConnection::startTransaction();

                // in case the truck is ONROAD , change its status to ARRIVED (وصول موقع التفريغ)
                if ($waybillBean->status == 'ONROAD') {
                    $this->_waybillCore->changeStatus($waybill_id, 'ARRIVED', $_SESSION['user_id']);
                }

                $this->_waybillCore->logActivity(
                    $waybill_id,
                    "وصول موقع التفريغ - ربط الكتروني بواسطة " . $_SESSION['u_id'],
                    "الموقع : " . $this->_request->destination_name,
                    "CARGO_DESTINATION_ENTER",
                    0
                );

                if ($this->_request->unit && strtoupper($this->_request->unit) == "KGS") {
                    $this->_request->weight_received = $this->_request->weight_received;
                } else {
                    // format it to be in kg
                    $this->_request->weight_received = $this->_request->weight_received * 1000;
                }

                $cargoBean->weights->discharge->net_weight = $this->_request->weight_received;
                $cargoBean->weights->discharge->time_stamp = DBConnection::getSystemDate();

                // update the weight in the bean
                $waybillBean->document->cargo[0] = $cargoBean;
                $this->_waybillCore->updateWeight($waybillBean, $_SESSION['user_id']);

                $this->_waybillCore->logActivity(
                    $waybill_id,
                    "تفريغ",
                    "تفريغ - ربط الكتروني بواسطة " . $_SESSION['u_id'] . " وزن التفريغ : " . $this->_request->weight_received . " كغم ",
                    "DISCHARGE_CARGO",
                    0
                );

                // save the waybill payment info + extra info from other integeration side
                $waybillBean->document->integeration_details = new stdClass();
                $waybillBean->document->integeration_details->ca = new stdClass();
                $waybillBean->document->integeration_details->ca->POD = $this->_request->POD;
                $waybillBean->document->integeration_details->ca->weighbridge_no = $this->_request->weighbridge_no;
                $waybillBean->document->integeration_details->ca->destination_name = $this->_request->destination_name;
                $waybillBean->document->integeration_details->ca->destination_address = $this->_request->destination_address;

                // TODO: enable this if company has EPAYMENT Service
                //$paymentCore = new PaymentCore();
                //$freight_node = $paymentCore->calculateFreight($waybillBean->id);
                //$waybillBean->document->freight->amount = $freight_node->amount;
                //$this->_waybillCore->updateWaybill($waybillBean, $waybill_id, 0);

                // change waybill status
                $this->_waybillCore->changeStatus($waybill_id, 'CLOSED', $_SESSION['user_id']);
                // DBConnection::commitTransaction();
            } catch (Exception $e) {
                DBConnection::rollBackTransaction();
                throw new Exception("CANT_COMPLETE_YOUR_REQUEST." . $e->getMessage());
            }
        } else {
            throw new Exception("INVALID_REQUEST.weight_received_not_defined");
        }

        // return response
        $result = [];
        $result['ERRORCODE'] = "0";
        $result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
        parent::response($result);
    }



    // ----------------------------------------------------------------------------------- //
    // ------------------ Handler when creating ltrc waybill is done --------------------- //
    // ----------------------------------------------------------------------------------- //
    public function createLtrcWaybillHandler()
    {

        try {

            // get incoming request daa
            $wn = $this->_request->wn;

            // get the waybill bean
            $waybillFilter = [['key' => 'wn', 'val' => $wn]];
            $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter, 1, 0, $_SESSION['user_id']);
            $waybillBean = $waybillResult->data[0];
            $doc = json_decode($waybillBean->document);


            // skip this handler in case the same docNum is sent twice
            if (is_numeric($this->_request->docnum)) {
                if ($doc->ltrc && $doc->ltrc->docnum == $this->_request->docnum) {
                    return;
                }
            }

            // prepare the ltrc node in waybill document
            $newWaybill = new stdClass();
            $newWaybill->ltrc = new stdClass();
            $newWaybill->ltrc->docNum = $this->_request->docnum;
            $newWaybill->id = $waybillBean->id;

            // log the ltrc activity
            $addNoteCore = new Add_notes_core();
            if ($this->_request->error) {
                $addNoteCore->addNotes('waybill', $waybillBean->id, $this->_request->error->message, $_SESSION['user_id']);

                $newWaybill->ltrc->submit_waybill = true;
                $newWaybill->ltrc->waybill_status = null;

                $wall_message = ' خطأ في تقديم وثيقة الهيئة للشاحنة '  . $doc->carrier[0]->truck->tn . ' السبب: ' . $this->_request->error->message;
                $notification_message = ' خطأ في تقديم وثيقة الهيئة للشاحنة '  . $doc->carrier[0]->truck->tn;

                $this->_waybillCore->logActivity(
                    $waybillBean->id,
                    "خطأ في تقديم وثيقة الهيئة",
                    $this->_request->error->message,
                    "SUBMIT_LTRC",
                    0
                );
            } else {

                $addNoteCore->addNotes('waybill', $waybillBean->id, 'تم تقديم وثيقة نقل الهيئة بنجاح - ' . $this->_request->docnum,  $_SESSION['user_id']);
                $newWaybill->ltrc->submit_waybill = false;
                $newWaybill->ltrc->waybill_status = null;
                $newWaybill->ltrc->send_SMS = $doc->ltrc->send_SMS;
                $newWaybill->ltrc->SMS_text = $doc->ltrc->SMS_TEXT;

                $wall_message = ' تم تقديم وثيقة نقل الهيئة للشاحنة رقم '  . $doc->carrier[0]->truck->tn . ' ورقمها ' . $this->_request->docnum;
                $notification_message = ' تم تقديم وثيقة نقل الهيئة للشاحنة رقم '  . $doc->carrier[0]->truck->tn;

                // log this activity
                $this->_waybillCore->logActivity(
                    $waybillBean->id,
                    "تقديم وثيقة نقل الهيئة بنجاح",
                    $this->_request->docnum,
                    "SUBMIT_LTRC",
                    0
                );

                // send SMS in case it is enabled in waybill doc to the driver
                if ($doc->ltrc->send_SMS) {
                    $SMS_text = $doc->ltrc->SMS_TEXT;

                    $driverFilter = [['key' => 'id', 'val' => $waybillBean->driver_id]];
                    $driver_qry = $this->_driverCore->searchDriver($driverFilter, 1, 0, 0);
                    $messageRecipient = $driver_qry->data[0]->phone;
                    $messageRecipient = convertToInternational($messageRecipient);
                    sendSMS($messageRecipient, $SMS_text);
                }
            }

            $this->_waybillCore->updateWaybill($newWaybill, $waybillBean->id, $_SESSION['user_id']);

            // send notification to the user who created the waybill
            $socialCore = new SocialCore();
            $socialCore->informSupervisor('وثيقة النقل', $wall_message, $notification_message,  $this->_request->done_by);
        } catch (Exception $e) {
            $notificationCore = new NotificationCore();
            $wall_message = $this->_request->wn . "," . $this->_request->docnum . "," . $_SESSION['user_id'];
            $notification_message = " createLtrcHandler error ";

            // send notification
            $payload = new stdClass();
            $payload->type = "set_notification";
            $payload->id = rand(1, 1000);
            $payload->title = $notification_message;
            $payload->message = $wall_message;
            $notificationCore->sendDataMessage(2, $payload);
        }
    }


    // ------------------------------------------------------------------- //
    // ------------------ Create Grains Waybill API --------------------- //
    // ------------------------------------------------------------------- //
    public function createGrainsWaybill()
    {

        try {

            // prepare the needed data
            $tender_id = $this->_request->tender_id;
            $q_id = $this->_request->q_id;
            $tender_company_id = $this->_request->tender_company_id;
            $cargo_id = $this->_request->cargo_id;
            $trucking_company_id = $this->_request->trucking_company_id;
            $origin_id = $this->_request->origin_id;
            $destination_id = $this->_request->destination_id;
            $ca_company_id = $this->_request->ca_company_id;
            $first_trip_ct = $this->_request->first_trip_ct;
            $first_trip_destination_id = $this->_request->first_trip_destination_id;

            $truck_id = null;
            $trailer_id = null;
            $truck_owner_id = null;
            $tender_truck_id = null;
            $driver_id = null;
            $tender_order_id = null;

            // parse the incoming data
            $truck = json_decode($this->_request->truck);
            $trailer = json_decode($this->_request->trailer);
            $permit = json_decode($this->_request->permit);
            $this->printLog("parse the incoming data done");

            $userBean = $this->_userCore->getUserBasic($_SESSION['u_id'], $_SESSION['user_id']);

            // ---------------- Truck Owner --------------------- //
            // in case the owner does not exist, create new truck_owner
            if ($userBean->truck_owner_id) {
                $truck_owner_id = $userBean->truck_owner_id;
            } else {
                $truckOwnerBean = new stdClass();
                $truckOwnerBean->user_id = $_SESSION['u_id'];
                $truck_owner_id = $this->_truckOwnerCore->createTruckOwner($truckOwnerBean, $_SESSION['user_id']);
            }
            $this->printLog("Truck Owner ... done");

            // ---------------- TRUCK --------------------------- //
            //check if truck already exists
            $truckActiveStatus = DBConnection::getActiveStatus('truck');
            $truckSearchFilter = [['key' => 'tn', 'val' => $truck->tn], ['key' => 'status', 'val' => $truckActiveStatus, 'op' => 'in']];
            $truckResult = $this->_truckCore->searchTrucks($truckSearchFilter, 1, 0, $_SESSION['user_id']);

            //if truck does not exist, create it
            if ($truckResult->found_rows == 0) {
                $truckBean = new stdClass();
                $truckBean->tn = $truck->tn;
                $truckBean->tt = $truck->tt;
                $truckBean->minor_tt = $truck->tt == "920000" ? "9" : "-1";
                $truckBean->truck_owner_name = $truck->truck_owner_name;
                $truckBean->cat = $truck->cat;
                $truckBean->reg_fees = $truck->reg_fees;
                $truckBean->engine_size = $truck->engine_size;
                $reg_expiry = str_replace("/", "-", $truck->reg_expiry);
                $reg_expiry_date = date_create($reg_expiry);
                $truckBean->reg_expiry = date_format($reg_expiry_date, 'Y-m-d');
                $truckBean->reg_num = $truck->reg_num;
                $truckBean->make_year = $truck->make_year;
                $truckBean->chasis_num = $truck->chasis_num;
                $truck_id = $this->_truckCore->createTruck($truckBean, $truck_owner_id, $_SESSION['user_id']);

                // activate it
                $this->_truckCore->changeStatus($truck_id, 'ACTIVE', $_SESSION['user_id']);
            } else {
                $truck_id = $truckResult->data[0]->id;
            }
            $this->printLog("Truck ... done");

            // --------------- Truck Contract ----------------------- //
            // search for truck_contract for current truck
            $truckContractFilter = [
                ['key' => 'truck_owner_id', 'val' => $truck_owner_id],
                ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in'],
                ['key' => 'truck_id', 'val' => $truck_id]
            ];

            $truckContractResult = $this->_truckContractCore->searchTruckContracts($truckContractFilter, 1, 0, $_SESSION['user_id']);

            // in case contract does not exists , create it
            // if($truckContractResult->found_rows == 0){
            //     $truckContractBean = new stdClass();
            //     $truckContractBean->truck_owner_id = $truck_owner_id;
            //     $truckContractBean->truck_id = $truck_id;
            //     $truckContractBean->contract_type = "AUTH";
            //     $truckContractBean->photos = [];

            //     $createTruckContractResult = $this->_truckContractCore->createTruckContract($truckContractBean, $_SESSION['user_id'] );
            // }
            // $this->printLog("Truck Contract ... done");

            // -------------- Trailer --------------------------------- //
            //check if trailer already exists
            $truckActiveStatus = DBConnection::getActiveStatus('truck');
            $trailerSearchFilter = [['key' => 'tn', 'val' => $trailer->tn], ['key' => 'status', 'val' => $truckActiveStatus, 'op' => 'in']];
            $trailerResult = $this->_truckCore->searchTrucks($trailerSearchFilter, 1, 0, $_SESSION['user_id']);

            //if truck does not exist, create it
            if ($trailerResult->found_rows == 0) {
                $trailerBean = new stdClass();
                $trailerBean->tn = $trailer->tn;
                $trailerBean->tt = $trailer->tt;
                $trailerBean->minor_tt = "-1";
                $trailerBean->truck_owner_name = $trailer->truck_owner_name;
                $trailerBean->cat = $trailer->cat;
                $trailerBean->reg_fees = $trailer->reg_fees;
                $trailerBean->engine_size = $trailer->engine_size;
                $reg_expiry = str_replace("/", "-", $truck->reg_expiry);
                $reg_expiry_date = date_create($reg_expiry);
                $trailerBean->reg_expiry = date_format($reg_expiry_date, 'Y-m-d');
                $trailerBean->reg_num = $trailer->reg_num;
                $trailerBean->make_year = $trailer->make_year;
                $trailerBean->chasis_num = $trailer->chasis_num;

                $trailer_id = $this->_truckCore->createTruck($trailerBean, $truck_owner_id, $_SESSION['user_id']);
            } else {
                $trailer_id = $trailerResult->data[0]->id;
            }
            $this->printLog("Trailer ... done");

            // --------------------- Driver User ------------------------------------- //
            // search for driver user
            $userActiveStatus = DBConnection::getActiveStatus('user');
            $userSearchFilter = [
                ['key' => 'nn', 'val' => $permit->NNPN],
                ['key' => 'status', 'val' => $userActiveStatus, 'op' => 'in']
            ];
            $userSearchResult = $this->_userCore->searchUser($userSearchFilter, 1, 0, 0);

            // in case the driver user does noit exists, create it
            if ($userSearchResult->found_rows == 0) {
                $userBean = new stdClass();
                $phone_info = new stdClass();
                $phone_info->sim = 0;
                $phone_info->phone = $permit->NNPN;
                $phone_info->imei = 0;
                $phone_info->verification_method = 'NONE';
                $phone_array[0] = $phone_info;

                $userBean->phone_array = $phone_array;
                $userBean->name = $permit->NAME;
                $userBean->nn = $permit->NNPN;

                $user_id = $this->_userCore->registerNewUser($userBean, $_SESSION['user_id']);
            } else {
                $user_id = $userSearchResult->data[0]->id;
            }
            $this->printLog("Driver User... done");

            // --------------------- Driver ------------------------------------- //

            $driverActiveStatus = DBConnection::getActiveStatus('driver');
            $driverFilter = [
                ['key' => 'nn', 'val' => $permit->NNPN],
                ['key' => 'status', 'val' => $driverActiveStatus, 'op' => 'in']
            ];
            $driver_result = $this->_driverCore->searchDriver($driverFilter, 1, 0, $_SESSION['user_id']);

            // in case the driver does not exist , create it
            if ($driver_result->found_rows == 0) {
                $driverBean = new stdClass();
                $driverBean->user_id = $user_id;
                $photos_array = [];
                $driverBean->photos = json_decode(json_encode($photos_array));

                $createDriverResult = $this->_driverCore->createDriver($driverBean, $user_id, $_SESSION['user_id']);
                $driver_id = $createDriverResult[0]['@id'];
            } else {
                $driver_id = $driver_result->data[0]->id;
            }
            $this->printLog("Driver ... done");

            // --------------------- Tender Truck ------------------------------- //
            // search for truck in tender truck
            $tenderTruckActiveStatus = DBConnection::getActiveStatus('tender_truck');
            $tenderTruckFilter = [
                ['key' => 'truck_id', 'val' => $truck_id],
                ['key' => 'tender_id', 'val' => $tender_id],
                ['key' => 'status', 'val' => ['ACTIVE'], 'op' => 'in']
            ];
            $tenderTruckResult = $this->_tenderCore->searchTenderTruck($tenderTruckFilter, 1, 0, $_SESSION['user_id']);

            //if tender_truck does not exist, create it
            if ($tenderTruckResult->found_rows == 0) {

                $tenderTruck = new stdClass();
                $tenderTruck->truck_id = $truck_id;
                $tenderTruck->trailer_id = $trailer_id;
                $tenderTruck->tender_id = $tender_id;
                $tenderTruck->q_id = $q_id;
                $tenderTruck->tender_company_id = $tender_company_id;
                $question1 = new stdClass();
                $question1->id = 1;
                $question1->val = [91000000]; // الاردن
                $question2 = new stdClass();
                $question2->id = 2;
                $question2->val = [91090000]; // العقبة
                $tenderTruck->questionnaire = [$question1, $question2];
                $tenderTruck->photos = [];

                $tender_truck_id = $this->_tenderCore->createTenderTruck($tenderTruck, $_SESSION['user_id']);

                // activate it
                $this->_tenderCore->changeTruckStatus($tender_truck_id, 'ACTIVE', $_SESSION['user_id']);
            } else {
                $tender_truck_id = $tenderTruckResult->data[0]->id;
            }
            $this->printLog("Tender Truck ... done");

            // ----------------------- Queue ------------------------------------ //
            // search for truck in queue in case it is ACTIVE
            $activeQueueStatus =  "ACTIVE";
            $queueSearchFilter = [
                ['key' => 'truck_id', 'val' => $truck_id],
                ['key' => 'q_id', 'val' => $q_id],
                ['key' => 'tender_id', 'val' => $tender_id],
                ['key' => 'status', 'val' => ['INACTIVE', 'CLOSED'], 'op' => 'not in']
            ];
            $queueTruckResult = $this->_queueCore->searchQueue($queueSearchFilter, 1, 0, $_SESSION['user_id']);

            // in case the truck is not found on the required queue
            if ($queueTruckResult->found_rows == 0) {

                // try to search if it exists on another queue on same tender
                $queueSearchFilter = [
                    ['key' => 'truck_id', 'val' => $truck_id],
                    ['key' => 'q_id', 'val' => [$q_id], 'op' => 'not in'],
                    ['key' => 'tender_id', 'val' => $tender_id],
                    ['key' => 'status', 'val' => ['INACTIVE', 'CLOSED'], 'op' => 'not in']
                ];
                $queueTruckResult = $this->_queueCore->searchQueue($queueSearchFilter, 1, 0, $_SESSION['user_id']);

                // if found on other queue on same tender, close it
                if ($queueTruckResult->found_rows != 0) {
                    $old_queue_id = $queueTruckResult->data[0]->id;
                    $this->_queueCore->changeStatus($old_queue_id, 'CLOSED', 0);
                }

                // add it to the required queue
                $queue_id = $this->_queueCore->addQueue($truck_id, $driver_id, $trailer_id, $q_id, $tender_id, $_SESSION['user_id']);
            } else {
                // in case the truck is ACTIVE or APPROVED, just use the queue_id
                if ($queueTruckResult->data[0]->status == 'ACTIVE' || $queueTruckResult->data[0]->status == 'APPROVED') {
                    $queue_id = $queueTruckResult->data[0]->id;
                } else {
                    // in case the queue status is other than active, throw exception
                    throw new Exception("Truck has invalid status on queue");
                }
            }
            $this->printLog("Queue ... done");

            // ---------------------- Tender Order --------------------------------------
            // search for tender order for current date
            $current_date = date_create(DBConnection::getSystemDate());
            $current_date = date_format($current_date, 'Y-m-d');
            $tenderSearchFilter = [
                ['key' => 'tender_id', 'val' => $tender_id],
                ['key' => 'status', 'val' => ['PENDING', 'ACTIVE'], 'op' => 'in'],
                ['key' => 'order_date', 'val' => $current_date]
            ];
            $orderResult = $this->_tenderCore->searchTenderOrder($tenderSearchFilter, 1, 0, $_SESSION['user_id']);

            // in case no tener order is found, create a new one and close any older tender orders
            if ($orderResult->found_rows == 0) {
                $tenderOrderBean = new stdClass();
                $tenderOrderBean->tender_id = $tender_id;
                $tenderOrderBean->q_id = $q_id;
                $question1 = new stdClass();
                $question1->id = 1;
                $question1->val = [91000000]; // الاردن
                $question2 = new stdClass();
                $question2->id = 2;
                $question2->val = [91090000]; // العقبة
                $tenderOrderBean->questionnaire = json_encode([$question1, $question2]);
                $tenderOrderBean->cargo = [(int)$cargo_id];
                $tenderOrderBean->trucks = 500;
                $tenderOrderBean->order_date = $current_date;

                $tender_order_id = $this->_tenderCore->createTenderOrder($tenderOrderBean, 0);
                $this->printLog("Create Tender Order ... done");

                //activate it
                $this->_tenderCore->changeOrderStatus($tender_order_id, 'ACTIVE', $_SESSION['user_id']);
                $this->printLog("Activate Tender Order ... done");

                //close old tender order
                $oldTenderSearchFilter = [
                    ['key' => 'tender_id', 'val' => $tender_id],
                    ['key' => 'status', 'val' => ['PENDING', 'ACTIVE'], 'op' => 'in'],
                    ['key' => 'order_date', 'val' => $current_date, 'op' => 'date less than']
                ];
                $oldOrderResult = $this->_tenderCore->searchTenderOrder($oldTenderSearchFilter, 1, 0, $_SESSION['user_id']);
                foreach ($oldOrderResult->data as $oldTenderOrder) {
                    $this->_tenderCore->changeOrderStatus($oldTenderOrder->id, 'INACTIVE', $_SESSION['user_id']);
                }
            } else {
                $tender_order_id = $orderResult->data[0]->id;
            }
            $this->printLog("Tender Order ... done");


            // -------------------- Waybill Order ------------------------------------
            // search for waybill order for this truck on this tender
            $waybillOrderFilter = [
                ['key' => 'truck_id', 'val' => $truck_id],
                ['key' => 'tender_id', 'val' => $tender_id],
                ['key' => 'status', 'val' => ['CLOSED', 'REVOKED'], 'op' => 'not in']
            ];
            $waybillOrderSearch = $this->_waybillOrderCore->searchWaybillOrder($waybillOrderFilter, 1, 0, $_SESSION['user_id']);

            // in case no waybill order in the active status, then create one
            if ($waybillOrderSearch->found_rows == 0) {

                $waybillOrderResult = $this->_waybillOrderCore->createWaybillOrder($tender_order_id, $cargo_id, $truck_owner_id, $queue_id, 0);
                $waybill_order_id = $waybillOrderResult[0]['@id'];
                $this->printLog("create waybill Order ... done");

                // change queue to waiting
                $queueFilter = [
                    ['key' => 'truck_id', 'val' => $truck_id],
                    ['key' => 'tender_id', 'val' => $tender_id],
                    ['key' => 'status', 'val' => "ACTIVE"]
                ];
                $queueResult = $this->_queueCore->searchQueue($queueFilter, 1, 0, $_SESSION['user_id']);
                if ($queueResult->found_rows) {
                    $this->_queueCore->changeStatus($queue_id, 'WAITING', 0);
                    $this->printLog("change queue status to waiting... done");
                }

                // accept waybill order
                $this->_waybillOrderCore->acceptWaybillOrder($waybill_order_id, $_SESSION['user_id']);
            } else {
                $waybill_order_id = $waybillOrderSearch->data[0]->id;

                // accept it in case it is NEW
                if ($waybillOrderSearch->data[0]->status == 'NEW') {
                    $this->_waybillOrderCore->acceptWaybillOrder($waybill_order_id, $_SESSION['user_id']);
                }
            }

            // close it and create new waybill
            $result = $this->_waybillOrderCore->closeWaybillOrder($waybill_order_id, $_SESSION['user_id']);
            $this->printLog("close waybill Order ... done");

            // ------------------------Waybill -------------------------------------- //
            $waybillFilter = [
                ['key' => 'truck_id', 'val' => $truck_id],
                ['key' => 'status', 'val' => ['NEW', 'APPROVED'], 'op' => 'in']
            ];
            $waybill_result = $this->_waybillCore->searchWaybills($waybillFilter, 1, 0, $_SESSION['user_id']);

            // get fresh copy of waybill
            $waybill_id = $waybill_result->data[0]->id;
            $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $_SESSION['user_id']);

            // update first trip info
            $waybillJson = $waybillBean->document;
            $waybillJson->first_trip = new stdClass();
            $waybillJson->first_trip->ct = $first_trip_ct;
            $waybillJson->first_trip->destination = $first_trip_destination_id;


            $waybillBean->document = $waybillJson;
            $this->_waybillCore->updateWaybill($waybillBean, $waybillBean->id, $_SESSION['user_id']);

            // ---------------------- activate it ------------------------------------ //
            $this->_waybillCore->changeStatus($waybill_id, 'ACTIVE', $_SESSION['user_id']);

            $this->printLog("create waybill ... done");

            // add new task to close the waybill after 12 hours
            $taskQueuesCore = new TaskQueuesCore();
            $taskQueuesCore->createCloseWaybillTask($waybill_result->data[0]->id, 12, "اغلاق مستند التموين بسبب مرور 12 ساعة من وقت الإنشاء");

            // return response
            $result = [];
            $result['ERRORCODE'] = "0";
            $result['ID'] = $waybill_result->data[0]->id;
            $result['WN'] = $waybill_result->data[0]->wn;
            $result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";

            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }



    // ------------------------------------------------------------------------------------------ //
    // ----------------- validate the incomming request (ex: IP whitelist) ---------------------- //
    // ------------------------------------------------------------------------------------------ //
    private function validateIntegerationRequest()
    {

        if (!$_SESSION['company_id']) {
            throw new Exception("INVALID_LOGIN");
        }

        switch ($_SESSION['company_id']) {
                // Alarabiya
            case '34196':
                // validate IP_address
                $ip_address = get_client_ip();
                if (!in_array($ip_address, [
                    "82.212.125.144",  // Minagate Office (for testing)
                    "34.207.222.70",   // Al arabyia server
                    "92.253.90.200",   // Al arabyia new server
                    "54.90.36.188"
                ])) // Al arabyia new server 2
                {
                    throw new Exception("ACCESS_DENIED_FOR_IP_ADDRESS_" . $ip_address);
                }
                break;

                // وزارة الصناعة
            case '275405':
                // validate IP_address
                $ip_address = get_client_ip();
                if (!in_array($ip_address, ["173.248.136.247", "82.212.125.144", "185.193.176.126", "94.249.100.179", "92.253.90.200"])) {
                    throw new Exception("ACCESS_DENIED_FOR_IP_ADDRESS  " . $ip_address);
                }
                break;

                // Shaaban
            case '900998':
                $ip_address = get_client_ip();
                if (!in_array($ip_address, [
                    "46.185.175.21",    // Hamzeh Home for testing
                    "82.212.125.144",   // Minagate Office (for testing)
                    "94.142.37.34"
                ])) // Shaaban
                {
                    throw new Exception("ACCESS_DENIED_FOR_IP_ADDRESS_" . $ip_address);
                }
                break;


                // in case no company is defined throw exception
            default:
                throw new Exception("COMPANY_ID_NOT_DEFINED , c=" . $_SESSION['company_id']);
        }
    }



    // ----------------------------------------------------------------------------------------- //
    // ----------------- Format cargo data for each integeration server------------------------------- //
    // ----------------------------------------------------------------------------------------- //
    private function formatCargoData($CargoResult)
    {

        switch ($_SESSION['company_id']) {

                //شعبان
            case '900998':

                $result = [];
                foreach ($CargoResult->data as $cargoData) {
                    $cargo = new stdClass();
                    $cargo->id = intval($cargoData->id);
                    $cargo->name = $cargoData->name;
                    $cargo->cargo_owner = $cargoData->cargo_owner;
                    $cargo->ca_name = $cargoData->ca_name;
                    $cargo->vessel_name = $cargoData->vessel_name;
                    $cargo->weight_total = $cargoData->weight_total;
                    $cargo->weight_units = $cargoData->weight_units;

                    $result[] = $cargo;
                }
                break;

                // no company is found
            default:
                throw new Exception("COMPANY_ID_NOT_DEFINED");
        }
        return $result;
    }



    // ----------------------------------------------------------------------------------------- //
    // ----------------- Format data for each integeration server------------------------------- //
    // ----------------------------------------------------------------------------------------- //
    private function formatData($waybillResult)
    {

        switch ($_SESSION['company_id']) {
                // Alarabiya , وزارة الصناعة,
            case '34196':
            case '275405':

                $doc = json_decode($waybillResult->data[0]->document);

                $result = new stdClass();
                $result->wn = $waybillResult->data[0]->wn;
                $result->status_code = $waybillResult->data[0]->status;
                if ($doc->carrier[0]->driver->nn) {
                    $result->driver_nn = $doc->carrier[0]->driver->nn;
                } else {
                    $driverCore = new DriverCore();
                    $driverFilter = [['key' => 'id', 'val' => $doc->carrier[0]->driver->id]];
                    $driver_qry = $driverCore->searchDriver($driverFilter, 1, 0, 0);
                    if ($driver_qry->found_rows > 0) {
                        $result->driver_nn = $driver_qry->data[0]->nn;
                    }
                }
                $result->driver_name = $doc->carrier[0]->driver->name;
                $result->driver_phone = $doc->carrier[0]->driver->phone;
                $result->plate_number = $doc->carrier[0]->truck->tn;
                $result->trailer_number = $doc->carrier[0]->trailer->tn;
                $result->destination_id = $doc->negotiable_instructios->route->destination->id;
                $result->destination_name = $doc->negotiable_instructios->route->destination->name;
                $result->integeration_details = $doc->integeration_details;
                $result->weight = new stdClass();
                $result->weight->loading_weight = $doc->cargo[0]->weights->loading->net_weight;
                $result->weight->discharge_weight = $doc->cargo[0]->weights->discharge->net_weight;

                if ($doc->carrier[0]->trailer->tt) {
                    $result->trailer_type_code = $doc->carrier[0]->trailer->tt;
                    $result->truck_type_caption = $doc->carrier[0]->trailer->tt;
                } else {
                    $truckCore = new TruckCore();

                    if ($doc->carrier[0]->trailer->id) {
                        $truckBean = $truckCore->getTruckBasic($doc->carrier[0]->trailer->id, 0);
                        $result->trailer_type_code = $truckBean->minor_tt;
                    } else {
                        $result->trailer_type_code = null;
                    }
                    if ($truckBean->minor_tt == 201) {
                        $result->truck_type_caption = "قلاب";
                    } else if ($truckBean->minor_tt == 203) {
                        $result->truck_type_caption = "تريلا";
                    } else {
                        $result->truck_type_caption = null;
                    }
                }
                break;

                //شعبان
            case '900998':

                $result = [];
                foreach ($waybillResult->data as $waybillData) {

                    $doc = json_decode($waybillData->document);

                    $wbl = new stdClass();
                    $wbl->id = $waybillData->id;
                    $wbl->wn = $waybillData->wn;
                    $wbl->create_date = $waybillData->create_date;
                    $wbl->tn = $doc->carrier[0]->truck->tn;
                    $wbl->trn = $doc->carrier[0]->trailer->tn;
                    $wbl->trailer_type = $doc->carrier[0]->trailer->minor_tt == "201" ? "قلاب" : "تريلا";
                    $wbl->driver_name = $doc->carrier[0]->driver->name;
                    $wbl->driver_phone = $doc->carrier[0]->driver->phone;
                    $wbl->driver_nn = $doc->carrier[0]->driver->nn;
                    $wbl->cargo_id = $doc->cargo[0]->cargo->id;
                    $wbl->cargo_name = $doc->cargo[0]->cargo->name;
                    $wbl->vessel_name = $doc->cargo[0]->vessel_name;

                    // in case out location is جوردينا make it القسطل
                    if ($doc->negotiable_instructios->route->destination->id == 91010063 || $doc->negotiable_instructios->route->destination->id == "91010063") {
                        $doc->negotiable_instructios->route->destination->id = 91010009;
                    }

                    // in case out location is ضبعة sub
                    if (
                        $doc->negotiable_instructios->route->destination->id == 91010003 ||
                        $doc->negotiable_instructios->route->destination->id == 91010004 ||
                        $doc->negotiable_instructios->route->destination->id == 91010005 ||
                        $doc->negotiable_instructios->route->destination->id == 91010006 ||
                        $doc->negotiable_instructios->route->destination->id == 91010007 ||
                        $doc->negotiable_instructios->route->destination->id == 91010008 ||
                        $doc->negotiable_instructios->route->destination->id == 91010053
                    ) {
                        $doc->negotiable_instructios->route->destination->id = 91010022;
                    }

                    $wbl->destination_id = strval($doc->negotiable_instructios->route->destination->id);
                    $wbl->destination_name = $doc->negotiable_instructios->route->destination->name;

                    $result[] = $wbl;
                }
                break;

                // no company is found
            default:
                throw new Exception("COMPANY_ID_NOT_DEFINED");
        }
        return $result;
    }

    private function printLog($message)
    {
        // echo $message . "<br/>";
        // var_dump($message);
    }



    // ------------------------------------------------------------------- //
    // ---------------- get waybill info for pa integration -------------- //
    // ------------------------------------------------------------------- //
    public function getWaybillInfo()
    {
        // get user input
        $wn = $this->_request->wn;
        if (!$wn) {
            throw new Exception("wn is required");
        }

        $this->validateIntegerationRequest();

        $waybillFilter = [['key' => "wn", 'val' => $wn]];


        // get waybill_info
        $waybillResult = $this->_waybillCore->searchWaybills($waybillFilter, 1, 0, $_SESSION['user_id']);
        if ($waybillResult->found_rows == 0) {
            throw new Exception("waybill is invalid or not found");
        }

        $waybillData = $waybillResult->data[0];
        $doc = json_decode($waybillData->document);

        $result = new stdClass();
        $result->id = $waybillData->id;
        $result->wn = $waybillData->wn;
        $result->tn = $doc->carrier[0]->truck->tn;
        $result->trn = $doc->carrier[0]->trailer->tn;
        $result->trailer_type = $doc->carrier[0]->trailer->minor_tt == "201" ? "قلاب" : "تريلا";
        $result->driver_name = $doc->carrier[0]->driver->name;
        $result->driver_phone = $doc->carrier[0]->driver->phone;
        $result->driver_nn = $doc->carrier[0]->driver->nn;
        $result->cargo_name = $doc->cargo[0]->cargo->name;
        $result->destination_id = $doc->negotiable_instructios->route->destination->id;
        $result->destination_name = $doc->negotiable_instructios->route->destination->name;

        $wns[] = $waybillData->wn;
        $location_result = $this->_mg_tracking->getLocations_new($wns);
        if (sizeof($location_result['data']) > 0) {
            $result->driver_location = new stdClass();
            $result->driver_location->long = $location_result['data'][0]['long'];
            $result->driver_location->lat = $location_result['data'][0]['lat'];
            $result->driver_location->location_date = $location_result['data'][0]['location_date'];
        } else {
            $result->driver_location = null;
        }

        parent::response($result);
    }






    // search list of all cargo
    public function searchCargos()
    {
        //$this->validateIntegerationRequest();

        $cargoFilter = $this->prepareCargoFilter();
        $cargoResult = $this->_cargoCore->searchCargo($cargoFilter, 1000, 0, $_SESSION['user_id']);

        // format search result
        $cargoResult = $this->formatCargoData($cargoResult);

        // return data to user
        parent::response($cargoResult);
    }

    // search list of all location
    public function searchLocations()
    {

        //$this->validateIntegerationRequest();

        $location_ids = $this->_tenderCore->getTenderDestinations(3);

        $locationFilter = [];
        $tempArr = ['key' => 'id', 'val' => $location_ids, 'op' => 'in'];
        array_push($locationFilter, $tempArr);
        $location_qry = $this->_locationCore->searchLocation($locationFilter, 1000, 0, $_SESSION['user_id']);

        // format data
        $reult = [];
        foreach ($location_qry->data as $loc) {
            $tempLoc = new stdClass();
            $tempLoc->id = intval($loc->id);
            $tempLoc->name = $loc->name;
            $result[] = $tempLoc;
        }



        //send websocket
        $messageData = new stdClass();
        $messageData->message = "تم انشاء توجيه جديد : الموقع القسطل - العدد : 150";
        $userHB = $this->_userCore->getUserHeartBeatObject(16543);
        $UUID = $userHB->UUID;
        $socialCore = new SocialCore();
        $socialCore->sendWebSocket($UUID, "MESSAGE_CONFIRM", $messageData);

        // return data to user
        parent::response($result);
    }

    // ----------------------------------------------------------------------------- //
    // ----------------------------- View destination routes ----------------------- //
    // ----------------------------------------------------------------------------- //
    public function viewDestinationRoute()
    {
        $cargo_id = $this->_request->cargo_id;

        // search cargo
        $cargoFilter = $this->prepareCargoFilter();
        $cargoFilter[] = ["key" => "id", "val" => $cargo_id];
        $cargoResult = $this->_cargoCore->searchCargo($cargoFilter, 1000, 0, $_SESSION['user_id']);

        // get active tender order
        $tenderSearchFilter = [
            ['key' => 'tender_id', 'val' => 3],
            ['key' => 'cargo', 'val' => $cargoResult->data[0]->id, 'op' => 'like'],
            ['key' => 'status', 'val' => ['COMPLETE', 'ACTIVE'], 'op' => 'in']
        ];
        $orderResult = $this->_tenderCore->searchTenderOrder($tenderSearchFilter, 1, 0, 0);

        $tender_order_id = $orderResult->data[0]->id;
        $truck_routes = $this->_truckRoutingCore->getActiveTruckRoutesDashboard($tender_order_id, 0);

        $result = [];
        foreach ($truck_routes['routes'] as $r) {
            $temp = new stdClass();

            $temp->id = $r->id;
            $temp->origin_name = $r->origin_name;
            $temp->destination_id = intval($r->destination_id);
            $temp->destination_name = $r->destination_name;
            $temp->count = intval($r->count);
            $temp->count_used = intval($r->count_used);
            $temp->trailer_type = $r->trailer_type;
            $result[] = $temp;
        }
        parent::response($result);
    }

    // ------------------------------------------------------------------ //
    // -------------------- create new route ---------------------------- //
    // ------------------------------------------------------------------ //
    public function createDestinationRoute()
    {
        //$this->validateIntegerationRequest();

        // get user params
        $origin_id = 91090000; // Aqaba
        $destination_id = $this->_request->destination_id;
        $count = $this->_request->count;
        $cargo_id = $this->_request->cargo_id;
        $trailer_type = $this->_request->trailer_type;      //201=Qalab  , 203: Trilla
        $notes = $this->_request->notes;

        // validate the cargo ownership
        $cargoFilter = $this->prepareCargoFilter();
        $cargoFilter[] = ["key" => "id", "val" => $cargo_id];
        $cargoResult = $this->_cargoCore->searchCargo($cargoFilter, 1000, 0, $_SESSION['user_id']);
        if ($cargoResult->found_rows == 0) {
            throw new Exception("رقم الحمولة غير صحيح");
        }

        // get active tender order
        $tenderSearchFilter = [
            ['key' => 'tender_id', 'val' => 3],
            ['key' => 'cargo', 'val' => $cargo_id, 'op' => 'like'],
            ['key' => 'status', 'val' => 'ACTIVE']
        ];
        $orderResult = $this->_tenderCore->searchTenderOrder($tenderSearchFilter, 10, 0, 0);
        $tender_order_id = $orderResult->data[0]->id;

        // get the route id
        $tender_order_bean = $this->_tenderCore->getTenderOrderBasic($tender_order_id, 0);
        $route_id = null;
        $questionnaire = null;
        foreach ($tender_order_bean->truck_routing as $r) {
            if ($r->destination_id == $destination_id && $r->status == "ACTIVE") {
                $route_id = $r->id;
                break;
            }
        }
        if ($route_id) {
            throw new Exception("destination already exist and still ACTIVE, you can update it but you cant create it again");
        }

        // for the questionare
        $questionnaire = [
            ["id" => 1, "val" => $destination_id],
            ["id" => 2, "val" => $origin_id],
            ["id" => 3, "val" => $trailer_type]
        ];

        try {
            $truck_route = $this->_truckRoutingCore->createTruckRoute($tender_order_id, $destination_id, $count, $questionnaire, false, $_SESSION['user_id']);

            // inform about this update
            $this->informRouteParties($destination_id, $count, "create");

            parent::response($truck_route);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------ //
    // -------------------- create new route ---------------------------- //
    // ------------------------------------------------------------------ //
    public function updateDestinationRoute()
    {
        $cargo_id = $this->_request->cargo_id;
        $count = $this->_request->count;
        $destination_id = $this->_request->destination_id;

        $cargoFilter = $this->prepareCargoFilter();
        $cargoFilter[] = ["key" => "id", "val" => $cargo_id];
        $cargoResult = $this->_cargoCore->searchCargo($cargoFilter, 1, 0, $_SESSION['user_id']);
        if ($cargoResult->found_rows == 0) {
            throw new Exception("INVALID CARGO");
        }

        // get active tender order
        $tenderSearchFilter = [
            ['key' => 'tender_id', 'val' => 3],
            ['key' => 'cargo', 'val' => $cargoResult->data[0]->id, 'op' => 'like'],
            ['key' => 'status', 'val' => 'ACTIVE']
        ];
        $orderResult = $this->_tenderCore->searchTenderOrder($tenderSearchFilter, 10, 0, 0);
        $tender_order_id = $orderResult->data[0]->id;

        // get the route id
        $tender_order_bean = $this->_tenderCore->getTenderOrderBasic($tender_order_id, 0);
        $route_id = null;
        $questionnaire = null;
        $old_count = 0;
        foreach ($tender_order_bean->truck_routing as $r) {
            if ($r->destination_id == $destination_id) {
                $route_id = $r->id;
                $questionnaire = $r->questionnaire;
                $old_count = $r->count;
                break;
            }
        }


        if (!$route_id) {
            throw new Exception("destination does not exist");
        }

        if ($old_count == $count) {
            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'تمت العملية بنجاح';
            parent::response($Result);
        } else {

            try {
                $truck_route = $this->_truckRoutingCore->updateTruckRoute($tender_order_id, $route_id, $count, $questionnaire, $_SESSION['user_id']);

                // inform about this update
                $this->informRouteParties($destination_id, $count, "update");

                $Result = [];
                $Result['ERRORCODE'] = '0';
                $Result['MESSAGE'] = 'تمت العملية بنجاح';
                parent::response($Result);
            } catch (Exception $e) {
                throw new Exception($e->getMessage());
            }
        }
    }


    // ------------------------------------------------------------------------------ //
    // -------------- Inform any interested party of route update ------------------- //
    // ------------------------------------------------------------------------------ //
    private function informRouteParties($destination_id, $count, $type)
    {

        // prepare data
        $socialCore = new SocialCore();
        $destinationName = $this->_locationCore->getLocationBasic($destination_id, 0)->name;
        if ($type == "create") {
            $createRouteMessage = "تم إنشاء توجيه جديد، الموقع: $destinationName - $count شاحنة";
        } else {
            $createRouteMessage = "تم تعديل توجيه الموقع: $destinationName ليصبح $count شاحنة";
        }
        $messageData = new stdClass();
        $messageData->message = $createRouteMessage;

        // get all employees on tender 3
        $db_query = "SELECT
                        u.id, u.name
                     FROM
                        waybill.employee e,
                        waybill.user u
                     WHERE
                        (tender_ids LIKE '%3%'
                            || tender_ids LIKE '%*%')
                            AND e.status = 'ACTIVE'
                            AND e.id = u.employee_id
                            AND u.status = 'ACTIVE'";
        $result =  DBConnection::runDatabaseQuery($db_query);
        foreach ($result as $employee) {
            $userHB = $this->_userCore->getUserHeartBeatObject($employee->id);
            $UUID = $userHB->UUID;

            //send websocket
            $socialCore->sendWebSocket($UUID, "MESSAGE_CONFIRM", $messageData);
        }

        // send SMS to key stakeholders
        sendSMS("0799764840", $createRouteMessage); // Abu Rakan
        sendSMS("0791233491", $createRouteMessage); // Hamza for testing
        sendSMS("0799184881", $createRouteMessage); // Lewaa Fanoun
    }
}


$waybill_integeratrion = new Waybill_integeratrion();
