<?php

// import objects
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/../../core/location/location_core.php");
require_once(dirname(__FILE__) . "/../../core/tender/tender_core.php");
require_once(dirname(__FILE__) . "/../../core/cargo/cargo_core.php");
require_once(dirname(__FILE__) . "/../../core/truck/truck_core.php");
require_once(dirname(__FILE__) . "/../../core/driver/driver_core.php");
require_once(dirname(__FILE__) . "/../../core/truck_owner/truck_owner_core.php");
require_once(dirname(__FILE__) . "/../../core/company/trucking_company/trucking_company_core.php");
require_once(dirname(__FILE__) . "/../../core/company/clearing_agent/clearing_agent_core.php");
require_once(dirname(__FILE__) . "/../../core/location/location_core.php");
require_once(dirname(__FILE__) . "/../../core/tender_company/tender_company_core.php");
require_once(dirname(__FILE__) . "/../../core/route_wage/route_wage_core.php");
require_once(dirname(__FILE__) . "/../notes/add_notes_core.php");
require_once(dirname(__FILE__) . "/../../core/account/account_core.php");
require_once(dirname(__FILE__) . "/../../core/notification/notification_core.php");
require_once(dirname(__FILE__) . "/../../core/social/social_core.php");
require_once(dirname(__FILE__) . "/../../core/payment/payment_core.php");
require_once(dirname(__FILE__) . "/../../core/voucher/voucher_core.php");
require_once(dirname(__FILE__) . "/../../core/truck_contract/truck_contract_core.php");
require_once(dirname(__FILE__) . "/../../core/payment_agent/payment_agent_core.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/Jo_Petrol.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/Grains.php");
require_once(dirname(__FILE__) . "/../../core/payment/jppmc.php");
require_once(dirname(__FILE__) . "/../gateway/gateWay_core.php");
require_once(dirname(__FILE__) . "/../object_watcher/object_watcher_core.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/customer_care.php");
require_once(dirname(__FILE__) . "/../../core/user/user_core.php");
require_once(dirname(__FILE__) . "/../../core/fps_claim/fps_claim_core.php");
require_once(dirname(__FILE__) . "/../../core/fps_voucher/fps_voucher_core.php");
require_once(dirname(__FILE__) . "/../pa_route_wage/pa_route_wage_core.php");


class WaybillCore
{

    public function __construct()
    {
        DBConnection::getInstance();
        $this->_locationCore = new LocationCore();
        $this->_tenderCore = new TenderCore();
        $this->_cargoCore = new CargoCore();
        $this->_truckCore = new TruckCore();
        $this->_driverCore = new DriverCore();
        $this->_truckOwnerCore = new TruckOwnerCore();
        $this->_truckCompanyCore = new TruckingCompanyCore();
        $this->_clearingAgentCore = new ClearingAgentCore();
        $this->_userCore = new UserCore();
        $this->_htmlHeader = '<html>
    <meta name="viewport"  content="user-scalable=no, initial-scale=1, maximum-scale=1, minimum-scale=1, width=device-width, height=device-height, target-densitydpi=device-dpi" >
    <head>
    <link rel="stylesheet" media="screen" href="https://fontlibrary.org/face/droid-arabic-kufi" type="text/css" />
    <style>
        .MinagateFont {
            font-family: DroidArabicKufiRegular;
            font-weight: lighter;
            font-style: normal;
            color: #807d7d;
            font-size: 11px;
            margin-top: 22px;
        }
        .labelStyle {
            text-align: right;
            padding-right: 25px;
        }
        .headerStyle {
            text-align: right;
            padding-right: 25px;
            color: #97c666;
        }
        .valueStyle {
            text-align: right;
            color: rgb(74, 163, 222);
        }
        .divStyle {
            padding: 4px;
            border-bottom: solid 0.5px #ccc;
        }
        .financial-box{
            box-shadow: 0px 0px 3px #888888;
            padding: 12px;
            margin: 7px;
        }
    </style><link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css"></head>';
    }

    // ------------------------------------------------------------------------ //
    // -------------------Create waybill bean and fill it from DB  ------------ //
    // ------------------------------------------------------------------------ //
    public function getWaybill($id, $user_id)
    {

        $waybillInfo = DBConnection::getObjectBean("waybill", $id, $user_id);
        return $waybillInfo;
    }


    // ------------------------------------------------------------------------ //
    // -------------------Create waybill bean and fill it from DB  ------------ //
    // ------------------------------------------------------------------------ //
    public function getWaybillBasic($id, $user_id)
    {

        $waybillInfo = DBConnection::getBasicObjectBean("waybill", $id, $user_id);
        return $waybillInfo;
    }


    // -------------------------------------------------------------------------- //
    // -------------------search for waybill using any search filter ------------ //
    // -------------------------------------------------------------------------- //
    public function searchWaybills($searchFilter, $limit, $offset, $user_id, $orderBy = null)
    {

        $searchWaybillResult = DBConnection::searchDB("waybill", $searchFilter, $limit, $offset, $user_id, $orderBy);

        return $searchWaybillResult;
    }


    // --------------------------------------------------------------- //
    // ------------- create new waybill in database ------------------ //
    // --------------------------------------------------------------- //
    public function createWaybill(
        $tender_id,
        $queue_id,
        $order_id,
        $cargo_id,
        $truck_id,
        $trailer_id,
        $driver_id,
        $truck_owner_id,
        $trailer_owner_id,
        $trucking_company_id,
        $ca_company_id,
        $origin_id,
        $destination_id,
        $user_id,
        $operation_type = 'IMPORT',
        $nafith_wn = null
    ) {

        //  Validate Waybill
        $this->validateForCreate($truck_id, $trailer_id, $driver_id, $tender_id, $user_id);

        if ($truck_owner_id == '') {
            $truck_owner_id = null;
        }
        if ($trailer_owner_id == '') {
            $trailer_owner_id = null;
        }

        $waybill_json = new stdClass();

        // ----------- Generate Waybill Number ---------------------
        // get the tender info
        $tenderBean = $this->_tenderCore->getTenderBasic($tender_id, $user_id);

        // get the waybill status in which the system has to generate WN
        $waybillStatusForGenerating = $tenderBean->manifest->generateWaybillNumberStatus;

        if ($waybillStatusForGenerating == 'NEW' || $waybillStatusForGenerating == null) {
            $wn = DBCOnnection::generateWaybillNumber();
            $waybill_json->wn = $wn;
        } else {
            $waybill_json->wn = null;
        }

        //--------- Start the process of creating the jSON document ----------

        //------------------- operation type ----------------------
        $waybill_json->operation_type = new stdClass();
        $waybill_json->operation_type->code = $operation_type;

        // ------------------- Default contact person ----------------
        try {
            $tenderTruckSearchFilter = [
                ['key' => 'tender_id', 'val' => $tender_id],
                ['key' => 'truck_id', 'val' => $truck_id],
                ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in']
            ];
            $tenderTruck = $this->_tenderCore->searchTenderTruck($tenderTruckSearchFilter, 1, 0, 0);
            $tenderTruck = $tenderTruck->data[0];
            $default_contact_truck_owner_id = $tenderTruck->default_contact_user_id;
            $truckOwnerFilter = [['key' => 'id', 'val' => $default_contact_truck_owner_id]];
            $truckOwner_qry = $this->_truckOwnerCore->searchTruckOwner($truckOwnerFilter, 1, 0, $user_id);
            $waybill_json->default_contact_user_id = $truckOwner_qry->data[0]->user_id;
        } catch (Exception $e) {
        }

        //------------------- Notes ----------------------
        $waybill_json->notes = new stdClass();

        // ------------------ cargo -----------------------
        $cargo_node = new stdClass();
        $cargo_Bean = $this->_cargoCore->getCargoBasic($cargo_id, $user_id);
        $cargo_node->cargo_id = $cargo_id;
        $cargo_node->cargo_unit = $cargo_Bean->weight_units ? $cargo_Bean->weight_units : "kg";
        $cargo_node->unit_weight = $tenderBean->manifest->unit_weight ? $tenderBean->manifest->unit_weight : "50";

        $cargo_node->cargo = new stdClass();
        $cargo_node->cargo->id = $cargo_id;
        $cargo_node->cargo->name = $cargo_Bean->name;
        $cargo_node->cargo->ct_id = $cargo_Bean->ct_id;
        $cargo_node->cargo->container = $cargo_Bean->container;
        $cargo_node->cargo->ct_id = $cargo_Bean->ct_id;

        if ($cargo_Bean == null) {
            throw new Exception("WBL001 - invalid cargo_id");
        }
        $cargo_node->name = $cargo_Bean->name;

        $cargo_node->consigner = new stdClass();
        $cargo_node->consigner->ca = new stdClass();
        $cargo_node->consigner->ca->id = $ca_company_id;
        $caFilter = [['key' => 'id', 'val' => $ca_company_id]];
        $clearingAgent_qry = $this->_clearingAgentCore->searchClearingAgent($caFilter, 1, 0, 0); // search ca by system

        if ($clearingAgent_qry->found_rows == 0) {
            throw new Exception("WBL002 - invalid ca_company_id");
        }
        $cargo_node->consigner->ca->name = $clearingAgent_qry->data[0]->name;

        if ($cargo_Bean->owner_id) {
            $cargoAgentCore = new CargoAgentCore();
            $cargoOwnerBean = $cargoAgentCore->getCargoAgentBasic($cargo_Bean->owner_id, 0);
            $cargo_node->consigner->cargo_owner = new stdClass();
            $cargo_node->consigner->cargo_owner->id = $cargoOwnerBean->id;
            $cargo_node->consigner->cargo_owner->name = $cargoOwnerBean->name;
        } else {
            $cargo_node->consigner->cargo_owner = new stdClass();
            $cargo_node->consigner->cargo_owner->id = 0;
            $cargo_node->consigner->cargo_owner->name = $cargo_Bean->waybill_template->cargo[0]->consigner->cargo_owner_id;
        }
        if ($cargo_Bean->agent_id) {
            $cargoAgentCore = new CargoAgentCore();
            $cargoOwnerBean = $cargoAgentCore->getCargoAgentBasic($cargo_Bean->agent_id, 0);
            $cargo_node->consigner->cargo_agent = new stdClass();
            $cargo_node->consigner->cargo_agent->id = $cargoOwnerBean->id;
            $cargo_node->consigner->cargo_agent->name = $cargoOwnerBean->name;
        }

        $cargoTruckingCompanyFilter = [['key' => 'id', 'val' => $cargo_Bean->waybill_template->carrier[0]->tc_id]];
        $cargoTruckingCompany_qry = $this->_truckCompanyCore->searchTruckingCompany($cargoTruckingCompanyFilter, 1, 0, 0); // search by system

        $cargo_node->consigner->tc = new stdClass();
        $cargo_node->consigner->tc->id = $cargo_Bean->waybill_template->carrier[0]->tc_id;
        $cargo_node->consigner->tc->name = $cargoTruckingCompany_qry->data[0]->name;
        $cargo_node->consigner->tc->logo = extractLogo($cargoTruckingCompany_qry->data[0]->photos);


        // loading and discharge
        $cargo_node->weights = new stdClass();
        $cargo_node->weights->loading = new stdClass();
        $cargo_node->weights->discharge = new stdClass();
        $cargo_node->weights->loading->tare_weight = new stdClass();
        $cargo_node->weights->discharge->tare_weight = new stdClass();
        $cargo_node->weights->loading->gross_weight = new stdClass();
        $cargo_node->weights->discharge->gross_weight = new stdClass();
        $cargo_node->weights->loading->net_weight = null;
        $cargo_node->weights->loading->tare_weight->weight = null;
        $cargo_node->weights->loading->tare_weight->time_stamp = null;
        $cargo_node->weights->loading->tare_weight->location_id = null;
        $cargo_node->weights->loading->tare_weight->weighbridge_id = null;
        $cargo_node->weights->loading->gross_weight->weight = null;
        $cargo_node->weights->loading->gross_weight->time_stamp = null;
        $cargo_node->weights->loading->gross_weight->location_id = null;
        $cargo_node->weights->loading->gross_weight->weighbridge_id = null;
        $cargo_node->weights->discharge->net_weight = null;
        $cargo_node->weights->discharge->tare_weight->weight = null;
        $cargo_node->weights->discharge->tare_weight->time_stamp = null;
        $cargo_node->weights->discharge->tare_weight->location_id = null;
        $cargo_node->weights->discharge->tare_weight->weighbridge_id = null;
        $cargo_node->weights->discharge->gross_weight->weight = null;
        $cargo_node->weights->discharge->gross_weight->time_stamp = null;
        $cargo_node->weights->discharge->gross_weight->location_id = null;
        $cargo_node->weights->discharge->gross_weight->weighbridge_id = null;
        $cargo_node->allowMultiTruckForCargo = $tenderBean->manifest->allowMultiTruckForCargo;

        $waybill_json->cargo = [$cargo_node];

        // ------------------ carrier -----------------------
        $carrier_node = new stdClass();
        $carrier_node->truck = new stdClass();
        $carrier_node->truck->id = $truck_id;

        if ($truck_id != null) {
            $truckBean = $this->_truckCore->getTruckBasic($truck_id, 0);
            $carrier_node->truck->tn = $truckBean->tn;
        } else {
            $carrier_node->truck->tn = null;
        }

        $carrier_node->trailer = new stdClass();
        $carrier_node->trailer->id = $trailer_id;
        if ($trailer_id != null) {
            $trailerBean = $this->_truckCore->getTruckBasic($trailer_id, 0);
            $carrier_node->trailer->tn = $trailerBean->tn;
            $carrier_node->trailer->minor_tt = $trailerBean->minor_tt;
        } else {
            $carrier_node->trailer->tn = null;
        }

        $carrier_node->driver = new stdClass();
        $carrier_node->driver->id = $driver_id;
        $driverFilter = [['key' => 'id', 'val' => $driver_id]];
        $driver_qry = $this->_driverCore->searchDriver($driverFilter, 1, 0, $user_id);

        if ($driver_qry->found_rows > 0) {
            $carrier_node->driver->name = $driver_qry->data[0]->name;
            $carrier_node->driver->phone = $driver_qry->data[0]->phone;
            $carrier_node->driver->nn = $driver_qry->data[0]->nn;
        } else {
            $carrier_node->driver->name = null;
            $carrier_node->driver->phone = null;
            $carrier_node->driver->nn = null;
        }

        $carrier_node->truck_owner = new stdClass();
        $carrier_node->truck_owner->id = $truck_owner_id;
        $truckOwnerFilter = [['key' => 'id', 'val' => $truck_owner_id]];
        $truckOwner_qry = $this->_truckOwnerCore->searchTruckOwner($truckOwnerFilter, 1, 0, $user_id);

        if ($truckOwner_qry->found_rows > 0) {

            $truck_owner_name = str_replace("\\t", "", $truckBean->truck_owner_name);
            $truck_owner_name = str_replace("\"", "", $truck_owner_name);
            $truck_owner_name = trim(preg_replace('/\t+/', '',  $truck_owner_name));
            $truck_owner_name = stripcslashes($truck_owner_name);
            $carrier_node->truck_owner->name = $truck_owner_name;
            $carrier_node->truck_owner->phone = $truckOwner_qry->data[0]->phone;
        } else {
            $carrier_node->truck_owner->name = null;
            $carrier_node->truck_owner->phone = null;
        }

        $carrier_node->trailer_owner = new stdClass();
        $carrier_node->trailer_owner->id = $trailer_owner_id;
        $trailerOwnerFilter = [['key' => 'id', 'val' => $trailer_owner_id]];
        $trailerOwner_qry = $this->_truckOwnerCore->searchTruckOwner($trailerOwnerFilter, 1, 0, $user_id);

        if ($trailerOwner_qry->found_rows == 0) {
            $carrier_node->trailer_owner->name = $trailerOwner_qry->data[0]->name;
        } else {
            $carrier_node->trailer_owner->name = null;
        }

        $carrier_node->tc = new stdClass();
        $carrier_node->tc->id = $trucking_company_id;
        $truckingCompanyFilter = [['key' => 'id', 'val' => $trucking_company_id]];
        $truckingCompany_qry = $this->_truckCompanyCore->searchTruckingCompany($truckingCompanyFilter, 1, 0, 0); // search by system

        if ($truckingCompany_qry->found_rows == 0) {
            throw new Exception("WBL003 - invalid trucking_company_id");
        }
        $carrier_node->tc->name = $truckingCompany_qry->data[0]->name;
        $carrier_node->tc->logo = extractLogo($truckingCompany_qry->data[0]->photos);

        // get the truck owner id
        $companyID = $truckingCompany_qry->data[0]->company_id;
        $truckCompanyOwnerFilter = [['key' => 'company_id', 'val' => $companyID]];
        $truckCompanyOwner_qry = $this->_truckOwnerCore->searchTruckOwner($truckCompanyOwnerFilter, 1, 0, $user_id);
        $carrier_node->tc->tc_owner_id = $truckCompanyOwner_qry->data[0]->id;

        $waybill_json->carrier = [$carrier_node];

        // ----------------- waybill_captions ----------------
        $waybill_captions_node = new stdClass();
        $waybill_json->waybill_captions = $tenderBean->manifest->waybill_captions;

        // ----------------- negotiable_instructios ----------
        $negotiable_instructios_node = new stdClass();
        $negotiable_instructios_node->route = new stdClass();
        $negotiable_instructios_node->route->origin = new stdClass();
        $negotiable_instructios_node->route->destination = new stdClass();
        $negotiable_instructios_node->freight = new stdClass();
        $negotiable_instructios_node->special = new stdClass();
        $negotiable_instructios_node->insurance = new stdClass();
        $negotiable_instructios_node->dangerous_goods = new stdClass();
        $negotiable_instructios_node->route->origin->id = $origin_id;

        if ($origin_id == "") {
            throw new Exception("WBL004 - inavalid origin_id");
        }
        $originBean = $this->_locationCore->getBasicLocation($origin_id, 0);

        if ($originBean == null) {
            throw new Exception("WBL005 - inavalid origin_id");
        }
        $negotiable_instructios_node->route->origin->name = $originBean->name;

        $negotiable_instructios_node->route->remarks = null;

        $negotiable_instructios_node->route->destination->id = $destination_id;
        $destinationBean = $this->_locationCore->getBasicLocation($destination_id, 0);
        if ($destinationBean == null) {
            throw new Exception("WBL005 - inavalid destination_id");
        }
        $negotiable_instructios_node->route->destination->name = $destinationBean->name;

        $negotiable_instructios_node->freight->remarks = $cargo_Bean->waybill_template->negotiable_instructios->freight->remarks;
        $negotiable_instructios_node->special->remarks = $cargo_Bean->waybill_template->negotiable_instructios->special->remarks;
        $negotiable_instructios_node->insurance->remarks = $cargo_Bean->waybill_template->negotiable_instructios->insurance->remarks;
        $negotiable_instructios_node->dangerous_goods->remarks = $cargo_Bean->waybill_template->negotiable_instructios->dangerous_goods->remarks;

        $waybill_json->negotiable_instructios = $negotiable_instructios_node;

        // --------------------------- Tender -------------------
        $tender_node = new stdClass();
        $man = $this->_tenderCore->getTenderManifest($tender_id, 0);
        $tender_node->id = $tender_id;
        $tender_node->name = $man['name'];
        $waybill_json->tender = $tender_node;

        // ----------------- ltrc section -------------------------
        if ($man['ltrc']['submit_waybill']) {
            $ltrc_node = new stdClass();
            $ltrc_node->docnum = null;
            $ltrc_node->submit_waybill = false;
            $ltrc_node->waybill_status = null;
            $waybill_json->ltrc = $ltrc_node;
        }

        // ---------------- payment_delay --------------------------

        $payment_method = $man['freight']['payment_method']['method'];
        if ($payment_method == "schedule") {

            // get the payment_delay from the tender_truck
            $tenderTruckSearchFilter = [
                ['key' => 'tender_id', 'val' => $tender_id],
                ['key' => 'truck_id', 'val' => $truck_id],
                ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in']
            ];
            $tenderTruck = $this->_tenderCore->searchTenderTruck($tenderTruckSearchFilter, 1, 0, 0);
            $tenderTruck = $tenderTruck->data[0];

            $payment_delay = new stdClass();
            if ($tenderTruck->financial_details) {
                $financial_details = json_decode($tenderTruck->financial_details);
                $payment_delay = $financial_details->payment_delay;
            }

            if (!$payment_delay) {
                // in case no payment delay , take it from tender manifest
                foreach ($man['freight']['payment_method']['payment_delay'] as $tender_payment_delay) {
                    if ($tender_payment_delay['is_default']) {
                        $payment_delay = (object) $tender_payment_delay;
                    }
                }
            }

            if (!$payment_delay) {
                throw new Exception("payment_delay is not defined");
            }
            $waybill_json->payment_delay = $payment_delay;
        }

        // in case the company has queue service, save the queue info
        $tenderCompanyActiveStatus = DBConnection::getActiveStatus('tender_company');
        $tenderCompanyFilter = [
            ['key' => 'trucking_company_id', 'val' => $trucking_company_id],
            ['key' => 'status', 'val' => $tenderCompanyActiveStatus, 'op' => 'in']
        ];
        $tenderCompaniesReuslt = DBConnection::searchDB("tender_company", $tenderCompanyFilter, 1, 0, $user_id);
        // if the tender company has service ("QUEUE"), see the re-create queue status from manifest
        $service_list = $tenderCompaniesReuslt->data[0]->service_list;
        $service_list = json_decode($service_list);

        if ($service_list) {
            foreach ($service_list as $service) {
                if ($service->code == 'DISPATCH' && $service->type == 'QUEUE') {
                    $queue_node = new stdClass();
                    $queue_node->id = $queue_id;
                    $queue_node->name =  $man['queues'][$queue_id]['name'];
                    $waybill_json->queue = $queue_node;
                }
            }
        }

        $order_node = new stdClass();
        $order_node->id = $order_id;
        $waybill_json->order = $order_node;
        // ----------------------generate Freight Node ------------------------//
        $freightNode = $this->createFreightNode($waybillBean);
        $waybill_json->freight = $freightNode;
        $waybill_json->activities = [];
        // ----------------------nafith wn ------------------------//
        if ($nafith_wn) {
            $waybill_json->nafith_wn = $nafith_wn;
        }
        // -------------------------------------------------------------//

        // insert new waybill in database
        $waybillBean = new stdClass();
        $waybillBean->document = json_decode(json_encode($waybill_json));

        // insert waybill
        $createWaybillResult = DBConnection::insertDB("waybill", $waybillBean, 0);

        // get the newly created waybill id
        $createWaybillResultQry = $createWaybillResult[0];
        $waybill_id =  $createWaybillResultQry['@id'];
        $waybillResult = new stdClass();
        $waybillResult->id = $waybill_id;
        $waybillResult->wn = $waybill_json->wn;

        //------------------log activity----------------------
        $this->logActivity($waybill_id, "إنشاء مستند", " رقم " .  $waybill_json->wn, "create", $user_id);

        // ---------------- write post on driver and truck_owner wall --------------
        $socialCore = new SocialCore();
        $title = "انشاء مستند شحن";
        $msg = "تم تثبيت وصول الشاحنة " . $waybill_json->carrier[0]->truck->tn . "+" . $waybill_json->carrier[0]->trailer->tn . " " .
            "وانشاء المستند رقم: $waybill_json->wn - " .
            "الحمل: " . $waybill_json->cargo[0]->name . " - الشركة: " . $waybill_json->carrier[0]->tc->name;
        if ($driver_id) {
            $driver_user_id = $this->_driverCore->getDriverBasic($driver_id, 0)->user_id;
            $socialCore->createWallEntry($driver_user_id, $title, $msg);
        }
        if ($owner_user_id) {
            $owner_user_id =  $this->_truckOwnerCore->getTruckOwnerBasic($truck_owner_id, 0)->user_id;
            if ($owner_user_id && $owner_user_id != $driver_user_id) {
                $socialCore->createWallEntry($owner_user_id, $title, $msg);
            }
        }

        // ------------- Add watchers to monitor any action on the waybill , if it stays NEW after 24 hour , open ticket -------------------
        if ($tender_id == 3 || $tender_id == 13 || $tender_id == 11 || $tender_id == 12 || $tender_id == 15) {
            (new ObjectWatcherCore())->createWatcher("WAYBILL", $waybill_id, "NEW");
        }

        // ------------------------------------- Add Cargo Policy record in case the cargo has ca ----------------------------------- //
        // ---------------------------- Cargo Policy here store (cargo_id + waybill_id) in order to generate SN --------------------- //
        if ($cargo_Bean->ca_id) {
            $cargoPolicyBean = new stdClass();
            $cargoPolicyBean->waybill_id  = $waybill_id;
            $cargoPolicyBean->cargo_id  = $cargo_id;
            $cargo_policy_id = $this->_cargoCore->createCargoPolicy($cargoPolicyBean, 0);

            if ($cargo_policy_id) {
                // add new integration node in waybill document to store Cargo Policy info
                $cargoPolicyBean = $this->_policyCore->getCargoPolicy($cargo_policy_id, 0);
                if (!$waybillBean->document->integeration_details) {
                    $waybillBean->document->integeration_details = new stdClass();
                }
                $waybillBean->document->integeration_details->cargo_policy = new stdClass();
                $waybillBean->document->integeration_details->cargo_policy->id = $cargoPolicyBean->id;
                $waybillBean->document->integeration_details->cargo_policy->serial_number = $cargoPolicyBean->serial_number;
                $this->updateWaybill($waybillBean, $waybillBean->id, 0);
            }
        }
        return $waybillResult;
    }


    // ---------------------------------------------------------------------- //
    // ---------------------- Change waybill status-------------------------- //
    // ----- NEW      : Upon Create the waybill ----------------------------- //
    // ----- APPROVED : Upon carrier approval ------------------------------- //
    // ----- ACTIVE   : Upon print ------------------------------------------ //
    // ----- PENDING  : Upon arrival to loading location -------------------- //
    // ----- ONROAD   : Upon leaving loading location ----------------------- //
    // ----- ARRIVED  : Upon arrival to discharge location ------------------ //
    // ----- CLOSED   : Upon leaving discharg location ---------------------- //
    // ----- COMPLETE : Upon receiving payment ------------------------------ //
    // ---------------------------------------------------------------------- //
    public function changeStatus($id, $new_status, $user_id, $advancePaymentsValues = null, $extraFees = null)
    {

        // ------------------------------ PART 0: init objects ---------------------------------------------------
        $paymentCore = new PaymentCore();
        $tenderCompanyCore = new TenderCompanyCore();
        $tenderCompanyCore = new TenderCompanyCore();
        $queueCore = new QueueCore();


        $waybillBean = $this->getWaybillBasic($id, $user_id);

        //-------------------- get company services --------------------------------------------------------------
        $trucking_company_id = $waybillBean->trucking_company_id;
        $tender_id = $waybillBean->document->tender->id;
        $tenderManafist = $this->_tenderCore->getTenderManifest($tender_id, 0);

        $service_list = $tenderCompanyCore->getTenderCompanyServices($trucking_company_id, $tender_id);
        $hasPaymentService = $tenderCompanyCore->hasPaymentService($tender_id, null, $trucking_company_id);

        // ---------------- PART 1: TODO: waybill number generation process --------------------------------------------

        // if($new_status === "ACTIVE" && $tenderManafist['tender_code']=='GRAINS'){
        //     if(!$waybillBean->document->first_trip || !$waybillBean->document->first_trip->type){
        //         throw new Exception("معلومات الرحلة الأولى غير موجودة");
        //     }
        // }


        // ---------------- PART 2: Re-Queue process -----------------------------------------------------------------
        $re_create_Queue_Old_status = 'NEW';
        $re_create_Queue_status = 'APPROVED';
        if ($new_status == $re_create_Queue_status && $waybillBean->status == $re_create_Queue_Old_status) {

            // validate if the destination_id is defined and not JORDAN
            if ($waybillBean->document->negotiable_instructios->route->destination->id == 91000000) {
                //throw new Exception(" لا تستطيع تفعيل المستند بسبب عدم تحديد الوجهة ");
            }

            if ($waybillBean->document->carrier[0]->driver->id == null) {
                throw new Exception(" لا تستطيع تفعيل المستند بسبب عدم تحديد السائق ");
            }

            // validate if the driver is black listed in Jo_petrol system'
            if ($tender_id == 11) {
                $nn = $waybillBean->document->carrier[0]->driver->nn;
                $jo_petrol_integration = new Jo_Petrol();
                $jo_petrol_driver = $jo_petrol_integration->QueryOnDriverStatus($nn);
                if ($jo_petrol_driver['status'] == "ACTIVE") {
                    $msg = "لا تستطيع المتابعة ، السائق مضاف على قائمة المنع في المصفاة";
                    $msg .= " - السبب:" . $jo_petrol_driver['reason'];
                    $msg .= " - تاريخ الانتهاء:" . $jo_petrol_driver['black_list_end_date'];
                    throw new Exception($msg);
                }
            }

            if ($service_list) {
                foreach ($service_list as $service) {
                    if ($service->code == 'DISPATCH' && $service->type == 'QUEUE') {

                        // get the tender manifest
                        $tender_id = $waybillBean->document->tender->id;
                        $man = $this->_tenderCore->getTenderManifest($tender_id, 0);

                        // get the tender order
                        if (!$waybillBean->order_id) {
                            throw new Exception("طلبية المستند غير صحيحة");
                        }
                        $orderBean = $this->_tenderCore->getTenderOrderBasic($waybillBean->order_id, 0);

                        // get the requeue method using the order or queue info from waybill
                        if ($orderBean)
                            $requeue_method = $man['queues'][$orderBean->q_id]['requeue_rules']['method'];
                        if (!$requeue_method) {
                            $requeue_method = $man['queues'][$waybillBean->document->queue->id]['requeue_rules']['method'];
                        }
                        // in case no requeue method is defined , skip all
                        if (!$requeue_method) continue;

                        switch (strtoupper($requeue_method)) {
                            case 'QUEUE':

                                $target_queue = $man['queues'][$orderBean->q_id]['requeue_rules']['target_queue'];
                                if (!$target_queue) {
                                    $target_queue = 1; // TODO
                                }

                                // get the trailer from the tender_truck
                                $tenderTruckSearchFilter = [
                                    ['key' => 'tender_id', 'val' => $orderBean->tender_id],
                                    ['key' => 'truck_id', 'val' => $waybillBean->truck_id],
                                    ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in']
                                ];
                                $tenderTruck = $this->_tenderCore->searchTenderTruck($tenderTruckSearchFilter, 1, 0, 0);
                                $tenderTruck = $tenderTruck->data[0];

                                // re-create the queue again
                                $addQueueId = $queueCore->addQueue(
                                    $waybillBean->truck_id,
                                    $waybillBean->driver_id,
                                    $tenderTruck->trailer_id,
                                    $target_queue,
                                    $orderBean->tender_id,
                                    0
                                );

                                // write new queue info
                                $newQueueBean = $queueCore->getQueuebasic($addQueueId, 0);
                                $integeration_details = $waybillBean->document->integeration_details;
                                if (!$integeration_details) {
                                    $integeration_details = new stdClass();
                                }
                                if (!$integeration_details->queue) {
                                    $integeration_details->queue = new stdClass();
                                }
                                $integeration_details->queue->new_queue_rank = $newQueueBean->rank;
                                $integeration_details->queue->new_serial = $newQueueBean->serial;
                                $integeration_details->queue->q_id = $newQueueBean->q_id;
                                $waybillBean->document->integeration_details = $integeration_details;
                                $this->updateWaybill($waybillBean, $id, 0);
                                break;

                            case 'NONE':
                                // do nothing
                                break;

                            default:
                                throw new Exception("INVALID QUEUE REQUEUE");
                                break;
                        }
                    }
                }
            }
            $this->logActivity($id, "تأكيد وصول", "", "check", $user_id);
        }

        // ---------------- PART 3: FROM ACTIVE TO APPROVED process -----------------------------------------------------------------
        $re_old_status = 'ACTIVE';
        $re_new_status = 'APPROVED';

        if ($new_status == $re_new_status && $waybillBean->status == $re_old_status) {
            $this->logActivity(
                $id,
                "إعادة المستند الى تمت الموافقة",
                "",
                "RE_APPROVED",
                $user_id
            );
        }

        // ---------------- in case the truck has active quueue on Itihad, remove it -----------------------------------------------------------------
        $remove_from_yard_new_status = 'ONROAD';
        if ($new_status == $remove_from_yard_new_status) {

            try {
                // search for yard queue
                $man = $this->_tenderCore->getTenderManifest($waybillBean->tender_id, 0);
                $queues = $man['queues'];
                foreach ($queues as $q) {
                    if ($q['type'] == 'yard') {

                        // search if the truck is still in Itihad queue
                        $activeQueueStatus = DBConnection::getActiveStatus('queue');
                        $queueSearchFilter = [
                            ['key' => 'truck_id', 'val' => $waybillBean->truck_id],
                            ['key' => 'q_id', 'val' => $q['id']],
                            ['key' => 'tender_id', 'val' => $tender_id],
                            ['key' => 'status', 'val' => $activeQueueStatus, 'op' => 'in']
                        ];
                        $queueTruckResult = $queueCore->searchQueue($queueSearchFilter, 1, 0, 0);

                        // remove from yard
                        if ($queueTruckResult->found_rows) {
                            $queueCore->changeStatus($queueTruckResult->data[0]->id, 'CLOSED', 0);
                        }
                    }
                }
            } catch (Exception $e) {
            }

            // -------------------------------------------------------------------------------------
        }



        // ---------------- PART 4: close waybill and process the financial procedure ---------------------------------
        if ($hasPaymentService) {
            $e_payment_status = 'COMPLETE'; // TODO
            if ($new_status == $e_payment_status) {
                $waybillBean = $this->getWaybillBasic($id, $user_id);

                if ($tender_id != 11 && $tender_id != 12  && $tender_id != 17) {
                    throw new Exception("لا تستطيع المتابعة ، لا يوجد خدمة دفع للمشروع");
                }

                if (!$this->validateExtraDeductionMaximumValue($tenderManafist, $extraFees)) {
                    throw new Exception("قيمة الاقتطاع الاضافية يجب ان لا تتجاوز الحد المطلوب");
                }
                $this->completeWaybill($waybillBean, $user_id, $extraFees);
            }
        }


        // ---------------- PART 5: update waybill status --------------------------------------------------
        $updateBean = new stdClass();
        $updateBean->id = $id;
        $updateBean->status = $new_status;
        DBConnection::updateDB("waybill", $updateBean, $user_id);


        // --------------------------------- Integration Part -------------------------------------- //
        $jo_petrol_integration = new Jo_Petrol();
        $grains = new Grains();

        $waybill_json = $waybillBean->document;
        $tn = $waybill_json->carrier[0]->truck->tn;

        switch ($new_status) {
            case 'ACTIVE':
                // Fuel integeration
                if ($tenderManafist['tender_code'] == 'JO_PETROL_FUEL') {

                    $jo_petrol_integration = new Jo_Petrol();
                    $jo_petrol_integration->insertWaybill($waybillBean);

                    $this->logActivity(
                        $waybillBean->id,
                        "ترحيل ارسالية",
                        "تم ترحيل الإرسالية الى نظام مصفاة البترول بنجاح",
                        "check",
                        $user_id
                    );
                }

                //Crude oil integeration
                if ($tenderManafist['tender_code'] == 'JO_PETROL_AQ') {
                    //transfer waybill record to Jo_Petrol System
                    $jo_petrol_integration->insertWaybill($waybillBean);

                    $this->logActivity(
                        $waybillBean->id,
                        "ترحيل ارسالية",
                        "تم ترحيل الإرسالية الى نظام مصفاة البترول بنجاح",
                        "check",
                        $user_id
                    );
                }

                //grains integeration
                if ($tenderManafist['tender_code'] == 'GRAINS') {
                    // //transfer waybill record to grains System
                    // $taskQueuesCore = new TaskQueuesCore();
                    // $taskQueuesCore->createInsertGrainsWaybillTask($waybillBean->id ,1 , 1);

                    // create task to check for grains loading time
                    $taskQueuesCore = new TaskQueuesCore();
                    $trial = 1;
                    $delay = 3600; // 1 hour
                    //$taskQueuesCore->createGetGrainsWaybillInfoTask($waybillBean->id, $trial, $delay);
                }


                //grains or Vessels , then send SMS that user can get money from wataniah stations

                if ($tenderManafist['tender_code'] == 'GRAINS' || $tenderManafist['tender_code'] == 'VESSELS') {
                    $driver_phone = $waybill_json->carrier[0]->driver->phone;

                    $messageRecipient = $driver_phone;
                    $message = "تستطيع صرف المستند في محطات الوطنية المعتمدة https://bit.ly/3HD9KKj";
                    $messageRecipient = convertToInternational($messageRecipient);
                    //sendSMS($messageRecipient, $message);
                }
                break;
        }


        // ---------------- PART 6: advance payment process -------------------------------------------------
        if ($hasPaymentService) {
            $advancePayments = $paymentCore->generateWaybillAdvancePaymentNode($id);
            if ($advancePayments) {

                // loop on advance payments to see if any value is editable by user and the value is not yet provided
                foreach ($advancePayments as $payment) {
                    $this->addAdvancePayment($waybillBean, $payment);
                }
            }
        }

        // ----------------- Part 7: LTRC enable/disable -----------------------------------------------------
        $man = $this->_tenderCore->getTenderManifest($waybillBean->document->tender->id, 0);

        if ($man['ltrc'] && $man['ltrc']['submit_waybill']) {
            if ($new_status == 'ACTIVE') {
                $newWaybill = new stdClass();
                $newWaybill->ltrc = new stdClass();
                $newWaybill->ltrc->docnum = null;
                $newWaybill->ltrc->submit_waybill = true;
                $newWaybill->ltrc->waybill_status = null;
                $newWaybill->id = $waybillBean->id;
                $this->updateWaybill($newWaybill, $waybillBean->id, $user_id);
            } else {
                try {
                    DBConnection::has_authority($user_id, "WAYBILL", "UPDATE", $new_status, $new_status);
                    if ($waybillBean->document->ltrc) {
                        $ltrcNode = new stdClass();
                        $ltrcNode->ltrc = new stdClass();
                        $ltrcNode->ltrc->docnum = $waybillBean->document->ltrc->docnum;
                        $ltrcNode->ltrc->submit_waybill = false;
                        $ltrcNode->ltrc->waybill_status = $waybillBean->document->ltrc->waybill_status;
                        $ltrcNode->id = $waybillBean->id;
                        $this->updateWaybill($ltrcNode, $waybillBean->id, $user_id);
                    }
                } catch (Exception $e) {
                }
            }
        }


        // --------------- Part 8 : Reserved Queue -------------------------------------------------------------
        if ($tenderManafist['tender_code'] == 'GRAINS') {
            if ($new_status == "PENDING") {
                $queueCore = new QueueCore();
                $queueCore->requeueOnReservedQueue($waybillBean);
            }
        }

        // ------------- Add watchers if applicable -------------------------------------------------------------
        if ($tender_id == 3 || $tender_id == 13 || $tender_id == 11 || $tender_id == 12 || $tender_id == 15) {
            // (new ObjectWatcherCore())->createWatcher("WAYBILL", $id, $new_status);
        }

        $customerCare = new CustomerCare();

        // cancel waybill_loading_delay if truck arrived to loading destination
        if ($new_status === 'ONROAD') {
            //cancel ticket with this waybill
            // $ticket_filter = array("data->body->waybill_id" => $id, "request->type_code" => "WAYBILL_LOADING_DELAY");
            // $ticket = $customerCare->searchTickets($ticket_filter, 1, 1000);
            // if (sizeof($ticket['data']) > 0) {
            //     foreach ($ticket['data'] as $ticketObj) {
            //         $ticket_id = $ticketObj['id'];

            //         if ($ticketObj['status'] != 'CANCELED')
            //             $customerCare->changeStatus($ticket_id, 'CANCELED');
            //     }
            // }
        }
        // cancel waybill_no_action ticket if waybill approved
        if ($new_status === 'APPROVED') {
            //cancel ticket with this waybill
            // $ticket_filter = array("data->body->waybill_id" => $id, "request->type_code" => "WAYBILL_NO_ACTION");
            // $ticket = $customerCare->searchTickets($ticket_filter, 1, 1000);
            // if (sizeof($ticket['data']) > 0) {
            //     foreach ($ticket['data'] as $ticketObj) {
            //         $ticket_id = $ticketObj['id'];

            //         if ($ticketObj['status'] != 'CANCELED')
            //             $customerCare->changeStatus($ticket_id, 'CANCELED');
            //     }
            // }
        }
    }

    // ------------------------------------------------------------------------------------------------------------- //
    // ---------------------- complete waybill and process its financial procedure ------------------------------------ //
    // ------------------------------------------------------------------------------------------------------------- //
    private function completeWaybill($waybillBean, $user_id, $extraFees)
    {


        // init objects
        $paymentCore = new PaymentCore();
        $trxCore = new TrxCore();
        $accountCore = new AccountCore();
        $userCore = new UserCore();
        $paymentAgentCore = new PaymentAgentCore();
        $queueCore = new QueueCore();
        $u_id = DBConnection::getUserIdFromSession($user_id);

        // get the tender manifest
        $man = $this->_tenderCore->getTenderManifest($waybillBean->document->tender->id, 0);

        // calculate the freight and the deductions
        $freight_node = $waybillBean->document->freight;

        //update the waybillBean with the company_id that completed the waybill
        $userBean = $userCore->getUserBasic($u_id, 0);
        $paFilter = [
            ['key' => 'company_id', 'val' => $userBean->company_id],
            ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in']
        ];
        $pa_qry = $paymentAgentCore->searchPaymentAgents($paFilter, 1, 0, 0);
        if ($pa_qry->found_rows == 0) {
            //throw new Exception(" لاتستطيع المتابعة، لا يوجد مكتب صرف معرف على حسابك");
        }

        $ar_sub_id = 2 . str_pad($waybillBean->document->carrier[0]->tc->id, 4, "0", STR_PAD_LEFT);
        $tc_name = $waybillBean->document->carrier[0]->tc->name;
        $paAccountFilter = [
            ['key' => "company_id", 'val' => 266770],
            ['key' => "status", 'val' => 'ACTIVE'],
            ['key' => "type", 'val' => 'AR'],
            ['key' => "sub_id", 'val' => $ar_sub_id]
        ];

        $pa_account_qry = $accountCore->searchAccount($paAccountFilter, 1000, 0, 0);
        if ($pa_account_qry->found_rows == 0) {
            //throw new Exception("لا تستطيع المتابعة ، لا يوجد حساب مطالبة مع شركة $tc_name");
        }

        $waybillBean->document->freight->pa = new stdClass();
        $waybillBean->document->freight->pa->id = $pa_qry->data[0]->id;
        $waybillBean->document->freight->pa->company_id = $pa_qry->data[0]->company_id;
        $waybillBean->document->freight->pa->company_name = $pa_qry->data[0]->name;

        //update JSON in waybill
        $updatedWaybill = new stdClass();
        $updatedWaybill->id = $waybillBean->id;
        $updatedWaybill->document = $waybillBean->document;
        DBConnection::updateDB("waybill", $updatedWaybill, 0);

        // ------------------------ complete waybill Payment  ------------------------------- //

        // take the payment method from the tender
        $tender_id = $waybillBean->document->tender->id;
        $payment_method = $man['freight']['payment_method']['method'];

        // if no payment method is defined , throw exception
        if (!$payment_method) {
            throw new Exception("لا تستطيع المتابعة ، لم يتمكن النظام من تحديد اليه تسديد المستند");
        }

        // Method 1: (jv_payment_agent) pay the amount by jv ledger
        if ($payment_method == "jv_payment_agent") {

            // get the tenderTruck financial info
            $tender_id = $waybillBean->document->tender->id;
            $truck_id = $waybillBean->truck_id;
            $tenderTruckSearchFilter = [
                ['key' => 'tender_id', 'val' => $tender_id],
                ['key' => 'truck_id', 'val' => $truck_id],
                ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in']
            ];
            $tenderTruckQry = $this->_tenderCore->searchTenderTruck($tenderTruckSearchFilter, 1, 0, 0);
            $tenderTruck = $tenderTruckQry->data[0];

            // if the finaicial details is not defined , throw exception
            if (!$tenderTruck->financial_details) {
                throw new Exception("لا تستطيع المتابعة ، المعلومات المالية للشاحنة غير مكتملة");
            }
            $financial_details = json_decode($tenderTruck->financial_details);
            if (!$financial_details->payment_channel || $financial_details->payment_channel == "none") {
                throw new Exception("لا تستطيع المتابعة ، المعلومات المالية للشاحنة غير مكتملة");
            }

            // TODO
            //$extraFees = $this->calculateExtraFees($waybillBean, $waybillBean->tender_id , 'LOADING_DATE_DELAY');

            // create Waybill voucher
            $waybill_net_amount = $waybillBean->document->freight->amount->net_amount;
            $from_account = $waybillBean->document->freight->assets_account_id;
            $to_account = $financial_details->waybill_beneficiary_account . "-0";

            $value = new stdClass();
            $voucherCore = new VoucherCore();
            $value->amount = $waybill_net_amount;
            $clientPayment = (object) array(
                "name" => "WAYBILL_PAYMENT",
                "label" => 'قيد مستحقات',
                "target_account" => $to_account,
                "time_stamp" => DBConnection::getSystemDate(),
                "value" => $value
            );

            $clientPayment->check_number = $waybillBean->document->freight->check_number;

            $company_name = $waybillBean->document->carrier[0]->tc->name;
            $tn = $waybillBean->document->carrier[0]->truck->tn;

            $voucherNotes = "مستحقات المستند $waybillBean->wn " . " - " . $company_name . " - " . $tn;
            $payment_method = $financial_details->payment_channel;

            // add new payment to truck claim in case it has
            $fps_claim_core = new Fps_claim_core();
            $truck_owner_id = $waybillBean->document->carrier[0]->truck_owner->id;
            $fps_claim_core->addPaymentToTruckOwnerClaim($waybill_net_amount, $truck_owner_id, "سداد قيمة السلفة من رحلة المستند رقم " . $waybillBean->wn, 0);

            // in the case of tender 11 , use the new fps voucher
            if ($waybillBean->tender_id == 11) {
                $fps_voucher = new Fps_voucher_core();
                $voucherResult = $fps_voucher->createWaybillCompletetVoucher($waybillBean->id, $user_id);

                $targetAccountBean = $accountCore->getAccountBasic($to_account, 0);
                $this->logActivity(
                    $waybillBean->id,
                    "اغلاق مستند الشحن وانشاء أمر صرف مستحقات ",
                    "القيمة : " . $voucherResult['voucher_amount'] . " دينار ، " . " أمر الصرف رقم :" . $voucherResult['voucher_id'] . " - المستفيد: " . $voucherResult['recipient_name'],
                    "WAYBILL_PAYMENT",
                    $user_id
                );

                //append the item to Nafith claim
                $fps_claim_core->createARClaimWithProjectOwner($waybillBean->id, $user_id);

                // generate feedback poll in case the user has downpayment on this waybill queue
                // $fps = new FPS();
                // // $queue_id = $waybillBean->document->integeration_details->queue->queue_id;
                // $filter = ['waybill_id' => $waybillBean->id, 'status' => 'COMPLETE'];
                // $data = new stdClass();
                // $data->filter = json_encode($filter);
                // $voucherResult = $fps->searchVouchers($data, $user_id);
                // foreach ($voucherResult['data'] as $voucher) {
                //     if ($voucher['voucher_type_code'] == "DOWNPAYMENT") {
                //         $pollIntegration = new Poll();
                //         $financialManagerUserBean = $this->_tenderCore->getFinancialManagerUserBean($waybillBean->truck_id, $waybillBean->tender_id, 0);
                //         $pollIntegration->GenerateDownPaymentFeedbackPoll($tn, $financialManagerUserBean->id);
                //         break;
                //     }
                // }
            } else {
                $voucher_id = $voucherCore->createVoucher(
                    $from_account,
                    $to_account,
                    $waybill_net_amount,
                    strtoupper($payment_method),
                    $clientPayment,
                    null,
                    'WAYBILL',
                    $waybillBean->id,
                    $voucherNotes,
                    $waybillBean->tender_id
                );

                $targetAccountBean = $accountCore->getAccountBasic($to_account, 0);
                $this->logActivity(
                    $waybillBean->id,
                    "اغلاق مستند الشحن وانشاء أمر صرف مستحقات ",
                    "القيمة : " . $waybill_net_amount . " دينار ، " . " أمر الصرف رقم :" . $voucher_id . " - المستفيد: " . $targetAccountBean->name,
                    "WAYBILL_PAYMENT",
                    $user_id
                );
            }

            //activate the other queues if the truck has more than one
            $q_id = $waybillBean->document->integeration_details->queue->q_id;
            $queuesToActivateSearchFilter = [
                ['key' => 'truck_id', 'val' => $waybillBean->truck_id],
                ['key' => 'status', 'val' => 'HELD'],
                ['key' => 'tender_id', 'val' => [$waybillBean->tender_id], 'op' => 'not in'],
                ['key' => 'q_id', 'val' => [$q_id], 'op' => 'not in']
            ];

            $queuesToActivate = $queueCore->searchQueue($queuesToActivateSearchFilter, 1000, 0, 0)->data;
            // iterate and change status to ACTIVE for each queue
            foreach ($queuesToActivate as $queue) {
                $queueCore->changeStatus($queue->id, 'ACTIVE', 0);
                $queueCore->logActivity($queue->id, "فك تجميد الدور", "تم فك تجميد الدور", "activate_queue", 0);
            }
        } else {
            throw new Exception("لا تستطيع المتابعة ، لم يتمكن النظام من تحديد اليه تسديد المستند");
        }
    }
    //-------------------------------------------------------------------------------
    //---------------validate Maximum Extra Fees from tender manifest-----------------
    //--------------------------------------------------------------------------------

    private function validateExtraDeductionMaximumValue($manafist, $extraDeductionValue)
    {
        if (!$extraDeductionValue) {
            return true;
        }
        if ($manafist['freight']['payment_method']["extra_fees"]['maximum_extra_fees'] >= $extraDeductionValue->extra_fees_value) {
            return true;
        } else {
            return false;
        }
    }

    // -------------------------------------------------------------------------------------------- //
    // -------------------update weight in waybill bean then try to set the net weight ------------ //
    // -------------------------------------------------------------------------------------------- //
    public function updateWeight($waybillBean, $user_id)
    {

        // init objects
        $tenderCompanyCore = new TenderCompanyCore();
        $routeWageCore = new RouteWageCore();

        // Validate if the updateWeight process is allowed and valid
        $this->validateWeighing($waybillBean->id);

        // validate the weight is not lager than 5 digits
        if ($waybillBean->document->cargo[0]->weights->discharge->net_weight) {
            if (intval($waybillBean->document->cargo[0]->weights->discharge->net_weight) > 99999) {
                throw new Exception("لا تستطيع المتابعة ، وزن التفريغ أكبر من الحد المسموح به");
            }
        }
        if ($waybillBean->document->cargo[0]->weights->loading->net_weight) {
            if (intval($waybillBean->document->cargo[0]->weights->loading->net_weight) > 99999) {
                throw new Exception("لا تستطيع المتابعة ، وزن التحميل أكبر من الحد المسموح به");
            }
        }

        // start to work on the cargoJSON node
        $cargoJSON = $waybillBean->document->cargo[0];

        // update (total) net weight in document
        if ($cargoJSON->weights->discharge->net_weight && $cargoJSON->weights->loading->net_weight) {
            $totalNetWeight = $cargoJSON->weights->discharge->net_weight - $cargoJSON->weights->loading->net_weight;
            $cargoJSON->weights->net_weight = $totalNetWeight;
            $waybillBean->document->cargo[0] = $cargoJSON;
        }

        DBConnection::updateDB("waybill", $waybillBean, $user_id);
    }

    // --------------------------------------------------------------------------------------------- //
    // --------------------- Validate if the set weight process is allowed and valid --------------- //
    // --------------------------------------------------------------------------------------------- //
    private function validateWeighing($waybill_id)
    {

        // get waybill bean
        $waybillBean = $this->getWaybillBasic($waybill_id, 0);

        // validate if the waybill weights is locked if the waybill is added to an active tender_claim
        if (isset($waybillBean->document->tender_claim)) {
            $tender_claim = $waybillBean->document->tender_claim;
            if ($tender_claim && $tender_claim->status_for_re_weight == "LOCKED") {
                throw new Exception("لا تستطيع تعديل الوزن حيث ان المستند مضاف على مطالبة مالية فعالة");
            }
        }
    }


    // ------------------------------------------------------------------------------------- //
    // ------------------- Change destination id for a certain waybill --------------------- //
    // ------------------------------------------------------------------------------------- //
    public function changeRoute($waybill_id, $destination_id, $user_id)
    {

        // get the waybill bean
        $waybillBean = $this->getWaybill($waybill_id, $user_id);
        $waybillBean = json_decode($waybillBean);

        // TODO: in case the waybill is ARRIVED

        // get the name old and new route destination
        $routeBean = $waybillBean->document->negotiable_instructios->route;
        // if the new location is same as old, do nothing
        if ($routeBean->destination->id == $destination_id) {
            return;
        }

        $old_location = "-";
        if ($routeBean->destination && $routeBean->destination->id) {
            $old_location = $this->_locationCore->getLocationBasic($routeBean->destination->id, $user_id)->name;
        }
        $new_location = $this->_locationCore->getLocationBasic($destination_id, $user_id)->name;

        // update the destination_id
        $routeBean = $waybillBean->document->negotiable_instructios->route;
        $destinationNode = new stdClass();
        $destinationNode->id = $destination_id;
        $destinationNode->name = $new_location;

        $routeBean->destination = $destinationNode;
        // create new route remark object
        $u_id = DBConnection::getUserIdFromSession($user_id);
        $route_remark = new stdClass();
        $route_remark->type = 'CHANGE_ROUTE';
        $route_remark->notes = ' تم تغير موقع التفريغ من ' . $old_location . ' الى ' . $new_location;
        $route_remark->timestamp = date("Y-m-d") . " " . date("h:i:s");
        $route_remark->user_id = $u_id;

        if ($routeBean->remarks) {
            array_push($routeBean->remarks, $route_remark);
        } else {
            $remarks = [];
            array_push($remarks, $route_remark);
            $routeBean->remarks = $remarks;
        }

        //update the route node in document
        $waybillBean->document->negotiable_instructios->route = $routeBean;

        $updatedWaybillBean = new stdClass();
        $updatedWaybillBean->document = $waybillBean->document;
        $updatedWaybillBean->id = $waybill_id;

        DBConnection::updateDB("waybill", $updatedWaybillBean, $user_id);
        $this->logActivity($waybill_id, "تغيير الوجهة", 'تم تغير موقع التفريغ من ' . $old_location . ' الى ' . $new_location, "change_route", $user_id);

        // send notification to operation manager in case the new route does not have route wage
        $tender_id = $waybillBean->document->tender->id;
        $cargo_id = $waybillBean->document->cargo[0]->cargo_id;
        $origin_id = $waybillBean->document->negotiable_instructios->route->origin->id;
        $routeWageCore = new RouteWageCore();
        try {
            $routeWageCore->searchWageForFreight($tender_id, $origin_id, $destination_id, $cargo_id, DBConnection::getSystemDate(), 
            "payable", true, $waybillBean);
        } catch (Exception $e) {

            $socialCore = new SocialCore();
            $cargoName = $waybillBean->document->cargo[0]->name;
            $wall_message = "لا توجد تسعيرة معرفة لموقع التفريغ $new_location على الحمولة $cargoName";
            $notification_message = "لا توجد تسعيرة معرفة لموقع التفريغ $new_location على الحمولة $cargoName";
            //$socialCore->informSupervisor('تعريف تسعيرة', $wall_message, $notification_message);
        }
    }

    // ------------------------------------------------------------------------------------- //
    // ------------------- update waybill driver and trailer number ------------------------ //
    // ------------------------------------------------------------------------------------- //
    public function updateWaybill($newWaybillBean, $waybill_id, $user_id)
    {

        //Validate in use
        $this->validateForEdit($newWaybillBean, $user_id);

        // get the DB bean
        $waybillBean = $this->getWaybill($waybill_id, $user_id);
        $waybillBean = json_decode($waybillBean);
        $u_id = DBConnection::getUserIdFromSession($user_id);

        // update the driver
        if ($newWaybillBean->driver_id) {

            $driverBean = $waybillBean->document->carrier[0]->driver;
            $old_driver_name = $driverBean->name;
            $old_driver_id = $driverBean->id;
            $driverFilter = [['key' => 'id', 'val' => $newWaybillBean->driver_id]];
            $driver_result = $this->_driverCore->searchDriver($driverFilter, 1, 0, 0);
            $driverBean->id = $newWaybillBean->driver_id;
            $driverBean->name = $driver_result->data[0]->name;
            $driverBean->phone = $driver_result->data[0]->phone;
            $driverBean->nn = $driver_result->data[0]->nn;

            $waybillBean->document->carrier[0]->driver = $driverBean;
            // ADD ACTIVITIES , NOTE: I EXPLICITLY ADD THEM HERE ,
            // INSTEAD OF USING LOG ACTIVITY TO NOT CASE INFINITE LOOP OF UPDATING
            if ($old_driver_id != $newWaybillBean->driver_id) {
                $activity = new stdClass();
                $activity->activity_title = "تعديل معلومات السائق";
                $activity->activity_details = "تعديل السائق من " . $old_driver_name . " الى " . $driver_result->data[0]->name;
                $activity->user_id = $u_id;
                $activity->activity_icon = "UPDATE_DRIVER_INFO";
                $activity->activity_date = DBConnection::getSystemDate();
                if ($waybillBean->document->activities) {
                    array_push($waybillBean->document->activities, $activity);
                } else {
                    $waybillBean->document->activities = [$activity];
                }
            }
        }

        // update the trailer
        if ($newWaybillBean->trailer_id) {
            $trailerBean = $waybillBean->document->carrier[0]->trailer;
            $trailerBean->id = $newWaybillBean->trailer_id;
            $old_trailer = $trailerBean->tn;
            $new_trailer = $this->_truckCore->getTruckBasic($trailerBean->id, 0);
            $trailerBean->tn = $new_trailer->tn;
            $trailerBean->minor_tt = $new_trailer->minor_tt;
            $waybillBean->document->carrier[0]->trailer = $trailerBean;
            if ($old_trailer != $new_trailer->tn) {

                //if the waybill is crude oil , stop the update
                if ($waybillBean->tender_id == 11) {
                    //throw new Exception("لا تستطيع المتابعة ، لا يمكن تغير رقم المقطورة في مستندات النفط الخام");
                }

                // ADD ACTIVITIES , NOTE: I EXPLICITLY ADD THEM HERE ,
                // INSTEAD OF USING LOG ACTIVITY TO NOT CASE INFINITE LOOP OF UPDATING
                $activity = new stdClass();
                $activity->activity_title = "تعديل معلومات المقطورة";
                $activity->activity_details = "تعديل المقطورة من " . $old_trailer . " الى " . $new_trailer->tn;
                $activity->user_id = $u_id;
                $activity->activity_icon = "UPDATE_TRAILER";
                $activity->activity_date = DBConnection::getSystemDate();
                if ($waybillBean->document->activities) {
                    array_push($waybillBean->document->activities, $activity);
                } else {
                    $waybillBean->document->activities = [$activity];
                }
            }
        }

        // update the owner
        if ($newWaybillBean->truck_owner_id) {
            $ownerBean = $waybillBean->document->carrier[0]->truck_owner;
            $old_Owner_name = $ownerBean->name;

            $truckOwnerFilter = [['key' => 'id', 'val' => $newWaybillBean->truck_owner_id]];
            $new_owner = $this->_truckOwnerCore->searchTruckOwner($truckOwnerFilter, 1, 0, 0)->data[0];


            if ($ownerBean->id != $new_owner->id) {

                $ownerBean->id = $new_owner->id;
                $ownerBean->name = $new_owner->name;
                $ownerBean->phone = $new_owner->phone;

                $waybillBean->document->carrier[0]->truck_owner = $ownerBean;

                // ADD ACTIVITIES , NOTE: I EXPLICITLY ADD THEM HERE ,
                // INSTEAD OF USING LOG ACTIVITY TO NOT CASE INFINITE LOOP OF UPDATING
                $activity = new stdClass();
                $activity->activity_title = "تعديل معلومات مالك الشاحنة";
                $activity->activity_details = "تعديل المالك من " . $old_Owner_name . " الى " . $new_owner->name;
                $activity->user_id = $u_id;
                $activity->activity_icon = "UPDATE_DRIVER_INFO";
                $activity->activity_date = DBConnection::getSystemDate();
                if ($waybillBean->document->activities) {
                    array_push($waybillBean->document->activities, $activity);
                } else {
                    $waybillBean->document->activities = [$activity];
                }
            }
        }


        if ($newWaybillBean->tn) {
            if ($newWaybillBean->tn != $waybillBean->document->carrier[0]->truck->tn) {
                $companyId = $waybillBean->trucking_company_id;
                $tenderCompanyCore = new TenderCompanyCore();
                $tenderCompanyFilter = [
                    ['key' => 'trucking_company_id', 'val' => $companyId],
                    ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in'],
                    ['key' => 'tender_id', 'val' => $waybillBean->tender_id]
                ];
                $tenderCompaniesReuslt = $tenderCompanyCore->searchTenderCompany($tenderCompanyFilter, 1, 0, $_SESSION['user_id']);
                if (sizeof($tenderCompaniesReuslt->data) > 0) {
                    $service_list = json_decode($tenderCompaniesReuslt->data[0]->service_list);
                    foreach ($service_list as $service) {
                        if ($service->code == 'DISPATCH' && $service->type == 'QUEUE') {
                            throw new Exception('لا يمكن تعديل رقم الشاحنة لمستند أفراد');
                        }
                    }
                }
                $tenderTruckFilter = [
                    ['key' => 'truck_id', 'val' => $newWaybillBean->truck_id],
                    ['key' => 'status', 'val' => 'ACTIVE'],
                    ['key' => 'tender_id', 'val' => $waybillBean->tender_id]
                ];

                $tenderTrucks =  $this->_tenderCore->searchTenderTruck($tenderTruckFilter, 1, 0, 0);
                if (sizeof($tenderTrucks->data) == 0) {
                    throw new Exception('لا يمكنك المتابعة, لايوجد عقد فعال للشاحنة على المشروع');
                }

                $truckBeanNode = new stdClass();
                $truckBeanNode->id = $newWaybillBean->truck_id;
                $truckBeanNode->tn = $newWaybillBean->tn;
                $waybillBean->document->carrier[0]->truck =  $truckBeanNode;
            }
        }

        // update the revoked reason
        if ($newWaybillBean->document->revokeReason) {
            $waybillBean->document->revokeReason = $newWaybillBean->document->revokeReason;
        }

        // update the closed reason
        if ($newWaybillBean->document->closedReason) {
            $waybillBean->document->closedReason = $newWaybillBean->document->closedReason;
        }

        // update the freight node
        if ($newWaybillBean->document->freight) {
            $waybillBean->document->freight = $newWaybillBean->document->freight;
        }
        // update the integeration_details node
        if ($newWaybillBean->document->integeration_details) {
            $waybillBean->document->integeration_details = $newWaybillBean->document->integeration_details;
        }
        // update the service_list node
        if ($newWaybillBean->document->service_list) {
            $waybillBean->document->service_list = $newWaybillBean->document->service_list;
        }
        // update the order shift id
        if ($newWaybillBean->document->order->shift_id) {
            $waybillBean->document->order->shift_id  = $newWaybillBean->document->order->shift_id;
        }

        // update the ltrc node
        if ($newWaybillBean->ltrc) {
            $waybillBean->document->ltrc = $newWaybillBean->ltrc;
        }

        // update the payment delay node
        if ($newWaybillBean->document->payment_delay) {
            $waybillBean->document->payment_delay = $newWaybillBean->document->payment_delay;
        }

        // update the tender_claim node
        if ($newWaybillBean->document->tender_claim) {
            $waybillBean->document->tender_claim = $newWaybillBean->document->tender_claim;
        }

        // update the first_trip node
        if ($newWaybillBean->document->first_trip) {
            $waybillBean->document->first_trip = $newWaybillBean->document->first_trip;
        }

        // update the external_service node
        if ($newWaybillBean->document->external_service) {
            $waybillBean->document->external_service = $newWaybillBean->document->external_service;
        }
        // update the notes node
        if ($newWaybillBean->document->notes) {
            $waybillBean->document->notes = $newWaybillBean->document->notes;
        }

        // update the external_service node
        if ($newWaybillBean->document->activities) {
            $waybillBean->document->activities = $newWaybillBean->document->activities;
        }

        // update cargo node
        if ($newWaybillBean->document->cargo) {
            $waybillBean->document->cargo = $newWaybillBean->document->cargo;
        }

        // update origin node
        if ($newWaybillBean->document->negotiable_instructios->route->origin) {
            $waybillBean->document->negotiable_instructios->route->origin = $newWaybillBean->document->negotiable_instructios->route->origin;
        }

        // update destination node
        if ($newWaybillBean->document->negotiable_instructios->route->destination) {
            $waybillBean->document->negotiable_instructios->route->destination = $newWaybillBean->document->negotiable_instructios->route->destination;
        }

        // update nafith_wn
        if ($newWaybillBean->nafith_wn) {
            $waybillBean->document->nafith_wn = $newWaybillBean->nafith_wn;
        }

        // update tender_claim
        if ($newWaybillBean->tender_claim) {
            $waybillBean->document->tender_claim = $newWaybillBean->tender_claim;
        }

        // update create_date
        if ($newWaybillBean->create_date) {
            $waybillBean->create_date = $newWaybillBean->create_date;
        }

        // update the revoked reason
        if ($newWaybillBean->document->has_full_payment) {
            $waybillBean->document->has_full_payment = $newWaybillBean->document->has_full_payment;
        }

        // update the stamps
        if ($newWaybillBean->document->stamps) {
            $waybillBean->document->stamps = $newWaybillBean->document->stamps;
        }

        // update the stamps
        if ($newWaybillBean->document->discharge_report) {
            $waybillBean->document->discharge_report = $newWaybillBean->document->discharge_report;
        }

        // get basic object bean without any activites
        $DB_Bean = DBConnection::getBasicObjectBean("waybill", $waybill_id, $user_id);
        //update truck info only if the truck bean is different than DB bean
        if (compareObject($waybillBean, $DB_Bean) == false) {
            $updatedWaybill = new stdClass();
            $updatedWaybill->id = $waybillBean->id;
            $updatedWaybill->document = $waybillBean->document;
            // update create_date
            if ($waybillBean->create_date) {
                $updatedWaybill->create_date = $waybillBean->create_date;
            }

            DBConnection::updateDB("waybill", $updatedWaybill, $user_id);
        }
    }

    // -------------------------------------------------------------------------------------------------- //
    // ------------------- validate update the waybill info (trailer and driver) ------------------------ //
    // -------------------------------------------------------------------------------------------------- //
    public function validateForEdit($waybillBean, $user_id)
    {

        // get the active status of the waybill
        $activeWaybillStatus = DBConnection::getActiveStatus('waybill');

        // get the original waybill bean before the update
        $originalWaybillBean = $this->getWaybillBasic($waybillBean->id, 0);

        // validate trailer if exist
        if ($waybillBean->trailer_id) {
            $trailerFilter = [['key' => 'id', 'val' => $waybillBean->trailer_id]];
            $trailer_result = $this->_truckCore->searchTrucks($trailerFilter, 1, 0, 0);
            if ($trailer_result->found_rows == 0) {
                throw new Exception("WAYBILL.INVALID_TRAILER");
            }

            // validate trailer in use in case it is changed
            if ($originalWaybillBean->trailer_id != $waybillBean->trailer_id) {
                $waybillFilter = [
                    ['key' => 'trailer_id', 'val' => $waybillBean->trailer_id],
                    ['key' => 'status', 'val' => $activeWaybillStatus, 'op' => 'in'],
                    ['key' => 'id', 'val' => [$waybillBean->id], 'op' => 'not in']
                ];
                $waybill_result = $this->searchWaybills($waybillFilter, 1, 0, $user_id);
                if ($waybill_result->found_rows > 0) {
                    $wn = $waybill_result->data[0]->wn;
                    throw new Exception("المقطورة مستخدمة في المستند رقم $wn");
                }
            }
        }


        // validate driver if exist
        if ($waybillBean->driver_id) {
            $driverFilter = [['key' => 'id', 'val' => $waybillBean->driver_id]];
            $driver_result = $this->_driverCore->searchDriver($driverFilter, 1, 0, 0);
            if ($driver_result->found_rows == 0) {
                throw new Exception("WAYBILL.INVALID_DRIVER");
            }

            //validate driver in use
            $waybillFilter = [
                ['key' => 'driver_id', 'val' => $waybillBean->driver_id],
                ['key' => 'status', 'val' => $activeWaybillStatus, 'op' => 'in'],
            ];
            $waybill_result = $this->searchWaybills($waybillFilter, 1, 0, $user_id);
            $waybill_result = $this->searchWaybills($waybillFilter, 1, 0, $user_id);
            if ($waybill_result->found_rows > 0) {
                $wn = $waybill_result->data[0]->wn;
                //throw new Exception("السائق مستخدم في المستند رقم $wn");
            }
        }
    }


    // -------------------------------------------------------------------------------------------------- //
    // ------------------- validate create new waybill info (trailer and driver) ------------------------ //
    // -------------------------------------------------------------------------------------------------- //
    public function validateForCreate($truck_id, $trailer_id, $driver_id, $tender_id, $user_id)
    {

        // get the operation_type from tender
        $tenderManifestJSON = $this->_tenderCore->getTenderManifest($tender_id, 0);
        $operation_types_arr = $tenderManifestJSON['operation_type'];

        $operation_types = [];
        foreach ($operation_types_arr as $ot) {
            $operation_types[] = $ot->code;
        }

        // get the active status of the waybill
        $activeWaybillStatus = DBConnection::getActiveStatus('waybill');

        // validate truck if exist
        $truclFilter = [['key' => 'id', 'val' => $truck_id]];
        $truck_result = $this->_truckCore->searchTrucks($truclFilter, 1, 0, 0);
        if ($truck_result->found_rows == 0) {
            throw new Exception("رقم الشاحنة غير صحيح");
        }

        // validate truck in use
        $waybillFilter = [
            ['key' => 'truck_id', 'val' => $truck_id],
            ['key' => 'status', 'val' => $activeWaybillStatus, 'op' => 'in'],
            ['key' => 'operation_type', 'val' => $operation_types, 'op' => 'in'],
        ];

        $waybill_result = $this->searchWaybills($waybillFilter, 1, 0, $user_id);

        if ($waybill_result->found_rows > 0) {
            $wn = $waybill_result->data[0]->wn;
            throw new Exception("الشاحنة مستخدمة في المستند رقم $wn");
        }

        // validate trailer if exist
        if ($trailer_id) {
            $trailerFilter = [['key' => 'id', 'val' => $trailer_id]];
            $trailer_result = $this->_truckCore->searchTrucks($trailerFilter, 1, 0, 0);

            if ($trailer_result->found_rows == 0) {
                throw new Exception("رقم المقطورة غير صحيح");
            }

            // validate trailer in use
            $waybillFilter = [
                ['key' => 'trailer_id', 'val' => $trailer_id],
                ['key' => 'status', 'val' => $activeWaybillStatus, 'op' => 'in'],
                ['key' => 'operation_type', 'val' => $operation_types, 'op' => 'in']
            ];
            $waybill_result = $this->searchWaybills($waybillFilter, 1, 0, $user_id);
            if ($waybill_result->found_rows > 0) {
                $wn = $waybill_result->data[0]->wn;
                throw new Exception("المقطورة مستخدمة في المستند رقم $wn");
            }
        }


        // validate driver if exist
        if ($driver_id) {
            $driverFilter = [['key' => 'id', 'val' => $driver_id]];
            $driver_result = $this->_driverCore->searchDriver($driverFilter, 1, 0, $user_id);
            if ($driver_result->found_rows == 0) {
                throw new Exception("معلومات السائق غير صحيحة");
            }

            //validate driver in use
            $waybillFilter = [
                ['key' => 'driver_id', 'val' => $driver_id],
                ['key' => 'status', 'val' => $activeWaybillStatus, 'op' => 'in'],
                ['key' => 'operation_type', 'val' => $operation_types, 'op' => 'in']
            ];
            $waybill_result = $this->searchWaybills($waybillFilter, 1, 0, $user_id);
            if ($waybill_result->found_rows > 0) {
                $wn = $waybill_result->data[0]->wn;
                throw new Exception("السائق مستخدم في المستند رقم $wn");
            }
        }
    }


    // ------------------------------------------------------------------------ //
    // ---------------------- change cargo on selected waybill ---------------- //
    // ------------------------------------------------------------------------ //
    public function changeCargo($waybill_id, $cargo_id, $user_id)
    {

        // import objects
        $TenderCore = new TenderCore();

        // get the needed bean
        $waybillBean = $this->getWaybillBasic($waybill_id, $user_id);

        // ------------------ cargo -----------------------
        $waybill_json = $waybillBean->document;
        $cargo_node = $waybill_json->cargo[0];
        $oldCargoName = $cargo_node->name;

        $cargo_Bean = $this->_cargoCore->getCargoBasic($cargo_id, $user_id);
        if ($cargo_Bean == null) {
            throw new Exception("WBL001 - invalid cargo_id");
        }

        $cargo_node->cargo->id = $cargo_id;
        $cargo_node->cargo->name = $cargo_Bean->name;
        $cargo_node->name = $cargo_Bean->name;
        $cargo_node->cargo_id = $cargo_id;

        // ---------------------- CA ---------------------
        $waybill_template = $cargo_Bean->waybill_template;
        $ca_company_id = $waybill_template->cargo[0]->consigner->ca_id;
        $cargo_node->consigner = new stdClass();
        $cargo_node->consigner->ca = new stdClass();
        $cargo_node->consigner->ca->id = $ca_company_id;
        $caFilter = [['key' => 'id', 'val' => $ca_company_id]];
        $clearingAgent_qry = $this->_clearingAgentCore->searchClearingAgent($caFilter, 1, 0, 0); // search ca by system
        if ($clearingAgent_qry->found_rows == 0) {
            throw new Exception("WBL002 - invalid ca_company_id");
        }
        $cargo_node->consigner->ca->name = $clearingAgent_qry->data[0]->name;

        // ----------------------- Cargo Owner --------------------
        $cargo_node->consigner->cargo_owner = new stdClass();
        $cargo_node->consigner->cargo_owner->id = 0;
        $cargo_node->consigner->cargo_owner->name = $cargo_Bean->waybill_template->cargo[0]->consigner->cargo_owner_id;

        // ----------------------- Route --------------------------
        $origin_id = prepareLocationValue($waybill_template->negotiable_instructios->route->origin, $cargo_Bean);
        $destination_id = prepareLocationValue($waybill_template->negotiable_instructios->route->destination, $cargo_Bean);
        if ($origin_id == 91000000) {
            $origin_id = $waybill_json->negotiable_instructios->route->origin->id;
        }
        if ($destination_id == 91000000) {
            $destination_id = $waybill_json->negotiable_instructios->route->destination->id;
        }

        $negotiable_instructios_node = $waybill_json->negotiable_instructios;
        $negotiable_instructios_node->route = new stdClass();
        $negotiable_instructios_node->route->origin = new stdClass();
        $negotiable_instructios_node->route->destination = new stdClass();

        $negotiable_instructios_node->route->origin->id = $origin_id;
        $originBean = $this->_locationCore->getBasicLocation($origin_id, $user_id);
        if ($originBean == null) {
            throw new Exception("WBL006 - inavalid origin_id");
        }
        $negotiable_instructios_node->route->origin->name = $originBean->name;
        $negotiable_instructios_node->route->remarks = null;
        $negotiable_instructios_node->route->destination->id = $destination_id;
        $destinationBean = $this->_locationCore->getBasicLocation($destination_id, $user_id);
        if ($destinationBean == null) {
            throw new Exception("WBL005 - inavalid destination_id");
        }
        $negotiable_instructios_node->route->destination->name = $destinationBean->name;

        // ----------------------Fill new Data----------------- //
        $waybill_json->cargo = [$cargo_node];
        $ordersFilter = [
            ['key' => 'tender_id', 'val' => $cargo_Bean->tender_id],
            ['key' => 'status', 'val' => ['PENDING', 'ACTIVE'], 'op' => 'in'],
            ['key' => 'cargo', 'val' => '[' . $cargo_Bean->id . ']', 'op' => '=']
        ];

        $orders = $this->_tenderCore->searchTenderOrder($ordersFilter, 1, 0, 0);
        $order_id = $orders->data[0]->id;

        if (!$order_id) {
            //throw new Exception("لا يوجد اي طلبية فعالة على الحمل");
        }

        $waybill_json->order->id = $order_id;
        $waybill_json->negotiable_instructios = $negotiable_instructios_node;
        $waybillBean->document = $waybill_json;

        // -------------- update DB --------------------------- //
        $updatedWaybill = new stdClass();
        $updatedWaybill->id = $waybillBean->id;
        $updatedWaybill->document = $waybillBean->document;

        DBConnection::updateDB("waybill", $updatedWaybill, $user_id);
        $tn = $waybill_json->carrier[0]->truck->tn;

        $this->logActivity(
            $waybillBean->id,
            "تغير حمولة",
            "تم تغير حمولة الشاحنة $tn  من $oldCargoName  الى  $cargo_Bean->name ",
            "CHANGE_CARGO",
            $user_id
        );

        $addNoteCore = new Add_notes_core();
        $addNoteCore->addNotes('waybill', $waybill_id, 'تم تغير الحمولة من ' . $oldCargoName . ' الى ' . $cargo_Bean->name, $user_id);

        // -------------- Send notification to operation manager ------------------//
        $socialCore = new SocialCore();

        $done_by = $user_id;

        $wall_message = "تم تغير حمولة الشاحنة $tn  من $oldCargoName  الى  $cargo_Bean->name من قبل الموظف $done_by ";
        $notification_message = "تم تغير حمولة الشاحنة $tn الى $cargo_Bean->name";
        $socialCore->informSupervisor('تغير حمولة', $wall_message, $notification_message);
    }


    // ---------------------------------------------------------------------------------------------- //
    // ------------------- Create list of waybill info to generate invoices ------------------------- //
    // ---------------------------------------------------------------------------------------------- //
    public function createWaybillInvoiceJson($title, $sub_title, $jsonFilter)
    {

        $waybill_json = new stdClass();
        $waybill_json->header = new stdClass();
        $waybill_json->header->title = $title;
        $waybill_json->header->sub_title = $sub_title;
        $waybill_json->header->logo_url = "https://www.minagate.com/assets/img/logo-small.png";
        $waybill_json->header->header_url = "https://storage.googleapis.com/menagate_photos/header.png";
        $waybill_json->header->footer_url = "https://storage.googleapis.com/menagate_photos/footer.png";

        // prepare the column list
        $waybill_json->column_list = [];
        $waybill_json->column_list[] = (object) array("code" => "id", "caption" => "#");
        $waybill_json->column_list[] = (object) array("code" => "wn", "caption" => "رقم المستند");
        $waybill_json->column_list[] = (object) array("code" => "tn", "caption" => "القاطرة");
        $waybill_json->column_list[] = (object) array("code" => "trn", "caption" => "المقطورة");
        $waybill_json->column_list[] = (object) array("code" => "driver", "caption" => "السائق");
        $waybill_json->column_list[] = (object) array("code" => "origin", "caption" => "موقع التحميل");
        $waybill_json->column_list[] = (object) array("code" => "distination", "caption" => "موقع التفريغ");
        $waybill_json->column_list[] = (object) array("code" => "weight", "caption" => "الوزن المحمل");
        $waybill_json->column_list[] = (object) array("code" => "create_date", "caption" => "تاريخ الإنشاء");

        // prepare the sql
        $sql_query = "SELECT
            CAST(document AS CHAR CHARSET UTF8) AS document ,
            create_date
        FROM
            waybill_view w
        WHERE
            status not in ('INACTIVE','REVOKED') ";

        // inject the filter
        foreach ($jsonFilter as $filter) {
            if ($filter['key'] == 'cargo_id') {
                $sql_query .= "AND JSON_EXTRACT(document,'$.cargo[0].cargo_id') = " . $filter['val'];
            } else if ($filter['key'] == 'date') {
                //extract next month
                $data = [];

                //extract the end month
                $date = $filter['val'];
                $date = explode('-', $date);

                $sql_query .= " AND " . " create_date " . " >= '" . $filter['val'] . "' AND " . " create_date " . " <=  '" . $filter['val'] . "' + INTERVAL 1 MONTH ";
            } else {
                $sql_query .= " AND " . $filter['key'] . "=" . $filter['val'];
            }
        }

        $sql_query .= " AND EXISTS( SELECT
                    id
                FROM
                    activity a
                WHERE
                    w.id = a.waybill_id
                        AND a.action_code = 'CHANGE_STATUS'
                        AND a.object_status_code = 'NEW'
                        AND a.object_new_status_code = 'APPROVED')
        order by create_date ";

        $result = DBConnection::runDatabaseQuery($sql_query);
        $waybill_json->body = [];

        $counter = 0;
        foreach ($result as $waybill_doc) {
            $waybill = json_decode($waybill_doc->document);

            $waybill_json->body[] = (object) array(
                "id" => ++$counter,
                "wn" => $waybill->wn,
                "tn" => $waybill->carrier[0]->truck->tn,
                "trn" => $waybill->carrier[0]->trailer->tn,
                "driver" => $waybill->carrier[0]->driver->name,
                "origin" => $waybill->negotiable_instructios->route->origin->name,
                "destination" => $waybill->negotiable_instructios->route->destination->name,
                "cargo" => $waybill->cargo[0]->name,
                "weight" => $waybill->cargo[0]->weights->loading->net_weight,
                "create_date" => $waybill_doc->create_date
            );
        }
        // calculate the found_rows
        $waybill_json->header->total_count = $counter;

        return ($waybill_json);
    }



    // ------------------------------------------------------------------------------- //
    // -------------------- Create Empty freight Node -------------------------------- //
    // ------------------------------------------------------------------------------- //
    public function createFreightNode()
    {

        $amount = (object) array(
            "base_amount" => null,  // caculated based on discharge weight * price per ton
            "net_amount" => null,  // total amount of payments
            "tips" => null,          // tips if exist
            "tips_remarks" => null,          // tips remarks if exist

            "loss_fine" => null,
            "loss_in_kg" => null,
            "tolerance_in_kg" => null,
            "loss_fine_per_kg" => null,
            "total_fines" => null,

            "total_advance_payment" => 0,
            "total_deductions" => 0
        );
        $payments = [];
        $cargo_info = (object) array("loading_weight" => null, "discharged_weight" => null);
        $route_wage = null;
        $trx_error_logs = [];
        $trx_logs = [];

        $freight_json =  (object) array(
            "amount" => $amount,
            "payments" => $payments,
            "cargo_info" => $cargo_info,
            "trx_error_logs" => $trx_error_logs,
            "trx_logs" => $trx_logs,
            "route_wage" => $route_wage
        );

        return $freight_json;
    }


    // ------------------------------------------------------------------------- //
    // ----------------- generate waybill payment json node  ------------------- //
    // ------------------------------------------------------------------------- //
    public function addWaybillPaymentNode($waybill_id, $payment)
    {

        // get the waybill bean
        if (gettype($waybill_id) == "object") {
            $waybillBean = $waybill_id;
        } else {
            $waybillBean = $this->getWaybillBasic($waybill_id, 0);
        }

        // add the advance payment to payment section in json
        // push the new payment if it is not exist before
        $has_payment = false;

        $waybill_json = $waybillBean->document;
        $waybill_json->freight = $waybillBean->document->freight;
        $existingPayments = $waybill_json->freight->payments;

        foreach ($existingPayments as $old_payments) {
            if ($old_payments->name == $payment->name) {
                $has_payment = true;
            }
        }

        // if ($has_payment) return;
        array_push($existingPayments, $payment);
        $waybill_json->freight->payments = $existingPayments;

        // update the waybill document (payments)
        $waybillBean->document = $waybill_json;
        $updatedWaybill = new stdClass();
        $updatedWaybill->id = $waybillBean->id;
        $updatedWaybill->document = $waybillBean->document;
        DBConnection::updateDB("waybill", $updatedWaybill, 0);
    }


    // -------------------------------------------------------------------------------------- //
    // -------------------- log trx in waybill document ------------------------------------- //
    //--------------------------------------------------------------------------------------- //
    public function logTrx($waybill_id, $trx_id, $type, $remarks, $user_id)
    {
        // get the waybill bean
        if (gettype($waybill_id) == "object") {
            $waybillBean = $waybill_id;
        } else {
            $waybillBean = $this->getWaybillBasic($waybill_id, $user_id);
        }
        // get the trx bean
        $trxCore = new TrxCore();
        $trxFilter = [['key' => 'id', 'val' => $trx_id]];
        $trxInfo = $trxCore->searchTrx($trxFilter, 1, 0, $user_id);

        // create trx log object
        $newTrxLog =  (object) array(
            "trx_id" => $trx_id,
            "amount" => $trxInfo->data[0]->amount,
            "type" => $type,
            "remarks" => $remarks,
            "time_stamp" => DBConnection::getSystemDate()
        );

        // append the new trx log to old logs
        $trx_logs = $waybillBean->document->freight->trx_logs;
        if (!$trx_logs) {
            $trx_logs = [];
        }
        array_push($trx_logs, $newTrxLog);

        // update the waybill document in DB
        $waybillBean->document->freight->trx_logs = $trx_logs;

        $updatedBean = new stdClass();
        $updatedBean->id = $waybill_id;
        $updatedBean->document = $waybillBean->document;



        DBConnection::updateDB("waybill", $updatedBean, $user_id);
    }

    // --------------------------------------------------------------------------------------------- //
    // -------------------- log trx errors in waybill document ------------------------------------- //
    //---------------------------------------------------------------------------------------------- //
    public function logTrxError($waybill_id, $error_msg, $user_id)
    {
        // get the waybill bean
        if (gettype($waybill_id) == "object") {
            $waybillBean = $waybill_id;
        } else {
            $waybillBean = $this->getWaybillBasic($waybill_id, $user_id);
        }

        // create trx log object
        $newTrxLog =  (object) array(
            "error_msg" => $error_msg,
            "time_stamp" => DBConnection::getSystemDate()
        );

        // append the new trx log to old logs
        if ($waybillBean->document->freight) {
            $trx_error_logs = $waybillBean->document->freight->trx_error_logs;
            array_push($trx_error_logs, $newTrxLog);

            // update the waybill document in DB
            $waybillBean->document->freight->trx_error_logs = $trx_error_logs;
            $updatedBean = new stdClass();
            $updatedBean->id = $waybill_id;
            $updatedBean->document = $waybillBean->document;
            DBConnection::updateDB("waybill", $updatedBean, $user_id);
        }
    }


    // --------------------------------------------------------------------------------------- //
    // ------------------- Validate if the waybill has certain payment or not ---------------- //
    // --------------------------------------------------------------------------------------- //
    public function hasPayment($waybill_id, $payment_name)
    {

        if (gettype($waybill_id) == "object") {
            $waybillBean = $waybill_id;
        } else {
            $waybillBean = $this->getWaybillBasic($waybill_id, 0);
        }

        $has_payment = false;
        $waybill_json = $waybillBean->document;
        $waybill_json->freight = $waybillBean->document->freight;
        $existingPayments = $waybill_json->freight->payments;
        $tn = $waybillBean->document->carrier[0]->truck->tn;

        if ($existingPayments) {
            foreach ($existingPayments as $old_payments) {
                if (gettype($old_payments) == "object") {
                    if (strtoupper($old_payments->name) == strtoupper($payment_name)) {
                        if ($old_payments->value && isset($old_payments->value->amount)) {
                            if (isset($old_payments->time_stamp) && $old_payments->time_stamp) {
                                $has_payment = true;
                                break;
                            }
                        }
                    }
                } else {
                    if (strtoupper($old_payments['name']) == strtoupper($payment_name)) {
                        if ($old_payments['value'] && isset($old_payments['value']['amount'])) {
                            if (isset($old_payments['time_stamp']) && $old_payments['time_stamp']) {
                                $has_payment = true;
                                break;
                            }
                        }
                    }
                }
            }
        }

        return $has_payment;
    }


    // ------------------------------------------------------------------------------------------------------------------ //
    // ------------------ add advance payment to certain waybill  ---------------- //
    // ------------------ amount = reserved - (sum of all advanced payments) -------------------------------------------- //
    // ------------------------------------------------------------------------------------------------------------------ //
    public function addAdvancePayment($waybill_id, $payment)
    {

        $notificationCore = new NotificationCore();
        $voucherCore = new VoucherCore();

        // get the waybill bean
        if (gettype($waybill_id) == "object") {
            $waybillBean = $waybill_id;
        } else {
            $waybillBean = $this->getWaybillBasic($waybill_id, 0);
        }

        // add the advance payment to payment section in json
        // push the new payment if it is not exist before
        $has_payment = $this->hasPayment($waybill_id, $payment['name']);
        if ($has_payment) return;

        $jo_petrol_integration = new Jo_Petrol();

        if (strtoupper($payment['name']) == 'DEISIL_PRE_LOAD') {

            $amount = $jo_petrol_integration->getDieselPayment($waybillBean->id, 'DEISIL_PRE_LOAD');

            // create PENDING pre diesel node
            $newPayment = new stdClass();
            $newPayment->label = "DEISIL_PRE_LOAD";
            $newPayment->name = "DEISIL_PRE_LOAD";
            $newPayment->value = new stdClass();
            $newPayment->value->amount = $amount;
            $newPayment->status = "PENDING";
            $this->addWaybillPaymentNode($waybill_id, $newPayment);

            // create transfer diesil task
            $taskQueuesCore = new TaskQueuesCore();
            $taskQueuesCore->createTransferDieselTask($waybillBean->id, "DEISIL_PRE_LOAD");
        } else if (strtoupper($payment['name']) == 'DEISIL_POST_LOAD') {

            $amount = $jo_petrol_integration->getDieselPayment($waybillBean->id, 'DEISIL_POST_LOAD');

            // create PENDING pre diesel node
            $newPayment = new stdClass();
            $newPayment->label = "DEISIL_POST_LOAD";
            $newPayment->name = "DEISIL_POST_LOAD";
            $newPayment->value = new stdClass();
            $newPayment->value->amount = $amount;
            $newPayment->status = "PENDING";
            $this->addWaybillPaymentNode($waybill_id, $newPayment);

            // create transfer diesil task
            $taskQueuesCore = new TaskQueuesCore();
            $taskQueuesCore->createTransferDieselTask($waybillBean->id, "DEISIL_POST_LOAD");
        } else if (strtoupper($payment['name']) == 'PERMIT_FEES') {

            // create permit fees node
            $newPayment = new stdClass();
            $newPayment->label = "PERMIT_FEES";
            $newPayment->name = "PERMIT_FEES";
            $newPayment->value = new stdClass();
            $newPayment->value->amount = $payment['amount'];
            $this->addWaybillPaymentNode($waybill_id, $newPayment);
        }
    }



    // ------------------------------------------------------------------------------------ //
    // ------------------ Search for ltrc waybill ----------------------------------------- //
    // ------------------------------------------------------------------------------------ //
    public function searchLTRCWaybill($tn, $user_id)
    {

        $url = Config::$minagate_reg_base_url . '/face';
        $fields = array(
            "method" => "searchLtrcDocument",
            "tn" => $tn,
            "username" => "c395"
        );
        $headers[] = 'Authorization: wJfSDKrsxr5u8kqdXm6XL2pNWckc4aajkV4N3B8FgB56cmYYc8GuHd4p788JhEEc';


        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));
        $headers = array();
        $headers[] = 'CallBack: [waybill URL]';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close($ch);

        $response = json_decode($result, 1);

        return $response;
    }


    // ---------------------------------------------------------------------------------------- //
    // ------------------------- render adel waybill info   ---------------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function renderAdelWaybill($waybill)
    {
        $document = json_decode($waybill->document);

        $html = $this->_htmlHeader . '<body>
    <div class="MinagateFont">
        <form>
            <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' .
            Captions::getCaption("WAYBILL.STATUS." . $waybill->status) . '</label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : الحالة</label>
            </div>

             <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . explode(" ", $waybill->create_date)[0] . '</label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : تاريخ اﻹنشاء</label>
            </div>
             <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $waybill->tn . '</label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> :  رقم الشاحنة</label>
            </div>
             <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $document->cargo[0]->name . '</label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> :  اسم الحمولة </label>
            </div>

             <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle" style="direction: rtl;">  ' . ($document->cargo[0]->weights->loading->net_weight ? $document->cargo[0]->weights->loading->net_weight : 0) . '  كيلو  </label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle" > :  صافي وزن التحميل  </label>
            </div>

             <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle" style="direction: rtl;">  ' . ($document->cargo[0]->weights->discharge->net_weight ? $document->cargo[0]->weights->discharge->net_weight : 0) . ' كيلو  </label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> :  صافي وزن التفريغ  </label>
            </div>:0
             <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->carrier[0]->trailer->tn . '  </label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : رقم المقطورة </label>
            </div>
             <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $waybill->wn . '  </label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : رقم المستند </label>
            </div>
             <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->carrier[0]->tc->name . '  </label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : اسم شركة النقل  </label>
            </div>
              <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->carrier[0]->truck_owner->name . '  </label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : اسم المالك </label>
            </div>
             <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->carrier[0]->truck_owner->phone . '  </label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : رقم  هاتف المالك </label>
            </div>

             <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->carrier[0]->driver->name . '  </label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : اسم السائق </label>
            </div>
             <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->carrier[0]->driver->phone . '  </label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : رقم  هاتف السائق </label>
            </div>
              <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->negotiable_instructios->route->origin->name . '  </label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : الموقع </label>
            </div>
             <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->negotiable_instructios->route->destination->name . '  </label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : الوجهة </label>
            </div>
        </form>
    </div>
</body>

</html>';

        return $html;
    }




    // ---------------------------------------------------------------------------------------- //
    // ------------------------- render Fuel waybill info   ---------------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function renderFuelWaybill($waybill)
    {

        $document = json_decode($waybill->document);

        $serial = $document->integeration_details->queue->serial;
        if (!$serial) {
            $serial = $document->integeration_details->serial;
            if (!$serial) {
                $serial = "-";
            }
        }
        $newSerial = $document->integeration_details->queue->new_serial;

        $html = $this->_htmlHeader . '<body>
    <div class="MinagateFont">
    <form>
        <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' .
            Captions::getCaption("WAYBILL.STATUS." . $waybill->status) . '</label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : الحالة</label>
        </div>
         <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . explode(" ", $waybill->create_date)[0] . '</label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : تاريخ اﻹنشاء</label>
        </div>
         <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $waybill->tn . '</label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> :  رقم الشاحنة</label>
        </div>
         <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $document->cargo[0]->name . '</label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> :  اسم الحمولة </label>
        </div>
         <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle" style="direction: rtl;">  ' . ($document->cargo[0]->weights->loading->net_weight ? $document->cargo[0]->weights->loading->net_weight : 0) . '  كيلو  </label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle" > :  صافي وزن التحميل  </label>
        </div>
         <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle" style="direction: rtl;">  ' . ($document->cargo[0]->weights->discharge->net_weight ? $document->cargo[0]->weights->discharge->net_weight : 0) . ' كيلو  </label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> :  صافي وزن التفريغ  </label>
        </div>:0
         <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->carrier[0]->trailer->tn . '  </label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : رقم المقطورة </label>
        </div>
         <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $waybill->wn . '  </label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : رقم المستند </label>
        </div>
        <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $serial . '  </label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : تسلسل الدور الحالي </label>
        </div>';

        if ($newSerial) {
            $html .= '<div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                        <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $newSerial . '  </label>
                        <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : تسلسل الدور الجديد </label>
                    </div>';
        }

        $html .= '
         <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->carrier[0]->tc->name . '  </label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : اسم شركة النقل  </label>
        </div>
          <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->carrier[0]->truck_owner->name . '  </label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : اسم المالك </label>
        </div>
         <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->carrier[0]->truck_owner->phone . '  </label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : رقم  هاتف المالك </label>
        </div>

         <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->carrier[0]->driver->name . '  </label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : اسم السائق </label>
        </div>
         <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->carrier[0]->driver->phone . '  </label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : رقم  هاتف السائق </label>
        </div>
          <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->negotiable_instructios->route->origin->name . '  </label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : الموقع </label>
        </div>
         <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->negotiable_instructios->route->destination->name . '  </label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : الوجهة </label>
        </div>
    </form>
</div>
</body>

</html>';

        return $html;
    }


    // ---------------------------------------------------------------------------------------- //
    // ------------------------- render crude oil waybill info   ---------------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function renderCrudeOilWaybill($waybill)
    {
        $document = json_decode($waybill->document);
        $serial = $document->integeration_details->queue->serial;
        if (!$serial) {
            $serial = $document->integeration_details->serial;
            if (!$serial) {
                $serial = "-";
            }
        }
        $newSerial = $document->integeration_details->queue->new_serial;

        $html = $this->_htmlHeader . '<body>
<div class="MinagateFont">
    <form>
        <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' .
            Captions::getCaption("WAYBILL.STATUS." . $waybill->status) . '</label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : الحالة</label>
        </div>

         <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . explode(" ", $waybill->create_date)[0] . '</label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : تاريخ اﻹنشاء</label>
        </div>
         <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $waybill->tn . '</label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> :  رقم الشاحنة</label>
        </div>
         <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $document->cargo[0]->name . '</label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> :  اسم الحمولة </label>
        </div>

         <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle" style="direction: rtl;">  ' . ($document->cargo[0]->weights->loading->net_weight ? $document->cargo[0]->weights->loading->net_weight : 0) . '  كيلو  </label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle" > :  صافي وزن التحميل  </label>
        </div>

         <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle" style="direction: rtl;">  ' . ($document->cargo[0]->weights->discharge->net_weight ? $document->cargo[0]->weights->discharge->net_weight : 0) . ' كيلو  </label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> :  صافي وزن التفريغ  </label>
        </div>:0
         <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->carrier[0]->trailer->tn . '  </label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : رقم المقطورة </label>
        </div>
         <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $waybill->wn . '  </label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : رقم المستند </label>
        </div>
        <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $serial . '  </label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : تسلسل الدور الحالي </label>
        </div>';

        if ($newSerial) {
            $html .= '<div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $newSerial . '  </label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : تسلسل الدور الجديد </label>
            </div>';
        }

        $html .= '<div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->carrier[0]->tc->name . '  </label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : اسم شركة النقل  </label>
        </div>
          <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->carrier[0]->truck_owner->name . '  </label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : اسم المالك </label>
        </div>
         <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->carrier[0]->truck_owner->phone . '  </label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : رقم  هاتف المالك </label>
        </div>

         <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->carrier[0]->driver->name . '  </label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : اسم السائق </label>
        </div>
         <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->carrier[0]->driver->phone . '  </label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : رقم  هاتف السائق </label>
        </div>
          <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->negotiable_instructios->route->origin->name . '  </label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : الموقع </label>
        </div>
         <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
            <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->negotiable_instructios->route->destination->name . '  </label>
            <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : الوجهة </label>
        </div>
    </form>
</div>
</body>

</html>';

        return $html;
    }

    // ---------------------------------------------------------------------------------------- //
    // ------------------------- render grain waybill info   ---------------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function renderGrainWaybill($waybill)
    {
        $document = json_decode($waybill->document);

        $html = $this->_htmlHeader . '<body>
    <div class="MinagateFont">
        <form>
            <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' .
            Captions::getCaption("WAYBILL.STATUS." . $waybill->status) . '</label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : الحالة</label>
            </div>

             <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . explode(" ", $waybill->create_date)[0] . '</label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : تاريخ اﻹنشاء</label>
            </div>
             <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $waybill->tn . '</label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> :  رقم الشاحنة</label>
            </div>
             <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle"> ' . $document->cargo[0]->name . '</label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> :  اسم الحمولة </label>
            </div>

             <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->cargo[0]->weights->loading->net_weight . '  </label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> :  صافي وزن التحميل  </label>
            </div>

             <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->cargo[0]->weights->discharge->net_weight . '  </label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> :  صافي وزن التفريغ  </label>
            </div>
             <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->carrier[0]->trailer->tn . '  </label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : رقم المقطورة </label>
            </div>
             <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $waybill->wn . '  </label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : رقم المستند </label>
            </div>
             <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->carrier[0]->tc->name . '  </label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : اسم شركة النقل  </label>
            </div>
              <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->carrier[0]->truck_owner->name . '  </label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : اسم المالك </label>
            </div>
             <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->carrier[0]->truck_owner->phone . '  </label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : رقم  هاتف المالك </label>
            </div>

             <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->carrier[0]->driver->name . '  </label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : اسم السائق </label>
            </div>
             <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->carrier[0]->driver->phone . '  </label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : رقم  هاتف السائق </label>
            </div>
              <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->negotiable_instructios->route->origin->name . '  </label>
                <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : الموقع </label>
            </div>

        </form>
    </div>
</body>
</html>';

        /*<div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
    <label class="col-sm-7  col-xs-7   col-md-7  col-form-label valueStyle">  ' . $document->negotiable_instructios->route->destination->name . '  </label>
    <label class="col-sm-5   col-xs-5  col-md-5   col-form-label labelStyle"> : الوجهة </label>
</div>*/

        return $html;
    }

    // -------------------------------------------------------------------------------------------//
    // ------------------------- render adel financial------------------------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function renderAdelFinancial($waybill)
    {
        $document = json_decode($waybill->document);

        if ($document->freight == null || count($document->freight->payments) == 0) {
            $html = $this->_htmlHeader . ' <body>
                                            <div class="MinagateFont">
                                                <h4 style="text-align: center">لا يوجد حركات مالية </h4>';
        } else {
            $html = $this->_htmlHeader . '<body>
        <div class="MinagateFont">' . $this->renderPayments($document->freight->payments);
        }
        if ($this->renderTotalPayments($document->freight) != "") {
            $html = $html . '<div class="col-md-10 financial-box">
            <div class=" col-sm-12  col-xs-12   col-md-12 " style="margin-bottom: 5px">
                ' . $this->renderTotalPayments($document->freight) . '
            </div>
        </div>
        </div>
        </html>';
        }

        return $html;
    }

    // ---------------------------------------------------------------------------------------- //
    // ------------------------- render grain financial---------------------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function renderGrainFinancial($waybill)
    {
        $document = json_decode($waybill->document);

        if ($document->freight == null || count($document->freight->payments) == 0) {
            $html = $this->_htmlHeader . '<body>
                                        <div class="MinagateFont">
                                        <h4 style="text-align: center">لا يوجد حركات مالية   </h4>
                                       ';
        } else {
            $html = $this->_htmlHeader . '<body>
        <div class="MinagateFont">' . $this->renderPayments($document->freight->payments);
        }
        if ($this->renderTotalPayments($document->freight) != "") {
            $html = $html . ' <div class="col-md-10 financial-box">
                <div class=" col-sm-12  col-xs-12   col-md-12 " style="margin-bottom: 5px">
                    ' . $this->renderTotalPayments($document->freight) . '
                </div>
            </div>
        </div>
   </html>';
        }
        return $html;
    }
    // ---------------------------------------------------------------------------------------- //
    // ------------------------- render render invalid waybill box ---------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function renderInvalidWaybill()
    {
        $html = $this->_htmlHeader . '<body>
                                        <div class="MinagateFont">
                                        <h4 style="text-align: center">لا يمكن عرض معلومات الرحلة</h4>
                                        </div>
                                    </html>';
        return $html;
    }
    // ---------------------------------------------------------------------------------------- /
    // ------------------------- render  invalid financial box---------------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function renderInvalidFinancial()
    {
        $html = $this->_htmlHeader . '<body>
                                        <div class="MinagateFont">
                                        <h4 style="text-align: center">المعلومات المالية غير متوفرة حاليا</h4>
                                        </div>
                                    </html>';
        return $html;
    }
    // -------------------------------------------------------------------------------------- //
    // ------------------------- render financial payments boxes----------------------------- //
    // ------------------------------------------------------------------------------------- //
    public function renderPayments($payments)
    {
        $html = "";

        foreach ($payments as $payment) {
            $html = $html . '<div class="col-md-10 financial-box">
            <div class=" col-sm-12  col-xs-12   col-md-12 " style="margin-bottom: 5px">
                <div class="col-md-6 col-sm-6 col-lg-6 col-xs-6 valueStyle " style="font-weight: bold">
                    ' . $payment->time_stamp . '
                </div>
                <div class="col-md-6 col-sm-6 col-lg-6 col-xs-6 valueStyle  " style="font-weight: bold">' .
                $payment->label
                . '
                </div>
            </div>
            <div class=" col-sm-12  col-xs-12   col-md-12 " style="font-weight: bold">
                <div class="col-md-12 col-sm-12 col-lg-12 col-xs-12  " style="text-align: right;color: #969191">
                    ' . $payment->label . ' بقيمة ' . ($payment->value->amount) . ' دينار
                    لحساب رقم ' . $payment->target_account
                . '
                </div>
            </div>
        </div>';
        }

        return $html;
    }

    // ---------------------------------------------------------------------------------------- //
    // ------------------------- render total financial box--------------------------------------- //
    // ------------------------------------------------------------------------------------------ //
    public function renderNewTotalPayments($freight, $activities = null)
    {

        $html = "";
        $html = $this->_htmlHeader . '<body>';

        $html .= '<div class="MinagateFont">
                <form dir="rtl">
                    <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                        <label class="col-form-label headerStyle"> معلومات التقريش</label>
                    </div>
                </form>
                </div>';

        // if the waybill has tagreesh
        if ($freight->amount->base_amount) {

            $html .= '
        <div class="MinagateFont">
            <form>
                <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                    <label class="col-sm-6  col-xs-6   col-md-6  col-form-label valueStyle"> '
                . $freight->amount->wage_per_ton . '</label>
                    <label class="col-sm-6   col-xs-6  col-md-6   col-form-label labelStyle"> : سعر الطن</label>
                </div>

                <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                    <label class="col-sm-6  col-xs-6   col-md-6  col-form-label valueStyle"> '
                . $freight->amount->base_amount . '</label>
                    <label class="col-sm-6   col-xs-6  col-md-6   col-form-label labelStyle"> : المبلغ المستحق من التفريغ</label>
                </div>

                <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                    <label class="col-sm-6  col-xs-6   col-md-6  col-form-label valueStyle"> '
                . $freight->amount->total_deductions . '</label>
                    <label class="col-sm-6   col-xs-6  col-md-6   col-form-label labelStyle"> : مجموع الاقتطاعات</label>
                </div>

                <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                    <label class="col-sm-6  col-xs-6   col-md-6  col-form-label valueStyle"> '
                . $freight->amount->total_fines . '</label>
                    <label class="col-sm-6   col-xs-6  col-md-6   col-form-label labelStyle"> : تغريم النقص والغرامات</label>
                </div>

                <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                    <label class="col-sm-6  col-xs-6   col-md-6  col-form-label valueStyle"> '
                . $freight->amount->total_advance_payment . '</label>
                    <label class="col-sm-6   col-xs-6  col-md-6   col-form-label labelStyle"> : سلف الديزل + الإكراميات </label>
                </div>

                <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                    <label class="col-sm-6  col-xs-6   col-md-6  col-form-label valueStyle"> '
                . $freight->amount->net_amount . '</label>
                    <label class="col-sm-6   col-xs-6  col-md-6   col-form-label labelStyle"> : المبلغ الصافي</label>
                </div>

                </form>
            </div>
        ';
        } else {
            $html .= '<div class="MinagateFont">
                <form dir="rtl">
                    <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                    <label col-form-label labelStyle">  لم يتم تقريش المستند بعد</label>
                    </div>
                </form>
                </div>';
        }


        // Diesel payments
        if ($activities) {
            $html .= '
            <div class="MinagateFont">
                <form dir="rtl">
                    <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                        <label class="col-form-label headerStyle"> المعلومات المالية</label>
                    </div>';

            foreach ($activities as &$act) {
                if ($act->activity_icon == "WAYBILL_PAYMENT") {

                    $title = $act->activity_title;
                    $label = $act->activity_details;
                    $label = explode("ليصبح", $label)[0];

                    $html .= '<div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                                        <label col-form-label labelStyle"> ' . $title . "<br/>" . $label . '</label>
                                      </div>';
                }
            }
            $html .= '</form>
                    </div>';
        }
        $html .= '</body></html>';
        return $html;
    }


    // ---------------------------------------------------------------------------------------- //
    // ------------------------- render total financial box--------------------------------------- //
    // ------------------------------------------------------------------------------------------ //
    public function renderTotalPayments($freight)
    {


        $html = $this->_htmlHeader . '<body>
        <div class="MinagateFont">
            <form>
                <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                    <label class="col-sm-6  col-xs-6   col-md-6  col-form-label valueStyle"> '
            . $freight->amount->base_amount . '</label>
                    <label class="col-sm-6   col-xs-6  col-md-6   col-form-label labelStyle"> : المبلغ المستحق من التفريغ</label>
                </div>

                <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                    <label class="col-sm-6  col-xs-6   col-md-6  col-form-label valueStyle"> '
            . $freight->amount->total_deductions . '</label>
                    <label class="col-sm-6   col-xs-6  col-md-6   col-form-label labelStyle"> : مجموع الاقتطاعات</label>
                </div>

                <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                    <label class="col-sm-6  col-xs-6   col-md-6  col-form-label valueStyle"> '
            . $freight->amount->total_fines . '</label>
                    <label class="col-sm-6   col-xs-6  col-md-6   col-form-label labelStyle"> : تغريم النقص والغرامات</label>
                </div>

        ';
        foreach ($freight->payments as &$payment) {

            if ($payment->label == "DEISIL_PRE_LOAD") {
                $payment->label = "سلفة ديزل قبل التحميل";
            }
            if ($payment->label == "DEISIL_POST_LOAD") {
                $payment->label = "سلفة ديزل بعد التحميل";
            }

            $html = $html .
                '<div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                <label class="col-sm-6  col-xs-6   col-md-6  col-form-label valueStyle"> '
                . $payment->value->amount . '</label>
                <label class="col-sm-6   col-xs-6  col-md-6   col-form-label labelStyle"> : ' . $payment->label . '</label>
            </div>';
        }

        $html .= '  <div class="form-group divStyle  col-sm-12  col-xs-12   col-md-12 ">
                    <label class="col-sm-6  col-xs-6   col-md-6  col-form-label valueStyle"> '
            . $freight->amount->net_amount . '</label>
                    <label class="col-sm-6   col-xs-6  col-md-6   col-form-label labelStyle"> : المبلغ الصافي</label>
                </div>
            </form>
        </div>
        </body>

        </html>';

        return $html;
    }


    // -------------------------------------------------------------------------------------------------------------- //
    // ---------------- Save all the payment info (DNA) that will be used in any payment calculation later ---------- //
    // -------------------------------------------------------------------------------------------------------------- //
    public function savePaymentDNA($waybillBean)
    {

        // init objects
        $tenderCompanyCore = new TenderCompanyCore();
        $routeWageCore = new routeWageCore();

        // set the routeWage date
        $loadingDate = $waybillBean->document->cargo[0]->weights->loading->time_stamp;
        $start_date = $loadingDate ? $loadingDate : DBConnection::getSystemDate();

        // get the route wage from fright node in case the company has EPAYMENT service
        $trucking_company_id = $waybillBean->document->carrier[0]->tc->id;
        $tender_id = $waybillBean->document->tender->id;
        $hasPayment = $tenderCompanyCore->hasPaymentService($tender_id, null, $trucking_company_id);

        if ($hasPayment) {
            // search route wage
            $routeWage =  $routeWageCore->searchWageForFreight(
                $waybillBean->document->tender->id,
                $waybillBean->origin_id,
                $waybillBean->destination_id,
                $waybillBean->document->cargo[0]->cargo_id,
                $start_date,
                'payable',
                true,
                $waybillBean
            );

            $routeWage->deductions = json_decode($routeWage->deductions);

            $waybillBean->document->freight->route_wage = $routeWage;

            // get the deductions
            $deductions = $routeWage->deductions;
            $waybillBean->document->freight->deductions = $deductions;

            // update waybill document
            $this->updateWaybill($waybillBean, $waybillBean->id, 0);
        }
    }


    // ------------------------------------------------------------------------------------------- //
    // ---------------------- save Tagreesh calculation in waybill document ---------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function saveTagreeshData($waybillBean, $user_id, $pa_id = null)
    {

        // init objects
        $tenderCompanyCore = new TenderCompanyCore();
        $paymentCore = new PaymentCore();

        // check if the waybill trucking company has E-payment service
        $trucking_company_id = $waybillBean->document->carrier[0]->tc->id;
        $tender_id = $waybillBean->document->tender->id;
        $hasPayment = $tenderCompanyCore->hasPaymentService($tender_id, null, $trucking_company_id);
        $tagreeshRemarks = "";

        $hasPayment = true;
        if ($hasPayment) {
            $routeWageCore = new RouteWageCore();
            // search route wage
            $routeWage =  $routeWageCore->searchWageForFreight(
                $waybillBean->tender_id,
                $waybillBean->origin_id,
                $waybillBean->destination_id,
                $waybillBean->document->cargo[0]->cargo_id,
                $waybillBean->document->cargo[0]->weights->loading->time_stamp,
                'payable',
                true,
                $waybillBean,
                $pa_id
            );
            // calculate Tagreesh info
            $freight_node = $paymentCore->calculateFreight($waybillBean, null, null, $routeWage);
            // save the waybill payment info in waybill doc
            if (!$waybillBean->document->freight) {
                $waybillBean->document->freight = new stdClass();
            }
            $waybillBean->document->freight->amount = $freight_node->amount;
            $waybillBean->document->freight->deductions = $freight_node->deductions;

            // check if there is note to cancel axial fines waybill
            if ($waybillBean->document->freight->cancel_axial_load_fine && sizeof($waybillBean->document->freight->cancel_axial_load_fine) > 0) {
                $attachements = $waybillBean->document->freight->cancel_axial_load_fine;
                foreach ($attachements as $item) {
                    if ($item->code == "CANCEL_AXIAL_LOAD_FINE") {
                        $axial_load_fine = $waybillBean->document->freight->amount->axial_load_fine;
                        $waybillBean->document->freight->amount->axial_load_fine = 0;
                        $waybillBean->document->freight->amount->total_fines -= $axial_load_fine;
                        $waybillBean->document->freight->amount->net_amount += $axial_load_fine;

                        $u_id = DBConnection::getUserIdFromSession($user_id);
                        $tagreeshRemarks = "تم حذف غرامة الأحمال المحورية  (" . $axial_load_fine . " دينار )" . " بواسطة المستخدم " . $u_id;
                    }
                }
            }
            if ($waybillBean->document->freight->extra_fine && sizeof($waybillBean->document->freight->extra_fine) > 0) {
                $attachements = $waybillBean->document->freight->extra_fine;
                foreach ($attachements as $item) {
                    $waybillBean->document->freight->amount->total_fines += $item->value;
                    $waybillBean->document->freight->amount->net_amount -= $item->value;
                    $u_id = DBConnection::getUserIdFromSession($user_id);
                    $tagreeshRemarks = "تم اضافة غرامة   (" . $item->value . " دينار )" . " بواسطة المستخدم " . $u_id;
                }
            }

            $this->updateWaybill($waybillBean, $waybillBean->id, 0);
            $this->logActivity(
                $waybillBean->id,
                " إحتساب المستحقات المالية - تقريش  ",
                $tagreeshRemarks,
                "SAVE_TAGREESH",
                0
            );
        }
    }

    // ---------------------------------------------------------------------------------------------------------------------------- //
    // ---------------- Add new node in waybill document, to lock this waybill from being add to multi tender claims -------------- //
    // ---------------------------------------------------------------------------------------------------------------------------- //
    public function lockWaybillForTenderClaim($waybill_id, $tenderClaimBean)
    {

        // get waybill bean
        $waybillBean = $this->getWaybillBasic($waybill_id, 0);
        // generate the new node
        $tender_claim_node = new stdClass();
        $tender_claim_node->id = $tenderClaimBean->id;
        $tender_claim_node->type = $tenderClaimBean->claim_details->claim_type;
        $tender_claim_node->status_for_re_weight = "AVAILABLE";
        if ($waybillBean->document->tender_claim) {
            $temp = $waybillBean->document->tender_claim;
            array_push($temp, $tender_claim_node);
        } else {
            $temp = [$tender_claim_node];
        }


        // write it in waybill document
        $waybillBean->document->tender_claim = $temp;
        $this->updateWaybill($waybillBean, $waybillBean->id, 0);
    }

    // ----------------------------------------------------------------------------------------------------- //
    // ---------------- unlock waybill document,so it can be added to another new tender_claim -------------- //
    // ------------------------------------------------------------------------------------------------------ //
    public function unlockWaybillForTenderClaim($waybill_id, $tenderClaimBean)
    {

        // get waybill bean
        $waybillBean = $this->getWaybillBasic($waybill_id, 0);
        $doc = $waybillBean->document;
        $tender_claim = $doc->tender_claim;
        $tender_claim_id = $tenderClaimBean->id;
        $temp = [];
        // if tender_claim node is exist and has an id , this means that this waybill is already added to another claim, thus it cant be added here
        if ($tender_claim && is_object($tender_claim)) {
            $tender_claim_node = new stdClass();
            $tender_claim_node->id = null;
            $tender_claim_node->type = null;
            $tender_claim_node->status_for_re_weight = null;
            array_push($temp, $tender_claim_node);
        } else if ($tender_claim && is_array($tender_claim)) {
            foreach ($tender_claim as $claim) {
                if ($claim->id !== $tender_claim_id) {
                    array_push($temp, $claim);
                }
            }
        }
        // write it in waybill document
        $waybillBean->document->tender_claim = $temp;
        $this->updateWaybill($waybillBean, $waybillBean->id, 0);
    }


    // ---------------------------------------------------------------------------------------------------------------------------- //
    // ---------------- lock the waybill weights and prevent anyone from change the loading or dishcarge weight in case the ------- //
    // ---------------- waybill is added to an approved tender_claim -------------------------------------------------------------- //
    // ---------------------------------------------------------------------------------------------------------------------------- //
    public function lockWaybillWeights($waybill_id)
    {

        // get waybill bean
        $waybillBean = $this->getWaybillBasic($waybill_id, 0);

        // generate the new node
        $tender_claim_node = $waybillBean->document->tender_claim;
        $tender_claim_node->status_for_re_weight = "LOCKED";

        // write it in waybill document
        $waybillBean->document->tender_claim = $tender_claim_node;
        $this->updateWaybill($waybillBean, $waybillBean->id, 0);
    }


    // ----------------------------------------------------- //
    // ------------------- get certain service  ------------ //
    // ----------------------------------------------------- //
    public function getService($id, $user_id)
    {

        $waybillInfo = DBConnection::getBasicObjectBean("waybill_service", $id, $user_id);
        return $waybillInfo;
    }


    // ----------------------------------------------------------------------------------- //
    // -------------------search for waybill services using any search filter ------------ //
    // ----------------------------------------------------------------------------------- //
    public function searchWaybillServices($searchFilter, $limit, $offset, $user_id, $orderBy = null)
    {

        $searchWaybillResult = DBConnection::searchDB("waybill_service", $searchFilter, $limit, $offset, $user_id, $orderBy);
        return $searchWaybillResult;
    }



    // ----------------------------------------------------------------------- //
    // ------------------ create External Waybill ---------------------------- //
    // ----------------------------------------------------------------------- //
    public function createExternalWaybill($externalWaybillBean, $user_id)
    {

        //validate if the truck has already grains waybill in active status
        $activeWaybillStatus = DBConnection::getActiveStatus('waybill');
        $waybillFilter = [
            ['key' => 'tn', 'val' => $externalWaybillBean->tn],
            ['key' => 'status', 'val' => $activeWaybillStatus, 'op' => 'in']
        ];
        $waybill_result = $this->searchWaybills($waybillFilter, 1, 0, $user_id);
        if ($waybill_result->found_rows > 0) {
            throw new Exception("الشاحنة لديها مستند فعال برقم " . $waybill_result->data[0]->wn);
        }

        try {

            // ------------------------------ TRUCK --------------------------- //
            //check if truck exists
            $truckActiveStatus = DBConnection::getActiveStatus('truck');
            $truckSearchFilter = [['key' => 'tn', 'val' => $externalWaybillBean->tn], ['key' => 'status', 'val' => $truckActiveStatus, 'op' => 'in']];
            $truckResult = $this->_truckCore->searchTrucks($truckSearchFilter, 1, 0, $user_id);

            //if truck does not exist, throw exception
            if ($truckResult->found_rows == 0) {
                throw new Exception("الشاحنة غير مسجلة على النظام");
            } else {
                $truck_id = $truckResult->data[0]->id;
                $truck_owner_id = $truckResult->data[0]->truck_owner_id;
            }

            // ------------------------------- Trailer ------------------------ //
            //check if trailer exists
            $truckActiveStatus = DBConnection::getActiveStatus('truck');
            $trailerSearchFilter = [['key' => 'tn', 'val' => $externalWaybillBean->trn], ['key' => 'status', 'val' => $truckActiveStatus, 'op' => 'in']];
            $trailerResult = $this->_truckCore->searchTrucks($trailerSearchFilter, 1, 0, $user_id);
            //if truck does not exist, create it
            if ($trailerResult->found_rows == 0) {
                throw new Exception("المقطورة غير مسجلة على النظام");
            } else {
                $trailer_id = $trailerResult->data[0]->id;
                $trailer_owner_id = $trailerResult->data[0]->truck_owner_id;
            }

            // ------------------------------- Driver ------------------------ //
            $driverActiveStatus = DBConnection::getActiveStatus('driver');
            $driverFilter = [
                ['key' => 'nn', 'val' => $externalWaybillBean->nn],
                ['key' => 'status', 'val' => $driverActiveStatus, 'op' => 'in']
            ];
            $driver_result = $this->_driverCore->searchDriver($driverFilter, 1, 0, $user_id);

            // in case the driver does not exist , throw exception
            if ($driver_result->found_rows == 0) {
                throw new Exception("السائق غير مسجل على النظام");
            } else {
                $driver_id = $driver_result->data[0]->id;
            }

            // ------------------------------- Waybill Service -------------------------------- //
            $waybill_service_price = null;
            $service_id = $externalWaybillBean->service_id;
            $gatewayCore = new GatewayCore();
            $services = json_decode($gatewayCore->get_external_waybill_services());

            foreach ($services as $service) {
                if ($service->code == 'EXTERNAL_WAYBILL.SERVICE.' . $service_id) {
                    $waybill_service_price = $service->value;
                    break;
                }
            }

            if (!$waybill_service_price) {
                throw new Exception("الخدمة المطلوبة غير صحيحة");
            }


            // -------------------------------- Waybill ---------------------------------- //
            DBConnection::startTransaction();

            // create the  waybill
            $waybill_result = $this->createWaybill(
                $externalWaybillBean->tender_id,
                null,
                null,
                $externalWaybillBean->cargo_id,
                $truck_id,
                $trailer_id,
                $driver_id,
                $truck_owner_id,
                $trailer_owner_id,
                $externalWaybillBean->trucking_company_id,
                $externalWaybillBean->ca_id,
                $externalWaybillBean->origin_id,
                $externalWaybillBean->destination_id,
                $user_id
            );

            // ------------------------------- Waybill Service -------------------------------- //
            $serviceBean = new stdClass();
            $voucher_id = null;
            if ($externalWaybillBean->service_id) {

                // create voucher for this service
                $serviceBean = $this->getService($externalWaybillBean->service_id, 0);

                if (!$serviceBean) {
                    throw new Exception("الخدمة المراد اضافتها على المستند غير موجودة على النظام");
                }
                $service_name = $serviceBean->caption;
                // log advance payment
                $newPayment = new stdClass();
                $newPayment->label = "سند قبض بدل $service_name";
                $newPayment->name = "RECEIPT_VOUCHER";
                $newPayment->value = new stdClass();
                $newPayment->value->amount = $serviceBean->price;
                $newPayment->time_stamp = DBConnection::getSystemDate();

                // create voucher for this payment
                $payment_account = "590000-19914"; //حساب صندوق التصاريح الخارجية 21;
                $target_account = "590000-50005"; // حساب ايرادات التصاريح الخارجية 21;
                $value = new stdClass();
                $value->amount = $serviceBean->price;
                $PaymentNode = (object)array(
                    "name" => "RECEIPT_VOUCHER",
                    "label" => $newPayment->label,
                    "target_account" => $target_account,
                    "time_stamp" => DBConnection::getSystemDate(),
                    "value" => $value,
                    "service_id" => $serviceBean->id
                );

                $remarks = " بدل خدمة $service_name - للشاحنة $externalWaybillBean->tn - المستند $waybill_result->wn ";

                $voucherCore = new VoucherCore();
                $voucher_id = $voucherCore->createVoucher(
                    $payment_account,
                    $target_account,
                    $serviceBean->price,
                    "CASH",
                    $PaymentNode,
                    null,
                    'RECEIPT_VOUCHER',
                    $waybill_result->id,
                    $remarks,
                    $externalWaybillBean->tender_id,
                    "payment_voucher",
                    $user_id,
                    true
                );
            }

            // update the new waybill document to include the new info
            $waybillBean = $this->getWaybillBasic($waybill_result->id, $user_id);
            $service_list = [];
            $service_list[] = [
                "cargo_id" => $externalWaybillBean->cargo_id,
                "service_id" => $externalWaybillBean->service_id,
                "service_name" => $service_name,
                "service_voucher_id" => $voucher_id,
                "service_price" => $serviceBean->price,
                "update_by" => DBConnection::getUserIdFromSession($user_id),
                "update_date" => DBConnection::getSystemDate(),
                "payment_method" => $externalWaybillBean->payment_method,
                "entry_point_id" => $externalWaybillBean->entry_point_id,
                "exit_point_id" => $externalWaybillBean->exit_point_id,
                "discharge_location_id" => $externalWaybillBean->discharge_location_id
            ];
            $waybillJson = $waybillBean->document;
            $waybillJson->service_list = $service_list;

            // update bond info
            $notes = $waybillJson->notes;

            if (!$notes) {
                $notes = new stdClass();
            }
            $notes->bond = new stdClass();
            $notes->bond->id = $externalWaybillBean->bond_number;
            $notes->bond->photo = $externalWaybillBean->bond_photo;
            $waybillJson->notes = $notes;

            $waybill_result->voucher_id = $voucher_id;
            $waybillBean->document = $waybillJson;
            $this->updateWaybill($waybillBean, $waybill_result->id, $user_id);

            DBConnection::commitTransaction();
            return $waybill_result;
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception("لا يمكن انشاء التصريح - " . $e->getMessage());
        }
    }

    // ----------------------------------------------------------------------- //
    // ------------------ LOG ACTIVITY FOR WAYBILL BEAN ----------------------- //
    // ----------------------------------------------------------------------- //
    public function logActivity($waybillId, $activity_title, $activity_details, $activity_icon, $user_id)
    {

        // get user id using session_id ( in this function , the param user_id represent session_id, so it must be converted to u_id )
        $u_id = DBConnection::getUserIdFromSession($user_id);

        // set activity node
        $activity = new stdClass();
        $activity->activity_title = $activity_title;
        $activity->activity_details = $activity_details;
        $activity->user_id = $u_id;
        $activity->activity_icon = $activity_icon;
        $activity->activity_date = DBConnection::getSystemDate();

        // get waybill bean
        $waybillBean = $this->getWaybillBasic($waybillId, $user_id);
        // get waybill document
        $waybill_document = $waybillBean->document;
        if ($waybill_document->activities) {
            array_push($waybill_document->activities, $activity);
        } else {
            $waybill_document->activities = [$activity];
        }
        // write it in waybill document
        $waybillBean->document = $waybill_document;

        $this->updateWaybill($waybillBean, $waybillId, $user_id);
    }


    // ---------------------------------------------------------------------------------- //
    // ------------------- calculate any extra fees to be added to the waybill----------- //
    // ------------------- fee_types = LOADING_DATE_DELAY ------------------------------- //
    // ---------------------------------------------------------------------------------- //
    public function calculateExtraFees($waybillBean, $tender_id, $fee_type)
    {

        $extra_fees_value = 0;
        $extra_fees_note = "";

        // get the tender manifest
        $tenderManifestJSON = $this->_tenderCore->getTenderManifest($tender_id, 0);

        // check if the extra fees is enabled
        $enable_extra_fees = $tenderManifestJSON['freight']['payment_method']['extra_fees']['enable_extra_fees'];
        if ($enable_extra_fees) {
            $extra_fees_node = $tenderManifestJSON['freight']['payment_method']['extra_fees']['method'];
            if ($extra_fees_node['code'] == $fee_type) {

                // calculate diff between current time and loading time
                $doc = $waybillBean->document;
                $cargoBean = $doc->cargo[0];
                $loading_time = date_create(date("Y-m-d H:i", strtotime($cargoBean->weights->loading->time_stamp)));
                $discharge_time = date_create(date("Y-m-d H:i", strtotime($cargoBean->weights->discharge->time_stamp)));
                $diff = date_diff($discharge_time, $loading_time);
                $diff_in_hours = ($diff->d * 24) + ($diff->h);

                // if the diff is larger than the allowed threshold, calculate extra fees
                if ($diff_in_hours > $extra_fees_node['delay']) {
                    $extra_fees_value = $extra_fees_node['fine'] * ($diff->d - ($extra_fees_node['delay'] / 24));
                    $extra_fees_note = $extra_fees_node['fine_note'];
                }
            }
        }

        $result = new stdClass();
        $result->extra_fees_value = $extra_fees_value;
        $result->extra_fees_note = $extra_fees_note;
        return $result;
    }

    // ---------------------------------------------------------------------------------- //
    // ------------------- calculate the late days number to be shown in report --------- //
    // ---------------------------------------------------------------------------------- //
    public function calculateExtraFeesLateDays($waybillBean, $tender_id)
    {

        $diffInDays = 0;

        // get the tender manifest
        $tenderManifestJSON = $this->_tenderCore->getTenderManifest($tender_id, 0);

        // check if the extra fees is enabled
        $enable_extra_fees = $tenderManifestJSON['freight']['payment_method']['extra_fees']['enable_extra_fees'];
        if ($enable_extra_fees) {
            $extra_fees_node = $tenderManifestJSON['freight']['payment_method']['extra_fees']['method'];
            if ($extra_fees_node['code'] == 'LOADING_DATE_DELAY') {

                // calculate diff between current time and loading time
                $doc = $waybillBean->document;
                $cargoBean = $doc->cargo[0];
                $loading_time = date_create(date("Y-m-d H:i", strtotime($cargoBean->weights->loading->time_stamp)));
                $discharge_time = date_create(date("Y-m-d H:i", strtotime($cargoBean->weights->discharge->time_stamp)));
                $diff = date_diff($discharge_time, $loading_time);

                $diffInDays = $diff->d - ($extra_fees_node['delay'] / 24);
            }
        }

        $result = new stdClass();
        if ($diffInDays < 0) {
            $diffInDays = 0;
        }
        $result->diffInDays = $diffInDays;
        return $result;
    }

    // ---------------------------------------------------------------------------------------- //
    // ------------------ Write wall entry on waybill default contact person ------------------ //
    // ---------------------------------------------------------------------------------------- //
    public function informWaybillContactPerson($waybill_id, $wallPost)
    {

        $socialCore = new SocialCore();
        $waybillBean = $this->getWaybillBasic($waybill_id, 0);

        // get the default contact user_id
        $user_id = $waybillBean->document->default_contact_user_id;

        // if no default user is defined, get the truck owner user id
        if (!$user_id) {
            $truck_owner_id = $waybillBean->document->carrier[0]->truck_owner->id;
            if ($truck_owner_id) {
                $truckOwnerBean = $this->_truckOwnerCore->getTruckOwnerBasic($truck_owner_id, 0);
                $user_id = $truckOwnerBean->user_id;
            }
        }

        // send only if user id is defined
        if ($user_id) {
            $title = $wallPost->title;
            $msg = $wallPost->msg;
            $socialCore->createWallEntry($user_id, $title, $msg);
        }
    }


    // ---------------------------------------------------------------------------------------- //
    // ------------------ create Permit ticket for waybill ------------------ //
    // ---------------------------------------------------------------------------------------- //
    public function createPermitTicket($waybill_id, $truckQueueId = null, $request = null)
    {

        try {
            // get waybill bean
            $waybill = $this->getWaybillBasic($waybill_id, 0);

            // if the waybill already has permit ticket dont duplicate it
            $doc = $waybill->document;
            $has_ticket = false;
            if ($doc->integeration_details->ticket) {
                foreach ($doc->integeration_details->ticket as $ticket) {
                    if ($ticket->ticket_type_code == "SUBMIT_PERMIT_FOR_WAYBILL") {
                        $has_ticket = true;
                    }
                }
            }
            if ($has_ticket) {
                return;
            }


            // get the user id
            $driverBean = $this->_driverCore->getDriverBasic($waybill->driver_id, 0);
            $userBean = $this->_userCore->getUserBasic($driverBean->user_id, 0);

            //get some info needed for ticket
            $doc = $waybill->document;
            $body = new stdClass();
            $body->tn = $doc->carrier[0]->truck->tn;
            $body->trn = $doc->carrier[0]->trailer->tn;
            $body->wn = $waybill->wn;
            $body->nn = $userBean->nn;
            $body->driver_name = $userBean->name;
            $body->waybill_id = $waybill->id;
            $body->truck_queue_id = $truckQueueId;
            $body->destination_id = $doc->negotiable_instructios->route->destination->id;
            $body->cargo_name = $doc->cargo[0]->cargo->name;
            if ($doc->service_list) {
                $body->first_trip_destination = $doc->service_list[0]->discharge_location_id;
                $body->payment_method = $doc->service_list[0]->payment_method;
                $body->waybill_service_id = (int) $doc->service_list[0]->waybill_service_id;
                $body->waybill_service_price = $doc->service_list[0]->waybill_service_price;
                $body->first_trip_entry_location = $doc->service_list[0]->entry_point_id;
                $body->first_trip_exit_location = $doc->service_list[0]->exit_point_id;
            }


            $firstTrip = $doc->first_trip;
            if ($firstTrip) {
                $body->first_trip_destination = $firstTrip->destination;
                $body->first_trip_type = $firstTrip->type;
                $body->first_trip_entry_location = $firstTrip->entry_location;
            }
            // type of ticket
            $type_code = 'submit_permit_for_waybill';
            $body->type_code = $type_code;

            //ticket
            $data = new stdClass();
            $data->title =  'معاملة تسريب - ' . $doc->carrier[0]->truck->tn;;
            $data->body = json_encode($body, JSON_UNESCAPED_UNICODE);
            $data->priority = 8;
            $data->type_code = strtoupper($type_code);
            $data->company_id = 266770;
            $data->user_id = $userBean->id;
            $data->senderName = $userBean->name;

            // Ticket filters
            $filters = new stdClass();
            $filters->ticket_type = 'client';
            $filters->type_code = strtoupper($type_code);
            $filters->tender_id = $waybill->tender_id;

            // call to customer care system to create ticket
            $customerCare = new CustomerCare();
            $ticket = $customerCare->createTicket($data, $filters, null);

            // inform driver
            $socialCore = new SocialCore();
            $notificationCore = new NotificationCore();
            $title = "تقديم معاملة تسريب";
            $tn = $doc->carrier[0]->truck->tn;
            $msg = "تم تقديم معاملة تسريب للشاحنة $tn " . "، سيتم ابلاغكم فور تجهيز التصريح";
            $socialCore->createWallEntry($userBean->id, $title, $msg);
            $payload = new stdClass();
            $payload->type = "set_notification";
            $payload->id = rand(1, 1000);
            $payload->title = $title;
            $payload->message = $msg;
            $r = $notificationCore->sendDataMessage($userBean->id, $payload);

            // log in document tickets
            $waybill->document = $this->appendTicketToDocument($waybill->document, $ticket['id'], $ticket['type'], $ticket['type_code']);
            $this->updateWaybill($waybill, $waybill->id, 0);

            //logHamzeh("success", "finish creating submit ticket for w_id= ". $waybill->id . " and ticket=" . $ticket['id']);

            return $ticket;
        } catch (Exception $e) {
            logHamzeh("error", $e->getMessage());
            throw new Exception($e->getMessage());
        }
    }

    // ---------------------------------------------------------------------------------------- //
    // ------------------ Appends Ticket node to document ------------------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function appendTicketToDocument($document, $ticketId, $ticketType, $ticketTypeCode)
    {
        // Insure that the document is of type stdClass
        switch (gettype($document)) {
            case "string":
                $document = json_decode($document);
                break;
            case "array":
                $document = json_decode(json_encode($document));
                break;
        }

        // Get the ticket node or create if not exists
        if (!$document->integeration_details) {
            $document->integeration_details = new stdClass();
        }
        $ticketNode = $document->integeration_details->ticket;
        $ticketNode =  $ticketNode ? $ticketNode : [];

        // create new ticket node object
        $ticket = [
            "ticket_id" => $ticketId,
            "ticket_type" => $ticketType,
            "ticket_type_code" => $ticketTypeCode,
            "append_date" => DBConnection::getSystemDate()
        ];
        // Append to node
        $ticketNode[] = $ticket;
        // Update document
        $document->integeration_details->ticket = $ticketNode;
        return $document;
    }

    // ---------------------------------------------------------------------------------------- //
    // ------------------ Search document Tickets --------------------------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function searchTicketInDocument($document, $field = "ticket_type_code", $value = "")
    {
        // Insure that the document is of type stdClass
        switch (gettype($document)) {
            case "string":
                $document = json_decode($document);
                break;
            case "array":
                $document = json_decode(json_encode($document));
                break;
        }
        // Get the ticket node or create if not exists
        $ticketNode = $document->integeration_details->ticket;
        if (!$ticketNode || !is_array($ticketNode)) return false;
        $ticket = null;
        // Loop throw all tickets
        foreach ($ticketNode as $object) {
            if ($object->{$field} == $value) {
                $ticket = $object;
                break;
            }
        }
        return $ticket;
    }

    public function searchDieselLog($tn, $date)
    {
        if ($date)
            $fields = 'diesel_date';
        else
            $fields = '*';
        $db_query = "SELECT " . $fields . " FROM waybill.diesel_log";
        if (isset($tn) && !$date)
            $db_query .= " WHERE tn = " . $tn;
        $db_query .= " ORDER BY diesel_date DESC";
        if ($date)
            $db_query .= " LIMIT 1";
        $res = DBConnection::runDatabaseQuery($db_query);
        return $res;
    }

    public function insertDieselLogData($data_array)
    {
        $db_query = "INSERT INTO waybill.diesel_log(diesel_date, tn, station, unit_price, quantity, total) values ";
        $values_arr = [];
        foreach ($data_array as $row)
            $values_arr[] = ' (' . implode(',', $row) . ') ';
        $db_query .= implode(',', $values_arr);
        $res = DBConnection::runBindDatabaseQuery($db_query, []);
        return $res;
    }



    // ------------------------------------------------------------------- //
    // ------------- Generate trx for complete waybill ------------------- //
    // ------------------------------------------------------------------- //
    public function autoCompleteJvTemplate($jv_template, $claimItem, $waybillBean, $user_id)
    {
        // init
        $trx = [];

        foreach ($jv_template->template as $temp) {
            $wn = $waybillBean->wn ? $waybillBean->wn : $claimItem->details->wn;
            $tn = $waybillBean->tn ? $waybillBean->tn : $claimItem->details->tn;

            // -------------------- ذمة مدير المشروع  --------------------------------
            if ($temp->target_account) {

                $amount = 0;
                foreach ($temp->amount as $am) {
                    if (strtoupper($am->source) == "WAYBILL") {
                        $key = $am->val;
                        $amount += $am->factor * ($waybillBean->document->freight->amount->$key);
                    }
                    if (strtoupper($am->source) == "FIXED") {
                        $amount += $am->factor * ($am->val);
                    }
                    if (strtoupper($am->source) == "CLAIM_ITEM") {
                        $key = $am->val;
                        $amount += $am->factor * ($claimItem->freight->amount->$key);
                    }
                    $trx_note = "حركة ذمة للمستند رقم " . $wn . " الشاحنة: " . $tn;
                }
                $trx[] = array(
                    "account" => $temp->value[0],
                    "amount" => $amount,
                    "op" => "D",
                    "notes" => $trx_note,
                    "trx_note" => ["text" => $trx_note],
                    "source_account" => null,
                    "target_account" => $temp->target_account
                );
            }

            // -------------------- ذمة مكتب الصرف  --------------------------------
            else if ($temp->source_account) {
                $amount = 0;

                foreach ($temp->amount as $am) {
                    if (strtoupper($am->source) == "WAYBILL") {
                        $key = $am->val;
                        $amount += $am->factor * ($waybillBean->document->freight->amount->$key);
                    }
                    if (strtoupper($am->source) == "FIXED") {
                        $amount += $am->factor * ($am->val);
                    }
                    if (strtoupper($am->source) == "CLAIM_ITEM") {
                        $key = $am->val;
                        $amount += $am->factor * ($claimItem->freight->amount->$key);
                    }
                    $trx_note = "حركة ذمة مكتب الصرف عن المستند رقم " . $wn . " الشاحنة: " . $tn;
                }
                $trx[] = array(
                    "account" => $temp->value[0],
                    "amount" => $amount,
                    "op" => "C",
                    "notes" => $trx_note,
                    "trx_note" => ["text" => $trx_note],
                    "source_account" => true,
                    "target_account" => null
                );
            }

            // -------------------- الايراد --------------------------------
            else {

                $amount = 0;
                foreach ($temp->amount as $am) {
                    if (strtoupper($am->source) == "WAYBILL") {
                        $key = $am->val;
                        $amount += $am->factor * ($waybillBean->document->freight->amount->$key);
                    }
                    if (strtoupper($am->source) == "FIXED") {
                        $amount += $am->factor * ($am->val);
                    }
                    if (strtoupper($am->source) == "CLAIM_ITEM") {
                        $key = $am->val;
                        $amount += $am->factor * ($claimItem->freight->amount->$key);
                    }

                    if ($claimItem->details->pa_id == 57 && $am->val == 5) {
                        $trx_note = "قيد ايراد انشاء وتنظيم وثائق نقل الوطنية عن المستند  " . $wn;
                    } else if ($claimItem->details->pa_id == 57) {
                        $trx_note = "قيد امانات محروقات عن الإرسالية  " . $wn;
                    } else {
                        $trx_note = "حركة ايراد للمستند رقم " . $wn . " الشاحنة: " . $tn;
                    }
                }
                if ($amount > 0) {
                    $trx[] = array(
                        "account" => $temp->value[0],
                        "amount" => $amount,
                        "op" => "C",
                        "notes" => $trx_note,
                        "trx_note" => ["text" => $trx_note],
                        "source_account" => null,
                        "target_account" => null
                    );
                }
            }
        }

        return $trx;
    }


    // ------------------------------------------------------------------- //
    // ------------- Generate trx for complete waybill ------------------- //
    // ------------------------------------------------------------------- //
    public function generateWaybillSettelmentTrx($waybill_id, $trx_template, $user_id)
    {

        $userCore = new UserCore();
        $voucherCore = new VoucherCore();
        $tenderCore = new TenderCore();
        $truckOwnerCore = new TruckOwnerCore();

        // get waybill bean
        $waybillBean = $this->getWaybillBasic($waybill_id, $user_id);

        // calculate voucher_amount
        $voucher_amount = $waybillBean->document->freight->amount->net_amount;

        // get tender truck bean
        $activeTenderTruckStatus = DBConnection::getActiveStatus('tender_truck');
        $tenderTruckFilter = [
            ['key' => 'truck_id', 'val' => $waybillBean->truck_id],
            ['key' => 'status', 'val' => $activeTenderTruckStatus, 'op' => 'in'],
            ['key' => 'tender_id', 'val' => $waybillBean->tender_id]
        ];
        $tenderTruck_qry = $tenderCore->searchTenderTruck($tenderTruckFilter, 1, 0, $user_id);
        $tenderTruckBean = $tenderTruck_qry->data[0];

        $financial_manager_owner_id = $tenderTruckBean->financial_manager_owner_id;
        if (!$financial_manager_owner_id) {
            throw new Exception("Invalid financial manager for the truck in tender truck record");
        }
        $financialManagerBean = $truckOwnerCore->getTruckOwnerBasic($financial_manager_owner_id, $user_id);
        if (!$financialManagerBean->user_id) {
            throw new Exception("Invalid financial manager for the truck, manager has to be user and not company");
        }
        $recipient_user_id = $financialManagerBean->user_id;
        $tenderTruckBean = json_decode($tenderTruckBean->financial_details);
        $truck_payment_channel = $tenderTruckBean->payment_channel;

        // validate inputs
        if (!$waybillBean) {
            throw new Exception("waybill id is invalid");
        }
        $userBean = $userCore->getUserBasic($recipient_user_id, $user_id);
        if (!$userBean) {
            throw new Exception("recipient_user_id is invalid");
        }

        // get active claims on the truck
        $fps = new FPS();
        $filterObj = new stdClass();
        $filterObj->filter = new stdClass();
        $filterObj->filter->tn = $waybillBean->document->carrier[0]->truck->tn;
        $filterObj->filter->status = "ACTIVE";
        $claimsReuslt =  $fps->searchClaims($filterObj, 0);

        $totalClaimRemaingAmount = 0;
        // in case the truck has claim, deduct from net amount
        if ($claimsReuslt['found_rows']) {
            // get the remaining of each claim
            foreach ($claimsReuslt['data'] as $claim) {
                $remainingAmount =  $fps->getClaimRemainingAmount($claim['id'], 0);
                $totalClaimRemaingAmount += $remainingAmount;
            }
        }
        $downpayment = $totalClaimRemaingAmount;

        // get what services has been taken by the truck by searching on the complete vouchers for this waybill
        $filter = ['waybill_id' => $waybillBean->id, 'status' => 'COMPLETE'];
        $data = new stdClass();
        $data->filter = json_encode($filter);
        $voucherResult = $fps->searchVouchers($data, $user_id);
        $paymentFees = 5;
        $driverWageFees = 0;
        foreach ($voucherResult['data'] as $voucher) {
            if ($voucher['voucher_type_code'] == "DRIVER_WAGE") {
                $driverWageFees = 2;
            }
        }

        // get what services has been taken by the truck by searching on the complete vouchers for this queue_id
        $filter = ['waybill_id' => $waybillBean->id, 'status' => 'COMPLETE'];
        $data = new stdClass();
        $data->filter = json_encode($filter);
        $voucherResult = $fps->searchVouchers($data, $user_id);
        $paymentFees = 5;
        $driverWageFees = 0;
        foreach ($voucherResult['data'] as $voucher) {
            if ($voucher['voucher_type_code'] == "DRIVER_WAGE") {
                $driverWageFees = 2;
            }
        }



        $trx = [];
        $ledger_account_id = 590000;

        // -------------------- ذمة مدير المشروع  --------------------------------
        $trx_note = "حركة ذمة للمستند رقم " . $waybillBean->wn . " الشاحنة: " . $waybillBean->document->carrier[0]->truck->tn . " المستفيد: " . $userBean->name;
        $trx[] = array(
            "account_id" => $ledger_account_id . "-" . "50001",
            "amount" => $waybillBean->document->freight->amount->net_amount + $paymentFees,
            "op" => "D",
            "notes" => $trx_note,
            "trx_note" => ["text" => $trx_note],
            "source_account" => null,
            "target_account" => null
        );


        $cashBoxAmount = $waybillBean->document->freight->amount->net_amount;
        if ($downpayment > $cashBoxAmount) {
            $downpayment = $cashBoxAmount;
        }

        // -------------------- سداد ذمة الشاحنة --------------------------------
        if ($downpayment && $downpayment > 0) {
            $trx_note = "حركة سداد ذمة الشاحنة من المستند رقم " . $waybillBean->wn;
            $trx[] = array(
                "account_id" => $ledger_account_id . "-" . $waybillBean->document->carrier[0]->truck->tn,
                "amount" => $downpayment,
                "op" => "C",
                "notes" => $trx_note,
                "trx_note" => ["text" => $trx_note],
                "source_account" => null,
                "target_account" => null
            );
        }

        // --------------------  حركة الصندوق --------------------------------
        $availabelCashBoxes = $trx_template[1]->value;
        $trx_note = "حركة تصفية حساب للمستند رقم " . $waybillBean->wn;
        foreach ($availabelCashBoxes as $cashBox) {
            $cashBoxBean =  $fps->getAccountBasic($cashBox, $user_id);
            if (strtolower($cashBoxBean['payment_channel'][0]) == strtolower($truck_payment_channel)) {
                $account_id_2 = $cashBox;
            }
        }
        if (!$account_id_2) throw new Exception("payment method of source account does not match with truck payment channel");
        if ($waybillBean->document->freight->amount->net_amount - $downpayment - $driverWageFees > 0) {
            $trx[] = array(
                "account_id" => $account_id_2,
                "amount" => $waybillBean->document->freight->amount->net_amount - $downpayment - $driverWageFees,
                "op" => "C",
                "notes" => $trx_note,
                "trx_note" => ["text" => $trx_note],
                "source_account" => true,
                "target_account" => null
            );
        }

        // -------------------- ايراد الصرف -------------------------------
        $trx_note = "حركة ايراد الصرف للمستند رقم " . $waybillBean->wn;
        $account_id_3 = $trx_template[2]->value[0];
        $trx[] = array(
            "account_id" => $account_id_3,
            "amount" => 3.333,
            "op" => "C",
            "notes" => $trx_note,
            "trx_note" => ["text" => $trx_note],
            "source_account" => null,
            "target_account" => null
        );

        // -------------------- ايراد تنظيم الوثائق -------------------------------
        $account_id_4 = $trx_template[3]->value[0];
        $trx_note = "حركة ايراد تنظيم الوثائق للمستند رقم " . $waybillBean->wn;
        $trx[] = array(
            "account_id" => $account_id_4,
            "amount" => ($paymentFees + $driverWageFees) - 3.333,
            "op" => "C",
            "notes" => $trx_note,
            "trx_note" => ["text" => $trx_note],
            "source_account" => null,
            "target_account" => null
        );
        return $trx;
    }



    public function getWaybillRouteWageMode($trucking_company_id, $tender_id, $user_id)
    {

        // init objects
        $tenderCompanyCore = new TenderCompanyCore();

        $filter = [
            ["key" => "trucking_company_id", "val" => $trucking_company_id],
            ["key" => "status", "val" => ["ACTIVE", "NEW"], "op" => "in"],
            ["key" => "tender_id", "val" => $tender_id]
        ];
        $tenderCompany = $tenderCompanyCore->searchTenderCompany($filter, 1, 0, $user_id)->data;

        if (gettype($tenderCompany[0]->service_list) == 'string') {
            $tenderCompany[0]->service_list = json_decode($tenderCompany[0]->service_list);
        }

        $result = new stdClass();
        $result->code = '-';
        $result->caption = "-";
        if (sizeof($tenderCompany) > 0) {
            if ($tenderCompany[0]->service_list) {
                $list = $tenderCompany[0]->service_list;
                $flag = true;
                foreach ($list as $service) {
                    if ($service->code === "DISPATCH" && $service->type === "QUEUE") {
                        $flag = false;
                        $result->code = 'payable';
                        $result->caption = "أهالي";
                    }
                }
                if ($flag) {
                    $result->code = 'receivable';
                    $result->caption = "شركات";
                }
            }
        }

        return $result;
    }


    public function completeWaybillByMerchanht($waybill_id, $pa_id, $cash_value, $user_id)
    {

        $paymentAgentCore = new paymentAgentCore();

        $updateBean = new stdClass();
        $updateBean->id = $waybill_id;
        $updateBean->status = "COMPLETE";

        // $paBean = $paymentAgentCore->getPaymentAgentBasic($pa_id,0);
        // $updateBean->document->freight->pa = new stdClass();
        // $updateBean->document->freight->pa->id = $paBean->id;
        // $updateBean->document->freight->pa->company_id = $paBean->company_id;
        // $updateBean->document->freight->pa->company_name = $paBean->name;

        DBConnection::updateDB("waybill", $updateBean, $user_id);

        // log activity
        $this->logActivity(
            $waybill_id,
            "اغلاق مستند الشحن وانشاء أمر صرف مستحقات",
            "القيمة : " . $cash_value,
            "WAYBILL_PAYMENT",
            $user_id
        );
    }

    public function createDischargeReport($waybill_id,$answers,$user_id){

        $remarks = $answers[sizeof($answers)-1]['value'];
        $attachments = [];
        foreach ($answers as $answer) {
            if (strpos($answer['value'], "storage.googleapis.com") !== false) {
                $attachments[] = $answer['value'];
            }
        }
        $waybillBean = $this->getWaybillBasic($waybill_id,0);
        // get user basic and get the name and other information
        $user =  $this->_userCore->getUserBasic($user_id,0);
        $waybillBean->document->discharge_report = [
            "attachments" => $attachments,
            'remarks'=>$remarks,
            'done_by' => $user_id,
            'done_by_name'=>$user->name,
            'time_stamp' => DBConnection::getSystemDate()
        ];

        $this->updateWaybill($waybillBean, $waybill_id,0);

        // log activity
        $this->logActivity($waybill_id, "انشاء تقرير التسليم" , "", "check", $user_id);


    }
}
