<?php
error_reporting(E_ERROR | E_ALL);

// import required classes
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/../../includes/Captions.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/voucher_core.php");
require_once(dirname(__FILE__) . "/../notes/add_notes_core.php");
require_once(dirname(__FILE__) . "/../account/account_core.php");
require_once(dirname(__FILE__) . "/../user/user_core.php");
require_once(dirname(__FILE__) . "/../tender_claim/tender_claim_core.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/zain_cash.php");
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../taskQueues/taskQueues_core.php");
require_once(dirname(__FILE__) . "/../../core/waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../../core/waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../../core/payment_agent/payment_agent_core.php");


class Voucher_interface extends API{

    // the request of each call
    private $_request = array();
    private $_voucherCore;
    private $_accountCore;
    private $_userCore;
    private $_zain_cash;
    private $_taskQueuesCore;
    private $_waybillCore;
    private $_paymentAgentCore;
    private $_tenderClaimCore;

    public function __construct()
    {

        // call the super constructur
        $this->_request = parent::__construct();
        DBConnection::getInstance();
        session_start();
        if (!isset($_SESSION['user_id'])) {
            //throw new Exception("NO_SESSION",1);
        }
        $this->_voucherCore = new VoucherCore();
        $this->_accountCore = new AccountCore();
        $this->_userCore = new UserCore();
        $this->_zain_cash = new Zain_Cash();
        $this->_taskQueuesCore = new TaskQueuesCore();
        $this->_waybillCore = new WaybillCore();
        $this->_paymentAgentCore = new PaymentAgentCore();
        $this->_tenderClaimCore = new TenderClaimCore();

        // process the incoming request
        $this->processRequest();
    }

    // call the correnponding method based on what the request call
    private function processRequest(){
        $func = $this->_request->method;
        unset($this->_request->method);
        if ((int)method_exists($this, $func) > 0)
            $this->$func();
        else
            parent::response('Error code 404, method not found', 404);   // If the method not exist with in this class, response would be "Page not found".
    }

    // -------------------------------------------------------------- //
    // --------------------- get voucher info------------------------- //
    // -------------------------------------------------------------- //
    public function getVoucher(){

        $voucherBean = json_decode($this->_voucherCore->getVoucher($this->_request->id, $_SESSION['user_id']));

        // in case the payment_method is CHECK, calculate the number of items
        if($voucherBean->payment_method == 'CHECK'){
            $activity = $voucherBean->integration_details->activity;
 
            $searchTenderClaimItemsFilter = [
                ['key' => 'voucher_id', 'val' => $voucherBean->id],
                ['key' => 'status', 'val' => ["INACTIVE"], "op" => "not in"]
            ];

            if(!$activity){$activity = [];}
            $tenderClaims = $this->_tenderClaimCore->searchTenderClaimItems($searchTenderClaimItemsFilter, 1000, 0,$_SESSION['user_id']);

            $itemNote = new stdClass();
            $itemNote->code = "عدد الوصولات: " . $tenderClaims->found_rows;
            $activity[] = $itemNote;

            if(!$voucherBean->integration_details){
                $voucherBean->integration_details = new stdClass();
            }
            $voucherBean->integration_details->activity = $activity;
        }


        //return Success reponse
        parent::response($voucherBean);
    }

    // ------------------------------------------------------------------------ //
    // -------------------search for vouchers using  search filter ---------- //
    // ------------------------------------------------------------------------ //
    public function searchVouchers(){

        // call the core search
        $searchFilter = $this->prepareFilter();

        if ($_SESSION['u_id'] == 15407) {
            $searchFilter = [['key' => "id", 'val' => '2040043137']];
            $vouchers_qry = $this->_voucherCore->searchVouchers( $searchFilter,
                $this->_request->limit,
                $this->_request->offset,
                0,
                $this->_request->sort
            );
        } else {
            $vouchers_qry = $this->_voucherCore->searchVouchers( $searchFilter,
                $this->_request->limit,
                $this->_request->offset,
                $_SESSION['user_id'],
                $this->_request->sort
            );
        }


        parent::response($vouchers_qry);
    }

    private function prepareFilter(){
        $voucherFilter = [];
        if ($this->_request->filter) {
            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {
                if ($key == "date_from") {
                    $tempArr = ['key' => "create_date", 'val' => $value, 'op' => 'date greater than'];
                }
                else if($key == "date_to"){
                    $tempArr = ['key' => "create_date", 'val' => $value, 'op' => 'date less than'];
                }
                else if($key == "notes"){
                    $tempArr = ['key' => "trx_notes", 'val' => $value, 'op' => 'like'];
                }
                 else if($key == "payment_date_from"){
                    $tempArr = ['key' => "update_date", 'val' => $value, 'op' => 'date greater than'];
                }
                else if($key == "payment_date_to"){
                    $tempArr = ['key' => "update_date", 'val' => $value, 'op' => 'date less than'];
                }
                else if ($key == "check_number"){
                    $tempArr = ['key' => 'integration_details', 'val' => '"' . $value . '"', 'op' => 'json unquote', 'node' => '$.payment.ref_id'];
                }
                else if ($key == "waybill_id"){
                    $tempArr = ['key' => 'trx_template', 'val' => '"' . $value . '"', 'op' => 'json unquote', 'node' => '$.ref_id'];
                }
                else{
                    $tempArr = ['key' => $key, 'val' => $value, 'op' => '='];
                }
                array_push($voucherFilter, $tempArr);
            }
        }

        // filter voucher for pa
        if ($_SESSION['type'] == "CORPORATE" && $_SESSION['pa_id']) {
            $paymentAgentBean = $this->_paymentAgentCore->getPaymentAgentBasic($_SESSION['pa_id'], 0);

            $accountFilter = [['key' => "company_id", 'val' => $paymentAgentBean->company_id], ['key' => "status", 'val' => 'ACTIVE']];
            $account_qry = $this->_accountCore->searchAccount($accountFilter, 1, 0, 0);
            $tempArr = ['key' => 'from_account', 'val' => $account_qry->data[0]->id, 'op' => 'like'];
            array_push($voucherFilter, $tempArr);
        }

        return $voucherFilter;
    }



    // --------------------------------------------------------------------------- //
    // --------------------- process checks ------------------ //
    // --------------------------------------------------------------------------- //
    public function changeChecksStatus(){

        // get input params
        $array_id = $this->_request->filter->checks_id;
        $check_number = $this->_request->check_Number;

        try {
            // loop on each voucher
            DBConnection::startTransaction();
            foreach ($array_id as $voucher_id) {

                // validate payment method
                $voucherBean = $this->_voucherCore->getVoucherBasic($voucher_id, $_SESSION['user_id']);

                if ($voucherBean->payment_method != "CHECK") {
                    throw new Exception("لا تستطيع المتابعة ،طريقة الدفع لأمر الصرف رقم " . $voucherBean->id . " ليست شيك");
                }

                // write check number in voucher in case it is not saved
                if (!$check_number) {
                    throw new Exception("لا تستطيع المتابعة ، أمر الصرف رقم " . $voucherBean->id . " لا يحمل رقم شيك");
                }

                $integration_details = $voucherBean->integration_details ? $voucherBean->integration_details : new stdClass();
                $activity = $voucherBean->integration_details->activity ? $voucherBean->integration_details->activity : [];
                $new_act = new stdClass();
                $new_act->ref_id = $check_number;
                $new_act->code = "تمت عملية الصرف بموجب شيك رقم $check_number";
                $new_act->time_stamp = DBConnection::getSystemDate();
                $activity[] = $new_act;
                $integration_details->activity = $activity;
                $integration_details->payment = new stdClass();
                $integration_details->payment->ref_id = $check_number;
                $integration_details->payment->transaction_date = DBConnection::getSystemDate();
                $voucherBean->integration_details = $integration_details;
                $this->_voucherCore->updateVoucherInfo($voucherBean, $voucher_id, 0);

                if ($voucherBean->trx_template->ref_code == "AR_CLAIM") {
                    $this->_voucherCore->completeARVoucher($voucher_id, $check_number , $_SESSION['user_id']);
                } else {
                    // complete it
                    $this->_voucherCore->completeVoucher($voucher_id, $_SESSION['user_id']);
                }
            }
 
            DBConnection::commitTransaction();

            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "VOUCHER.SUCCESSFUL_OPERATION";
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            if ($e->getMessage() == 'SQLSTATE[10000]: <>: 100 Insufficient funds!') {
                throw new Exception("لا يوجد رصيد كاف لإتمام هذه العملية");
            } else {
                throw $e;
            }
        }
    }

    // --------------------------------------------------------------------------- //
    // --------------------- process checks ------------------ //
    // --------------------------------------------------------------------------- //
    public function createARclaimVoucher(){

        // get input params
        $payment_method = $this->_request->payment_method;
        $items = $this->_request->items;
        $from_account = $this->_request->account;
        $pa_id = $this->_request->pa_id;
        $tender_id = $this->_request->tender_id;
        try {
            if (!$payment_method) {
                throw new Exception("طريقة الدفع مطلوبة");
            }
            if (!$items || sizeof($items) == 0) {
                throw new Exception("الرجاء تحديد المستندات المراد صرفها");
            }

            // get ledger account
            $company_id = $_SESSION['company_id'];
            if(!$company_id){
                throw new Exception("شركة غير معرفة");
            }
            $account_filter = [['key' => 'company_id','val' =>$company_id]];
            $account = $this->_accountCore->searchAccount($account_filter,1,0,$_SESSION['user_id']);
            if($account->found_rows == 0){
                throw new Exception(" لا تستطيع المتابعة ، حيث لم يتمكن النظام من تحديد حساب الشركة");
            }
            $ledger_account = $account->data[0]->id;

            // loop on each voucher
            DBConnection::startTransaction();
            $tenderClaimCore = new TenderClaimCore();
            $tenderPaFilter = [
                ['key' => 'pa_id', 'val' => $pa_id],
                ['key' => 'status', 'val' => 'ACTIVE'],
                ['key' => 'tender_id', 'val' => $tender_id],
                ];
            $tenderPa = $this->_paymentAgentCore->searchTenderPaymentAgent($tenderPaFilter, 1, 0, 0)->data[0];
            $tenderPaAccounts = json_decode($tenderPa->accounts);
            if (!$tenderPaAccounts) {
                throw new Exception("لا يوجد حساب ذمة معرف على المشروع لمكتب الصرف على المطالبة");
            }
            foreach ($tenderPaAccounts as $acc) {
                if ($acc->AP) {
                    $acr = explode("-",$acc->AP);
                    if($acr[0] == $ledger_account){
                        $AP_account = $acc->AP;
                    }
                }
            }

            if(!$AP_account){
                throw new Exception('لا يوجد حساب ذمة معرف على المشروع لمكتب الصرف');
            }

            $total_amount = 0;
            $ar_waybills = [];

            //prepare voucher bean
            $bean = new stdClass();
            $bean->payment_method = strtoupper($payment_method);
            $bean->from_account = $from_account ;
            $bean->target_account = $AP_account;
            $bean->tender_id = $tender_id; //TODO get tender id
            $bean->template = null; //TODO get tempalte
            $bean->pa_name = $tenderPa->pa_name;
            $bean->pa_id = $tenderPa->pa_id;
            $bean->tender_pa = $tenderPa->id;
            $bean->remarks = "صرف مستحقات لمكتب صرف  $tenderPa->pa_name";
 
            // loop  on selected items to calculate the amount
            foreach ($items as $item_id) {
                $item = $tenderClaimCore->getTenderClaimItem($item_id, $_SESSION['user_id']);
                if (!$item) {
                    throw new Exception("invalid tender claim id");
                };
                if ($item->status != "APPROVED") {
                    $ref = $item->details->ref_num;
                    throw new Exception("لا تستطيع المتابعة، مستند البوليصة رقم $ref غير موافق عليه بعد");
                }
                if ($item->voucher_id) {
                    $ref = $item->details->ref_num;
                    throw new Exception("لا تستطيع المتابعة، مستند البوليصة رقم $ref مضاف على أمر صرف");
                }
                
                $details = $item->details;

                if(!$item->approved_freight){
                    $wn =$item->details->wn;
                    throw new Exception("لا تستطيع المتابعة، المستند رقم  $wn  لا يحمل مبلغ محتسب صحيح ");
                }

                $net_amount = $item->approved_freight->net_amount;

                // if there is a commission
                if($details->tender_payable_id){
                    $commission = $this->_tenderClaimCore->getTenderPayableCommissionAmount($details->tender_payable_id,$bean->pa_id);
                    $net_amount = $net_amount - floatval($commission);
                }

                $total_amount += $net_amount;

                $ar_waybills[] = $item;

                if ($payment_method == "ZAIN_CASH" && $total_amount > 2000) {
                    $total_amount -= $net_amount;
                    array_pop($ar_waybills);

                    $bean->amount = $total_amount;
                    $voucher_id = $this->_voucherCore->createARclaimVoucher($bean);
                    $this->_voucherCore->logTenderClaimItemWithVoucher($voucher_id, $ar_waybills, $_SESSION['user_id']);

                    $ar_waybills = [$item];
                    $total_amount = $net_amount;
                }
            }

            // create the voucher for pa
            $bean->amount = $total_amount;
            $voucher_id = $this->_voucherCore->createARclaimVoucher($bean);


            // update voucher id for all items that were included in the voucher
            $this->_voucherCore->logTenderClaimItemWithVoucher($voucher_id, $ar_waybills, $_SESSION['user_id']);

            DBConnection::commitTransaction();
            $Result['ERRORCODE'] = "0";
            $Result['voucher_id'] = $voucher_id;
            $Result['MESSAGE'] = "VOUCHER.SUCCESSFUL_OPERATION";
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            if ($e->getMessage() == 'SQLSTATE[10000]: <>: 100 Insufficient funds!') {
                throw new Exception("لا يوجد رصيد كاف لإتمام هذه العملية");
            } else {
                throw $e;
            }
        }
    }
    // --------------------------------------------------------------------------- //
    // --------------------- activate/Deactivate Employee Profile ------------------ //
    // --------------------------------------------------------------------------- //
    public function changeStatus(){

        try {

            $voucher_id = $this->_request->id;

            if ($this->_request->new_status == 'PENDING') {

                // get voucher basic bean
                $voucherBean = $this->_voucherCore->getVoucherBasic($voucher_id, $_SESSION['user_id']);
                switch (strtoupper($voucherBean->payment_method)) {
                    case 'ZAIN_CASH':
                        // change the status to Pending
                        $this->_voucherCore->changeStatus($voucher_id, $this->_request->new_status, $_SESSION['user_id']);

                        // prepare zain cash notes and then call zain API
                        $trx_template = $voucherBean->trx_template;
                        $zain_notes = $voucherBean->notes;
                        $result = $this->_zain_cash->processVoucherTrx($voucher_id, $zain_notes, $_SESSION['user_id']);
                        break;

                    case 'CHECK':
                        // process the voucher , then close it
                        throw new Exception("لا تستطيع المتابعة ، يجب صرف امر الصرف عن طريق الشيكات");
                        break;

                    case 'CASH':
                        // change the status to Pending
                        $this->_voucherCore->changeStatus($voucher_id, $this->_request->new_status, $_SESSION['user_id']);
                        break;
                    default:
                        throw new Exception("Payment method is not defined");
                        break;
                }
            }

            // when the user Revoked Voucher change waybill status to Closed
            else if ($this->_request->new_status == 'REVOKED') {
                $voucherBean = $this->_voucherCore->getVoucherBasic($voucher_id, $_SESSION['user_id']);
                if ($voucherBean->trx_template->ref_code == 'WAYBILL_COMPLETE') {
                    $waybillId = $voucherBean->trx_template->ref_id;
                    $this->_waybillCore->changeStatus($waybillId, 'CLOSED', $_SESSION['user_id']);
                }
                $this->_voucherCore->changeStatus($this->_request->id, $this->_request->new_status, $_SESSION['user_id']);
            } else {
                $this->_voucherCore->changeStatus($this->_request->id, $this->_request->new_status, $_SESSION['user_id']);
            }

            // write remarks if exist
            if ($this->_request->notes != null) {
                $addNoteCore = new Add_notes_core();
                $addNoteCore->addNotes('voucher', $this->_request->id, $this->_request->notes, $_SESSION['user_id']);
            }

            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "VOUCHER.SUCCESSFUL_OPERATION";
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            if ($e->getMessage() == 'SQLSTATE[10000]: <>: 100 Insufficient funds!') {
                throw new Exception("لا يوجد رصيد كاف لإتمام هذه العملية");
            } else {
                throw $e;
            }
        }
    }

    // --------------------------------------------------------------------------- //
    // --------------------- activate/Deactivate Employee Profile ------------------ //
    // --------------------------------------------------------------------------- //
    public function updateAttachment()
    {
        $this->_voucherCore->updateAttachment(
            $this->_request->id,
            $this->_request->attachment,
            $_SESSION['user_id']
        );

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "VOUCHER.SUCCESSFUL_OPERATION";
        parent::response($Result);
    }

    // ----------------------------------------------------------------------------------- //
    // ------------------- Create Voucher Manually --------------------------------------- //
    // ----------------------------------------------------------------------------------- //
    public function createVoucher(){

        $payment = (object) array(
            "name" => "MANUAL_VOUCHER",
            "label" => 'أمر صرف يدوي',
            "target_account" => $this->_request->target_account,
            "time_stamp" => DBConnection::getSystemDate(),
            "value" => $this->_request->amount
        );

        $VOUCHER_ID = $this->_voucherCore->createVoucher(
            $this->_request->from_account,
            $this->_request->target_account,
            $this->_request->amount,
            $this->_request->payment_method,
            $payment,
            DBConnection::getSystemDate(),
            null,
            $this->_request->ref_id,
            $this->_request->notes,
            $this->_request->tender_id
        );

        $Result['ERRORCODE'] = "0";
        $Result['VOUCHER_ID'] = $VOUCHER_ID;
        $Result['MESSAGE'] = "VOUCHER.SUCCESSFUL_OPERATION";
        parent::response($Result);
    }

    // --------------------------------------------------------------------------- //
    // --------------------- activate/Deactivate Employee Profile ------------------ //
    // --------------------------------------------------------------------------- //
    public function searchVoucherReports(){
        $vouchers = DBConnection::searchReport("voucher", "01", [], 100, 0, $_SESSION['user_id']);
        $date = date_create(DBConnection::getSystemDate());

        $dateArray = [];
        $dateArray[date_format($date, "Ymd")] = [];
        for ($i = 1; $i < 7; $i++) {
            $dateArray[date('Ymd', strtotime(date_format($date, "Y/m/d") . "+" . $i . " days"))] = [];
        }

        foreach ($vouchers->data as $vouchersKey => $vouchersValue) {
            foreach ($dateArray as $key => $value) {
                if ($key == $vouchersValue->due_date_system) {
                    array_push($dateArray[$key], $vouchersValue->cnt);
                    array_push($dateArray[$key], $vouchersValue->amount);
                }
            }
        }
        parent::response($dateArray);
    }

    // ------------------------------------------------------------------------------------ //
    // --------------------- validte e-payment with CBJ and complete trx ------------------ //
    // ------------------------------------------------------------------------------------ //
    public function completeTrx(){
        $voucher_id = $this->_request->voucher_id;
        $ref_id = $this->_request->ref_id;
        $trial = $this->_request->trial;
        if (!$trial) {
            $trial = 1;
        }

        // create JCB task
        $this->_taskQueuesCore->createCompleteZainCashTask($voucher_id, $ref_id, $trial, 1);
    }

    // ------------------------------------------------------------------------------------ //
    // --------------------- get list of beneficiaries ----------------------------------- //
    // ------------------------------------------------------------------------------------ //
    public function getBeneficiaries(){
        try {
            // sql queury
            $sqlQuery = "select * from beneficiary_address_book where status = ?";
            $param = ['ACTIVE'];
            $beneficiaries = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

            // return list
            parent::response($beneficiaries);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------------------ //
    // --------------------- add beneficiary to db --------------------------------------- //
    // ------------------------------------------------------------------------------------ //
    public function addBeneficiary(){
        try {
            $name = trim($this->_request->name);

            if (!$name) {
                throw new Exception('الرجاء التحقق من الاسم');
            }

            // sql queury
            $sqlQuery = "INSERT INTO beneficiary_address_book (name,status,update_by) values(?,?,?);";

            $param = [$name, 'ACTIVE', $_SESSION['u_id']];
            DBConnection::runBindDatabaseQuery($sqlQuery, $param);

            // return response
            $result['ERRORCODE'] = '0';
            $result['MESSAGE'] = 'SUCCESSFUL.OPERATION';
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------------------ //
    // --------------------- remove beneficiary from db --------------------------------------- //
    // ------------------------------------------------------------------------------------ //
    public function removeBeneficiary()
    {
        try {
            $id = $this->_request->id;

            if (!$id) {
                throw new Exception('الرجاء التحقق من المعلومات');
            }

            // sql queury
            $sqlQuery = "UPDATE beneficiary_address_book SET status = ?, update_by = ? WHERE id = ?";

            $param = ['INACTIVE', $_SESSION['u_id'], $id];
            DBConnection::runBindDatabaseQuery($sqlQuery, $param);

            // return response
            $result['ERRORCODE'] = '0';
            $result['MESSAGE'] = 'SUCCESSFUL.OPERATION';
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    //----------------------------------------------------------------------------------------------//
    //------------------------------------getVoucherListDetailsForMobile----------------------------//
    //----------------------------------------------------------------------------------------------//
    public function getVoucherListDetails(){


        if ($_SESSION['u_id'] == 15407) {
            $voucher = $this->_voucherCore->getVoucherBasic($this->_request->voucher_id, 0);
        } else {
            $voucher = $this->_voucherCore->getVoucherBasic($this->_request->voucher_id, $_SESSION['user_id']);
        }

        $result = new stdClass();
        if ($voucher) {
            $voucherBeanData = $voucher;
            $html = $this->_voucherCore->renderVoucherDetails($voucherBeanData);
        } else {
            $html = $this->_voucherCore->renderInvaildVoucher();
            $result->ERRORCODE = 500;
            $result->tabs = [
                "تفاصيل امر الصرف" => $html
            ];
        }
        $result->ERRORCODE = 0;
        $result->tabs = [
            "تفاصيل امر الصرف" => $html
        ];
        parent::response($result);
    }


    //---------------------------------------------------------------------------------------------------------//
    //------------------------------- change the payment method for a certain voucher -------------------------//
    //---------------------------------------------------------------------------------------------------------//
    public function changePaymentMethod(){

        // get user params
        $voucher_id = $this->_request->voucher_id;
        $new_payment_method = $this->_request->new_payment_method;

        // get voucher bean
        $voucherBean = $this->_voucherCore->getVoucherBasic($voucher_id, $_SESSION['user_id']);

        // the voucher can be changed from zain_cash to CHECK only
        $allow_continue = false;
        if ($voucherBean->payment_method == 'ZAIN_CASH' && $new_payment_method == 'CHECK') {
            $allow_continue = true;
        }
        if (!$allow_continue) {
            throw new Exception("لا تستطيع تغير طريقة الدفع للطريقة المطلوبة");
        }

        // change payment method
        $this->_voucherCore->changePaymentMethod($voucher_id, $new_payment_method, $_SESSION['user_id']);

        // return response
        $result['ERRORCODE'] = '0';
        $result['MESSAGE'] = 'SUCCESSFUL.OPERATION';
        parent::response($result);
    }
}
$user_interface = new Voucher_interface();
