<?php
require_once (dirname(__FILE__)."/../API.php");
require_once (dirname(__FILE__)."/voucher_core.php");
require_once (dirname(__FILE__)."/../user/user_core.php");
require_once (dirname(__FILE__)."/../tender/tender_core.php");
require_once (dirname(__FILE__)."/../account/account_core.php");
require_once (dirname(__FILE__)."/../waybill_draft/waybill_draft_core.php");
require_once (dirname(__FILE__)."/../payment/payment_core.php");
require_once (dirname(__FILE__)."/../notification/notification_core.php");
require_once (dirname(__FILE__)."/../../includes/util.php");

class Voucher_integeratrion extends API{

    // the request of each call
    private $_voucherCore;
    private $_userCore;
    private $_tenderCore;
    private $_accountCore;
    private $_paymentCore;
    private $_waybillDraft;

    public function __construct(){
        
        // call the super constructur
        $this->_request = parent::__construct();

        session_start();    
        if( !isset($_SESSION['user_id'])){
             //throw new Exception('No Session!');
        }

        // init the object
        $this->_voucherCore = new VoucherCore();
        $this->_userCore = new UserCore();
        $this->_tenderCore = new TenderCore();
        $this->_accountCore = new AccountCore();
        $this->_paymentCore = new PaymentCore();
        $this->_waybillDraft = new WaybillDraftCore();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }
    
    
    // --------------------------------------------------------------------------------------------------------------- //
    // ------------------------------ Get certain voucher details in orderto continue trx process -------------------- //
    // --------------------------------------------------------------------------------------------------------------- //
    public function getVoucherDetails(){
        
        try{
        // parse incoming data
        $private_key = $this->_request->private_key;
        $voucherResult = new stdClass();

        // search for all pending vouchers
        $filter = [['key'=>'status','val' => ['PENDING'] , 'op'=>'in']];
        $pendingVouchers = $this->_voucherCore->searchVouchers($filter, 10000 , 0 , $_SESSION['user_id']);
            //$pendingVouchers = $this->_voucherCore->searchVouchers($filter, 10000 , 0 , 0);

        // loop on them and has each id to match it with requested private_key
        foreach ($pendingVouchers->data as $voucher) {
            $hash_voucher_id = md5($voucher->id);

            // when found , extract the needed info
            if($hash_voucher_id == $private_key){
                
                $trx_template = json_decode($voucher->trx_template);
                $notes = $voucher->notes;
                $notes_arr = explode("-",$notes);

                $voucherResult->name = $trx_template->name?$trx_template->name:$notes_arr[0];
                $voucherResult->amount = $voucher->amount;
                $voucherResult->phone = $trx_template->phone?$trx_template->phone:$notes_arr[3];
            }
        }
        
        // return result
        $Result['ERRORCODE'] = "0";
        $Result['RESULT'] = $voucherResult;
        parent::response($Result);            
        }
        catch(Exception $e){

        }

    }


    // ----------------------------------------------------------------------------------- //
    // ------------------- Create Voucher by answering tips poll ------------------------- //
    // ----------------------------------------------------------------------------------- //
    public function processPollAnswerToCreateVoucher(){

        try {
            $voucher_type = $this->_request->voucher_type;
            $voucher_label = $this->_request->voucher_label;
            $from_account = $this->_request->from_account;
            $payment_method = $this->_request->payment_method;
            $tender_id = $this->_request->tender_id;
            $user_id = $this->_request->user_id;
            $poll_id = $this->_request->poll_id;
            $wallet_id = $this->_request->wallet_id;
            $bind_params = json_decode($this->_request->bind_params);
            $bind_params = json_decode(json_encode($bind_params),true);
            $answers = $this->_request->answers;
            $notificationCore = new NotificationCore();

            $user_answer = "";
            foreach ($answers as $ans) {
                if($ans->question_id == 0){
                    $user_answer = $ans->value;
                }
            }
  
            if($user_answer == 1){
                // get target account
                $searchFilter = [['key' => "user_id", 'val' => $user_id]];
                $account_qry = $this->_accountCore->searchAccount($searchFilter, 1, 0, 0);
                $target_account = $account_qry->data[0]->id . "," .  $account_qry->data[0]->sub_id;
                $to_account = $target_account;
                $due_date = null;
                $ref_code = $voucher_type;
                $ref_id = null;
                $notes = $voucher_label;
                $voucher_type = $voucher_type;
                $value = new stdClass();
                $voucher_amount = $bind_params['amount'];
                $value->amount = $voucher_amount;

                $clientPayment = (object) array("name"=> $voucher_type . "_PAYMENT",
                    "label"=>$voucher_label,
                    "target_account"=>$target_account,
                    "wallet_id" => $wallet_id,
                    "poll_id" => $poll_id,
                    "time_stamp" => DBConnection::getSystemDate(),
                    "value"=>$value);
                    
                $voucher_id = $this->_voucherCore->createVoucher($from_account, $to_account, $voucher_amount,
                                                                 strtoupper($payment_method) ,$clientPayment,null,
                                                                 $ref_code, $ref_id, $notes , $tender_id, $voucher_type);


                // log voucher id in recipents
                $pollIntegration = new Poll();
                $pollBean = $pollIntegration->getPoll($poll_id);
                foreach ($pollBean['recipients'] as &$recipient) {
                    if($recipient['remote_user_id'] == $user_id){
                        $recipient_id = $recipient['id'];
                    }
                }
                $pollIntegration->logActivity($recipient_id, "انشاء أمر الصرف: " . $voucher_id . "بقيمة: ". $voucher_amount, "VOUCHER_ID");               

                $payload = new stdClass();
                $payload->type = "set_notification";
                $payload->id = 2222;
                $payload->message =  "تمت الاجابة على الاستبيان بنجاح ، ستصلك رسالة نصية عند تحويل المبلغ لمحفظتك الالكترونية";
                $notificationCore->sendDataMessage($user_id,$payload);

                $Result['ERRORCODE'] = "0";
                $Result['VOUCHER_ID'] = $voucher_id;
                $Result['MESSAGE'] = "VOUCHER.SUCCESSFUL_OPERATION";
                parent::response($Result);
            }
        } catch (Exception $e) {
            // send notification to user
            $payload = new stdClass();
            $payload->type = "set_notification";
            $payload->id = 1;
            $payload->message = $e->getmessage()  . json_encode($this->_request, JSON_UNESCAPED_UNICODE);
            $notificationCore->sendDataMessage(2,$payload);

        }
        
       

    }


    // ------------------------------------------------------------------------------------------------------------------ //
    // ------------------------------ process a certain voucher after validatin the trx with zain cash ------------------ //
    // ------------------------------------------------------------------------------------------------------------------ //
    public function processVoucherResult(){
        
        try{

            DBConnection::startTransaction();

            // parse incoming params
            $private_key = $this->_request->private_key;
            $result = $this->_request->result;
            // un-hash the private key
            $voucher_id = $this->unhashPrivateKey($private_key);
            if(!$voucher_id){
                $result = [];
                $result['ERRORCODE'] = "500";
                $result['MESSAGE'] = "ERROR.CANT_FIND_VOUCHER";
                parent::response($result);
            }

            if(!$voucher_id){
                throw new Exception("رقم أمر الصرف غير صحيح");
            }

            // update integeration node
            $voucherBean = $this->_voucherCore->getVoucherBasic($voucher_id,$_SESSION['user_id']);
    
            $ledger_account_id = 777412;
            $payment_value = $voucherBean->trx_template->payment->value;

            if(!$payment_value || gettype($payment_value) == 'object'){
                $payment_value = $voucherBean->trx_template->payment->value->amount;
            }
            if(!$payment_value){
                $payment_value = $voucherBean->trx_template->amount;
            }
            if(!$payment_value){
                throw new Exception("قيمة أمر الصرف غير صحيح");
            }
 
            $remarksTRX =  $voucherBean->notes;
            $cash_account_id = $voucherBean->trx_template->from_account;
            $claim_account_id = "777412-20436"; //  hard coded

            switch ($voucherBean->trx_template->voucher_type) {
                // if the voucher is downpayment
                case 'CASH_DOWNPAYMENT':                
                    $jv_id = $this->_paymentCore->logWaybillAdvancePaymentTrx($payment_value, $ledger_account_id, $cash_account_id, $remarksTRX, $_SESSION['user_id']);    
                    break;

                // if the voucher is waybill_complate                    
                case 'WAYBILL_COMPLETE':                    
                    // get the following info from waybill_draft
                    $waybillDraftId = $voucherBean->trx_template->waybill_draft_ref_id;
                    $waybillDraftBean = $this->_waybillDraft->getWaybillDraft($waybillDraftId);
                    $waybillDraftBean->document= json_decode($waybillDraftBean->document);

                    $advanced_payment = $waybillDraftBean->document->freight->amount->total_advance_payment;
                    $total_deductions = $waybillDraftBean->document->freight->amount->total_deductions;
                    $total_fines = $waybillDraftBean->document->freight->amount->total_fines;
                    $net_amount = $waybillDraftBean->document->freight->amount->net_amount;
                    $base_amount = $waybillDraftBean->document->freight->amount->base_amount;

                    $jv_id = $this->_paymentCore->logCompleteVoucherTrx($net_amount,$base_amount,$advanced_payment, $total_deductions , $total_fines,
                                                                        $ledger_account_id ,$cash_account_id ,$claim_account_id,
                                                                        null, $remarksTRX, 19 ,$_SESSION['user_id']);
                    break;

                default:
                    throw new Exception("INVALID Voucher type");
                    break;
            }

            // complete it
            $voucherBean->jv_id = $jv_id;
            $voucherBean->payment_date = DBConnection::getSystemDate();
            $voucherBean->status = "COMPLETE";
            $this->_voucherCore->updateVoucherInfo($voucherBean, $voucherBean->id, $_SESSION['user_id']);

            DBConnection::commitTransaction();

        // return response
        $result = [];
        $result['ERRORCODE'] = "0";
        $result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
        parent::response($result);
        }
        catch(Exception $e){
            //logHamzeh("error",$e->getMessage());
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }

    }


    // -------------------------------------------------------------------------------------------------------- //
    // ----------------------- Log any error in the integration details node inside the voucher --------------- //
    // -------------------------------------------------------------------------------------------------------- //
    public function logVoucherTransaction(){

        try{

                // parse incoming params
                $private_key = $this->_request->private_key;
                $code = $this->_request->code;

                // un-hash the private key
                $voucher_id = $this->unhashPrivateKey($private_key);

                if(!$voucher_id){
                    throw new Exception("Invalid Voucher");
                }

                // update integeration node
                $voucherBean = $this->_voucherCore->getVoucherBasic($voucher_id,$_SESSION['user_id']);
                $integration_details = $voucherBean->integration_details ? $voucherBean->integration_details : new stdClass();
                $activity = $voucherBean->integration_details->activity ? $voucherBean->integration_details->activity : [];
                $new_act = new stdClass();
                $new_act->code = $code;
                $new_act->time_stamp = DBConnection::getSystemDate();
                $activity[] = $new_act;
                $integration_details->activity = $activity;
                $voucherBean->integration_details = $integration_details;
                $this->_voucherCore->updateVoucherInfo($voucherBean , $voucher_id, $_SESSION['user_id']);

                // change status from  PENDING  -> INCOMPLETE
                $this->_voucherCore->changeStatus($voucher_id,'INCOMPLETE',$_SESSION['user_id']);

                // return response
                $result = [];
                $result['ERRORCODE'] = "0";
                $result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
                parent::response($result);

            // TODO: send notification to the user who start the process

        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }        
    }

    // -------------------------------------------------------------------------------------------- //
    // ----------------------- convert the hash private key to clar text voucher id --------------- //
    // -------------------------------------------------------------------------------------------- //
    private function unhashPrivateKey($private_key){

        // search for all pending vouchers
        $filter = [['key'=>'status','val' => 'PENDING']];
        $pendingVouchers = $this->_voucherCore->searchVouchers($filter, 10000 , 0 , $_SESSION['user_id']);

        // loop on them and has each id to match it with requested private_key
        foreach ($pendingVouchers->data as $voucher) {
            $hash_voucher_id = md5($voucher->id);           
            if($hash_voucher_id == $private_key){                
                $voucher_id = $voucher->id;
            }
        }

        // return result
        return $voucher_id;
    }


}

new Voucher_integeratrion();