<?php

// import objects
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../../core/account/account_core.php");
require_once(dirname(__FILE__) . "/../../core/trx/trx_core.php");
require_once(dirname(__FILE__) . "/../../core/waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../../core/tender/tender_core.php");
require_once(dirname(__FILE__) . "/../../core/notification/notification_core.php");
require_once(dirname(__FILE__) . "/../../core/user/user_core.php");
require_once(dirname(__FILE__) . "/../../core/payment/payment_core.php");


class VoucherCore
{
  public function __construct()
  {
    DBConnection::getInstance();
  }

  // ------------------------------------------------------------------------ //
  // -------------------get  voucher from DB  ---------------------------- //
  // ------------------------------------------------------------------------ //
  public function getVoucher($id, $user_id)
  { // IMPORTANT: user_id is the user who search not the user we are looking for.

    $voucherInfo = DBConnection::getObjectBean("voucher", $id, $user_id);
    if ($voucherInfo == null) {
      throw new Exception("VOUCHER.NOT_EXIST", 0);
    }
    return $voucherInfo;
  }

  // ---------------------------------------------------------------------------------------------- //
  // -------------------get basic version of voucher from DB (without activities)  ---------------- //
  // ---------------------------------------------------------------------------------------------- //
  public function getVoucherBasic($id, $user_id)
  {
    $voucherInfo = DBConnection::getBasicObjectBean("voucher", $id, $user_id);
    return $voucherInfo;
  }

  // -------------------------------------------------------------------------- //
  // -------------------search for vouchers using any search filter ---------- //
  // -------------------------------------------------------------------------- //
  public function searchVouchers($searchFilter, $limit, $offset, $user_id, $sort = " order by id desc ")
  {
    if ($sort == 'desc' || $sort == 'asc') {
      $sort = "order by id " . $sort;
    }

    $VouchersResult = DBConnection::searchDB("voucher", $searchFilter, $limit, $offset, $user_id, $sort);
    return $VouchersResult;
  }

  // ------------------------------------------------------------------------------------------ //
  // --------------------- complete voucher and all its financial porocess--------------------- //
  // ------------------------------------------------------------------------------------------ //
  public function completeVoucher($voucher_id, $user_id)
  {

    // init objects
    $paymentCore = new PaymentCore();
    $waybillCore = new WaybillCore();
    $accountCore = new AccountCore();
    $notificationCore = new NotificationCore();

    // get voucher
    $voucherBean = $this->getVoucherBasic($voucher_id, 0);

    // complete voucher
    if ($voucherBean->trx_template->ref_code == 'WAYBILL_DOWNPAYMENT' && $voucherBean->trx_template->voucher_type == 'CASH_DOWNPAYMENT') {
      $jv_id = $paymentCore->completeDownPaymentVoucherProcedure($voucher_id);
    } else {
      $jv_id = $paymentCore->completeVoucherFinancialProcedure($voucher_id);
    }
    if (!$jv_id) {
      throw new Exception("Error Processing Request , close JV_id is not exist");
    }

    // log the jv_id in voucher and change status to complete
    $voucherBean->jv_id = $jv_id;
    $voucherBean->payment_date = DBConnection::getSystemDate();
    $voucherBean->status = "COMPLETE";
    $this->updateVoucherInfo($voucherBean, $voucher_id, 0);

    if ($voucherBean->trx_template->ref_code == 'WAYBILL_COMPLETE') {
      // get the waybill bean
      $waybill_id = $voucherBean->trx_template->ref_id;
      $waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);
      $target_account = $voucherBean->trx_template->target_account;

      // prepare notification obj
      $accountFilter = [['key' => "id", 'val' => $target_account], ['key' => "status", 'val' => 'ACTIVE']];
      $account_qry = $accountCore->searchAccount($accountFilter, 1, 0, 0);
      $target_account_user_id = $account_qry->data[0]->user_id;
      $payload = new stdClass();
      $payload->type = "set_notification";
      $payload->id = rand(1, 1000);

      // get the amount to be logged
      $waybill_payment_amount = $voucherBean->trx_template->amount;

      //send notification
      if ($target_account_user_id) {
        $payload->message = 'قيد مستحقات عن مستند الشحن رقم ' . $waybillBean->wn . " بمبلغ " . $waybill_payment_amount . " دينار";
        $notificationCore->sendDataMessage($target_account_user_id, $payload);
      }

      // write the waybill_document
      $payment = $voucherBean->trx_template->payment;
      $waybillCore->addWaybillPaymentNode($waybillBean->id, $payment);
    }
  }


  // ------------------------------------------------------------------------------------------ //
  // --------------------- complete voucher and all its financial porocess--------------------- //
  // ------------------------------------------------------------------------------------------ //
  public function completeServiceVoucher($voucher_id, $user_id)
  {
    // init objects
    $paymentCore = new PaymentCore();
    // get voucher
    $voucherBean = $this->getVoucherBasic($voucher_id, 0);

    // complete voucher
    $jv_id = $paymentCore->logServiceVoucherTrx($voucher_id, $user_id);
    if (!$jv_id) {
      throw new Exception("Error Processing Request , close JV_id is not exist");
    }

    // log the jv_id in voucher and change status to complete
    $voucherBean->jv_id = $jv_id;
    $voucherBean->payment_date = DBConnection::getSystemDate();
    $voucherBean->status = "COMPLETE";
    $this->updateVoucherInfo($voucherBean, $voucher_id, 0);
  }


  // ------------------------------------------------------------------------------------------ //
  // --------------------- complete voucher and all its financial porocess--------------------- //
  // ------------------------------------------------------------------------------------------ //
  public function completeReceiptVoucher($voucher_id, $user_id)
  {
    // init objects
    $paymentCore = new PaymentCore();
    // get voucher
    $voucherBean = $this->getVoucherBasic($voucher_id, 0);

    // complete voucher
    $jv_id = $paymentCore->logReceiptVoucherTrx($voucher_id, $user_id);
    if (!$jv_id) {
      throw new Exception("Error Processing Request , close JV_id is not exist");
    }

    // log the jv_id in voucher and change status to complete
    $voucherBean->jv_id = $jv_id;
    $voucherBean->payment_date = DBConnection::getSystemDate();
    $voucherBean->status = "COMPLETE";
    $this->updateVoucherInfo($voucherBean, $voucher_id, 0);
  }

  // ------------------------------------------------------------------------------------------ //
  // --------------------- complete voucher and all its financial porocess--------------------- //
  // ------------------------------------------------------------------------------------------ //
  public function completeARVoucher($voucher_id, $check_number, $user_id)
  {

    // init objects
    $paymentCore = new PaymentCore();
    $waybillCore = new WaybillCore();

    // get voucher
    $voucherBean = $this->getVoucherBasic($voucher_id, 0);

    // complete voucher
    $jv_id = $paymentCore->logARVoucherTrx($voucher_id, $check_number);
    if (!$jv_id) {
      throw new Exception("Error Processing Request , close JV_id is not exist");
    }

    // log the jv_id in voucher and change status to complete
    $voucherBean->jv_id = $jv_id;
    $voucherBean->payment_date = DBConnection::getSystemDate();
    $voucherBean->status = "COMPLETE";
    $this->updateVoucherInfo($voucherBean, $voucher_id, 0);


    // get the waybill bean
    $tender_claim_id = $voucherBean->trx_template->ref_id;
    $searchFilter = [
      ['key' => 'voucher_id', 'val' => $voucherBean->id],
      ['key' => 'status', 'val' => 'APPROVED']
    ];
    $tenderClaimCore = new TenderClaimCore();
    $tenderClaimItems = $tenderClaimCore->searchTenderClaimItems($searchFilter, 10000, 0, 0, null);

    if ($tenderClaimItems->found_rows > 0) {
      foreach ($tenderClaimItems->data as $item) {
        $item->status = 'COMPLETE';
        DBConnection::updateDB('tender_claim_item', $item, 0);
      }
    }
  }


  // --------------------------------------------------------------------------- //
  // ---------------------activate/ Deactivate  voucher---------------------- //
  // --------------------------------------------------------------------------- //
  public function changeStatus($id, $new_status, $user_id)
  {
    $updateStruct = new stdClass();
    $updateStruct->id = $id;
    $updateStruct->status = $new_status;

    $voucherBasicBean = $this->getVoucherBasic($id, 0);

    if ($new_status == "REVOKED" && $voucherBasicBean->jv_id) {
      $updateStruct->jv_id = null;
    }

    // change the status
    DBConnection::updateDB("voucher", $updateStruct, $user_id);

    if ($new_status == "REVOKED" && $voucherBasicBean->jv_id) {

      // get all trx for this jv
      $jv_trx = $this->getJvTrx($voucherBasicBean->jv_id);

      // generate trx JSON by reversing each trx
      $reverse_trx = [];
      foreach ($jv_trx as $trx) {
        $temp = new stdClass();
        $temp->amount =  $trx->amount;
        $ledger_account_id =  $trx->account_id;
        $temp->account = $trx->account_id . "-" . $trx->sub_id;
        if ($trx->op == 'C') $temp->op = 'D';
        if ($trx->op == 'D') $temp->op = 'C';
        $temp->notes =  "عكس الحركة رقم " . $trx->id;

        $reverse_trx[] = $temp;
      }


      // insert trx
      $jv_date = DBConnection::getSystemDate();
      $remarks = "عكس حركات أمر الصرف " . $id;
      $paymentCore = new PaymentCore();
      $paymentCore->addJV($ledger_account_id, $jv_date, $reverse_trx, $remarks, $user_id);


      //if the voucher is DIESEL_DOWNPAYMENT , return the copoun status to ACTIVE
      if ($voucherBasicBean->trx_template->payment->name == "DISEL_PAYMENT") {
        if ($voucherBasicBean->integration_details && $voucherBasicBean->integration_details->activity) {
          $couponNumber  = $voucherBasicBean->integration_details->activity[0]->ref_id;
          if ($couponNumber) {
            $this->_merchantIntegration->changeStatus('ACTIVE', $couponNumber);
          }
        }
      }

      return $voucherBasicBean->jv_id;
    }
  }

  // --------------------------------------------------------------------------- //
  // ---------------------activate/ Deactivate  voucher---------------------- //
  // --------------------------------------------------------------------------- //
  public function updateAttachment($id, $attachment, $user_id)
  {
    $updateStruct = new stdClass();
    $updateStruct->id = $id;
    $updateStruct->photo = $attachment;

    // change the status
    DBConnection::updateDB("voucher", $updateStruct, $user_id);
  }

  // ---------------------------------------------------------------------------- //
  // -------------------- create new voucher ------------------------------------ //
  // ---------------------------------------------------------------------------- //
  public function createVoucher(
    $from_account,
    $target_account,
    $amount,
    $payment_method,
    $payment,
    $due_date,
    $ref_code,
    $ref_id,
    $remarks,
    $tender_id,
    $template = null,
    $user_id = 0
  ) {

    if (!$from_account) {
      throw new Exception("Invalid account ID in from_account, $from_account");
    }
    if (!$target_account) {
      throw new Exception("Invalid account ID in to_account, $target_account");
    }

    // get accounts bean
    $accountCore = new AccountCore();
    $fromAccountBean = $accountCore->getAccountBasic($from_account, 0);
    $targetAccountBean = $accountCore->getAccountBasic($target_account, 0);

    // TODO: validate voucher
    if (!$payment_method) {
      throw new Exception("لا تستطيع المتابعة ، لم يتم تحديد اّلية الدفع");
    }
    if ($amount < 0) {
      throw new Exception("لا تستطيع المتابعة قيمة أمر الصرف أقل من 0");
    }


    if ($tender_id) {
      $tenderCore = new TenderCore();
      $man = $tenderCore->getTenderManifest($tender_id, 0);
      if ($template) {
        $voucher_template = $template;
      } else {
        $voucher_template = $man['voucher_template'];
      }
    }

    $refcode_vouchertype_map = [
      'WAYBILL' => 'WAYBILL_COMPLETE',
      'WAYBILL_DRAFT_EXPORT_PHOSPHATE_COMPLETED' => 'WAYBILL_COMPLETE',
      'WAYBILL_DRAFT_EXPORT_PHOSPHATE_DISEL' => 'DIESEL_DOWNPAYMENT',
      'WAYBILL_DRAFT_EXPORT_PHOSPHATE_PERSONAL' => 'CASH_DOWNPAYMENT',
      'TIPS' => 'TIPS',
      'RECEIPT_VOUCHER' => 'RECEIPT_VOUCHER',
      'WAYBILL_DOWNPAYMENT' => 'CASH_DOWNPAYMENT',
      'PAYABLE_VOUCHER' => 'CASH_DOWNPAYMENT',
      'CARGO_SERVICE' => 'RECEIPT_VOUCHER',
    ];
    $oldref_newref_map = [
      'WAYBILL_DOWNPAYMENT' => 'WAYBILL_DOWNPAYMENT',
      'WAYBILL' => 'WAYBILL_COMPLETE',
      'WAYBILL_DRAFT' => 'WAYBILL_DRAFT',
      'WAYBILL_DRAFT_EXPORT_PHOSPHATE_COMPLETED' => 'WAYBILL_DRAFT',
      'WAYBILL_DRAFT_EXPORT_PHOSPHATE_DISEL' => 'WAYBILL_DRAFT',
      'WAYBILL_DRAFT_EXPORT_PHOSPHATE_PERSONAL' => 'WAYBILL_DRAFT',
      'TIPS' => 'TIPS',
      'RECEIPT_VOUCHER' => 'WAYBILL_SERVICE',
      'PAYABLE_VOUCHER' => 'WAYBILL_SERVICE',
      'CARGO_SERVICE' => 'WAYBILL_DRAFT_SERVICE',
    ];

    $voucher_type = $refcode_vouchertype_map[$ref_code];
    $new_ref_code = $oldref_newref_map[$ref_code];
    // get phone from target account
    if ($targetAccountBean->user_id) {
      $userCore = new UserCore();
      $targetUserBean = $userCore->getUserBasic($targetAccountBean->user_id, 0);
      $phone = $targetUserBean->phone;
    }

    // prepare trx_template
    $trx_template = new stdClass();
    $trx_template->from_account = $from_account;
    $trx_template->from_account_name = $fromAccountBean->name;
    $trx_template->target_account = $target_account;
    $trx_template->target_account_name = $targetAccountBean->name;
    $trx_template->amount = $amount;
    $trx_template->phone = $phone;
    $trx_template->ref_code = $new_ref_code;
    $trx_template->ref_id = "$ref_id";
    $trx_template->payment = $payment;
    $trx_template->tender_id = $tender_id;
    $trx_template->voucher_type = $voucher_type;

    if (strtoupper($payment_method) == "MINAGATE_CASH") {
      $payment_method = "CASH";
    }


    if (strtoupper($payment_method) == "CHECK") {
      $trx_template->check_number = $payment->check_number;
      $trx_template->bank_branch = $payment->bank_branch;
    }

    // prepare voucher bean
    $voucherBean = new stdClass();
    $voucherBean->trx_template = $trx_template;
    $voucherBean->payment_method = $payment_method;
    $voucherBean->notes = $remarks;
    $voucherBean->system_code = $voucher_template;

    if ($due_date) {
      $voucherBean->due_date = $due_date;
    } else {
      $voucherBean->due_date = DBConnection::getSystemDate();
    }

    $voucherBean->status = 'NEW';
    // create Database record
    $createVoucherResult = DBConnection::insertDB("voucher", $voucherBean, 0);
    $voucher_id = $createVoucherResult[0]['@id'];

    if (strtoupper($payment_method) == "CASH" && $payment->name == "WAYBILL_SERVICE") {
      $this->completeServiceVoucher($voucher_id, $user_id);
    } else if (strtoupper($payment_method) == "CASH" && $ref_code === "RECEIPT_VOUCHER" || $ref_code === 'PAYABLE_VOUCHER') {
      $this->completeReceiptVoucher($voucher_id, $user_id);
    } else if (strtoupper($payment_method) == "CASH") {
      $this->completeVoucher($voucher_id, 0);
    }

    return $voucher_id;
  }

  // ---------------------------------------------------------------------------- //
  // -------------------- create new voucher ------------------------------------ //
  // ---------------------------------------------------------------------------- //
  public function createARclaimVoucher($bean)
  {

    if (!$bean->from_account) {
      throw new Exception("Invalid account ID in from_account, from_account");
    }
    if (!$bean->target_account) {
      throw new Exception("Invalid account ID in target_account, target_account");
    }

    // get accounts bean
    $accountCore = new AccountCore();
    $fromAccountBean = $accountCore->getAccountBasic($bean->from_account, 0);
    $targetAccountBean = $accountCore->getAccountBasic($bean->target_account, 0);
    // TODO: validate voucher
    if (!$bean->payment_method) {
      throw new Exception("لا تستطيع المتابعة ، لم يتم تحديد اّلية الدفع");
    }
    if ($bean->amount < 0) {
      throw new Exception("لا تستطيع المتابعة قيمة أمر الصرف أقل من 0");
    }

    if ($bean->tender_id) {
      $tenderCore = new TenderCore();
      $man = $tenderCore->getTenderManifest($bean->tender_id, 0);
      if ($bean->template) {
        $voucher_template = $bean->template;
      } else {
        $voucher_template = $man['voucher_template'];
      }
    }

    $voucher_type = "WAYBILL_COMPLETE";
    $new_ref_code = "AR_CLAIM";
    // prepare trx_template
    $trx_template = new stdClass();
    $trx_template->from_account = $bean->from_account;
    $trx_template->from_account_name = $fromAccountBean->name;
    $trx_template->target_account = $bean->target_account; //TODO:: to do
    $trx_template->target_account_name = $targetAccountBean->name;
    $trx_template->pa_id = $bean->pa_id;
    $trx_template->amount = $bean->amount;
    $trx_template->ref_code = $new_ref_code;
    $trx_template->ref_id = $bean->tender_claim_id;
    $trx_template->tender_id = $bean->tender_id;
    $trx_template->voucher_type = $voucher_type;
    $trx_template->tender_pa = $bean->tender_pa;

    if (strtoupper($bean->payment_method) == "CHECK") {
      $trx_template->check_number = $bean->check_number;
    }

    // prepare voucher bean
    $voucherBean = new stdClass();
    $voucherBean->trx_template = $trx_template;
    $voucherBean->payment_method = $bean->payment_method;
    $voucherBean->notes = $bean->remarks;
    $voucherBean->system_code = $voucher_template;

    if ($bean->due_date) {
      $voucherBean->due_date = $bean->due_date;
    } else {
      $voucherBean->due_date = DBConnection::getSystemDate();
    }
    $voucherBean->status = 'NEW';
    // create Database record
    $createVoucherResult = DBConnection::insertDB("voucher", $voucherBean, 0);
    $voucher_id = $createVoucherResult[0]['@id'];
    return $voucher_id;
  }


  // -------------------------------------------------------------------- //
  // --------------------- Update voucher info in DB------------------------ //
  // -------------------------------------------------------------------- //
  function logTenderClaimItemWithVoucher($voucher_id, $ar_waybills, $updated_by)
  {
    foreach ($ar_waybills as &$waybill) {
      $waybill->voucher_id = $voucher_id;
      DBConnection::updateDB("tender_claim_item", $waybill, $updated_by);
    }
  }

  // -------------------------------------------------------------------- //
  // --------------------- Update voucher info in DB------------------------ //
  // -------------------------------------------------------------------- //
  function updateVoucherInfo($voucherBean, $voucher_id, $updated_by)
  {

    // get basic object bean without any activites
    $DB_Bean = DBConnection::getBasicObjectBean("voucher", $voucher_id, $updated_by);

    // map all the new values into the DB_bean
    $voucherBean = mapBeanToDBBean($voucherBean, $DB_Bean);

    // fill update struct and set the target user id
    $voucherBean->id = $voucher_id;
    DBConnection::updateDB("voucher", $voucherBean, $updated_by);
  }



  // ------------------------------------------------------------------------------- //
  // ------------------- lock voucher to tender claim ------------------------------ //
  // ------------------------------------------------------------------------------- //
  public function lockVoucherWithTenderClaim($id, $tender_claim_id)
  {

    // get basic object bean without any activites
    $DB_Bean = DBConnection::getBasicObjectBean("voucher", $id, 0);
    $DB_Bean->trx_template->tender_claim = $tender_claim_id;
    $this->updateVoucherInfo($DB_Bean, $id, 0);
  }


  // ----------------------------------------------------------------------------------------------- //
  // ------------------- release voucher from tender claim ------------------------------ //
  // ----------------------------------------------------------------------------------------------- //
  public function releaseVoucherFromTenderClaim($id)
  {

    // get basic object bean without any activites
    $DB_Bean = DBConnection::getBasicObjectBean("voucher", $id, 0);
    $DB_Bean->trx_template->tender_claim = "";
    $this->updateVoucherInfo($DB_Bean, $id, 0);
  }


  //------------------------------------------------------------------------//
  //-------------------------------renderInvalidVoucher-------------------//
  //------------------------------------------------------------------------//
  public function renderInvaildVoucher()
  {
    $html = '<html>
            <meta name="viewport"  content="user-scalable=no, initial-scale=1, maximum-scale=1, minimum-scale=1, width=device-width, height=device-height, target-densitydpi=device-dpi" >

        <head>
        <link rel="stylesheet" media="screen" href="https://fontlibrary.org/face/droid-arabic-kufi" type="text/css" />

            <style>
                .MinagateFont {
                    font-family: DroidArabicKufiRegular;
                    font-weight: lighter;
                    font-style: normal;
                    color: #807d7d;
                    font-size: 11px;
                    margin-top: 22px;
        }   
                .labelStyle {
                    text-align: right;
                    padding-right: 25px;
            }
                .valueStyle {
                    text-align: right;
                    color: rgb(74, 163, 222);
        }
                .divStyle {
                    padding: 4px;
                    border-bottom: solid 0.5px #ccc;
        }
            </style>
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
        </head>
        <body>
            <div class="MinagateFont">
            <h2 style="text-align: center">لا يمكن عرض معلومات امر الصرف</h2>
            </div>
        </html>';

    return $html;
  }

  // ---------------------------------------------------------------------------------------- //
  // ------------------------- render VoucherDetailsForMobile---------------------------------- //
  // ---------------------------------------------------------------------------------------- //
  public function renderVoucherDetails($voucher)
  {
    $createDate =  new DateTime($voucher->create_date);
    $html = '<html>
                    <meta name="viewport"  content="user-scalable=no, initial-scale=1, maximum-scale=1, minimum-scale=1, width=device-width, height=device-height, target-densitydpi=device-dpi" >
                      <head>
                        <link rel="stylesheet" media="screen" href="https://fontlibrary.org/face/droid-arabic-kufi" type="text/css" />
                        <style>
                          .MinagateFont {
                            font-family: DroidArabicKufiRegular;
                            font-weight: lighter;
                            font-style: normal;
                            color: #807d7d;
                            font-size: 11px;
                            margin-top: 22px;}
                          .labelStyle {
                            text-align: right;
                            padding-right: 25px;}
                          .valueStyle {
                            text-align: right;
                            color: rgb(74, 163, 222);}
                          .divStyle {
                            padding: 4px;
                            border-bottom: solid 0.5px #ccc;}
                        </style>
                        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css">
                      </head>
                  <body>
                  <div class="MinagateFont">
                    <form>
                      <div class="form-group divStyle  col-sm-12 col-xs-12 col-md-12">
                        <label class="col-sm-8  col-xs-8   col-md-8  col-form-label valueStyle">  ' . $voucher->id . '  </label>
                        <label class="col-sm-4   col-xs-4  col-md-4   col-form-label labelStyle">رقم امر الصرف</label>
                      </div>
                      <div class="form-group divStyle  col-sm-12 col-xs-12 col-md-12">
                        <label class="col-sm-8  col-xs-8   col-md-8  col-form-label valueStyle">' . $voucher->trx_template->amount . '</label>
                        <label class="col-sm-4   col-xs-4  col-md-4   col-form-label labelStyle">المبلغ</label>
                      </div>
                      <div class="form-group divStyle  col-sm-12 col-xs-12 col-md-12">
                        <label class="col-sm-8  col-xs-8   col-md-8  col-form-label valueStyle">  ' . $voucher->trx_template->from_account_name . ' (' . $voucher->trx_template->from_account . ')  </label>
                        <label class="col-sm-4   col-xs-4  col-md-4   col-form-label labelStyle">من حساب</label>
                      </div>
                      <div class="form-group divStyle  col-sm-12 col-xs-12 col-md-12">
                        <label class="col-sm-8  col-xs-8   col-md-8  col-form-label valueStyle">  ' . $voucher->trx_template->target_account_name . ' (' . $voucher->trx_template->target_account . ')  </label>
                        <label class="col-sm-4   col-xs-4  col-md-4   col-form-label labelStyle">الى حساب</label>
                      </div>
                      <div class="form-group divStyle  col-sm-12 col-xs-12 col-md-12">
                        <label class="col-sm-8  col-xs-8   col-md-8  col-form-label valueStyle">  ' . $createDate->format('Y-m-d H:i') . '  </label>
                        <label class="col-sm-4   col-xs-4  col-md-4   col-form-label labelStyle">تاريخ الانشاء</label>
                      </div>
                      <div class="form-group divStyle  col-sm-12 col-xs-12 col-md-12">
                        <label class="col-sm-8  col-xs-8   col-md-8  col-form-label valueStyle">  ' . $voucher->notes . '  </label>
                        <label class="col-sm-4   col-xs-4  col-md-4   col-form-label labelStyle">الملاحظات</label>
                      </div>
                    </form>
                  </div>
                </body>
              </html>';
    return $html;
  }



  //---------------------------------------------------------------------------------------------------------//
  //------------------------------- change the payment method for a certain voucher -------------------------//
  //---------------------------------------------------------------------------------------------------------//
  public function changePaymentMethod($voucher_id, $new_payment_method, $user_id)
  {

    // init objects
    $waybillCore = new WaybillCore();
    $tenderCore = new TenderCore();
    $accountCore = new AccountCore();

    // get voucher bean
    $voucherBean = $this->getVoucherBasic($voucher_id, $user_id);

    // get tender bean
    $ref_code = $voucherBean->trx_template->ref_code;
    if ($ref_code == "WAYBILL_COMPLETE") {
      $waybill_id = $voucherBean->trx_template->ref_id;
      $waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);

      $man = $tenderCore->getTenderManifest($waybillBean->tender_id, 0);
      $payment_accounts = $man['freight']['payment_accounts'];

      foreach ($payment_accounts as $acc) {
        if (strtoupper($acc['payment_method']) == strtoupper($new_payment_method)) {
          $from_account = $acc['account_id'] . "," . $acc['account_sub_id'];
          $from_account_name  = $accountCore->getAccountBasic($from_account, 0)->name;
          break;
        }
      }
    }

    // update bean
    $voucherBean->payment_method = $new_payment_method;
    $voucherBean->trx_template->from_account = $from_account;
    $voucherBean->trx_template->from_account_name = $from_account_name;
    $this->updateVoucherInfo($voucherBean, $voucher_id, 0);
  }



  //-------------------------------------------------------------------------//
  //--------------------------- Get trx for certain jv ----------------------//
  //-------------------------------------------------------------------------//
  public function getJvTrx($jv_id)
  {

    $query = "SELECT 
                  id,
                  account_id,
                  sub_id,
                  amount,
                  op
              FROM
                  jv_trx 
                  WHERE
                jv_id = ?";

    $param = [$jv_id];
    $trxResult = DBConnection::runBindDatabaseQuery($query, $param);

    return $trxResult;
  }





  // -------------------------------------------------------------------------------------- //
  // ----------- Prepare needed information in order to create voucher trx ---------------- //
  // ----------- Input: trx_template, freight , item --------- //
  // -------------------------------------------------------------------------------------- //
  public function generateVoucherTrx($trx_template, $sourceAccountBean, $paymentObj, $tagreeshFreight, $item)
  {

    $trx = [];

    // start filling the trx
    foreach ($trx_template as $trxkey  => $trx_row) {
      try {

        // calculate amount
        $amount = 0;
        foreach ($trx_row->amount as $amountTemplate) {

          // in case the amount is calculated from tagreesh
          if (trim($amountTemplate->source) == "tagreesh") {
            $freightKey = strtolower($amountTemplate->val);
            $amount += $tagreeshFreight->$freightKey * $amountTemplate->factor;
          }

          // in case the amount is calculated from source account
          else if (trim($amountTemplate->source) == "account") {
            if ($sourceAccountBean[strtolower($amountTemplate->val)] && $sourceAccountBean[strtolower($amountTemplate->val)] > 0) {
              $amount += $sourceAccountBean[strtolower($amountTemplate->val)] * $amountTemplate->factor;
            }
          }

          // in case the amount is calculated from pa project settings
          else if (trim($amountTemplate->source) == "pa_project") {
            if ($paymentObj->commissions) {
              $commissions = $paymentObj->commissions;
            }

            if ($commissions) {
              foreach ($commissions as $com) {
                if ($com->method == "fixed") {
                  $amount += $com->amount * $amountTemplate->factor;
                }
                if ($com->method == "percentage") {
                  if ($com->source == "tagreesh.net_amount") {
                    $amount += $com->amount * $tagreeshFreight->net_amount * $amountTemplate->factor;
                  }
                  if ($com->source == "tagreesh.base_amount") {
                    $amount += $com->amount * $tagreeshFreight->net_amount * $amountTemplate->factor;
                  }
                } else if (trim(strtolower($amountTemplate->source)) == "user_defined") {
                  $amount = $paymentObj->value;
                }
              }
            }
          } else if (trim(strtolower($amountTemplate->source)) == "user_defined") {
            $amount = $paymentObj->value;
          } else if (trim(strtolower($amountTemplate->source)) == "fixed") {
            $amount = $amountTemplate->val * $amountTemplate->factor;
          }
        }

        //generate trx_note
        $trx_note = $trx_row->trx_note->text;
        foreach ($trx_row->trx_note->params as $noteParam) {
          $key = explode(".", $noteParam)[1];
          $trx_note = str_replace_first("؟", $item[$key], $trx_note);
        }

        // if ($amount > 0) {
        // generate the account id
        if ($trx_row->value[0] == "TARGET_ACCOUNT_ID") {
          $account_id = $paymentObj->target_account_id;
        } else if ($trx_row->value[0] == "SOURCE_ACCOUNT_ID") {          
          $account_id = $paymentObj->source_account_id;
        } else {

          // if the value size is 1 then choose this account, else take it from user
          if (sizeof($trx_row->value) == 1) {
            $account_id = $trx_row->value[0];
          } else {
            $account_id = $sourceAccountBean['id'] . "-" . $sourceAccountBean['sub_id'];
          }
        }

        $amount = number_format($amount, 3);
        $trx[] = array(
          "account_id" => $account_id,
          "account" => $account_id,
          "amount" => $amount,
          "op" => $trx_row->op,
          "notes" => $trx_note,
          "trx_note" => ["text" => $trx_note],
          "source_account" => $trx_row->source_account ? $trx_row->source_account : null,
          "target_account" => $trx_row->target_account ? $trx_row->target_account : null
        );
        // }
      } catch (Exception $e) {
        throw new Exception($e->getMessage());
      }
    }

    return $trx;
  }
}
