<?php

// import required classes
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/vessel_visit_core.php");
require_once(dirname(__FILE__) . "/../cargo/cargo_core.php");
require_once(dirname(__FILE__) . "/../waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");

class VesselVisit_interface extends API
{

    // the request of each call
    private $_request = array();
    private $_vesselCore;
    private $_cargoCore;
    private $_waybillCore;


    public function __construct()
    {
        DBConnection::getInstance();

        // call the super constructur
        $this->_request = parent::__construct();

        // validate the session
        session_start();

        if (!isset($_SESSION['user_id'])) {
            throw new Exception("NO_SESSION", 1);
        }

        // init the DriverCore object
        $this->_vesselCore = new VesselVisitCore();
        $this->_cargoCore  = new CargoCore();
        $this->_waybillCore = new WaybillCore();
        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // -------------------------------------------------------------- //
    // --------------------- get info for a certian vessel ----------- //
    // -------------------------------------------------------------- //
    public function getVesselVisit()
    {

        $vesselBean = $this->_vesselCore->getVesselVisit($this->_request->id, $_SESSION['user_id']);

        isset($vesselBean) or die('no data found');

        //return Success reponse
        parent::response($vesselBean);
    }

    // ---------------------------------------------------------------------- //
    // -------------------search for vessel using any search filter ---------- //
    // ---------------------------------------------------------------------- //
    public function searchVesselVisits()
    {

        // call the core search
        $filter = $this->prepareFilter();

        $vessel_qry = $this->_vesselCore->searchVesselVisit(
            $filter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        parent::response($vessel_qry);
    }

    // ---------------------------------------------------------------------- //
    // --------------------- create new  vessel ----------------------------- //
    // ---------------------------------------------------------------------- //
    public function createVesselVisit()
    {

        $vesselBean = [
            'vessel_name' => $this->_request->vessel_name,
            'shipping_line' => $this->_request->shipping_line,
            'port_dock' => $this->_request->port_dock,
            'ETA' => $this->_request->eta,
            'ETD' => $this->_request->etd,
            'status' => 'ACTIVE',
        ];
        $vesselBean = json_decode(json_encode($vesselBean));
        // echo gettype($vesselBean);die;
        // insert into db vessel table
        $inserted_vessel_id = $this->_vesselCore->createVesselVisit($vesselBean,  $_SESSION['user_id']);

        parent::response("تمت العملية بنجاح");
    }

    // ---------------------------------------------------------------------- //
    // --------------------- create new  vessel ----------------------------- //
    // ---------------------------------------------------------------------- //
    public function updateVesselVisit()
    {
        $vessel_name = $this->_request->vessel_name;
        $shipping_line = $this->_request->shipping_line;
        $port_dock = $this->_request->port_dock;
        $ETA = $this->_request->eta;
        $ETD = $this->_request->etd;
        $status = 'ACTIVE';

        $vesselBean = $this->_vesselCore->getVesselVisit($this->_request->id, $_SESSION['user_id']);

        if (isset($vessel_name)) {
            $vesselBean->vessel_name = $vessel_name;
        }
        if (isset($shipping_line)) {
            $vesselBean->shipping_line = $shipping_line;
        }
        if (isset($port_dock)) {
            $vesselBean->port_dock = $port_dock;
        }
        if (isset($ETA)) {
            $vesselBean->ETA = $ETA;
        }
        if (isset($ETD)) {
            $vesselBean->ETD = $ETD;
        }


        $vessel_id = $this->_vesselCore->updateVesselVisit($vesselBean,  $_SESSION['user_id']);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "تمت العملية بنجاح";
        $Result['ID'] = $vessel_id;
        parent::response($Result, 200);
    }

    public function vesselProgressBar()
    {
        $vessel_visit_id = $this->_request->vessel_visit_id;

        $cargos = $this->_cargoCore->searchVessle([
            ['key' => 'vessel_visit_id', 'val' => $vessel_visit_id],
            ['key' => 'status', 'val' => ["INACTIVE"], 'op' => 'not in']
        ], 100, 0, $_SESSION['user_id']);

        $cargos_ids = array_map(function ($a) {
            return $a->id;
        }, $cargos->data);
        $weight = array_sum(array_map(function ($a) {
            return json_decode($a->waybill_template)->cargo[0]->weight;
        }, $cargos->data));


        $search_filter = [
            ['key' => 'cargo_id', 'val' => $cargos_ids, 'op' => 'in'],
            ['key' => 'status', 'val' => ["REVOKED"], 'op' => 'not in']
        ];
        $waybills = DBConnection::searchReport('waybill', '01', $search_filter, 800, 0, $_SESSION['user_id']);


        $response = new stdClass();
        $response->total = $weight;
        $response->loaded = 0;
        if ($waybills->found_rows <= 0) {
            parent::response($response);
            die;
        }

        $response->loaded = array_sum(array_map(function ($e) {
            return (isset($e->loading_weight) && $e->loading_weight > 0) ? $e->loading_weight : 0;
        }, $waybills->data));


        parent::response($response);
    }
    private function prepareFilter()
    {

        $vesselFilter = [];
        if ($this->_request->filter) {
            if (gettype($this->_request->filter)  == "string") {
                $filter = json_decode($this->_request->filter, true);
            } else {
                $filter = $this->_request->filter;
            }
            foreach ($filter as $key => $value) {

                if ($key == 'vessel_name') {
                    $tempArr = ['key' => $key, 'val' => $value, 'op' => 'like'];
                } else {
                    $tempArr = ['key' => $key, 'val' => $value];
                }

                array_push($vesselFilter, $tempArr);
            }
        }
        return $vesselFilter;
    }
}


$vessel_interface = new VesselVisit_interface();
