<?php
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../tender/tender_core.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . '/../outgoing_integration/poll.php');

class VesselVisitCore
{

    public function __construct()
    {
        DBConnection::getInstance();

    }


    // -------------------------------------------------------------- //
    // --------------------- get info for a certian vessel ----------- //
    // -------------------------------------------------------------- //
    public function getVesselVisit($id, $user_id)
    {

        $vesselInfo = DBConnection::getBasicObjectBean("vessel_visit", $id, $user_id);
        return $vesselInfo;
    }


    public function searchVesselVisit($searchFilter, $limit, $offset, $user_id)
    {

        $searchVesselResult = DBConnection::searchDB("vessel_visit", $searchFilter, $limit, $offset, $user_id, ' order by id desc ');
        return $searchVesselResult;
    }


    // ------------------------------------------------------------------------ //
    // ------------------- create new vessel  ----------- //
    // ------------------------------------------------------------------------ //
    public function createVesselVisit($vesselBean, $user_id)
    {

        $vesselRes =  DBConnection::insertDB("vessel_visit", $vesselBean, $user_id);
        $vessel_ID =  $vesselRes[0]['@id'];

        return $vessel_ID;
    }


    // ------------------------------------------------------------------------ //
    // ------------------- update current vessel  ----------- //
    // ------------------------------------------------------------------------ //
    public function updateVesselVisit($vesselBean, $updated_by)
    {
        $createVesselResult =  DBConnection::updateDB("vessel_visit", $vesselBean, $updated_by);
        return $createVesselResult;
    }


    // ------------------------------------------------------------------------ //
    // -------------------change status of Vessel ------------------------------ //
    // ------------------------------------------------------------------------ //
    public function changeVesselVisitStatus($vessel_id, $new_status, $user_id)
    {

        $updateBean = new stdClass();
        $updateBean->id = $vessel_id;
        $updateBean->status = $new_status;

        DBConnection::updateDB("vessel_visit", $updateBean, $user_id);
    }

}
