<?php

// import required classes 
require_once (dirname(__FILE__)."/../login/login_core.php");
require_once (dirname(__FILE__)."/../truck_contract/truck_contract_core.php");
require_once (dirname(__FILE__)."/../driver/driver_core.php");
require_once (dirname(__FILE__)."/../truck_owner/truck_owner_core.php");
require_once (dirname(__FILE__)."/../API.php");
require_once (dirname(__FILE__)."/../../includes/Captions.php");
require_once (dirname(__FILE__)."/../../includes/util.php");
require_once (dirname(__FILE__)."/../company/company_core.php");
require_once (dirname(__FILE__)."/../account/account_core.php");
require_once (dirname(__FILE__)."/../company_employee/company_employee_core.php");
require_once (dirname(__FILE__)."/../outgoing_integration/customer_care.php");
require_once (dirname(__FILE__)."/../company/trucking_company/trucking_company_core.php");
require_once (dirname(__FILE__)."/../tender/tender_core.php");
require_once (dirname(__FILE__)."/../outgoing_integration/zain_cash.php");
require_once (dirname(__FILE__)."/../taskQueues/taskQueues_core.php");
require_once (dirname(__FILE__)."/../outgoing_integration/zain_cash.php");
require_once (dirname(__FILE__)."/../outgoing_integration/poll.php");
require_once (dirname(__FILE__)."/../payment_agent/payment_agent_core.php");
require_once (dirname(__FILE__)."/../company/clearing_agent/clearing_agent_core.php");


 class User_interface extends API{

    // the request of each call
    private $_request = array();
    private $_userCore;
    private $_loginCore;
    private $_driverCore;
    private $_truckContractCore;
    private $_truckOwnerCore;
    private $_companyCore;
    private $_accountCore;
    private $_company_employee;
    private $_truckingCompanyCore;
    private $_tenderCore;
    private $_paymentAgentCore;
    private $_taskQueuesCore;
    private $_customerCare;
    private $_poll;
    private $_clearingAgentCore;

    public function __construct(){ 

        // call the super constructur
        $this->_request = parent::__construct();
         
        // validate session
        session_start();
        // if( !isset($_SESSION['user_id'])){
        //     throw new Exception("NO_SESSION",1);
        // }

        // init the UserCore object
        $this->_userCore = new UserCore();
        $this->_loginCore = new LoginCore();
        $this->_driverCore = new DriverCore();
        $this->_truckOwnerCore = new TruckOwnerCore();
        $this->_truckContractCore = new TruckContractCore();
        $this->_companyCore = new CompanyCore();
        $this->_accountCore = new AccountCore();
        $this->_company_employee = new CompanyEmployeeCore();
        $this->_truckingCompanyCore = new TruckingCompanyCore();
        $this->_tenderCore = new TenderCore();
        $this->_zain_cash = new Zain_cash();
        $this->_taskQueuesCore = new TaskQueuesCore();
        $this->_customerCare = new CustomerCare();
        $this->_poll = new Poll();
        $this->_paymentAgentCore = new PaymentAgentCore();
        $this->_clearingAgentCore = new ClearingAgentCore();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();

    }
 
    // -------------------------------------------------------------- //
    // --------------------- get User info as JSON ------------------ //
    // -------------------------------------------------------------- //
    public function getUser(){
        
        $userInfo = $this->_userCore->getUser($this->_request->id,
                                              $_SESSION['user_id']);

        //return Success reponse
        parent::response(json_decode($userInfo));
         
    }

   // -------------------------------------------------------------- //
    // --------------------- get User role info as JSON ------------------ //
    // -------------------------------------------------------------- //
    public function getUserRole(){

        $userInfo = $this->_userCore->getUserRole($this->_request->id,
                                                 $_SESSION['user_id']);

        //return Success reponse
        parent::response(json_decode($userInfo));
         
    }
    

    // ------------------------------------------------------------------------ //
    // -------------------search for users using any search filter ---------- //
    // ------------------------------------------------------------------------ //
    public function searchUser(){
        
        // call the core search
        $searchFilter = $this->prepareFilter();

        $users_qry = $this->_userCore->searchUser(  $searchFilter,
                                                    $this->_request->limit,
                                                    $this->_request->offset,
                                                    $_SESSION['user_id']
                                                );
        parent::response($users_qry);
    }

      // prepare any json filter 
      private function prepareFilter(){
        $searchFilter = [];
        if($this->_request->filter){
            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {
                if($key == 'name' || $key == 'role'){
                    $tempArr = ['key'=>$key,'val' => $value , 'op' => "LIKE"];
                }
                else if($key == 'phone'){
                    $tempArr = ['key'=>$key,'val' => convertToInternational($value)];
                }
                else{
                    $tempArr = ['key'=>$key,'val' => $value ];
                }
                array_push($searchFilter,$tempArr);
            }
        }
        return $searchFilter;
    }



    // ---------------------------------------------------------------------------- //
    // -------------------search for users roles using any search filter ---------- //
    // ---------------------------------------------------------------------------- //
    public function searchUserRoles(){

        // call the core search
        $searchFilter = $this->prepareFilter();
        $users_qry = $this->_userCore->searchUserRoles($searchFilter,$this->_request->limit, $this->_request->offset, $_SESSION['user_id'] );

        $result = [];
        foreach ($users_qry->data as $user) {

            if ($result[$user->user_id]) {
                $userElement= $result[$user->user_id];
                $role_code= $userElement->role_code.','.$user->role_code;
                $result[$user->user_id]->role_code= $role_code;

            }else{
                $result[$user->user_id]=$user;
            }
        }

        $result = array_values($result); // 'reindex' array

        $result['data']= $result;
        $result['found_rows']= $users_qry->found_rows;

        parent::response($result);
        
    }




    // ---------------------------------------------- //
    // -------------------create new user  ---------- //
    // ---------------------------------------------- //
    public function createUser(){
 
        $userBean = $this->cleanUserBean($this->_request);

        // call the core search
        $id = $this->_userCore->registerNewUser( $userBean, $_SESSION['user_id'] );
        $Result['ERRORCODE'] = "0";
        $Result['MOBILENUMBER'] = $userBean->phone;
        $Result['MESSAGE'] = "USER.SUCCESS_CREATE";
        $Result['ID'] = $id;
        parent::response($Result,200); 

    }

    // ---------------------------------------------------------------- //
    // --------------------- update user info ------------------------- //
    // ---------------------------------------------------------------- //
    public function updateUserInfo(){
        
        $userBean = $this->cleanUserBean($this->_request);

        //remove phone_array
        unset($userBean->phone_array);

        // convert user input from JSON to Object
        $this->_userCore->updateUserInfo($userBean, $this->_request->user_id, $_SESSION['user_id']);

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "USER.SUCCESSFUL_UPDATE";
        parent::response($Result); 
    }

    // ---------------------------------------------------------------- //
    // --------------------- update user phone ------------------------- //
    // ---------------------------------------------------------------- //
    public function updateUserPhone(){

        // validate mobiler number
        if(!$this->_request->user_phone){
            throw new Exception("USER.INVALID_MOBILE_NUMBER");
        }

        // validate if the number has active wallet on the phone
        $zain_cash = new Zain_cash();
        $originalUserBean = $this->_userCore->getUserBasic($this->_request->user_id,$_SESSION['user_id']);
        $result = $zain_cash->getUserWallet($originalUserBean->phone);
        if($result && $result['RESULT'] == 'ACTIVE'){
            throw new Exception("لا تستطيع المتابعة ، رقم الهاتف معرف كمحفظة الكترونية");
        }

        // validate if the mobile number is used in any payment method in account
        $userAccountFilter = [['key'=>"user_id",'val' => $this->_request->user_id],['key'=>"status",'val' => 'ACTIVE']];
        $account_qry = $this->_accountCore->searchAccount($userAccountFilter, 1, 0, 0);

        if($account_qry->found_rows > 0){

            $account_id = $account_qry->data[0]->id;

            //search in financial details in tender_truck
            $tender_truck_filter = [['key'=>'financial_details','val' => $account_id, 'op'=>'json unquote', 'node'=>'$.waybill_beneficiary_account'],
                                    ['key'=>'financial_details','val' => '"zain_cash"', 'op'=>'json unquote', 'node'=>'$.payment_channel'],
                                    ['key'=>'status','val' => 'ACTIVE']];
                                                                      
            $tenderTruckResult = $this->_tenderCore->searchTenderTruck($tender_truck_filter,1,0,0);

            if($tenderTruckResult->found_rows > 0){
                throw new Exception("لا تستطيع تغير رقم الهاتف ، حيث أنه معرف كمستفيد أول للشاحنة رقم " . $tenderTruckResult->data[0]->tn . " على مشروع " . $tenderTruckResult->data[0]->tender_name);
            }         
        }

        // get the user bean
        $userBean = $this->_userCore->getUserBasic($this->_request->user_id,$_SESSION['user_id']);

        // prepare the phone info array
        $phone_array = $userBean->phone_array[0];
        $phone_info = new stdClass();
        $phone_info->sim = $phone_array->sim;
        $phone_info->phone = convertToInternational($this->_request->user_phone);
        $phone_info->imei = $phone_array->imei;
        $phone_info->verification_method = "MANUAL";

        $new_phone_array = [];
        $new_phone_array[0]=$phone_info;
        $userBean->phone_array = json_decode(json_encode($new_phone_array)) ;

        // convert user input from JSON to Object
        $this->_userCore->updateUserInfo($userBean, $this->_request->user_id, $_SESSION['user_id']);

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "USER.SUCCESSFUL_UPDATE";
        parent::response($Result);
    }


    // ---------------------------------------------------------------- //
    // --------------------- update user Name ------------------------- //
    // ---------------------------------------------------------------- //
    public function updateUserName(){

        // validate mobiler number
        if(!$this->_request->name){
            throw new Exception("USER.INVALID_NAME");
        }

        // get the user bean
        $userBean = $this->_userCore->getUserBasic($this->_request->user_id,$_SESSION['user_id']);

        // update name
        $userBean->name = $this->_request->name;

        // update in database
        $this->_userCore->updateUserInfo($userBean, $this->_request->user_id, $_SESSION['user_id']);

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "USER.SUCCESSFUL_UPDATE";
        parent::response($Result);
    }


    // ---------------------------------------------------------------- //
    // --------------------- update user roles ------------------------- //
    // ---------------------------------------------------------------- //
    public function updateUserRoles(){

         // search for the company record localy using (company id) in case the user is for company
         if($this->_request->company_id) {
            $searchFilter = [['key'=>'id','val' => $this->_request->company_id]];
            $companyInfo = $this->_companyCore->searchCompany($searchFilter,1,0,$_SESSION['user_id']);

            if($companyInfo->found_rows == 0) {
                throw new Exception("TRUCK.INVALID_COMPANY");
            }
         }
  
        $this->_userCore->updateUserRoles($this->_request ,$_SESSION['user_id'],$_SESSION['USER_ROLES']);

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "USER.SUCCESSFUL_UPDATE";
        parent::response($Result); 
    }


    // ------------------------------------------------------------------------------ //
    // --------------Clear the request and form it to be a valid user bean ---------- //
    // ------------------------------------------------------------------------------ //
    private function cleanUserBean ($request) {
        
        $userBean = $request;

        // loop on userBean and remove any empty string
        foreach ($userBean as $key => $value) {
            if($value == ""){
                unset($userBean->{$key});
            }
        }

        // remove the +962 if exist
        if($request->phone_array && substr( $request->phone, 0, 3 ) === "962" || substr( $request->phone, 0, 4 ) === "+962"){
            $request->phone = str_replace("+962","0",$request->phone);
            $request->phone = str_replace("962","0",$request->phone);
            $request->sim_id =  $request->sim_id ? $request->sim_id : 0;
            $request->imei = $request->imei ?  $request->imei : 0;
            $request->verification_method = 'MANUAL';
        }

        if(substr( $request->mobile, 0, 3 ) === "078" || substr( $request->mobile, 0, 3 ) === "079" || substr( $request->mobile, 0, 3 ) === "077"){
            $request->phone = convertToInternational($request->mobile);
            $request->sim_id =  $request->sim_id ? $request->sim_id : 0;
            $request->imei = $request->imei ?  $request->imei : 0;
            $request->verification_method = 'MANUAL';
        }else{
            $request->phone = $request->mobile;
            $request->sim_id =  $request->sim_id ? $request->sim_id : 0;
            $request->imei = $request->imei ?  $request->imei : 0;
            $request->verification_method = 'MANUAL';
        }


        // prepare the phone info array
        $phone_array = [];
        $phone_info = new stdClass();
        $phone_info->sim = $request->sim_id;
        $phone_info->phone = $request->phone;
        $phone_info->imei = $request->imei;
        $phone_info->verification_method = $request->verification_method;
        $phone_array[0]=$phone_info;
        $userBean->phone_array = json_decode(json_encode($phone_array)) ;

        $photos_array = []; 
        if($request->id_photo ){
            // prepare the photos info array
            $photos_info = new stdClass();
            $photos_info->type = 'id_photo';
            $photos_info->url = $request->id_photo;
            array_push($photos_array,$photos_info);
        }

        if($request->personal_photo){
            $photos_info = new stdClass();
            $photos_info->type = 'personal_photo';
            $photos_info->url = $request->personal_photo;
            array_push($photos_array,$photos_info);
        }

        $userBean->photos = json_decode(json_encode($photos_array)) ;

        // remove unneccery items from bean
        unset($userBean->sim_id);
        unset($userBean->mobile);
        unset($userBean->verification_method);
        unset($userBean->imei);
        unset($userBean->personal_photo);
        unset($userBean->id_photo);
 

        return $userBean;
    }


    // ----------------------------------------------------------------------------------------------- //
    // ------------------ Update user financial details ---------------------------------------------- //
    // ----------------------------------------------------------------------------------------------- //
    public function updateFinancialDetails(){

        // get user input
        $wallet_vendor = $this->_request->wallet_vendor;
        $bank_account = $this->_request->bank_account;
        $bank_name = $this->_request->bank_name;
        $bank_branch = $this->_request->bank_branch;
        $iban = $this->_request->iban;
        $financial_details = new stdClass();
        $financial_details->wallet_vendor = $wallet_vendor;
        $financial_details->bank_account = $bank_account;
        $financial_details->bank_name = $bank_name;
        $financial_details->bank_branch = $bank_branch;
        $financial_details->iban = $iban;

        // get userBean 
        $userBean = $this->_userCore->getUserBasic($_SESSION['u_id'],$_SESSION['user_id']);
        $userBean->financial_details = $financial_details;
        // update
        $this->_userCore->updateUserInfo($userBean, $_SESSION['u_id'], $_SESSION['user_id']);

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "USER.SUCCESSFUL_OPERATION";
        parent::response($Result);

    }



    // ----------------------------------------------------------------------------------------------- //
    // ------------- get the user profile info , roles, beans and wf --------------------------------- //
    // ------------- idtoken = google oauth token , refresh_token = google notification token -------- //
    // ------------- integration_token = token generated for integration purposes only) -------------- //
    // ----------------------------------------------------------------------------------------------- //
    public function getUserProfile(){
   
        // get the request tokens
        $idToken = $this->_request->idtoken;
        $refresh_token = $this->_request->refresh_token;
        $integration_token = $this->_request->integration_token;
        //if user has session, then get user info from session->user_id
        if($_SESSION && $_SESSION['user_id']){

            if($_SESSION['type'] == "INDIVIDUAL" || $_SESSION['type'] == "SYSTEM"){
                $userProfile = $this->_userCore->getUserProfile($_SESSION['user_id'], $_SESSION['u_id']);

            }else if($_SESSION['type'] == "CORPORATE"){
                $company_employee_id = $_SESSION['company_employee_id'];
                $userProfile = $this->_company_employee->getCompanyEmployeeProfile($company_employee_id, $_SESSION['user_id']);
                parent::validateCorporateSession();
            }else{
                $this->_loginCore->logoutUser($_SESSION);
                $_SESSION = array();
                session_destroy();
                throw new Exception("INVALID SESSION TYPE");                
            }

        }else{
            throw new Exception("INVALID_SESSION");
        }

        // get user company employee company profiles
        $u_id = $_SESSION['u_id'];
        $searchFilter = [['key'=>'user_id','val' =>$u_id],
                         ['key'=>'status','val' =>'ACTIVE']];
        $employeeInfo = $this->_company_employee->searchCompanyEmployee($searchFilter,100,0,0);

        // append individual profile
        $userProfile['company_profiles'] = [];
        $individualProfile = [];
        $userBean = json_decode($userProfile['USER_BEAN']);

        $individualProfile["user_id"] = $userBean->id;
        $individualProfile["name"] = $userBean->name;
        $individualProfile["avatar"] = null;
        try{
            foreach ($userBean->photos as $p) {
                if($p->type == "personal_photo"){
                    $individualProfile["avatar"] = $p->url;
                }
            }
        }catch(Exception $e){}


        $userProfile['company_profiles'][] = $individualProfile;

        if($employeeInfo->found_rows > 0){
            foreach ($employeeInfo->data as $employeeInfo) {
                
                // get company logo in case it is tc
                $tc_searchFilter = [['key'=>'company_id','val' => $employeeInfo->company_id],
                                    ['key'=>'status','val' =>'ACTIVE']
                                    ];
                $tc_qry = $this->_truckingCompanyCore->searchTruckingCompany($tc_searchFilter, 1, 0, 0);
                $companyLogo = null;
                foreach ($tc_qry->data as $company) {
                    $photos = $company->photos;
                    $photos = json_decode($photos);
                    if($photos && sizeof($photos)>0) {
                        foreach ($photos as $p) {
                            if($p->type == "logo"){
                                $companyLogo = $p->url;
                            }
                        }
                    }
                }

                // get company logo in case it is ca
                $ca_searchFilter = [['key'=>'company_id','val' => $employeeInfo->company_id],
                                    ['key'=>'status','val' =>'ACTIVE']
                                    ];
                $ca_qry = $this->_clearingAgentCore->searchClearingAgent($ca_searchFilter, 1, 0, 0);
                $companyLogo = null;
                foreach ($ca_qry->data as $company) {
                    $photos = $company->photos;
                    $photos = json_decode($photos);
                    if($photos && sizeof($photos)>0) {
                        foreach ($photos as $p) {
                            if($p->type == "logo"){
                                $companyLogo = $p->url;
                            }
                        }
                    }
                }


                // get company logo in case it is pa
                $pa_searchFilter = [['key'=>'company_id','val' => $employeeInfo->company_id],
                                    ['key'=>'status','val' =>'ACTIVE']
                                    ];
                $paymentAgents_qry = $this->_paymentAgentCore->searchPaymentAgents($pa_searchFilter,1,0,0);
                foreach ($paymentAgents_qry->data as $company) {
                    $photos = $company->photo;
                    $photos = json_decode($photos);
                    if($photos && sizeof($photos)>0) {
                        foreach ($photos as $p) {
                            if($p->type == "logo"){
                                $companyLogo = $p->url;
                            }
                        }
                    }
                }


                // TODO: Fix this
                if($employeeInfo->company_id == 36465){   // Amin Qiwar
                    $companyLogo = "https://storage.googleapis.com/waybill-system.appspot.com/amin_qiwar.jpg";
                    $employeeInfo->company_name = "شركة أمين قعوار";
                }

                $comanyProfile = [];
                $comanyProfile["company_id"] = $employeeInfo->company_id;
                $comanyProfile["tc_id"] = $employeeInfo->tc_id;
                $comanyProfile["name"] = $employeeInfo->company_name;
                $comanyProfile["avatar"] = $companyLogo;
                $userProfile['company_profiles'][] = $comanyProfile;
            }
        }


        // set the selected profile
        foreach ($userProfile['company_profiles'] as &$profile) {
            if($profile['user_id'] && $_SESSION['type'] == "INDIVIDUAL"){
                $profile['is_selected'] = true;
                break;
            }
            if($profile['company_id'] == $_SESSION['company_id'] && $_SESSION['type'] == "CORPORATE"){
                $profile['is_selected'] = true;
                break;
            }
        }

        // // check the user role if it's yard or not
        // $USER_ROLES = $userProfile['USER_ROLES'];
        // if (strpos($USER_ROLES,"YARD_MANAGER")) {
        //     $userProfile['is_yard_user'] = true;
        // }
        // $userProfile['is_yard_user'] = true;
        // $userProfile['is_yard_user_token'] = $idToken;

        parent::response($userProfile);
    }


    // ----------------------------------------------------------------------------------------//
    // ------------- search the user profile info for registration screen--------------------- //
    // --------------------------------------------------------------------------------------- //
    public function searchUserProfile(){
        $searchValue = $this->_request->search_value;
        $searchType = '';


        // remove the +962 if exist
        if(substr( $searchValue, 0, 3 ) === "962") {
            $searchValue = str_replace_first("962","0",$searchValue);
            $searchType = 'mobile';
        }
        else if(substr( $searchValue, 0, 4 ) === "+962"){
            $searchValue = str_replace_first("+962","0",$searchValue);
            $searchType = 'mobile';
        }
        else if(substr( $searchValue, 0, 3 ) === "078" || substr( $searchValue, 0, 3 ) === "079" || substr( $searchValue, 0, 3 ) === "077"){
            $searchType = 'mobile';
        }

        // determine the type of the search value (nn, mobile or truck)
        if($searchType == 'mobile') {
            $searchValue = convertToInternational($searchValue);
            // search for the user record localy using (phone)
            $searchFilter = [['key'=>'phone','val' => $searchValue ]];          
            $searchUserResult = DBConnection::searchDB("user",$searchFilter,1,0,0);// 1= one record is enough , 0= start from the bigining , 0= System User
        }
        else  {
            $searchType = 'nn';
             // search for the user record localy using (national number)
             $searchFilter = [['key'=>'nn','val' => $searchValue ,'op' => '='] ];
             $searchUserResult = DBConnection::searchDB("user",$searchFilter,1,0,0);

        }

        $userQry = $searchUserResult->data[0];
        $userID = $userQry->id;

        if(!$userID) {
            throw new Exception("USER.INVALID_PHONE",500);
        }
         // // get the user beans (user, driver, owner)
        $userBean = $this->_userCore->getUserBasic($userID,$_SESSION['user_id']);

        // determine the missing info and store it in warning JSON object
        $userWarning = $this->_userCore->getUserWarnings($userBean->id, $_SESSION['user_id']);
        if($userWarning){
            $userBean->warnings = $userWarning;
        }
        $Result['USERBEAN'] = $userBean;
        $Result['USERBEAN']   = json_encode($Result['USERBEAN'],JSON_UNESCAPED_UNICODE);

        // if the user is a driver, get the driver info
        if ($userQry->driver_id != null){
            $driverObj = $this->_driverCore->getDriverBasic($userQry->driver_id,$_SESSION['user_id']);

            // get the driver warnings
            $driverWarning = $this->_driverCore->getDriverWarnings($userQry->driver_id,$_SESSION['user_id']);
            $driverObj->warnings = $driverWarning;
            $Result['DRIVERBEAN'] = $driverObj;
            $Result['DRIVERBEAN'] = json_encode($Result['DRIVERBEAN'],JSON_UNESCAPED_UNICODE);
        }


        // if the user is a truck owner, get the truck owner info
        if ($userQry->truck_owner_id != null){
            $truckOwnerObj = $this->_truckOwnerCore->getTruckOwnerBasic($userQry->truck_owner_id,$_SESSION['user_id']);
            $Result['TRUCKOWNER'] = $truckOwnerObj;

            // get the trucks owned by this user
            $truckContractFilter = [['key'=>'truck_owner_id','val' => $truckOwnerObj->id ,'op' => '='],
                                   ['key'=>'contract_type','val' => ['OWN','AUTH'],'op' => 'in']
                                   ];

            $contracts_qry = $this->_truckContractCore->searchTruckContracts($truckContractFilter,
                                                                             1000,// limit
                                                                             0,  // offset
                                                                             $_SESSION['user_id']
                                                                            );
            
            $Result['TRUCKS'] = $contracts_qry->data;
        }

        // Search account info
        $accountFilter = [['key'=>"user_id",'val' => $userID],['key'=>"status",'val' => 'ACTIVE']];
        $account_qry = $this->_accountCore->searchAccount($accountFilter, 1, 0, $_SESSION['user_id']);

        if($account_qry->found_rows > 0){
            $accountBean = $account_qry->data[0];
            unset($accountBean->balance);
            unset($accountBean->minimum_balance);
            $Result['ACCOUNT_BEAN'] = $accountBean;
        }else{
            $Result['ACCOUNT_BEAN']=NULL;
        }


         // validate if the number has active wallet on the phone
         $zain_cash = new Zain_cash();
         $result = $zain_cash->getUserWallet($userBean->phone);
         if($result && $result['RESULT'] == 'ACTIVE'){
            $Result['ACTIVE_WALLET']=true;
         }else{
            $Result['ACTIVE_WALLET']=null;
         }

        parent::response($Result);

    }




    // -------------------------------------------------------------------------------- //
    // ---------------- store web socket uuid for the user in the session ------------- //
    // -------------------------------------------------------------------------------- //
    public function SaveWebsocketUUID()
    {
        $_SESSION['uuid'] = $this->_request->uuid;

        $Result=$this->_userCore->updateUserHBObject(
            $_SESSION['user_id'],
            $this->_request->android_version,
            $this->_request->app_version,
            $this->_request->brand,
            $this->_request->uuid);

        parent::response($Result);

    }

    // -------------------------------------------------------------------------------- //
    // ---------------- store web socket uuid for the user in the session ------------- //
    // -------------------------------------------------------------------------------- //
    public function updateUserHBObject(){

        $Result=$this->_userCore->updateUserHBObject(
            $_SESSION['user_id'],
            $this->_request->android_version,
            $this->_request->app_version,
            $this->_request->brand,
            $this->_request->uuid,
            $this->_request->os,
            $this->_request->app_code,
            $this->_request->platform,
            $this->_request->emulated,
            $this->_request->power_state);

        parent::response($Result);

    }

    // ----------------------------------------------------------------------------------------- //
    // ---------------- store anonymous selected role (for marketing purposes only) ------------- //
    // ------------------------------------------------------------------------------------------ //
    public function storeAnonymousCategory(){

        $this->_userCore->storeAnonymousCategory($this->_request->cat,$_SESSION['user_id']);
        $Result['MESSAGE'] = "USER.SUCCESSFUL_OPERATION";
        parent::response($Result);
    }


    // --------------------------------------------------------------------------- //
    // --------------------- activate/Deactivate User Profile ------------------ //
    // --------------------------------------------------------------------------- //
    public function changeStatus(){

        $this->_userCore->changeStatus($this->_request->user_id, $this->_request->new_status,$_SESSION['user_id']);

        // write remarks if exist
        if($this->_request->remarks != null){
            $addNoteCore = new Add_notes_core();
            $addNoteCore->addNotes('user', $this->_request->user_id, $this->_request->remarks , $_SESSION['user_id'] );
        }

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "USER.SUCCESSFUL_OPERATION";
        parent::response($Result);

    }


    // ----------------------------------------------------------------------------------------//
    // ------------- API for mobile users to reply for heartbeat messages  ------------------- //
    // --------------------------------------------------------------------------------------- //
    public function isAlive(){

        if($_SESSION['user_id']){
            $this->_userCore->updateUserHBObject($_SESSION['user_id'],
            $this->_request->android_version,
            $this->_request->app_version,
            $this->_request->brand);

            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "USER.SUCCESSFUL_OPERATION";
            parent::response($Result);
        }
    }


    // ---------------------------------------------------------------------------//
    // ------------- API for mobile users to save phone book  ------------------- //
    // ------------- param: user_id, pb ----------------------------------------- //
    // -------------------------------------------------------------------------- //
    public function store_pb(){

        $Result['user_id'] = $this->_request->user_id;
        $Result['pb'] = $this->_request->pb;
        parent::response($Result);

    }


    // ---------------------------------------------------------------------------//
    // ------------- API for mobile users to save current GPS location ---------- //
    // ------------- param: user_id, longitude, latitude ------------------------ //
    // -------------------------------------------------------------------------- //
    public function saveUserLocation(){

        $Result['user_id'] = $this->_request->user_id;
        $Result['longitude'] = $this->_request->longitude;
        $Result['latitude'] = $this->_request->latitude;
        parent::response($Result);

    }


    // ---------------------------------------------------------------------------//
    // ------------- API for mobile users to save last seen timestamp ----------- //
    // ------------- param: user_id, last_seen ----------------------------------- //
    // -------------------------------------------------------------------------- //
    public function saveLastSeen(){
        $Result['user_id'] = $this->_request->user_id;
        $Result['last_seen'] = DBConnection::getSystemDate();
        parent::response($Result);
    }


    // -------------------------------------------------------------------------------------------------- //
    // ------------- API for to update user name ,nn and id_serial -------------------------------------- //
    // ------------- param: name, nn, id_serial --------------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function updatePersonName(){

        $name = $this->_request->name;

        // This line creates a task to automatically get person name
        //$result = $this->_mg_registrar->getPersonName($nn,$id_serial);

        $this->_userCore->updatePersonName($name,$_SESSION['u_id'] , $_SESSION['user_id']);

        $Result=[];
        $Result['ERRORCODE'] = '0';
        $Result['MESSAGE'] = 'USER.SUCCESS_OPERATION';
        parent::response($Result);

    }


    // ---------------------------------------------------------------------------------- //
    // ------------- get the tour guide progress for TC employee ------------------------ //
    // ---------------------------------------------------------------------------------- //
    public function getTourGuide(){

        $progressItems['TC_MANAGER'] = [
            ["caption" => "" , "isDone" => true]
        ];

        // get the the items of progress
    }


    // ---------------------------------------------------------------------------------- //
    // -------------  auto complete user info by providing phone and nn ----------------- //
    // ---------------------------------------------------------------------------------- //
    public function userAutoCompleteByClient(){

        $phone = $this->_request->phone;
        $nn = $this->_request->nn;

        $phone = convertToInternational($phone);
        $searchFilter = [['key'=>'status','val' => "ACTIVE"]];
            if($phone){
                $searchFilter[] = ['key'=>'phone','val' => $phone];
            }
            if($nn){
                $searchFilter[] = ['key'=>'nn','val' => $nn];
            }
        $searchUserResult = DBConnection::searchDB("user",$searchFilter,1,0,0);

        if($searchUserResult->found_rows > 0){
            parent::response($searchUserResult->data[0]);
        }else{
            throw new Exception("الرجاء التأكد من المعلومات المدخلة");
        }
    }

    // ----------------------------------------------------------- //
    // -------------  check if user has e wallet ----------------- //
    // ----------------------------------------------------------- //
    public function checkUserWallet(){

        $user_phone = $this->_request->phone;
        $poll_id = $this->_request->poll_id;

        try{
            $this->_taskQueuesCore->createOneFillsTask($user_phone,$poll_id);
        }catch(Exception $e){
            throw new Exception($e->getMessage());
        }
        
    }

    
    // ------------------------------------------------------------------------------- //
    // -------------  check if user has e wallet and save the result ----------------- //
    // ------------------------------------------------------------------------------- //
    public function saveUserWallet(){

        // get request params
        $user_id = $this->_request->user_id;

        // get user bean
        $userBean = $this->_userCore->getUserBasic($user_id,$_SESSION['user_id']);

        // get user wallet
        $zain_cash = new Zain_cash();
        $walletResult = $zain_cash->getUserWallet($userBean->phone);

        // if user wallet is ACTIVE , then the user has active wallet no need to do anything
        if($walletResult && $walletResult['RESULT'] == 'ACTIVE'){
            $Result=[];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'رقم الهاتف يملك محفظة الكترونية فعالة';
            parent::response($Result);
        }
        else{
            // transfer 1 fills to user
            $this->_taskQueuesCore->createOneFillsTask($userBean->phone);

            $Result=[];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'تم ارسال فلس واحد لرقم الهاتف وجار العمل على تدقيق الرقم';
            parent::response($Result);
        }
    }

     public function processPersonalDocument(){
        // Get poll data
         $pollId = $this->_request->poll_id;
        $userId = $this->_request->user_id;
        $answers = $this->_request->answers;

         if (empty($userId)) throw new Exception("user_id is required");
         if (empty($answers)) throw new Exception("answers is required");

        $answers = is_string($answers) ? json_decode($answers, true): $answers;
        // Get image uri
        $imageQuestions = array_filter($answers, function ($answer){ return strpos($answer->value, "http") !== false; });

        // Get User bean
         $userBean = $this->_userCore->getUserBasic($userId, 0);
        // Get Poll bean and unset recipients node
         $poll = $this->_poll->getPoll($pollId);

        // Create Ticket
        $ticketData = [
            "type_code" => "PERSONAL_DOCS",
            "priority" => 7,
            "title" => "معاملة تحديث وثائق شخصية",
            "senderName" => $userBean->name,
            "user_id" => $userId,
            "company_id" => null,
            "body" => [
                "user_id" => $userId,
                "user_name" => $userBean->name,
                "type_code" => "PERSONAL_DOCS",
                "poll" => $poll['details']
            ]
        ];

        $ticketFilters = new stdClass();
        $ticketFilters->ticket_type = "client";
        $ticketFilters->type_code = "PERSONAL_DOCS";

        // Convert to stdClass objects
        $ticketData = json_decode(json_encode($ticketData,JSON_UNESCAPED_UNICODE));

        $ticket = $this->_customerCare->createTicket($ticketData, $ticketFilters);

        // Add replies with images
         foreach ($imageQuestions as $imageQuestion)
         {
             $id = $ticket['id'];
             $note = new stdClass();
             $note->body = "";
             $note->attachments = [$imageQuestion->value];
             $note->senderName = $userBean->name;
             // call to customer care system to create ticket
             $this->_customerCare->replyToTicket($id,$note);
         }


         parent::response($ticket);
         return;
     }


    // -------------------------------------------------------------------------------- //
    // ------------------- Validate id_token if valid --------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function validateUser(){
      
        $token = $this->_request->user_token;       

        if (!$token)
            throw new Exception("user_token is required", 1);
        
        // validate user token
        $userInfo = $this->_loginCore->loginUser($imei = '', $sim_id = '', $brand = '', $token);

        // init session record in database
        $initSession = new stdClass();
        $initSession->phone_number = $userInfo['phone_number'];
        $initSession->email = $userInfo['email'];
        $initSession->token = $token;
        $initSession->user_id = $userInfo['user_id'];
        $session_id = $this->initPersonalSession($initSession);
        
        $result = new stdClass();
        $result->u_id = $userInfo['user_id'];
        $result->name = $userInfo['name'];
        $result->user_id = $session_id;
        parent::response($result);
    }


    // -------------------------------------------------------------------------------- //
    // ------------------- get full info about certain session--------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function getSessionInfo(){

        $session_id = $this->_request->session_id;
        $sessionObj = parent::getSession($session_id);
        $sessionObj = json_decode(json_encode($sessionObj), true);
        $details = json_decode($sessionObj['details']);
        $sessionObj['type'] = $details->type;

        if($details->company_employee_id){
            $userProfile = $this->_company_employee->getCompanyEmployeeProfile($details->company_employee_id, 0);           
            $company_employee_info = json_decode($userProfile['company_employee_info']);
            $sessionObj['company_id'] = $company_employee_info->company_id;
            $sessionObj['account_ids'] = $company_employee_info->account_ids;
            $sessionObj['company_employee_location_id'] = $company_employee_info->location_id;      
        }else{

            if($details->id == 1 ||$details->id == 2 || $details->id == 12865  ){
                $sessionObj['company_id'] = 266771;
                $sessionObj['account_ids'] = ["*"];
            }           
            
        }
        
        parent::response($sessionObj);

    }

}

$user_interface = new User_interface();
