<?php 

// import objects
require_once (dirname(__FILE__)."/../../includes/DBConnection.php");
require_once (dirname(__FILE__).'/../driver/driver_core.php');
require_once (dirname(__FILE__).'/../truck_owner/truck_owner_core.php');
require_once (dirname(__FILE__).'/../../includes/util.php');
require_once (dirname(__FILE__)."/../gateway/gateWay_core.php");
require_once (dirname(__FILE__)."/../payment_agent/payment_agent_core.php");
require_once (dirname(__FILE__)."/../company/company_core.php");
require_once (dirname(__FILE__)."/../company/trucking_company/trucking_company_core.php");
require_once (dirname(__FILE__)."/../account/account_core.php");


class UserCore {
     
    private $_gatewayCore;

    public function __construct(){
        DBConnection::getInstance();
        $this->_gatewayCore = new GatewayCore();
    }


    // ------------------------------------------------------------------------------ //
    // --------------- GET HB object  stored in user_hb table ------------- //
    // ------------------------------------------------------------------------------ //
    public function getUserHeartBeatObject($user_id){

        // get original HB
        $sqlQuery = "select cast( hb as char charset utf8) as hb from user_hb where user_id = $user_id";
        $heartBeat =  DBConnection::runDatabaseQuery($sqlQuery);

        if($heartBeat[0]->hb!='{}'){
            $heartBeat = json_decode( $heartBeat[0]->hb);
            $heartBeat = $heartBeat[0];
        }else{
            $heartBeat=new stdClass();
        }

        return $heartBeat;
    }


    // ------------------------------------------------------------------------ //
    // -------------------Create User bean and fill it from DB  ------------- //
    // ------------------------------------------------------------------------ //
    public function getUser($id,$user_id){ // IMPORTANT: user_id is the user who search not the user we are looking for.
        
        $userInfo = DBConnection::getObjectBean("user",$id,$user_id);
        if($userInfo == null){
            throw new Exception("USER.NOT_EXIST",0);
        }
        return $userInfo;
    }

    // ------------------------------------------------------------------------ //
    // -------------------Create User bean and fill it from DB  ------------- //
    // ------------------------------------------------------------------------ //
    public function getUserBasic($id,$user_id){ // IMPORTANT: user_id is the user who search not the user we are looking for.

        $userBean = DBConnection::getBasicObjectBean("user",$id,$user_id);
        return $userBean;
    }

    // --------------------------------------------------------------------------- //
    // -------------------Create User Role bean and fill it from DB  ------------- //
    // --------------------------------------------------------------------------- //
    public function getUserRole($id,$user_id){ // IMPORTANT: user_id is the user who search not the user we are looking for.
        
        $userInfo = DBConnection::getObjectBean("user_role",$id,$user_id);
        if($userInfo == null){
            throw new Exception("USR_ROLE.NOT_EXIST",0);
        }
        return $userInfo;
    }

    // ------------------------------------------------------------------------ //
    // -------------------search for users using any search filter ---------- //
    // ------------------------------------------------------------------------ //
    public function searchUser($searchFilter, $limit, $offset, $user_id){

        $searchUserResult = DBConnection::searchDB("user",$searchFilter, $limit, $offset, $user_id);
        return $searchUserResult;
    }

    // ------------------------------------------------------------------------ //
    // -------------------search for users using any search filter ---------- //
    // ------------------------------------------------------------------------ //
    public function searchUserRoles($searchFilter, $limit, $offset, $user_id){
   
        $searchUserResult = DBConnection::searchDB("user_role",$searchFilter, $limit, $offset, $user_id);
        return $searchUserResult;
    }
    
    // ------------------------------------------------------------------------ //
    // -------------------Update user photos  --------------------------------- //
    // ------------------------------------------------------------------------ //
    public function updateUserPhoto($userId, $imageURI, $imageType){
        // Get user bean
        $user = $this->getUserBasic($userId, 0);

        // Decode image uri
        $imageURI = urldecode($imageURI);
        // Get user photos
        $photos = is_string($user->photos) ? json_decode($user->photos, true): $user->photos;
        if(!$photos){
            $photos=[];
        }
        // Append new image node
        $photos[] = [
            "type" => $imageType,
            "url" => $imageURI
        ];
        // Update user bean
        $user->photos = $photos;
        $this->updateUserInfo($user, $userId, 0);

        // Generate thumbnail
        $generateThumbnailURI="https://us-central1-waybill-system.cloudfunctions.net/generateThumb?imageURL=$imageURI";
        $generateThumbnailURI = urldecode($generateThumbnailURI);
        file_get_contents($generateThumbnailURI);

    }



    // -------------------------------------------------------------------- //
    // --------------------- Update user info in DB------------------------ //
    // -------------------------------------------------------------------- //
    function updateUserInfo($userBean,$user_id, $updated_by){
        
        // get basic object bean without any activites
        $DB_Bean = DBConnection::getBasicObjectBean("user",$user_id,$updated_by);

        //update userInfo only if the user bean is different than DB bean
        if(compareObject($userBean,$DB_Bean) == false) {

            // map all the new values into the DB_bean
            $userBean = mapBeanToDBBean($userBean,$DB_Bean);

            //re-validate the user input
            //$this->validateForEdit($userBean);

            // fill update struct and set the target user id
            $userBean->id = $user_id;

            unset($userBean->phone);
            unset($userBean->notification_token);
            unset($userBean->integration_token);
            DBConnection::updateDB("user",$userBean,$updated_by);

            // update account name
            $userFilter = [['key'=>"user_id",'val' => $user_id],['key'=>"status",'val' => 'ACTIVE']];
            $accountCore = new AccountCore();
            $account_qry = $accountCore->searchAccount($userFilter, 1, 0, 0);

            if($account_qry->found_rows > 0){
                $updateStruct = new stdClass();
                $updateStruct->id = "'" .$account_qry->data[0]->id . "','0'";
                $updateStruct->name = $userBean->name;
                //DBConnection::updateDB("account",$updateStruct,0);
            }


        }
    }


    // ----------------------------------------------------------------------- //
    // ------------ Validate User input for edit ----------------------------- //
    // ----------------------------------------------------------------------- //
    function validateForEdit($userBean) {
        $validationRules =  $this->_gatewayCore->getResource("VALIDATION","user");

        $status = $userBean->status;

        foreach($userBean as $key=>$userInput){
            if($validationRules[$key]){
                $rule = $validationRules[$key];
                $validationResult = validateInput($userInput,$rule,$status);
 
                if($validationResult->error_message){
                    throw new Exception($validationResult->error_message);
                }
            }
        }
    }
 


    // -------------------------------------------------------------------------------------- //
    // --------------------- register new user then assign default role to it --------------- //
    // -------------------------------------------------------------------------------------- //
    function registerNewUser($userBean, $created_by){
        
        $this->validateForCreate($userBean);
        $searchUserResult = DBConnection::insertDB("user",$userBean,$created_by);
 
        // get the newly created userID
        $newUserQry = $searchUserResult[0];
        $user_ID =  $newUserQry['@id'];

        //assign the new created user to the default role (ANONYMOUS)
        $userRoleBean = new stdClass();
        $userRoleBean->user_id = $user_ID;
        $userRoleBean->role_code = 'ANONYMOUS';
        $newUserRoleQry = DBConnection::insertDB("user_role",$userRoleBean,$created_by);          
        $user_role_id =  $newUserRoleQry[0]['@id'];

        //activate the ANONYMOUS role for this user (by SYSTEM)
        $this->changeRoleStatus($user_role_id,'','ACTIVE',0);

        // Create New account for the user
        $accountCore = new AccountCore();
        $accountBean = new stdClass();
        $accountBean->user_id = $user_ID;
        $accountBean->name = $userBean->name;
        $accountBean->company_id = null;
        $accountBean->minimum_balance = 0;
        $accountBean->balance = 0;
        $accountBean->currency = 'JOD';
        $accountBean->status = 'NEW';
        $accountCore->createAccount($accountBean,"user",0);

        return $user_ID;
       
    }

    // ----------------------------------------------------------------------- //
    // ------------ Validate User input for create --------------------------- //
    // ----------------------------------------------------------------------- //
    function validateForCreate($userBean) {
        $validationRules =  $this->_gatewayCore->getResource("VALIDATION","user");
 
        foreach($userBean as $key=>$userInput){
            if($validationRules[$key]){
                $rule = $validationRules[$key];
                $validationResult = validateInput($userInput,$rule,'NEW');

                if($validationResult->error_message){
                    throw new Exception($validationResult->error_message);
                }
            }
        }
    }

    // -------------------------------------------------------------------------------------------------------- //
    // --------------------- activate or deactivate user role and it corresponding object --------------------- //
    // -------------------------------------------------------------------------------------------------------- //
    function changeRoleStatus($user_role_id,$object, $new_status, $updated_by){
        
        // get the corresponding object and apply the activate/Deactivate action to it
        $userRoleStructFilter = [['key'=>'id','val' => $user_role_id ,'op' => '=']];
        $userRoleStruct = DBConnection::searchDB("user_role",$userRoleStructFilter,1,0,$updated_by);

        foreach ($userRoleStruct->data as $obj) {
            $updateStruct = new stdClass();
             
            // Driver 
            if($object == 'DRIVER' && $obj->driver_id != null){
                $updateStruct->id = $obj->driver_id;
                $updateStruct->status = $new_status;
                DBConnection::updateDB("driver",$updateStruct,$updated_by);
            }
            // trucker 
            if($object == 'TRUCKER' && $obj->trucker_id != null){
                $updateStruct->id = $obj->trucker_id;
                $updateStruct->status = $new_status;
                DBConnection::updateDB("trucker",$updateStruct,$updated_by);
            }
            // employee 
            if($object == 'EMPLOYEE' && $obj->employee_id != null){
                $updateStruct->id = $obj->employee_id;
                $updateStruct->status = $new_status;
                DBConnection::updateDB("employee",$updateStruct,$updated_by);
            }
        }

        // activate or deactivate the role in table user_role
        $ActivateUserRoleStruct = new stdClass();
        $ActivateUserRoleStruct->id = $user_role_id;
        $ActivateUserRoleStruct->status = $new_status;

        DBConnection::updateDB("user_role",$ActivateUserRoleStruct,$updated_by);
        
    }

    // ------------------------------------------------------- //
    // ------------- update user profile --------------------- //
    // ------------------------------------------------------- //
    public function updateUserRoles($userBean,$updated_by,$user_roles){

        // validate if the session user is trying to update his role, throw exception
        if( $userBean->user_id == $updated_by){
            throw new Exception("USER_ROLE.USER_CANT_UPDATE_SELF_ROLE");
        }

        // get the new roles
        $newRolesArr = explode(",",$userBean->roles);

        // get old roles from DB
        $old_role_filter = [['key'=>'user_id','val' => $userBean->user_id]];
        $old_roles = DBConnection::searchDB("user_role",$old_role_filter,1,0,0);

        // loop on old roles and deactivate them in case roles are not exist in new roles
        foreach ($old_roles->data as $old_role) {

            // validate if the user has any MINAGATE role, throw exception
            if($old_role->company_id == 266770){
                throw new Exception("USER_ROLE.CANT_UPDATE_MINAGATE_USERS");
            }

            // skip the ANONYMOUS role
            if($old_role->role_code == 'ANONYMOUS'){
                continue;
            }

            // validate if the user has any MINAGATE role, throw exception
            if($old_role->company_id != '' && $old_role->company_id != $userBean->company_id){
                throw new Exception("USER_ROLE.CANT_ASSIGN_USER_TO_MULTI_COMPONIES");
            }

            if( $this->inRolesArray($newRolesArr,$old_role) == false ){
                $deactivateUserRoleStruct = new stdClass();
                $deactivateUserRoleStruct->id = $old_role->id;
                $deactivateUserRoleStruct->status = 'INACTIVE';
                $deactivateUserRoleStruct->update_by = $updated_by;

                DBConnection::updateDB("user_role",$deactivateUserRoleStruct,$updated_by);
            }
        }

        // loop on new roles
        foreach ($newRolesArr as $new_role) {

            // validate if the new roles is not part of the user role herarichy
            $this->isWithinSessionRoles($user_roles ,$new_role);

            // in case role is totaly new, insert it
            if( $this->inRolesArray($old_roles->data,$new_role) == false){
                $userRoleBean = new stdClass();
                $userRoleBean->user_id = $userBean->user_id;
                $userRoleBean->company_id = $userBean->company_id;
                $userRoleBean->role_code = $new_role;
                $newUserRoleQry = DBConnection::insertDB("user_role",$userRoleBean,$updated_by);
            }

            // in case role was deactivated in the past, reactivate it
            else{
                $old_role_filter = [['key'=>'user_id','val' => $userBean->user_id],
                                    ['key'=>'status','val' => 'INACTIVE'],
                                    ['key'=>'role_code','val' => $new_role]];


                $old_roles = DBConnection::searchDB("user_role",$old_role_filter,1,0,0);

                if($old_roles->found_rows > 0){
                    $activateRoleStruct = new stdClass();
                    $activateRoleStruct->id = $old_roles->data[0]->id;
                    $activateRoleStruct->status = 'ACTIVE';
                    DBConnection::updateDB("user_role",$activateRoleStruct,$updated_by);
                }
            }
        }
    }


    private function inRolesArray($rolesArr, $role){

        foreach ($rolesArr as $tempRole) {
            if($tempRole->role_code == $role){
                return true;
            }
        }
        return false;

    }

    // validate if the new roles is not part of the user role herarichy
    private function isWithinSessionRoles($current_user_roles, $new_role){

        $isValidRole = false;

        $userRolesArr = explode(",", $current_user_roles);

        foreach ($userRolesArr as $temp_user_role) {
            $availableRoles = $this->_gatewayCore->getResource("ROLES",$temp_user_role);
            if($availableRoles){
                foreach ($availableRoles as $availabelRole) {
                    if($availabelRole['VALUE'] == $new_role){
                        $isValidRole = true;
                    }
                }
            }
        }

        if(! $isValidRole){
            throw new Exception("USER.INVALID_ROLE");
        }
    }



    // ----------------------------------------------------------------------------------- //
    // ------------- get the user profile info , roles, beans and wf --------------------- //
    // ----------------------------------------------------------------------------------- //
    public function getUserProfile($user_id, $u_id){

        // init objects
        $result = [];
        $driverObj = new DriverCore();
        $ownerObj = new TruckOwnerCore();

        // get the user roles
        $searchFilter = [['key'=>'id','val' => $u_id ,'op' => '=']];
        $searchUserResult = DBConnection::searchDB("user",$searchFilter,1,0,$user_id);
 
        $userInfo = $searchUserResult->data[0];
        $result['USER_ROLES'] = $userInfo->role;

        // get the user bean infoW
        if ($userInfo->id != null){
            $result['USER_BEAN'] = json_encode($this->getUserBasic($userInfo->id,$user_id),JSON_UNESCAPED_UNICODE);
        } 

        // if the user is a driver, get the driver info
        if ($userInfo->driver_id != null){
            $result['DRIVER_BEAN'] = json_encode($driverObj->getDriverBasic($userInfo->driver_id,$user_id),JSON_UNESCAPED_UNICODE);
        }

        // if the user is a owner, get the driver info
        if ($userInfo->truck_owner_id != null){
            $result['OWNER_BEAN'] = json_encode($ownerObj->getTruckOwnerBasic($userInfo->truck_owner_id,$user_id),JSON_UNESCAPED_UNICODE);
        }

        // get the Work Flow of the user roles
        $wf_result = DBConnection::getUserWF($u_id);
        $result['WF'] = $wf_result;

        // return financial_details
        $result['financial_details'] = $userInfo->financial_details;
 
        return $result;

    }


    // ---------------------------------------------------------------------------------------------- //
    // ---------------- store anonymous selected category (for marketing purposes only) ------------- //
    // ---------------------------------------------------------------------------------------------- //
    public function storeAnonymousCategory($cat, $user_id){

        // search user if it has already answered the questionare
        $userBean = $this->getUser($user_id,$user_id);
        $userBean = json_decode($userBean);

        if($userBean->cat == null){

            $anonymousRoleBean = new stdClass();
            $anonymousRoleBean->id = $user_id;
            $anonymousRoleBean->cat = $cat;

            DBConnection::updateDB("user",$anonymousRoleBean,$user_id);
        }
    }


    // ----------------------------------------------------------------------------------------------- //
    // ----------------------- get the warnings of user bean ----------------------------------------- //
    // ----------------------------------------------------------------------------------------------- //
    public function getUserWarnings($userID, $user_id){     // user_id = session user id

        $userBean = $this->getUserBasic($userID,$user_id);
        $warnings = [];

        if(!$userBean->id_serial){
            $warning = new stdClass();
            $warning->type = "warning";
            $warning->msg = "رقم القيد المدني غير موجود";
            array_push($warnings,$warning);
        }
        if(!$userBean->birth_date){
            $warning = new stdClass();
            $warning->type = "warning";
            $warning->msg = "تاريخ الميلاد غير موجود";
            array_push($warnings,$warning);
        }
        if(!$userBean->birth_place){
            $warning = new stdClass();
            $warning->type = "warning";
            $warning->msg = "مكان الميلاد غير موجود";
            array_push($warnings,$warning);
        }

        $has_id_photo = false;
        $has_personal_photo = false;
        if($userBean->photos){
            foreach ($userBean->photos as $photo) {
                if($photo->type == 'id_photo' && $photo->url != null ) {
                    $has_id_photo = true;
                }
                if($photo->type == 'personal_photo' && $photo->url != null ) {
                    $has_personal_photo = true;
                }
            }
        }

        if(!$has_id_photo){
            $warning = new stdClass();
            $warning->type = "warning";
            $warning->msg = "صورة الهوية غير موجودة";
            array_push($warnings,$warning);
        }
        if(!$has_personal_photo){
            $warning = new stdClass();
            $warning->type = "warning";
            $warning->msg = "الصورة الشخصية غير موجودة";
            array_push($warnings,$warning);
        }

        if(!empty($warnings)){
            return $warnings;
        }else{
            return null;
        }

    }

    // --------------------------------------------------------------------------- //
    // ---------------------activate/ Deactivate an user---------------------- //
    // --------------------------------------------------------------------------- //
    public function changeStatus($u_id,$new_status,$user_id){
        $updateStruct = new stdClass();
        $updateStruct->id = $u_id;
        $updateStruct->status = $new_status;

        // change the status
        DBConnection::updateDB("user",$updateStruct,$user_id);
    }


    // ------------------------------------------------------------------------------------ //
    // --------------- Generate phone array object to be stored in user table ------------- //
    // ------------------------------------------------------------------------------------ //
    public function generatePhoneArrayObject($imei="", $phone_number, $email="", $verification_method="NONE",$notification_token=""){
        $phone_array = [];
        $phone_info = new stdClass();
        $phone_info->phone = convertToInternational($phone_number);
        $phone_info->email = $email;
        $phone_info->imei = $imei;
        $phone_info->sim = "";
        $phone_info->verification_method = $verification_method;
        $phone_info->notification_token = $notification_token;

        $phone_array[0]=$phone_info;
        return json_decode(json_encode($phone_array)) ;
    }

    // ------------------------------------------------------------------------------ //
    // --------------- Generate HB object to be stored in user_hb table ------------- //
    // ------------------------------------------------------------------------------ //
    public function updateUserHBObject($user_id, $android_version="", $app_version="", $brand="",$UUID="",
                                       $os="", $app_code="", $platform="",$emulated="",$power_state=""){

        $HB_array = [];

        $u_id = DBConnection::getUserIdFromSession($user_id);

        $HB_info = new stdClass();
        $HB_info->android_version = $android_version;
        $HB_info->app_version = $app_version;
        $HB_info->brand = $brand;
        $HB_info->UUID = $UUID;
        $HB_info->os = $os;
        $HB_info->app_code = $app_code;
        $HB_info->platform = $platform;
        $HB_info->emulated = $emulated;
        $HB_info->power_state = $power_state;
        $HB_info->last_seen = DBConnection::getSystemDate();
        array_push($HB_array, $HB_info);

        // update hb
        try{
            $sqlQuery = "update user_hb set hb = ? where user_id = ?";
            $param2 = [json_encode($HB_array),$u_id];
            $tempResult = DBConnection::runBindDatabaseQuery($sqlQuery,$param2);
        }catch(Exception $e){
        }

        // return result
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "USER.SUCCESSFUL_SAVE_USER.HB.OBJECT";
        return $Result;
    }

    // ------------------------------------------------------------------------------- //
    // ------------------ Get the mobile app version for a certain user -------------- //
    // ------------------------------------------------------------------------------- //
    public function getUserMobileVersion($user_id){

        if($user_id){
        // see if user has app version in heart beat table
        $sqlQuery = "SELECT
                        JSON_UNQUOTE(JSON_EXTRACT(hb.hb, '$[0].app_version')) app_version
                    FROM
                        user_hb hb,
                        user u
                    WHERE
                        hb.user_id = $user_id
                        and u.id = hb.user_id
                        and u.notification_token != \"\" ";

        $result =  DBConnection::runDatabaseQuery($sqlQuery);
        }else{
            $result = [];
        }

        if(!empty($result) && $result[0]->app_version && $result[0]->app_version != "null"){
            $app_version = $result[0]->app_version;
            return $app_version;
        }
        // else return 0,, this user does not have mobile
        return "0";
    }

    // ------------------------------------------------------------------------------ //
    // --------------- GET HB object  stored in user_hb table ------------- //
    // ------------------------------------------------------------------------------ //
    public function getUserHBObject($user_id){

        // get original HB
        $sqlQuery = "select hb from user_hb where user_id = $user_id";
        $heartBeat =  DBConnection::runDatabaseQuery($sqlQuery);

        if($heartBeat[0]->hb!='{}'){
            $heartBeat = json_decode( $heartBeat[0]->hb);
            $heartBeat = $heartBeat[0];
        }else{
            $heartBeat=new stdClass();
        }

        return $heartBeat;
    }
    // ------------------------------------------------------------------------------ //
    // ---------------------------- GET USER ROLES HIERARCHY  ----------------------- //
    // ------------------------------------------------------------------------------ //
    public function getUserRolesHierarchy($user_id)
    {
        $userBean = $this->getUserBasic($user_id, $user_id);
        $userRoles = explode(",", $userBean->role_code);
        $rolesHierarchy = [];
        $result = [];

        foreach ($userRoles as $role) {
            if ($role != 'ANONYMOUS') {
                $rolesHierarchy = array_merge($rolesHierarchy, $this->_gatewayCore->get_roles_Instance($role));
            }
        }
        foreach ($rolesHierarchy as $roleHierarchy) {
            array_push($result, $roleHierarchy['VALUE']);
        }
        return array_unique($result);

    }


    // ------------------------------------------------------------------------------ //
    // ---------------------------- GET USER ROLES HIERARCHY  ----------------------- //
    // ------------------------------------------------------------------------------ //
    public function updatePersonName($name, $user_id, $update_by){

        // validate input
        if(!$name){
            throw new Exception("لا تستطيع المتابعة ، الأسم غير موجود");
        }

        // get user bean
        $userBean = $this->getUserBasic($user_id, $update_by);
        if(!$userBean){
            throw new Exception("لا يوجد لديك صلاحية للمتابعة");
        }

        $userBean->name = $name;

        // call DB to update info
        $this->updateUserInfo($userBean,$user_id, $update_by);
    }


    // ------------------------------------------------------------------------------ //
    // ---------------------------- Save User Notification Token -------------------- //
    // ------------------------------------------------------------------------------ //
    public function insertNotificationRecord($user_id, $token, $status){

        $select_notification_sql = "select id from `waybill`.`user_token` where user_id = ? and status = 'ACTIVE'";
        $result = DBConnection::runBindDatabaseQuery($select_notification_sql,[$user_id]);

        if($result && sizeof($result)>0){
            $notification_sql = "update `waybill`.`user_token` set token = ? where id = ?";
            DBConnection::runBindDatabaseQuery($notification_sql,[$token,$result[0]->id]);
        }else{
        $notification_sql = "INSERT INTO `waybill`.`user_token` (`user_id`, `token`, `status`) VALUES (?,?,?)";
        DBConnection::runBindDatabaseQuery($notification_sql,[$user_id,$token,$status]);
    }
    }

    // ------------------------------------------------------------------------------ //
    // ---------------------------- get User Notification Token -------------------- //
    // ------------------------------------------------------------------------------ //
    public function getUserToken($user_id){
        $notification_sql = "SELECT token FROM waybill.user_token where user_id = ?";
        $result = DBConnection::runBindDatabaseQuery($notification_sql,[$user_id]);

        return $result[0]->token;
    }

    

}
?> 