<?php
require_once (dirname(__FILE__)."/../../includes/DBConnection.php");


class TrxCore {

    public function __construct(){
        DBConnection::getInstance();       
    }



    // -------------------------------------------------------------------------- //
    // -------------------search for account trxs using any search filter ----------- //
    // -------------------------------------------------------------------------- //
    public function searchTrx($searchFilter, $limit, $offset, $user_id){

        $searchAccountTrxResult = DBConnection::searchReport("account","01",$searchFilter, $limit, $offset,$user_id);
        return $searchAccountTrxResult;

    }

    // -------------------------------------------------------------------------- //
    // ------------------- insert new transaction on certain account ------------ //
    // -------------------------------------------------------------------------- //
    public function insertTrx($from_account, $to_account, $amount, $notes, $voucher_id, $user_id){

        // TODO: create voucher here

        // validate if any trx is from "system account" to "exteranl account". voucher_id must be provided
        $from_account_cat = substr($from_account, 0, 2);
        $to_account_cat = substr($to_account, 0, 2);

        if($from_account_cat == "59" && $to_account_cat != "59" && !$voucher_id){
            throw new Exception("trx from system account to external account must have voucher id");
        }

        //create new Trx
        $trxBean = new stdClass();
        $trxBean->from_account = $from_account;
        $trxBean->to_account = $to_account;
        $trxBean->amount = $amount;
        $trxBean->notes = $notes;
        $trxBean->voucher_id = $voucher_id;

        $trxResult = DBConnection::insertDB("account_trx",$trxBean,$user_id);

        $trx_id =  $trxResult[0]['@id'];
        return $trx_id;



    }


}