<?php
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/truck_routing_core.php");
class TruckRoutingInterface extends API
{
    private $_truckRoutingCore;
    public function __construct()
    {

        // call the super constructur
        $this->_request = parent::__construct();

        session_start();
        if (!isset($_SESSION['user_id'])) {
            throw new Exception('No Session!');
        }
        $this->_truckRoutingCore = new TruckRoutingCore();
        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }


    // ------------------------------------------------------------------------ //
    // -------------------Create Truck Route for tender order ------------- //
    // ------------------------------------------------------------------------ //
    public function createTruckRoute()
    {
        $tender_order_id = $this->_request->tender_order_id;
        $destination_id = $this->_request->destination_id;
        $count = $this->_request->count;
        $questionnaire = json_decode($this->_request->questionnaire);
        try {
            $truck_route = $this->_truckRoutingCore->createTruckRoute($tender_order_id, $destination_id, $count, $questionnaire, false, $_SESSION['user_id']);
            parent::response($truck_route);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------ //
    // -------------------get Truck Route for tender order ------------- //
    // ------------------------------------------------------------------------ //
    public function getTruckRoutes()
    {
        $tender_order_id = $this->_request->tender_order_id;
        try {
            $truck_routes = $this->_truckRoutingCore->getTruckRoutes($tender_order_id, $_SESSION['user_id']);
            parent::response($truck_routes);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------ //
    // -------------------get Truck Route for tender order ------------- //
    // ------------------------------------------------------------------------ //
    public function getTruckRoute()
    {
        $tender_order_id = $this->_request->tender_order_id;
        $id = $this->_request->id;
        try {
            $truck_route = $this->_truckRoutingCore->getTruckRoute($tender_order_id, $id, $_SESSION['user_id']);
            parent::response($truck_route);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------ //
    // -------------------get active Truck Route for tender order ------------- //
    // ------------------------------------------------------------------------ //
    public function getActiveTruckRoutes()
    {
        $tender_order_id = $this->_request->tender_order_id;
        try {
            $truck_routes = $this->_truckRoutingCore->getActiveTruckRoutes($tender_order_id, $_SESSION['user_id']);
            parent::response($truck_routes);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------ //
    // -------------------get  Truck Route dashboard for tender order ------------- //
    // ------------------------------------------------------------------------ //
    public function getActiveTruckRoutesDashboard()
    {
        $tender_order_id = $this->_request->tender_order_id;
        try {
            $truck_routes = $this->_truckRoutingCore->getActiveTruckRoutesDashboard($tender_order_id, $_SESSION['user_id']);

            // loop on routes to hide COMPLETED routes with 1 truck
            // foreach ($truck_routes as $route) {
            //     dump($route);die;
            // }

            parent::response($truck_routes);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------ //
    // -------------------get highest Truck Route for tender order ------------- //
    // ------------------------------------------------------------------------ //
    public function getHighestTruckRoute()
    {
        $tender_order_id = $this->_request->tender_order_id;
        $truck_id = $this->_request->truck_id;
        try {
            $truck_routes = $this->_truckRoutingCore->getHighestTruckRoute($tender_order_id, $truck_id, false, $_SESSION['user_id']);
            parent::response($truck_routes);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------ //
    // -------------------changeStatus Truck Route for tender order ------------- //
    // ------------------------------------------------------------------------ //
    public function changeStatus()
    {
        $tender_order_id = $this->_request->tender_order_id;
        $id = $this->_request->id;
        $status = $this->_request->status;
        try {
            $route = $this->_truckRoutingCore->changeStatus($tender_order_id, $id, $status, $_SESSION['user_id']);
            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'تمت العملية بنجاح';
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------ //
    // -------------------increasePriority Truck Route for tender order ------------- //
    // ------------------------------------------------------------------------ //
    public function increasePriority()
    {
        $tender_order_id = $this->_request->tender_order_id;
        $id = $this->_request->id;
        try {
            $this->_truckRoutingCore->increasePriority($tender_order_id, $id, $_SESSION['user_id']);
            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'تمت العملية بنجاح';
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------ //
    // -------------------increasePriority Truck Route for tender order ------------- //
    // ------------------------------------------------------------------------ //
    public function decreasePriority()
    {
        $tender_order_id = $this->_request->tender_order_id;
        $id = $this->_request->id;
        try {
            $this->_truckRoutingCore->decreasePriority($tender_order_id, $id, $_SESSION['user_id']);
            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'تمت العملية بنجاح';
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------ //
    // -------------------UPDATE Truck Route for tender order ------------- //
    // ------------------------------------------------------------------------ //
    public function updateTruckRoute()
    {
        $tender_order_id = $this->_request->tender_order_id;
        $id = $this->_request->id;
        $count = $this->_request->count;
        $questionnaire = json_decode($this->_request->questionnaire);
        try {
            $truck_route = $this->_truckRoutingCore->updateTruckRoute($tender_order_id, $id, $count, $questionnaire, $_SESSION['user_id']);
            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'تمت العملية بنجاح';
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------ //
    // -------------------change Route for truck ------------- //
    // ------------------------------------------------------------------------ //
    public function changeTruckRoute()
    {
        $waybill_id = $this->_request->waybill_id;
        $origin_id = $this->_request->origin_id;
        $destination_id = $this->_request->destination_id;

        try {
            $truck_route = $this->_truckRoutingCore->changeTruckRoute($waybill_id, $origin_id, $destination_id, $_SESSION['user_id']);
            $Result = [];
            $Result['ERRORCODE'] = '0';
            $Result['MESSAGE'] = 'تمت العملية بنجاح';
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------ //
    // -------------------get  Truck Route dashboard for tender order ------------- //
    // ------------------------------------------------------------------------ //
    public function writeTruckRouteIdOnWaybill()
    {
        $tender_order_id = $this->_request->tender_order_id;
        try {
            $truck_routes = $this->_truckRoutingCore->writeTruckRouteIdOnWaybill($tender_order_id, $_SESSION['user_id']);
            parent::response($truck_routes);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }
}

$truck_routing = new TruckRoutingInterface();
