<?php

require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../tender/tender_core.php");
require_once(dirname(__FILE__) . "/../waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../truck/truck_core.php");
require_once(dirname(__FILE__) . "/../cargo/cargo_core.php");
require_once(dirname(__FILE__) . "/../truck/truck_core.php");
require_once(dirname(__FILE__) . "/../tender_claim/tender_claim_core.php");

//summation
function sum($carry, $item)
{
    $carry += $item;
    return $carry;
}


class TruckRoutingCore
{
    private $_tenderCore;
    private $_waybillCore;
    private $_truckCore;
    private $_cargoCore;
    public function __construct()
    {
        DBConnection::getInstance();
        $this->_tenderCore = new TenderCore();
        $this->_waybillCore = new WaybillCore();
        $this->_truckCore = new TruckCore();
        $this->_cargoCore = new CargoCore();
    }

    // ------------------------------------------------------------------------ //
    // -------------------Create Truck Route for tender order ------------- //
    // ------------------------------------------------------------------------ //
    public function createTruckRoute($tender_order_id, $destination_id, $count, $questionnaire, $force_create, $user_id)
    {
        try {
            if (substr((string) $destination_id, -2, 2) == '00') { // if it is Jordan or area
                throw new Exception('لا يمكن إنشاء هذه الوجهة, يجب تحديد وجهة أكثر تفصيلا');
            }


            // get tender order bean
            $tender_order_bean = $this->_tenderCore->getTenderOrderBasic($tender_order_id, $user_id);
            // if the count for this rute is greater than total trucks count don't allow
            $total_trucks = $tender_order_bean->trucks;
            if ($count > $total_trucks && !$force_create) {
                throw new Exception('لا يمكن القيام بهذه العملية, عدد الشاحنات أكبر من العدد الكلي لهذه الطلبية' . ", العدد الكلي $total_trucks");
            }

            $tender_order_routes = $tender_order_bean->truck_routing;
            // new route object
            $route = new stdClass();
            $route->destination_id = $destination_id;
            $route->count = $count;
            $route->status = 'ACTIVE';
            if ($questionnaire) {
                $route->questionnaire = $questionnaire;
            } else {
                $route->questionnaire = $tender_order_bean->questionnaire;
            }

            $route->create_date = DBConnection::getSystemDate();
            if ($tender_order_routes) {
                //check if the destination already exsit
                foreach ($tender_order_routes as $truck_route) {
                    if ($truck_route->destination_id == $destination_id && !$force_create && ($truck_route->status == 'ACTIVE' || $truck_route->status == 'COMPLETED')) {
                        throw new Exception('الوجهة مضافة مسبقا');
                    }
                }
                // summation of used trcuks for this route
                $used_trucks = array_reduce(array_column($tender_order_routes, 'count'), 'sum');
                $reminder = $total_trucks - $used_trucks;
                if ($count > ($reminder) && !$force_create) {
                    throw new Exception("لا يمكن القيام بهذه العملية" . ", العدد المتبقي لهذه الطلبية $reminder");
                }
                // get the length of routes and add one to priority when creating a new route
                $route->priority = sizeof($tender_order_routes) + 1;
                $route->id = "$tender_order_id" . "_" . (sizeof($tender_order_routes) + 1);
                array_push($tender_order_routes, $route);
                $tender_order_bean->truck_routing = $tender_order_routes;
            } else {
                $route->priority = 1;
                $route->id = "$tender_order_id" . "_1";
                $tender_order_routes = [$route];
                $tender_order_bean->truck_routing = $tender_order_routes;
            }

            // update tender order
            DBConnection::updateDB("tender_order", $tender_order_bean, $user_id);
            return $route->id;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------ //
    // -------------------Create Truck Route for tender order ------------- //
    // ------------------------------------------------------------------------ //
    public function getTruckRoutes($tender_order_id, $user_id)
    {
        try {
            // get tender order bean 
            $tender_order_bean = $this->_tenderCore->getTenderOrderBasic($tender_order_id, $user_id);
            $tender_order_routes = $tender_order_bean->truck_routing;
            return $tender_order_routes;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------ //
    // -------------------Create Truck Route for tender order ------------- //
    // ------------------------------------------------------------------------ //
    public function getTruckRoute($tender_order_id, $id, $user_id)
    {
        try {

            // get tender order bean 
            $tender_order_bean = $this->_tenderCore->getTenderOrderBasic($tender_order_id, $user_id);
            $tender_order_routes = $tender_order_bean->truck_routing;

            foreach ($tender_order_routes as $route) {
                if ($route->id == $id) {

                    $used_waybills = [];
                    //get used waybills for this route
                    $waybillFilter = [
                        ['key' => 'order_id', 'val' => $tender_order_id],
                        ['key' => 'document', 'val' => "'$id'", 'op' => 'json unquote', 'node' => '$.integeration_details.truck_route.id']
                        // ['key' => 'destination_id', 'val' => $route->destination_id]
                    ];

                    $waybills = $this->_waybillCore->searchWaybills($waybillFilter, 10000, 0, $user_id);
                    foreach ($waybills->data as $waybill) {
                        //get some info needed for ui 
                        $doc = json_decode($waybill->document);
                        $temp = new stdClass();
                        $temp->tn = $doc->carrier[0]->truck->tn;
                        $temp->trn = $doc->carrier[0]->trailer->tn;
                        $temp->driver_name = $doc->carrier[0]->driver->name;
                        $temp->driver_nn = $doc->carrier[0]->driver->nn;
                        $temp->wn = $waybill->wn;
                        $firstTrip = $doc->first_trip;
                        $routeBean = $doc->negotiable_instructios->route;
                        $integerationDetails = $doc->integeration_details->truck_route;

                        if ($routeBean->remarks) {
                            foreach ($routeBean->remarks as $remark) {
                                if ($remark->type == 'CHANGE_ROUTE') {
                                    $temp->routing_date = $remark->timestamp;
                                    $temp->done_by = $remark->user_id;
                                }
                            }
                        }

                        if (!$temp->routing_date) {
                            if ($integerationDetails) {
                                $temp->routing_date = $integerationDetails->update_date;
                                $temp->done_by = $integerationDetails->done_by;
                            }
                        }

                        if ($firstTrip) {
                            $temp->first_trip = new stdClass();
                            if ($firstTrip->destination) {
                                $temp->first_trip->destination = getLocationName($firstTrip->destination);
                            }

                            if ($firstTrip->type == 'export') {
                                $temp->first_trip->type = 'تصدير';
                            } else if ($firstTrip->type == 'import') {
                                $temp->first_trip->type = 'استيراد';
                            } else if ($firstTrip->type == 'import_export') {
                                $temp->first_trip->type = 'استيراد\تصدير';
                            }
                            if ($firstTrip->entry_location) {
                                $temp->first_trip->entry_location = getLocationName($firstTrip->entry_location);
                            }
                        }
                        array_push($used_waybills, $temp);
                    }
                    $route->waybills = $used_waybills;
                    return $route;
                }
            }

            return null;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------ //
    // -------------------get active  Truck Route for tender order ------------- //
    // ------------------------------------------------------------------------ //
    public function getTruckRouteBasic($tender_order_id, $id, $user_id)
    {
        try {
            // get tender order bean
            $tender_order_bean = $this->_tenderCore->getTenderOrderBasic($tender_order_id, $user_id);
            $tender_order_routes = $tender_order_bean->truck_routing;
            foreach ($tender_order_routes as $route) {
                if ($route->id == $id) {
                    return $route;
                }
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------ //
    // -------------------get active  Truck Route for tender order ------------- //
    // ------------------------------------------------------------------------ //
    public function getActiveTruckRoutes($tender_order_id, $user_id)
    {
        try {
            // get tender order bean 
            $tender_order_bean = $this->_tenderCore->getTenderOrderBasic($tender_order_id, $user_id);
            $tender_order_routes = $tender_order_bean->truck_routing;
            $result = [];
            foreach ($tender_order_routes as $route) {
                if ($route->status == 'ACTIVE' || $route->status == 'COMPLETED') {
                    array_push($result, $route);
                }
            }
            return $result;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------ //
    // -------------------get active  Truck Route for tender order ------------- //
    // ------------------------------------------------------------------------ //
    public function getActiveTruckRoutesDashboard($tender_order_id, $user_id)
    {
        try {

            // get tender order bean 
            $tender_order_bean = $this->_tenderCore->getTenderOrderBasic($tender_order_id, $user_id);

            $tender_bean = $this->_tenderCore->getTenderManifest($tender_order_bean->tender_id, $user_id);
            // return $tender_bean;questionnaire":
            $tender_order_routes = $tender_order_bean->truck_routing;
            $total_used = 0;
            $total_count = $tender_order_bean->trucks;
            $total_used_of_order = 0;
            if ($tender_order_routes) {


                $routes = [];
                foreach ($tender_order_routes as &$route) {
                    if ($route->status == 'ACTIVE' || $route->status == 'COMPLETED') {
                        $waybillFilter = [
                            ['key' => 'order_id', 'val' => $tender_order_id],
                            ['key' => 'document', 'val' => "'$route->id'", 'op' => 'json unquote', 'node' => '$.integeration_details.truck_route.id']
                            // ['key' => 'destination_id', 'val' => $route->destination_id]
                        ];
                        $waybills = $this->_waybillCore->searchWaybills($waybillFilter, 10000, 0, $user_id);
                        $route->count_used = $waybills->found_rows;
                        $total_used += $waybills->found_rows;
                        $total_used_of_order += $route->count;
                        $routes[] = $route;

                        // get questionnaire questions info
                        foreach ($route->questionnaire as $q) {

                            if (
                                $tender_bean['questionnaire'][$q->id] &&
                                $tender_bean['questionnaire'][$q->id]['question_type'] == 'ROUTE:DISTINATION'
                            ) {
                                if (gettype($q->val) == 'array') {
                                    $route->destination_name = getLocationName($q->val[0]);
                                } else {
                                    $route->destination_name = getLocationName($q->val);
                                }
                            } else if (
                                $tender_bean['questionnaire'][$q->id] &&
                                $tender_bean['questionnaire'][$q->id]['question_type'] == 'ROUTE:ORIGIN'
                            ) {
                                if (gettype($q->val) == 'array') {
                                    $route->origin_name = getLocationName($q->val[0]);
                                } else {
                                    $route->origin_name = getLocationName($q->val);
                                }
                            } else if (
                                $tender_bean['questionnaire'][$q->id] &&
                                $tender_bean['questionnaire'][$q->id]['truck_answer'] == '_TRUCK_$_MINOR_TT_'
                            ) {
                                foreach ($tender_bean['questionnaire'][$q->id]['options'] as $option) {
                                    if ($option['id'] == $q->val) {
                                        $route->trailer_type = $option['name'];
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                $routes =  [];
            }
            $result['routes'] = $routes;
            $result['total_used'] = $total_used;
            $result['total_count'] = $total_count;
            $result['total_used_of_order'] = $total_used_of_order;
            return $result;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------ //
    // -------------------get highest rank  Truck Route for tender order ------------- //
    // ------------------------------------------------------------------------ //
    public function getHighestTruckRoute($tender_order_id, $truck_id, $multi_route, $user_id)
    {
        try {
            $truckCore = new TruckCore();
            // get tender order bean
            $tender_order_bean = $this->_tenderCore->getTenderOrderBasic($tender_order_id, 0);
            $tender_order_routes = $tender_order_bean->truck_routing;
            //results
            $results = [];


            if ($tender_order_routes) {
                foreach ($tender_order_routes as $route) {
                    if ($route->status == 'ACTIVE') {
                        // if the route questionnaire and truck questionnaire matching return the route
                        $is_match = $this->_tenderCore->matchRoute($truck_id, $tender_order_id, $tender_order_bean->tender_id, $route);

                        if ($is_match && !$multi_route) {
                            $results[] =  $route;
                            return $results;
                        } else if ($is_match && $multi_route) {
                            $results[] =  $route;
                        }
                    }
                }

                if (sizeof($results) > 0) {
                    return $results;
                } else {
                    $msg = 'لا يمكن المتابعة, لا يوجد توجيه يطابق بيانات الشاحنة ';
                    $msg .=  'الرجاء التأكد من وجود توجيه فعال من شاشة التوجيه - ';
                    $msg .= 'ثم التأكد من اكتمال استبيان الشاحنة ومن نمط المقطورة على المستند';
                    throw new Exception($msg);
                }
            } else {
                throw new Exception('لا يمكن المتابعة, لا يوجد توجيهات فعالة لطلبية الشاحنة');
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------ //
    // -------------------get active  Truck Route for tender order ------------- //
    // ------------------------------------------------------------------------ //
    public function closeCompletedTruckRoute($tender_order_id, $user_id)
    {
        try {

            // get tender order bean 
            $tender_order_bean = $this->_tenderCore->getTenderOrderBasic($tender_order_id, $user_id);
            $tender_order_routes = $tender_order_bean->truck_routing;
            $continueToUpdate = false;

            if ($tender_order_routes) {
                foreach ($tender_order_routes as &$route) {
                    // get destination and search in waybills
                    $waybillFilter = [
                        ['key' => 'order_id', 'val' => $tender_order_id],
                        ['key' => 'document', 'val' => "'$route->id'", 'op' => 'json unquote', 'node' => '$.integeration_details.truck_route.id']
                    ];
                    $waybills = $this->_waybillCore->searchWaybills($waybillFilter, 10000, 0, $user_id);
                    // if waybills count is equal to count of route that means the route is totaly used so close
                    if ($route->count == 0 && $waybills->found_rows == 0) {
                        $route->status = 'INACTIVE';
                        $continueToUpdate = true;
                    } else if ($waybills->found_rows == $route->count) {
                        $route->status = 'COMPLETED';
                        $continueToUpdate = true;
                    } else if ($waybills->found_rows == 0 && $route->status === 'COMPLETED') {
                        $route->status = 'INACTIVE';
                        $route->count = 0;
                        $continueToUpdate = true;
                    }
                }
                $tender_order_bean->truck_routing = $this->fixPriority($tender_order_routes);

                if ($continueToUpdate) {
                    // update tender order
                    DBConnection::updateDB("tender_order", $tender_order_bean, $user_id);
                }
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }
    // ------------------------------------------------------------------------ //
    // -------------------Create Truck Route for tender order ------------- //
    // ------------------------------------------------------------------------ //
    public function changeStatus($tender_order_id, $id, $status, $user_id)
    {
        try {
            // get tender order bean 
            $tender_order_bean = $this->_tenderCore->getTenderOrderBasic($tender_order_id, $user_id);
            $tender_order_routes = $tender_order_bean->truck_routing;
            foreach ($tender_order_routes as &$route) {
                if ($route->id == $id) {
                    // get waybills
                    $waybillFilter = [
                        ['key' => 'order_id', 'val' => $tender_order_id],
                        ['key' => 'document', 'val' => "'$id'", 'op' => 'json unquote', 'node' => '$.integeration_details.truck_route.id']
                    ];
                    $waybills = $this->_waybillCore->searchWaybills($waybillFilter, 10000, 0, $user_id);
                    // check if the used count is less than defined count
                    if ($waybills->found_rows == 0) {
                        $route->status = 'INACTIVE';
                        $route->count = 0;
                    } else if ($waybills->found_rows > 0 && $waybills->found_rows <= $route->count) {
                        $route->status = 'COMPLETED';
                    } else {
                        $route->status = $status;
                        $route->count = 0;
                    }
                }
            }
            $tender_order_bean->truck_routing = $this->fixPriority($tender_order_routes);
            // update tender order
            DBConnection::updateDB("tender_order", $tender_order_bean, $user_id);
            return $tender_order_bean;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------ //
    // -------------------increasePriority Truck Route for tender order --------//
    // ------------------------------------------------------------------------ //
    public function increasePriority($tender_order_id, $id, $user_id)
    {
        try {
            // get tender order bean 
            $tender_order_bean = $this->_tenderCore->getTenderOrderBasic($tender_order_id, $user_id);
            $tender_order_routes = $tender_order_bean->truck_routing;
            foreach ($tender_order_routes as $index => &$route) {
                if ($route->id == $id) {
                    $route->priority--;
                    //increase the priority of the next one higher
                    $tender_order_routes[$index - 1]->priority++;
                }
            }
            $tender_order_bean->truck_routing = $this->fixPriority($tender_order_routes);
            // update tender order
            DBConnection::updateDB("tender_order", $tender_order_bean, $user_id);
            return $tender_order_bean;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }



    // ------------------------------------------------------------------------ //
    // -------------------decreasePriority Truck Route for tender order ------------- //
    // ------------------------------------------------------------------------ //
    public function decreasePriority($tender_order_id, $id, $user_id)
    {
        try {
            // get tender order bean 
            $tender_order_bean = $this->_tenderCore->getTenderOrderBasic($tender_order_id, $user_id);
            $tender_order_routes = $tender_order_bean->truck_routing;
            foreach ($tender_order_routes as $index => &$route) {
                if ($route->id == $id) {
                    $route->priority++;
                    //decrease the priority of the next one higher
                    $tender_order_routes[$index + 1]->priority--;
                }
            }
            $tender_order_bean->truck_routing = $this->fixPriority($tender_order_routes);
            // update tender order
            DBConnection::updateDB("tender_order", $tender_order_bean, $user_id);
            return $tender_order_bean;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------ //
    // -------------------FIXPriority Truck Route for tender order ------------- //
    // ------------------------------------------------------------------------ //
    public function fixPriority($tender_order_routes)
    {
        try {
            //sorting based on priority
            usort($tender_order_routes, function ($a, $b) {
                return $a->priority - $b->priority;
            });

            $i = 1;
            foreach ($tender_order_routes as &$route) {
                if ($route->status == 'ACTIVE'  || $route->status == 'COMPLETED') {
                    $route->priority = $i;
                    $i++;
                }
            }
            return $tender_order_routes;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------ //
    // -------------------update Truck Route for tender order ------------- //
    // ------------------------------------------------------------------------ //
    public function updateTruckRoute($tender_order_id, $id, $count, $questionnaire, $user_id)
    {
        try {
            // get tender order bean
            $tender_order_bean = $this->_tenderCore->getTenderOrderBasic($tender_order_id, 0);

            // if the count for this rute is greater than total trucks count don't allow
            $total_trucks = $tender_order_bean->trucks;
            if ($count > $total_trucks) {
                throw new Exception('لا يمكن القيام بهذه العملية, عدد الشاحنات أكبر من العدد الكلي لهذه الطلبية' . ", العدد الكلي $total_trucks");
            }


            $tender_order_routes = $tender_order_bean->truck_routing;
            // UPDATE THE COUNT AND DESTINATION
            foreach ($tender_order_routes as &$truck_route) {
                if ($truck_route->id == $id && $truck_route->status = 'ACTIVE') {
                    // summation of used trcuks for this route
                    $used_trucks = array_reduce(array_column($tender_order_routes, 'count'), 'sum');
                    $reminder = $total_trucks - $used_trucks + $truck_route->count;
                    if ($count > ($reminder)) {
                        throw new Exception("لا يمكن القيام بهذه العملية" . ", العدد المتبقي لهذه الطلبية $reminder");
                    }
                    $truck_route->count = $count;
                    $truck_route->questionnaire = $questionnaire;
                } else if ($truck_route->id == $id &&  $truck_route->status = 'COMPLETED') {
                    // summation of used trcuks for this route
                    $used_trucks = array_reduce(array_column($tender_order_routes, 'count'), 'sum');
                    $reminder = $total_trucks - $used_trucks + $truck_route->count;
                    if ($count > ($reminder)) {
                        throw new Exception("لا يمكن القيام بهذه العملية" . ", العدد المتبقي لهذه الطلبية $reminder");
                    }
                    $truck_route->count = $count;
                    $truck_route->status = 'ACTIVE';
                    $truck_route->questionnaire = $questionnaire;
                }
            }
            $tender_order_bean->truck_routing = $this->fixPriority($tender_order_routes);
            // update tender order

            DBConnection::updateDB("tender_order", $tender_order_bean, 0);
            $this->closeCompletedTruckRoute($tender_order_bean->id, 0);
            return $tender_order_bean;
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------ //
    // -------------------increasePriority Truck Route for tender order --------//
    // ------------------------------------------------------------------------ //
    public function changeTruckRoute($waybill_id, $origin_id, $destination_id, $user_id)
    {
        try {
            //get waybill bean
            $waybill_bean = $this->_waybillCore->getWaybillBasic($waybill_id, $user_id);

            // change origin in case it is not ull
            if ($origin_id && $origin_id != "") {
                $old_location = $waybill_bean->document->negotiable_instructios->route->origin->name;

                $locationCore = new LocationCore();
                $originLocationBean =  $locationCore->getLocationBasic($origin_id, 0);
                $document = $waybill_bean->document;
                $document->negotiable_instructios->route->origin->id = $origin_id;
                $document->negotiable_instructios->route->origin->name = $originLocationBean->name;
                $waybill_bean->document = $document;
                $this->_waybillCore->updateWaybill($waybill_bean, $waybill_id, $user_id);
                $this->_waybillCore->logActivity($waybill_id, "تغيير موقع التحميل", 'تم تغير موقع التحميل من ' . $old_location . ' الى ' . $originLocationBean->name, "change_route", $user_id);
            }

            if ($destination_id && $destination_id != "") {

                // get tender truck bean
                $truck_id  = $waybill_bean->document->carrier[0]->truck->id;
                //get tender truck bean
                $tender_truck_filter = [
                    ['key' => 'truck_id', 'val' => $truck_id],
                    ['key' => 'status', 'val' => 'ACTIVE'],
                    ['key' => 'tender_id', 'val' => $waybill_bean->tender_id]
                ];

                $truck_bean = $this->_tenderCore->searchTenderTruck($tender_truck_filter, 1, 0, 0);

                if ($truck_bean->found_rows == 0) {
                    throw new Exception('لا تستطيع المتابعة ، عقد تشغيل الشاحنة على المشروع غير فعال ، الرجاء مراجعة العمليات');
                }

                $truck_questionnaire = json_decode($truck_bean->data[0]->questionnaire);
                if (!$truck_questionnaire || sizeof($truck_questionnaire) == 0) {
                    $tenderCompanyCore = new TenderCompanyCore();
                    // in case the truck questionare is null or empty
                    // fill truck questionare from company
                    $tenderCompanyFilter = [
                        ['key' => 'tender_id', 'val' => $waybill_bean->tender_id],
                        ['key' => 'trucking_company_id', 'val' => $waybill_bean->trucking_company_id],
                        ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']
                    ];
                    $tenderCompaniesReuslt = $tenderCompanyCore->searchTenderCompany($tenderCompanyFilter, 1, 0, 0);
                    $tenderCompanyBean = $tenderCompaniesReuslt->data[0];
                    $truck_questionnaire = json_decode($tenderCompaniesReuslt->data[0]->questionnaire);
                    if (!$truck_questionnaire) {
                        throw new Exception('لا تستطيع المتابعة استبيان الشاحنة في عقد التشغيل غير صحيح ، الرجاء مراجعة العمليات');
                    }
                }

                // update tender claim item in case the waybill is added to claim
                $itemFilter = [];
                $itemFilter[] = ['key' => 'waybill_id', 'val' => $waybill_bean->id];
                $itemFilter[] = ['key' => 'status', 'val' => 'ACTIVE'];
                $tenderClaimCore = new TenderClaimCore();
                $items = $tenderClaimCore->searchTenderClaimItems($itemFilter, 1, 0, $user_id);
                if ($items->found_rows > 0) {
                    $item_details = $items->data[0]->details;
                    $item_details = json_decode($item_details);
                    $item_details->destination_id = $destination_id;
                    $item_details->destination_name = getLocationName($destination_id);
                    $item_details->claim_destination_id = $destination_id;
                    $item_details->claim_destination_name = getLocationName($destination_id);
                    // save in tender item claim
                    $updateSql = "update tender_claim_item set details = ? where id=?";
                    $param = [json_encode($item_details, JSON_UNESCAPED_UNICODE), $items->data[0]->id];
                    $result = DBConnection::runBindDatabaseQuery($updateSql, $param);
                    $tenderClaimCore->reCalculateFreight($items->data[0]->id);
                }

                $truck_questionnaire[0]->val = $destination_id;
                $trailer_type = $waybill_bean->document->carrier[0]->trailer->minor_tt;
                // convert truck answer to real value
                if ($truck_questionnaire) {
                    foreach ($truck_questionnaire as $truck_answer_id => &$truckAnsweres) {
                        if (gettype($truckAnsweres->val) == "string" && $truckAnsweres->val == '_TRUCK_$_MINOR_TT_') {
                            $truckAnsweres->val = $trailer_type;
                            $truck_questionnaire[$truck_answer_id]->val = $truckAnsweres->val;
                        }
                    }
                }

                // in case the order id is null
                // this is rare case , but sometimes the order id becomes null (this needs more investigation)
                if (!$waybill_bean->order_id || $waybill_bean->order_id == "") {
                    // get the tender order id from the create activity of the bean
                    $waybill_bean_activity = json_decode($this->_waybillCore->getWaybill($waybill_id, 0))->activity;

                    $activitySQL = "select
                                    CAST(`object_bean` AS CHAR CHARSET UTF8) AS object_bean
                                    from activity where id = " . $waybill_bean_activity[0]->id;
                    $activity = DBConnection::runDatabaseQuery($activitySQL);

                    $object_bean = json_decode($activity[0]->object_bean);
                    $waybill_bean->order_id = ($object_bean->document->order->id);
                }

                // get tender order bean
                $tender_order_bean = $this->_tenderCore->getTenderOrderBasic($waybill_bean->order_id, 0);
                $tender_order_routes = $tender_order_bean->truck_routing;

                if ($tender_order_routes) {
                    $truck_route_id = null;
                    foreach ($tender_order_routes as  &$route) {
                        if ($route->destination_id == $destination_id && $route->status == 'ACTIVE') {
                            $is_match = $this->_tenderCore->matchRoute($truck_bean->data[0]->truck_id, $tender_order_bean->id, $tender_order_bean->tender_id, $route);
                            if ($is_match) {
                                $truck_route_id = $route->id;
                                break;
                            }
                        } else if ($route->destination_id == $destination_id && $route->status == 'COMPLETED') {
                            $is_match = $this->_tenderCore->matchRoute($truck_bean->data[0]->truck_id, $tender_order_bean->id, $tender_order_bean->tender_id, $route);
                            if ($is_match) {
                                $truck_route_id = $route->id;
                                $route->count++;
                                $tender_order_bean->truck_routing = $this->fixPriority($tender_order_routes);
                                // update tender order
                                DBConnection::updateDB("tender_order", $tender_order_bean, $user_id);
                                break;
                            }
                        } else if ($route->destination_id == $destination_id && $route->status == 'INACTIVE') {
                            $is_match = $this->_tenderCore->matchRoute($truck_bean->data[0]->truck_id, $tender_order_bean->id, $tender_order_bean->tender_id, $route);
                            if ($is_match) {
                                $truck_route_id = $route->id;
                                $route->count++;
                                $route->status = 'ACTIVE';
                                $tender_order_bean->truck_routing = $this->fixPriority($tender_order_routes);
                                // update tender order
                                DBConnection::updateDB("tender_order", $tender_order_bean, $user_id);
                                break;
                            }
                        }
                    }

                    if (!$truck_route_id) {
                        
                        if ($waybill_bean->tender_id == 12) {
                            $truck_route_id = $this->createTruckRoute($tender_order_bean->id, $destination_id, 1, $truck_questionnaire, true, $user_id);
                        } else {
                            throw new Exception("لا يوجد توجيه مطابق لوجهة وتفاصيل الشاحنة، يرجى مراجعة العمليات لإنشاء توجيه");
                        }
                    }
                } else {
                    // if there is no route active for this destination and tender is FUEL ,create it
                    if ($waybill_bean->tender_id == 12) {
                        $truck_route_id = $this->createTruckRoute($tender_order_bean->id, $destination_id, 1, $truck_questionnaire, true, $user_id);
                    } else {
                        throw new Exception("لا يوجد توجيه مطابق لوجهة وتفاصيل الشاحنة، يرجى مراجعة العمليات لإنشاء توجيه");
                    }
                }


                $this->_waybillCore->changeRoute($waybill_id, $destination_id, $user_id);
                // write truck route id in waybill document
                $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_id, $user_id);
                $integeration_details = $waybillBean->document->integeration_details;
                if (!$integeration_details) {
                    $integeration_details = new stdClass();
                    $integeration_details->truck_route = new stdClass();
                    $integeration_details->truck_route->id = $truck_route_id;
                    $waybillBean->document->integeration_details = $integeration_details;
                } else {
                    $waybillBean->document->integeration_details->truck_route = new stdClass();
                    $waybillBean->document->integeration_details->truck_route->id = $truck_route_id;
                }
                $this->_waybillCore->updateWaybill($waybillBean, $waybillBean->id, $user_id);

                //close completed routes
                $this->closeCompletedTruckRoute($tender_order_bean->id, $user_id);

                return  $tender_order_bean->id;
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------ //
    // -------------------get active  Truck Route for tender order ------------- //
    // ------------------------------------------------------------------------ //
    public function writeTruckRouteIdOnWaybill($tender_order_id, $user_id)
    {
        try {

            // get tender order bean
            $tender_order_bean = $this->_tenderCore->getTenderOrderBasic($tender_order_id, $user_id);
            // return $tender_bean;questionnaire":
            $tender_order_routes = $tender_order_bean->truck_routing;
            if ($tender_order_routes) {
                $index = 1;
                foreach ($tender_order_routes as &$route) {
                    $route->id = "$tender_order_id" . "_$index";
                    $waybillFilter = [
                        ['key' => 'order_id', 'val' => $tender_order_id],
                        // ['key' => 'document', 'val' => $route->id, 'op' => 'json unquote', 'node' => '$.integeration_details.truck_route.id']
                        ['key' => 'destination_id', 'val' => $route->destination_id]
                    ];
                    $waybills = $this->_waybillCore->searchWaybills($waybillFilter, 10000, 0, $user_id);
                    foreach ($waybills->data as $waybill) {
                        // write truck route id in waybill document
                        $waybillBean = $this->_waybillCore->getWaybillBasic($waybill->id, $user_id);
                        $integeration_details = $waybillBean->document->integeration_details;
                        if (!$integeration_details) {
                            $integeration_details = new stdClass();
                            $integeration_details->truck_route = new stdClass();
                            $integeration_details->truck_route->id = "$tender_order_id" . "_$index";
                            $waybillBean->document->integeration_details = $integeration_details;
                        } else {
                            $waybillBean->document->integeration_details->truck_route = new stdClass();
                            $waybillBean->document->integeration_details->truck_route->id = "$tender_order_id" . "_$index";
                        }

                        $this->_waybillCore->updateWaybill($waybillBean, $waybillBean->id, $user_id);
                    }
                    $index++;
                }
            }

            $tender_order_bean->truck_routing = $this->fixPriority($tender_order_routes);
            // update tender order
            DBConnection::updateDB("tender_order", $tender_order_bean, $user_id);

            return 'done';
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }
}
