<?php

// import required classes
require_once(dirname(__FILE__) . "/truck_owner_core.php");
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/../../includes/Captions.php");
require_once(dirname(__FILE__) . "/../company/trucking_company/trucking_company_core.php");
require_once(dirname(__FILE__) . "/../../core/woq/woq_core.php");

class TruckOwner_interface extends API
{

    // the request of each call
    private $_request = array();
    private $_truckOwnerCore;
    private $_truckingCompanyCore;
    private $_woqCore;

    public function __construct()
    {

        // call the super constructur
        $this->_request = parent::__construct();

        // validate session
        session_start();
        if (!isset($_SESSION['user_id'])) {
            throw new Exception("NO_SESSION", 1);
        }

        // init the OwnerCore object
        $this->_truckOwnerCore = new TruckOwnerCore();
        $this->_truckingCompanyCore = new TruckingCompanyCore();
        $this->_woqCore = new WoqCore();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    private function prepareFilter()
    {
        $ownerFilter = [];
        if ($this->_request->filter) {
            $filter = json_decode($this->_request->filter, true);

            foreach ($filter as $key => $value) {
                if ($key == 'name') {
                    $tempArr = ['key' => $key, 'val' => $value, 'op' => 'like'];
                } else if ($key == 'phone') {
                    $tempArr = ['key' => $key, 'val' => convertToInternational($value)];
                } else if ($key == 'query') {

                    // search by phone
                    $ownerFilter = [];
                    $tempArr = ['key' => "phone", 'val' => convertToInternational($value)];
                    $ownerFilter[] = $tempArr;
                    $owners_qry = $this->_truckOwnerCore->searchTruckOwner($ownerFilter, $this->_request->limit, $this->_request->offset, $_SESSION['user_id']);
                    if ($owners_qry->found_rows == 0) {
                        // search by name
                        $ownerFilter = [];
                        $tempArr = ['key' => "name", 'val' => $value, 'op' => 'like'];
                        $ownerFilter[] = $tempArr;
                        $owners_qry = $this->_truckOwnerCore->searchTruckOwner($ownerFilter, $this->_request->limit, $this->_request->offset, $_SESSION['user_id']);
                    }
                    // search by nn
                    if ($owners_qry->found_rows == 0) {
                        $ownerFilter = [];
                        $tempArr = ['key' => "nn", 'val' => $value];
                        $ownerFilter[] = $tempArr;
                        $owners_qry = $this->_truckOwnerCore->searchTruckOwner($ownerFilter, $this->_request->limit, $this->_request->offset, $_SESSION['user_id']);
                    }
                    $ids = [-1];
                    foreach ($owners_qry->data as $value) {
                        $ids[] = $value->id;
                    }
                    $tempArr = ['key' => "id", 'val' => $ids, 'op' => 'in'];
                } else if ($key == 'owner_type') {
                    if ($value == 'COMPANY') {
                        $tempArr = ['key' => 'company_id', 'op' => 'is not null'];
                    }
                    if ($value == 'INDIVIDUAL') {
                        $tempArr = ['key' => 'user_id', 'op' => 'is not null'];
                    }
                } else {
                    $tempArr = ['key' => $key, 'val' => $value];
                }
                array_push($ownerFilter, $tempArr);
            }
        }
        return $ownerFilter;
    }




    // -------------------------------------------------------------- //
    // --------------------- get Owner info------------------------- //
    // -------------------------------------------------------------- //
    public function getTruckOwner()
    {

        $truckOwnerBean = $this->_truckOwnerCore->getTruckOwner(
            $this->_request->id,
            $_SESSION['user_id']
        );

        //return Success reponse
        parent::response(json_decode($truckOwnerBean));
    }

    // ------------------------------------------------------------------------ //
    // -------------------search for owner using any search filter ----------- //
    // ------------------------------------------------------------------------ //
    public function searchTruckOwner()
    {

        $ownerfilter = $this->prepareFilter();


        // call the core search
        $owners_qry = $this->_truckOwnerCore->searchTruckOwner(
            $ownerfilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        // get the trucking company id for this company
        foreach ($owners_qry->data as &$owner) {

            if ($owner->company_id) {
                $companyFilter = [['key' => 'company_id', 'val' => $owner->company_id]];
                $truckingCompnayResult = $this->_truckingCompanyCore->searchTruckingCompany($companyFilter, 1, 0, $_SESSION['user_id']);
                $owner->trucking_company_id = $truckingCompnayResult->data[0]->id;
                $owner->owner_type = 'COMPANY';
            } else  if ($owner->user_id) {
                $owner->owner_type = 'INDIVIDUAL';
            }
        }

        parent::response($owners_qry);
    }


    // ------------------------------------------------------------------------ //
    // ---------------------create new truck owner profile ----------- -------- //
    // ------------------------------------------------------------------------ //
    public function CreateTruckOwner()
    {

        $createTruckOwnerResult = $this->_truckOwnerCore->CreateTruckOwner($this->_request, $_SESSION['user_id']);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['TRUCK_OWNER_ID'] = $createTruckOwnerResult;
        $Result['MESSAGE'] = "TRUCKOWNER.SUCCESS_CREATE";
        parent::response($Result);
    }

    // ------------------------------------------------------------------ //
    // --------------------- update owner info ------------------------- //
    // ------------------------------------------------------------------ //
    public function updateOwnerInfo()
    {

        $this->_truckOwnerCore->updateOwnerInfo($this->_request, $_SESSION['user_id']);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "OWNER.SUCCESS_UPDATE";
        parent::response($Result);
    }


    // ------------------------------------------------------------------ //
    // --------------------- change status owner ------------------ //
    // ------------------------------------------------------------------ //
    public function changeStatus()
    {

        $this->_truckOwnerCore->changeStatus($this->_request->truck_owner_id, $this->_request->new_status, $_SESSION['user_id']);

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "OWNER.SUCCESSFUL_OPERATION";
        parent::response($Result);
    }

    // ------------------------------------------------------- //
    // -------------------auto complete owner info ---------- //
    // ------------------------------------------------------- //
    public function truckOwnerAutoComplete()
    {

        $ownerBean = $this->_truckOwnerCore->truckOwnerAutoComplete($this->_request, $_SESSION['user_id']);
        if (!$ownerBean)
            $ownerBean = new stdClass();

        parent::response($ownerBean);
    }
}


$truckOwner_interface = new TruckOwner_interface();
