<?php 

// import objects
require_once (dirname(__FILE__)."/../../includes/DBConnection.php");
require_once (dirname(__FILE__)."/../user/user_core.php");
require_once (dirname(__FILE__)."/../../includes/Captions.php");

class TruckOwnerCore {
    
    public function __construct(){
        DBConnection::getInstance();
    }

    // ------------------------------------------------------------------------ //
    // -------------------Create TruckOwner bean and fill it from DB  ------------- //
    // ------------------------------------------------------------------------ //
    public function getTruckOwner($id,$user_id){
        
        $truckOwnerInfo = DBConnection::getObjectBean("truck_owner",$id,$user_id);
        return $truckOwnerInfo;
    }

    // ------------------------------------------------------------------------ //
    // -------------------Create TruckOwner bean and fill it from DB  ------------- //
    // ------------------------------------------------------------------------ //
    public function getTruckOwnerBasic($id,$user_id){

        $truckOwnerInfo = DBConnection::getBasicObjectBean("truck_owner",$id,$user_id);
        return $truckOwnerInfo;
    }

    // ------------------------------------------------------------------------ //
    // -------------------search for owner using any search filter ----------- //
    // ------------------------------------------------------------------------ //
    public function searchTruckOwner($searchFilter, $limit, $offset, $user_id){
        
        $searchTruckOwnerResult = DBConnection::searchDB("truck_owner",$searchFilter, $limit, $offset,$user_id);
        return $searchTruckOwnerResult;
    }

    // ------------------------------------------------------------------------ //
    // ---------------------create new truck owner----------------------------- //
    // ------------------------------------------------------------------------ //
    public function createTruckOwner($truckOwnerBean,$user_id){
        
        try{
            DBConnection::startTransaction();
  
            // insert the bean in the databases
            $createTruckOwneresult = DBConnection::insertDB("truck_owner",$truckOwnerBean,$user_id);
             
            // get the newly created owner
            $newTruckOwnerQry = $createTruckOwneresult[0];
            $truck_owner_id =  $newTruckOwnerQry['@id'];

            //assign the new created owner to the user roles
            $userRoleBean = new stdClass();
            $userRoleBean->truck_owner_id = $truck_owner_id;
            $userRoleBean->user_id = $truckOwnerBean->user_id;
            $userRoleBean->role_code = 'TRUCK_OWNER';

            DBConnection::insertDB("user_role",$userRoleBean,$user_id);  

            DBConnection::commitTransaction();
            return $truck_owner_id;
        }    
        catch(Exception $e){
            DBConnection::rollBackTransaction();
            if(!is_null($e->errorInfo) && strpos($e->errorInfo[2],'user_role_idx')){ //check if error is doublicate record of TN-NAT
                throw new exception ("TRUCKOWNER.ALREADY_REGISTERED");
            }
            throw $e;
            
        }
    }

 
    // ---------------------------------------------------------------------- //
    // --------------------- Update owner info in DB------------------------ //
    // ---------------------------------------------------------------------- //
    function updateTruckOwnerInfo($truckOwnerBean,$user_id){
        
        // fill update struct and set the target driver id
        $truckOwnerBean->id = $truckOwnerBean->owner_id;
        DBConnection::updateDB("truck_owner",$truckOwnerBean,$user_id);
        
    }

    // ------------------------------------------------------------------------ //
    // ---------------------activate an owner---------------------------------- //
    // ------------------------------------------------------------------------ //
    public function activateTruckOwner($user_id){
        
        // get the assigned role to this owner
        $searchFilter = [['key'=>'user_id','val' => $user_id ],
                         ['key'=>'role_code','val' =>  'TRUCK_OWNER'],
                         ['key'=>'status','val' => 'NEW']];
        $userRoleStruct = DBConnection::searchDB("user_role",$searchFilter,1,0,0);

        // activate the owner and its role
        $userObj = new UserCore();
        $user_role_id = $userRoleStruct->data[0]->id;
        $userObj->changeRoleStatus($user_role_id,'truck_owner','ACTIVE',0);
         
    }

    // ------------------------------------------------------------------------ //
    // --------------------deactivate an owner -------------------------------- //
    // ------------------------------------------------------------------------ //
    public function deactivateTruckOwner($owner_id,$user_id){
        
        // get the assigned role to this owner 
        $searchFilter = [['key'=>'owner_id','val' => $owner_id ,'op' => '=']];
        $userRoleStruct = DBConnection::searchDB("user_role",$searchFilter,1,0,$user_id);

        // deactivate the driver and its role
        $userObj = new UserCore();
        $user_role_id = $userRoleStruct->data[0]->id;
        $userObj->changeRoleStatus($user_role_id,'truck_owner','INACTIVE',$user_id);
         
    }

     // ------------------------------------------------------- //
    // -------------------auto complete driver info ---------- //
    // ------------------------------------------------------- //
    public function truckOwnerAutoComplete($request,$user_id){
        $userCore = new UserCore();

        $truck_owner_id = null;
        if($request->phone_nn){
            $searchFilter = [['key'=>'nn','val' =>$request->phone_nn],['key'=>'status','val' =>['INACTIVE'], 'op'=>'not in']];
            $userInfo = $userCore->searchUser($searchFilter,1,0,0)->data;
            if($userInfo){
                $truck_owner_id = $userInfo[0]->truck_owner_id;
            }
        }

        //get the id of driver if user typed mobile
        if($truck_owner_id == null){
            $request->phone_nn = convertToInternational($request->phone_nn);
            $searchFilter = [['key'=>'phone','val' =>$request->phone_nn ]];
            $userInfo = $userCore->searchUser($searchFilter,1,0,0)->data;

            if($userInfo){
                $truck_owner_id = $userInfo[0]->truck_owner_id;
            }else{
                $truck_owner_id = null;
            }
        }
 
        // get the owner bean
        if($truck_owner_id){
            // get the owner bean
            $truckOwnerBean =  $this->getTruckOwnerBasic($truck_owner_id, $user_id);
            if($truckOwnerBean->status == 'ACTIVE' || $truckOwnerBean->status == 'NEW'){
                $result = new stdClass();
                $result->truck_owner_id = $truck_owner_id;
                $result->name = $userInfo[0]->name;
                $result->nn = $userInfo[0]->nn;
                $result->phone = $userInfo[0]->phone;
                return $result;
            }else{
                return null;
            }
        }
        else{
            return null;
        }
    }


}
?>