<?php

// import required classes
require_once (dirname(__FILE__)."/../API.php");
require_once (dirname(__FILE__)."/truck_contract_core.php");
require_once (dirname(__FILE__)."/../../includes/Captions.php");
require_once (dirname(__FILE__)."/../truck/truck_core.php");
require_once (dirname(__FILE__)."/../../includes/DBConnection.php");
require_once (dirname(__FILE__)."/../truck_owner/truck_owner_core.php");
require_once (dirname(__FILE__)."/../tender/tender_core.php");
require_once (dirname(__FILE__)."/../user/user_core.php");

class Truck_contract_interface extends API{

    // the request of each call
    private $_request = array();
    private $_truckContractCore;
    private $_truckCore;
    private $_truckOwnerCore;
    private $_tenderCore;

    public function __construct(){
        DBConnection::getInstance();
        // call the super constructur
        $this->_request = parent::__construct();

        session_start();    
        if( !isset($_SESSION['user_id'])){
            throw new Exception('No Session!');
        }

        // init the object   
        $this->_truckContractCore = new TruckContractCore();
        $this->_truckCore = new TruckCore();
        $this->_truckOwnerCore = new TruckOwnerCore();
        $this->_tenderCore = new TenderCore();

        // process the incoming request
        $this->processRequest();
       
    }

    // call the correnponding method based on what the request call
    private function processRequest(){
        $func = $this->_request->method;
        unset($this->_request->method);
        if((int)method_exists($this,$func) > 0)
            $this->$func();
        else
            parent::response('Error code 404, method not found',404);   // If the method not exist with in this class, response would be "Page not found".
    }
 
    // ---------------------------------------------------------------- //
    // --------------------- get contract info------------------------- //
    // ---------------------------------------------------------------- //
    public function getTruckContract(){
        $truckBean = $this->_truckContractCore->getTruckContract($this->_request->id,$_SESSION['user_id']);
        //return Success reponse
        parent::response(json_decode($truckBean));
            
    }

    private function prepareFilter(){
        $contractFilter = [];
         
        if($this->_request->filter){
            $filter = json_decode($this->_request->filter, true);
 
            foreach ($filter as $key => $value) {
                $tempArr = ['key'=>$key,'val' => $value];
                array_push($contractFilter,$tempArr);
            }
        }
        return $contractFilter;
    }

    // ------------------------------------------------------------------------ //
    // -------------------search for contracts using any search filter ---------- //
    // ------------------------------------------------------------------------ //
    public function searchContracts(){

        $truckContractFilter = $this->prepareFilter();
 
        $contracts_qry = $this->_truckContractCore->searchTruckContracts($truckContractFilter,
                                                                $this->_request->limit,
                                                                $this->_request->offset,
                                                                $_SESSION['user_id']
                                                                );


        // parse the photos to be array of objects
        foreach ($contracts_qry->data as &$contract) {
            $contract->photos = json_decode($contract->photos);
            if(gettype($contract->photos) == 'object'){
                $contract->photos = [$contract->photos];
            }
        }
        parent::response($contracts_qry);
    }


    // ------------------------------------------------------------------------------------------------------- //
    // --------------------- validate if the truck can be added to the company/user fleet -------------------- //
    // ------------------------------------------------------------------------------------------------------- //
    public function validateContractForCreate(){


        // get the truck
        $truckFilter = [['key'=>'tn','val' =>$this->_request->truck_number],
                        ['key'=>'status','val' => ['NEW','ACTIVE'], 'op'=>'in']
                        ];
        $truckResult = $this->_truckCore->searchTrucks($truckFilter,1, 0, $_SESSION['user_id'] );


        // get the truck owner id
        if($this->_request->company_id){
            $ownerSearchFilter = [['key'=>'company_id','val' => $this->_request->company_id],
                                  ['key'=>'status','val' => ['INACTIVE'], 'op' => 'not in']];
            $truckOwnerInfo = $this->_truckOwnerCore->searchTruckOwner($ownerSearchFilter,1,0,0);
            $truck_owner_id = $truckOwnerInfo->data[0]->id;
        }

        if(!$truck_owner_id){
        $truck_id = $truckResult->data[0]->id;
        $truck_owner_id = $truckResult->data[0]->truck_owner_id;
        }

        // validate if the truck is already registred to the copmpany
        $truckContractFilter = [['key'=>"truck_owner_id",'val' => $truck_owner_id],
                                ['key'=>"truck_id",'val' => $truck_id],
                                ['key'=>"contract_type",'val' => 'JOIN'],
                                ['key'=>"status",'val' => ['ACTIVE','NEW'], 'op' => "in" ]];
        $contracts_qry = $this->_truckContractCore->searchTruckContracts($truckContractFilter,
                                                                            $this->_request->limit,
                                                                            $this->_request->offset,
                                                                            $_SESSION['user_id']
                                                                         );

        if($contracts_qry->found_rows > 0 ){
            throw new Exception('CONTRACT.TRUCK_IS_ALREADY_ADDED_TO_FLEET');
        }


        $Result['TRUCK'] = $truckResult->data[0];
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "CONTRACT.SUCCESSFUL_OPERATION";
        parent::response($Result);
    }


    // ------------------------------------------------------------------ //
    // --------------------- activate/Deactivate contract --------------- //
    // ------------------------------------------------------------------ //
    public function changeStatus(){

        // get the truck_contract bean
        $truckContractBean = $this->_truckContractCore->getBasicTruckContract($this->_request->contract_id,$_SESSION['user_id']);

        // in case the truck contract type is own, make sure no AUTH contracts is active for the truck
        if($truckContractBean->contract_type == 'OWN' && $this->_request->new_status=='INACTIVE' ){
            $truckContractFilter = [['key'=>"truck_id",'val' => $truckContractBean->truck_id],
                                    ['key'=>"contract_type",'val' => 'AUTH'],
                                    ['key'=>"status",'val' => ['ACTIVE','NEW'], 'op' => "in" ],
                                    ['key'=>"truck_owner_id",'val' => [433828], 'op' => "not in" ] // يوزر تقديم الوثائق
                                ];
            $contracts_qry = $this->_truckContractCore->searchTruckContracts($truckContractFilter,10,0,$_SESSION['user_id']);
            if($contracts_qry->found_rows > 0){
                throw new Exception('لا تستطيع الغاء عقد ملكية الشاحنة، يجب الغاء كافة عقود الوكالة اولا');
            }
        }

        // stop the deactivation if the owner is default contact for tender_truck
        if($this->_request->new_status=='INACTIVE' ){
            $activeTenderTruckStatus = DBConnection::getActiveStatus('tender_truck');
            $tenderSearchFilter = [['key'=>'truck_id','val' =>$truckContractBean->truck_id],
                                   ['key'=>'default_contact_user_id','val' =>$truckContractBean->truck_owner_id],
                                   ['key'=>'status','val' =>$activeTenderTruckStatus , 'op'=> 'in']];
            $tenderTruckResult = $this->_tenderCore->searchTenderTruck($tenderSearchFilter,1,0,0) ;

            if($tenderTruckResult->found_rows > 0){
                throw new Exception('لا تستطيع الغاء عقد ملكية الشاحنة،حيث ان صاحب العقد هو جهة الاتصال المعتمدة للشاحنة');
            }

            // check if the contract truck_id is ACTIVE tender_truck trailer_id
            $tenderTruckSearchFilter = [['key'=>'trailer_id','val' =>$truckContractBean->truck_id],
                                        ['key'=>'status','val' =>$activeTenderTruckStatus , 'op'=> 'in']];
            $tenderTruckTrailerResult = $this->_tenderCore->searchTenderTruck($tenderTruckSearchFilter,1,0,0) ;
            if($tenderTruckTrailerResult->found_rows > 0){
                $tn = $tenderTruckTrailerResult->data[0]->tn;
                //throw new Exception(" لا تستطيع الغاء عقد ملكية المقطورة ، حيث أنها مرتبطة بعقد تشغيل فعال للشاحنة رقم $tn");
            }
        }

        // activate/Deactivate contract
        $this->_truckContractCore->changeStatus($this->_request->contract_id, $this->_request->new_status, $_SESSION['user_id']);

        // in case the user want to deactivate the contract and truck contract type is own, remove the truck_owner_id from truck table
        if($truckContractBean->contract_type == 'OWN' && $this->_request->new_status=='INACTIVE' ){
            // update the truck info
            if($truckContractBean->truck_id){
            $this->_truckCore->clearTruckOwner($truckContractBean->truck_id, $_SESSION['u_id']);
        }
        }

        // in case the contract is the last contract, clear owner id
        $truckContractFilter = [['key'=>"truck_id",'val' => $truckContractBean->truck_id],
                                ['key'=>"status",'val' => ['ACTIVE','NEW'], 'op' => "in" ]];
        $contracts_qry = $this->_truckContractCore->searchTruckContracts($truckContractFilter,10,0,$_SESSION['user_id']);
        if($contracts_qry->found_rows == 0){
            if($truckContractBean->truck_id){
            $this->_truckCore->clearTruckOwner($truckContractBean->truck_id, $_SESSION['u_id']);
        }
        }

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "CONTRACT.SUCCESSFUL_OPERATION";
        parent::response($Result);

    }
}


$truck_contract_interface = new Truck_contract_interface();
