<?php 

// import objects
require_once (dirname(__FILE__)."/../../includes/DBConnection.php"); 
require_once (dirname(__FILE__)."/../../includes/Captions.php");
require_once (dirname(__FILE__)."/../truck/truck_core.php");

class TruckContractCore {
 
    public function __construct(){
        DBConnection::getInstance();
    } 

    // ------------------------------------------------------------------------ //
    // --------------------- get the truck contract info----------------------- //
    // ------------------------------------------------------------------------ //
    function getTruckContract($id,$user_id){
        $contractInfo = DBConnection::getObjectBean("truck_contract",$id,$user_id);
        if($contractInfo == null){
            throw new Exception("CONTACT.NOT_EXIST",0);
        }
        return $contractInfo;
    }

    // ------------------------------------------------------------------------------ //
    // --------------------- get the truck contract info without activities  -------- //
    // ------------------------------------------------------------------------------ //
    function getBasicTruckContract($id,$user_id){
        $contractInfo = DBConnection::getBasicObjectBean("truck_contract",$id,$user_id);
        if($contractInfo == null){
            throw new Exception("CONTACT.NOT_EXIST",0);
        }
        return $contractInfo;
    }




    // -------------------------------------------------------------------------------- //
    // -------------------search for truck contracts using any search filter ---------- //
    // -------------------------------------------------------------------------------- //
    public function searchTruckContracts($searchFilter, $limit, $offset, $user_id){

        $searchTruckResult = DBConnection::searchDB("truck_contract",$searchFilter, $limit, $offset,$user_id);
        return $searchTruckResult;
    }


    // ----------------------------------------------------------------------- //
    // -------------------- Validate Add new truck contrct ------------------- //
    // ----------------------------------------------------------------------- //
    public function validateCreateContract(){

    }

    // ------------------------------------------------------------------------ //
    // ---------------------create new truck contract ------------------------- //
    // ------------------------------------------------------------------------ //
    public function createTruckContract($truckContractBean, $user_id){

        // validate Create New Contract
        $this->validateCreateNewContract($truckContractBean);

        //create new Truck Contract Record
        $searchUserResult = DBConnection::insertDB("truck_contract",$truckContractBean,$user_id);

        // update truck_owner_id in truck table in case it is empty
        $truckCore = new TruckCore();
        $truckCore->setTruckOwner($truckContractBean->truck_id, $truckContractBean->truck_owner_id, 0);

        return $searchUserResult[0]['@id'];
       
    }

    // ------------------------------------------------------------------------ //
    // ---------------------create new truck contract ------------------------- //
    // ------------------------------------------------------------------------ //
    public function validateCreateNewContract($truckContractBean){

        //validate tthe truck contract bean, in case auth type the auth photo must exist
        if($truckContractBean->type == 'AUTH'){
            if($truckContractBean->photo == null){
                //throw new Exception("CONTRACT.AUTH.PHOTO.NOT.EXIST");
            }
        }

        // validate if the owner has another active contract with the same truck
        $searchFilter = [['key'=>'truck_owner_id','val' => $truckContractBean->truck_owner_id],
                         ['key'=>'truck_id'      ,'val' => $truckContractBean->truck_id],
                         ['key'=>'status'        ,'val' => ['INACTIVE'], 'op' => 'not in']];
        $searchTruckResult = DBConnection::searchDB("truck_contract",$searchFilter,1,0,0);

        if($searchTruckResult->found_rows>0){
            //throw new Exception("يوجد عقد فعال لنفس المالك على نفس الشاحنة");
            return;
        }

        if($truckContractBean->contract_type == 'OWN'){
            // validate if the truck has another own contract
            $searchFilter = [['key'=>'contract_type','val' => 'OWN'],
                            ['key'=>'truck_id'      ,'val' => $truckContractBean->truck_id],
                            ['key'=>'status'        ,'val' => ['INACTIVE'], 'op' => 'not in']];
            $searchTruckResult = DBConnection::searchDB("truck_contract",$searchFilter,1,0,0);
            if($searchTruckResult->found_rows>0){
                throw new Exception("الشاحنة لديها عقد ملك فعال");
            }
        }
    }

    // -------------------------------------------------------------------- //
    // ---------------------update truck contract ------------------------- //
    // -------------------------------------------------------------------- //
    public function updateTruckContract($truckContractBean, $user_id){
        
       //update Truck Contract Record
       $searchUserResult = DBConnection::updateDB("truck_contract",$truckContractBean,$user_id);                
       
    }

    // ------------------------------------------------------------------------ //
    // --------------------- change status of truck contract  ----------------- //
    // ------------------------------------------------------------------------ //
    public function changeStatus($truck_contract_id,$new_status,$user_id){
        $updateStruct = new stdClass();
        $updateStruct->id = $truck_contract_id;
        $updateStruct->status = $new_status;

        // change the status
        DBConnection::updateDB("truck_contract",$updateStruct,$user_id);
    }


}

?>