<?php

// import required classes
require_once(dirname(__FILE__) . "/truck_core.php");
require_once(dirname(__FILE__) . "/../truck_contract/truck_contract_core.php");
require_once(dirname(__FILE__) . "/../tender/tender_core.php");
require_once(dirname(__FILE__) . "/../company/trucking_company/trucking_company_core.php");
require_once(dirname(__FILE__) . "/../company/company_core.php");
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/../gateway/gateWay_core.php");
require_once(dirname(__FILE__) . "/../../includes/Captions.php");
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . '/../user/user_core.php');
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/../notes/add_notes_core.php");
require_once(dirname(__FILE__) . '/../truck_contract/truck_contract_core.php');
require_once(dirname(__FILE__) . '/../outgoing_integration/mg_registrar.php');
require_once(dirname(__FILE__) . '/../outgoing_integration/poll.php');
require_once(dirname(__FILE__) . '/../outgoing_integration/customer_care.php');


class Truck_interface extends API
{

    // the request of each call
    private $_request = array();
    private $_truckCore;
    private $_tenderCore;
    private $_truckOwnerCore;
    private $_userCore;
    private $_customerCare;
    private $_truckContractCore;
    private $_gatewayCore;
    private $_truckingCompanyCore;
    private $_companyCore;
    private $_mg_registrar;

    public function __construct()
    {

        // call the super constructur
        $this->_request = parent::__construct();

        session_start();
        if (!isset($_SESSION['user_id'])) {
            throw new Exception('No Session!');
        }

        // init the object
        $this->_truckCore = new TruckCore();
        $this->_tenderCore = new TenderCore();
        $this->_truckOwnerCore = new TruckOwnerCore();
        $this->_userCore = new UserCore();
        $this->_truckContractCore = new TruckContractCore();
        $this->_gatewayCore = new GatewayCore();
        $this->_truckingCompanyCore = new TruckingCompanyCore();
        $this->_companyCore = new CompanyCore();
        $this->_mg_registrar = new MG_registrar();
        $this->_customerCare = new CustomerCare();

        // process the incoming request
        $this->processRequest();
    }

    // call the correnponding method based on what the request call
    private function processRequest()
    {
        $func = $this->_request->method;
        unset($this->_request->method);
        if ((int)method_exists($this, $func) > 0)
            $this->$func();
        else
            parent::response('Error code 404, method not found', 404);   // If the method not exist with in this class, response would be "Page not found".
    }


    // -------------------------------------------------------------- //
    // --------------------- get Owner info------------------------- //
    // -------------------------------------------------------------- //
    public function getTruck()
    {
        // get the truck info
        $truckBean = $this->_truckCore->getTruck($this->_request->id, $_SESSION['user_id']);
        $truckBean = json_decode($truckBean);

        // get the contract auth image if any
        $truckContractFilter = [['key' => 'truck_id', 'val' => $truckBean->id]];
        $contract_qry = $this->_truckContractCore->searchTruckContracts(
            $truckContractFilter,
            1000, // limit
            0,  // offset
            $_SESSION['user_id']
        );


        $contractArray = [];
        foreach ($contract_qry->data  as &$contractInfo) {
            // if the returned data is object format it to be array of object
            if (gettype(json_decode($contractInfo->photos)) == 'object') {
                $contractInfo->photos = [json_decode($contractInfo->photos)];
            } else {
                $contractInfo->photos = json_decode($contractInfo->photos);
            }

            $contractBean = $this->_truckContractCore->getTruckContract($contractInfo->id,  $_SESSION['user_id']);
            $contractBean = json_decode($contractBean);
            array_push($contractArray, $contractBean);
        }

        //return Success reponse
        $truckResult = new stdClass();
        $truckResult->truckBean = $truckBean;
        $truckResult->contractBean = $contractArray;

        parent::response($truckResult);
    }

    // --------------------------------------------------------------------------------------------------------- //
    // --------------------- get truck bean and list of contracts for trucking company ------------------------- //
    // --------------------------------------------------------------------------------------------------------- //
    public function getClientTruckProfile()
    {

        // get the truck bean
        $truckFilter = [
            ['key' => 'tn', 'val' => $this->_request->tn],
            ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in'],
            ['key' => 'cat', 'val' => ['TRUCK-SINGLE', 'TRUCK'], 'op' => 'in']
        ];
        $contract_qry = $this->_truckContractCore->searchTruckContracts($truckFilter, 10000, 0, $_SESSION['user_id']);

        if ($contract_qry->found_rows > 0) {
            $truckBean = new stdClass();
            $contractBean = $contract_qry->data[0];
            $truckBean->id = $contractBean->truck_id;
            $truckBean->tn = $contractBean->tn;
            $truckBean->truck_owner_id = $contractBean->truck_owner_id;
            $truckBean->status = $contractBean->truck_status;
            $truckBean->tt = $contractBean->tt;
            $truckBean->minor_tt = $contractBean->minor_tt;
            $truckBean->cat = $contractBean->cat;
            $truckBean->owner_name = $contractBean->truck_owner_name;
            $truckBean->truck_photos = $contractBean->truck_photos;
        } else {
            throw new Exception("TRUCK.INVALID_TRUCK");
        }

        // get truck owner trailers
        $trucksOwnersTrailers = [];
        if ($truckBean->truck_owner_id) {

            // if truck is single , add only the TRAIL and the single it self
            if ($truckBean->cat == 'TRUCK-SINGLE') {
                $truckContractsFilter = [
                    ['key' => 'truck_owner_id', 'val' => $truckBean->truck_owner_id],
                    ['key' => 'cat', 'val' => ['TRAIL'], 'op' => 'in'],
                    ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in'],
                    ['key' => 'contract_type', 'val' => ['OWN', 'AUTH'], 'op' => 'in']
                ];
                $contract_qry = $this->_truckContractCore->searchTruckContracts($truckContractsFilter, null, 0, $_SESSION['user_id']);
                foreach ($contract_qry->data as &$trucksOwnersTrailer) {
                    $trailer = new stdClass();
                    $trailer->truck_id = $trucksOwnersTrailer->truck_id;
                    $trailer->tn = $trucksOwnersTrailer->tn;
                    array_push($trucksOwnersTrailers, $trailer);
                }

                // add the truck head (single)
                $trailer = new stdClass();
                $trailer->truck_id = $truckBean->id;
                $trailer->tn = $truckBean->tn;
                array_push($trucksOwnersTrailers, $trailer);
            } else {
                // in case the truck is TRAILER add the trail half only
                $truckContractsFilter = [
                    ['key' => 'truck_owner_id', 'val' => $truckBean->truck_owner_id],
                    ['key' => 'cat', 'val' => ['TRAIL-HALF'], 'op' => 'in'],
                    ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in'],
                    ['key' => 'contract_type', 'val' => ['OWN', 'AUTH', 'JOIN'], 'op' => 'in']
                ];
                $contract_qry = $this->_truckContractCore->searchTruckContracts($truckContractsFilter, null, 0, $_SESSION['user_id']);
                foreach ($contract_qry->data as &$trucksOwnersTrailer) {
                    $trailer = new stdClass();
                    $trailer->truck_id = $trucksOwnersTrailer->truck_id;
                    $trailer->tn = $trucksOwnersTrailer->tn;
                    array_push($trucksOwnersTrailers, $trailer);
                }
            }
        }

        // get the contracts
        $truckContractFilter = [['key' => 'truck_id', 'val' => $truckBean->id], ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']];
        $contract_qry = $this->_truckContractCore->searchTruckContracts(
            $truckContractFilter,
            1000, // limit
            0,  // offset
            $_SESSION['user_id']
        );
        $contracts = [];

        // get the contract beans
        foreach ($contract_qry->data  as &$contractInfo) {

            $contractBean = $this->_truckContractCore->getBasicTruckContract($contractInfo->id, $_SESSION['user_id']);
            $contractBean->owner_name = $contractInfo->name;
            $contractBean->nn = $contractInfo->nn;
            $contractBean->phone = $contractInfo->phone;

            if (gettype($contractBean->photos) == 'object') {
                $contractBean->photos = [$contractBean->photos];
            }

            try {
                DBConnection::has_authority($_SESSION['user_id'], 'TRUCK_CONTRACT', 'CHANGE_STATUS', $contractBean->status, 'INACTIVE');
                $contractBean->canDeactivate = true;
            } catch (Exception $e) {
                $contractBean->canDeactivate = false;
            }

            // append the contract bean into the array
            array_push($contracts, $contractBean);
        }

        // return the result
        $truckResult = new stdClass();
        $truckResult->truckBean = $truckBean;
        $truckResult->contracts = $contracts;
        $truckResult->trucksOwnersTrailers = $trucksOwnersTrailers;


        parent::response($truckResult);
    }


    // ------------------------------------------------------------------------------------ //
    // --------------------- get truck bean and list of contracts ------------------------- //
    // ------------------------------------------------------------------------------------ //
    public function getTruckProfile()
    {

        // get the truck bean
        if ($this->_request->id) {
            $truckBean = $this->_truckCore->getTruck($this->_request->id, $_SESSION['user_id']);
            $truckBean = json_decode($truckBean);
            $truck_id = $this->_request->id;
        } else if ($this->_request->tn) {
            $truckFilter = [
                ['key' => 'tn', 'val' => $this->_request->tn],
                ['key' => 'nationality_code', 'val' => 'JOR'],
                ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']
            ];
            $truck_qry = $this->_truckCore->searchTrucks($truckFilter, 1, 0, $_SESSION['user_id']);

            $truck_id = $truck_qry->data[0]->id;
            if ($truck_id) {
                $truckBean = $this->_truckCore->getTruck($truck_id, $_SESSION['user_id']);
                $truckBean = json_decode($truckBean);
            } else {
                // do nothing
            }
        }

        // get the truck info from minagate-reg
        $autocompleteTruckBean = new stdClass();
        if (!$truck_id) {
            $result = $this->_mg_registrar->getTruckData($this->_request->tn, 'JOR', 'c395');

            if (isset($result[0]['details'])) {
                $autocompleteTruckBean = $result[0]['details'];
                $autocompleteTruckBean = json_decode($autocompleteTruckBean, true);
            } else {
                $autocompleteTruckBean = $result;
            }

            if ($autocompleteTruckBean['cat'] == "TRUCK") {
                $autocompleteTruckBean['minor_tt'] = 9;
            }

            $date = str_replace('/', '-', $autocompleteTruckBean['reg_expiry']);
            $autocompleteTruckBean['reg_expiry'] = date("Y-m-d", strtotime($date));
        }

        // get the the truck owner
        $truckContractsFilter = [
            ['key' => 'truck_id', 'val' => $truckBean->id],
            ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in'],
            ['key' => 'contract_type', 'val' => ['OWN', 'AUTH', 'JOIN'], 'op' => 'in']
        ];

        $truckContract_qry = $this->_truckContractCore->searchTruckContracts($truckContractsFilter, 1000, 0, $_SESSION['user_id']);
        $truck_owner_ids = [];

        // search for OWN contract
        foreach ($truckContract_qry->data as $truckContract) {
            if ($truckContract->truck_owner_id == 433828) {   //يوزر تقديم وثائق
                continue;   //skip this owner
            }
            $truck_owner_ids[] = $truckContract->truck_owner_id;
        }

        // get truck owner trailers
        $trucksOwnersTrailers = [];
        if ($truckBean && $truck_owner_ids) {

            // if truck is single , add only the TRAIL and the single it self
            if ($truckBean->cat == 'TRUCK-SINGLE') {
                $truckContractsFilter = [
                    ['key' => 'truck_owner_id', 'val' => $truck_owner_ids, 'op' => 'in'],
                    ['key' => 'cat', 'val' => ['TRAIL', 'TRAIL-HALF'], 'op' => 'in'],
                    ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in'],
                    ['key' => 'contract_type', 'val' => ['OWN', 'AUTH', 'JOIN'], 'op' => 'in']
                ];
                $contract_qry = $this->_truckContractCore->searchTruckContracts($truckContractsFilter, 10000, 0, $_SESSION['user_id']);
                foreach ($contract_qry->data as &$trucksOwnersTrailer) {
                    $trailer = new stdClass();
                    $trailer->truck_id = $trucksOwnersTrailer->truck_id;
                    $trailer->tn = $trucksOwnersTrailer->tn;
                    array_push($trucksOwnersTrailers, $trailer);
                }

                // add the truck head (single)
                $trailer = new stdClass();
                $trailer->truck_id = $truckBean->id;
                $trailer->tn = $truckBean->tn;
                array_push($trucksOwnersTrailers, $trailer);
            } else {

                // in case the truck is TRAILER add the trail half only
                $truckContractsFilter = [
                    ['key' => 'truck_owner_id', 'val' => $truck_owner_ids, 'op' => 'in'],
                    ['key' => 'cat', 'val' => ['TRAIL-HALF'], 'op' => 'in'],
                    ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in'],
                    ['key' => 'contract_type', 'val' => ['OWN', 'AUTH', 'JOIN'], 'op' => 'in']
                ];

                $contract_qry = $this->_truckContractCore->searchTruckContracts($truckContractsFilter, 10000, 0, $_SESSION['user_id']);
                foreach ($contract_qry->data as &$trucksOwnersTrailer) {
                    $trailer = new stdClass();
                    $trailer->truck_id = $trucksOwnersTrailer->truck_id;
                    $trailer->tn = $trucksOwnersTrailer->tn;
                    array_push($trucksOwnersTrailers, $trailer);
                }
            }
        }


        // get the truck warning
        $truckWarnings = $this->getTruckWarnings($truckBean);
        if ($truckBean && $truckWarnings) {
            $truckBean->warnings = $truckWarnings;
        }

        // get the contracts
        if ($truckBean) {
            $truckContractFilter = [
                ['key' => 'truck_id', 'val' => $truckBean->id],
                ['key' => 'truck_owner_id', 'val' => [433828], 'op' => 'not in'],  // exclude يوزر تقديم وثائق
                ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']
            ];
            $contract_qry = $this->_truckContractCore->searchTruckContracts(
                $truckContractFilter,
                1000, // limit
                0,  // offset
                $_SESSION['user_id']
            );
        }

        $contracts = [];

        // get the contract beans
        if ($contract_qry) {
            foreach ($contract_qry->data  as &$contractInfo) {

                $contractBean = $this->_truckContractCore->getBasicTruckContract($contractInfo->id, $_SESSION['user_id']);
                $contractBean->owner_name = $contractInfo->name;
                $contractBean->nn = $contractInfo->nn;
                $contractBean->phone = $contractInfo->phone;

                if (gettype($contractBean->photos) == 'object') {
                    $contractBean->photos = [$contractBean->photos];
                }

                try {
                    DBConnection::has_authority($_SESSION['user_id'], 'TRUCK_CONTRACT', 'CHANGE_STATUS', $contractBean->status, 'INACTIVE');
                    $contractBean->canDeactivate = true;
                } catch (Exception $e) {
                    $contractBean->canDeactivate = false;
                }

                // append the contract bean into the array
                array_push($contracts, $contractBean);
            }
        }


        // return the result
        $truckResult = new stdClass();
        $truckResult->truckBean = $truckBean;
        $truckResult->autocompleteTruckBean = $autocompleteTruckBean;
        $truckResult->contracts = $contracts;
        $truckResult->trucking_company = $contracts;
        $truckResult->trucksOwnersTrailers = $trucksOwnersTrailers;

        parent::response($truckResult);
    }


    // ----------------------------------------------------------------------------------------------- //
    // ----------------------- get the warnings of truck bean ----------------------------------------- //
    // ----------------------------------------------------------------------------------------------- //
    public function getTruckWarnings($truckBean)
    {

        $warnings = [];

        if (!$truckBean->reg_num) {
            $warning = new stdClass();
            $warning->type = "warning";
            $warning->msg = "رقم التسجيل غير محدد";
            array_push($warnings, $warning);
        }
        if (!$truckBean->axial_weight) {
            $warning = new stdClass();
            $warning->type = "warning";
            $warning->msg = "وزن الشاحنة غير محدد";
            array_push($warnings, $warning);
        }
        if (!$truckBean->axis) {
            $warning = new stdClass();
            $warning->type = "warning";
            $warning->msg = "عدد المحاور غير محدد";
            array_push($warnings, $warning);
        }
        if (!$truckBean->make_year) {
            $warning = new stdClass();
            $warning->type = "warning";
            $warning->msg = "سنة الصنع غير محددة";
            array_push($warnings, $warning);
        }
        if (!$truckBean->color) {
            $warning = new stdClass();
            $warning->type = "warning";
            $warning->msg = "لون الشاحنة غير محدد";
            array_push($warnings, $warning);
        }
        if (!$truckBean->chasis_num) {
            $warning = new stdClass();
            $warning->type = "warning";
            $warning->msg = "رقم الشصي غير موجود";
            array_push($warnings, $warning);
        }
        if (!$truckBean->reg_expiry) {
            $warning = new stdClass();
            $warning->type = "warning";
            $warning->msg = "تاريخ انتهاء الرخصه غير موجود";
            array_push($warnings, $warning);
        }


        $has_truck_license_photo = false;
        if ($truckBean->photos) {

            if (!is_array($truckBean->photos)) {
                $truckBean->photos = json_decode($truckBean->photos);
            }

            foreach ($truckBean->photos as $photo) {
                if ($photo->type == 'truck_license_photo' && $photo->url != null) {
                    $has_truck_license_photo = true;
                }
            }
        }

        if (!$has_truck_license_photo) {
            $warning = new stdClass();
            $warning->type = "warning";
            $warning->msg = "صورة رخصة القيادة غير موجودة";
            array_push($warnings, $warning);
        }

        return $warnings;
    }



    // ------------------------------------------------------------------------ //
    // -------------------search for trucks using any search filter ---------- //
    // ------------------------------------------------------------------------ //
    public function searchTrucks()
    {

        $filter = $this->prepareFilter();
        // call the core search
        $truck_qry = $this->_truckCore->searchTrucks(
            $filter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );


        // add any warning
        foreach ($truck_qry->data  as &$truckInfo) {
            // gert driver warning
            $warnings = $this->getTruckWarnings($truckInfo);
            if ($warnings) {
                $truckInfo->warnings = $warnings;
            } else {
                $truckInfo->warnings = null;
            }
        }

        parent::response($truck_qry);
    }

    private function prepareFilter()
    {
        $truckFilter = [];
        if ($this->_request->filter) {
            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {
                if ($value) {
                    if (strpos($value, ',') !== false) {
                        $valueArr = explode(",", $value);
                        $tempArr = ['key' => $key, 'val' => $valueArr, 'op' => 'in'];
                    } else {
                        $tempArr = ['key' => $key, 'val' => $value, 'op' => '='];
                    }
                    array_push($truckFilter, $tempArr);
                }
            }
        }


        return $truckFilter;
    }

    // --------------------------------------------------------------------------------------- //
    // ---------------------create new truck for indivusual/company -------------------------- //
    // --------------------------------------------------------------------------------------- //
    public function createTruck()
    {

        try {

            // in case the truck is registered from trucking company, exclude Minagate operation users from this validation
            if ($_SESSION['company_id'] && $_SESSION['company_id'] != 266770) {
                $this->_request->company_id = $_SESSION['company_id'];
            }

            if ($this->_request->user_id) {

                if ($this->_request->truck_id) {
                    $truckBean =  $this->_truckCore->getTruckBasic($this->_request->truck_id, $_SESSION['user_id']);
                } else {
                    $truckBean = $this->cleanTruckBean($this->_request);
                }

                // search for the user record localy using (user id)
                $searchFilter = [['key' => 'id', 'val' => $this->_request->user_id]];
                $userInfo = $this->_userCore->searchUser($searchFilter, 1, 0, 0);
                if ($userInfo->found_rows == 0) {
                    throw new Exception("TRUCK.INVALID_USER");
                }

                // in case the owner does not exist, create new truck_owner
                $userRecord = $userInfo->data[0];


                if (!$userRecord->truck_owner_id) {
                    $truckOwnerBean = new stdClass();
                    $truckOwnerBean->user_id = $this->_request->user_id;
                    $truckOwnerID = $this->_truckOwnerCore->createTruckOwner($truckOwnerBean, $_SESSION['user_id']);
                    // activate it
                    $this->_truckOwnerCore->activateTruckOwner($this->_request->user_id);
                } else {
                    $truckOwnerID = $userRecord->truck_owner_id;
                }

                $truckBean->nationality_code = 'JOR';

                // search for truck, to decide whether to create new record or not
                $truckFilter = [['key' => 'tn', 'val' => $truckBean->tn]];
                $truck_qry = $this->_truckCore->searchTrucks($truckFilter, 1, 0, $_SESSION['user_id']);

                // insert new truck if it is not exist
                if ($truck_qry->found_rows == 0) {
                    $truck_ID = $this->_truckCore->createTruck($truckBean, $truckOwnerID, $_SESSION['user_id']);
                } else {
                    // if the truck is INACTIVE, activate it
                    if ($truck_qry->data[0]->status == 'INACTIVE') {
                        $this->_truckCore->changeStatus($truck_qry->data[0]->id, "ACTIVE", $_SESSION['user_id']);

                        // update truck info
                        $truckBean->id = $truck_qry->data[0]->id;
                        $this->_truckCore->updateTruckInfo($truckBean, $truck_qry->data[0]->id, $_SESSION['user_id']);
                    }
                    $truck_ID = $truck_qry->data[0]->id;
                }

                // determine the contract_type (OWN,AUTH,JOIN,JV)
                if (trim($userRecord->name) == trim($truckBean->truck_owner_name)) {
                    $contract_type = 'OWN';
                } else {
                    $contract_type = 'AUTH';
                }


                // Create contract record and connect it with truckID and ownerID
                $truckContractBean = new stdClass();
                $truckContractBean->truck_owner_id = $truckOwnerID;
                $truckContractBean->truck_id = $truck_ID;
                $truckContractBean->contract_type = $contract_type;
                $truckContractBean->photos = $truckBean->contract_photo;

                $contract_id = $this->_truckContractCore->createTruckContract($truckContractBean, $_SESSION['user_id']);

                // send sms to truck owner to inform him about the new contract
                if ($contract_type == 'OWN') {
                    $messageBody = "تم انشاء عقد ملكية للشاحنة رقم " . $truckBean->tn;
                    $this->_truckCore->informTruckOwner($truck_ID, $messageBody);
                }
            } else if ($this->_request->company_id) {

                if ($this->_request->truck_id) {
                    $truckBean =  $this->_truckCore->getTruckBasic($this->_request->truck_id, $_SESSION['user_id']);
                } else {
                    $truckBean = $this->cleanTruckBean($this->_request);
                }

                // search for the company record localy using (company id)
                $searchFilter = [['key' => 'id', 'val' => $this->_request->company_id]];
                $companyInfo = $this->_companyCore->searchCompany($searchFilter, 1, 0, $_SESSION['user_id']);

                if ($companyInfo->found_rows == 0) {
                    throw new Exception("TRUCK.INVALID_COMPANY");
                }

                // in case the owner does not exist, create new truck_owner
                $ownerSearchFilter = [
                    ['key' => 'company_id', 'val' => $this->_request->company_id],
                    ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']
                ];
                $truckOwnerInfo = $this->_truckOwnerCore->searchTruckOwner($ownerSearchFilter, 1, 0, 0);


                if ($truckOwnerInfo->found_rows == 0) {
                    $truckOwnerBean = new stdClass();
                    $truckOwnerBean->company_id =  $this->_request->company_id;
                    $truckOwnerID = $this->_truckOwnerCore->createTruckOwner($truckOwnerBean, $_SESSION['user_id']);

                    // update the user truck_owner_id in user table
                    $userBean = new stdClass();
                    $userBean->truck_owner_id = $truckOwnerID;
                    $userBean->id = $_SESSION['user_id'];
                    $this->_userCore->updateUserInfo($userBean, $_SESSION['user_id'], 0);
                } else {
                    $truckOwnerID = $truckOwnerInfo->data[0]->id;
                    $truckOwnerName = $this->_request->truck_owner_name;
                    $truckBean->truck_owner_name = $truckOwnerName;
                }
                $truckBean->nationality_code = 'JOR';

                // check if the truck is new and does not exist in database
                $truckFilter = [['key' => 'tn', 'val' => $truckBean->tn]];
                $truck_qry = $this->_truckCore->searchTrucks($truckFilter, 1, 0, 0);

                if ($truck_qry->found_rows == 0) {
                    $truck_ID = $this->_truckCore->createTruck(
                        $truckBean,
                        $truckOwnerID,
                        $_SESSION['user_id']
                    );
                } else {
                    if ($truck_qry->data[0]->status == 'INACTIVE') {
                        $this->_truckCore->changeStatus($truck_qry->data[0]->id, "NEW", 0);
                    }
                    $truck_ID = $truck_qry->data[0]->id;
                }

                // determine the contract_type (OWN,JOIN)
                $truckBean =  $this->_truckCore->getTruckBasic($truck_ID, $_SESSION['user_id']);

                if ($this->_request->isowner) {
                    $contract_type = 'OWN';
                } else if (trim($companyInfo->data[0]->name) == trim($truckBean->truck_owner_name)) {
                    $contract_type = 'OWN';
                } else {
                    $contract_type = 'JOIN';
                }

                // Create contract record and connect it with truckID and ownerID
                $truckContractBean = new stdClass();
                $truckContractBean->truck_owner_id = $truckOwnerID;
                $truckContractBean->truck_id = $truck_ID;
                $truckContractBean->contract_type = $contract_type;
                $truckContractBean->photos = $truckBean->contract_photo;

                $createTruckContractResult = $this->_truckContractCore->createTruckContract($truckContractBean, $_SESSION['user_id']);
            }

            //return Success reponse
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "TRUCK.SUCCESS_CREATE";
            $Result['ID'] = $truck_ID;
            $Result['contract_id'] = $contract_id;
            $Result['truck_owner_id'] = $truckBean->truck_owner_id;
            parent::response($Result, 200);
        } catch (Exception $e) {
            throw $e;
        }
    }

    // ---------------------------------------------------------------- //
    // --------------------- update truck info ------------------------ //
    // ---------------------------------------------------------------- //
    public function updateTruckInfo()
    {

        // convert user input from JSON to Object 
        $truckBean = $this->cleanTruckBean($this->_request);

        // inject the images
        if ($this->_request->truck_license_photo) {
            $truck_license_photo = new stdClass();
            $truck_license_photo->url = $this->_request->truck_license_photo;
            $truck_license_photo->type = "truck_license_photo";
            $truckBean->photos[] = $truck_license_photo;
        }
        if ($this->_request->auth_photo) {
            $truck_auth_photo = new stdClass();
            $truck_auth_photo->url = $this->_request->auth_photo;
            $truck_auth_photo->type = "auth_photo";
            $truckBean->photos[] = $truck_auth_photo;
        }

        //validate update truck
        $this->_truckCore->validateForUpdate($truckBean, $this->_request->truck_id, $_SESSION['user_id']);

        // update the truck info
        $this->_truckCore->updateTruckInfo($truckBean, $this->_request->truck_id, $_SESSION['user_id']);

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "TRUCK.SUCCESSFUL_UPDATE";
        parent::response($Result);
    }



    // ------------------------------------------------------------------------------ //
    // --------------Clear the request and form it to be a valid truck bean --------- //
    // ------------------------------------------------------------------------------ //
    private function cleanTruckBean($request)
    {

        $truckBean = $request;

        // loop on truckBean and remove any empty string
        foreach ($truckBean as $key => $value) {
            if ($value == "") {
                unset($truckBean->{$key});
            }
        }

        $truckBean->photos = [
            ['type' => 'truck_license_photo', 'url' => $request->truck_license_photo]
        ];

        $truckBean->contract_photo = [
            ['type' => 'auth_photo', 'url' => $request->auth_photo]
        ];

        return $truckBean;
    }


    // ------------------------------------------------------------------------- //
    // ---------------------create new Anoymous Truck  -------------------------- //
    // -------------------------------------------------------------------------- //
    public function createAnoymousTruck()
    {


        $this->_request->mobile = convertToInternational($this->_request->mobile);

        $this->_truckCore->createAnoymousTruck($this->_request, $truckOwnerID,  $_SESSION['user_id']);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "TRUCK.SUCCESS_CREATE";
        parent::response($Result);
    }


    // ---------------------------------------------------------------------------------------------- //
    // ---------------------get the truck dashboard for mobile (my profile screen) ------------------ //
    // ---------------------------------------------------------------------------------------------- //
    public function getTruckMobileDashboard()
    {

        $_truckContractCore = new TruckContractCore();

        $Result['OWNED_TRUCKS'] = $_truckContractCore->searchTruckContracts(
            [['key' => 'contract_type', 'val' => "OWN"]],
            1000,
            $this->_request->offset,
            $_SESSION['user_id']
        )->found_rows;
        $Result['CONTRACT_TRUCKS'] = $_truckContractCore->searchTruckContracts(
            [['key' => 'contract_type', 'val' => "CONTRACT"]],
            1000,
            $this->_request->offset,
            $_SESSION['user_id']
        )->found_rows;

        parent::response($Result, 200);
    }

    // ------------------------------------------------------------------ //
    // --------------------- activate/Deactivate truck ------------------ //
    // ------------------------------------------------------------------ //
    public function changeStatus()
    {

        // deactivate the truck and its contract
        $this->_truckCore->changeStatus($this->_request->truck_id, $this->_request->new_status, $_SESSION['user_id']);

        // write remarks if exist
        if ($this->_request->remarks != null) {
            $addNoteCore = new Add_notes_core();
            $addNoteCore->addNotes('truck', $this->_request->truck_id, $this->_request->remarks, $_SESSION['user_id']);
        }


        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "TRUCK.SUCCESSFUL_ACTIVATE";
        parent::response($Result);
    }

    // ------------------------------------------------------------------ //
    // --------------------- update  ------------------ //
    // ------------------------------------------------------------------ //
    public function processTruckDocument()
    {
        // Get poll data
        $pollId = $this->_request->poll_id;
        $answers = $this->_request->answers;
        $userId = $this->_request->user_id;
        $bindParams = $this->_request->bind_params;

        $answers = is_string($answers) ? json_decode($answers, true) : $answers;
        // Get image uri
        $imageQuestions = array_filter($answers, function ($answer) {
            return strpos($answer->value, "http") !== false;
        });
        // Get truck bean
        $tn = $bindParams->{'_$_TN_$_'};
        $truckFilter = [
            ['key' => 'tn', 'val' => $tn],
            ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in']
        ];
        $truckBean = $this->_truckCore->searchTrucks($truckFilter, 1, 0, 0)->data[0];
        // Get Poll bean and unset recipients node
        $poll = (new Poll())->getPoll($pollId);
        // Create Ticket
        $ticketData = [
            "type_code" => "TRUCK_DOCS",
            "priority" => 7,
            "title" => "معاملة تحديث وثائق المركبة",
            "senderName" => $truckBean->truck_owner_name ? $truckBean->truck_owner_name : "شخص غير معرف",
            "truck_id" => $truckBean->id,
            "user_id" => $userId,
            "company_id" => null,
            "body" => [
                "truck_id" => $truckBean->id,
                "user_id" => $userId,
                "tn" => $truckBean->tn,
                "type_code" => "TRUCK_DOCS",
                "poll" => $poll['details']
            ]
        ];
        $ticketFilters = new stdClass();
        $ticketFilters->ticket_type = "client";
        $ticketFilters->type_code = "TRUCK_DOCS";

        // Convert to stdClass objects
        $ticketData = json_decode(json_encode($ticketData));
        //die(json_encode($ticketData));//
        $ticket = $this->_customerCare->createTicket($ticketData, $ticketFilters);

        // Add replies with images
        foreach ($imageQuestions as $imageQuestion) {
            $id = $ticket['id'];
            $note = new stdClass();
            $note->body = "";
            $note->attachments = [$imageQuestion->value];
            $note->senderName = $truckBean->truck_owner_name ? $truckBean->truck_owner_name : "شخص غير معرف";
            // call to customer care system to create ticket
            $this->_customerCare->replyToTicket($id, $note);
        }


        parent::response($ticket);
        return;
    }
}


$truck_interface = new Truck_interface();
