<?php 

// import objects
require_once (dirname(__FILE__)."/../../includes/DBConnection.php");
require_once (dirname(__FILE__).'/../truck_owner/truck_owner_core.php');
require_once (dirname(__FILE__).'/../truck_contract/truck_contract_core.php');

require_once (dirname(__FILE__)."/../../includes/util.php");
require_once (dirname(__FILE__).'/../user/user_core.php');
require_once (dirname(__FILE__)."/../gateway/gateWay_core.php");
require_once (dirname(__FILE__)."/../../includes/Captions.php");

class TruckCore {

    private $_truckOwnerCore;
    private $_userCore;
    private $_truckContractCore;
     
    public function __construct(){
        DBConnection::getInstance();

        $this->_truckOwnerCore = new TruckOwnerCore();
        $this->_userCore = new UserCore();       
        $this->_gatewayCore = new GatewayCore(); 
        $this->_truckContractCore = new TruckContractCore();
    }

    // ------------------------------------------------------------------------ //
    // -------------------Create Truck bean and fill it from DB  ------------- //
    // ------------------------------------------------------------------------ //
    public function getTruckBasic($id,$user_id){

        $truckBean = DBConnection::getBasicObjectBean("truck",$id,$user_id);
        return $truckBean;
    }

    // ------------------------------------------------------------------------ //
    // -------------------Create Truck bean and fill it from DB  ------------- //
    // ------------------------------------------------------------------------ //
    public function getTruck($id,$user_id){
        
        $truckBean = DBConnection::getObjectBean("truck",$id,$user_id);
        return $truckBean;
    }

    // ------------------------------------------------------------------------ //
    // -------------------search for Trucks using any search filter ---------- //
    // ------------------------------------------------------------------------ //
    public function searchTrucks($searchFilter, $limit, $offset, $user_id){
        
        $searchTruckResult = DBConnection::searchDB("truck",$searchFilter, $limit, $offset,$user_id);
        return $searchTruckResult;
    }

 

    // ------------------------------------------------------------------------ //
    // ---------------------create new truck---------------------------------- //
    // ------------------------------------------------------------------------ //
    public function createTruck($truckBean,$truck_owner_id, $user_id){

        // set the truck owner id
        $truckBean->truck_owner_id = $truck_owner_id;

        // validatr user input
        $this->validateForCreate($truckBean,$user_id);
        
        // import needed objects
        $truckOwnerObj = new TruckOwnerCore();
        $userObj = new UserCore();
        $truckContractObj = new TruckContractCore();

        // validate the owner of the truck if exist
        $truckFilter = [['key'=>'id','val'=>$truckBean->truck_owner_id]];
        $truckOwner_qry = $truckOwnerObj->searchTruckOwner($truckFilter,1,0,0);
        $truckBean->nationality_code = 'JOR';

        if($truckOwner_qry->found_rows < 1 ){ 
            throw new Exception("TRUCK.OWNER_NOT_FOUND");
        }
 
        // Create Truck record in database  in case the TN is not exist
        $createTruckResult = DBConnection::insertDB("truck",$truckBean,$user_id);
        $truck_ID =  $createTruckResult[0]['@id'];
        return $truck_ID;
        
    }


    // ----------------------------------------------------------------------- //
    // ------------ Validate User input for create new truck ----------------- //
    // ----------------------------------------------------------------------- //
    function validateForCreate($truckBean,$user_id) {

        $truckFilter = [['key'=>'tn','val' =>$truckBean->tn],
                        ['key'=>'status','val' => ['NEW','ACTIVE'], 'op'=>'in']
                       ];
        $truckResult = $this->searchTrucks($truckFilter,1, 0, $user_id );

        if($truckResult->found_rows > 0 ){
            //validate if the truck has active contract with another individual
            $contractFilter = [['key'=>'truck_id','val' =>$truckResult->data[0]->id],
                               ['key'=>'status','val' => ['NEW','ACTIVE'], 'op'=>'in'],
                               ['key'=>'truck_owner_id','val' => [$truckBean->truck_owner_id] , 'op'=>'not in'],
                               ['key'=>'contract_type','val' =>['OWN','AUTH']]
                              ];

            $contract_qry = $this->_truckContractCore->searchTruckContracts($contractFilter,1, 0, $user_id );

            if($contract_qry->found_rows){
                throw new Exception("TRUCK.IS_OWNED_TO_ANOTHER_OWNER");
            }
        }

        $this->validateTT($truckBean);

        $validationRules =  $this->_gatewayCore->getResource("VALIDATION","truck");
        foreach($truckBean as $key=>$userInput){
            if($validationRules[$key]){
                $rule = $validationRules[$key];
                $validationResult = validateInput($userInput,$rule,'NEW');

                if($validationResult->error_message){
                    throw new Exception($validationResult->error_message);
                }
            }
        }
    }
 


    // ------------------------------------------------------------------------- //
    // ---------------------create new Anoymous Truck  -------------------------- //
    // -------------------------------------------------------------------------- //
    public function createAnoymousTruck($truckBean,$truck_owner_id, $user_id){

        // search for the user record localy using (phone)
        $searchFilter = [['key'=>'phone','val' =>  $truckBean->mobile ]];
        $searchUserResult = DBConnection::searchDB("user",$searchFilter,1,0,0);// 1= one record is enough , 0= start from the bigining , 0= System User 

        // in case the user does not exist create it
        if ($searchUserResult->found_rows == 0) {
            $userBean = new stdClass();
            $userBean->imei = 0;
            $userBean->sim = 0;
            $userBean->phone = $truckBean->mobile;
            $userBean->google_verified = false;
            $userBean->id_front_photo = $truckBean->id_front_photo;
            $userBean->id_back_photo = $truckBean->id_back_photo;

            $user_id =$this->_userCore->registerNewUser($userBean);

            $userBean->user_id = $user_id; 
        }else{
            // update user info
            $userBean = new stdClass();

            $userBean->id_front_photo = $truckBean->id_front_photo;
            $userBean->id_back_photo = $truckBean->id_back_photo   ;
            $userBean->user_id = $searchUserResult->data[0]->id;
            $this->_userCore->updateUserInfo($userBean,$user_id);
        }

        // in case the owner does not exist, create new truck_owner
        if(!$searchUserResult->data[0]->truck_owner_id) {
            $truckBean->user_id = $userBean->user_id;
         
            $truckOwnerID = $this->_truckOwnerCore->createTruckOwner($truckBean, $user_id);
        }else{ 
            $truckOwnerID = $searchUserResult->data[0]->truck_owner_id;
        }

        // create the truck and its images
        $truckBean->photos = [
                [type=>'license_front','url' => $truckBean->licence_front_photo],
                [type=>'license_back','url' => $truckBean->licence_back_photo],
                [type=>'truck_image','url' => $truckBean->truck_photo],
        ];
        
        $truckBean->contract_photo = [
            [type=>'auth_image','url' => $truckBean->auth_photo]
        ];
 
        $this->createTruck($truckBean, $truckOwnerID,  $_SESSION['user_id']);

    }

    // ------------------------------------------------------------------------------ //
    // --------------------- validate Update truck info in DB------------------------ //
    // ------------------------------------------------------------------------------ //
    function validateForUpdate($truckBean,$truck_id, $user_id){

        // check if the truck owner has OWN contract, then throw exception if user is trying to change owner name
        $contractFilter = [['key'=>'truck_id','val' =>$truck_id],
                           ['key'=>'status','val' => ['NEW','ACTIVE'], 'op'=>'in'],
                           ['key'=>'contract_type','val' => ['OWN'], 'op'=>'in']
                          ];
        $contract_qry = $this->_truckContractCore->searchTruckContracts($contractFilter,1, 0, $user_id );
        if($contract_qry->found_rows > 0){
            if(trim($contract_qry->data[0]->name) != trim($truckBean->truck_owner_name)){
                throw new Exception('لا تستطيع تغير اسم المالك الحالي ، حيث يوجد لديه عقد ملكية فعال');
            }
        }

        // check if the new owner name match any name of the AUTH contracts
        $contractFilter = [['key'=>'truck_id','val' =>$truck_id],
                           ['key'=>'status','val' => ['NEW','ACTIVE'], 'op'=>'in'],
                           ['key'=>'contract_type','val' => ['AUTH'], 'op'=>'in'],
                           ['key'=>'name','val' => $truckBean->truck_owner_name]
                          ];
        $contract_qry = $this->_truckContractCore->searchTruckContracts($contractFilter,1, 0, $user_id );
        if($contract_qry->found_rows > 0){
            throw new Exception('لا تستطيع تغير اسم المالك الحالي ، حيث ان اسم المالك الجديد يطابق احد عقود الوكالة، يجب الغاء عقد الوكالة اولا');
        }
    }

    // -------------------------------------------------------------------- //
    // --------------------- Update truck info in DB------------------------ //
    // -------------------------------------------------------------------- //
    function updateTruckInfo($truckBean,$truck_id, $updated_by){
 
        // get basic object bean without any activites
        $DB_Bean = DBConnection::getBasicObjectBean("truck",$truck_id,$updated_by);
    
         //update truck info only if the truck bean is different than DB bean
        if(compareObject($truckBean,$DB_Bean) == false) {

            // map all the new values into the DB_bean
            $truckBean = mapBeanToDBBean($truckBean,$DB_Bean);
          
            //re-validate the user input 
            //$this->validateForEdit($truckBean);
            
            // fill update struct and set the target user id
            $truckBean->id = $truck_id;
           
            DBConnection::updateDB("truck",$truckBean,$updated_by);

            // update contract bean
            $contractBean = new stdClass();
            $truckContractFilter = [['key'=>'truck_id','val' => $truckBean->id],['key'=>'contract_type','val' => 'AUTH'],['key'=>'status', 'val'=>'ACTIVE']];
            $contract_qry = $this->_truckContractCore->searchTruckContracts($truckContractFilter,1, 0, $updated_by );
            
            if($contract_qry->found_rows > 0){
               
                $contractBean->photos = $truckBean->contract_photo[0];
                $contractBean->id = $contract_qry->data[0]->id;

                $this->_truckContractCore->updateTruckContract($contractBean,$updated_by);
            }
            

        }

    }
    


    // ----------------------------------------------------------------------- //
    // ------------ Validate User input for update new truck ----------------- //
    // ----------------------------------------------------------------------- //
    function validateForEdit($truckBean) {

        $this->validateTT($truckBean);

    }


    // ------------------------------------------------------------------ //
    // --------------------- activate/deactivate truck ------------------ //
    // ------------------------------------------------------------------ //
    public function changeStatus($truck_id,$new_status,$user_id){

        $updateStruct = new stdClass();
        $updateStruct->id = $truck_id;
        $updateStruct->status = $new_status;

        // get basic object bean without any activites
        $truckBean = DBConnection::getBasicObjectBean("truck",$truck_id,$user_id);

        // map all the new values into the truckBean
        $truckBean->status = $new_status;

        //re-validate the user input
        //$this->validateForEdit($truckBean);
 
        // change the status
        DBConnection::updateDB("truck",$updateStruct,$user_id);

        // deactivate the truck contract as well
        $truckContractBean = new stdClass();
        $truckContractFilter = [['key'=>'truck_id','val' => $truck_id],['key'=>'contract_type','val' => ['AUTH','OWN'], 'op'=>'in' ]];
        $contract_qry = $this->_truckContractCore->searchTruckContracts($truckContractFilter,1, 0, $user_id );

        if($contract_qry->found_rows > 0){
            $this->_truckContractCore->changeStatus($contract_qry->data[0]->id, $new_status , $user_id);
        }
 
    }

    // ------------------------------------------------------------------ //
    // --------------------- clear Truck Owner id ----------------------- //
    // ------------------------------------------------------------------ //
    public function clearTruckOwner($truck_id, $user_id){
        $db_query = "update truck
                    set truck_owner_id = null, update_by=$user_id
                    where id = $truck_id";
        $result = DBConnection::runDatabaseQuery($db_query);
    }

    // ------------------------------------------------------------------------ //
    // --------------------- set Truck Owner id in case it is empty------------ //
    // ------------------------------------------------------------------------ //
    public function setTruckOwner($truck_id,$truck_owner_id,$user_id){

        // get truck bean
        $truckBean = $this->getTruckBasic($truck_id,$user_id);

        // update it in case it does not exist
        if(!$truckBean->truck_owner_id){
            $db_query = "update truck
                        set truck_owner_id = $truck_owner_id, update_by=0
                        where id = $truck_id";

            $result = DBConnection::runDatabaseQuery($db_query);
        }


    }


    // ------------------------------------------------------------------------------ //
    // --------------------------- Send SMS to truck owner -------------------------- //
    // ------------------------------------------------------------------------------ //
    public function informTruckOwner($truck_id, $messageBody){

        // check if sending SMS to owner is enabled
        $MINAGATE_CONFIG = $this->_gatewayCore->getResource("MINAGATE_CONFIG","");
        $MINAGATE_CONFIG = json_decode($MINAGATE_CONFIG);

        if($MINAGATE_CONFIG->inform_truck_owner_by_SMS){
            $truckContractFilter = [['key'=>'truck_id','val' =>$truck_id],
                                    ['key'=>'status','val' => ['NEW','ACTIVE'], 'op'=>'in'],
                                    ['key'=>'contract_type','val' => 'OWN']];

            $contract_qry = $this->_truckContractCore->searchTruckContracts($truckContractFilter,1, 0, 1);
            $messageRecipient = $contract_qry->data[0]->phone;

            $messageRecipient = convertToInternational($messageRecipient);
            $result = sendSMS($messageRecipient,$messageBody);
        }
    }


    // ------------------------------------------------------------------------------ //
    // --------------------------- Send SMS to truck owner -------------------------- //
    // ------------------------------------------------------------------------------ //
    public function validateTT($truckBean){

        $isValidTT = false;
        // validate TRUCK (رأس قاطر) registration
        if($truckBean->cat == 'TRUCK'){
            if($truckBean->tt == 920000){
                if($truckBean->minor_tt == 9) {
                    $isValidTT = true;
                }
            }
        }
 
        // validate SINGLE (سنجل) , TRAIL (مقطورة), TRAILE-HALF (نصف مقطورة) registration
        if($truckBean->cat == 'TRUCK-SINGLE' || $truckBean->cat == 'TRAIL' || $truckBean->cat == 'TRAIL-HALF'){
            if($truckBean->tt == 920100){ // حاويات
                if($truckBean->minor_tt == 101 || $truckBean->minor_tt == 102 || $truckBean->minor_tt == 103 ){
                    $isValidTT = true;
                }
            }

            if($truckBean->tt == 920200){ // بضائع
                if($truckBean->minor_tt == 201 || $truckBean->minor_tt == 203 || $truckBean->minor_tt == 204 ||
                   $truckBean->minor_tt == 205 || $truckBean->minor_tt == 206 || $truckBean->minor_tt == 207 ||
                   $truckBean->minor_tt == 208 || $truckBean->minor_tt == 209 || $truckBean->minor_tt == 210 ||
                   $truckBean->minor_tt == 211 || $truckBean->minor_tt == 213 || $truckBean->minor_tt == -1){
                        $isValidTT = true;
                }
            }
            if($truckBean->tt == 920300){ // مشتقات
                if($truckBean->minor_tt == 301 || $truckBean->minor_tt == 302 || $truckBean->minor_tt == 303 ){
                    $isValidTT = true;
                }
            }
        }
        if( !$isValidTT){
            throw new Exception("TRUCK.TRUCK_TT_AND_CAT_DOES_NOT_MATCH");
        }
    }


    // --------------------------------------------------------------------------------- //
    // --------------------- Get list of contacts for a certain truck ------------------ //
    // --------------------------------------------------------------------------------- //
    public function getTruckAvailableContacts($truck_id, $user_id){

        $truckContractFilter = [['key'=>'truck_id','val' => $truck_id],['key'=>'status','val' =>['INACTIVE'], 'op'=> 'not in']];
        $contract_qry = $this->_truckContractCore->searchTruckContracts($truckContractFilter,1000,0, $user_id);

        $result = [];
        foreach ($contract_qry->data  as $contractInfo) {
            $contractBean = new stdClass();
            $contractBean->truck_owner_id = $contractInfo->truck_owner_id;
            $contractBean->owner_name = $contractInfo->name;
            $contractBean->nn = $contractInfo->nn;
            $contractBean->phone = $contractInfo->phone;
            $contractBean->contract_type = $contractInfo->contract_type;

            if($contractInfo->phone)
                array_push($result,$contractBean);
        }

        return $result;
    }


    // ------------------------------------------------------------------------ //
    // -------------------Update truck photos  --------------------------------- //
    // ------------------------------------------------------------------------ //
    public function updateTruckPhoto($truckId, $imageURI, $imageType){
        // Get truck bean

        $truck = $this->getTruckBasic($truckId, 0);

        // Decode image uri
        $imageURI = urldecode($imageURI);
        // Get truck photos
        $photos = is_string($truck->photos) ? json_decode($truck->photos, true): $truck->photos;
        if(!$photos){
            $photos=[];
        }

        // Append new image node
        $photos[] = [
            "type" => $imageType,
            "url" => $imageURI
        ];

        // Update truck bean
        $truck->photos = $photos;
        $this->updateTruckInfo($truck, $truckId, 0);

        // Generate thumbnail
        $generateThumbnailURI="https://us-central1-waybill-system.cloudfunctions.net/generateThumb?imageURL=$imageURI";
        $generateThumbnailURI = urldecode($generateThumbnailURI);
        file_get_contents($generateThumbnailURI);

    }
}