<?php 
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
include('simple_html_dom.php');

class DVLD {

    public function __construct(){
        DBConnection::getInstance();
    }



    // gets cookies from DB if available and not older than x0 minutes, else, it creates new ones and saves them to DB
    private function getCookies(){
        
        $sql = 'SELECT * FROM waybill.dvld_cookies where create_date > DATE_SUB(NOW() , INTERVAL 60 MINUTE)';
        $getCookies = DBConnection::runDatabaseQuery($sql);
        
        if(true || !$getCookies){ //if session life is older than x minutes, then renew cookies
            // gets new cookies from DB and saves them to DB with new time stamp
            $this->saveFreshCookies();
            $getCookies = DBConnection::runDatabaseQuery('select * from dvld_cookies');

        }else{// just change time stamp on DB to renew session
            $this->refreshCookies();
        }

        $cookies = json_decode($getCookies[0]->cookies,1);
        return $cookies;
    }


    public function getPersonName($nn,$id_serial){
        $cookies = [];
        if (!ctype_digit($nn)){
            throw new Exception("Illegal NN.");
        }
        $id = explode("/", $id_serial);
        if (sizeof($id) != 2 || !ctype_digit($id[0]) || !ctype_digit($id[1])){
            throw new Exception("Illegal Serial.");
        }
        $id_serial = str_replace("/","%2F",$id_serial);

        // Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://www.dvld.gov.jo/dvldportal/faces/misc/jordanianReg');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
        curl_setopt($ch, CURLOPT_HEADER, 1);
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');

        $headers = array();
        $headers[] = 'User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:66.0) Gecko/20100101 Firefox/66.0';
        $headers[] = 'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8';
        $headers[] = 'Accept-Language: en-US,en;q=0.5';
        $headers[] = 'Connection: keep-alive';
        $headers[] = 'Upgrade-Insecure-Requests: 1';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close ($ch);



        preg_match_all('/Set-Cookie:\s*([^;]+)/', $result, $c);
        $c=implode('; ',$c[1]);
        preg_match_all('/_afrLoop=([0-9])([^\";]+)/', $result, $_afrLoop);


        $_afrLoop=$_afrLoop[0][0];
        $cookies['faces_cookies']= $c;
        
        // Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://www.dvld.gov.jo/dvldportal/faces/misc/jordanianReg?'.$_afrLoop.'&_afrWindowMode=0&_afrWindowId=null');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');

        $headers = array();
        $headers[] = 'User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:66.0) Gecko/20100101 Firefox/66.0';
        $headers[] = 'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8';
        $headers[] = 'Accept-Language: en-US,en;q=0.5';
        $headers[] = 'Connection: keep-alive';
        $headers[] = 'Cookie: '.$cookies['faces_cookies'];
        $headers[] = 'Upgrade-Insecure-Requests: 1';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close ($ch);

        preg_match_all('/_adf.ctrl-state=*([^\"]+)/', $result, $_adf);
        $_adf=$_adf[0][0];

        preg_match_all('/input type=\"hidden\" name=\"javax.faces.ViewState\" value=\"*([^\"]+)/', $result, $ViewState);
        $ViewState=$ViewState[1][0];

        $cookies['faces_adf']=$_adf;
        $cookies['faces_viewstate']=$ViewState;

        // Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://www.dvld.gov.jo/dvldportal/faces/oracle/webcenter/portalapp/pages/jordanianReg.jspx?'.$cookies['faces_adf']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "pt1:pt_s4:pt_it1=&pt1:pt_s4:pt_it2=&pt1:pt_it3=&pt1:r1:0:it1=".$nn."&pt1:r1:0:soc1=0&pt1:r1:0:it5=&pt1:r1:0:it6=&pt1:r1:0:soc2=0&pt1:r1:0:soc3=0&pt1:r1:0:it2=&pt1:r1:0:soc4=0&pt1:r1:0:it4=&pt1:r1:0:it3=&pt1:r1:0:inputText1=&org.apache.myfaces.trinidad.faces.FORM=f1&javax.faces.ViewState=".$cookies['faces_viewstate']."&event=pt1%3Ar1%3A0%3Ait1&event.pt1:r1:0:it1=%3Cm+xmlns%3D%22http%3A%2F%2Foracle.com%2FrichClient%2Fcomm%22%3E%3Ck+v%3D%22autoSubmit%22%3E%3Cb%3E1%3C%2Fb%3E%3C%2Fk%3E%3Ck+v%3D%22suppressMessageShow%22%3E%3Cs%3Etrue%3C%2Fs%3E%3C%2Fk%3E%3Ck+v%3D%22type%22%3E%3Cs%3EvalueChange%3C%2Fs%3E%3C%2Fk%3E%3C%2Fm%3E&oracle.adf.view.rich.PROCESS=pt1%3Ar1%3A0%3Ait1");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');

        $headers = array();
        $headers[] = 'User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:66.0) Gecko/20100101 Firefox/66.0';
        $headers[] = 'Accept: */*';
        $headers[] = 'Accept-Language: en-US,en;q=0.5';
        $headers[] = 'Content-Type: application/x-www-form-urlencoded; charset=UTF-8';
        $headers[] = 'Adf-Rich-Message: true';
        $headers[] = 'Connection: keep-alive';
        $headers[] = 'Cookie: '.$cookies['faces_cookies'];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close ($ch);


        // Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://www.dvld.gov.jo/dvldportal/faces/oracle/webcenter/portalapp/pages/jordanianReg.jspx?'.$cookies['faces_adf']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "pt1:pt_s4:pt_it1=&pt1:pt_s4:pt_it2=&pt1:pt_it3=&pt1:r1:0:it1=".$nn."&pt1:r1:0:soc1=1&pt1:r1:0:it5=&pt1:r1:0:it6=&pt1:r1:0:soc2=0&pt1:r1:0:soc3=0&pt1:r1:0:it2=&pt1:r1:0:soc4=0&pt1:r1:0:it4=&pt1:r1:0:it3=&pt1:r1:0:inputText1=&org.apache.myfaces.trinidad.faces.FORM=f1&javax.faces.ViewState=".$cookies['faces_viewstate']."&event=pt1%3Ar1%3A0%3Asoc1&event.pt1:r1:0:soc1=%3Cm+xmlns%3D%22http%3A%2F%2Foracle.com%2FrichClient%2Fcomm%22%3E%3Ck+v%3D%22autoSubmit%22%3E%3Cb%3E1%3C%2Fb%3E%3C%2Fk%3E%3Ck+v%3D%22suppressMessageShow%22%3E%3Cs%3Etrue%3C%2Fs%3E%3C%2Fk%3E%3Ck+v%3D%22type%22%3E%3Cs%3EvalueChange%3C%2Fs%3E%3C%2Fk%3E%3C%2Fm%3E&oracle.adf.view.rich.PROCESS=pt1%3Ar1%3A0%3Asoc1");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');

        $headers = array();
        $headers[] = 'User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:66.0) Gecko/20100101 Firefox/66.0';
        $headers[] = 'Accept: */*';
        $headers[] = 'Accept-Language: en-US,en;q=0.5';
        $headers[] = 'Content-Type: application/x-www-form-urlencoded; charset=UTF-8';
        $headers[] = 'Adf-Ads-Page-Id: 1';
        $headers[] = 'Adf-Rich-Message: true';
        $headers[] = 'Connection: keep-alive';
        $headers[] = 'Cookie: '.$cookies['faces_cookies'];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close ($ch);


        // Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://www.dvld.gov.jo/dvldportal/faces/oracle/webcenter/portalapp/pages/jordanianReg.jspx?'.$cookies['faces_adf']);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "pt1:pt_s4:pt_it1=&pt1:pt_s4:pt_it2=&pt1:pt_it3=&pt1:r1:0:it1=".$nn."&pt1:r1:0:soc1=1&pt1:r1:0:it5=".$id_serial."&pt1:r1:0:it6=&pt1:r1:0:soc2=0&pt1:r1:0:soc3=0&pt1:r1:0:it2=&pt1:r1:0:soc4=0&pt1:r1:0:it4=&pt1:r1:0:it3=&pt1:r1:0:inputText1=&org.apache.myfaces.trinidad.faces.FORM=f1&javax.faces.ViewState=".$cookies['faces_viewstate']."&event=pt1%3Ar1%3A0%3Ait5&event.pt1:r1:0:it5=%3Cm+xmlns%3D%22http%3A%2F%2Foracle.com%2FrichClient%2Fcomm%22%3E%3Ck+v%3D%22autoSubmit%22%3E%3Cb%3E1%3C%2Fb%3E%3C%2Fk%3E%3Ck+v%3D%22suppressMessageShow%22%3E%3Cs%3Etrue%3C%2Fs%3E%3C%2Fk%3E%3Ck+v%3D%22type%22%3E%3Cs%3EvalueChange%3C%2Fs%3E%3C%2Fk%3E%3C%2Fm%3E&oracle.adf.view.rich.PROCESS=pt1%3Ar1%3A0%3Ait5");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');

        $headers = array();
        $headers[] = 'User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:66.0) Gecko/20100101 Firefox/66.0';
        $headers[] = 'Accept: */*';
        $headers[] = 'Accept-Language: en-US,en;q=0.5';
        $headers[] = 'Content-Type: application/x-www-form-urlencoded; charset=UTF-8';
        $headers[] = 'Adf-Ads-Page-Id: 1';
        $headers[] = 'Adf-Rich-Message: true';
        $headers[] = 'Connection: keep-alive';
        $headers[] = 'Cookie: '.$cookies['faces_cookies'];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close ($ch);


        // Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://www.dvld.gov.jo/dvldportal/faces/oracle/webcenter/portalapp/pages/jordanianReg.jspx?'.$cookies['faces_adf']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "pt1:pt_s4:pt_it1=&pt1:pt_s4:pt_it2=&pt1:pt_it3=&pt1:r1:0:it1=".$nn."&pt1:r1:0:soc1=1&pt1:r1:0:it5=".$id_serial."&pt1:r1:0:it6=&pt1:r1:0:soc2=0&pt1:r1:0:soc3=0&pt1:r1:0:it2=&pt1:r1:0:soc4=0&pt1:r1:0:it4=&pt1:r1:0:it3=&pt1:r1:0:inputText1=&org.apache.myfaces.trinidad.faces.FORM=f1&javax.faces.ViewState=".$cookies['faces_viewstate']."&event=pt1%3Ar1%3A0%3Acb1&event.pt1:r1:0:cb1=%3Cm+xmlns%3D%22http%3A%2F%2Foracle.com%2FrichClient%2Fcomm%22%3E%3Ck+v%3D%22type%22%3E%3Cs%3Eaction%3C%2Fs%3E%3C%2Fk%3E%3C%2Fm%3E&oracle.adf.view.rich.PROCESS=pt1%3Ar1");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');

        $headers = array();
        $headers[] = 'User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:66.0) Gecko/20100101 Firefox/66.0';
        $headers[] = 'Accept: */*';
        $headers[] = 'Accept-Language: en-US,en;q=0.5';
        $headers[] = 'Content-Type: application/x-www-form-urlencoded; charset=UTF-8';
        $headers[] = 'Adf-Ads-Page-Id: 1';
        $headers[] = 'Adf-Rich-Message: true';
        $headers[] = 'Connection: keep-alive';
        $headers[] = 'Cookie: '.$cookies['faces_cookies'];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close ($ch);
        // remove un-needed details in HTML
        $tempHTML=substr($result,strpos($result,'<table><tr class="xnu" id="pt1:r1:0:plam4">')-1);
        $tempHTML=substr($tempHTML,1,strpos($tempHTML,']]></fragment><fragment><![CDATA[<span id="f1::postscript">'));

        // Ignore HTML Parse errors
        libxml_use_internal_errors(true);
        $html = str_get_html($tempHTML);
        $details=[];

        $details['first'] = $html->find('span[id=pt1:r1:0:inputText2::content]')[0]->innertext;
        $details['second'] = $html->find('span[id=pt1:r1:0:it8::content]')[0]->innertext;
        $details['third'] = $html->find('span[id=pt1:r1:0:it9::content]')[0]->innertext;
        $details['last'] = $html->find('span[id=pt1:r1:0:it10::content]')[0]->innertext;
        $details['fullName'] = $details['first'].' '.$details['second'].' '.$details['third'].' '.$details['last'];
        return $details;

    }

    // teturns truck details as object.
    public function getTruckDvldData($tn,$reg){
        $cookies = $this->getCookies();

        // Get truck details request
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://www.dvld.gov.jo/dvldportal/faces/oracle/webcenter/portalapp/pages/vehicleInquiryService.jspx?'.$cookies['truck_adf']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "pt1:pt_s4:pt_it1=&pt1:pt_s4:pt_it2=&pt1:pt_it3=&pt1:r1:0:s7:it1=".substr($tn,0,2)."&pt1:r1:0:s7:it2=".substr($tn,2)."&pt1:r1:0:s7:it4=".$reg."&org.apache.myfaces.trinidad.faces.FORM=f1&javax.faces.ViewState=".$cookies['truck_viewstate']."&oracle.adf.view.rich.RENDER=pt1%3Ar1&event=pt1%3Ar1%3A0%3As7%3AsearchBtn&event.pt1:r1:0:s7:searchBtn=%3Cm+xmlns%3D%22http%3A%2F%2Foracle.com%2FrichClient%2Fcomm%22%3E%3Ck+v%3D%22type%22%3E%3Cs%3Eaction%3C%2Fs%3E%3C%2Fk%3E%3C%2Fm%3E&oracle.adf.view.rich.PROCESS=pt1%3Ar1");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');

        $headers = array();
        $headers[] = 'User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:66.0) Gecko/20100101 Firefox/66.0';
        $headers[] = 'Accept: */*';
        $headers[] = 'Accept-Language: en-US,en;q=0.5';
        $headers[] = 'Content-Type: application/x-www-form-urlencoded; charset=UTF-8';
        $headers[] = 'Adf-Rich-Message: true';
        $headers[] = 'Connection: keep-alive';
        $headers[] = 'Cookie:'.$cookies['truck_cookies'];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close ($ch);

        // remove un-needed details in HTML
        $tempHTML=substr($result,strpos($result,'<div id="pt1:r1:0:pgl1"')-1);
        $tempHTML=substr($tempHTML,1,strpos($tempHTML,'<div class="xq3">'));
        // Ignore HTML Parse errors
        libxml_use_internal_errors(true);
        // Parse HTML to DOM object
        $html = str_get_html($tempHTML);
        $details=[];
        // Fill details object
        $details['color']=$html->find('span[id=pt1:r1:0:it7::content]')[0]->innertext;
        $details['make']=$html->find('span[id=pt1:r1:0:it5::content]')[0]->innertext;
        $details['model']=$html->find('span[id=pt1:r1:0:it13::content]')[0]->innertext;
        $details['axis']=null;
        $details['axial_weight']=null;
        $details['make_year']=$html->find('span[id=pt1:r1:0:it11::content]')[0]->innertext;
        $details['fuel_type']=$html->find('span[id=pt1:r1:0:it15::content]')[0]->innertext;
        $details['engine_size']=$html->find('span[id=pt1:r1:0:it24::content]')[0]->innertext;
        $details['reg_fees']=$html->find('span[id=pt1:r1:0:it8::content]')[0]->innertext;
        $details['chasis_num']=$html->find('span[id=pt1:r1:0:it23::content]')[0]->innertext;
        $details['reg_expiry']=$html->find('span[id=pt1:r1:0:it6::content]')[0]->innertext;
        $details['truck_owner_name']=$html->find('span[id=pt1:r1:0:it14::content]')[0]->innertext;


        // Clear Form Request
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://www.dvld.gov.jo/dvldportal/faces/oracle/webcenter/portalapp/pages/vehicleInquiryService.jspx?'.$cookies['truck_adf']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, "pt1:pt_s4:pt_it1=&pt1:pt_s4:pt_it2=&pt1:pt_it3=&org.apache.myfaces.trinidad.faces.FORM=f1&javax.faces.ViewState=".$cookies['truck_viewstate']."&oracle.adf.view.rich.RENDER=pt1%3Ar1&event=pt1%3Ar1%3A0%3As7%3AcleanBtn&event.pt1:r1:0:s7:cleanBtn=%3Cm+xmlns%3D%22http%3A%2F%2Foracle.com%2FrichClient%2Fcomm%22%3E%3Ck+v%3D%22type%22%3E%3Cs%3Eaction%3C%2Fs%3E%3C%2Fk%3E%3C%2Fm%3E&oracle.adf.view.rich.PROCESS=pt1%3Ar1");
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');

        $headers = array();
        $headers[] = 'User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:66.0) Gecko/20100101 Firefox/66.0';
        $headers[] = 'Accept: */*';
        $headers[] = 'Accept-Language: en-US,en;q=0.5';
        $headers[] = 'Content-Type: application/x-www-form-urlencoded; charset=UTF-8';
        $headers[] = 'Adf-Ads-Page-Id: 1';
        $headers[] = 'Adf-Rich-Message: true';
        $headers[] = 'Connection: keep-alive';
        $headers[] = 'Cookie: '.$cookies['truck_cookies'];
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close ($ch);
        
        return $details;
    }

    private function getFreshCookies(){
        // cookies object to be saved to the server
        $c=[];


        // Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://www.dvld.gov.jo/dvldportal/faces/oracle/webcenter/portalapp/pages/vehicleInquiryService.jspx');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');

        curl_setopt($ch, CURLOPT_VERBOSE, 1);
        curl_setopt($ch, CURLOPT_HEADER, 1);

        $headers = array();
        $headers[] = 'Connection: keep-alive';
        $headers[] = 'Upgrade-Insecure-Requests: 1';
        $headers[] = 'User-Agent: Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.75 Safari/537.36';
        $headers[] = 'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,image/apng,*/*;q=0.8,application/signed-exchange;v=b3';
        $headers[] = 'Accept-Encoding: gzip, deflate, br';
        $headers[] = 'Accept-Language: en-US,en;q=0.9,ar;q=0.8';

        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }

        curl_close ($ch);

        preg_match_all('/Set-Cookie:\s*([^;]+)/', $result, $Cookies);
        $Cookies=implode('; ',$Cookies[1]);
        preg_match_all('/_afrLoop=([0-9])([^\";]+)/', $result, $_afrLoop);


        $_afrLoop=$_afrLoop[0][0];

        $c['truck_cookies']=$Cookies;

        // Generated by curl-to-PHP: http://incarnate.github.io/curl-to-php/
        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://www.dvld.gov.jo/dvldportal/faces/oracle/webcenter/portalapp/pages/vehicleInquiryService.jspx?'.$_afrLoop.'&_afrWindowMode=0&_afrWindowId=null');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');

        curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');

        $headers = array();
        $headers[] = 'User-Agent: Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:66.0) Gecko/20100101 Firefox/66.0';
        $headers[] = 'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8';
        $headers[] = 'Accept-Language: en-US,en;q=0.5';
        $headers[] = 'Connection: keep-alive';
        $headers[] = 'Cookie: '.$Cookies;
        $headers[] = 'Upgrade-Insecure-Requests: 1';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        if (curl_errno($ch)) {
            echo 'Error:' . curl_error($ch);
        }
        curl_close ($ch);

        preg_match_all('/_adf.ctrl-state=*([^\"]+)/', $result, $_adf);
        $_adf=$_adf[0][0];

        preg_match_all('/input type=\"hidden\" name=\"javax.faces.ViewState\" value=\"*([^\"]+)/', $result, $ViewState);
        $ViewState=$ViewState[1][0];

        $c['truck_adf']=$_adf;
        $c['truck_viewstate']=$ViewState;

        return $c;
    }

    private function saveFreshCookies(){
        $c = json_encode($this->getFreshCookies());
        DBConnection::runDatabaseQuery("update dvld_cookies set cookies='".$c."' ");
    }
    private function refreshCookies(){
        DBConnection::runDatabaseQuery("update dvld_cookies set cookies=cookies");
    }    
}