<?php

// import required classes
require_once(dirname(__FILE__) . "/../API.php");


class TenderVoucher extends API
{
    // the request of each call
    private $_request = array();

    public function __construct()
    {
        // call the super constructur
        $this->_request = parent::__construct();
        // validate the session
        session_start();
        if (!isset($_SESSION['user_id'])) {
            //throw new Exception("NO_SESSION", 1);
        }

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // ---------------------------------------------------------------------------- //
    // ---------------- get voucher templates for tender -------------------------- //
    // ---------------------------------------------------------------------------- //
    public function getVoucherTemplatesForTender()
    {
        $tender_id = $this->_request->tender_id;
        $q = 'select id,
        tender_id,
        voucher_type_code,
        CAST(`trx_template` AS CHAR CHARSET UTF8) AS trx_template,
        create_date,
        status,
        update_by,
        update_date,
        version 
        from tender_voucher_type
        where tender_id = ?
        and status ="active"';
        $params = [$tender_id];

        $result = DBConnection::runBindDatabaseQuery($q, $params);

        $r['data'] = $result;
        parent::response($r);
    }

    // ---------------------------------------------------------------------------- //
    // ---------------- get voucher Templates ------------------------------------- //
    // ---------------------------------------------------------------------------- //
    public function getVoucherTemplates()
    {
        $q = 'select 
                code,
                name,
                description,
                CAST(`amount_calculation_method` AS CHAR CHARSET UTF8) AS amount_calculation_method ,
                CAST(`trx_templates` AS CHAR CHARSET UTF8) AS trx_templates,
                CAST(`commission` AS CHAR CHARSET UTF8 ) as commission,
                status
            from voucher_type';
        $result = DBConnection::runDatabaseQuery($q);
        parent::response($result);
    }


    // --------------------------------------------------------------------------------------------- //
    // ---------------- create new voucher template for tender ------------------------------------- //
    // --------------------------------------------------------------------------------------------- //
    public function createTenderVoucher()
    {
        $tender_id = $this->_request->tender_id;
        $tender_voucher = $this->_request->tender_voucher;

        //query
        $insertSql = "INSERT INTO `waybill`.`tender_voucher_type` (`tender_id`, `voucher_type_code`, `trx_template`, `status`,`update_by`,`version`) VALUES
                                                       (?, ?, ?, ?,?,?)";
        $param = [
            $tender_id,
            $tender_voucher->code,
            json_encode($tender_voucher, JSON_UNESCAPED_UNICODE),
            "ACTIVE",
            $_SESSION['u_id'],
            1
        ];
        DBConnection::runBindDatabaseQuery($insertSql, $param);

        $Result['message'] = 'success';
        parent::response($Result);
    }


    // ---------------------------------------------------------------------------- //
    // ---------------- update tender voucher ------------------------------------- //
    // ---------------------------------------------------------------------------- //
    public function updateTenderVoucher()
    {
        $id = $this->_request->id;
        $tender_voucher = $this->_request->tender_voucher;

        //query
        $insertSql = "UPDATE `waybill`.`tender_voucher_type` set  `trx_template` = ? where id = ?";
        $param = [json_encode($tender_voucher, JSON_UNESCAPED_UNICODE), $id];
        DBConnection::runBindDatabaseQuery($insertSql, $param);

        $Result['message'] = 'success';
        parent::response($Result);
    }

    // ---------------------------------------------------------------------------- //
    // ---------------- update tender voucher ------------------------------------- //
    // ---------------------------------------------------------------------------- //
    public function changeStatus()
    {
        $id = $this->_request->id;
        $newStatus = $this->_request->newStatus;

        //query
        $insertSql = "UPDATE `waybill`.`tender_voucher_type` set  `status` = ? where id = ?";
        $param = [$newStatus, $id];
        DBConnection::runBindDatabaseQuery($insertSql, $param);

        $Result['message'] = 'success';
        parent::response($Result);
    }
}

new TenderVoucher();
