<?php
require_once (dirname(__FILE__)."/../API.php");
require_once (dirname(__FILE__)."/tender_driver_core.php");
require_once (dirname(__FILE__)."/../../includes/util.php");
require_once (dirname(__FILE__)."/../../core/tender/tender_core.php");
require_once (dirname(__FILE__)."/../../core/driver/driver_core.php");
require_once (dirname(__FILE__)."/../../core/user/user_core.php");


class Tender_driver_interface extends API{
    // the request of each call
    private $_request = array();
    private $_tenderDriverCore;
    private $_tenderCore;
    private $_driverCore;
    private $_userCore;

    public function __construct(){
        
        // call the super constructur
        $this->_request = parent::__construct();
        session_start();    
        if( !isset($_SESSION['user_id'])){
            throw new Exception('No Session!');
        }

        // init the object
        $this->_tenderDriverCore = new TenderDriverCore();
        $this->_tenderCore = new TenderCore();
        $this->_driverCore = new DriverCore();
        $this->_userCore = new UserCore();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }


    // ----------------------------------------------------------------- //
    // ------------ get certain tender driver by id -------------------- //
    // ----------------------------------------------------------------- //
    public function getTenderDriver(){

        // get tender driver bean
        $tenderDriverResult = $this->_tenderDriverCore->getTenderDriver($this->_request->id,$_SESSION['user_id']);       
        $tenderDriverSearchResult= $this->_tenderDriverCore->searchTenderDriver([['key'=>'id','val'=> $this->_request->id]],1, 0,  $_SESSION['user_id']  );
        $driverResult = $this->_driverCore->searchDriver([['key'=>'id','val'=> $tenderDriverSearchResult->data[0]->driver_id]],1, 0,  $_SESSION['user_id']  );
        $userResult = $this->_userCore->searchUser([['key'=>'driver_id','val' =>$tenderDriverSearchResult->data[0]->driver_id],['key'=>'status','val' =>'ACTIVE']],1, 0,  $_SESSION['user_id']  );

        // merge from tender driver view
        $tenderDriverBean = new stdClass();
        $tenderDriverBean= (object) array_merge((array) json_decode($tenderDriverResult), (array) $tenderDriverSearchResult->data[0]);
        $tenderDriverBean->personal_photo = $userResult->data[0]->photos;

        parent::response($tenderDriverBean);
    }


    // --------------------------------------------------------------------------- //
    // ------------------------ Prepare Search Filter ---------------------------- //
    // --------------------------------------------------------------------------- //
    private function prepareFilter(){
        $routeWageFilter = [];
        if($this->_request->filter){
            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {
                $tempArr = ['key'=>$key,'val' => $value];
                array_push($routeWageFilter,$tempArr);
            }
        }
        return $routeWageFilter;
    }

    // --------------------------------------------------------------- //
    // ----------------Search for a list of tender drivers ----------- //
    // --------------------------------------------------------------- //
    public function searchTenderDriver(){

        $tenderDriverFilter = $this->prepareFilter();

        $tenderDriverReuslt = $this->_tenderDriverCore->searchTenderDriver($tenderDriverFilter,
                                                                        $this->_request->limit,
                                                                        $this->_request->offset,
                                                                        $_SESSION['user_id']);

        //return response
        parent::response($tenderDriverReuslt);

    }

    // ------------------------------------------------------------------------------------- //
    // ----------------Search for a applicable tenders that allow tender drivers ----------- //
    // ------------------------------------------------------------------------------------- //
    public function searchApplicableTender(){

        $activeTenderStatus = DBConnection::getActiveStatus('tender');
        $tenderFilter = [['key'=>'status', 'val' => $activeTenderStatus , 'op'=>'in']];
        $tenderReuslt = $this->_tenderCore->searchTender($tenderFilter,100,0,$_SESSION['user_id']);

        $result = [];
        foreach ($tenderReuslt->data as $tender) {
            $man = json_decode($tender->manifest);
            if($man->tender_driver){
                if($man->tender_driver->is_required == true){
                    $temp = new stdClass();
                    $temp->id = $tender->id;
                    $temp->name = $tender->tender_name;
                    $result[] = $temp;
                }               
            }
        }

        //return response
        $Result=[];
        $Result['data'] = $result;
        $Result['found_rows'] = sizeof($result);
        parent::response($Result);

    }

    // ----------------------------------------------------------- //
    // ----------- Add new tender driver into database ----------- //
    // ----------------------------------------------------------- //
    public function create(){

        $driver_id = $this->_request->driver_id;
        $tender_id = $this->_request->tender_id;
        $tender_driver_id = $this->_tenderDriverCore->create($driver_id ,$tender_id , $_SESSION['user_id']);

        $autoAction = getAutoAction('TENDER_DRIVER','NEW','ACTIVE',$_SESSION['user_id'],$_SESSION['u_id']);
        if($autoAction){
            $this->_tenderDriverCore->activateTenderDriver($tender_driver_id, $_SESSION['user_id']);
        }

        $Result=[];
        $Result['ERRORCODE'] = '0';
        $Result['MESSAGE'] = 'WAYBILL.SUCCESS_OPERATION';
        parent::response($Result);
    }

    // ------------------------------------------------------------ //
    // --------------- Activate or deactivate any driver ---------- //
    // ------------------------------------------------------------ //
    public function changeStatus(){

        $id = $this->_request->id;
        $new_status = $this->_request->new_status;
        $remarks = $this->_request->remarks;

        if($new_status == 'ACTIVE'){
            $this->_tenderDriverCore->activateTenderDriver($id , $_SESSION['user_id']);
        }
        else if($new_status == 'INACTIVE'){
            $this->_tenderDriverCore->deactivateTenderDriver($id , $_SESSION['user_id']);
        }
        else if($new_status == 'PENDING'){
            $this->_tenderDriverCore->blackListTenderDriver($id , $_SESSION['user_id']);
            $this->_tenderDriverCore->addNotes($id , $remarks , $_SESSION['user_id']);
        }

        $Result=[];
        $Result['ERRORCODE'] = '0';
        $Result['MESSAGE'] = 'WAYBILL.SUCCESS_OPERATION';
        parent::response($Result);

    }

    // ---------------------------------------------------------- //
    // --------------- add remarks on a certain driver ---------- //
    // ---------------------------------------------------------- //
    public function addNotes(){
        // parse params
        $id = $this->_request->id;
        $notes = $this->_request->notes;

        // add remarks
        $this->_tenderDriverCore->addNotes($id , $notes , $_SESSION['user_id']);

        //return result
        $Result=[];
        $Result['ERRORCODE'] = '0';
        $Result['MESSAGE'] = 'WAYBILL.SUCCESS_OPERATION';
        parent::response($Result);

    }
}

new Tender_driver_interface();