<?php 

// import objects
require_once (dirname(__FILE__)."/../../includes/DBConnection.php");
require_once (dirname(__FILE__)."/../../includes/util.php");
require_once (dirname(__FILE__)."/../../core/driver/driver_core.php");
require_once (dirname(__FILE__)."/../../core/tender/tender_core.php");
require_once (dirname(__FILE__)."/../../core/user/user_core.php");


class TenderDriverCore {

    public function __construct(){
        DBConnection::getInstance();
    }

    // ----------------------------------------------------------------- //
    // ------------ get certain tender driver by id -------------------- //
    // ----------------------------------------------------------------- //
    public function getTenderDriver($id,$user_id){
        $tenderDriver = DBConnection::getObjectBean("tender_driver",$id,$user_id);
        return $tenderDriver;
    }


    // --------------------------------------------------------------------------------- //
    // --------------- get tender driver bean from database without activities --------- //
    // --------------------------------------------------------------------------------- //
    public function getTenderDriverBasic($id,$user_id){
        $tenderDriver = DBConnection::getBasicObjectBean("tender_driver",$id,$user_id);
        return $tenderDriver;
    }

    // --------------------------------------------------------------- //
    // ----------------Search for a list of tender drivers ----------- //
    // --------------------------------------------------------------- //
    public function searchTenderDriver($searchFilter, $limit, $offset,$user_id){
        $searchDriverResult = DBConnection::searchDB("tender_driver",$searchFilter,$limit,$offset,$user_id);
        return $searchDriverResult;
    }

    // ----------------------------------------------------------- //
    // ----------- Add new tender driver into database ----------- //
    // ----------------------------------------------------------- //
    public function create($driver_id ,$tender_id, $user_id){

        // prepare variables
        $tender_driver_bean = new stdClass();
        $tender_driver_bean->driver_id = $driver_id;
        $tender_driver_bean->tender_id = $tender_id;
        $tender_driver_bean->notes = [];
        $tender_driver_bean->status = "NEW";

        // validate if tender driver can be inserted into database
        $this->validateTenderDriverForCreate($tender_driver_bean);

        // insert into database
        $createTenderDriverResult = DBConnection::insertDB("tender_driver",$tender_driver_bean,$user_id);
        $tender_driver_id = $createTenderDriverResult[0]['@id'];

        return $tender_driver_id;
    }

    // --------------------------------------------------------------------------- //
    // -------- validate if tender driver can be inserted into database ---------- //
    // --------------------------------------------------------------------------- //
    public function validateTenderDriverForCreate($tender_driver_bean){
        $driverCore = new DriverCore();
        $tenderCore = new TenderCore();

        // validate driver
        $driverBean = $driverCore->getDriverBasic($tender_driver_bean->driver_id , 0);
        if(!$driverBean){throw new Exception("Driver is not registered");}
        if($driverBean->status == 'INACTIVE'){throw new Exception("Driver status is INVALID");}

        // validate tender
        $tenderBean = $tenderCore->getTenderBasic($tender_driver_bean->tender_id , 0);
        if(!$tenderBean){throw new Exception("tender is invalid");}

        // validate if the driver is already registered on the tender
        $tenderDriverFilter = [['key'=>'tender_id', 'val' => $tender_driver_bean->tender_id],
                               ['key'=>'driver_id', 'val' => $tender_driver_bean->driver_id],
                               ['key'=>'status','val' => ['INACTIVE'], 'op'=>'not in']];
        $tenderReuslt = $this->searchTenderDriver($tenderDriverFilter,1,0,0);
        if($tenderReuslt->found_rows > 0){
            throw new Exception("السائق مسجل مسبقا على المشروع");            
        }
        
    }


    // ------------------------------------------------------- //
    // ----------- activate certain tender driver  ----------- //
    // ------------------------------------------------------- //
    public function activateTenderDriver($tender_driver_id, $user_id){

        // change tender driver status
        $updateBean = new stdClass();
        $updateBean->id = $tender_driver_id;
        $updateBean->status = "ACTIVE";
        DBConnection::updateDB("tender_driver",$updateBean,$user_id);

        $tenderDriverQry = $this->searchTenderDriver([['key'=>'id','val'=> $tender_driver_id]],1, 0, $user_id);
        $tenderDriverInfo = $tenderDriverQry->data[0];

        // post on driver wall 
        // $socialCore = new SocialCore();
        // $tender_name = json_decode($tenderDriverInfo->mnanifest)->tender_name;
        // $user_id = $tenderDriverInfo->user_id;
        // $title = "فك عن قائمة المنع";
        // $msg = "تم فك السائق " . $tenderDriverInfo->name . " عن قائمة المنع على مشروع " . $tender_name;
        // $socialCore->createWallEntry($user_id,$title,$msg);
        
    }



    // ----------------------------------------------------------------------------- //
    // ----------- deactivate tender driver (remove from the whole list) ----------- //
    // ----------------------------------------------------------------------------- //
    public function deactivateTenderDriver($tender_driver_id, $user_id){

        // change tender driver status
        $updateBean = new stdClass();
        $updateBean->id = $tender_driver_id;
        $updateBean->status = "INACTIVE";
        DBConnection::updateDB("tender_driver",$updateBean,$user_id);
    }

    // -------------------------------------------------------- //
    // ----------- add certain driver to black list ----------- //
    // -------------------------------------------------------- //
    public function blackListTenderDriver($tender_driver_id, $user_id){

        // import 
        $userCore = new UserCore();

        // change tender driver status
        $updateBean = new stdClass();
        $updateBean->id = $tender_driver_id;
        $updateBean->status = "PENDING";
        DBConnection::updateDB("tender_driver",$updateBean,$user_id);

        $tenderDriverQry = $this->searchTenderDriver([['key'=>'id','val'=> $tender_driver_id]],1, 0, $user_id);
        $tenderDriverInfo = $tenderDriverQry->data[0];

        // post on driver wall
        // $socialCore = new SocialCore();
        // $tender_name = json_decode($tenderDriverInfo->manifest)->name;
        // $user_id = $tenderDriverInfo->user_id;
        // $title = "اضافة على قائمة المنع";
        // $msg = "تمت اضافة السائق " . $tenderDriverInfo->name . " إلى قائمة المنع على مشروع " . $tender_name;
        // $socialCore->createWallEntry($user_id,$title,$msg);

        //send SMS
        // $userBean = $userCore->getUserBasic($user_id,0);
        // $messageRecipient = $userBean->phone;
        // $messageRecipient = convertToInternational($messageRecipient);
        // $messageBody = "تمت اضافتك على قائمة المنع على مشروع " . $tender_name;
        // $result = sendSMS($messageRecipient,$messageBody);

    }

    // ---------------------------------------------------------- //
    // --------------- add remarks on a certain driver ---------- //
    // ---------------------------------------------------------- //
    public function addNotes($tender_driver_id , $note , $user_id){

        $tenderDriverBean = $this->getTenderDriverBasic($tender_driver_id , $user_id);
        $notes = $tenderDriverBean->notes;
        if(!$notes){
            $notes = [];
        }

        // create new note object
        $noteObj = new stdClass();
        $noteObj->done_by = DBConnection::getUserIdFromSession($user_id);
        $noteObj->note = $note;
        $noteObj->created_at = DBConnection::getSystemDate();
        $notes[] = $noteObj;

        // change tender_driver notes
        $updateBean = new stdClass();
        $updateBean->id = $tender_driver_id;
        $updateBean->notes = $notes;
        DBConnection::updateDB("tender_driver",$updateBean,$user_id);
        
    }

    

}