<?php
require_once (dirname(__FILE__)."/../API.php");
require_once (dirname(__FILE__)."/tender_company_core.php");
require_once (dirname(__FILE__)."/../tender/tender_core.php");


class Tender_interface_interface extends API{
    // the request of each call
    private $_request = array();
    private $_tenderCompanyCore;
    private $_tenderCore;

    public function __construct(){

        // call the super constructur
        $this->_request = parent::__construct();

        session_start();    
        if( !isset($_SESSION['user_id'])){
            throw new Exception('No Session!');
        }

        // init the object
        $this->_tenderCompanyCore = new TenderCompanyCore();
        $this->_tenderCore = new TenderCore();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }


    // ---------------------------------------------------------------------------- //
    // --------------------- get bean for certain truck on queue ------------------- //
    // ----------------------------------------------------------------------------- //
    public function getTenderCompany(){

        $tenderCompanyBean = $this->_tenderCompanyCore->getTenderCompany($this->_request->id,$_SESSION['user_id']);
        parent::response($tenderCompanyBean);
    }


    // --------------------------------------------------------------------------- //
     // ------------------------ Prepare Search Filter --------------------------- //
     // -------------------------------------------------------------------------- //
    private function prepareFilter(){
        $tenderCompanyFilter = [];
        if($this->_request->filter){
            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {
                if($key == "name"){
                    $tempArr = ['key'=>$key,'val' => $value , 'op'=>'like'] ;
                }else{
                    $tempArr = ['key'=>$key,'val' => $value];                   
                }
                array_push($tenderCompanyFilter,$tempArr);               
            }
        }
        return $tenderCompanyFilter;
    }

    // ----------------------------------------------------------------------- //
    // --------------------- get list of tender companies  ------------------- //
    // ----------------------------------------------------------------------- //
    public function searchTenderCompany(){

        $tenderCompaniesFilter = $this->prepareFilter();
        if(!$this->_request->limit){
            $this->_request->limit = 250;
        }

        $tenderCompaniesReuslt = $this->_tenderCompanyCore->searchTenderCompany($tenderCompaniesFilter,
                                                      $this->_request->limit,
                                                      $this->_request->offset,
                                                      $_SESSION['user_id'],
                                                      ' order by id desc '
        );

        //return  response
        parent::response($tenderCompaniesReuslt);
    }

    // ----------------------------------------------------------------------------------------- //
    // --------------------- get list of tender companies for manual waybill ------------------- //
    // ----------------------------------------------------------------------------------------- //
    public function searchTenderCompanyForManualWaybill(){

        $tenderCompaniesFilter = $this->prepareFilter();
        $tenderCompaniesReuslt = $this->_tenderCompanyCore->searchTenderCompany($tenderCompaniesFilter,
                                                      $this->_request->limit,
                                                      $this->_request->offset,
                                                      $_SESSION['user_id']
        );

        // filter any company that has queue service
        $index = 0;
        $user_roles = explode(",", $_SESSION['USER_ROLES']);

        //filter any company that has MANUAL_DISPATCH service
        foreach ($tenderCompaniesReuslt->data as $tenderCompany) {
            $serviceList = json_decode($tenderCompany->service_list);
            $isCompanyEligible = $this->isCompanyEligibleForManualDispatch($serviceList,$user_roles);
            $tenderCompaniesReuslt->data[$index]->manifest = null;

            if(! $isCompanyEligible){
                unset($tenderCompaniesReuslt->data[$index]);
            }
            if($tenderCompany->status == "INACTIVE"){
                unset($tenderCompaniesReuslt->data[$index]);
            }
            $index++;
        }

        //for vessels projects, make ADEl as first company
        if($tenderCompaniesFilter && $tenderCompaniesFilter[0]['key'] == "tender_id" && $tenderCompaniesFilter[0]['val'] == 3){
            $index2 = 0;
            foreach ($tenderCompaniesReuslt->data as $tenderCompany) {
                if($tenderCompany->trucking_company_id == 395){
                    $adelObj = $tenderCompany;
                    unset($tenderCompaniesReuslt->data[$index2]);
                }
                $index2++;
            }

            // pre apend adel
            array_unshift($tenderCompaniesReuslt->data,$adelObj);
        }

        //return  response
        $tenderCompaniesReuslt->data = array_values($tenderCompaniesReuslt->data);
        parent::response($tenderCompaniesReuslt);
    }


    // ---------------------------------------------------------------------------------------------------------- //
    // ------------- Check if a certain company eligible for manual dispatch for a certain role  ---------------- //
    // ---------------------------------------------------------------------------------------------------------- //
    private function isCompanyEligibleForManualDispatch($companyServices, $userRoles){

        if($companyServices){
            foreach ($companyServices as $service) {
                // if the company has MANUAL DISPATCH then this company is eligible
                if($service->code == 'DISPATCH' && $service->type == 'MANUAL'){
                    return true;
                }

                // if the company has QUEUE DISPATCH then check for override roles
                else if($service->code == 'DISPATCH' && $service->type == 'QUEUE'){
                    $allowed_roles = $service->override_roles;
                    if($allowed_roles == "*") return true;

                    $allowed_roles_arr = explode(",", $allowed_roles);
                    foreach ($allowed_roles_arr as $role) {
                        if(in_array($role,$userRoles)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }




    // -------------------------------------------------------------------------------- //
    // -------------------- create new tender comapny --------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function createTenderCompany(){

        $tenderCompanyBean = $this->_request;

        $service_list = json_decode($tenderCompanyBean->service_list);
        foreach ($service_list as & $service) {
            if($service->code == "DISPATCH"){
                $service->type = "MANUAL";
            }
        }
        $tenderCompanyBean->service_list = json_encode($service_list,JSON_UNESCAPED_UNICODE);
        $id = $this->_tenderCompanyCore->createTenderCompany($tenderCompanyBean,$_SESSION['user_id']);

        // check if there is auto action to be done by the system
        $autoAction = getAutoAction('TENDER_COMPANY','NEW','ACTIVE',$_SESSION['user_id'],$_SESSION['u_id']);
        if($autoAction){
            $this->_tenderCompanyCore->changeStatus($id, $autoAction->object_new_status_code, $_SESSION['user_id']);
        }

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "TENDER_COMPANY.SUCCESS_CREATE";
        $Result['ID'] = $id;
        parent::response($Result,200);
    }

    // ---------------------------------------------------------------------- //
    // -------------------- change tender company status -------------------- //
    // ---------------------------------------------------------------------- //
    public function changeStatus(){

        // change tender company status
        $this->_tenderCompanyCore->changeStatus($this->_request->id, $this->_request->new_status, $_SESSION['user_id']);

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "TENDER_COMPANY.SUCCESSFUL_CHANGE_STATUS";
        parent::response($Result);
    }


    // ---------------------------------------------------------------------------- //
    // --------------------- update tender company info --------------------------- //
    // ---------------------------------------------------------------------------- //
    public function updateInfo(){

        $tenderCompanyBean = $this->_request;
        $tenderCompanyBean->photos = json_decode($this->_request->photos);

        $this->_tenderCompanyCore->updateInfo($tenderCompanyBean,
                                                $this->_request->id,
                                                $_SESSION['user_id']);

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "TENDER_COMPANY.SUCCESSFUL_UPDATE";
        parent::response($Result);

    }





}

$tender_interface_interface = new Tender_interface_interface();

