<?php 

// import objects
require_once (dirname(__FILE__)."/../../includes/DBConnection.php");
require_once (dirname(__FILE__)."/../../includes/util.php");


class TenderCompanyCore {
    
    public function __construct(){
        DBConnection::getInstance();
 
    }

    // -------------------------------------------------------------------------------- //
    // -------------------Create tender company bean and fill it from DB  ------------- //
    // -------------------------------------------------------------------------------- //
    public function getTenderCompany($id,$user_id){
        
        $tenderCompanyInfo = DBConnection::getObjectBean("tender_company",$id,$user_id);
        return $tenderCompanyInfo;
    }

    // ----------------------------------------------------------------------------------------------------------- //
    // -------------------Create basic tender company (without activities) bean and fill it from DB  ------------- //
    // ----------------------------------------------------------------------------------------------------------- //
    public function getTenderCompanyBasic($id,$user_id){

        $tenderCompanyInfo = DBConnection::getBasicObjectBean("tender_company",$id,$user_id);

        return $tenderCompanyInfo;
    }


    // ------------------------------------------------------------------------ //
    // -------------------search for tender company using any search filter ----------- //
    // ------------------------------------------------------------------------ //
    public function searchTenderCompany($searchFilter, $limit, $offset, $user_id , $order_by = null){

        $tenderCompanyResult = DBConnection::searchDB("tender_company",$searchFilter, $limit, $offset,$user_id , $order_by);
        return $tenderCompanyResult;
    }

    // ------------------------------------------------------------------------ //
    // -------------------create new tender company ------------------------- //
    // ------------------------------------------------------------------------ //
    public function createTenderCompany($tenderCompanyBean,  $user_id){

        //validate tenderCompanyBean
        //$this->validateTruckingCompanyForCreate($tenderCompanyBean,$user_id);

        unset($tenderCompanyBean->id);

        $createTenderCompanyResult = DBConnection::insertDB("tender_company",$tenderCompanyBean,$user_id);
        $tenderCompany_id =  $createTenderCompanyResult[0]['@id'];

        return $tenderCompany_id;
    }


    // ---------------------------------------------------------------------- //
    // -------------------- change tender company status -------------------- //
    // ---------------------------------------------------------------------- //
    public function changeStatus($tender_company_id,$new_status,$user_id){

        $updateStruct = new stdClass();
        $updateStruct->id = $tender_company_id;
        $updateStruct->status = $new_status;

        // change the status
        DBConnection::updateDB("tender_company",$updateStruct,$user_id);
    }


    // ---------------------------------------------------------------------- //
    // --------------------- Update trucking info in DB------------------------ //
    // ---------------------------------------------------------------------- //
    function updateInfo($tenderCompanyBean,$tender_company_id, $updated_by){

        // fill update struct and set the target user id
        $tenderCompanyBean->id = $tender_company_id;

        // remove any sensative data
        unset($tenderCompanyBean->tender_id);
        unset($tenderCompanyBean->q_id);
        unset($tenderCompanyBean->shareBalance);
        unset($tenderCompanyBean->trucking_company_id);

        // get basic object bean without any activites
        $DB_Bean = DBConnection::getBasicObjectBean("tender_company",$tender_company_id,$updated_by);

        //update driver info only if the driver bean is different than DB bean
        if(compareObject($tenderCompanyBean,$DB_Bean) == false) {

            // map all the new values into the DB_bean
            $tenderCompanyBean = mapBeanToDBBean($tenderCompanyBean,$DB_Bean);

            //re-validate the user input
            //$this->validateForEdit($driverBean);

            // fill update struct and set the target user id
            DBConnection::updateDB("tender_company",$tenderCompanyBean,$updated_by);
        }
    }

    // ----------------------------------------------------------------------------------- //
    // -------------------get the registered services for a certain comapny  ------------- //
    // ----------------------------------------------------------------------------------- //
    public function getTenderCompanyServices($trucking_company_id,$tender_id){

        // search for the services
        $tenderCompanyActiveStatus = DBConnection::getActiveStatus('tender_company');
        $queueSearchFilter = [['key'=>'trucking_company_id','val' =>$trucking_company_id],
                              ['key'=>'tender_id','val' =>$tender_id],
                              ['key'=>'status','val' =>$tenderCompanyActiveStatus , 'op' => 'in']];

        $tenderCompanyInfo = $this->searchTenderCompany($queueSearchFilter,null,0,0); // search by system
        if($tenderCompanyInfo->found_rows > 0){
            return json_decode($tenderCompanyInfo->data[0]->service_list);
        }else{
            return [];
        }
    }

    // -------------------------------------------------------------------------------------------------------------------------------- //
    // ------------------------ Check if company has payment service as part of its package for a certain tender ---------------------- //
    // -------------------------------------------------------------------------------------------------------------------------------- //
    public function hasPaymentService($tender_id, $company_id, $trucking_company_id){

        // init required objects
        $truckingCompanyCore = new TruckingCompanyCore();

        if ($tender_id == 11){
            $trucking_company_id = 71;
        }
        else{
        // Search for trucking company if company_id is provided
        if($company_id){
            $searchFilter = [['key'=>'company_id','val' => $company_id]];
            $tcResult = $truckingCompanyCore->searchTruckingCompany($searchFilter, 1, 0, 0); // search by system

            if($tcResult->found_rows){
                $trucking_company_id = $tcResult->data[0]->id;
            }else{
                throw new Exception("company is not defined as tender_company for this tender");
            }
        }
        }

        // get list of defined services for the company on a certain tender
        $service_list = $this->getTenderCompanyServices($trucking_company_id,$tender_id) ;
        if($service_list){
            foreach ($service_list as $service) {
                if($service->code == 'EPAYMENT') {
                    return true;
                }
            }
        }

        return false;
    }

}