<?php

// import required classes
require_once(dirname(__FILE__) . "/tender_claim_core.php");
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/../../includes/Captions.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/../../core/waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../../core/cargo/cargo_core.php");
require_once(dirname(__FILE__) . "/../../core/tender/tender_core.php");
require_once(dirname(__FILE__) . "/../../core/payment/payment_core.php");
require_once(dirname(__FILE__) . "/../../core/route_wage/route_wage_core.php");
require_once(dirname(__FILE__) . "/../../core/voucher/voucher_core.php");
require_once(dirname(__FILE__) . "/../../core/taskQueues/taskQueues_core.php");
require_once(dirname(__FILE__) . "/../../core/waybill_draft/waybill_draft_core.php");
require_once(dirname(__FILE__) . "/../../core/woq/woq_core.php");


class Claims_interface extends API
{
    // the request of each call
    private $_request = array();
    private $_tenderClaimCore;
    private $_waybillCore;
    private $_cargoCore;
    private $_tenderCore;
    private $_paymentCore;
    private $_routeWageCore;
    private $_voucherCore;
    private $_waybillDraft;
    private $_fps;
    private $woqCore;


    public function __construct()
    {
        // call the super constructur
        $this->_request = parent::__construct();
        // validate the session
        session_start();
        if (!isset($_SESSION['user_id'])) {
            //throw new Exception("NO_SESSION", 1);
        }

        // init the core objects
        $this->_tenderClaimCore = new TenderClaimCore();
        $this->_waybillCore = new WaybillCore();
        $this->_cargoCore = new CargoCore();
        $this->_tenderCore = new TenderCore();
        $this->_paymentCore = new PaymentCore();
        $this->_routeWageCore = new RouteWageCore();
        $this->_voucherCore = new VoucherCore();
        $this->_waybillDraft = new WaybillDraftCore();
        $this->_fps = new FPS();
        $this->_woqCore = new WoqCore();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }


    // --------------------------------------------------------------------------- //
    // --------------------- get single tender claim info ------------------------ //
    // --------------------------------------------------------------------------- //
    public function getTenderClaim()
    {

        $ids = $this->_tenderClaimCore->getTenderClaimAuthority($_SESSION, "id");
        if ($ids && !in_array($this->_request->id, $ids))
            throw new Exception("لا توجد لديك صلاحية لمشاهدة المطالبة");


        // get the claim info
        $tenderClaimBean = $this->_tenderClaimCore->getTenderClaimBasic($this->_request->id, $_SESSION['user_id']);

        $create_date = new DateTime($tenderClaimBean->create_date);
        $tenderClaimBean->create_date = $create_date->format('Y-m-d');
        $tenderClaimBean->tender_payable_name = $this->_tenderClaimCore->getTenderPayableName($tenderClaimBean->tender_payable_id);

        parent::response($tenderClaimBean);
    }
    // --------------------------------------------------------------------------- //
    // --------------------- get single tender claim items info ------------------------ //
    // --------------------------------------------------------------------------- //
    public function getTenderClaimItems()
    {

        // get params
        $tender_claim_id = $this->_request->id;
        $offset = $this->_request->offset ? $this->_request->offset : 0;
        $limit = $this->_request->limit ? $this->_request->limit : 15;

        $ids = $this->_tenderClaimCore->getTenderClaimAuthority($_SESSION, "id");
        if ($ids && !in_array($this->_request->id, $ids))
            throw new Exception("لا توجد لديك صلاحية لمشاهدة المطالبة");

        //get claim type
        $tenderClaimBean = $this->_tenderClaimCore->getTenderClaimBasic($this->_request->id, $_SESSION['user_id']);
        // get tenderClaim Items
        $tenderClaimItems = $this->_tenderClaimCore->getTenderClaimItems($tender_claim_id, $_SESSION['user_id'], $offset, $limit);

        // format items to be key => value
        if ($tenderClaimBean->claim_details->claim_type == 'voucher_claim') {
            $items = [];
            foreach ($tenderClaimItems as $record) {
                $temp = new stdClass();
                $temp->voucher_id = $record[0];
                $temp->from_account = $record[1];
                $temp->from_account_name = $record[2];
                $temp->target_account = $record[3];
                $temp->target_account_name = $record[4];
                $temp->amount = $record[5];
                $temp->status = $record[6];
                $temp->waybill_ref = $record[7];
                $items[] = $temp;
            }
        } else {
            foreach ($tenderClaimItems as &$claim_item) {
                if ($claim_item->previous_item_id) {
                    $previous_item = DBConnection::getBasicObjectBean("tender_claim_item", $claim_item->previous_item_id, 0);
                    $claim_item->previous_approved_freight = $previous_item->approved_freight;

                    if ($claim_item->requested_freight) {
                        foreach ($claim_item->requested_freight->deductions as $ded) {
                            if ($ded->name == "tc_commission") {
                                $claim_item->requested_freight->tc_commission = $ded->value;
                                break;
                            }
                        }

                        foreach ($claim_item->requested_freight->deductions as $ded) {
                            if ($ded->name == "tawabe") {
                                $claim_item->requested_freight->tawabe = $ded->value;
                                break;
                            }
                        }
                    }
                }
            }
            $items = $tenderClaimItems;
        }
        $result['data'] = $items;
        $result['found_rows'] = sizeOf($tenderClaimItems);

        parent::response($result);
    }

    // --------------------------------------------------------------------------- //
    // --------------------- search for tender claim items  ------------------------ //
    // --------------------------------------------------------------------------- //
    public function searchTenderClaimItems()
    {
        $itemFilter = $this->prepareFilter();

        $claimsItemsReuslt = $this->_tenderClaimCore->searchTenderClaimItems(
            $itemFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id'],
            ' order by id desc '
        );


        parent::response($claimsItemsReuslt);
    }



    // --------------------------------------------------------------------------- //
    // ------------------------ Prepare Search Filter ---------------------------- //
    // --------------------------------------------------------------------------- //
    private function prepareFilter()
    {
        $claimsFilter = [];
        if ($this->_request->filter) {
            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {

                if ($key == 'create_date_from') {
                    $tempArr = ['key' => 'create_date', 'val' => $value, 'op' => 'date greater than'];
                } else if ($key == 'create_date_to') {
                    $tempArr = ['key' => 'create_date', 'val' => $value, 'op' => 'date less than'];
                } else if ($key == 'ref_number') {
                    $tempArr = ['key' => 'claim_details', 'val' => $value, 'op' => 'json unquote', 'node' => '$.ref'];
                } else if ($key == 'claim_type') {
                    $tempArr = ['key' => 'claim_details', 'val' => "'$value'", 'op' => 'json unquote', 'node' => '$.claim_type'];
                } else if ($key == 'status' && strpos($value, ',') !== false) {
                    $tempArr = ['key' => 'status', 'val' => explode(",", $value), 'op' => 'in'];
                } else if ($key == 'policy_number') {

                    // if user input starts with 60, then it is tn else its policy number
                    if (substr($value, 0, 2) == "60") {
                        $itemFilter = [
                            ['key' => 'details', 'val' => $value, 'op' => 'json unquote', 'node' => '$.tn'],
                            ['key' => "status", 'val' => ["ACTIVE", "APPROVED"], "op" => "in"]
                        ];
                    } else {
                        $itemFilter = [
                            ['key' => 'details', 'val' => $value, 'op' => 'json unquote', 'node' => '$.ref_num'],
                            ['key' => "status", 'val' => ["ACTIVE", "APPROVED"], "op" => "in"]
                        ];
                    }

                    $items = $this->_tenderClaimCore->searchTenderClaimItems($itemFilter, 1000, 0, $_SESSION['user_id'], ' order by id desc ');
                    $tenderClaimIds = [];
                    foreach ($items->data as $i) {
                        $tenderClaimIds[] = $i->tender_claim_id;
                    }
                    $tempArr = ['key' => 'id', 'val' => $tenderClaimIds, 'op' => 'in'];
                } else {
                    $tempArr = ['key' => $key, 'val' => $value];
                }
                array_push($claimsFilter, $tempArr);
            }
        }

        return $claimsFilter;
    }


    // ------------------------------------------------------------------ //
    // --------------------- get list of claims ------------------------- //
    // ------------------------------------------------------------------ //
    public function searchTenderClaims()
    {

        $claimsFilter = $this->prepareFilter();
        $extraFilter = $this->_tenderClaimCore->getTenderClaimAuthority($_SESSION, "filter");
        if ($extraFilter)
            $claimsFilter[] = $extraFilter;

        $claimsReuslt = $this->_tenderClaimCore->searchTenderClaims(
            $claimsFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id'],
            ' order by id desc '
        );

        foreach ($claimsReuslt->data as &$claim) {
            if ($claim->waybill_details) {
                $waybill_details = json_decode($claim->waybill_details);
                $waybill_details->body = [];
                $claim->waybill_details = json_encode($waybill_details, JSON_UNESCAPED_UNICODE);
            }

            $claim->num_of_waybills = sizeOf($this->_tenderClaimCore->getTenderClaimItems($claim->id, $_SESSION['user_id']));
            $claim_details = json_decode($claim->claim_details);

            $claim->claim_type = $claim_details->claim_type;
            $create_date = new DateTime($claim->create_date);
            $claim->create_date = $create_date->format('Y-m-d');
        }

        //return response
        parent::response($claimsReuslt);
    }


    // ------------------------------------------------------------------------------------------ //
    // ------------------Create new tender claim which contains number of waybills -------------- //
    // -------------------- Param: ref_id, tender_company_id, waybill_ids ----------------------- //
    // ------------------------------------------------------------------------------------------ //
    public function createTenderClaim()
    {

        $tender_company_id = $this->_request->tender_company_id;
        $ref = $this->_request->ref_id;
        $claim_type = $this->_request->claim_type;
        $ca_id = $this->_request->ca_id;

        // prepare tender_claim bean
        $tenderClaimBean = new stdClass();
        $tenderClaimBean->ref = $ref;
        $tenderClaimBean->waybills = null;
        $tenderClaimBean->tender_company_id = $tender_company_id;
        $tenderClaimBean->claim_type = $claim_type;
        $tenderClaimBean->ca_id = $ca_id;
        $new_claim_id = $this->_tenderClaimCore->createTenderClaim($tenderClaimBean, $_SESSION['user_id']);

        // return result
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "TENDER_CLAIM.SUCCESSFUL_OPERATION";
        $Result['claim_id'] = $new_claim_id;
        parent::response($Result);
    }

    // ------------------------------------------------------------------------------------------ //
    // ------------------ update tender claim which allow the user to add/remove waybills ------- //
    // -------------------- Param: tender_claim_id, waybill_ids --------------------------------- //
    // ------------------------------------------------------------------------------------------ //
    public function updateTenderClaim()
    {

        $tender_claim_id = $this->_request->tender_claim_id;
        $waybills = $this->_request->waybills;
        if (gettype($waybills) != 'array') {
            $waybills = json_decode($this->_request->waybills);
        }

        // prepare tender_claim bean
        $tenderClaimBean = new stdClass();
        $tenderClaimBean->id = $tender_claim_id;
        $tenderClaimBean->waybills = $waybills;

        //$this->_tenderClaimCore->updateTenderClaim($tenderClaimBean, $_SESSION['user_id']);

        // return result
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "TENDER_CLAIM.SUCCESSFUL_OPERATION";
        parent::response($Result);
    }

    // -------------------------------------------------------------------- //
    // -------------------- Change status of a certain claim -------------- //
    // -------------------- Param: id, new_status ------------------------- //
    // -------------------------------------------------------------------- //
    public function changeStatus()
    {
        try {
            DBConnection::startTransaction();

            // get claim bean
            $tenderClaimBean = $this->_tenderClaimCore->getTenderClaimBasic($this->_request->id, $_SESSION['user_id']);

            // submit tender claim for review
            if ($tenderClaimBean->status == 'NEW' && $this->_request->new_status == "PENDING") {
                $this->_tenderClaimCore->submitTenderClaim($this->_request->id, $_SESSION['user_id']);
            }

            // return for data entry
            if ($tenderClaimBean->status == 'PENDING' && $this->_request->new_status == "NEW") {
                $this->_tenderClaimCore->changeStatus($this->_request->id, 'NEW', $_SESSION['user_id']);
            }

            // approve tender claim
            if ($tenderClaimBean->status == 'PENDING' && $this->_request->new_status == "APPROVED") {
                $this->_tenderClaimCore->approveTenderClaim($this->_request->id, $_SESSION['user_id']);
            }
            // revoke tender claim
            if ($this->_request->new_status == "INACTIVE") {
                $this->_tenderClaimCore->revokeTenderClaim($this->_request->id, $_SESSION['user_id']);
            }

            // complete tender claim
            if ($this->_request->new_status == "COMPLETE") {

                // save activation_date
                $sqlStatment = "update tender_claim set activation_date = now() , update_by= ? where id = ?  ";
                $param = [$_SESSION['u_id'], $this->_request->id];
                $result = DBConnection::runBindDatabaseQuery($sqlStatment, $param);

                $this->_tenderClaimCore->changeStatus($this->_request->id, 'COMPLETE', $_SESSION['user_id']);
            }

            // return it to pending
            if ($tenderClaimBean->status == 'APPROVED' && $this->_request->new_status == "PENDING") {
                $this->_tenderClaimCore->changeStatus($this->_request->id, 'PENDING', $_SESSION['user_id']);
            }

            DBConnection::commitTransaction();
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "TENDER_CLAIM.SUCCESSFUL_OPERATION";
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------------------------- //
    // ------------------- search for eligable waybills to be added to a tender claim ------------ //
    // ------------------------------------------------------------------------------------------- //
    public function searchTenderClaimsWaybills()
    {

        $filter = json_decode($this->_request->filter, true);

        // prepare search filters (create_date, loading_date, discharge_date, wn, cargo_id, trucking_company_id)
        $searchFilter = [];
        $searchFilter[] = ['key' => 'status', 'val' => 'COMPLETE'];  // available status

        if ($filter['tender_id']) {
            $searchFilter[] = ['key' => 'tender_id', 'val' => $filter['tender_id']];
        }
        if ($filter['trucking_company_id']) {
            $searchFilter[] = ['key' => 'trucking_company_id', 'val' => $filter['trucking_company_id']];
        }
        if ($filter['create_date_from']) {
            $searchFilter[] = ['key' => 'create_date', 'val' => $filter['create_date_from'], 'op' => 'date greater than'];
        }
        if ($filter['create_date_to']) {
            $searchFilter[] = ['key' => 'create_date', 'val' => $filter['create_date_to'], 'op' => 'date less than'];
        }
        if ($filter['loading_date_from']) {
            $searchFilter[] = ['key' => 'loading_date', 'val' => $filter['loading_date_from'], 'op' => 'date greater than'];
        }
        if ($filter['loading_date_to']) {
            $searchFilter[] = ['key' => 'loading_date', 'val' => $filter['loading_date_to'], 'op' => 'date less than'];
        }
        if ($filter['discharge_date_from']) {
            $searchFilter[] = ['key' => 'discharge_date', 'val' => $filter['discharge_date_from'], 'op' => 'date greater than'];
        }
        if ($filter['discharge_date_to']) {
            $searchFilter[] = ['key' => 'discharge_date', 'val' => $filter['discharge_date_to'], 'op' => 'date less than'];
        }
        if ($filter['wn']) {
            $searchFilter[] = ['key' => 'wn', 'val' => $filter['wn']];
        }
        if ($filter['cargo_id']) {
            $searchFilter[] = ['key' => 'document', 'val' => $filter['cargo_id'], 'op' => 'json', 'node' => '$.cargo[0].cargo_id'];
        }

        // search for waybills
        $waybillsResult = $this->_waybillCore->searchWaybills($searchFilter, 1000, 0, $_SESSION['user_id']);

        // loop on waybills and exclude any if it has tender_claim node
        $result = new stdClass();
        $data = [];
        foreach ($waybillsResult->data as $wbl_raw) {
            $doc = json_decode($wbl_raw->document);
            if (!$doc->tender_claim || !$doc->tender_claim->id) {

                $wbl = new stdClass();
                $wbl->id = $wbl_raw->id;
                $wbl->wn = $wbl_raw->wn;
                $wbl->tn = $wbl_raw->tn;
                $wbl->trn = $doc->carrier[0]->trailer->tn;
                $wbl->cargo_name = $doc->cargo[0]->cargo->name;
                if ($wbl->create_date) {
                    $wbl->create_date = new DateTime($wbl_raw->create_date);
                    $wbl->create_date = $wbl->create_date->format('Y-m-d');
                } else {
                    $wbl->create_date = null;
                }

                if ($doc->cargo[0]->weights->loading->time_stamp) {
                    $wbl->loading_date = new DateTime($doc->cargo[0]->weights->loading->time_stamp);
                    $wbl->loading_date = $wbl->loading_date->format('Y-m-d');
                } else {
                    $wbl->loading_date = null;
                }

                if ($doc->cargo[0]->weights->discharge->time_stamp) {
                    $wbl->discharge_date = new DateTime($doc->cargo[0]->weights->discharge->time_stamp);
                    $wbl->discharge_date = $wbl->discharge_date->format('Y-m-d');
                } else {
                    $wbl->discharge_date = null;
                }
                $wbl->loading_weight = $doc->cargo[0]->weights->loading->net_weight;
                $wbl->discharge_weight = $doc->cargo[0]->weights->discharge->net_weight;
                $wbl->base_amount =  $doc->freight->amount->base_amount;
                $data[] = $wbl;
            }
        }

        // return result
        $result->data = $data;
        $result->found_rows = sizeof($data);
        parent::response($result);
    }

    // -------------------------------------------------------------------------------- //
    // --------------- append new waybill to a certain tender claim ------------------- //
    // --------------  Parcreaam: tender_claim_id, waybill -------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function appendWaybillToTenderClaim()
    {
        try {

            DBConnection::startTransaction();
            // prpaer params
            $id = $this->_request->id;
            $waybill_id = $this->_request->waybill_id;
            $claim_loading_weight = $this->_request->claim_loading_weight;
            $claim_discharge_weight = $this->_request->claim_discharge_weight;
            $claim_loading_date = $this->_request->claim_loading_date;
            $claim_discharge_date = $this->_request->claim_discharge_date;
            $ref_num = $this->_request->ref_num;
            $destination_id = $this->_request->destination_id; //
            $late_fine = $this->_request->late_fine;
            $compensation = $this->_request->compensation;
            $absence_fine = $this->_request->absence_fine;
            $loss_fine = $this->_request->loss_fine;
            $claim_amount = $this->_request->claim_amount;
            $cargo_id = $this->_request->cargo_id;
            $tender_id = $this->_request->tender_id;
            $claim_origin_id = $this->_request->origin_id;
            $claim_discharge_arrive_date = $this->_request->claim_discharge_arrive_date;
            $tender_payable_id = $this->_request->tender_payable_id;


            if (!$destination_id) {
                throw new Exception("الرجاء اختيار الوجهة");
            }
            if (!$cargo_id) {
                throw new Exception("الرجاء اختيار الحمولة");
            }

            if ($tender_id) {
                $tenderBean = $this->_tenderCore->getTenderBasic($tender_id, 0);
                $freight_object = $tenderBean->manifest->freight->freight_object->code;
            } else {
                $freight_object = "waybill";
            }


            $waybill_info = new stdClass();
            $waybill_info->claim_discharge_arrive_date = $claim_discharge_arrive_date;
            $waybill_info->claim_origin_id = $claim_origin_id;
            $waybill_info->claim_origin_name = getLocationName($claim_origin_id);
            $waybill_info->waybill_id = $waybill_id;
            $waybill_info->claim_loading_date = $claim_loading_date;
            $waybill_info->claim_discharge_date = $claim_discharge_date;
            $waybill_info->claim_loading_weight = $claim_loading_weight;
            $waybill_info->claim_discharge_weight = $claim_discharge_weight;
            $waybill_info->ref_num = $ref_num;
            $waybill_info->claim_destination_id = $destination_id;
            $waybill_info->claim_destination_name = getLocationName($destination_id);
            $waybill_info->claim_cargo_id = $cargo_id;
            $cargoCore = new CargoCore();
            $waybill_info->claim_cargo_name = $cargoCore->getCargoBasic($cargo_id, 0)->name;
            $waybill_info->tender_payable_id = $tender_payable_id;


            // search for route wage
            if ($freight_object && $freight_object == "waybill_draft") {
                $waybillBean = $this->_waybillDraft->getWaybillDraft($waybill_id);
                $waybillBean->document =  json_decode($waybillBean->document);
                $waybillBean->destination_id = $destination_id;
            } else {
                $waybillBean = $this->_waybillCore->getWaybill($waybill_id, $_SESSION['user_id']);
                $waybillBean = json_decode($waybillBean);
            }

            if ($freight_object && $freight_object == "waybill") {

                // Compare if loading date is before create date
                $formated_claim_date    =  date_create($claim_loading_date);
                $formated_waybill_date  = date_create($waybillBean->create_date);

                $dateDiff = date_diff($formated_waybill_date, $formated_claim_date);
                if ($dateDiff->d > 0 && $dateDiff->invert > 0) {
                    throw new Exception('لا يمكنك المتابعة, تاريخ التحميل المدخل في المطالبة يجب ان يكون بعد تاريخ انشاء المستند');
                }
            }

            // search route wage
            $routeWage =  $this->_routeWageCore->searchWageForFreight(
                $waybillBean->tender_id,
                $claim_origin_id,
                $destination_id,
                $cargo_id,
                $claim_loading_date,
                'receivable',
                true,
                $waybillBean
            );
            // inject cargo weights and dates in waybill bean
            $waybillBean->document->cargo[0]->weights->loading->net_weight = $claim_loading_weight;
            $waybillBean->document->cargo[0]->weights->loading->time_stamp = $claim_loading_date;
            $waybillBean->document->cargo[0]->weights->discharge->net_weight = $claim_discharge_weight;
            $waybillBean->document->cargo[0]->weights->discharge->time_stamp = $claim_discharge_date;
            // calculate waybill claim amount

            $freight = $this->_paymentCore->calculateFreight($waybillBean, $claim_discharge_weight, $claim_loading_weight, $routeWage);

            //update fines
            // if ($claim_amount) {
            //$freight->amount->net_amount = $claim_amount;
            // }
            if ($late_fine) {
                $freight->amount->late_fine = $late_fine;
                $freight->amount->net_amount -= $late_fine;
            }
            if ($compensation) {
                $freight->amount->compensation = $compensation;
            }
            if ($absence_fine) {
                $freight->amount->absence_fine = $absence_fine;
            }
            if ($loss_fine) {
                $freight->amount->loss_fine = $loss_fine;
            }

            //total fine
            $freight->amount->total_fines = $freight->amount->loss_fine + $freight->amount->absence_fine  +  $freight->amount->late_fine;
            $waybill_info->freight = $freight;
            $waybill_info->freight->route_wage = $routeWage;

            // prepare tender_claim bean
            if ($freight_object && $freight_object == "waybill") {
                $this->_tenderClaimCore->appendWaybillToTenderClaim($id, $waybill_info, $_SESSION['u_id'], $_SESSION['user_id']);
            } else if ($freight_object && $freight_object == "waybill_draft") {
                $this->_tenderClaimCore->appendWaybillDraftToTenderClaim($id, $waybill_info, $_SESSION['u_id'], $_SESSION['user_id']);
            } else {
                throw new Exception("INVALID freight_object");
            }

            DBConnection::commitTransaction();

            // return result
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "TENDER_CLAIM.SUCCESSFUL_OPERATION";
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------------- //
    // --------------- append new voucher to a certain tender claim ------------------- //
    // --------------  Param: tender_claim_id, voucher -------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function appendVoucherToTenderClaim()
    {

        try {
            // prpaer params
            $id = $this->_request->id;
            $voucher_id = $this->_request->voucher_id;
            $from_account = $this->_request->from_account;
            $from_account_name = $this->_request->from_account_name;
            $target_account = $this->_request->target_account;
            $target_account_name = $this->_request->target_account_name;
            $amount = $this->_request->amount;
            $status = $this->_request->status;
            $waybill_ref = $this->_request->waybill_ref;

            $voucher_info = new stdClass();
            $voucher_info->voucher_id = $voucher_id;
            $voucher_info->from_account = $from_account;
            $voucher_info->from_account_name = $from_account_name;
            $voucher_info->target_account = $target_account;
            $voucher_info->target_account_name = $target_account_name;
            $voucher_info->amount = $amount;
            $voucher_info->status = $status;
            $voucher_info->waybill_ref = $waybill_ref;

            // prepare tender_claim bean
            $this->_tenderClaimCore->appendVoucherToTenderClaim($id, $voucher_info, $_SESSION['u_id'], $_SESSION['user_id']);

            // return result
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "TENDER_CLAIM.SUCCESSFUL_OPERATION";
            parent::response($Result);
        } catch (Exception $e) {

            throw new Exception($e->getMessage());
        }
    }


    // --------------------------------------------------------------------------------------------- //
    // --------- Search for Available claims to add new waybill , this method is used by PA -------- //
    // --------------------------------------------------------------------------------------------- //
    public function searchPaymentAgentAvailableClaims()
    {

        // search for NEW tender claims of type "AR_claim"
        $claimFilter = [];
        $claimFilter[] = ['key' => 'status', 'val' => 'NEW'];
        $claimFilter[] = ['key' => 'pa_id', 'val' => $this->_request->pa_id];
        $claimFilter[] = ['key' => 'claim_details', 'val' => "'AR_claim'", 'op' => 'json unquote', 'node' => "$.claim_type"];

        $claimsItemsReuslt = $this->_tenderClaimCore->searchTenderClaims($claimFilter, 100, 0, $_SESSION['user_id'], ' order by id desc ');

        $result = [];
        foreach ($claimsItemsReuslt->data as $claim) {
            $itemFilter = [];
            $itemFilter[] = ['key' => 'tender_claim_id', 'val' => $claim->id];
            $items = $this->_tenderClaimCore->searchTenderClaimItems($itemFilter, 1000, 0, $_SESSION['user_id'], ' order by id desc ');

            $obj = new stdClass();
            $obj->id = $claim->id;
            // $obj->cargo_id = json_decode($items->data[0]->details)->claim_cargo_id;
            // $obj->cargo_name = json_decode($items->data[0]->details)->claim_cargo_name;
            $obj->cargo_id = "";
            $obj->cargo_name = "";
            $obj->number_of_waybills = $items->found_rows;
            $result[] = $obj;
        }
        parent::response($result);
    }

    // ----------------------------------------------------------------------------------------- //
    // ------------------ auto complete the waybill info in update tender claim ---------------- //
    // ------------------ params: wn ----------------------------------------------------------- //
    // ----------------------------------------------------------------------------------------- //
    public function autoCompleteWaybillInfo()
    {
        // parse param
        $wn = $this->_request->wn;
        $ref_num = $this->_request->ref_num;
        $tender_claim_id = $this->_request->tender_claim_id;

        // get tender_claim bean
        $searchTenderClaimFilter = [['key' => 'id', 'val' => $tender_claim_id]];
        $tenderClaimBean = $this->_tenderClaimCore->searchTenderClaims($searchTenderClaimFilter, 1, 0, $_SESSION['user_id'], null)->data[0];
        $tender_id = $tenderClaimBean->tender_id;

        // get tender bean
        $tenderBean = $this->_tenderCore->getTenderBasic($tender_id, 0);
        $freight_object = $tenderBean->manifest->freight->freight_object->code;

        // search in waybill draft
        if ($freight_object && $freight_object == "waybill_draft") {
            $filter = ['bond_number' => $ref_num];
            $waybill_drafts = $this->_waybillDraft->searchWaybillDraft($filter, null, 10, 0, $_SESSION['u_id']);
            $draftResult = [];
            foreach ($waybill_drafts as $draft) {
                $result = new stdClass();
                $result->id = $draft->id;
                $result->tn = $draft->tn;
                $result->trn = $draft->trn;
                $result->create_date = $draft->create_date;
                $doc = json_decode($draft->document);
                $result->loading_weight = $doc->cargo[0]->weights->loading->net_weight;
                $loading_date = new DateTime($doc->cargo[0]->weights->loading->time_stamp);
                $result->loading_date = $loading_date->format('Y-m-d');
                $result->cargo_id = $doc->cargo[0]->cargo_id;
                $result->cargo_name = $doc->cargo[0]->name;
                $result->discharge_weight = $doc->cargo[0]->weights->discharge->net_weight;
                $discharge_date = new DateTime($doc->cargo[0]->weights->discharge->time_stamp);
                $result->discharge_date = $discharge_date->format('Y-m-d');
                $result->destination_name = $doc->negotiable_instructios->route->destination->name;
                $result->destination = $doc->negotiable_instructios->route->destination->name;
                $result->destination_id = $doc->negotiable_instructios->route->destination->id;
                $result->origin_name = $doc->negotiable_instructios->route->origin->name;
                $result->origin = $doc->negotiable_instructios->route->origin->name;
                $result->origin_id = $doc->negotiable_instructios->route->origin->id;
                $result->bond_number = $draft->bond_number;
                $result->ref_num = $draft->bond_number;
                $result->ref = $draft->bond_number;
                $result->wn = $draft->bond_number;
                $draftResult[] = $result;
            }
            // return result
            parent::response($draftResult);
            die;
        }

        // search in waybill
        else {
            // first of all search in AR_claim
            if ($wn) {

                // search in waybill claim if exists
                $searchFilter = [
                    ['key' => 'details', 'val' => $wn, 'op' => 'json unquote', 'node' => '$.wn'],
                    ['key' => 'status', 'val' => 'ACTIVE'],
                    ['key' => 'details', 'val' => '"waybill_claim"', 'op' => 'json unquote', 'node' => '$.claim_type'],
                ];
                $tenderClaimItems = $this->_tenderClaimCore->searchTenderClaimItems($searchFilter, 1, 0, $_SESSION['user_id'], null);

                // search in AR_claim  if not found
                if ($tenderClaimItems->found_rows == 0) {
                    $searchFilter = [
                        ['key' => 'details', 'val' => $wn, 'op' => 'json unquote', 'node' => '$.wn'],
                        ['key' => 'status', 'val' => 'ACTIVE'],
                        ['key' => 'details', 'val' => '"AR_claim"', 'op' => 'json unquote', 'node' => '$.claim_type'],
                    ];
                    $tenderClaimItems = $this->_tenderClaimCore->searchTenderClaimItems($searchFilter, 1, 0, $_SESSION['user_id'], null);
                }
            } else if ($ref_num) {

                // search in waybill claim if exists
                $searchFilter = [
                    ['key' => 'details', 'val' => $ref_num, 'op' => 'json unquote', 'node' => '$.ref_num'],
                    ['key' => 'status', 'val' => 'ACTIVE'],
                    ['key' => 'details', 'val' => '"waybill_claim"', 'op' => 'json unquote', 'node' => '$.claim_type'],
                ];
                $tenderClaimItems = $this->_tenderClaimCore->searchTenderClaimItems($searchFilter, 1, 0, $_SESSION['user_id'], null);

                if ($tenderClaimItems->found_rows == 0) {
                    // search in AR_claim  if not found
                    $searchFilter = [
                        ['key' => 'details', 'val' => $ref_num, 'op' => 'json unquote', 'node' => '$.ref_num'],
                        ['key' => 'status', 'val' => 'ACTIVE'],
                        ['key' => 'details', 'val' => '"AR_claim"', 'op' => 'json unquote', 'node' => '$.claim_type'],
                    ];
                    $tenderClaimItems = $this->_tenderClaimCore->searchTenderClaimItems($searchFilter, 1, 0, $_SESSION['user_id'], null);
                }
            }
            if (sizeof($tenderClaimItems->data) > 0) {
                $this->returnItemResponse($tenderClaimItems);
            }

            // search for waybill bean
            if ($wn) {
                $searchFilter = [['key' => 'wn', 'val' => $wn]];
            }
            // search for waybills
            if ($ref_num) {
                $searchFilter = [
                    ['key' => 'document', 'val' => $ref_num, 'op' => 'json unquote', 'node' => '$.integeration_details.jo_petrol.nfldnm'],
                    ['key' => 'tender_id', 'val' => 11]
                ];
            }
            $waybillsResult = $this->_waybillCore->searchWaybills($searchFilter, 1, 0, $_SESSION['user_id']);
            if ($waybillsResult->found_rows == 0 && $ref_num) {
                $searchFilter = [['key' => 'document', 'val' => $ref_num, 'op' => 'json unquote', 'node' => '$.integeration_details.jo_petrol.jo_petrol_policy_num']];
                $waybillsResult = $this->_waybillCore->searchWaybills($searchFilter, 1, 0, $_SESSION['user_id']);
            }

            $waybillBean = $waybillsResult->data[0];

            // check if waybill is used in another claim
            $doc = json_decode($waybillBean->document);

            // clean the data
            $result = new stdClass();
            $result->id = $waybillBean->id;
            $result->tn = $doc->carrier[0]->truck->tn;
            $result->trn = $doc->carrier[0]->trailer->tn;
            $result->create_date = $waybillBean->create_date;
            $result->loading_weight = $doc->cargo[0]->weights->loading->net_weight;
            $loading_date = new DateTime($doc->cargo[0]->weights->loading->time_stamp);
            $result->loading_date = $loading_date->format('Y-m-d');
            $result->cargo_id = $doc->cargo[0]->cargo_id;
            $result->cargo_name = $doc->cargo[0]->name;
            $result->discharge_weight = $doc->cargo[0]->weights->discharge->net_weight;
            $discharge_date = new DateTime($doc->cargo[0]->weights->discharge->time_stamp);
            $result->discharge_date = $discharge_date->format('Y-m-d');
            $result->destination_name = $doc->negotiable_instructios->route->destination->name;
            $result->destination_id = $doc->negotiable_instructios->route->destination->id;
            $result->origin_name = $doc->negotiable_instructios->route->origin->name;
            $result->origin = $doc->negotiable_instructios->route->origin->name;
            $result->origin_id = $doc->negotiable_instructios->route->origin->id;
            // return result
            parent::response([$result]);
        }
    }


    // ----------------------------------------------------------------------------------------- //
    // ------------------ auto complete the waybill info in update tender claim ---------------- //
    // ------------------ params: wn ----------------------------------------------------------- //
    // ----------------------------------------------------------------------------------------- //
    public function auditWaybillClaim()
    {

        // parse param
        $wn = $this->_request->wn;
        $ref_num = $this->_request->ref_num;
        $tn = $this->_request->tn;
        $tender_claim_id = $this->_request->tender_claim_id;

        // first of all search in AR_claim
        $searchFilter = [
            ['key' => 'status', 'val' => ['ACTIVE', 'COMPLETE'], "op" => "in"],
            ['key' => 'tender_claim_id', 'val' => $tender_claim_id],
        ];

        // search for waybill bean
        if ($wn) {
            $searchFilter[] = ['key' => 'details', 'val' => $wn, 'op' => 'json unquote', 'node' => '$.wn'];
        }
        // search for waybills
        if ($ref_num) {
            $searchFilter[] = ['key' => 'details', 'val' => $ref_num, 'op' => 'json unquote', 'node' => '$.ref_num'];;
        }

        // search for waybills
        if ($tn) {
            $searchFilter[] = ['key' => 'details', 'val' => $tn, 'op' => 'json unquote', 'node' => '$.tn'];;
        }

        $tenderClaimItems = $this->_tenderClaimCore->searchTenderClaimItems($searchFilter, 1, 0, $_SESSION['user_id'], null);
        if (sizeof($tenderClaimItems->data) > 0) {
            $item = $tenderClaimItems->data[0];
            $doc = json_decode($item->details);
            $freight = json_decode($item->requested_freight);
            // clean the data
            $result = new stdClass();
            $result->id = $item->waybill_id;
            $result->tn = $doc->tn;
            $result->trn = $doc->trn;
            $result->loading_weight = $doc->claim_loading_weight;
            if ($doc->claim_loading_date) {
                try {
                    $loading_date = new DateTime($doc->claim_loading_date);
                    $result->loading_date = $loading_date->format('Y-m-d h:m');
                } catch (Exception $e) {
                }
            }
            $result->cargo_id = $doc->cargo_id;
            $result->cargo_name = $doc->cargo_name;
            $result->discharge_weight = $doc->claim_discharge_weight;
            if ($doc->claim_discharge_date) {
                try {
                    $discharge_date = new DateTime($doc->claim_discharge_date);
                    $result->discharge_date = $discharge_date->format('Y-m-d h:m');
                } catch (Exception $e) {
                }
            }
            if ($doc->claim_discharge_arrive_date) {
                try {
                    $arrival_date = new DateTime($doc->claim_discharge_arrive_date);
                    $result->arrival_date = $arrival_date->format('Y-m-d h:m');
                } catch (Exception $e) {
                }
            }

            $result->destination_name = $doc->claim_destination_name;
            $result->destination_id = $doc->claim_destination_id;
            $result->ref_num = $doc->ref_num;
            $result->ref = $doc->ref_num;
            $result->user_freight = $freight;
            // return result
            parent::response($result);
            die;
        }
        // return result
        parent::response(null);
    }

    // ------------------------------------------------------------------------------------------------------------------------- //
    // ------------------ auto complete the waybill info in update tender claim ------------------------------------------------ //
    // ------------------ params: tn, tender_id, trucking_company_id ----------------------------------------------------------- //
    // ------------------------------------------------------------------------------------------------------------------------- //

    public function autoCompleteTruckInfo()
    {

        // parse param
        $tn = $this->_request->tn;
        $tender_id = $this->_request->tender_id;
        $trucking_company_id = $this->_request->trucking_company_id;

        $activeWaybillStatus = DBConnection::getActiveStatus('waybill');
        $activeWaybillStatus[] = 'CLOSED';

        $searchFilter = [
            ['key' => 'tn', 'val' => $tn],
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'trucking_company_id', 'val' => $trucking_company_id],
            ['key' => 'status', 'val' => $activeWaybillStatus, 'op' => 'in']
        ];

        // search for waybills
        $waybillsResult = $this->_waybillCore->searchWaybills($searchFilter, 10, 0, $_SESSION['user_id']);
        $results = array();

        foreach ($waybillsResult->data as $waybillBean) {

            $doc = json_decode($waybillBean->document);
            // clean the data
            $waybill = new stdClass();
            $waybill->wn = $waybillBean->wn;
            $waybill->origin = $doc->negotiable_instructios->route->origin->name;
            $waybill->driver = $doc->carrier[0]->driver->name;
            $waybill->destination = $doc->negotiable_instructios->route->destination->name;
            $waybill->id = $waybillBean->id;
            $waybill->tn = $doc->carrier[0]->truck->tn;
            $waybill->trn = $doc->carrier[0]->trailer->tn;
            $waybill->create_date = $waybillBean->create_date;

            $waybill->loading_weight = $doc->cargo[0]->weights->loading->net_weight;
            $loading_date = new DateTime($waybillBean->loading_date);
            $waybill->loading_date = $loading_date->format('Y-m-d');

            $waybill->discharge_weight = $doc->cargo[0]->weights->discharge->net_weight;
            $discharge_date = new DateTime($waybillBean->discharge_date);
            $waybill->discharge_date = $discharge_date->format('Y-m-d');

            array_push($results, $waybill);
        }
        // return result
        parent::response($results);
    }

    // ------------------------------------------------------------------------------------------------------ //
    // ------------------ Generate cover letter for a certain tender_claim ---------------------------------- //
    // ------------------------------------------------------------------------------------------------------ //
    public function generateTenderClaimCover()
    {
        $id = $this->_request->id;

        $tenderClaimBean = $this->_tenderClaimCore->getTenderClaimBasic($id, $_SESSION['user_id']);

        // get tender claim summary
        $result = [];
        $result['amount'] = $tenderClaimBean->claim_details->amount;
        $result['waybills'] = 33; //TODO
        $result['company_name'] = $tenderClaimBean->claim_details->company_name;

        parent::response($result);
    }

    // -------------------------------------------------------------------------------------- //
    // ------------------ remove waybill from tender claim ---------------------------------- //
    // -------------------------------------------------------------------------------------- //
    public function removeWaybillFromTenderClaim()
    {
        try {
            DBConnection::startTransaction();
            // prepare input
            $tender_claim_id = $this->_request->id;
            $waybill_id = $this->_request->waybill_id;
            $waybill_draft_id = $this->_request->waybill_draft_id;

            if (!$tender_claim_id) throw new Exception("tender_claim_id is required");

            // get tender_claim bean
            $searchTenderClaimFilter = [['key' => 'id', 'val' => $tender_claim_id]];
            $tenderClaimBean = $this->_tenderClaimCore->searchTenderClaims($searchTenderClaimFilter, 1, 0, $_SESSION['user_id'], null)->data[0];
            $tender_id = $tenderClaimBean->tender_id;

            // get tender bean
            $tenderBean = $this->_tenderCore->getTenderBasic($tender_id, 0);
            $freight_object = $tenderBean->manifest->freight->freight_object->code;

            if ($freight_object == "waybill") {
                // remove certain waybill from tender_claim
                if (!$waybill_id) throw new Exception("waybill_id  is required");
                $this->_tenderClaimCore->removeWaybillFromTenderClaim($tender_claim_id, $waybill_id, $_SESSION['user_id']);
            } else {
                // remove certain waybill draft from tender_claim
                if (!$waybill_draft_id) throw new Exception("waybill_draft_id  is required");
                $this->_tenderClaimCore->removeWaybillDraftFromTenderClaim($tender_claim_id, $waybill_draft_id, $_SESSION['user_id']);
            }

            DBConnection::commitTransaction();
            // return result
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "TENDER_CLAIM.SUCCESSFUL_OPERATION";
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
        DBConnection::startTransaction();
    }

    // -------------------------------------------------------------------------------------- //
    // ------------------ revoke waybill from tender claim ---------------------------------- //
    // -------------------------------------------------------------------------------------- //
    public function revokeWaybillFromTenderClaim()
    {
        // prepare input
        $tender_claim_id = $this->_request->tender_claim_id;
        $tender_claim_item_id = $this->_request->tender_claim_item_id;
        $remarks = $this->_request->remarks;

        if (!$tender_claim_id) throw new Exception("tender_claim_id is required");
        if (!$tender_claim_item_id) throw new Exception("tender_claim_item_id  is required");

        //TODO make sure the claim is AR claim

        // remove certain waybill from tender_claim
        $this->_tenderClaimCore->revokeWaybillFromTenderClaim($tender_claim_id, $tender_claim_item_id, $remarks, $_SESSION['user_id']);

        // return result
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "TENDER_CLAIM.SUCCESSFUL_OPERATION";
        parent::response($Result);
    }


    // -------------------------------------------------------------------------------------- //
    // ------------------ remove voucher from tender claim ---------------------------------- //
    // -------------------------------------------------------------------------------------- //
    public function removeVoucherFromTenderClaim()
    {

        // prepare input
        $tender_claim_id = $this->_request->id;
        $voucher_id = $this->_request->voucher_id;

        // remove certain waybill from tender_claim
        $this->_tenderClaimCore->removeVoucherFromTenderClaim($tender_claim_id, $voucher_id, $_SESSION['user_id']);

        // return result
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "TENDER_CLAIM.SUCCESSFUL_OPERATION";
        parent::response($Result);
    }



    // -------------------------------------------------------------------------------------- //
    // ------------------ get vouchers report from tender claim ---------------------------------- //
    // -------------------------------------------------------------------------------------- //
    public function searchVouchersReport()
    {

        // prepare input
        $tender_claim_id = $this->_request->id;

        try {
            // get the claim info
            $vouchers = $this->_tenderClaimCore->getTenderClaimItems($tender_claim_id, $_SESSION['user_id']);
            $waybills = [];
            $list_of_waybills_id = [];

            // save ids of waybills
            foreach ($vouchers as $voucher) {
                $list_of_waybills_id[] = $voucher[7];
            }

            // prepare filter for search waybills
            $waybillFilter = [
                ['key' => 'id', 'val' => $list_of_waybills_id, 'op' => 'in']
            ];

            // get the list of waybills
            $waybill_qry = $this->_waybillCore->searchWaybills($waybillFilter, 10000, 0, $_SESSION['user_id'], null);

            if ($waybill_qry->found_rows > 0) {
                foreach ($waybill_qry->data as $waybill) {
                    if (in_array($waybill->id, $list_of_waybills_id)) {
                        $doc = json_decode($waybill->document);
                        $temp = new stdClass();
                        $temp->tn = $doc->carrier[0]->truck->tn;
                        $temp->trn = $doc->carrier[0]->trailer->tn;
                        $temp->carrier = $doc->carrier[0]->tc->name;
                        $temp->driver = $doc->carrier[0]->driver->name;
                        $temp->wn = $waybill->wn;

                        if (
                            $doc->integeration_details &&
                            $doc->integeration_details->jo_petrol &&
                            $doc->integeration_details->jo_petrol->nfldnm
                        ) {
                            $temp->policy_num = $doc->integeration_details->jo_petrol->nfldnm;
                        }
                        if (
                            $doc->integeration_details &&
                            $doc->integeration_details->jo_petrol &&
                            $doc->integeration_details->jo_petrol->nfy55dispn
                        ) {
                            $temp->discharge_permit_num = $doc->integeration_details->jo_petrol->nfy55dispn;
                        }

                        $temp->loading_weight = $doc->cargo[0]->weights->loading->net_weight;
                        $temp->discharge_weight = $doc->cargo[0]->weights->discharge->net_weight;
                        $temp->loading_date = $doc->cargo[0]->weights->loading->time_stamp;
                        $temp->discharge_date = $doc->cargo[0]->weights->discharge->time_stamp;
                        $temp->loss_in_kg = $doc->freight->amount->loss_in_kg;
                        $temp->total_fines = $doc->freight->amount->total_fines;
                        $temp->net_amount = $doc->freight->amount->net_amount;
                        $temp->base_amount = $doc->freight->amount->base_amount;
                        $temp->total_advance_payment = $doc->freight->amount->total_advance_payment;
                        $temp->total_deductions = $doc->freight->amount->total_deductions;
                        $temp->tolerance_in_kg = $doc->freight->amount->tolerance_in_kg;
                        $waybills[] = $temp;
                    }
                }
            }

            // return result
            parent::response($waybills);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------------------------------------- //
    // ------------------ search for vouchers to add to tender claim with policy num ------------------------- //
    // ------------------------------------------------------------------------------------------------------- //
    public function searchVoucherForTenderClaim()
    {
        $ref = $this->_request->ref_num;
        $resultVoucher = $this->_tenderClaimCore->searchVoucherForTenderClaim($ref);
        parent::response($resultVoucher);
    }

    // ------------------------------------------------------------------------------------------------------------------- //
    // --------------------- get a list of waybills on a certain tender claim on the remote server "JO_Petrol" ----------- //
    // ------------------------------------------------------------------------------------------------------------------- //
    public function searchClaimOnRemoteServer()
    {
        $claim_number = $this->_request->claim_number;

        $jo_petrol = new Jo_Petrol();
        $result = $jo_petrol->QueryOnClaimNumber($claim_number);

        // return result
        parent::response($result);
    }

    // ------------------------------------------------------------------------------- //
    // --------------------- get a tender claim covver letter for printing ----------- //
    // ------------------------------------------------------------------------------- //
    public function getTenderClaimCoverLetter()
    {
        // get user params
        $tender_claim_id = $this->_request->tender_claim_id;
        $create_date_month = $this->_request->create_date_month;

        // get tenderClaim bean
        $tenderClaimBean = $this->_tenderClaimCore->getTenderClaimBasic($tender_claim_id, $_SESSION['user_id']);

        // generate voucher claim cover letter
        if ($tenderClaimBean->claim_details->claim_type == 'voucher_claim') {

            // fill basic info for print
            $result = new stdClass();
            $result->tender_claim_number = $tenderClaimBean->claim_details->ref;
            if ($create_date_month) {
                $result->create_date_for_month = $create_date_month;
            } else {
                $result->create_date_for_month = date('m');
            }

            $tenderClaimItems = $this->_tenderClaimCore->getTenderClaimItems($tender_claim_id, $_SESSION['user_id']);
            $result->total_number = sizeOf($tenderClaimItems);
            $result->create_date =  date("Y-m-d");

            // get the waybill of each voucher to extract data from
            $waybill_ids = [];
            foreach ($tenderClaimItems as $voucherInfo) {
                $waybill_ids[] = $voucherInfo[7];
            }
            $waybillFilter = [['key' => 'id', 'val' => array_values($waybill_ids), 'op' => 'in']];
            $waybillsResult = $this->_waybillCore->searchWaybills($waybillFilter, 10000, 0, $_SESSION['user_id']);

            // extract info from waybill
            foreach ($waybillsResult->data as $wbl) {
                $doc = json_decode($wbl->document);
                $result->loading_weight += $doc->cargo[0]->weights->loading->net_weight;
                $result->discharging_weight += $doc->cargo[0]->weights->discharge->net_weight;
                $result->ton_price = $doc->freight->route_wage->wage_per_ton;
                $result->total += $doc->freight->amount->base_amount;

                // get deductions
                $deductions = $doc->freight->deductions;

                if ($deductions) {
                    foreach ($deductions as $d) {
                        if ($d->label == "إكرامية سائق") {
                            $result->drivers_tips +=  $d->value->amount;
                        }
                        if ($d->label == "رسوم هيئة") {
                            $result->waybills +=  $d->value->amount;
                        }
                        if ($d->label == "رسوم مفوضية") {
                            $result->submit_waybill +=  $d->value->amount;
                        }
                        if ($d->label == "بدل صرف الكتروني") {
                            $result->commission +=  $d->value->amount;
                        }
                    }
                } else {
                    throw new Exception("لا يمكن المتابعة ، المستند رقم " . $wbl->wn . ' بحاجة لإعادة احتساب المستحقات المالية');
                }

                // get Diesel
                $payments = $doc->freight->payments;
                $dieselValues = [];
                $dieselValue = 0;
                foreach ($payments as $p) {
                    if ($p->name == "DEISIL_PRE_LOAD" || $p->name == "DEISIL_POST_LOAD") {
                        $dieselValues[] = $p->value->amount;
                        $dieselValue += $p->value->amount;
                    } else if ($p->name == "DRIVER_WAGE") {
                        $result->driver_wage += $p->value->amount;
                        $result->net_amount += $p->value->amount;
                    }
                }

                if ($dieselValue < 203) {
                    throw new Exception("لا تستطيع المتابعة ، الشاحنة رقم $wbl->tn ، الأرسالية : $wbl->wn لا تملك كامل قيمة الديزل");
                }
                // validate diesel amount
                $jo_petrol_integration = new Jo_Petrol();
                $dieselAmount = $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_PRE_LOAD') +
                    $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_POST_LOAD');

                // if (abs($dieselAmount - $dieselValue) > 1) {
                //     throw new Exception("لا تستطيع المتابعة ، الشاحنة رقم $wbl->tn ، الأرسالية : $wbl->wn لا تملك قيمة ديزل صحيحة");
                // }

                $result->diesel += $dieselAmount;

                // get loss weights
                $result->lose_weight += $doc->freight->amount->total_fines;
                $result->net_amount += $doc->freight->amount->net_amount;
            }

            $result->total = $result->discharging_weight * $result->ton_price;
            $result->net_amount = $result->net_amount - 0.015;

            if ($tenderClaimBean->extra_items) {
                foreach ($tenderClaimBean->extra_items as $item) {
                    $val = $item->value;
                    $result->net_amount += $val;
                }
                $result->extra_items = $tenderClaimBean->extra_items;
            }

            // fixed decimal
            $result->loading_weight = number_format($result->loading_weight, 3);
            $result->discharging_weight = number_format($result->discharging_weight, 3);
            $result->drivers_tips = number_format($result->drivers_tips, 3);
            $result->waybills = number_format($result->waybills, 3);
            $result->total = number_format($result->total / 1000, 3);
            $result->submit_waybill = number_format($result->submit_waybill, 3);
            $result->diesel = number_format($result->diesel, 3);
            $result->lose_weight = number_format($result->lose_weight, 3);
            $result->commission = number_format($result->commission, 3);
            $result->driver_wage = number_format($result->driver_wage, 3);
            $result->net_amount = number_format($result->net_amount, 3);
        }
        parent::response($result);
    }

    // ------------------------------------------------------------------------------- //
    // --------------------- save Extr Items For Tender Claim------------------------- //
    // ------------------------------------------------------------------------------- //
    public function saveExtrItemsForTenderClaim()
    {
        $tender_claim_id = $this->_request->tender_claim_id;
        $items = $this->_request->items;

        try {
            // change tender_claim status
            $updateBean = new stdClass();
            $updateBean->id = $tender_claim_id;
            $updateBean->extra_items = $items;
            DBConnection::updateDB("tender_claim", $updateBean, $_SESSION['user_id']);
            parent::response("success");
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------------- //
    // --------------------- save Extr Items For Tender Claim------------------------- //
    // ------------------------------------------------------------------------------- //
    public function getLatestTenderRefNumberForCompany()
    {
        $company_id = $this->_request->company_id;
        try {
            $sqlQuery = "
            SELECT MAX(cast(json_unquote(json_extract(claim_details,'$.ref')) as SIGNED )) ref
            from tender_claim
            where tender_company_id = ?
            and status != 'INACTIVE'
            ";
            $params = [$company_id];
            $result = DBConnection::runBindDatabaseQuery($sqlQuery, $params);
            if (sizeof($result) > 0) {
                parent::response($result[0]->ref);
                die;
            }
            parent::response(null);
            parent::response("success");
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }
    // ------------------------------------------------------------------------------------------------------ //
    // ------------------ Generate cover letter for a certain tender_claim ---------------------------------- //
    // ------------------------------------------------------------------------------------------------------ //
    public function updateTenderClaimRefNumber()
    {
        $id = $this->_request->id;
        $new_ref_number = $this->_request->ref_num;

        try {
            $tenderClaimBean = $this->_tenderClaimCore->getTenderClaimBasic($id, $_SESSION['user_id']);
            $claim_details = $tenderClaimBean->claim_details;
            $claim_details->ref = $new_ref_number;
            $tenderClaimBean->claim_details = $claim_details;
            DBConnection::updateDB("tender_claim", $tenderClaimBean, $_SESSION['user_id']);
            // get tender claim summary
            $result['MESSAGE'] = 'تمت العملية بنجاح';
            $result['CODE'] = 0; //TODO

            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------------- //
    // --------------------- save Extr Items For Tender Claim------------------------- //
    // ------------------------------------------------------------------------------- //
    public function addBulkItemsToTenderClaim()
    {
        $items_arr = $this->_request->items_arr;
        $tender_claim_id = $this->_request->tender_claim_id;
        try {
            //clean faild items to add erros log
            $tenderClaimBean = $this->_tenderClaimCore->getTenderClaimBasic($tender_claim_id, $_SESSION['user_id']);
            $claim_details = $tenderClaimBean->claim_details;
            $claim_details->faild_items_to_add = [];
            $tenderClaimBean->claim_details = $claim_details;
            DBConnection::updateDB("tender_claim", $tenderClaimBean, $_SESSION['user_id']);
            // create task to add item
            $taskQueuesCore = new TaskQueuesCore();
            foreach ($items_arr as $item) {
                $taskQueuesCore->addItemToTenderClaimTask($item->loading_ref, $tender_claim_id, $_SESSION['user_id'], $_SESSION['u_id']);
            }
            $result['result'] = 'تمت العملية بنجاح';
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------------- //
    // --------------------- save Extr Items For Tender Claim------------------------- //
    // ------------------------------------------------------------------------------- //
    public function getTenderClaimErros()
    {
        $tender_claim_id = $this->_request->tender_claim_id;
        try {
            //clean faild items to add erros log
            $tenderClaimBean = $this->_tenderClaimCore->getTenderClaimBasic($tender_claim_id, $_SESSION['user_id']);
            $claim_details = $tenderClaimBean->claim_details;
            if ($claim_details->faild_items_to_add && sizeof($claim_details->faild_items_to_add) > 0) {
                $Result['faild_items_to_add'] = $claim_details->faild_items_to_add;
            } else {
                $Result['faild_items_to_add'] = [];
            }

            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------------- //
    // --------------- append new waybill to a certain tender claim ------------------- //
    // --------------  Param: tender_claim_id, waybill -------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function appendWaybillToARClaim()
    {
        try {

            $this->_request = json_decode(json_encode($this->_request));

            // prpaer params
            $pa_id = $this->_request->pa_id;
            $waybill_id = $this->_request->waybill_id;
            $claim_loading_weight = $this->_request->claim_loading_weight;
            $claim_discharge_weight = $this->_request->claim_discharge_weight;
            $claim_loading_date = $this->_request->claim_loading_date;
            $claim_discharge_date = $this->_request->claim_discharge_date;
            $claim_discharge_arrive_date = $this->_request->claim_discharge_arrive_date;
            $ref_num = $this->_request->ref_num;
            $destination_id = $this->_request->destination_id;
            $cargo_id = $this->_request->cargo_id;
            $item_url = $this->_request->item_url;
            $late_fine =  $this->_request->late_fine;
            $compensation = $this->_request->compensation;
            $absence_fine = $this->_request->absence_fine;
            $loss_fine = $this->_request->loss_fine;
            $claim_amount = $this->_request->claim_amount;
            $claim_origin_id = $this->_request->origin_id;
            $tender_id = $this->_request->tender_id;
            $tender_payable_id = $this->_request->tender_payable_id;

            if (!$waybill_id) {
                throw new Exception("رقم المستند غير صحيح");
            }
            if (!$cargo_id) {
                throw new Exception("الحمل غير صحيح");
            }
            if (!$pa_id) {
                throw new Exception("مكتب الصرف غير صحيح");
            }
            if (!$destination_id) {
                throw new Exception("الوجهة غير صحيحة");
            }
            if (!$claim_discharge_date) {
                throw new Exception("تاريخ التفريغ غير صحيح");
            }
            if (!$claim_loading_date) {
                throw new Exception("تاريخ التحميل غير صحيح");
            }
            if (!$claim_discharge_weight) {
                throw new Exception("وزن التفريغ غير صحيح");
            }
            if (!$claim_discharge_arrive_date) {
                throw new Exception("تاريخ الوصول غير صحيح");
            }
            if (!$claim_loading_weight) {
                throw new Exception("وزن التحميل غير صحيح");
            }
            if (!$tender_payable_id) {
                throw new Exception("جهة المطالبة غير صحيحة");
            }
            if (!$ref_num) {
                throw new Exception("رقم البوليصة مطلوب");
            }

            //CHECK AUTH
            $allow = false;
            $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
            foreach ($userRolesArray as $role) {
                if ($role == 'OPERATION_MANAGER' || $role == 'TELLER_SUPERVISOR') {
                    $allow = true;
                }
            }

            // search for route wage
            $waybillBean = $this->_waybillCore->getWaybill($waybill_id, $_SESSION['user_id']);
            $waybillBean = json_decode($waybillBean);
            if (!$waybillBean) {
                throw new Exception("رقم المستند غير صحيح");
            }


            // Compare if loading date is before create date
            $formated_claim_date    =  date_create($claim_loading_date);
            $formated_waybill_date  = date_create($waybillBean->create_date);
            $dateDiff = date_diff($formated_waybill_date, $formated_claim_date);
            if ($dateDiff->d > 0 && $dateDiff->invert > 0) {
                throw new Exception('لا يمكنك المتابعة, تاريخ التحميل المدخل في المطالبة يجب ان يكون بعد تاريخ انشاء المستند');
            }


            DBConnection::startTransaction();

            // if the tender is 3 (البواخر) , and the tender_payable_id (جهة المطالبة) = 2
            // 2 : مدارج

            // search for AR claim for this pa with status new with waybill cargo type
            $status = "NEW";
            if ($allow) {
                $status = "PENDING";
            }
            $AR_claim_filter = [
                //['key' => 'claim_details', 'val' => $cargo_id, 'op' => 'json unquote', 'node' => '$.cargo_id'],
                ['key' => 'claim_details', 'val' => '"AR_claim"', 'op' => 'json unquote', 'node' => '$.claim_type'],
                ['key' => 'pa_id', 'val' => $pa_id],
                ['key' => 'status', 'val' => $status],
                ['key' => 'tender_payable_id', 'val' => $tender_payable_id]
            ];

            if ($tender_id != 3) {
                //array_push($AR_claim_filter, ['key' => 'claim_details', 'val' => date("m", strtotime($claim_loading_date)), 'op' => 'json unquote', 'node' => '$.loading_month']);
            }

            $tender_claims = $this->_tenderClaimCore->searchTenderClaims($AR_claim_filter, 1, 0, $_SESSION['user_id'], null);

            if (sizeof($tender_claims->data) < 1) {
                // create new AR Claim
                // prepare tender_claim bean
                $tenderClaimBean = new stdClass();
                $tenderClaimBean->waybills = null;

                $filter = [
                    ["key" => "status", "val" => ["ACTIVE", "NEW"], "op" => "in"],
                    ["key" => "tender_id", "val" => $tender_id],
                    ['key' => "service_list", "val" => '"DISPATCH"', "op" => "json unquote", "node" => "$[0].code"],
                    ['key' => "service_list", "val" => '"QUEUE"', "op" => "json unquote", "node" => "$[0].type"]
                ];

                $tenderCompanyCore = new TenderCompanyCore();
                $tenderCompany = $tenderCompanyCore->searchTenderCompany($filter, 1, 0, 0)->data;
                $tenderClaimBean->tender_company_id = $tenderCompany[0]->id; // TODO:: ADEL
                $tenderClaimBean->trucking_company_id = $tenderCompany[0]->trucking_company_id;
                $tenderClaimBean->beneficiary_name = "";
                $tenderClaimBean->claim_type = "AR_claim";
                $paCore = new PaymentAgentCore();
                $paBean = $paCore->getPaymentAgentBasic($pa_id, $_SESSION['user_id']);
                $tenderClaimBean->pa_id = $pa_id;
                $tenderClaimBean->pa_name = $paBean->name;
                $tenderClaimBean->tender_payable_id = $tender_payable_id;
     
                $tender_claim_id = $this->_tenderClaimCore->createTenderClaim($tenderClaimBean, $_SESSION['user_id']);
  
                if ($allow) {
                    $this->_tenderClaimCore->changeStatus($tender_claim_id, "PENDING", $_SESSION['user_id']);
                }
            } else {
                // get AR claim id and append to it
                $tender_claim_id = $tender_claims->data[0]->id;
            }


            $waybill_info = new stdClass();
            $waybill_info->waybill_id = $waybill_id;
            $waybill_info->claim_loading_date = $claim_loading_date;
            $waybill_info->claim_discharge_date = $claim_discharge_date;
            $waybill_info->claim_loading_weight = $claim_loading_weight;
            $waybill_info->claim_discharge_weight = $claim_discharge_weight;
            $waybill_info->ref_num = $ref_num;
            $waybill_info->claim_destination_id = $destination_id;
            $waybill_info->claim_destination_name = getLocationName($destination_id);           
            $waybill_info->claim_origin_id = $claim_origin_id;      
            $waybill_info->claim_origin_name = getLocationName($claim_origin_id);
            $waybill_info->claim_discharge_arrive_date =  $claim_discharge_arrive_date;
            $waybill_info->claim_cargo_id =  $cargo_id;
            $waybill_info->claim_cargo_name = $this->_cargoCore->getCargoBasic($cargo_id, 0)->name;
            $waybill_info->allow =  $allow;
            $waybill_info->item_url =  $item_url;
            $waybill_info->tender_payable_id =  $tender_payable_id;
            


            // search route wage
            $routeWage =  $this->_routeWageCore->searchWageForFreight(
                $waybillBean->tender_id,
                $this->_request->origin_id,
                $destination_id,
                $cargo_id,
                $claim_loading_date,
                'payable',
                false,
                $waybillBean
            );
  
            if ($routeWage) {
                // inject cargo weights and dates in waybill bean
                $waybillBean->document->cargo[0]->weights->loading->net_weight = $claim_loading_weight;
                $waybillBean->document->cargo[0]->weights->loading->time_stamp = $claim_loading_date;
                $waybillBean->document->cargo[0]->weights->discharge->net_weight = $claim_discharge_weight;
                $waybillBean->document->cargo[0]->weights->discharge->time_stamp = $claim_discharge_date;
                $waybillBean->document->cargo[0]->weights->arrival = new stdClass();
                $waybillBean->document->cargo[0]->weights->arrival->time_stamp = $claim_discharge_arrive_date;
                $freight = $this->_paymentCore->calculateFreight($waybillBean, $claim_discharge_weight, $claim_loading_weight, $routeWage);
                //update fines
                if ($claim_amount) {
                    $freight->amount->net_amount = $claim_amount;
                }
                if ($late_fine) {
                    $freight->amount->late_fine = $late_fine;
                }
                if ($compensation) {
                    $freight->amount->compensation = $compensation;
                }
                if ($absence_fine) {
                    $freight->amount->absence_fine = $absence_fine;
                }
                if ($loss_fine) {
                    $freight->amount->loss_fine = $loss_fine;
                }

                //total fine
                $freight->amount->total_fines = $freight->amount->loss_fine + $freight->amount->absence_fine  +  $freight->amount->late_fine;

                $waybill_info->claim_amount = $freight->amount->net_amount;
                $waybill_info->freight = $freight;
                $waybill_info->freight->route_wage = $routeWage;
            }

            // prepare tender_claim bean
            $this->_tenderClaimCore->appendWaybillToTenderClaim($tender_claim_id, $waybill_info, $_SESSION['u_id'], $_SESSION['user_id']);

            DBConnection::commitTransaction();

            // return result
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "TENDER_CLAIM.SUCCESSFUL_OPERATION";
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }
    // ----------------------------------------------------------------------------------------- //
    // ------------------ auto complete the waybill info in AR Claim ---------------- //
    // ------------------ params: wn ----------------------------------------------------------- //
    // ----------------------------------------------------------------------------------------- //
    public function autoCompleteARWaybillInfo()
    {

        // parse param
        $wn = $this->_request->wn;
        $tn = $this->_request->tn;
        $tender_id = $this->_request->tender_id;

        try {
            if (!$wn && !$tn) {
                throw new Exception("رقم المستند او الشاحنة مطلوب");
            }

            // search in woq
            $searchFilter = [];
            $searchFilter['query'] = $wn;
            $searchFilter['table_names'] = "WAYBILL";
            $hashedResult = $this->_woqCore->search($searchFilter, 1, 0, 0);
            if ($hashedResult->found_rows > 0) {
                $waybill_id = $hashedResult->data[0]->object_id;
            }

            if ($wn && $tender_id == 3) {
                $searchFilter = [
                    ['key' => 'wn', 'val' => $wn],
                    ['key' => 'tender_id', 'val' => $tender_id]
                ];
                $waybillsResult = $this->_waybillCore->searchWaybills($searchFilter, 1, 0, 0);
            } else {
                // search in AR_claim if not found
                $searchFilter = [
                    ['key' => 'status', 'val' => ['INACTIVE', 'REVOKED'], 'op' => 'not in'],
                    ['key' => 'details', 'val' => '"AR_claim"', 'op' => 'json unquote', 'node' => '$.claim_type'],
                ];
                if ($waybill_id) {
                    $searchFilter[] = ['key' => 'waybill_id', 'val' => $waybill_id];
                } else {
                    $searchFilter[] = ['key' => 'details', 'val' => $wn, 'op' => 'json unquote', 'node' => '$.wn'];
                }
                $waybillsResult = $this->_tenderClaimCore->searchTenderClaimItems($searchFilter, 1, 0, $_SESSION['user_id'], null);

                // search in waybill
                if ($waybillsResult->found_rows == 0) {
                    $wblSearchFilter = [
                        ['key' => 'id', 'val' => $waybill_id]
                    ];

                    $waybillsResult = $this->_waybillCore->searchWaybills($wblSearchFilter, 1, 0, 0);
                } else {
                    $this->returnItemResponse($waybillsResult);
                }
            }


            $arr = [];
            foreach ($waybillsResult->data as $waybill) {
                $waybillBean = $waybill;
                // check if waybill is used in another claim
                $doc = json_decode($waybillBean->document);
                // clean the data
                $result = new stdClass();
                $result->nafith_wn = $doc->nafith_wn;
                $result->wn = $waybillBean->wn;
                $result->id = $waybillBean->id;
                $result->tn = $doc->carrier[0]->truck->tn;
                $result->trn = $doc->carrier[0]->trailer->tn;
                $result->create_date = $waybillBean->create_date;
                $result->loading_weight = $doc->cargo[0]->weights->loading->net_weight;
                if ($doc->cargo[0]->weights->loading->time_stamp) {
                    $loading_date = new DateTime($doc->cargo[0]->weights->loading->time_stamp);
                    $result->loading_date = $loading_date->format('Y-m-d h:m');
                } else {
                    $result->loading_date = "";
                }

                $result->cargo_name = $doc->cargo[0]->name;
                $result->cargo_id = $doc->cargo[0]->cargo_id;
                $result->discharge_weight = $doc->cargo[0]->weights->discharge->net_weight;
                $result->driver_name = $doc->carrier[0]->driver->name;
                $result->truck_owner_name = $doc->carrier[0]->truck_owner->name;
                if ($doc->cargo[0]->weights->discharge->time_stamp) {
                    $discharge_date = new DateTime($doc->cargo[0]->weights->discharge->time_stamp);
                    $result->discharge_date = $discharge_date->format('Y-m-d h:m');
                } else {
                    $result->discharge_date = "";
                }
                $result->destination_name = $doc->negotiable_instructios->route->destination->name;
                $result->destination_id = $doc->negotiable_instructios->route->destination->id;
                $arr[] = $result;
            }
            parent::response($arr);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ----------------------------------------------------------------------------------------- //
    // ------------------ return auto complete reponse  --------------------------------------- //
    // ------------------ params: wn ----------------------------------------------------------- //
    // ----------------------------------------------------------------------------------------- //
    public function returnItemResponse($waybillsResult)
    {
        $arr = [];
        foreach ($waybillsResult->data as $waybill) {
            // check if waybill is used in another claim
            $doc = json_decode($waybill->details);
            // clean the data
            $result = new stdClass();
            $result->nafith_wn = $doc->nafith_wn;
            $result->wn = $doc->wn;
            $result->id = $waybill->waybill_id;
            $result->tn = $doc->tn;
            $result->trn = $doc->trn;
            $result->create_date = $waybill->create_date;
            $result->loading_weight = $doc->claim_loading_weight;
            $result->loading_date = $doc->claim_loading_date;
            $result->cargo_name = $doc->claim_cargo_name;
            $result->cargo_id = $doc->claim_cargo_id;
            $result->discharge_weight = $doc->claim_discharge_weight;
            $result->driver_name = $doc->driver_name;
            $result->discharge_date = $doc->claim_discharge_date;
            $result->destination_name = $doc->claim_destination_name;
            $result->destination_id = $doc->claim_destination_id;
            $result->arrival_time = $doc->claim_discharge_arrive_date;
            $result->origin_id = $doc->claim_origin_id;
            $result->origin_name = $doc->claim_origin_name;
            $result->ref = $doc->ref_num;
            $arr[] = $result;
        }
        parent::response($arr);
        die;
    }

    // ----------------------------------------------------------------------------------------- //
    // ------------------ auto complete the waybill info in AR Claim ---------------- //
    // ------------------ params: wn ----------------------------------------------------------- //
    // ----------------------------------------------------------------------------------------- //
    public function addNoteToARClaim()
    {
        $waybill_id = $this->_request->waybill_id;
        $notes = $this->_request->notes;

        if (!$waybill_id || !$notes) {
            throw new Exception("رقم المستند والملاحظات مطلوب");
        }

        try {
            $this->_tenderClaimCore->addNoteToARClaim($waybill_id, $notes, $_SESSION['user_id']);
            $result["MESSAGE"] = "تمت اضافة الملاحظة بنجاح";
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ----------------------------------------------------------------------------------------- //
    // ------------------ auto complete the waybill info in AR Claim ---------------- //
    // ------------------ params: wn ----------------------------------------------------------- //
    // ----------------------------------------------------------------------------------------- //
    public function updateBeneficiaryName()
    {
        $beneficiary_name = $this->_request->beneficiary_name;
        $tender_claim_id = $this->_request->tender_claim_id;
        if (!$beneficiary_name) {
            throw new Exception("اسم المستفيد مطلوب");
        }

        // get the tender_claim bean
        $tenderClaimBean = $this->_tenderClaimCore->getTenderClaimBasic($tender_claim_id, $_SESSION['user_id']);
        if (!$tenderClaimBean) {
            throw new Exception("المطالبة غير صحيحة");
        }

        $claim_details = $tenderClaimBean->claim_details;
        $claim_details->beneficiary_name = $beneficiary_name;

        $tenderClaimBean->claim_details = $claim_details;
        DBConnection::updateDB("tender_claim", $tenderClaimBean, $_SESSION['user_id']);

        $Result['MESSAGE'] = "تمت العملية بنجاح";
        parent::response($Result);
    }


    // -------------------------------------------------------------------------------------- //
    // ---------------- Get Summary of claim by destination to be printed as pdf ------------ //
    // -------------------------------------------------------------------------------------- //
    public function getTenderClaimSummaryByDestination()
    {

        $tender_claim_id = $this->_request->tender_claim_id;
        $sqlQuery = "SELECT 
            t.details->>'$.claim_destination_name' claim_destination_name,
            t.id cnt ,
            t.details->>'$.claim_loading_weight' claim_loading_weight,
            t.requested_freight->>'$.wage_per_ton' wage_per_ton,
            t.requested_freight->>'$.loss_in_kg' loss_in_kg,
            t.requested_freight->>'$.loss_fine_per_kg' loss_fine_per_kg,
            t.requested_freight->>'$.loss_in_kg' loss_in_kg,
            t.requested_freight->>'$.total_fines' total_fines,
            t.requested_freight->>'$.base_amount' base_amount,
            t.requested_freight->>'$.compensation' compensation,
            t.requested_freight->>'$.deductions' tawabe
        FROM
            tender_claim_item t
        WHERE
            tender_claim_id = ?
                AND status = 'ACTIVE'";

        $cargosqlQuery = "SELECT
        t.details->>'$.claim_cargo_name' cargo_name
        FROM
        tender_claim_item t
        WHERE
        tender_claim_id = ?
            AND status = 'ACTIVE'
            group by t.details->>'$.claim_cargo_name'";

        $queryResult = DBConnection::runBindDatabaseQuery($sqlQuery, [$tender_claim_id]);
        $cargosResult = DBConnection::runBindDatabaseQuery($cargosqlQuery, [$tender_claim_id]);


        $tempSummaryResult = [];
        foreach ($queryResult as $citem) {
            $tempSummaryResult[$citem->claim_destination_name]['cnt']++;
            $tempSummaryResult[$citem->claim_destination_name]['claim_loading_weight'] += $citem->claim_loading_weight;
            $tempSummaryResult[$citem->claim_destination_name]['wage_per_ton'] =  $citem->wage_per_ton;
            $tempSummaryResult[$citem->claim_destination_name]['loss_in_kg'] +=  $citem->loss_in_kg;
            $tempSummaryResult[$citem->claim_destination_name]['loss_fine_per_kg'] =  $citem->loss_fine_per_kg;
            $tempSummaryResult[$citem->claim_destination_name]['total_fines'] +=  $citem->total_fines;
            $tempSummaryResult[$citem->claim_destination_name]['base_amount'] +=  $citem->base_amount;
            $tempSummaryResult[$citem->claim_destination_name]['compensation'] +=  $citem->compensation;
            $tawabeObj = json_decode($citem->tawabe, true);
            foreach ($tawabeObj as $key) {
                if ($key['name'] == "tawabe") {
                    $tempSummaryResult[$citem->claim_destination_name]['tawabe'] += $key['value'];
                }
            }
        }
        $summaryResult = [];
        foreach ($tempSummaryResult as $key => $temp) {
            $temp = (object)$temp;
            $temp->claim_destination_name = $key;
            $summaryResult[] = $temp;
        }

        foreach ($summaryResult as  &$item) {
            $item->cnt = strval($item->cnt);
            $item->claim_loading_weight = strval($item->claim_loading_weight);
            $item->wage_per_ton = strval($item->wage_per_ton);
            $item->loss_in_kg = strval($item->loss_in_kg);
            $item->loss_fine_per_kg = strval($item->loss_fine_per_kg);
            $item->total_fines = strval($item->total_fines);
            $item->base_amount = strval(round($item->base_amount, 3));
            $item->compensation = strval($item->compensation);
        }

        $Result['summary'] = $summaryResult;
        $Result['cargos'] = $cargosResult;

        parent::response($Result);
    }

    // -------------------------------------------------------------------------------------- //
    // ---------------- Get Summary of claim by destination to be printed as pdf ------------ //
    // -------------------------------------------------------------------------------------- //
    public function reCalculateFreight()
    {
        try {
            $tender_claim_item_id = $this->_request->tender_claim_item_id;
            $this->_tenderClaimCore->reCalculateFreight($tender_claim_item_id);
            $data["MESSAGE"] = "تمت العملية بنجاح";
            parent::response($data);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------------------- //
    // ---------------- Get Summary of claim by destination to be printed as pdf ------------ //
    // -------------------------------------------------------------------------------------- //
    public function getApprovedItemsForPa()
    {
        try {
            $pa_id = $this->_request->pa_id;
            $tender_id = $this->_request->tender_id;

            $sqlQuery = "
                        SELECT
                        id,
                        tender_claim_id,
                        pa_id,
                        pa_name,
                        cargo_name,
                        waybill_id,
                        policy_number,
                        tn,
                        pa_claim_destination_name,
                        tc_claim_destination_name,
                        indivisual_price,
                        tc_price,
                        requested_net_amount,
                        approved_net_amount,
                        company_net_amount
                    FROM
                        tender_claim_item_01_report
                    WHERE
                        pa_id = ?
                        and tender_id = ?
                        and status = 'APPROVED'
                        and voucher_id is null";


            $approvedItems = DBConnection::runBindDatabaseQuery($sqlQuery, [$pa_id, $tender_id]);
            parent::response($approvedItems);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------TC_FINANCIAL_MANAGER Dashboard ----------------------------------------- //




    // ----------------------------------------------------------------------------------- //
    // ---------------- lvl1: Get Summary of approved items ------------------------------------ //
    // ---------------- مطالبات مكاتب غير مدفوعة ----------------------------------------- //
    // ----------------------------------------------------------------------------------- //
    public function getApprovedItemsSummary()
    {

        // TODO: validate auth

        try {
            $sqlQuery = "SELECT
                            format(sum(ar_item.approved_net_amount),3) amount,
                            count(distinct(ar_item.pa_id)) pa_count,
                            count(distinct(ar_item.id)) items_count
                        FROM
                            tender_claim_item_01_report as ar_item
                        WHERE
                            ar_item.pa_id IS NOT NULL
                            and ar_item.waybill_tender_claim_status = 'APPROVED'
                            and ar_item.status in ('APPROVED')
                            AND ar_item.tender_company_id = 197 ";

            $summary = DBConnection::runDatabaseQuery($sqlQuery);
            $result = [];
            $result['main_tilte'] = "ذمم مكاتب غير مدفوعة";
            $result['amount'] = ["label" => "المبلغ", "value" => $summary[0]->amount];
            $result['pa_count'] = ["label" => "المكاتب", "value" => intval($summary[0]->pa_count)];
            $result['items_count'] = ["label" => "المستندات", "value" => intval($summary[0]->items_count)];
            #$result['percentage']=["percentage"=>"5.52%" , "arrow"=> "up" , "caption"=>"مقارنة بآخر 7 ايام"];

            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ---------------------------------------------------------------------------------------- //
    // ---------------- lvl1: Get Summary of approved items ----------------------------------------- //
    // ----------------- مطالبات تجار لم تحصل بعد --------------------------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function getApprovedTenderClaims()
    {
        try {
            $sqlQuery = "SELECT
                            FORMAT(SUM(ar_item.company_net_amount),3) amount,
                            COUNT(DISTINCT (ar_item.ca_id)) ca
                        FROM
                            tender_claim_item_01_report AS ar_item
                        WHERE
                            ar_item.pa_id IS NOT NULL
                                AND ar_item.waybill_item_status = 'ACTIVE'
                                AND ar_item.status IN ('APPROVED','ACTIVE')
                                AND ar_item.tender_company_id = 197";

            $summary = DBConnection::runDatabaseQuery($sqlQuery);
            $captions = array("ca" => "التجار", "amount" => "المبلغ");
            $summary = DBConnection::runDatabaseQuery($sqlQuery);
            $result = array();
            foreach ($summary[0] as $key => $val) {
                $result[$key] = array("label" => $captions[$key], "value" => $val);
            }
            $result['main_tilte'] = "مطالبات تجار لم تحصل بعد";
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ---------------------------------------------------------------------------------------- //
    // ---------------- lvl1: Get Summary of approved items ----------------------------------- //
    // ---------------- مطالبات مكاتب غير موافق عليها ----------------------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function getActiveItemsSummary()
    {

        // TODO: validate auth
        try {
            $sqlQuery = "SELECT
                            format(sum(ar_item.requested_net_amount),3) amount,
                    count(distinct(ar_item.pa_id)) pa_count,
                    count(distinct(ar_item.id)) items_count
                FROM
                    tender_claim_item_01_report as ar_item
                WHERE
                    ar_item.pa_id IS NOT NULL
                            and ar_item.waybill_item_status = 'ACTIVE'
                            and ar_item.status in ('ACTIVE')
                            AND ar_item.tender_company_id = 197";

            $summary = DBConnection::runDatabaseQuery($sqlQuery);
            $result = [];
            $result['main_tilte'] = "مطالبات مكاتب غير موافق عليها";
            $result['amount'] = ["label" => "المبلغ", "value" => $summary[0]->amount];
            $result['pa_count'] = ["label" => "المكاتب", "value" => intval($summary[0]->pa_count)];
            $result['items_count'] = ["label" => "المستندات", "value" => intval($summary[0]->items_count)];
            // $result['percentage']=["percentage"=>"5.52%" , "arrow"=> "up" , "caption"=>"مقارنة بآخر 7 ايام"];

            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------- //
    // ----------------lvl1: Get Summary of approved items --------------------------- //
    // ----------------- مستندات غير مصروفة ------------------------------------- //
    // -------------------------------------------------------------------------- //
    public function getWaybillsWithoutTenderClaim()
    {

        // TODO: Validate Auth

        try {
            $sqlQuery = "SELECT
            count(w.id) cnt ,
            format(sum((w.document->>'$.cargo[0].weights.loading.net_weight'/1000) * r.wage_per_ton),3) amount
                FROM
                    waybill w,route_wage r
                WHERE
                w.tender_id = 13
                and w.loading_date is not null
                and r.destination_id = w.destination_id
                and r.cargo_id = w.document->>'$.cargo[0].cargo_id'
                and r.status = 'ACTIVE'
                and r.start_date >= '2020-12-01'
                and r.type = 'payable'
                and w.status not in ('INACTIVE','REVOKED')
                and w.trucking_company_id = 395
                AND NOT EXISTS( SELECT  id
                FROM tender_claim_item
                WHERE waybill_id = w.id AND status != 'INACTIVE')
            ";

            $captions = array("cnt" => "المستندات", "amount" => "المبلغ التقديري");
            $summary = DBConnection::runDatabaseQuery($sqlQuery);
            $result = array();
            foreach ($summary[0] as $key => $val) {
                $result[$key] = array("label" => $captions[$key], "value" => $val);
            }
            $result['main_tilte'] = "مستندات غير مصروفة";
            // $result['percentage']=["percentage"=>"" , "arrow"=> "" , "caption"=>"مبلغ تقديري"];

            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------------------------------- //
    // ---------------- lvl1: Get getItems Without Load--------------------------- //
    // -------------------------------------------------------------------------- //
    public function getItemsWithoutLoad()
    {
        try {
            $sqlQuery = "
            select count(w.id) count ,
                    count(distinct(w.document->>'$.negotiable_instructios.route.destination.name')) dest_cnt,
                    format(sum(36.000 * r.wage_per_ton),3) amount
            from waybill_view w, route_wage r
            where
                w.tender_id = 13
                and w.loading_date is not null
                and r.destination_id = w.destination_id
                and r.cargo_id = w.document->>'$.cargo[0].cargo_id'
                and r.status = 'ACTIVE'
                and r.start_date >= '2020-12-01'
                and r.type = 'payable'
                and w.status not in ('INACTIVE','REVOKED')
                and w.trucking_company_id = 395
                and w.status in ('NEW','APPROVED','ACTIVE')
                and document->>'$.carrier[0].tc.id' = 395
                ";

            $summary = DBConnection::runDatabaseQuery($sqlQuery);

            $result = [];
            $result['main_tilte'] = "مستندات غير محملة";
            $result['amount'] = ["label" => "المبلغ التقديري", "value" => $summary[0]->amount];
            $result['pa_count'] = ["label" => "عدد الوجهات", "value" => intval($summary[0]->dest_cnt)];
            $result['items_count'] = ["label" => "المستندات", "value" => intval($summary[0]->count)];
            // $result['percentage']=["percentage"=>"" , "arrow"=> "" , "caption"=>"مبلغ تقديري"];

            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }



    // ---------------------------------------------------------------------------------------- //
    // ----------------lvl2: Get Summary of approved items ----------------------------------------- //
    // -------------- تفاصيل ذمم المكاتب غير المدفوعة ----------------------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function getApprovedItemsSummaryDetails()
    {
        try {
            $sqlQuery = "SELECT
                    count(id) cnt,
                    format(sum(approved_net_amount),3) approved_net_amount,
                    sum(approved_net_amount) order_approved_net_amount,
                    min(date(approved_date)) oldest_approved_date,
                    pa_id,
                    pa_name
                FROM
                    tender_claim_item_01_report i
                WHERE
                    status = 'APPROVED' AND pa_id IS NOT NULL
                GROUP BY pa_id,pa_name
                        order by order_approved_net_amount desc
            ";

            $summary = DBConnection::runDatabaseQuery($sqlQuery);

            $result = [];
            $result['main_tilte'] = "تفاصيل ذمم المكاتب غير المدفوعة";
            foreach ($summary as $raw) {
                $data['pa_id'] = $raw->pa_id;
                $data['item1'] = [];
                $data['item1'] = ["label" => $raw->pa_name];
                $data['item2'] = ["label" => "المستندات", "value" => $raw->cnt];
                $data['item3'] = ["label" => $raw->approved_net_amount];
                $data['item4'] = ["label" => "اقدم ذمة", "value" => $raw->oldest_approved_date];
                $result['data'][] = $data;
            }

            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------- //
    // ---------------- lvl2: getItemsWithoutLoad Details --------------------------- //
    // ------------------- تفاصيل المستندات الغير المحملة --------------------------- //
    // -------------------------------------------------------------------------- //
    public function getItemsWithoutLoadDetails()
    {
        try {
            $sqlQuery = "
            select  count(w.id) cnt ,
                w.document->>'$.negotiable_instructios.route.destination.name' destination_name,
                format(sum(36000 * r.wage_per_ton),3) amount
            from waybill_view w, route_wage r
                where
                w.tender_id = 13
                and w.loading_date is not null
                and r.destination_id = w.destination_id
                and r.cargo_id = w.document->>'$.cargo[0].cargo_id'
                and r.status = 'ACTIVE'
                and r.start_date >= '2020-12-01'
                and r.type = 'payable'
                and w.status not in ('INACTIVE','REVOKED')
                and w.trucking_company_id = 395
                and w.status in ('NEW','APPROVED','ACTIVE')
                and document->>'$.carrier[0].tc.id' = 395
                group by w.document->>'$.negotiable_instructios.route.destination.name'
                ";

            $summary = DBConnection::runDatabaseQuery($sqlQuery);

            $result = [];
            $result['main_tilte'] = "تفاصيل المستندات الغير المحملة";
            foreach ($summary as $raw) {
                $data['item1'] = [];
                $data['item1'] = ["label" => $raw->destination_name];
                $data['item2'] = ["label" => $raw->amount];
                $data['item3'] = ["label" => "المستندات", "value" => $raw->cnt];
                $result['data'][] = $data;
            }

            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------------------------- //
    // ----------------lvl2: Get Summary of approved items -------------------------------------------- //
    // ---------------- تفاصيل مطالبات مكاتب غير موافق عليها ------------------------------------- //
    // ------------------------------------------------------------------------------------------- //
    public function getActiveItemsSummaryDetails()
    {
        try {
            $sqlQuery =
                "SELECT
                    count(id) cnt,
                    format(sum(requested_net_amount),3) requested_net_amount,
                    pa_name,
                    pa_id
                FROM
                    tender_claim_item_01_report i
                WHERE
                    status = 'ACTIVE' AND pa_id IS NOT NULL
                    and waybill_tender_claim_id is null
                GROUP BY pa_name, pa_id
                order by requested_net_amount desc
            ";
            $summary = DBConnection::runDatabaseQuery($sqlQuery);

            $result = [];
            $result['main_title'] = "تفاصيل مطالبات مكاتب غير موافق عليها";
            foreach ($summary as $raw) {
                $data['pa_id'] = $raw->pa_id;
                $data['item1'] = [];
                $data['item1'] = ["label" => $raw->pa_name];
                $data['item2'] = ["label" => "المستندات", "value" => $raw->cnt];
                $data['item3'] = ["label" => $raw->requested_net_amount];
                $result['data'][] = $data;
            }
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ----------------------------------------------------------------------------------------- //
    // ----------------lvl2:Get Summary of approved items ------------------------------------------ //
    // ----------------- تفاصيل المستندات غير مصروفة ------------------------------------------- //
    // ----------------------------------------------------------------------------------------- //
    public function getWaybillsWithoutTenderClaimDetails()
    {
        try {
            $sqlQuery =
                "SELECT
                count(w.id) cnt ,
                l.name as destination_name,
                format(sum(w.document->>'$.cargo[0].weights.loading.net_weight' * r.wage_per_ton,3) amount
            FROM
                    waybill w,route_wage r, location l
            WHERE
            w.tender_id = 13
            and w.loading_date is not null
            and r.destination_id = w.destination_id
            and r.cargo_id = w.document->>'$.cargo[0].cargo_id'
            and r.status = 'ACTIVE'
            and r.start_date >= '2020-12-01'
            and r.type = 'payable'
            and w.status not in ('INACTIVE','REVOKED')
            and w.trucking_company_id = 395
            AND NOT EXISTS( SELECT  id
            FROM tender_claim_item
            WHERE waybill_id = w.id AND status != 'INACTIVE')
                and w.destination_id = l.id
                group by w.destination_id, l.name
            ";
            $summary = DBConnection::runDatabaseQuery($sqlQuery);

            $result = [];
            $result['main_title'] = "المستندات غير المحملة";
            foreach ($summary as $raw) {
                $data['item1'] = [];
                $data['item1'] = ["label" => $raw->destination_name];
                $data['item2'] = ["label" => "المستندات", "value" => $raw->cnt];
                $data['item3'] = ["label" => $raw->amount];
                $result['data'][] = $data;
            }
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ---------------------------------------------------------------------------------------- //
    // ---------------- lvl2: Get Summary of approved items ----------------------------------------- //
    // ----------------- مطالبات تجار لم تحصل بعد --------------------------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function getApprovedTenderClaimsDetails()
    {
        try {
            $sqlQuery = "
                SELECT
                    FORMAT(SUM(ar_item.company_net_amount),3) amount,
                    COUNT(DISTINCT (ar_item.waybill_tender_claim_id)) cnt,
                    min(date(ar_item.create_date)) min_date,
                    c.name ca_name,
                    c.id as ca_id
                FROM
                    tender_claim_item_01_report AS ar_item,
                    ca_view c
                WHERE
                    ar_item.pa_id IS NOT NULL
                        AND ar_item.ca_id = c.id
                        AND ar_item.waybill_item_status = 'ACTIVE'
                        AND ar_item.status IN ('APPROVED' , 'ACTIVE')
                        AND ar_item.tender_company_id = 197
                group by ar_item.ca_id ";

            $summary = DBConnection::runDatabaseQuery($sqlQuery);

            $result = [];
            $result['main_title'] = "مطالبات تجار لم تحصل بعد";
            foreach ($summary as $raw) {
                $data['ca_id'] = $raw->ca_id;
                $data['item1'] = [];
                $data['item1'] = ["label" => $raw->ca_name];
                $data['item3'] = ["label" => $raw->amount];

                $data['item2'] = ["label" => "اقدم مطالبة", "value" => $raw->min_date];
                $data['item4'] = ["label" => "عدد المطالبات", "value" => $raw->cnt];

                $result['data'][] = $data;
            }
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ---------------------------------------------------------------------------------------------- //
    // ---------------- lvl3: Get Summary of approved items per ca ---------------------------------- //
    // ----------------- تفاصيل مطالبات تجار لم تحصل بعد -------------------------------------------- //
    // ---------------------------------------------------------------------------------------------- //
    public function getApprovedTenderClaimsSummary()
    {

        $clearingAgentCore = new ClearingAgentCore();
        $ca_id = $this->_request->ca_id;

        try {
            $sqlQuery = "
            select
                count(distinct(i.tender_claim_id)) claim_cnt,
                count(i.id) item_cnt,
                format(sum(i.requested_freight->>'$.net_amount'),3) as company_net_amount,
                date(t.create_date) create_date
            from tender_claim t, tender_claim_item i
            where
                t.claim_details->>'$.claim_type' = 'waybill_claim'
                and t.tender_company_id = 197
                and t.status ='APPROVED'
                and t.ca_id = ?
                and i.tender_claim_id = t.id
                and i.status !=' INACTIVE'
                group by  date(create_date)
                order by date(t.create_date)
            ";

            $param = [$ca_id];
            $summary = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

            $clearingAgentBean = $clearingAgentCore->getClearingAgentBasic($ca_id, 0);
            $result = [];
            $result['main_title'] = "مطالبات " . $clearingAgentBean->name;
            foreach ($summary as $raw) {
                $data['item1'] = [];
                $data['item1'] = ["label" => $raw->create_date];
                $data['item2'] = ["label" => $raw->company_net_amount];
                $data['item3'] = ["label" => "المطالبات", "value" => $raw->claim_cnt];
                $data['item4'] = ["label" => "المستندات", "value" => $raw->item_cnt];
                $result['data'][] = $data;
            }
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ---------------------------------------------------------------------------------------- //
    // ----------------lvl3: Get Summary of approved items ----------------------------------------- //
    // ---------------- تفاصيل المستندات الموافق عليها لمكتب معين ----------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function getPaApprovedItemsSummary()
    {
        $paCore = new PaymentAgentCore();

        //TODO: validate auth
        try {
            $pa_id = $this->_request->pa_id;
            $sqlQuery =
                "SELECT
                    COUNT(id), format(sum(approved_net_amount),3) approved_net_amount ,date(approved_date) approved_date
                FROM
                    tender_claim_item_01_report
                WHERE
                    status = 'APPROVED' AND pa_id = ?
                GROUP BY date(approved_date)
                order by date(approved_date) asc
            ";
            $param = [$pa_id];

            $summary = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
            $paBeanName = $paCore->getPaymentAgentBasic($pa_id, 0)->name;

            $result = [];
            $result['main_title'] = "مستندات مكتب $paBeanName الموافق عليها";
            foreach ($summary as $raw) {
                $data['item1'] = [];
                $data['item1'] = ["label" => $raw->approved_date];
                $data['item2'] = ["label" => $raw->approved_net_amount];
                $result['data'][] = $data;
            }
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ---------------------------------------------------------------------------------------- //
    // ----------------lvl3: Get Summary of active items ------------------------------------------ //
    // ---------------- تفاصيل المستندات المقدمة من مكتب معين ----------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function getPaActiveItemsSummary()
    {

        $paCore = new PaymentAgentCore();

        try {
            $pa_id = $this->_request->pa_id;
            $sqlQuery =
                "SELECT
                    COUNT(id),
                    format(SUM(requested_net_amount), 3) requested_net_amount,
                    DATE(create_date) create_date
                FROM
                    tender_claim_item_01_report
                WHERE
                    status = 'ACTIVE' AND pa_id IS NOT NULL
                        AND waybill_tender_claim_id IS NULL
                        AND pa_id = ?
                GROUP BY DATE(create_date)
                ORDER BY DATE(create_date) ASC";

            $param = [$pa_id];
            $summary = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
            $paBeanName = $paCore->getPaymentAgentBasic($pa_id, 0)->name;

            $result = [];
            $result['data'] = [];
            $result['main_title'] = "مستندات مكتب $paBeanName المقدمة ";
            foreach ($summary as $raw) {
                $data['item1'] = [];
                $data['item1'] = ["label" => $raw->create_date];
                $data['item2'] = ["label" => $raw->requested_net_amount];
                $result['data'][] = $data;
            }
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ---------------------------------------------------------------------------------------- //
    // ----------------lvl3: Get Summary of history payment up to 10 for certain pa ----------- //
    // ---------------- سجل الدفعات  ---------------------------------------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function getPaHistoryPayment()
    {

        $paCore = new PaymentAgentCore();

        try {
            $pa_id = $this->_request->pa_id;
            $sqlQuery =
                "SELECT
                    COUNT(id) cnt,
                    FORMAT(SUM(requested_net_amount), 3) requested_net_amount,
                    DATE(create_date) create_date
                FROM
                    tender_claim_item_01_report
                WHERE
                    status = 'COMPLETE' AND pa_id IS NOT NULL
                        AND pa_id = ?
            GROUP BY DATE(create_date)
            ORDER BY DATE(create_date) desc
            limit 10";

            $param = [$pa_id];
            $summary = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
            $paBeanName = $paCore->getPaymentAgentBasic($pa_id, 0)->name;

            $result = [];
            $result['data'] = [];
            $result['main_title'] = "اخر 10 دفعات ، المكتب: $paBeanName ";
            foreach ($summary as $raw) {
                $data['item1'] = [];
                $data['item1'] = ["label" => $raw->create_date];
                $data['item2'] = ["label" => $raw->requested_net_amount];
                $result['data'][] = $data;
            }
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ---------------------------------------------------------------------------- //
    // ---------------- get if the module is in Maintenance Mode or not ----------- //
    // ---------------------------------------------------------------------------- //
    public function getMaintenanceMode()
    {
        if ($_SESSION['u_id'] == 2) {
            parent::response(false);
        } else {
            parent::response(false);
        }
    }

    // ---------------------------------------------------------------------------- //
    // ---------------- get if the module is in Maintenance Mode or not ----------- //
    // ---------------------------------------------------------------------------- //
    public function searchTenderPayable()
    {
        $tender_id = $this->_request->tender_id;
        $pa_id = $this->_request->pa_id;

        if (!$tender_id) {
            throw new Exception("رقم المشروع مطلوب");
        }

        $sqlQuery = " select id,tender_id,company_id,company_name,CAST(`filter` AS CHAR CHARSET UTF8) AS filter,status from tender_payable where tender_id = ?";
        $result = DBConnection::runBindDatabaseQuery($sqlQuery, [$tender_id]);


        $response = [];
        foreach ($result as $p) {
            if ($p->filter) {
                if (array_search($pa_id, json_decode($p->filter)) > -1) {
                    $response[] = $p;
                } else {
                    continue;
                }
            } else {
                $response[] = $p;
            }
        }

        parent::response($response);
    }


    // -------------------------------------------------------------------------------- //
    // --------------- append new item to a certain  claim in FPS ------------------- //
    // ---------------------------------------------- -------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function appendToPaClaim()
    {
        try {

            DBConnection::startTransaction();
            // prpaer params
            $claim_loading_weight = $this->_request->claim_loading_weight;
            $claim_discharge_weight = $this->_request->claim_discharge_weight;
            $claim_loading_date = $this->_request->claim_loading_date;
            $claim_discharge_date = $this->_request->claim_discharge_date;
            $ref_num = $this->_request->ref_num;
            $destination_id = $this->_request->destination_id;
            $late_fine = $this->_request->late_fine;
            $compensation = $this->_request->compensation;
            $absence_fine = $this->_request->absence_fine;
            $loss_fine = $this->_request->loss_fine;
            $claim_amount = $this->_request->claim_amount;
            $claim_origin_id = $this->_request->origin_id;
            $claim_discharge_arrive_date = $this->_request->claim_discharge_arrive_date;
            $pa_id = $this->_request->pa_id;

            if (!$destination_id) {
                throw new Exception("الرجاء اختيار الوجهة");
            }

            $bean = new stdClass();
            $bean->claim_discharge_arrive_date = $claim_discharge_arrive_date;
            $bean->claim_origin_id = $claim_origin_id;
            $bean->claim_origin_name = getLocationName($claim_origin_id);
            $bean->claim_loading_date = $claim_loading_date;
            $bean->claim_discharge_date = $claim_discharge_date;
            $bean->claim_loading_weight = $claim_loading_weight;
            $bean->claim_discharge_weight = $claim_discharge_weight;
            $bean->ref_num = $ref_num;
            $bean->claim_destination_id = $destination_id;
            $bean->claim_destination_name = getLocationName($destination_id);


            // search route wage
            $paRouteWage = new PaWageCore();
            $routeWage =  $paRouteWage->searchPaWageForFreight($pa_id, $claim_origin_id, $destination_id, $claim_loading_date, $_SESSION['user_id']);

            //
            $waybillBean = new stdClass();
            $waybillBean->document = new stdClass();
            $waybillBean->document->freight = null;
            $waybillBean->document->tender = new stdClass();
            $waybillBean->document->tender->id = null;
            $waybillBean->document->negotiable_instructios = new stdClass();
            $waybillBean->document->negotiable_instructios->route = new stdClass();
            $waybillBean->document->negotiable_instructios->route->destination = new stdClass();
            $waybillBean->document->negotiable_instructios->route->destination->id = $destination_id;

            $freight = $this->_paymentCore->calculateFreight($waybillBean, $claim_discharge_weight, $claim_loading_weight, $routeWage);


            //update fines
            if ($claim_amount) {
                $freight->amount->net_amount = $claim_amount;
            }
            if ($late_fine) {
                $freight->amount->late_fine = $late_fine;
            }
            if ($compensation) {
                $freight->amount->compensation = $compensation;
            }
            if ($absence_fine) {
                $freight->amount->absence_fine = $absence_fine;
            }
            if ($loss_fine) {
                $freight->amount->loss_fine = $loss_fine;
            }

            //total fine
            $freight->amount->total_fines = $freight->amount->loss_fine + $freight->amount->absence_fine  +  $freight->amount->late_fine;

            $bean->freight = $freight;
            $bean->freight->route_wage = $routeWage;


            DBConnection::commitTransaction();

            // return result
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "TENDER_CLAIM.SUCCESSFUL_OPERATION";
            parent::response($Result);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }


    // ----------------------------------------------------------------------------------------- //
    // --------------- Create new claim and item in FPS System of type Payable ----------------- //
    // ----------------------------------------------------------------------------------------- //
    private function createPayableFpsClaim($pa_id, $tender_payable_id, $waybillBean, $claim_amount)
    {

        $tenderPayableBean = $this->_tenderClaimCore->getTenderPayable($tender_payable_id, $_SESSION['user_id']);

        // search if there is a claim from the pa to Minagate;
        $filterObj = new stdClass();
        $filterObj->filter = new stdClass();
        $filterObj->filter->pa_id = $pa_id;
        $filterObj->filter->payee_reference_code = $tenderPayableBean->company_id;
        $filterObj->filter->claim_type = "AP_CLAIM";
        $filterObj->filter->status = "NEW";
        $claimsReuslt =  $this->_fps->searchClaims($filterObj, 0);

        // in case no claim is found, create one
        if ($claimsReuslt->found_rows == 0) {
            // reference object
            $data = new stdClass();
            $data->reference = new stdClass();
            $data->reference->reference_code = "COMPANY";
            $data->reference->reference_value = $tenderPayableBean->company_id;

            // claim details
            $claim_details = new stdClass();
            $claim_details->claim_type = "AP_CLAIM";
            $claim_details->tender_id = $waybillBean->document->tender->id;
            $claim_details->pa_id = $pa_id;
            // $claim_details->ledger_account_sub_id =  $tn; // truck

            // payments
            $claim_details->payments = [];
            $data->claim_details = $claim_details;
            $data->ledger_account_id = "590000"; // Minagate

            // call fps system to create claim
            $claim_id = $this->_fps->createClaim($data, $_SESSION['user_id']);
        } else {
            $claim_id = $claimsReuslt->data[0]->id;
        }

        // append new Item to this claim
        $itemBean = new stdClass();
        $itemBean->claim_id = $claim_id;
        $itemBean->status = "NEW";
        $itemBean->create_date = date("Y-m-d h:m:s");
        $itemBean->details = new stdClass();
        $itemBean->details->tn = $waybillBean->document->carrier[0]->truck->tn;
        $itemBean->details->amount = $claim_amount;
        $itemBean->details->wn = $waybillBean->wn;
        $itemBean->details->waybill_id = $waybillBean->id;
        $itemBean->details->tender_id = $waybillBean->tender_id;
        $itemBean->details->tender_name = $waybillBean->document->tender->name;

        $item_id = $this->_fps->appendItemToClaim($itemBean, $_SESSION['user_id']);
        return $item_id;
    }


    // -----------------------------------------------------------------------------------------------------------//
    // -------------- Search if the claim item can be added automaticly yo suitable claim ----------------------- //
    // -----------------------------------------------------------------------------------------------------------//
    public function checkARClaims()
    {
        // get user input
        $tender_item_id = $this->_request->id;

        // get claimItem to extract loading month and cargo // TODO
        $tenderClaimItems = $this->_tenderClaimCore->getTenderClaimItem($tender_item_id, $_SESSION['user_id']);

        $claim_loading_date = $tenderClaimItems->details->claim_loading_date;
        $cargo_id = $tenderClaimItems->details->cargo_id;

        //make sure the calculate freight is applicable
        $waybillBean = $this->_waybillCore->getWaybillBasic($tenderClaimItems->waybill_id, $_SESSION['user_id']);
        $details = $tenderClaimItems->details;

        $routeWage =  $this->_routeWageCore->searchWageForFreight(
            $waybillBean->tender_id,
            $details->claim_origin_id,
            $details->claim_destination_id,
            $details->claim_cargo_id ? $details->claim_cargo_id : $details->cargo_id,
            $details->claim_loading_date,
            "receivable",
            false,
            $waybillBean
        );


        // search if matched claim can be found
        $AR_claim_filter = [
            ['key' => 'claim_details', 'val' => '"waybill_claim"', 'op' => 'json unquote', 'node' => '$.claim_type'],
            ['key' => 'claim_details', 'val' => $cargo_id, 'op' => 'json unquote', 'node' => '$.cargo_id'],
            ['key' => 'status', 'val' => 'NEW'],
            ['key' => 'claim_details', 'val' => date("m", strtotime($claim_loading_date)), 'op' => 'json unquote', 'node' => '$.loading_month']
        ];

        $claimsReuslt = $this->_tenderClaimCore->searchTenderClaims($AR_claim_filter, 1, 0, $_SESSION['user_id'], ' order by id desc ');

        if ($claimsReuslt->found_rows == 0) {
            if (!$routeWage) {
                throw new Exception("لا يوجد تسعيرة");
            } else {
                throw new Exception("No Matched claim is found");
            }
        }

        // in case the user found a match, append the item to it
        $tender_claim_id = $claimsReuslt->data[0]->id;
        $waybill_info = new stdClass();
        $waybill_info->waybill_id = $tenderClaimItems->waybill_id;
        $waybill_info->claim_loading_date = $claim_loading_date;
        $waybill_info->claim_discharge_date = $tenderClaimItems->details->claim_discharge_date;
        $waybill_info->claim_loading_weight = $tenderClaimItems->details->claim_loading_weight;
        $waybill_info->claim_discharge_weight = $tenderClaimItems->details->claim_discharge_weight;
        $waybill_info->ref_num = $tenderClaimItems->details->ref_num;
        $waybill_info->claim_destination_id = $tenderClaimItems->details->claim_destination_id;
        $waybill_info->claim_destination_name = getLocationName($tenderClaimItems->details->claim_destination_id);
        $waybill_info->claim_origin_id = $tenderClaimItems->details->claim_origin_id;
        $waybill_info->claim_origin_name = getLocationName($tenderClaimItems->details->claim_origin_id);
        $waybill_info->claim_discharge_arrive_date = $tenderClaimItems->details->claim_discharge_arrive_date;
        $waybill_info->claim_cargo_id = $cargo_id;
        $waybill_info->claim_cargo_name = $this->_cargoCore->getCargoBasic($cargo_id, 0)->name;
        $waybill_info->allow = true;;
        $waybill_info->item_url = $tenderClaimItems->details->item_url;
        $waybill_info->tender_payable_id = $tenderClaimItems->details->tender_payable_id;

        $freightObj = $this->_paymentCore->calculateFreight(
            $waybillBean,
            $tenderClaimItems->details->claim_discharge_weight,
            $tenderClaimItems->details->claim_loading_weight,
            $routeWage
        );
        $waybill_info->freight = $freightObj;

        $this->_tenderClaimCore->appendWaybillToTenderClaim($tender_claim_id, $waybill_info, $_SESSION['u_id'], $_SESSION['user_id']);

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "TENDER_CLAIM.SUCCESSFUL_OPERATION";
        parent::response($Result);
    }



    // ------------------------------------------------------------------------------------------- //
    // -------------------- Move tender claim item from certain claim to another ----------------- //
    // ------------------------------------------------------------------------------------------- //
    public function moveClaimItem(){

        // get user params
        $tender_claim_item_id = $this->_request->tender_claim_item_id;
        $tender_claim_id = $this->_request->tender_claim_id;

        // validate if the target claim is still new
        $tenderClaimBean = $this->_tenderClaimCore->getTenderClaimBasic($tender_claim_id, $_SESSION['user_id']);
        $tenderClaimItemBean = $this->_tenderClaimCore->getTenderClaimItem($tender_claim_item_id, $_SESSION['user_id']);

        if (!$tenderClaimBean) {
            throw new Exception("رقم المطالبة غير صحيح");
        }
        if ($tenderClaimBean->status != "NEW") {
            throw new Exception("لا تستطيع المتابعة، المطالبة ليست بحالة جديد");
        }

        //update claim item to change tender_claim_id
        $this->_tenderClaimCore->moveClaimItem($tender_claim_item_id, $tender_claim_id, $_SESSION['u_id']);

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "تم نقل الوصل بنجاح للمطالبة رقم $tender_claim_id ";
        parent::response($Result);
    }


    // ------------------------------------------------------------------------------------------- //
    // -------------------- update policy number on certain tender_claim_item ----------------- //
    // ------------------------------------------------------------------------------------------- //
    public function updateRefNum()
    {

        // get user params
        $tender_claim_item_id = $this->_request->tender_claim_item_id;
        $ref_num = $this->_request->ref_num;

        if(!$ref_num){
            throw new Exception("رقم البوليصة غير صحيح");
        }

        // validate if the target claim is still new
        $tenderClaimItemBean = $this->_tenderClaimCore->getTenderClaimItem($tender_claim_item_id, $_SESSION['user_id']);
        if (!$tender_claim_item_id) {
            throw new Exception("رقم الوصل غير صحيح");
        }

        //update claim item to change tender_claim_id
        $this->_tenderClaimCore->updateRefNum($tender_claim_item_id , $ref_num,$_SESSION['u_id']);

        // get the AR_CLAIM for the same waybill and update the ref_num as well
        $itemFilter = [
            ['key' => 'waybill_id', 'val' => $tenderClaimItemBean->waybill_id],
            ['key' => "status", 'val' => ["ACTIVE", "APPROVED"], "op" => "in"]
        ];
        $items = $this->_tenderClaimCore->searchTenderClaimItems($itemFilter, 1000, 0, $_SESSION['user_id'], ' order by id desc ');
        foreach ($items->data as $item) {
            $details = json_decode($item->details);
            if($details->claim_type == "AR_claim"){
                $this->_tenderClaimCore->updateRefNum($item->id , $ref_num,$_SESSION['u_id']);
            }
        }

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "تم تعديل رقم الوصل بنجاح";
        parent::response($Result);
    }


     /*
        appendOrAudit waybill to claim from mobile
    */
    public function appendWaybillToARClaimForMobile()
    {
        $claim_loading_weight = $this->_request->loading_weight;
        $claim_loading_date = $this->_request->loading_timestamp;
        $claim_discharge_weight = $this->_request->discharge_weight;
        $claim_discharge_date = $this->_request->discharge_timestamp;
        $claim_discharge_arrive_date = $this->_request->discharge_arrive_date;
        $policy_num = $this->_request->policy_num;
        $cargo_id = $this->_request->cargo_id;

        $destination_id = $this->_request->destination_id;
        $origin_id = $this->_request->origin_id;
        $tender_payable_id = 1;
        $tender_id = 13;

        // $pa_id = $_SESSION['pa_id'];
        $pa_id = 7;

        $waybill_id = $this->_request->waybill_id;

        $this->_request = array(
            "claim_loading_weight"=>$claim_loading_weight,
            "claim_loading_date"=>$claim_loading_date,
            "claim_discharge_weight"=>$claim_discharge_weight,
            "claim_discharge_arrive_date"=>$claim_discharge_arrive_date,
            "claim_discharge_date"=>$claim_discharge_date,
            "policy_num"=>$policy_num,
            "cargo_id"=>$cargo_id,
            "destination_id"=>$destination_id,
            "origin_id"=>$origin_id,
            "tender_payable_id"=>$tender_payable_id,
            "pa_id"=>$pa_id,
            "waybill_id"=>$waybill_id,
            "ref_num"=>$policy_num,
            "tender_id"=>$tender_id
 
        );
        $this->appendWaybillToARClaim();

    }
}

new Claims_interface();
