<?php

// import objects
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/../../core/waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../../core/voucher/voucher_core.php");
require_once(dirname(__FILE__) . "/../../core/payment/payment_core.php");
require_once(dirname(__FILE__) . "/../../core/route_wage/route_wage_core.php");
require_once(dirname(__FILE__) . "/../../core/tender_company/tender_company_core.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/Jo_Petrol.php");
require_once(dirname(__FILE__) . "/../../core/waybill_draft/waybill_draft_core.php");

class TenderClaimCore
{

    private $_waybillCore;
    private $_paymentCore;
    private $_voucherCore;
    public function __construct()
    {
        DBConnection::getInstance();

        $this->_waybillCore = new WaybillCore();
        $this->_paymentCore = new PaymentCore();
        $this->_voucherCore = new VoucherCore();
        $this->_routeWageCore = new RouteWageCore();
    }

    // --------------------------------------------------------------------------------------- //
    // --------------------- get info for a certian sub account without activities ----------- //
    // -------------------------------------------------------------------------------------- //
    public function getTenderClaimAuthority($session, $type)
    {

        // inject filter auth in case of corporate session
        if (strtoupper($session['type']) == "CORPORATE" && $session['trucking_company_id'] && !$session['pa_id']) {

            if ($type == "id") {
                $ids = [];
                $claimsFilter = [['key' => 'trucking_company_id', 'val' => $session['trucking_company_id']]];

                // search for tender claim that match the trucking company
                $searchClaimsResult = DBConnection::searchDB("tender_claim", $claimsFilter, 10000, 0, $session['user_id']);
                foreach ($searchClaimsResult->data as $claim) {
                    $ids[] = $claim->id;
                }
                return $ids;
            } else {
                $claimsFilter = ['key' => 'trucking_company_id', 'val' => $session['trucking_company_id']];
                return $claimsFilter;
            }
        }
    }

    // ----------------------------------------------------------------- //
    // --------------- get Claim bean and fill it from DB  ------------- //
    // ----------------------------------------------------------------- //
    public function getTenderClaim($id, $user_id)
    {

        $claimBean = DBConnection::getObjectBean("tender_claim", $id, $user_id);
        return $claimBean;
    }

    // ------------------------------------------------------------------------- //
    // --------------- get Claim bean from database without activities --------- //
    // ------------------------------------------------------------------------- //
    public function getTenderClaimBasic($id, $user_id)
    {
        $claimBean = DBConnection::getBasicObjectBean("tender_claim", $id, $user_id);
        return $claimBean;
    }

    // ----------------------------------------------------------------- //
    // --------------- get Claim items and fill it from DB  ------------- //
    // ----------------------------------------------------------------- //
    public function getTenderClaimItems($id, $user_id, $offset = 0, $limit = 10000)
    {


        $sqlStatment = "SELECT 
                        id,
                        waybill_id,
                        voucher_id,
                        waybill_draft_id,
                        status,
                        CAST(details AS CHAR CHARSET UTF8) AS details,
                        CAST(requested_freight AS CHAR CHARSET UTF8) AS requested_freight,
                        CAST(approved_freight AS CHAR CHARSET UTF8) AS approved_freight,
                        ifnull(json_extract(details,'$.distination_name'),id) as destination
                        FROM  tender_claim_item
                        where tender_claim_id = ?
                        and status not in ('INACTIVE','REVOKED')
                        order by id desc  , voucher_id
                        limit $limit offset $offset ";
        $param = [$id];
        $itemResult = DBConnection::runBindDatabaseQuery($sqlStatment, $param);

        $output = [];


        foreach ($itemResult as $claim_item) {
            $details = new stdClass();
            $details = json_decode($claim_item->details);
            $requested_freight = json_decode($claim_item->requested_freight);
            $approved_freight = json_decode($claim_item->approved_freight);

            if ($details && gettype($details) == 'object') {
                $details->id = $claim_item->id;
                $details->waybill_id = $claim_item->waybill_id;
                $details->voucher_id = $claim_item->voucher_id;
                $details->waybill_draft_id = $claim_item->waybill_draft_id;
                $details->tender_claim_item_id = $claim_item->id;
                $details->status = $claim_item->status;
                $details->requested_freight = $requested_freight;
                $details->approved_freight = $approved_freight;
            } else if ($details && gettype($details) == 'array') {
                $details['id'] = $claim_item->id;
                $details['waybill_id'] = $claim_item->waybill_id;
                $details['voucher_id'] = $claim_item->voucher_id;
                $details['tender_claim_item_id'] = $claim_item->id;
                $details['waybill_draft_id'] = $claim_item->waybill_draft_id;
                $details['status'] = $claim_item->status;
                $details['requested_freight'] = $requested_freight;
                $details['approved_freight'] = $approved_freight;
            }

            $output[] = $details;
        }

        $itemResult = null;
        return $output;
    }

    // ----------------------------------------------------------------- //
    // --------------- get Claim items and fill it from DB  ------------- //
    // ----------------------------------------------------------------- //
    public function getTenderActiveClaimItems($id, $user_id, $offset = 0, $limit = 10000)
    {
        $sqlStatment = "SELECT 
                        id,
                        waybill_id,
                        voucher_id,
                        waybill_draft_id,
                        status,
                        CAST(details AS CHAR CHARSET UTF8) AS details,
                        CAST(requested_freight AS CHAR CHARSET UTF8) AS requested_freight,
                        CAST(approved_freight AS CHAR CHARSET UTF8) AS approved_freight,
                        ifnull(json_extract(details,'$.distination_name'),id) as destination
                        FROM  tender_claim_item
                        where tender_claim_id = ?
                        and status in ('ACTIVE')
                        order by id desc , voucher_id
                        limit $limit offset $offset ";
        $param = [$id];
        $itemResult = DBConnection::runBindDatabaseQuery($sqlStatment, $param);

        $output = [];

        foreach ($itemResult as $claim_item) {
            $details = new stdClass();
            $details = json_decode($claim_item->details);
            $requested_freight = json_decode($claim_item->requested_freight);
            $approved_freight = json_decode($claim_item->approved_freight);

            if ($details && gettype($details) == 'object') {
                $details->id = $claim_item->id;
                $details->waybill_id = $claim_item->waybill_id;
                $details->voucher_id = $claim_item->voucher_id;
                $details->waybill_draft_id = $claim_item->waybill_draft_id;
                $details->tender_claim_item_id = $claim_item->id;
                $details->status = $claim_item->status;
                $details->requested_freight = $requested_freight;
                $details->approved_freight = $approved_freight;
            } else if ($details && gettype($details) == 'array') {
                $details['id'] = $claim_item->id;
                $details['waybill_id'] = $claim_item->waybill_id;
                $details['voucher_id'] = $claim_item->voucher_id;
                $details['tender_claim_item_id'] = $claim_item->id;
                $details['waybill_draft_id'] = $claim_item->waybill_draft_id;
                $details['status'] = $claim_item->status;
                $details['requested_freight'] = $requested_freight;
                $details['approved_freight'] = $approved_freight;
            }

            $output[] = $details;
        }

        $itemResult = null;
        return $output;
    }

    // ----------------------------------------------------------------- //
    // --------------- get Claim items and fill it from DB  ------------- //
    // ----------------------------------------------------------------- //
    public function getTenderClaimItem($id, $user_id)
    {
        $itemBean = DBConnection::getBasicObjectBean("tender_claim_item", $id, $user_id);
        return $itemBean;
    }

    // ------------------------------------------------------------------------ //
    // --------------------- search for tender claim items  ------------------- //
    // ------------------------------------------------------------------------ //
    public function searchTenderClaimItems($searchFilter, $limit, $offset, $user_id, $order_by = null)
    {

        $searchClaimsResult = DBConnection::searchDB("tender_claim_item", $searchFilter, $limit, $offset, $user_id, $order_by);
        return $searchClaimsResult;
    }

    // ------------------------------------------------------------------------ //
    // --------------- search for claims using any search filter -------------- //
    // ------------------------------------------------------------------------ //
    public function searchTenderClaims($searchFilter, $limit, $offset, $user_id, $order_by = null)
    {

        $searchClaimsResult = DBConnection::searchDB("tender_claim", $searchFilter, $limit, $offset, $user_id, $order_by);
        return $searchClaimsResult;
    }

    // -------------------------------------------------------------------- //
    // -------------------- Change status of a certain claim -------------- //
    // -------------------------------------------------------------------- //
    public function createTenderClaim($tender_claim_bean, $user_id)
    {

        // prepare variables
        $tender_company_id = $tender_claim_bean->tender_company_id;
        $ref = $tender_claim_bean->ref;
        $tenderClaimAmount = 0;
        $claim_type = $tender_claim_bean->claim_type;
        // validate all waybills if can be inserted in this tender claim
        $this->validateTenderClaimForCreate($tender_claim_bean);


        // DBConnection::startTransaction();
        $tenderCompanyCore = new TenderCompanyCore();
        $tenderCompanySearchFilter = [['key' => 'id', 'val' => $tender_company_id]];
        $tenderCompaniesReuslt = $tenderCompanyCore->searchTenderCompany($tenderCompanySearchFilter, 1, 0, $user_id);
        $tenderCompanyBean = $tenderCompaniesReuslt->data[0];


        // create the record in DB
        $tenderClaimBean = new stdClass();
        $tender_claim_details = new stdClass();
        $tender_claim_details->ref = $ref;
        $tender_claim_details->company_name = $tenderCompanyBean->name;
        $tender_claim_details->tender_company_id = $tender_company_id;
        $tender_claim_details->trucking_company_id = $tenderCompanyBean->trucking_company_id;
        $tender_claim_details->amount = $tenderClaimAmount;
        $tender_claim_details->claim_type = $claim_type;
        $tenderClaimBean->tender_company_id = $tender_company_id;
        // check the type of claim and init the appropriate json
        if ($claim_type == "voucher_claim") {
            $tenderClaimBean->waybill_details = $this->initVoucherJson();
        } else if ($claim_type == "waybill_claim") {
            $tenderClaimBean->waybill_details = ["body" => [], "header" => []];
        } else if ($claim_type == "AR_claim") {
            $tender_claim_details->pa_id = $tender_claim_bean->pa_id;
            $tender_claim_details->pa_name = $tender_claim_bean->pa_name;
            $tender_claim_details->trucking_company_id = $tender_company_id;
            $tender_claim_details->company_name = $tender_claim_bean->pa_name;
            $tender_claim_details->beneficiary_name = "";
            $tenderClaimBean->waybill_details = ["body" => [], "header" => []];
        }

        $tenderClaimBean->claim_details = $tender_claim_details;

        $tenderClaimBean->status = "NEW";
        $tenderClaimBean->ca_id = $tender_claim_bean->ca_id;
        $tenderClaimBean->tender_payable_id = $tender_claim_bean->tender_payable_id;
        $tenderClaimBean->pa_id = $tender_claim_bean->pa_id;

        $createTenderClaimResult = DBConnection::insertDB("tender_claim", $tenderClaimBean, $user_id);
        $claim_id = $createTenderClaimResult[0]['@id'];

        return $claim_id;
    }

    // -------------------------------------------------------------------------------- //
    // --------------- append new waybill to a certain tender claim ------------------- //
    // ------------- this method is used in add waybill in single mode ---------------- //
    // -------------------------------------------------------------------------------- //
    public function appendWaybillToTenderClaim($tender_claim_id, $waybill_info, $u_id, $user_id)
    {

        // get the tender_claim bean
        $tenderClaimBean = $this->getTenderClaimBasic($tender_claim_id, $user_id);

        $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_info->waybill_id, 0);
        $tenderClaimAmount = $tenderClaimBean->claim_details->amount;

        // validate new waybill if can be inserted in this tender claim
        if ($tenderClaimBean->claim_details->claim_type == "waybill_claim") {
            $this->validateTenderClaimForEdit($tender_claim_id, $waybill_info, $tenderClaimBean, $user_id, false);
        }

        if ($tenderClaimBean->claim_details->claim_type == "waybill_claim") {
            $filter = [
                ['key' => 'waybill_id', 'val' => $waybill_info->waybill_id],
                ['key' => 'details', 'val' => '"waybill_claim"', 'op' => 'json unquote', 'node' => '$.claim_type'],
                ['key' => 'status', 'val' => ['INACTIVE', 'REVOKED'], 'op' => 'not in']
            ];
        } else {
            $filter = [
                ['key' => 'waybill_id', 'val' => $waybill_info->waybill_id],
                ['key' => 'details', 'val' => '"AR_claim"', 'op' => 'json unquote', 'node' => '$.claim_type'],
                ['key' => 'status', 'val' => ['INACTIVE', 'REVOKED'], 'op' => 'not in'],
                ['key' => 'details', 'val' => $waybill_info->tender_payable_id, 'op' => 'json unquote', 'node' => '$.tender_payable_id'],
            ];
        }

        $tenderClaimItems = $this->searchTenderClaimItems($filter, 1, 0, $user_id, null);

        if (sizeof($tenderClaimItems->data) > 0) {
            $item = $tenderClaimItems->data[0];
            throw new Exception("المستند مضاف مسبقا على المطالبة رقم $item->tender_claim_id");
        }

        // prepare waybill JSON
        $waybillDetails = new stdClass();
        $waybillDetails->wn = $waybillBean->wn;
        $waybillDetails->tn = $waybillBean->document->carrier[0]->truck->tn;
        $waybillDetails->trn = $waybillBean->document->carrier[0]->trailer->tn;
        $waybillDetails->driver_id = $waybillBean->document->carrier[0]->driver->id;
        $waybillDetails->driver_name = $waybillBean->document->carrier[0]->driver->name;
        $waybillDetails->claim_origin_id =  $waybill_info->claim_origin_id;
        $waybillDetails->claim_origin_name =  $waybill_info->claim_origin_name;
        $waybillDetails->claim_cargo_id =  $waybill_info->claim_cargo_id;
        $waybillDetails->claim_cargo_name =  $waybill_info->claim_cargo_name;
        $waybillDetails->destination_id = $waybillBean->document->negotiable_instructios->route->destination->id;
        $waybillDetails->destination_name =  $waybillBean->document->negotiable_instructios->route->destination->name;
        $waybillDetails->claim_destination_id = $waybill_info->claim_destination_id;
        $waybillDetails->claim_destination_name =  $waybill_info->claim_destination_name;
        $waybillDetails->tc_name = $waybillBean->document->carrier[0]->tc->name;
        $waybillDetails->claim_discharge_date = $waybill_info->claim_discharge_date;
        $waybillDetails->claim_discharge_weight = $waybill_info->claim_discharge_weight;
        $waybillDetails->claim_loading_date = $waybill_info->claim_loading_date;
        $waybillDetails->claim_loading_weight = $waybill_info->claim_loading_weight;
        $waybillDetails->discharge_date = $waybillBean->document->cargo[0]->weights->discharge->time_stamp;
        $waybillDetails->discharge_permit_num = $waybillBean->document->integeration_details->jo_petrol->discharge_permit_num;
        $waybillDetails->discharge_weight = $waybillBean->document->cargo[0]->weights->discharge->net_weight;
        $waybillDetails->loading_date = $waybillBean->document->cargo[0]->weights->loading->time_stamp;
        $waybillDetails->jo_petrol_policy_num = $waybillBean->document->integeration_details->jo_petrol->jo_petrol_policy_num;
        $waybillDetails->loading_weight = $waybillBean->document->cargo[0]->weights->loading->net_weight;
        $waybillDetails->ref_num = $waybill_info->ref_num;
        $waybillDetails->claim_type = $tenderClaimBean->claim_details->claim_type;
        $waybillDetails->cargo_id =  $waybillBean->document->cargo[0]->cargo->id;
        $waybillDetails->cargo_name =  $waybillBean->document->cargo[0]->cargo->name;
        $waybillDetails->claim_discharge_arrive_date = $waybill_info->claim_discharge_arrive_date;
        $waybillDetails->activites = null;
        $waybillDetails->item_url = $waybill_info->item_url;
        $waybillDetails->wn_date = $waybillBean->create_date;
        $waybillDetails->tender_payable_id = $waybill_info->tender_payable_id;

        // financial info
        if ($waybill_info->freight && $waybill_info->freight->amount && $waybill_info->freight->amount->net_amount) {
            $requested_freight = $waybill_info->freight->amount;
            $tenderClaimAmount += $waybill_info->freight->amount->net_amount;
        }

        //update claim amount
        $tenderClaimBean->claim_details->amount = $tenderClaimAmount;

        //search for the item with same waybill id in ar claim
        $searchFilter = [
            ['key' => 'waybill_id', 'val' => $waybillBean->id],
            ['key' => 'details', 'val' => '"AR_claim"', 'op' => 'json unquote', 'node' => '$.claim_type'],
            ['key' => 'status', 'val' => ['ACTIVE', 'APPROVED'], 'op' => 'in']
        ];

        $tenderClaimItems = $this->searchTenderClaimItems($searchFilter, 1, 0, 0, " order by id desc ");
        if (sizeof($tenderClaimItems->data) > 0) {
            $waybillDetails->previous_item_id = $tenderClaimItems->data[0]->id;
        }

        //update database record
        DBConnection::updateDB("tender_claim", $tenderClaimBean, $user_id);
        // add new tender claim item
        $insertSql = "INSERT INTO `waybill`.`tender_claim_item` (`tender_claim_id`, `waybill_id`, `details`, `status`, `update_by`,`requested_freight`) VALUES
                                                       (?, ?, ?, ?, ?,?)";
        $param = [$tender_claim_id, $waybill_info->waybill_id, json_encode($waybillDetails, JSON_UNESCAPED_UNICODE), "ACTIVE", $u_id, json_encode($requested_freight, JSON_UNESCAPED_UNICODE)];
        DBConnection::runBindDatabaseQuery($insertSql, $param);

        // lock the new waybill to prevent it from being added to another claim
        $this->_waybillCore->lockWaybillForTenderClaim($waybill_info->waybill_id, $tenderClaimBean);

        if (sizeof($tenderClaimItems->data) > 0) {
            // update AR claim item with approved freight
            $item = $tenderClaimItems->data[0];
            $this->updateApprovedFreight($item->id, $waybillDetails, $requested_freight);

            ////////////////////////////////////////////////////
            $details = json_decode($tenderClaimItems->data[0]->details);
            if ($details->claim_discharge_weight != $waybillDetails->claim_discharge_weight) {
                $this->addNoteToARClaim($waybill_info->waybill_id, "تم تغيير وزن التفريغ من $details->claim_discharge_weight الى $waybillDetails->claim_discharge_weight", $user_id);
            } else if ($details->claim_loading_weight != $waybillDetails->claim_loading_weight) {
                $this->addNoteToARClaim($waybill_info->waybill_id, "تم تغيير وزن التحميل من $details->claim_loading_weight الى $waybillDetails->claim_loading_weight", $user_id);
            } else if ($details->claim_loading_date  != $waybillDetails->claim_loading_date) {
                $this->addNoteToARClaim($waybill_info->waybill_id, "تم تغيير تاريخ التحميل من $details->claim_loading_date  الى $waybillDetails->claim_loading_date", $user_id);
            } else if ($details->claim_discharge_date != $waybillDetails->claim_discharge_date) {
                $this->addNoteToARClaim($waybill_info->waybill_id, "تم تغيير تاريخ التفريغ من $details->claim_discharge_date  الى $waybillDetails->claim_discharge_date", $user_id);
            } else if ($details->claim_destination_id != $waybillDetails->claim_destination_id) {
                $this->addNoteToARClaim($waybill_info->waybill_id, "تم تغيير وجهة التفريغ من $details->claim_destination_name  الى $waybillDetails->claim_destination_name", $user_id);
            }
        }
    }


    // -------------------------------------------------------------------------------- //
    // --------------- append new waybill_draft to a certain tender claim ------------------- //
    // ------------- this method is used in add waybill in single mode ---------------- //
    // -------------------------------------------------------------------------------- //
    public function appendWaybillDraftToTenderClaim($tender_claim_id, $waybill_info, $u_id, $user_id)
    {

        $waybillDraft = new waybillDraftCore();

        // get the tender_claim bean
        $tenderClaimBean = $this->getTenderClaimBasic($tender_claim_id, $user_id);
        $waybillBean = $waybillDraft->getWaybillDraft($waybill_info->waybill_id);
        $waybillBean->document =  json_decode($waybillBean->document);
        //validate
        $this->validateTenderClaimForEdit($tender_claim_id, $waybill_info, $tenderClaimBean, $user_id, true);
        $tenderClaimAmount = $tenderClaimBean->claim_details->amount;
        $filter = [
            ['key' => 'waybill_draft_id', 'val' => $waybill_info->waybill_id],
            ['key' => 'details', 'val' => '"waybill_claim"', 'op' => 'json unquote', 'node' => '$.claim_type'],
            ['key' => 'status', 'val' => 'ACTIVE']
        ];
        $tenderClaimItems = $this->searchTenderClaimItems($filter, 1, 0, $user_id, null);
        if (sizeof($tenderClaimItems->data) > 0) {
            $item = $tenderClaimItems->data[0];
            throw new Exception("المستند مضاف مسبقا على المطالبة رقم $item->tender_claim_id");
        }

        // prepare waybill JSON
        $waybillDetails = new stdClass();
        $waybillDetails->wn = $waybillBean->wn;
        $waybillDetails->tn = $waybillBean->document->carrier[0]->truck->tn;
        $waybillDetails->trn = $waybillBean->document->carrier[0]->trailer->tn;
        $waybillDetails->driver_id = $waybillBean->document->carrier[0]->driver->id;
        $waybillDetails->driver_name = $waybillBean->document->carrier[0]->driver->name;
        $waybillDetails->claim_cargo_id =  $waybill_info->claim_cargo_id;
        $waybillDetails->claim_cargo_name =  $waybill_info->claim_cargo_name;
        $waybillDetails->origin_id = $waybillBean->document->negotiable_instructios->route->origin->id;
        $waybillDetails->origin_name =  $waybillBean->document->negotiable_instructios->route->origin->name;
        $waybillDetails->claim_origin_id =  $waybill_info->claim_origin_id;
        $waybillDetails->claim_origin_name =  $waybill_info->claim_origin_name;
        $waybillDetails->destination_id = $waybillBean->document->negotiable_instructios->route->destination->id;
        $waybillDetails->destination_name =  $waybillBean->document->negotiable_instructios->route->destination->name;
        $waybillDetails->claim_destination_id = $waybill_info->claim_destination_id;
        $waybillDetails->claim_destination_name =  $waybill_info->claim_destination_name;
        $waybillDetails->tc_name = $waybillBean->document->carrier[0]->tc->name;
        // financial info
        if ($waybill_info->freight) {
            $requested_freight = $waybill_info->freight->amount;
            $tenderClaimAmount += $waybill_info->freight->amount->net_amount;
        }
        $waybillDetails->claim_discharge_date = $waybill_info->claim_discharge_date;
        $waybillDetails->claim_discharge_weight = $waybill_info->claim_discharge_weight;
        $waybillDetails->claim_loading_date = $waybill_info->claim_loading_date;
        $waybillDetails->claim_loading_weight = $waybill_info->claim_loading_weight;
        $waybillDetails->discharge_date = $waybillBean->document->cargo[0]->weights->discharge->time_stamp;
        $waybillDetails->discharge_permit_num = $waybillBean->document->integeration_details->jo_petrol->discharge_permit_num;
        $waybillDetails->discharge_weight = $waybillBean->document->cargo[0]->weights->discharge->net_weight;
        $waybillDetails->loading_date = $waybillBean->document->cargo[0]->weights->loading->time_stamp;
        $waybillDetails->jo_petrol_policy_num = $waybillBean->document->integeration_details->jo_petrol->jo_petrol_policy_num;
        $waybillDetails->loading_weight = $waybillBean->document->cargo[0]->weights->loading->net_weight;
        $waybillDetails->ref_num = $waybill_info->ref_num;
        $waybillDetails->claim_type = $tenderClaimBean->claim_details->claim_type;
        $waybillDetails->cargo_id =  $waybill_info->cargo_id ? $waybill_info->cargo_id : $waybillBean->document->cargo[0]->cargo->id;
        $waybillDetails->cargo_name =  $waybill_info->cargo_name ? $waybill_info->cargo_name : $waybillBean->document->cargo[0]->cargo->name;
        $waybillDetails->claim_discharge_arrive_date = $waybill_info->claim_discharge_arrive_date;
        $waybillDetails->activites = null;
        $waybillDetails->item_url = $waybill_info->item_url;
        $waybillDetails->wn_date = $waybillBean->create_date;

        $tenderClaimBean->claim_details->amount = $tenderClaimAmount;

        //update database record
        DBConnection::updateDB("tender_claim", $tenderClaimBean, $user_id);
        // add new tender claim item
        $insertSql = "INSERT INTO `waybill`.`tender_claim_item` (`tender_claim_id`, `waybill_draft_id`, `details`, `status`, `update_by`,`requested_freight`) VALUES
                                    (?, ?, ?, ?, ?, ?)";

        $param = [$tender_claim_id, $waybill_info->waybill_id, json_encode($waybillDetails, JSON_UNESCAPED_UNICODE), "ACTIVE", $u_id, json_encode($requested_freight, JSON_UNESCAPED_UNICODE)];
        $result = DBConnection::runBindDatabaseQuery($insertSql, $param);
    }



    // -------------------------------------------------------------------- //
    // --------------- remove waybill from tender claim ------------------- //    
    // -------------------------------------------------------------------- //
    public function removeWaybillFromTenderClaim($tender_claim_id, $waybill_id, $user_id)
    {
        // inactive the tender claim item record
        //CHANGE ITEMS OF THIS WAYBILL IN AR_claim
        $filter = [
            ['key' => 'waybill_id', 'val' => $waybill_id],
            ['key' => 'status', 'val' => 'ACTIVE'],
            ['key' => 'tender_claim_id', 'val' => $tender_claim_id]
        ];
        $tenderClaimItems = $this->searchTenderClaimItems($filter, 1, 0, $user_id, null);

        if ($tenderClaimItems->found_rows > 0) {
            $tenderClaimItem = $tenderClaimItems->data[0];
            $tenderClaimItem->status = "INACTIVE";
            DBConnection::updateDB("tender_claim_item", $tenderClaimItem, $user_id);

            // update total amount
            $tenderClaimBean = $this->getTenderClaimBasic($tender_claim_id, $user_id);
            $tenderClaimAmount = $tenderClaimBean->claim_details->amount;
            $claim_item_amount = json_decode($tenderClaimItem->requested_freight)->net_amount;
            $tenderClaimAmount = floatval($tenderClaimAmount - $claim_item_amount);
            $tenderClaimBean->claim_details->amount = $tenderClaimAmount;
            DBConnection::updateDB("tender_claim", $tenderClaimBean, 0);

            // unlock or release its waybills
            $this->_waybillCore->unlockWaybillForTenderClaim($waybill_id, $tenderClaimBean);

            // remove the same waybill from the AR_CLAIM 
            $filter = [
                ['key' => 'waybill_id', 'val' => $waybill_id],
                ['key' => 'status', 'val' => 'ACTIVE'],
                ['key' => 'details', 'val' => '"AR_claim"', 'op' => 'json unquote', 'node' => '$.claim_type']
            ];
            $arTenderClaimItems = $this->searchTenderClaimItems($filter, 1, 0, $user_id, null);
            if ($arTenderClaimItems->found_rows > 0) {
                $arTenderClaimItem = $arTenderClaimItems->data[0];
                $arTenderClaimItem->status = "INACTIVE";          
                DBConnection::updateDB("tender_claim_item", $arTenderClaimItem, $user_id);
            }
        }
    }


    // -------------------------------------------------------------------- //
    // --------------- remove waybill from tender claim ------------------- //    
    // -------------------------------------------------------------------- //
    public function removeWaybillDraftFromTenderClaim($tender_claim_id, $waybill_draft_id, $user_id)
    {
        // inactive the tender claim item record
        //CHANGE ITEMS OF THIS WAYBILL IN AR_claim
        $filter = [
            ['key' => 'waybill_draft_id', 'val' => $waybill_draft_id],
            ['key' => 'status', 'val' => 'ACTIVE'],
            ['key' => 'tender_claim_id', 'val' => $tender_claim_id]
        ];
        $tenderClaimItems = $this->searchTenderClaimItems($filter, 1, 0, $user_id, null);

        if ($tenderClaimItems->found_rows > 0) {
            $tenderClaimItem = $tenderClaimItems->data[0];
            $tenderClaimItem->status = "INACTIVE";
            DBConnection::updateDB("tender_claim_item", $tenderClaimItem, $user_id);

            // update total amount
            $tenderClaimBean = $this->getTenderClaimBasic($tender_claim_id, $user_id);
            $tenderClaimAmount = $tenderClaimBean->claim_details->amount;
            $claim_item_amount = json_decode($tenderClaimItem->requested_freight)->net_amount;
            $tenderClaimAmount = floatval($tenderClaimAmount - $claim_item_amount);
            $tenderClaimBean->claim_details->amount = $tenderClaimAmount;
            DBConnection::updateDB("tender_claim", $tenderClaimBean, 0);
        }
    }


    // ------------------------------------------------------------------------------------------ //
    // --------------------- Revoke certain waybill from AR claim ------------------------------- //
    // ------------------------------------------------------------------------------------------ //
    public function revokeWaybillFromTenderClaim($tender_claim_id, $tender_claim_item_id, $remarks, $user_id)
    {

        $tenderClaimItemBean = $this->getTenderClaimItem($tender_claim_item_id, $user_id);

        try {

            DBConnection::startTransaction();

            // revoke the item record
            $tenderClaimItemBean->status = "REVOKED";

            // update total amount
            $tenderClaimBean = $this->getTenderClaimBasic($tender_claim_id, $user_id);
            $tenderClaimAmount = $tenderClaimBean->claim_details->amount;

            $tenderClaimAmount -= $tenderClaimItemBean->requested_freight->net_amount;
            $tenderClaimBean->claim_details->amount = $tenderClaimAmount;
            DBConnection::updateDB("tender_claim", $tenderClaimBean, 0);

            // unlock or release its waybills
            $this->_waybillCore->unlockWaybillForTenderClaim($tenderClaimItemBean->waybill_id, $tenderClaimBean);

            // add note
            $note = new stdClass();
            $note->note = "تم رفض الوصل ، السبب: " . $remarks;
            $date = new DateTime();
            $note->timestamp = $date->format('Y-m-d h:m');

            $details = $tenderClaimItemBean->details;
            if ($details && $details->activites) {
                $oldActivites = $details->activites;
                array_push($oldActivites, $note);
                $details->activites = $oldActivites;
                $tenderClaimItemBean->details = $details;
            } else {
                $details->activites = [$note];
                $tenderClaimItemBean->details = $details;
            }

            DBConnection::updateDB("tender_claim_item", $tenderClaimItemBean, 0);
            DBConnection::commitTransaction();
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------------------------------------- //
    // --------------- append new voucher to a certain tender claim ------------------- //
    // ------------- this method is used in add voucher in single mode ---------------- //
    // -------------------------------------------------------------------------------- //
    public function appendVoucherToTenderClaim($tender_claim_id, $voucher_info, $u_id, $user_id)
    {

        // get the tender_claim bean
        $tenderClaimBean = $this->getTenderClaimBasic($tender_claim_id, $user_id);

        $tenderClaimAmount = $tenderClaimBean->claim_details->amount;

        // validate new voucher if can be inserted in this tender claim
        $this->validateTenderClaimForEditVoucher($tenderClaimBean, $voucher_info);

        DBConnection::startTransaction();

        // prepare voucher json
        $voucherJson = $this->generateVoucherJson($voucher_info, $user_id);
        $tenderClaimAmount += $voucher_info->amount;

        // prepare claim json
        $tenderClaimBean->claim_details->amount = $tenderClaimAmount;

        // insert into tender claim item
        $insertSql = "INSERT INTO `waybill`.`tender_claim_item` (`tender_claim_id`, `voucher_id`, `details`, `status`, `update_by`) VALUES 
                                                       (?, ?, ?, ?, ?)";

        $param = [$tender_claim_id, $voucher_info->voucher_id, json_encode($voucherJson, JSON_UNESCAPED_UNICODE), 'ACTIVE', $u_id];
        $result = DBConnection::runBindDatabaseQuery($insertSql, $param);

        //update database record
        DBConnection::updateDB("tender_claim", $tenderClaimBean, $user_id);

        // lock the new voucher to prevent it from being added to another claim
        $this->_voucherCore->lockVoucherWithTenderClaim($voucher_info->voucher_id, $tenderClaimBean->id);

        // save this info in Jo_petrol system
        $voucherBean = $this->_voucherCore->getVoucherBasic($voucher_info->voucher_id, 0);
        $waybill_id = $voucherBean->trx_template->ref_id;

        $jo_petrol = new Jo_petrol();
        $claim_number = $tenderClaimBean->claim_details->ref;
        $jo_petrol->saveWaybillClaimNumber($waybill_id, $claim_number);

        DBConnection::commitTransaction();
    }


    // -------------------------------------------------------------------- //
    // --------------- remove waybill from tender claim ------------------- //
    // -------------------------------------------------------------------- //
    public function removeVoucherFromTenderClaim($tender_claim_id, $voucher_id, $user_id)
    {

        DBConnection::startTransaction();

        // inactive the tender claim item record
        $updateSql = "update tender_claim_item set status = 'INACTIVE' where tender_claim_id=? and voucher_id=?";
        $param = [$tender_claim_id, $voucher_id];
        $result = DBConnection::runBindDatabaseQuery($updateSql, $param);

        // releae voucher
        $this->_voucherCore->releaseVoucherFromTenderClaim($voucher_id);

        // save this info in Jo_petrol system
        $voucherBean = $this->_voucherCore->getVoucherBasic($voucher_id, 0);
        $waybill_id = $voucherBean->trx_template->ref_id;
        $jo_petrol = new Jo_petrol();
        $claim_number = "-1";
        $response = $jo_petrol->saveWaybillClaimNumber($waybill_id, $claim_number);

        DBConnection::commitTransaction();
    }


    // --------------------------------------------------------------------------------- //
    // ----------------------- init new voucher json ---------------------------------- //
    // --------------------------------------------------------------------------------- //
    private function initVoucherJson()
    {
        $result = [];
        $result['body'] = [];
        $result['header'] = [
            "id",
            "from_account",
            "from_account_name",
            "target_account",
            "target_account_name",
            "amount",
            "status",
            "waybill_ref"
        ];

        return $result;
    }



    // -------------------------------------------------------------------------------------------------------------- //
    // ----------- generate JSON object that contains the waybill_details column in table tender_claim -------------- //
    // -------------------------------------------------------------------------------------------------------------- //
    private function generateVoucherJson($voucher_info, $user_id)
    {

        $id = $voucher_info->voucher_id;
        $from_account = $voucher_info->from_account;
        $from_account_name = $voucher_info->from_account_name;
        $target_account = $voucher_info->target_account;
        $target_account_name = $voucher_info->target_account_name;
        $amount = $voucher_info->amount;
        $status = $voucher_info->status;
        $waybill_ref = $voucher_info->waybill_ref;

        // build JSON object
        $voucherJson = [];
        $voucherJson[] = $id;
        $voucherJson[] = $from_account;
        $voucherJson[] = $from_account_name;
        $voucherJson[] =  $target_account;
        $voucherJson[] = $target_account_name;
        $voucherJson[] =  $amount;
        $voucherJson[] = $status;
        $voucherJson[] = $waybill_ref;
        // return it
        return $voucherJson;
    }

    // ----------------------------------------------------------------------------------------- //
    // ----------- validate if tender claim has everything needed to be created ---------------- //
    // ----------------------------------------------------------------------------------------- //
    private function validateTenderClaimForCreate($tenderClaimBean)
    {
        if (!$tenderClaimBean->tender_company_id) {
            throw new Exception("لم يتم تحديد شركة النقل في المطالبة");
        }
    }

    // ---------------------------------------------------------------------------------------------- //
    // ----------- validate certain waybills if can be inserted in this tender claim ---------------- //
    // ---------------------------------------------------------------------------------------------- //
    private function validateTenderClaimForEdit($tender_claim_id, $waybill_info, $tenderClaimBean, $user_id, $is_draft)
    {

        // search for the waybills        
        if (!$is_draft) {
            $waybillBean = $this->_waybillCore->getWaybillBasic($waybill_info->waybill_id, 0);
        } else {
            $waybillDraft = new waybillDraftCore();
            $waybillBean = $waybillDraft->getWaybillDraft($waybill_info->waybill_id);
        }

        $items = $this->getTenderClaimItems($tender_claim_id, 0, 0, 1000);
        if (sizeof($items) == 0 && $tenderClaimBean->claim_details->claim_type == "waybill_claim") {

            $tenderClaimBean->claim_details->cargo_id = $waybill_info->claim_cargo_id;
            $tenderClaimBean->claim_details->cargo_name = $waybill_info->claim_cargo_name;
            $tenderClaimBean->claim_details->loading_month = date("m", strtotime($waybill_info->claim_loading_date));
            $tenderClaimBean->claim_details->discharge_month = date("m", strtotime($waybill_info->claim_discharge_date));
            $tenderClaimBean->claim_details->destination_id = $waybill_info->claim_destination_id;
            $tenderClaimBean->claim_details->origin_id = $waybill_info->claim_origin_id;

            //update database record
            DBConnection::updateDB("tender_claim", $tenderClaimBean, $user_id);
        } else {
            $tenderCore = new TenderCore();
            $man = $tenderCore->getTenderManifest($waybillBean->tender_id, 0);
            $tender_code = $man['tender_code'];
            switch ($tender_code) {
                case "GRAINS":
                    if (date("m", strtotime($waybill_info->claim_loading_date)) != $tenderClaimBean->claim_details->loading_month) {
                        throw new Exception("لا يمكن أضافة وصل مغاير عن شهر تحميل المطالبة");
                    }
                    if ($tenderClaimBean->claim_details->cargo_id != $waybill_info->claim_cargo_id) {
                        throw new Exception("لا يمكن أضافة وصل مغاير عن نوع حمولة المطالبة");
                    }
                    break;
                case "JO_PETROL_AQ":
                    if (date("m", strtotime($waybill_info->claim_loading_date)) != $tenderClaimBean->claim_details->loading_month) {
                        throw new Exception("لا يمكن أضافة وصل مغاير عن شهر تحميل المطالبة");
                    }
                    break;
                case "PHOSPHATE_SILK_ROAD":
                    if (date("m", strtotime($waybill_info->claim_loading_date)) != $tenderClaimBean->claim_details->loading_month) {
                        throw new Exception("لا يمكن أضافة وصل مغاير عن شهر تحميل المطالبة");
                    }
                    if ($tenderClaimBean->claim_details->origin_id != $waybill_info->claim_origin_id) {
                        throw new Exception("لا يمكن أضافة وصل مغاير عن مكان تحميل المطالبة");
                    }
                    if ($tenderClaimBean->claim_details->destination_id != $waybill_info->claim_destination_id) {
                        throw new Exception("لا يمكن أضافة وصل مغاير عن وجهة المطالبة");
                    }
                    break;
                case "VESSELS":
                    if ($tenderClaimBean->claim_details->cargo_id != $waybill_info->claim_cargo_id) {
                        throw new Exception("لا يمكن أضافة وصل مغاير عن نوع حمولة المطالبة");
                    }
                    // if (date("m", strtotime($waybill_info->claim_loading_date)) != $tenderClaimBean->claim_details->loading_month) {
                    //     throw new Exception("لا يمكن أضافة وصل مغاير عن شهر تحميل المطالبة");
                    // }
                    break;
                default:
                    throw new Exception("مشروع غير معروف");
            }
        }
    }


    // ---------------------------------------------------------------------------------------------- //
    // ----------- validate certain waybills if can be inserted in this tender claim ---------------- //
    // ---------------------------------------------------------------------------------------------- //
    private function validateTenderClaimForEditVoucher($tenderClaimBean, $voucher_info)
    {
        $id = $voucher_info->voucher_id;
        // get basic object bean without any activites
        $DB_Bean = DBConnection::getBasicObjectBean("voucher", $id, 0);

        if ($DB_Bean &&  $DB_Bean->trx_template && $DB_Bean->trx_template->tender_claim) {
            $tender_claim = $DB_Bean->trx_template->tender_claim;
            throw new Exception("أمر الصرف مضاف مسبقا على المطالبة رقم $tender_claim");
        }
    }

    // -------------------------------------------------------------------------------------------------------------------------------- //
    // -----------------Approve certain tender_claim and lock all its waybills to prevent change in the waybills weights -------------- //
    // -------------------------------------------------------------------------------------------------------------------------------- //
    public function approveTenderClaim($tender_claim_id, $user_id)
    {


        $tenderClaimBean = $this->getTenderClaimBasic($tender_claim_id, $user_id);
        $claim_type = $tenderClaimBean->claim_details->claim_type;

        if ($claim_type == "voucher_claim") {

            // change claim status
            $this->changeStatus($tender_claim_id, "APPROVED", $user_id);
        } else if ($claim_type == "waybill_claim") {

            $tenderClaimBean->claim_details->isProcessingTenderClaim = true;
            $tenderClaimBean->status = "APPROVED";
            DBConnection::updateDB("tender_claim", $tenderClaimBean, $user_id);


            //for adel claims , proceed with financial tasks
            if ($tenderClaimBean->claim_details->trucking_company_id == 395) {
                $waybills = $this->getTenderClaimItems($tender_claim_id, $user_id, 0, 10000);
                $index = 0;
                // validate JV of all waybiils
                foreach ($waybills as $waybill) {
                    $lastTask = false;
                    if ($index == sizeof($waybills) - 1) {
                        $lastTask = true;
                    }
                    // create task to fill this info into waybill
                    $taskQueuesCore = new TaskQueuesCore();
                    $taskQueuesCore->createApproveClaimWaybillTask($waybill, $tender_claim_id, $lastTask);
                    $index++;
                }
            }
        } else if ($claim_type == "AR_claim") {
            $tenderClaimBean->status = "APPROVED";
            DBConnection::updateDB("tender_claim", $tenderClaimBean, $user_id);

            //for adel claims , proceed with financial tasks
            $waybills = $this->getTenderActiveClaimItems($tender_claim_id, $user_id, 0, 10000);
            // validate JV of all waybiils
            foreach ($waybills as $waybill) {
                // create task to fill this info into waybill
                if ($waybill->previous_item_id) {
                    $taskQueuesCore = new TaskQueuesCore();
                    $taskQueuesCore->createApproveARClaimWaybillTask($waybill, $tender_claim_id);
                }
            }
        }
    }

    // ------------------------------------------------------ //
    // -----------------complete tender claim  -------------- //
    // ------------------------------------------------------ //
    public function completeTenderClaim($tender_claim_id, $user_id)
    {
        // validate tender_claim for approve
        $this->validateForComplete($tender_claim_id, $user_id);

        $this->changeStatus($tender_claim_id, "COMPLETE", $user_id);
    }

    // ----------------------------------------------------------------------------------------------------------------------------- //
    // ----------------Revoke certain claim and unloack it waybills in order to make them available for another claim -------------- //
    // ----------------------------------------------------------------------------------------------------------------------------- //
    public function revokeTenderClaim($tender_claim_id, $user_id)
    {
        // get tenderClaimBean
        $tenderClaimBean = $this->getTenderClaimBasic($tender_claim_id, $user_id);

        //change status
        $this->changeStatus($tender_claim_id, "INACTIVE", $user_id);

        $claim_type = $tenderClaimBean->claim_details->claim_type;

        if ($claim_type == "voucher_claim") {

            //  release its vouchers
            $vouchers = $this->getTenderClaimItems($tender_claim_id, $user_id, 0, 10000);
            foreach ($vouchers as $voucher) {
                $this->removeVoucherFromTenderClaim($tender_claim_id, $voucher['voucher_id'], $user_id);
            }
        } else {

            // unlock or release its waybills
            $waybills = $this->getTenderClaimItems($tender_claim_id, $user_id, 0, 10000);
            foreach ($waybills as $waybill) {
                $this->removeWaybillFromTenderClaim($tender_claim_id, $waybill->waybill_id, $user_id);
            }
        }
    }

    // ------------------------------------------------------------- //
    // ---------------- submit tender claim for review -------------- //
    // -------------------------------------------------------------- //
    public function submitTenderClaim($tender_claim_id, $user_id)
    {



        // get tenderClaimBean
        $tenderClaimBean = $this->getTenderClaimBasic($tender_claim_id, $user_id);
        $claim_type = $tenderClaimBean->claim_details->claim_type;

        if ($claim_type == "voucher_claim") {

            //change status
        } else if ($claim_type == "AR_claim") {
            $filter = [
                ["key" => "tender_claim_id", "val" => $tender_claim_id],
                ["key" => "status", "val" => 'ACTIVE']
            ];
            $tenderClimItems = $this->searchTenderClaimItems($filter, 10000, 0, $user_id, null);

            if (sizeof($tenderClimItems->data) == 0) {
                throw new Exception("لايوجد مستندات على المطالبة");
            }
            if (sizeof($tenderClimItems->data) < 1) {
                throw new Exception("يجب ان تحوي المطالبة على الحد الأدنى من الوصولات ( مطالبة واحدة على الأقل)");
            }
        } else {
            // validate tender_claim for submit
            $this->validateForSubmit($tenderClaimBean, $user_id);
        }

        $this->changeStatus($tender_claim_id, "PENDING", $user_id);
    }

    // -------------------------------------------------------------------- //
    // -------------------- Change status of a certain claim -------------- //
    // -------------------------------------------------------------------- //
    public function changeStatus($tender_claim_id, $new_status, $user_id)
    {

        // get the tender_claim bean
        $tenderClaimBean = $this->getTenderClaimBasic($tender_claim_id, $user_id);

        // change tender_claim status
        $updateBean = new stdClass();
        $updateBean->id = $tender_claim_id;
        $updateBean->status = $new_status;
        DBConnection::updateDB("tender_claim", $updateBean, $user_id);
    }

    // ----------------------------------------------------------------------------------------------------------------------------- //
    // --------------- validate tender_claim for approval and make sure all the waybills in the claim have weights ----------------- //
    // ----------------------------------------------------------------------------------------------------------------------------- //
    private function validateForComplete($tender_claim_id, $user_id)
    {

        $items = $this->getTenderClaimItems($tender_claim_id, $user_id, 0, 10000);
        $waybill_ids = [];

        foreach ($items as $item) {
            $wn = $item->wn;
            $waybill_ids[] = $item->waybill_id;

            if (!$item->claim_loading_weight) {
                throw new Exception("لا تستطيع الموافقة على المطالبة ، المستند رقم $wn لا يملك وزن تحميل");
            }
            if (!$item->claim_discharge_weight) {
                throw new Exception("لا تستطيع الموافقة على المطالبة ، المستند رقم $wn لا يملك وزن تفريغ");
            }
        }

        // get all waybills to match its dstination with claim destination
        $waybills = $this->_waybillCore->searchWaybills([
            ['key' => 'id', 'val' => $waybill_ids, 'op' => 'in'],
        ], 10000, 0, 0);

        foreach ($waybills->data as $waybill) {
            foreach ($items as $item) {
                if ($item->waybill_id == $waybill->id) {
                    if ($waybill->destination_id != $item->claim_destination_id) {
                        throw new Exception("لا تستطيع المتابعة ، وجهة المستند $waybill->wn لا تطابق الوجهة في المطالبة");
                    }
                }
            }
        }
    }

    // ----------------------------------------------------------------------------------------------------------------------------- //
    // --------------- validate tender_claim for approval and make sure all the waybills in the claim have weights ----------------- //
    // ----------------------------------------------------------------------------------------------------------------------------- //
    private function validateForSubmit($tenderClaimBean, $user_id)
    {

        $waybills = $this->getTenderClaimItems($tenderClaimBean->id, $user_id);

        // validate the tender claim has at least 1 waybill
        if (!$waybills || sizeOf($waybills) == 0) {
            throw new Exception("لا تستطيع المتابعة ، المطالبة يجب ان تحتوي على مستند واحد على الأقل");
        }

        foreach ($waybills as $waybill) {
            $wn = $waybill->wn;

            if (!$waybill->claim_loading_weight) {
                throw new Exception("لا تستطيع تقديم المطالبة ، المستند رقم $wn لا يملك وزن تحميل");
            }
            if (!$waybill->claim_discharge_weight) {
                throw new Exception("لا تستطيع تقديم المطالبة ، المستند رقم $wn لا يملك وزن تفريغ");
            }
            if (!preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/", $waybill->claim_loading_date)) {
                //throw new Exception("لا تستطيع تقديم المطالبة ،تاريخ التحميل للمستند رقم $wn غير صحيح");
            }
            if (!preg_match("/^[0-9]{4}-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/", $waybill->claim_discharge_date)) {
                //throw new Exception("لا تستطيع تقديم المطالبة ،تاريخ التفريغ للمستند رقم $wn غير صحيح");
            }
        }
    }

    // ------------------------------------------------------------------------------------------------------- //
    // ------------------ search for vouchers to add to tender claim with policy num ------------------------- //
    // ------------------------------------------------------------------------------------------------------- //
    public function searchVoucherForTenderClaim($ref)
    {

        //search waybills
        $sqlQuery = " SELECT id
                    FROM waybill
                    WHERE JSON_UNQUOTE(JSON_EXTRACT(document,'$.integeration_details.jo_petrol.nfldnm')) = ?
                    and tender_id = 11
                    and create_date > '2021-01-01' ";
        $param[] = $ref;
        $data = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        if (sizeof($data) == 0) {
            $sqlQuery = " SELECT id
                    FROM waybill
                    WHERE JSON_UNQUOTE(JSON_EXTRACT(document,'$.integeration_details.jo_petrol.jo_petrol_policy_num')) = ? and tender_id = 11";
            $param2[] = $ref;
            $data = DBConnection::runBindDatabaseQuery($sqlQuery, $param2);
        }

        $waybillResult = new stdClass();
        $waybillResult->data = $data;
        $waybillResult->found_rows = sizeof($data);

        if ($waybillResult->found_rows > 0) {
            $waybill_id = $waybillResult->data[0]->id;

            // get the waybill id and search in vouchers with the same ref_id
            $voucherFilter = [
                ['key' => 'trx_template', 'val' => '"' . $waybill_id . '"', 'op' => 'json unquote', 'node' => '$.ref_id']
            ];

            $vouchers_qry = $this->_voucherCore->searchVouchers($voucherFilter, 1, 0, 0);

            if ($vouchers_qry->found_rows > 0) {
                // return response
                $resultVoucher = $vouchers_qry->data[0];
                $resultVoucher->trx_template = json_decode($resultVoucher->trx_template);
                return $resultVoucher;
            } else {
                throw new Exception("لا يوجد أمر صرف  للمستند");
            }
        } else {
            throw new Exception("لا يوجد مستند لرقم البوليصة");
        }
    }

    // ------------------------------------------------------------------------------------------------------- //
    // ------------------ search for vouchers to add to tender claim with policy num ------------------------- //
    // ------------------------------------------------------------------------------------------------------- //
    public function addNoteToARClaim($waybill_id, $notes, $user_id)
    {
        try {
            // search for waybill in pending items
            $filter = [
                ['key' => 'waybill_id', 'val' => $waybill_id],
                ['key' => 'details', 'val' => '"AR_claim"', 'op' => 'json unquote', 'node' => '$.claim_type'],
                ['key' => 'status', 'val' => 'ACTIVE']
            ];
            $tenderClaimItems = $this->searchTenderClaimItems($filter, 1, 0, $user_id, null);

            if (sizeof($tenderClaimItems->data) > 0) {
                $tenderClaimItem = $tenderClaimItems->data[0];
                $details = json_decode($tenderClaimItem->details);
                if ($details->activites) {
                    $oldActivites = $details->activites;
                    $note = new stdClass();
                    $note->note = $notes;
                    $date = new DateTime();
                    $note->timestamp = $date->format('Y-m-d h:m');
                    array_push($oldActivites, $note);
                    $details->activites = $oldActivites;
                    $tenderClaimItem->details = $details;
                } else {
                    $note = new stdClass();
                    $note->note = $notes;
                    $date = new DateTime();
                    $note->timestamp = $date->format('Y-m-d h:m');
                    $details->activites = [$note];
                    $tenderClaimItem->details = $details;
                }
                DBConnection::updateDB("tender_claim_item", $tenderClaimItem, $user_id);
            } else {
                throw new Exception("لا يوجد وصل مطابق لرقم المستند على مطالبات الذمم");
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // // ------------------------------------------------------------------------------------------------------- //
    // // ------------------ search for vouchers to add to tender claim with policy num ------------------------- //
    // // ------------------------------------------------------------------------------------------------------- //
    public function reCalculateFreight($tender_claim_item_id)
    {
        $item = $this->getTenderClaimItem($tender_claim_item_id, 0);
        $details = $item->details;
        $routeWageCore = new RouteWageCore();
        $waybillCore = new WaybillCore();

        $waybillBean = $waybillCore->getWaybillBasic($item->waybill_id, 0);
        $waybillBean->document->cargo[0]->weights->loading->time_stamp = $details->claim_loading_date;
        $waybillBean->document->cargo[0]->weights->discharge->time_stamp = $details->claim_discharge_date;
        $waybillBean->document->cargo[0]->weights->arrival = new stdClass();
        $waybillBean->document->cargo[0]->weights->arrival->time_stamp = $details->claim_discharge_arrive_date;

        $type = 'receivable';
        if ($details->claim_type == "AR_claim") {
            $type = 'payable';
        }

        $routeWage = $routeWageCore->searchWageForFreight(
            $waybillBean->tender_id,
            $details->claim_origin_id,
            $details->claim_destination_id,
            $details->claim_cargo_id ? $details->claim_cargo_id : $details->cargo_id,
            $details->claim_loading_date,
            $type,
            true,
            $waybillBean
        );

        $freight = $this->_paymentCore->calculateFreight($waybillBean, $details->claim_discharge_weight, $details->claim_loading_weight, $routeWage);

        // update with the new freight
        $item->requested_freight = $freight->amount;
        DBConnection::updateDB('tender_claim_item', $item, 0);


        // update if there is ar claim item with the same waybill id
        if ($details->claim_type == "waybill_claim") {
            $filter = [
                ['key' => 'waybill_id', 'val' => $item->waybill_id],
                ['key' => 'details', 'val' => '"AR_claim"', 'op' => 'json unquote', 'node' => '$.claim_type'],
                ['key' => 'status', 'val' => 'ACTIVE']
            ];
            $tenderClaimItems = $this->searchTenderClaimItems($filter, 1, 0, 0, null);

            if (sizeof($tenderClaimItems->data) > 0) {
                $routeWage = $routeWageCore->searchWageForFreight(
                    $waybillBean->tender_id,
                    $details->claim_origin_id,
                    $details->claim_destination_id,
                    $details->claim_cargo_id ? $details->claim_cargo_id : $details->cargo_id,
                    $details->claim_loading_date,
                    'payable',
                    true,
                    $waybillBean
                );

                $freight = $this->_paymentCore->calculateFreight($waybillBean, $details->claim_discharge_weight, $details->claim_loading_weight, $routeWage);
                $freight->amount->late_fine = $details->requested_freight->late_fine;
                $freight->amount->loss_fine = $details->requested_freight->loss_fine;
                $freight->amount->total_fines = $details->requested_freight->total_fines;
                $freight->amount->compensation = $details->requested_freight->compensation;
                $freight->amount->net_amount = $freight->amount->base_amount - $details->requested_freight->total_fines + $details->requested_freight->compensation;
                $freight->amount->loading_date = $details->claim_loading_date;
                $freight->amount->discharge_date = $details->claim_discharge_date;
                $freight->amount->cargo_name = $details->claim_cargo_name;
                $freight->amount->destination_name = getLocationName($details->claim_destination_id);
                $ar_item = $tenderClaimItems->data[0];
                $ar_item->approved_freight = $freight->amount;
                DBConnection::updateDB('tender_claim_item', $ar_item, 0);
            }
        }

        $Result['message'] = 'success';
        return $Result;
    }


    // // ------------------------------------------------------------------------------------------------------- //
    // // ------------------ search for vouchers to add to tender claim with policy num ------------------------- //
    // // ------------------------------------------------------------------------------------------------------- //
    public function updateApprovedFreight($ar_item_id, $details, $requested_freight)
    {
        $item = $this->getTenderClaimItem($ar_item_id, 0);
        $routeWageCore = new RouteWageCore();
        $waybillCore = new WaybillCore();
        $waybillBean = $waybillCore->getWaybillBasic($item->waybill_id, 0);
        $waybillBean->document->cargo[0]->weights->loading->time_stamp = $details->claim_loading_date;
        $waybillBean->document->cargo[0]->weights->loading->net_weight = $details->claim_loading_weight;
        $waybillBean->document->cargo[0]->weights->discharge->time_stamp = $details->claim_discharge_date;
        $waybillBean->document->cargo[0]->weights->discharge->net_weight = $details->claim_discharge_weight;
        $waybillBean->document->cargo[0]->weights->arrival = new stdClass();
        $waybillBean->document->cargo[0]->weights->arrival->time_stamp = $details->claim_discharge_arrive_date;
        //search route wage
        $routeWage = $routeWageCore->searchWageForFreight(
            $waybillBean->tender_id,
            $details->claim_origin_id,
            $details->claim_destination_id,
            $details->claim_cargo_id ? $details->claim_cargo_id : $details->cargo_id,
            $details->claim_loading_date,
            'payable',
            true,
            $waybillBean
        );

        $freight = $this->_paymentCore->calculateFreight($waybillBean, $details->claim_discharge_weight, $details->claim_loading_weight, $routeWage);
        $freight->amount->late_fine = $requested_freight->late_fine;
        $freight->amount->loss_fine = $requested_freight->loss_fine;
        $freight->amount->total_fines = $requested_freight->total_fines;
        $freight->amount->compensation = $requested_freight->compensation;
        if ($waybillBean->tender_id == 13) {
            $freight->amount->net_amount = $freight->amount->base_amount - $requested_freight->total_fines + $requested_freight->compensation;
        } else {
            $freight->amount->net_amount = $freight->amount->base_amount - $requested_freight->total_fines - $requested_freight->total_deductions + $requested_freight->compensation;
        }

        $freight->amount->loading_date = $details->claim_loading_date;
        $freight->amount->discharge_date = $details->claim_discharge_date;
        $freight->amount->cargo_name = $details->claim_cargo_name;
        $freight->amount->destination_name = getLocationName($details->claim_destination_id);
        // update with the new freight
        $item->approved_freight = $freight->amount;
        if (!$item->requested_freight) {
            $item->requested_freight = $freight->amount;
        }
        DBConnection::updateDB('tender_claim_item', $item, 0);

        $Result['message'] = 'success';
        return $Result;
    }

    // ---------------------------------------------------------------------------- //
    // ---------------- get tender payable ----------- //
    // ---------------------------------------------------------------------------- //
    public function getTenderPayable($id)
    {
        $sqlQuery = "
            select
            id,
            tender_id,
            company_id,
            company_name,
            CAST(`filter` AS CHAR CHARSET UTF8) AS filter,
            status,
            CAST(`deductions` AS CHAR CHARSET UTF8) AS deductions
             from tender_payable where id = $id";
        $result = DBConnection::runDatabaseQuery($sqlQuery);
        if (sizeof($result) > 0) {
            return $result[0];
        } else {
            throw new Exception("جهة المطالبة غير صحيحة");
        }
    }

    // ---------------------------------------------------------------------------- //
    // ---------------- get tender payable ----------- //
    // ---------------------------------------------------------------------------- //
    public function getTenderPayableCommissionAmount($id, $pa_id)
    {
        $commission = 0;
        $tenderPayable = $this->getTenderPayable($id);
        if ($tenderPayable->deductions) {
            $deductions = json_decode($tenderPayable->deductions);

            foreach ($deductions as $deduction) {
                if (key_exists('filter', $deduction)) {
                    foreach ($deduction->filter->pa_id as $key => $value) {
                        if ($value == $pa_id) {
                            $commission += $deduction->amount;
                        }
                    }
                } else {
                    if ($deduction->type == "FIXED")
                        $commission += $deduction->amount;
                }
            }
        }
        return $commission;
    }


    // get the name of tender payable
    public function getTenderPayableName($tender_payable_id)
    {

        $sqlQuery = " select company_name from tender_payable where id=?";
        $result = DBConnection::runBindDatabaseQuery($sqlQuery, [$tender_payable_id]);
        return $result[0]->company_name;
    }

    //  move item from claim to claim
    public function moveClaimItem($tender_claim_item_id, $tender_claim_id, $done_by)
    {
        $sqlQuery = " update tender_claim_item set tender_claim_id=? , update_by=? where id=?";
        $result = DBConnection::runBindDatabaseQuery($sqlQuery, [$tender_claim_id, $done_by, $tender_claim_item_id]);
    }

    //  update ref number of certain tender claim item
    public function updateRefNum($tender_claim_item_id, $ref_num, $done_by)
    {
        $sqlQuery = "update tender_claim_item set details = json_set(details,'$.ref_num',?) , update_by=? where id=?";
        $result = DBConnection::runBindDatabaseQuery($sqlQuery, [$ref_num, $done_by, $tender_claim_item_id]);
    }
}
