<?php
require_once(dirname(__FILE__) . "/../API.php");
require_once(dirname(__FILE__) . "/tender_core.php");
require_once(dirname(__FILE__) . "/../gateway/gateWay_core.php");
require_once(dirname(__FILE__) . "/../cargo/cargo_core.php");
require_once(dirname(__FILE__) . "/../assign_cargo/assign_cargo_core.php");
require_once(dirname(__FILE__) . "/../truck/truck_core.php");
require_once(dirname(__FILE__) . "/../waybill_order/waybill_order_core.php");
require_once(dirname(__FILE__) . "/../company/clearing_agent/clearing_agent_core.php");
require_once(dirname(__FILE__) . "/../notes/add_notes_core.php");
require_once(dirname(__FILE__) . "/../account/account_core.php");
require_once(dirname(__FILE__) . "/../tender_company/tender_company_core.php");
require_once(dirname(__FILE__) . "/../../includes/Captions.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/zain_cash.php");
require_once(dirname(__FILE__) . "/../taskQueues/taskQueues_core.php");
require_once(dirname(__FILE__) . "/../assign_cargo/assign_cargo_core.php");
require_once(dirname(__FILE__) . "/../location/location_core.php");
require_once(dirname(__FILE__) . "/../truck_routing/truck_routing_core.php");
require_once(dirname(__FILE__) . "/../waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/Jo_Petrol.php");
require_once(dirname(__FILE__) . "/../pa_route_wage/pa_route_wage_core.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/FPS.php");
require_once(dirname(__FILE__) . "/../outgoing_integration/chart_engine.php");

class Tender_interface extends API
{

    // the request of each call
    private $_request = array();
    private $_tenderCore;
    private $_gatewayCore;
    private $_cargoCore;
    private $_truckCore;
    private $_queueCore;
    private $_tenderCompanyCore;
    private $_truckContractCore;
    private $_UserCore;
    private $_truckOwnerCore;
    private $_waybillOrderCore;
    private $_accountCore;
    private $_zain_cash;
    private $_taskQueuesCore;
    private $_assignCargoCore;
    private $_locationCore;
    private $_truckRouteCore;
    private $_waybillCore;
    private $_jo_petrol;
    private $_paRouteWageCore;
    private $_customerCare;


    public function __construct()
    {
        // call the super constructur
        $this->_request = parent::__construct();

        session_start();
        if (!isset($_SESSION['user_id'])) {
            throw new Exception('No Session!');
        }

        // init the object
        $this->_tenderCore = new TenderCore();
        $this->_gatewayCore = new GatewayCore();
        $this->_cargoCore = new CargoCore();
        $this->_truckCore = new TruckCore();
        $this->_queueCore = new QueueCore();
        $this->_truckContractCore = new TruckContractCore();
        $this->_tenderCompanyCore = new TenderCompanyCore();
        $this->_UserCore = new  UserCore();
        $this->_truckOwnerCore = new  TruckOwnerCore();
        $this->_waybillOrderCore = new WaybillOrderCore();
        $this->_accountCore = new AccountCore();
        $this->_zain_cash = new Zain_Cash();
        $this->_taskQueuesCore = new TaskQueuesCore();
        $this->_assignCargoCore = new AssignCargoCore();
        $this->_locationCore = new LocationCore();
        $this->_truckRouteCore = new TruckRoutingCore();
        $this->_waybillCore = new WaybillCore();
        $this->_jo_petrol = new Jo_Petrol();
        $this->_paRouteWageCore = new PaRouteWageCore();
        $this->_customerCare = new CustomerCare();


        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();
    }

    // prepare any json filter 
    private function prepareFilter()
    {
        $tenderFilter = [];
        if ($this->_request->filter) {
            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {
                if ($value == null) {
                    $tempArr = ['key' => $key, 'op' => 'is null'];
                } else if ($key == 'tn') {
                    $tempArr = ['key' => $key, 'val' => $value, 'op' => "LIKE"];
                } else if ($key == 'cargo') {
                    $tempArr = ['key' => $key, 'val' => $value, 'op' => "LIKE"];
                } else if ($key == 'status' && strpos($value, ',') !== false) {
                    $tempArr = ['key' => 'status', 'val' => explode(",", $value), 'op' => 'in'];
                } else if ($key == 'order_date_from') {
                    $tempArr = ['key' => "order_date", 'val' => $value, 'op' => "date greater than"];
                } else if ($key == 'order_date_to') {
                    $tempArr = ['key' => "order_date", 'val' => $value, 'op' => "date less than"];
                } else if ($key == 'order_date_to') {
                    $tempArr = ['key' => "name", 'val' => $value, 'op' => "LIKE"];
                } else {
                    $tempArr = ['key' => $key, 'val' => $value];
                }
                array_push($tenderFilter, $tempArr);
            }
        }
        return $tenderFilter;
    }






    // *************************************** TENDERS SECTION *****************************************************************//


    // -------------------------------------------------------------------- //
    // --------------------- get tender bean for certain id --------------- //
    // -------------------------------------------------------------------- //
    public function getTender()
    {

        $tenderBean = $this->_tenderCore->getTenderBasic($this->_request->id, $_SESSION['user_id']);
        $activeTenderTrucks = DBConnection::getActiveStatus('tender_order');
        $tenderOrderFilter = [
            ['key' => 'tender_id', 'val' => $tenderBean->id],
            ['key' => 'status', 'val' => $activeTenderTrucks, 'op' => 'in']
        ];
        $orderResult = $this->_tenderCore->searchTenderOrder($tenderOrderFilter, 0, 100,  $_SESSION['user_id']);

        if ($orderResult->found_rows > 0) {
            $tenderBean->manifest->allowEditQuestionnaire = false;
        } else {
            $tenderBean->manifest->allowEditQuestionnaire = true;
        }
        // add the extra questionare dynamic values in case the caller object
        if ($this->_request->caller_object && $this->_request->caller_object == 'tender_order') {
            $newAnsweres = $this->_gatewayCore->getResource('QUESTIONNAIRE', null);

            foreach ($tenderBean->manifest->questionnaire as &$question) {
                if ($question->type == 'select') {
                    // append the dynamic answeres
                    foreach ($newAnsweres as $answer) {
                        $otherResourcesArray = (object) $answer;
                        array_push($question->options, $otherResourcesArray);
                    }
                }
            }
        }

        parent::response($tenderBean);
    }


    // ------------------------------------------------------------------------------- //
    // --------------------- get list of tender based on search filter --------------- //
    // ------------------------------------------------------------------------------- //
    public function searchTenders()
    {
        $tenderFilter = $this->prepareFilter();
        // inject allowed tender ids only
        if ($_SESSION['tender_ids'] && $_SESSION['tender_ids'][0] != "*") {
            $temp = ['key' => 'id', 'val' => $_SESSION['tender_ids'], 'op' => 'in'];
            array_push($tenderFilter, $temp);
        }

        // TEMP SOLUTION, DELETE IT ASAP 
        $user_roles = explode(",", $_SESSION['USER_ROLES']);
        foreach ($user_roles as $role) {
            if ($role == "CLEARING_AGENT_MANAGER") {
                $tempArr = ['key' => "id", 'val' => 13];
                $tenderFilter[] = $tempArr;
            }
        }
        // if the tender list available for user not * (all tenders)
        if ($_SESSION['tender_ids'] && $_SESSION['tender_ids'][0] != "*") {
            $temp = ['key' => 'id', 'val' => $_SESSION['tender_ids'], 'op' => 'in'];
            array_push($tenderFilter, $temp);
        }

        $tendersResult = $this->_tenderCore->searchTender(
            $tenderFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id'],
            " order by id "
        );

        // loop on all tenders
        $newAnsweres = $this->_gatewayCore->getResource('QUESTIONNAIRE', null);

        foreach ($tendersResult->data as &$tender) {

            // get a ref for tender man and questionnaire
            $man = json_decode($tender->manifest);
            $questionnaire = $man->questionnaire;

            // loop on questions 
            foreach ($questionnaire as &$question) {
                if ($question->type == 'select') {
                    // append the dynamic answeres
                    foreach ($newAnsweres as $answer) {
                        $otherResourcesArray = (object) $answer;
                        array_push($question->options, $otherResourcesArray);
                    }
                }
            }
            $man->questionnaire = $questionnaire;
            $tender->manifest = json_encode($man, JSON_UNESCAPED_UNICODE);
        }
        parent::response($tendersResult);
    }

    // --------------------------------------------------------------------------------------------------------------------------------- //
    // ------------------------------ Get a list of  destination locations for a certain order ----------------------------------------- //
    // --------------------------------------------------------------------------------------------------------------------------------- //
    public function getTenderDestinations()
    {


        $tenderManifestJSON = $this->_tenderCore->getTenderManifest($this->_request->tender_id, $_SESSION['user_id']);

        if ($tenderManifestJSON) {

            if ($tenderManifestJSON['tender_code'] == 'JO_PETROL_AQ') {
                $result = [91030015];   //مصفاة البترول في الزرقاء
            } else {
                $result = $this->_tenderCore->getTenderDestinations($this->_request->tender_id);
            }
        }

        parent::response($result);
    }

    // --------------------------------------------------------------------------------------------------------------------------------- //
    // ------------------------------ Get a list of  destination locations for a certain tender ----------------------------------------- //
    // --------------------------------------------------------------------------------------------------------------------------------- //
    public function getTenderDestinationNames()
    {

        $result = [];

        $tenderManifestJSON = $this->_tenderCore->getTenderManifest($this->_request->tender_id, $_SESSION['user_id']);
        if ($tenderManifestJSON) {

            // tender_id = JO_PETROL_AQ
            if ($tenderManifestJSON['tender_code'] == 'JO_PETROL_AQ') {
                $result[] = ['label' => 'مصفاة البترول في الزرقاء', 'value' => 91030015];
            }

            // other projects
            else {

                $destinationResult = $this->_tenderCore->getTenderDestinations($this->_request->tender_id);

                // search for the highest location that has routing in order to shift them at first
                $sql = "SELECT
                    document->>'$.negotiable_instructios.route.destination.name' destination_name,
                    destination_id,
                    COUNT(id) cnt
                FROM
                    waybill
                WHERE
                    create_date > date(CURDATE())-1
                    and tender_id = ?
                    and destination_id != 91000000
                GROUP BY destination_id,destination_name
                order by COUNT(id)  desc limit 3";

                $param = [$this->_request->tender_id];
                $highestRankDestionation = DBConnection::runBindDatabaseQuery($sql, $param);
                $itemsToBeRemoved = [];
                foreach ($highestRankDestionation as $dest) {
                    $result[] = ['label' => $dest->destination_name, 'value' => $dest->destination_id];
                    $itemsToBeRemoved[] = $dest->destination_id;
                }

                // search location
                $searchFilter = [
                    ['key' => 'id', 'val' => $destinationResult, 'op' => 'in'],
                    ['key' => 'id', 'val' => $itemsToBeRemoved, 'op' => 'not in']
                ];
                $location_qry = $this->_locationCore->searchLocation($searchFilter, 1000, 0, 0, ' order by name ');

                // inject other locations
                foreach ($location_qry->data as $location) {
                    $result[] = ['label' => $location->name, 'value' => $location->id];
                }
            }
        }

        parent::response($result);
    }

    // ---------------------------------------------------------------------------------------------------------------------------- //
    // ------------------------------ Get a list of  origin locations for a certain order ----------------------------------------- //
    // ---------------------------------------------------------------------------------------------------------------------------- //
    public function getTenderOrigin()
    {

        $tenderManifestJSON = $this->_tenderCore->getTenderManifest($this->_request->tender_id, $_SESSION['user_id']);
        $result = [];
        $manifest_questionnaire = $tenderManifestJSON['questionnaire'];
        foreach ($manifest_questionnaire as $questions) {
            if ($questions['question_type'] == 'ROUTE:ORIGIN') {
                foreach ($questions['options'] as $temp) {
                    if ($temp['id'] != 0) {
                        $item = new stdClass();
                        $item->id = $temp['id'];
                        $item->name = $temp['name'];
                        array_push($result, $item);
                    }
                }
            }
        }
        parent::response($result);
    }




    // ***************************************** TENDER QUEUES ******************************************************************//

    // ------------------------------------------------------------------------------- //
    // --------------------- get list of queues on a certain tender ------------------ //
    // ------------------------------------------------------------------------------- //
    public function searchTenderQueues()
    {

        // get the queues
        $tenderFilter = $this->prepareFilter();
        // inject allowed tender ids only
        if ($_SESSION['tender_ids'] && $_SESSION['tender_ids'][0] != "*") {
            $temp = ['key' => 'id', 'val' => $_SESSION['tender_ids'], 'op' => 'in'];
            array_push($tenderFilter, $temp);
        }

        $queueResult = $this->_tenderCore->searchTenderQueues(
            $tenderFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        // inject the allowed tenders for user
        $tenderExtraInfoFilter = [['key' => 'status', 'val' => 'ACTIVE']];
        $tendersResult = $this->_tenderCore->searchTender(
            [],
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id'],
            " order by id "
        );
        $tender_ids = [];
        foreach ($tendersResult->data as $t) {
            $tender_ids[] = $t->id;
        }
        $tenderExtraInfoFilter[] = ['key' => 'tender_id', 'val' => $tender_ids, 'op' => 'in'];


        // search for extra info to be shown along side the queue name
        $tender_queues = [];

        if ($this->_request->resource == "tender_truck") {
            $tenderQueueSize = DBConnection::searchReport("tender", "02", $tenderExtraInfoFilter, 20000, 0, $_SESSION['user_id']);
        } else if ($this->_request->resource == "queues") {
            $tenderQueueSize = DBConnection::searchReport("tender", "01", $tenderExtraInfoFilter, 20000, 0, 0);
        } else if ($this->_request->resource == "tender_order") {
            $tenderQueueSize = DBConnection::searchReport("tender", "03", $tenderExtraInfoFilter, 20000, 0, $_SESSION['user_id']);
        }


        if ($tenderQueueSize) {
            foreach ($queueResult->data as $tender) {
                $tenderMan = $this->_tenderCore->getTenderBasic($tender->id, $_SESSION['user_id']);

                $tenderQueues = $tenderMan->manifest->queues;
                $tenderName = $tenderMan->manifest->name;
                $tenderQueueType = $tenderMan->manifest->allowMultiTruckForCargo == FALSE ? 'CONTAINER' : 'CARGO';

                foreach ($tenderQueues as $q) {
                    if ($q->type == 'yard') continue;
                    $q->tender_id = $tender->id;
                    $q->tender_name = $tenderName;
                    $q->queue_size = $this->getQueueSize($tenderQueueSize->data, $q->id, $tender->id);
                    $q->queue_type = $tenderQueueType;;
                    array_push($tender_queues, $q);
                }
            }
        }


        //return Success response
        parent::response($tender_queues);
    }

    private function getQueueSize($tenderQueues, $q_id, $tender_id)
    {

        foreach ($tenderQueues as $tenderInfo) {

            if ($tenderInfo->q_id == $q_id && $tenderInfo->tender_id == $tender_id)
                return $tenderInfo->cnt;
        }
        return 0;
    }


    // ************************************************** DISTRIBUTION PART ************************************************************ //

    // ----------------------------------------------------------------------------- //
    // ---------------- start the distribution process ----------------------------- //
    // ----------------------------------------------------------------------------- //
    public function distribute()
    {

        // create Waybill orders
        $serveTenderResult = $this->_tenderCore->distribute($this->_request->tender_id, $this->_request->queue_id, $_SESSION['user_id']);

        // save the result
        $assignResult = $this->_assignCargoCore->generateAssignCargoForIndivisual($this->_request->tender_id, $this->_request->queue_id, $serveTenderResult);
        $assign_cargo_id = $this->_assignCargoCore->createAssignCargo($assignResult, $_SESSION['user_id']);

        // if the tender is vessels , close it
        if ($this->_request->tender_id == 3 || $this->_request->tender_id == 15) {
            $this->_assignCargoCore->changeStatus($assign_cargo_id, 'CLOSED', 0);
        }

        //return Success reponse 
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "TENDER.SUCCESS_OPERATION";
        $Result['assign_cargo_id'] = $assign_cargo_id;
        $Result['serveTenderResult'] = $serveTenderResult;
        parent::response($Result, 200);
    }

    // ---------------------------------------------------------------------------------------- //
    // ---------------- get the raw pre-distribution info for confirmation screen  ------------ //
    // ---------------------------------------------------------------------------------------- //
    public function getRawPreDistributionInfo()
    {

        $infoResult = $this->_tenderCore->getRawPreDistributionInfo($this->_request->tender_id, $this->_request->queue_id, $_SESSION['user_id']);
        parent::response($infoResult);
    }

    // ---------------------------------------------------------------------------------------------- //
    // ---------------- get the real time pre-distribution info for confirmation screen  ------------ //
    // ---------------------------------------------------------------------------------------------- //
    public function getRealTimePreDistributionInfo()
    {

        try {

            $tender_id = $this->_request->tender_id;
            $queue_id  = $this->_request->queue_id;
            $assign_mode  = $this->_request->assign_mode;
            $result = [];

            // get tender bean
            $tenderBean = $this->_tenderCore->getTenderBasic($tender_id, 0);

            // if tender_code is JO_PETROL_AQ , GRAINS then open the company assign screen
            if ($tenderBean->manifest->tender_code == 'JO_PETROL_AQ') {

                // queue_id 4 = دور التبويش
                // this queue is for indivisual only
                if ($queue_id == 4) {
                    $assign_mode = "indivisual";
                }

                if ($assign_mode && $assign_mode == "indivisual") {
                    $data =  $this->_tenderCore->getQueueAssign($tender_id, $queue_id, $_SESSION['user_id'], $tender_order_id);
                    unset($data['available_to_overwrite']);
                    $result['screen_name'] = 'indivisual_shares';
                } else {
                    $data =  $this->_tenderCore->getCompanyAssign($tender_id, $queue_id, 0);
                    $result['screen_name'] = 'company_shares';
                }
            }
            // if tender_code is VESSELS open indivisual_shares screen
            else if (
                $tenderBean->manifest->tender_code == 'VESSELS' ||
                $tenderBean->manifest->tender_code == 'JO_PETROL_OIL_DERIVATIVES' ||
                $tenderBean->manifest->tender_code == 'GC_EXTERNAL' ||
                $tenderBean->manifest->tender_code == "JO_PETROL_FUEL" ||
                $tenderBean->manifest->tender_code == 'LIGHT_MEDIUM_TRANS'
            ) {

                $data =  $this->_tenderCore->getQueueAssign($tender_id, $queue_id, $_SESSION['user_id'], $tender_order_id);

                $result['screen_name'] = 'indivisual_shares';
            } else {
                throw new Exception("تجهيز أوامر الحركة غير متاحة لهذا المشروع");
            }

            $result['data'] = $data;
            parent::response($result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // // --------------------------------------------------------------------------- //
    // // --------------------- get Distribution info for certain id ------------- //
    // // ---------------------------------------------------------------------------- //
    // public function getDistribution(){

    //     $distributionResult = $this->_tenderCore->getDistribution($this->_request->id,$_SESSION['user_id']);

    //     //return Success reponse
    //     parent::response(json_decode($distributionResult));

    // }

    // ------------------------------------------------------------------------------- //
    // --------------------- get list of distribution on a certain queue ------------- //
    // ------------------------------------------------------------------------------- //
    public function searchQueueDistributions()
    {
        // call the core search
        $searchFilter = [];

        if ($this->_request->filter) {
            $filter = json_decode($this->_request->filter, true);
            foreach ($filter as $key => $value) {
                if ($key == 'queue_id') {
                    $tempArr = ['key' => 'details', 'val' => '"queue_id": ' . $value, 'op' => 'like'];
                } else if ($key == 'tender_id') {
                    $tempArr = ['key' => 'details', 'val' => '"tender_id": "' . $value . '"', 'op' => 'like'];
                }
                array_push($searchFilter, $tempArr);
            }
        }

        $distribution_qry = $this->_tenderCore->searchQueueDistributions(
            $searchFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        //calculate number of generated waybills of each distribution
        foreach ($distribution_qry->data as &$dist) {
            $dist->waybill_count = count(json_decode($dist->details)->servedTrucks);
        }

        parent::response($distribution_qry);
    }


    // *************************************** TENDER TRUCKS SECTION **********************************************************//

    // -------------------------------------------------------------------------------- //
    // -------------------- get bean for tender truck --------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function getTenderTruck()
    {

        $tenderTruckBean = $this->_tenderCore->getTenderTruck($this->_request->id, $_SESSION['user_id']);

        $dec_tenderTruckBean = json_decode($tenderTruckBean);

        if ($dec_tenderTruckBean->trailer_id) {
            $trailerBean = $this->_truckCore->getTruckBasic($dec_tenderTruckBean->trailer_id, 0);
            $dec_tenderTruckBean->trn = $trailerBean->tn;
        }

        if (isset($dec_tenderTruckBean->financial_details)) {
            $waybill_beneficiary_account = $dec_tenderTruckBean->financial_details->waybill_beneficiary_account;
            if ($waybill_beneficiary_account) {
                $accountBean = $this->_accountCore->getAccountBasic($waybill_beneficiary_account, 0);
                $userBean = $this->_UserCore->getUserBasic($accountBean->user_id, 0);
                $user_phone = $userBean->phone;
                $dec_tenderTruckBean->financial_details->phone = $user_phone;
            }
        } else {
            $dec_tenderTruckBean->financial_details = new stdClass();
        }

        $tenderTruckBean = json_encode($dec_tenderTruckBean, JSON_UNESCAPED_UNICODE);

        parent::response($tenderTruckBean);
    }


    // ----------------------------------------------------------------------------------- //
    // ------------------ Save the financial manager for certain truck ------------------- //
    // ----------------------------------------------------------------------------------- //
    public function saveTenderTruckFinancialManager()
    {

        $addNoteCore = new Add_notes_core();

        // get user params
        $tender_truck_id = $this->_request->id;
        $financial_manager_id = $this->_request->financial_manager_id;

        // get tenderTruckBean
        $tenderTruckBean = $this->_tenderCore->getTenderTruckBasic($tender_truck_id, $_SESSION['user_id']);
        if (!$tenderTruckBean) {
            throw new Exception("عقد تشغيل الشاحنة غير صحيح");
        }

        // get contracts of the truck to make sure the fin manager is onw of the AUTH,JOIN contracts
        $truckContractFilter = [
            ['key' => 'truck_id', 'val' => $tenderTruckBean->truck_id],
            ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in'],
            ['key' => 'contract_type', 'val' => ['AUTH', 'OWN'], 'op' => 'in']
        ];
        $contract_qry = $this->_truckContractCore->searchTruckContracts($truckContractFilter, 100, 0, 0);

        // the user wants to remove the manager 
        if ($financial_manager_id == "no_manger_added") {
            // save it in database
            $tenderTruckBean->financial_manager_owner_id = null;

            $sqlQuery = "update tender_truck set financial_manager_owner_id = null where id = ?";
            $param = [$tenderTruckBean->id];
            $result = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

            $addNoteCore->addNotes('tender_truck', $tenderTruckBean->id, 'تم حذف المدير المالي عن الشاحنة', $_SESSION['user_id']);
        } else {
            $valid_manager = false;
            foreach ($contract_qry->data as $contract) {
                if ($contract->truck_owner_id == $financial_manager_id) {
                    $valid_manager = true;
                    break;
                }
            }
            if (!$valid_manager) {
                throw new Exception("لا تستطيع المتابعة، المدير المالي ليس مالك الشاحنة أو احد وكلائها");
            }

            // check if the fin manager has changed by the user
            if ($tenderTruckBean->financial_manager_owner_id != $financial_manager_id) {

                // get truck_owner info
                $truck_ownerFilter = [['key' => 'id', 'val' => $financial_manager_id]];
                $truckOwnerQuery = $this->_truckOwnerCore->searchTruckOwner($truck_ownerFilter, 1, 0, 0);
                $financial_manager_bean = $truckOwnerQuery->data[0];

                // save it in database
                $tenderTruckBean->financial_manager_owner_id = $financial_manager_id;
                $this->_tenderCore->updateTenderTruck($tenderTruckBean, $tenderTruckBean->id, $_SESSION['user_id']);

                $addNoteCore->addNotes('tender_truck', $tenderTruckBean->id, 'تم تغير المدير المالي للشاحنة ليصبح ' . $financial_manager_bean->name, $_SESSION['user_id']);
            }
        }


        // return result
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "TENDER.SUCCESSFUL_UPDATE";
        parent::response($Result, 200);
    }

    // -------------------------------------------------------------------------------- //
    // -------------------- Create New Tender truck ----------------------------------- //
    // -------------------------------------------------------------------------------- //
    // -------------------------------------------------------------------------------- //
    // -------------------- Create New Tender truck ----------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function createTenderTruck()
    {
        $this->_request->photos = [['url' => $this->_request->photos]];
        $tenderTruck = $this->_request;
        $tender_bean = $this->_tenderCore->getTenderBasic($tenderTruck->tender_id, $_SESSION['user_id']);



        $account_ledger_id = $tender_bean->manifest->account_ledger_id;
        if (gettype($tenderTruck->financial_details) == "string") {
            $financial_details = json_decode($tenderTruck->financial_details);
        } else {
            $financial_details = $tenderTruck->financial_details;
        }


        // for tender MG_pay , there is new format of financial details
        if ($tender_bean->id == 23 || $tender_bean->tender_id == 24) {
            $truck_ownerFilter = [['key' => 'id', 'val' => $financial_details->truck_owner->id]];
            $truckOwnerQuery = $this->_truckOwnerCore->searchTruckOwner($truck_ownerFilter, 1, 0, 0);
            if ($truckOwnerQuery->found_rows == 0) {
                throw new Exception("الوكيل المالي غير صحيح");
            }
            $_fps = new FPS();
            $accountFilter = new stdClass();
            $accountFilter->filter = ["id" => $account_ledger_id, "truck_owner_id" => $financial_details->truck_owner->id];
            $accountFilter->filter = json_encode($accountFilter->filter);
            $account_qry =  $_fps->searchAccount($accountFilter, 0);
            if ($account_qry["found_rows"] > 0) {
                $financial_details->account_id = $account_ledger_id . "-" . $account_qry['data'][0]['sub_id'];
            } else {
                $acFilter = new stdClass();
                $acFilter->filter = ["id" => $account_ledger_id];
                $acFilter->filter = json_encode($acFilter->filter);
                $account_qry =  $_fps->searchAccount($acFilter, 0);
                $subAccount = new stdClass();
                $subAccount->account_id = $account_ledger_id;
                $subAccount->details = new stdClass();
                $subAccount->details->target_truck_owner_id = $financial_details->truck_owner->id;
                $subAccount->company_type = "pa";
                $subAccount->type = "AR";
                $subAccount->account_name = "ذمة : " . $truckOwnerQuery->data[0]->name;
                $subAccount->company_id = $account_qry['data'][0]['company_id'];
                $subAccount->balance = 0;
                $subAccount->currency = 'JOD';
                $subAccount->status = 'NEW';
                $subAccount->minimum_balance = 0;
                $subAccount->maximum_balance = 250; //todo check with abu othman
                $sub =  $_fps->createSubAccount($subAccount, $_SESSION["user_id"]);
                $financial_details->account_id = $account_ledger_id . " - " . $sub;
            }
        }

        $tenderTruck->financial_details = $financial_details;
        $id = $this->_tenderCore->createTenderTruck($tenderTruck, $_SESSION['user_id']);

        // check if there is auto action to be done by the system
        $autoAction = getAutoAction('TENDER_TRUCK', 'NEW', 'ACTIVE', $_SESSION['user_id'], $_SESSION['u_id']);
        if ($autoAction && $tenderTruck->tender_id != 23) {
            $this->_tenderCore->changeTruckStatus($id, $autoAction->object_new_status_code, $_SESSION['user_id']);
        }

        // if user chose to add the new truck on queue
        if ($tenderTruck->add_queue) {
            // get the tender company bean
            $tenderCompany = $this->_tenderCompanyCore->getTenderCompanyBasic($tenderTruck->tender_company_id, $_SESSION['user_id']);
            //if the company has service list
            if ($tenderCompany && $tenderCompany->service_list && sizeof($tenderCompany->service_list) > 0) {
                //flag
                $hasAuth = false;
                // iterate and chech if there service of type *** and code ***
                foreach ($tenderCompany->service_list as $service) {
                    if ($service->code == 'DISPATCH' && $service->type == 'QUEUE') {
                        $hasAuth = true;
                    }
                }

                if ($hasAuth) {
                    $this->_queueCore->addQueue(
                        $tenderTruck->truck_id,
                        null,
                        $this->_request->trailer_id,
                        $tenderTruck->q_id,
                        $tenderTruck->tender_id,
                        $_SESSION['user_id']
                    );
                } else {
                    throw new Exception("لا تستطيع إضافة شاحنة شركة على دور الأفراد");
                }
            } else {
                throw new Exception("لا تستطيع إضافة شاحنة شركة على دور الأفراد");
            }
        }

        //return Success reponse
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "TENDER.SUCCESS_CREATE_TRUCK";
        $Result['ID'] = $id;
        parent::response($Result, 200);
    }

    // -------------------------------------------------------------------------------- //
    // -------------------- Create New Tender truck ----------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function createClientTenderTruck()
    {

        try {

            DBConnection::startTransaction();
            $this->_request->photos = [['url' => $this->_request->photos]];
            $tenderTruck = $this->_request;

            $id = $this->_tenderCore->createClientTenderTruck($tenderTruck, $_SESSION['user_id']);
            // check if there is auto action to be done by the user
            $autoAction = getAutoAction('TENDER_TRUCK', 'NEW', 'ACTIVE', $_SESSION['user_id'], $_SESSION['u_id']);
            if ($autoAction) {
                $this->_tenderCore->changeTruckStatus($id, $autoAction->object_new_status_code, $_SESSION['user_id']);
            }

            // if user chose to add the new truck on queue
            if ($tenderTruck->add_queue) {
                $this->_queueCore->addQueue(
                    $tenderTruck->truck_id,
                    null,
                    $this->_request->trailer_id,
                    $tenderTruck->q_id,
                    $tenderTruck->tender_id,
                    0
                );
            }

            DBConnection::commitTransaction();

            //return Success reponse
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "TENDER.SUCCESS_CREATE_TRUCK";
            $Result['ID'] = $id;
            parent::response($Result, 200);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw $e;
        }
    }


    // ------------------------------------------------------------------------------- //
    // --------------------- get list of trucks on a certain tender ------------------ //
    // ------------------------------------------------------------------------------- //
    public function searchTenderTrucks()
    {

        $tenderFilter = $this->prepareFilter();
        // inject allowed tender ids only
        if ($_SESSION['tender_ids'] && $_SESSION['tender_ids'][0] != "*") {
            $temp = ['key' => 'tender_id', 'val' => $_SESSION['tender_ids'], 'op' => 'in'];
            array_push($tenderFilter, $temp);
        }


        $truckResult = $this->_tenderCore->searchTenderTruck(
            $tenderFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );

        //in case the user wants to get the driver from the last trip
        if ($this->_request->get_driver_info) {
            $filter = json_decode($this->_request->filter);
            $lastWaybillFilter = [
                ['key' => 'tender_id', 'val' => $filter->tender_id],
                ['key' => 'tn', 'val' => $filter->tn],
                ['key' => 'status', 'val' => ['CLOSED', 'COMPLETE'], 'op' => 'in']
            ];
            $last_waybill = $this->_waybillCore->searchWaybills($lastWaybillFilter, 1, 0, $_SESSION['user_id'], ' order by id desc ')->data[0];
            if ($last_waybill) {
                $truckResult->data[0]->driver_id = $last_waybill->driver_id;
                $truckResult->data[0]->driver_name = json_decode($last_waybill->document)->carrier[0]->driver->name;
                $truckResult->data[0]->driver_nn = json_decode($last_waybill->document)->carrier[0]->driver->nn;
            }
        }

        parent::response($truckResult);
    }

    // -------------------------------------------------------------------------------- //
    // -------------------- change truck status on a certain tender ------------------- //
    // -------------------------------------------------------------------------------- //
    public function changeTruckStatus()
    {

        // change tender truck status
        $this->_tenderCore->changeTruckStatus($this->_request->tender_truck_id, $this->_request->new_status, $_SESSION['user_id']);

        // add remarks
        if ($this->_request->remarks != null) {
            $addNoteCore = new Add_notes_core();
            $addNoteCore->addNotes('tender_truck', $this->_request->tender_truck_id, $this->_request->remarks, $_SESSION['user_id']);
        }


        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "TENDER_TRUCK.SUCCESSFUL_CHANGE_STATUS";
        parent::response($Result);
    }

    // --------------------------------------------------------------------------------- //
    // -------------- Search for TN in order to add into tender ------------------------ //
    // -------------- Params: tender_id, TN, tender_company_id  ------------------------ //
    // --------------------------------------------------------------------------------- //

    public function validateTenderTruckForCreate()
    {

        $filter = json_decode($this->_request->filter, true);
        $tn = $filter['tn'];
        $tender_id = $filter['tender_id'];
        $tender_company_id = $filter['tender_company_id'];

        //validate if the truck is eligable to be added as tender truck
        $this->_tenderCore->validateTenderTruckForCreate($tn, $tender_id, $tender_company_id, $_SESSION['user_id']);

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "";
        parent::response($Result);
    }


    // update default_contact_user_id if exist
    public function updateTenderTruckDefaultContact()
    {
        if ($this->_request->default_contact_user_id == "delete") {
            $sqlQuery = "update tender_truck set default_contact_user_id = null , update_by=? where id = ?";
            $param = [$_SESSION['u_id'], $this->_request->tender_truck_id];
            $result = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
        } else {
            $sqlQuery = "update tender_truck set default_contact_user_id = ? , update_by=? where id = ?";
            $param = [
                $this->_request->default_contact_user_id,
                $_SESSION['u_id'],
                $this->_request->tender_truck_id
            ];
            $result = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
        }

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "TENDER_TRUCK.SUCCESSFUL_UPDATE";
        parent::response($Result);
    }

    // -------------------------------------------------------------------------------- //
    // -------------------- update tender truck details ------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function updateTenderTruck()
    {
        // convert user input from JSON to Object  

        // TODO: option 1: No update for tender truck or queue

        // TODO: option 2: update tender truck but remove the truck queue


        $isTellerSuperVisor = false;
        $userRolesArray = explode(",", $_SESSION['USER_ROLES']);
        foreach ($userRolesArray as $role) {
            if ($role == 'TELLER_SUPERVISOR' || $role == 'TELLER') {
                $isTellerSuperVisor = true;
            }
        }
        if (!$isTellerSuperVisor) {
            $tenderTruckBean =  $this->_tenderCore->getTenderTruckBasic($this->_request->tender_truck_id, $_SESSION['user_id']);
            if ($tenderTruckBean->financial_details->waybill_beneficiary_account) {
                if ($this->_request->financial_details->waybill_beneficiary_account != $tenderTruckBean->financial_details->waybill_beneficiary_account) {
                    $Result['ERRORCODE'] = "0";
                    $Result['MESSAGE'] = "لا تستطيع تعديل حساب مستحقات المستند";
                    parent::response($Result);
                    die;
                }
            }
        }

        $this->_request->photos = [['url' => $this->_request->photos]];
        $this->_tenderCore->updateTenderTruck($this->_request, $this->_request->tender_truck_id, $_SESSION['user_id']);


        // get truck queue if active
        $activeQueueStatus = DBConnection::getActiveStatus('queue');
        $searchFilter = [
            ['key' => 'tender_id', 'val' => $this->_request->tender_id, 'op' => '='],
            ['key' => 'truck_id', 'val' => $this->_request->tender_truck_id, 'op' => '='],
            ['key' => 'status', 'val' => $activeQueueStatus, 'op' => 'in']
        ];

        $trucksInQueue = $this->_queueCore->searchQueue($searchFilter, $map['maxRows'], 0, $_SESSION['user_id']);

        if ($trucksInQueue->found_rows > 0) {
            $updateBean = new stdClass();
            $updateBean->id = $this->_request->id;
            $updateBean->trailer_id = $this->_request->$trailer_id;
            $this->_queueCore->updateQueue($updateBean, $_SESSION['user_id']);
            // update queue
        }

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "TENDER_TRUCK.SUCCESSFUL_UPDATE";
        parent::response($Result);
    }


    // ***************************************** TENDER ORDERS ******************************************************************//

    // -------------------------------------------------------------------------------- //
    // -------------------- get bean for tender order --------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function getTenderOrder()
    {
        $tenderOrderBean = $this->_tenderCore->getTenderOrder($this->_request->id, $_SESSION['user_id']);
        parent::response($tenderOrderBean);
    }

    // -------------------------------------------------------------------------------- //
    // -------------------- get bean for tender order --------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function getTenderOrderBasic()
    {
        $tenderOrderBean = $this->_tenderCore->getTenderOrderBasic($this->_request->id, $_SESSION['user_id']);
        parent::response($tenderOrderBean);
    }

    // ------------------------------------------------------------------------------- //
    // --------------------- get list of orders on a certain tender ------------------ //
    // ------------------------------------------------------------------------------- //
    public function searchTenderOrder()
    {

        $ordersFilter = $this->prepareFilter();
        // inject allowed tender ids only
        if ($_SESSION['tender_ids'] && $_SESSION['tender_ids'][0] != "*") {
            $temp = ['key' => 'tender_id', 'val' => $_SESSION['tender_ids'], 'op' => 'in'];
            array_push($ordersFilter, $temp);
        }

        $orderResult = $this->_tenderCore->searchTenderOrder(
            $ordersFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id'],
            ' order by order_date desc ,id desc '
        );

        // loop on the returned data to format it
        foreach ($orderResult->data  as &$orderInfo) {
            // TODO: get the real number not random
            if ($orderInfo->tender_id == 13) {
                $order_notes = json_decode($orderInfo->order_notes);
                $extra_note = $order_notes->extra_note;
                if ($extra_note != "") {
                    $orderInfo->cargo_sample_name = $orderInfo->cargo_sample_name . " - " . $extra_note;
                }
            }
            $orderInfo->loaded = $orderInfo->weight_reserved ? ($orderInfo->weight_reserved / 1000) : 0;
            $orderInfo->discharged = $orderInfo->weight_done ? $orderInfo->weight_done : 0;
        }

        //return Success response
        parent::response($orderResult);
    }

    // -------------------------------------------------------------------------------- //
    // -------------------- get tender order profile  --------------------------------- //
    // -------------------- param: id ------------------------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function getTenderOrderProfile()
    {

        $result = new stdClass();
        // get tender order bean
        $tenderOrderBean = $this->_tenderCore->getTenderOrder($this->_request->id, $_SESSION['user_id']);
        $tenderOrderBean = json_decode($tenderOrderBean);
        $result->tenderOrderBean = $tenderOrderBean;

        // tender_company info
        $tenderCompanyActiveStatus = DBConnection::getActiveStatus('tender_company');
        $queueSearchFilter = [
            ['key' => 'q_id', 'val' => $tenderOrderBean->q_id],
            ['key' => 'tender_id', 'val' => $tenderOrderBean->tender_id],
            ['key' => 'status', 'val' => $tenderCompanyActiveStatus, 'op' => 'in']
        ];
        $tenderCompaniesReuslt = $this->_tenderCompanyCore->searchTenderCompany($queueSearchFilter, 1, 0, $_SESSION['user_id']);

        $result->tender_company_id = $tenderCompaniesReuslt->data[0]->id;
        $result->tender_company_name = $tenderCompaniesReuslt->data[0]->name;

        // cargo list
        $cargoActiveStatus = DBConnection::getActiveStatus('cargo');
        $queueSearchFilter = [
            ['key' => 'tender_id', 'val' => $tenderOrderBean->tender_id],
            ['key' => 'status', 'val' => $cargoActiveStatus, 'op' => 'in']
        ];
        $cargo_qry = $this->_cargoCore->searchCargo($cargoFilter, 100, 0, $_SESSION['user_id']);

        $clearingAgentCore = new ClearingAgentCore();
        $cargos = [];
        foreach ($cargo_qry->data as $cargo) {

            $waybill_template = json_decode($cargo->waybill_template);;

            // TODO: FIX THE WAYBILL TEMPLATE JSON
            $tempCargo = new stdClass();
            $tempCargo->id = $cargo->id;
            $tempCargo->name = $cargo->name;
            $tempCargo->owner_name = $waybill_template->cargo[0]->consigner->cargo_owner_id;
            $tempCargo->ca_id = $waybill_template->cargo[0]->consigner->ca_id;

            $caSearchFilter = [['key' => 'id', 'val' => $tempCargo->ca_id]];
            $clearingAgentInfo = $clearingAgentCore->searchClearingAgent($caSearchFilter, 1, 0, $_SESSION['user_id']);
            $tempCargo->ca_name =  $clearingAgentInfo->data[0]->name;

            array_push($cargos, $tempCargo);
        }
        $result->cargo = $cargos;

        parent::response($result);
    }


    // -------------------------------------------------------------------------------- //
    // -------------------- Create New Tender Order ----------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function createTenderOrder()
    {

        try {

            if ($this->_request->tender_id == 13) {
                throw new Exception("لا تستطيع المتابعة ، انشاء الطلبيات موقوف على مشروع التموين");
            }

            DBConnection::startTransaction();

            $tenderOrderBean = $this->_request;

            $order_notes = json_decode($tenderOrderBean->order_notes);
            $order_notes->extra_note = $tenderOrderBean->notes;
            $tenderOrderBean->order_notes = json_encode($order_notes, JSON_UNESCAPED_UNICODE);
            $id = $this->_tenderCore->createTenderOrder($tenderOrderBean, $_SESSION['user_id']);

            // see if tender order is set to be automaticlay
            $this->_tenderCore->autoAssignCargo($tenderOrderBean, $id, $_SESSION['user_id']);

            // create truck route for this tender order
            $tender_order_bean = $this->_tenderCore->getTenderOrderBasic($id, $_SESSION['user_id']);
            $tender_bean = $this->_tenderCore->getTenderBasic($tender_order_bean->tender_id, $_SESSION['user_id']);
            $tender_questionnaire = $tender_bean->manifest->questionnaire;
            foreach ($tender_questionnaire as $q) {
                if ($q->question_type == 'ROUTE:DISTINATION') {
                    $destination_questionnaire_id = $q->id;
                }
            }
            foreach ($tender_order_bean->questionnaire as $q) {
                if ($q->id == $destination_questionnaire_id) {
                    $destination_id = $q->val;
                }
            }

            if (substr((string) $destination_id, -2, 2) !== '00') { // if it is not Jordan or area
                $this->_truckRouteCore->createTruckRoute($id, $destination_id, $tender_order_bean->trucks, $tender_order_bean->questionnaire, false, $_SESSION['user_id']);
            }

            DBConnection::commitTransaction();

            //return Success reponse
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "ORDER.SUCCESSFUL_CREATE";
            $Result['ID'] = $id;
            parent::response($Result, 200);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw $e;
        }
    }


    // ------------------------------------------------------------------------------------------------------------------------------------------ //
    // -------------------- Create New Tender Order for truckingCompany and calculate on memory the result of this order ------------------------ //
    // ------------------------------------------------------------------------------------------------------------------------------------------ //
    public function createTruckingCompanyTenderOrder()
    {

        try {

            DBConnection::startTransaction();

            // create tender order
            $tenderOrderBean = $this->_request;
            $id = $this->_tenderCore->createTenderOrder($tenderOrderBean, $_SESSION['user_id']);

            //change status of tender order to ACTIVE
            $autoAction = getAutoAction('TENDER_ORDER', 'NEW', 'ACTIVE', $_SESSION['user_id'], $_SESSION['u_id']);
            if ($autoAction) {
                $this->_tenderCore->changeOrderStatus($id, $autoAction->object_new_status_code, $_SESSION['user_id']);
            }

            // get a suggestion result of distribution
            // $reserveResult = $this->_tenderCore->getRealTimePreDistributionInfo($this->_request->tender_id, $this->_request->queue_id, $_SESSION['user_id']);

            //return reponse
            $Result['ERRORCODE'] = "0";
            //$Result['reserveResult'] = $reserveResult;
            //$Result['available_to_overwrite'] = $reserveResult['available_to_overwrite'];
            $Result['ID'] = $id;
            parent::response($Result, 200);


            DBConnection::commitTransaction();
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw $e;
        }
    }

    // -------------------------------------------------------------------------------------------------------------------- //
    // -------------------- this API is used to assign cargo to an existing tender order (ACTIVE)  ------------------------ //
    // -------------------- params: ID, tender_id, queue_id --------------------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------------------------- //
    public function distributeTruckingCompanyTenderOrder()
    {

        try {

            DBConnection::startTransaction();

            $tenderOrderBean = $this->_request;
            $id = $this->_request->id;

            // get a suggestion result of distribution
            $reserveResult = $this->_tenderCore->getRealTimePreDistributionInfo($this->_request->tender_id, $this->_request->queue_id, $_SESSION['user_id'], [$id]);

            //return reponse
            $Result['ERRORCODE'] = "0";
            $Result['reserveResult'] = $reserveResult;
            $Result['ID'] = $id;
            parent::response($Result, 200);


            DBConnection::commitTransaction();
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw $e;
        }
    }


    // -------------------------------------------------------------------------------------------------------------- //
    // -------------------- Assign the cargo which tc user created to the selected truck ids ------------------------ //
    // -------------------- params: cargo_id, order_id, truck_ids --------------------------------------------------- //
    // -------------------------------------------------------------------------------------------------------------- //
    public function AssignCargoForTruckingCompanyTenderOrder()
    {

        try {

            // get the needed param from request
            $cargo_id = $this->_request->cargo_id;
            $order_id = $this->_request->order_id;

            // get the tenderOrder bean to make sure the user has authority to access this bean
            $tenderOrderBean = $this->_tenderCore->getTenderOrderBasic($order_id, $_SESSION['user_id']);

            // change status if tender order to PENDING
            $this->_tenderCore->changeOrderStatus($order_id, "PENDING", $_SESSION['user_id']);

            // assign the cargo
            $truck_ids = explode(",", $this->_request->truck_ids);

            $id = $this->_tenderCore->distributeTruckingCompanyOrder($cargo_id, $order_id, $truck_ids, $_SESSION['user_id']);

            //return Success reponse
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "TENDER.SUCCESSFUL_CARGO_ASSIGN";
            $Result['ID'] = $id;
            parent::response($Result, 200);
        } catch (Exception $e) {
            throw $e;
        }
    }



    // --------------------------------------------------------------------------- //
    // -------------------- Create New Tender  ----------------------------------- //
    // --------------------------------------------------------------------------- //
    public function createTender()
    {

        try {

            DBConnection::startTransaction();

            // create new tender record
            $tenderBean = $this->_request;

            // inkect trucking_company_id in tender name
            $manifest = json_decode($tenderBean->manifest);
            $manifest->name =  $_SESSION['trucking_company_id'] . "-" . $manifest->name;
            $tenderBean->manifest = json_encode($manifest, JSON_UNESCAPED_UNICODE);

            $tenderBean->company_id = $_SESSION['company_id'];
            $id = $this->_tenderCore->createTender($tenderBean, $_SESSION['user_id']);

            // add the session company to the newly created tender
            $truckingCompanyCore = new TruckingCompanyCore();
            $companyFilter = [['key' => 'company_id', 'val' =>  $_SESSION['company_id']]];
            $companyResult = $truckingCompanyCore->searchTruckingCompany($companyFilter, 1, 0, $_SESSION['user_id']);

            $trucking_company_id = $companyResult->data[0]->id;
            $tenderCompanyBean = new stdClass();
            $tenderCompanyBean->tender_id = $id;
            $tenderCompanyBean->trucking_company_id = $companyResult->data[0]->id;
            $tenderCompanyBean->allowed_truck_contract_type = '["OWN", "AUTH", "JOIN"]';
            $tenderCompanyBean->share = 0;
            $tenderCompanyBean->service_list = '[{"code": "DISPATCH", "name": "خدمة تسريب", "type": "QUEUE", "override_roles": "tc_manager"}]';

            $this->_tenderCompanyCore->createTenderCompany($tenderCompanyBean, $_SESSION['user_id']);


            DBConnection::commitTransaction();

            //return Success reponse
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "TENDER.SUCCESSFUL_CREATE";
            $Result['ID'] = $id;
            parent::response($Result, 200);
        } catch (Exception $e) {
            DBConnection::rollBackTransaction();
            throw $e;
        }
    }

    // -------------------------------------------------------------------------------- //
    // -------------------- change order ststus --------------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function changeOrderStatus()
    {
        $this->_tenderCore->changeOrderStatus($this->_request->order_id, $this->_request->new_status, $_SESSION['user_id']);

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "ORDER.SUCCESSFUL_CHANGE_STATUS";
        parent::response($Result);
    }

    // -------------------------------------------------------------------------------- //
    // -------------------- update order details -------------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function updateOrder()
    {

        $tender_order_bean = $this->_request;

        if ($this->_request->notesField) {
            $order_notes = json_decode($tender_order_bean->order_notes);
            $order_notes->extra_note = str_replace('"', '', $this->_request->notesField);
            $tender_order_bean->order_notes = json_encode($order_notes, JSON_UNESCAPED_UNICODE);
        }
        $this->_tenderCore->updateTenderOrder($tender_order_bean,  $this->_request->id, $_SESSION['user_id']);

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "ORDER.SUCCESSFUL_UPDATE";
        parent::response($Result);
    }



    // ----------------------------------------------------------------------------------------------- //
    // -------------------- get the queue list to be generated in tender order screen----------------- //
    // ----------------------------------------------------------------------------------------------- //
    public function getTenderQueuesForTenderOrder()
    {

        $tenderManifestJSON = $this->_tenderCore->getTenderManifest($this->_request->tender_id, 0);
        $result = [];

        // add the quota option if enabled
        if ($tenderManifestJSON['quota_management']['is_quota_managed'] && $tenderManifestJSON['quota_management']['is_quota_managed'] == 'true') {
            $temp = new stdClass();
            $temp->value = "null";
            $temp->caption = $tenderManifestJSON['quota_management']['quota_managed_label'];
            array_push($result, $temp);
        }

        // add the queues
        foreach ($tenderManifestJSON['queues'] as $queue) {
            if ($queue['type'] == 'yard') continue;

            $temp = new stdClass();
            $temp->value = $queue['id'];
            $temp->caption = $queue['name'];
            array_push($result, $temp);
        }

        parent::response($result);
    }

    // ---------------------------------------------------------------------------- //
    // -------------------- Update the tender manifest ---------------------------- //
    // ---------------------------------------------------------------------------- //
    public function updateTenderManifest()
    {

        // call the core API to update
        $this->_tenderCore->updateTenderManifest($this->_request->tender_id, $this->_request->manifest, $_SESSION['user_id']);

        $Result['MESSAGE'] = "ORDER.SUCCESSFUL_UPDATE";
        parent::response($Result);
    }



    // ---------------------------------------------------------------------------------------------------------- //
    // --------------------- search for all tenders that the company is part of --------------------------------- //
    // ---------------------------------------------------------------------------------------------------------- //
    public function searchTruckingCompanyTender()
    {

        // search for company tender_company records and extract the tender names from
        $tenderCompanyActiveStatus = DBConnection::getActiveStatus('tender_company');
        $queueSearchFilter = [['key' => 'status', 'val' => $tenderCompanyActiveStatus, 'op' => 'in']];
        $tenderCompaniesReuslt = $this->_tenderCompanyCore->searchTenderCompany($queueSearchFilter, 1000, 0, $_SESSION['user_id']);

        $result = [];
        foreach ($tenderCompaniesReuslt->data as $tenderCompany) {
            $temp = new stdClass();
            $temp->id = $tenderCompany->tender_id;
            $temp->name = $tenderCompany->tender_name;
            array_push($result, $temp);
        }

        parent::response($result);
    }


    // ------------------------------------------------------------------------------------------------------------------------------------------------------ //
    // ------------------------------ Get a list of destination locations for a certain tender for trucking company ----------------------------------------- //
    // ------------------------------------------------------------------------------------------------------------------------------------------------------ //
    public function getTruckingCompanyTenderDestinations()
    {

        // search for company tender_company records and extract the tender names from
        $tenderCompanyActiveStatus = DBConnection::getActiveStatus('tender_company');
        $queueSearchFilter = [
            ['key' => 'status', 'val' => $tenderCompanyActiveStatus, 'op' => 'in'],
            ['key' => 'tender_id', 'val' => $this->_request->tender_id]
        ];
        $tenderCompaniesReuslt = $this->_tenderCompanyCore->searchTenderCompany($queueSearchFilter, 1000, 0, $_SESSION['user_id']);

        $tenderManifestJSON = json_encode(json_decode($tenderCompaniesReuslt->data[0]->manifest));
        $tenderManifestJSON = $this->_tenderCore->parseTenderManifest($tenderManifestJSON);

        $result = [];
        foreach ($tenderManifestJSON['destination'] as $destination_id) {
            $temp = new stdClass();
            $temp->id = $destination_id;
            $temp->name = "";

            array_push($result, $temp);
        }

        // get the extra dynamic options for tender origin
        $tenderQueueType = $tenderManifestJSON['allowMultiTruckForCargo'] == FALSE ? 'CONTAINER' : 'CARGO';
        if ($tenderQueueType == 'CARGO') {
            $tenderDestination =  $this->_gatewayCore->getResource("TENDER_DESTINATION", null);
            foreach ($tenderDestination as $dynamicDestination) {
                array_push($result, $dynamicDestination);
            }
        }

        parent::response($result);
    }

    // ------------------------------------------------------------------------------------------------------------------- //
    // ------------------------------ set the trailer_id to null in tender truck ----------------------------------------- //
    // ------------------------------------------------------------------------------------------------------------------- //
    public function removeTenderTruckTrailerId()
    {

        $tender_truck_id = $this->_request->id;
        $userRolesArray = explode(",", $_SESSION['USER_ROLES']);

        foreach ($userRolesArray as $role) {
            if ($role == 'OPERATION_MANAGER') {
                $isMinagateOperation = true;
            }
        }
        if (!$isMinagateOperation) {
            throw new Exception('NOT_ALLOWED_OPERATION');
        } else {
            //run database query to set the trailer_id to null
            $this->_tenderCore->removeTenderTruckTrailerId($tender_truck_id, $_SESSION['user_id']);
        }

        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "TENDER_TRUCK.SUCCESSFUL_CHANGE_STATUS";
        parent::response($Result);
    }


    // ----------------------------------------------------------------------------------------------- //
    // ------------------------ Return the SMS content from tender manifest -------------------------- //
    // ----------------------------------------------------------------------------------------------- //
    public function getLtrcSms()
    {

        $tender_id = $this->_request->tender_id;
        $tenderManifestJSON = $this->_tenderCore->getTenderManifest($tender_id, $_SESSION['user_id']);

        $SMS_Text = $tenderManifestJSON['ltrc']['SMS_text'];
        $enable_edit_SMS = $tenderManifestJSON['ltrc']['enable_edit_SMS'];

        $result = new stdClass();
        $result->SMS_Text = $SMS_Text;
        $result->enable_edit_SMS = $enable_edit_SMS;

        parent::response($result);
    }

    // ------------------------------------------------------------------------------------------------------------------ //
    // -------------------------- Get the UI elements to be rendered on user mobile screen regarding -------------------- //
    // -------------------------- the tender truck screen for a certain tender ------------------------------------------ //
    // ------------------------------------------------------------------------------------------------------------------ //
    public function getMobileTenderTruckScreen()
    {

        // incoming data
        $tender_truck_id = $this->_request->id;

        // get tenderTruck bean
        $tenderTruckBean = $this->_tenderCore->getTenderTruckBasic($tender_truck_id, $_SESSION['user_id']);
        if (!$tenderTruckBean) {
            throw new Exception("رقم الشاحنة غير صحيح");
        }

        // get the financial details
        $financial_details = $tenderTruckBean->financial_details;

        // check if the user has authority to edit any financial info
        $result = [];
        $has_auth = false;
        try {
            DBConnection::has_authority($_SESSION['user_id'], 'TENDER_TRUCK', 'EDIT_FINANCIAL', 'ACTIVE', 'ACTIVE');
            $has_auth = true;
        } catch (Exception $e) {
        }

        // -------------------------- get the default contact number  --------------------------
        $tenderTruckDefaultContact = $this->_tenderCore->getTenderTruckDefaultContact($tenderTruckBean->id, 0);
        $availableContacts = $this->_truckCore->getTruckAvailableContacts($tenderTruckBean->truck_id, 0);

        $element0 = new stdClass();
        $element0->type = $has_auth ? "PHONE" : "LABEL";
        $element0->title = "جهة الإتصال";

        foreach ($availableContacts as $contact) {
            if ($tenderTruckDefaultContact->truck_owner_id == $contact->truck_owner_id) {
                $element0->answer = $tenderTruckDefaultContact->phone;
            }
        }
        array_push($result, $element0);

        // temp solution
        // $has_auth = false;

        // ------------- payment channel --------------
        // $element1 = new stdClass();
        // $element1->type = $has_auth?"SWITCH":"LABEL";
        // $element1->title = "صرف مستحقات المستند بواسطة زين كاش";
        // $element1->answer = $has_auth?false:"غير فعال";
        // if($financial_details && $financial_details->payment_channel && $financial_details->payment_channel == "zain_cash"){
        //     $element1->answer = $has_auth?true:"فعال";
        // }
        // array_push($result, $element1);

        // // ----------------- waybill_beneficiary_account  ----------------------
        // if($financial_details && $financial_details->waybill_beneficiary_account){
        //     $accountCore = new AccountCore();
        //     $accountFilter = [['key'=>"id",'val' => $financial_details->waybill_beneficiary_account],['key'=>"status",'val' => 'ACTIVE']];
        //     $account_qry = $accountCore->searchAccount($accountFilter, 1, 0, 0);
        //     $accountBean = $account_qry->data[0];
        //     $userBean = $this->_UserCore->getUserBasic($accountBean->user_id, 0);
        // }else{
        //     $userBean = null;
        // }
        // $element2 = new stdClass();
        // $element2->type = $has_auth?"PHONE":"LABEL";
        // $element2->title = "رقم هاتف المستفيد";
        // $element2->answer = $userBean->phone;
        // $element2->description = "سيتم تحويل مستحقات المستند للحساب المرتبط برقم الهاتف";
        // array_push($result, $element2);

        // // ------------------- payment_delay -----------------------------------
        // $element3 = new stdClass();
        // $element3->type = $has_auth?"RADIO":"LABEL";
        // $element3->title = "وقت الدفعة";
        // $element3->description = "تحديد وقت الدفعة عند التسديد";
        // $element3->options = [];
        // $option1 = new stdClass();
        //     $option1->title = "فوري - بعد يوم واحد - عمولة 6.5 دينار";
        //     $option1->value = 1;
        //     $option1->isChecked = false;
        //     if($financial_details && $financial_details->payment_delay && $financial_details->payment_delay->delay == 1){
        //         $option1->isChecked = true;
        //         $element3->answer =  $option1->title;
        //     }
        //     array_push($element3->options, $option1);
        // $option2 = new stdClass();
        //     $option2->title = "مؤجل - بعد 21 يوم";
        //     $option2->value = 21;
        //     $option2->isChecked = false;
        //     if($financial_details && $financial_details->payment_delay && $financial_details->payment_delay->delay == 21){
        //         $option2->isChecked = true;
        //         $element3->answer =  $option2->title;
        //     }
        //     if(!$element3->answer){
        //         $element3->answer = "غير محدد";
        //     }
        //     array_push($element3->options, $option2);
        // array_push($result, $element3);

        // // -------------------- Advanced Payments ---------------------------------
        // $element4 = new stdClass();
        // $element4->type = $has_auth?"CHECKBOX":"LABEL";
        // $element4->title = "السلف المتاحة";
        // $element4->description = "حدد جميع السلف التي تود صرفها للشاحنة";
        // $element4->options = [];
        // $option1 = new stdClass();
        //     $option1->title = "سلفة شخصية بقيمة 70 دينار كحد أقصى";
        //     $option1->value = "pocket_money";
        //     $option1->isChecked = false;

        //     if($financial_details && $financial_details->advance_payment_account) {
        //         foreach ($financial_details->advance_payment_account as $adv) {
        //             if ($adv->name == $option1->value && $adv->status=="active") {
        //                 $option1->isChecked = true;
        //                 $element4->answer = $option1->title;
        //             }
        //         }
        //     }
        //     if(!$element4->answer){
        //         $element4->answer = "بدون سلف";
        //     }
        //     array_push($element4->options, $option1);

        // array_push($result, $element4);

        parent::response($result);
    }


    // ------------------------------------------------------------------------------------------------------------------ //
    // -------------------------- generate questioner to be shown for mobile screen  ------------------------------------ //
    // ------------------------------------------------------------------------------------------------------------------ //
    public function getMobileTenderQuestionnaireScreen()
    {

        // incoming data
        $tender_truck_id = $this->_request->id;

        // get the tender truck bean
        $tenderTruckBean = $this->_tenderCore->getTenderTruckBasic($tender_truck_id, $_SESSION['user_id']);
        if (!$tenderTruckBean) {
            throw new Exception("رقم الشاحنة غير صحيح");
        }

        // extract the questionnaire and the answers
        $questionnaireQuestions = $this->_tenderCore->getTenderManifest($tenderTruckBean->tender_id, 0)["questionnaire"];
        $questionnaireAnswers = $tenderTruckBean->questionnaire;

        // check if the user has authority to edit any financial info
        $result = [];
        $has_auth = false;
        try {
            DBConnection::has_authority($_SESSION['user_id'], 'TENDER_TRUCK', 'UPDATE', 'ACTIVE', 'ACTIVE');
            $has_auth = true;
        } catch (Exception $e) {
        }

        // generate the questionare list
        foreach ($questionnaireQuestions  as $key => $value) {
            $element = new stdClass();
            $element->title = $value["text"];
            $element->description = "";
            // always answers is array
            $element->answer =  $questionnaireAnswers[$key - 1]->val;
            $options = [];
            // to reformat options
            if ($value["type"] == "tree-select") {
                foreach ($value["options"] as $option) {
                    $newOption =  new stdClass();
                    $newOption->value = $option["id"];
                    $newOption->title = $option["name"];
                    $newOption->isChecked = false;
                    if (in_array($newOption->value, $element->answer)) {
                        $newOption->isChecked = true;
                    }
                    array_push($options, $newOption);
                }
            }

            // if it has truck_answer then it's read only
            if ($value["truck_answer"] != null) {
                $element->type = "LABEL";
            } else  if ($value["type"] == "tree-select") {
                $element->type = $has_auth ? "CHECKBOX" : "LABEL";
                $element->options = $options;
            } else if ($value["type"] == "select") {
                $element->type = $has_auth ? "RADIO" : "LABEL";
                $element->options = $options;
            }
            array_push($result, $element);
        }
        parent::response($result);
    }

    // ------------------------------------------------------------------------------------------------------------------ //
    // -------------------------- parse the incoming data from truck owner tender truck on mobile app ------------------- //
    // -------------------------- and save it in tender truck financial column ------------------------------------------ //
    // ------------------------------------------------------------------------------------------------------------------ //
    public function saveFinancialTenderTruck()
    {

        // validate if the user has authority to edit financial info
        try {
            DBConnection::has_authority($_SESSION['user_id'], 'TENDER_TRUCK', 'EDIT_FINANCIAL', 'ACTIVE', 'ACTIVE');
        } catch (Exception $e) {
            throw new Exception("NO AUTHORITY TO EDIT FINANCIAL ");
        }

        try {
            // init objects
            $accountCore = new AccountCore();

            // parse incoming data
            $tender_truck_id = $this->_request->id;
            $tenderTruckBean = $this->_tenderCore->getTenderTruckBasic($tender_truck_id, $_SESSION['user_id']);
            try {
                $answers = json_decode($this->_request->answers);
            } catch (Exception $error) {
                parent::response($error->getMessage());
            }

            // get the truck_owner_id
            // ---------- $answers[0] = default contact truck owner id -------
            $answers[0] = convertToInternational($answers[0]);
            $searchFilter = [['key' => 'phone', 'val' =>  $answers[0]], ['key' => 'status', 'val' => 'ACTIVE']];

            //----------save mobile default contact-----------------
            $defaultContactNewNumber = $answers[0];
            $this->saveMobileDefaultContact($tenderTruckBean->id, $defaultContactNewNumber, $this->_request->confirmation_flag);

            $default_contact_user_info = $this->_UserCore->searchUser($searchFilter, 1, 0, 0);
            $truck_owner_id = $default_contact_user_info->data[0]->truck_owner_id;


            // create financial object
            // ---------- $answers[1] = payment_channel -------
            $financialDetails = new stdClass();
            // if($answers[1] == true || $answers[0] == "true")
            //     $financialDetails->payment_channel = "zain_cash";
            // else
            //     $financialDetails->payment_channel = "none";


            // // ---------- $answers[2] = beneficiary phone -------
            // $answers[2] = convertToInternational($answers[2]);
            // $searchFilter = [['key'=>'phone','val' => $answers[2] ],['key'=>'status','val' => 'ACTIVE']];
            // $userInfo = $this->_UserCore->searchUser($searchFilter,1,0,0);
            // if($userInfo->found_rows == 0){
            //     throw new Exception("TENDER_TRUCK.BENEFICIARY_PHONE_NOT_EXIST");

            // }
            // $accountFilter = [['key'=>"user_id",'val' => $userInfo->data[0]->id],['key'=>"status",'val' => 'ACTIVE']];
            // $account_qry = $accountCore->searchAccount($accountFilter, 1, 0, 0);
            // if($account_qry->found_rows == 0){
            //     throw new Exception("TENDER_TRUCK.BENEFICIARY_ACCOUNT_NOT_EXIST");

            // }
            // $financialDetails->waybill_beneficiary_account = $account_qry->data[0]->id;

            // // ---------- $answers[3] = payment_delay -------
            // $payment_delay_node = new stdClass();

            // if($answers[3] == 1){
            //     $payment_delay_node->delay = 1;
            //     $payment_delay_node->method = "schedule";
            //     $payment_delay_node->caption = "فوري";
            //     $payment_delay_node->is_default = false;
            //     $payment_delay_node->deduction_value = 6.5;
            // }
            // else if($answers[3] == 21){
            //     $payment_delay_node->delay = 21;
            //     $payment_delay_node->method = "schedule";
            //     $payment_delay_node->caption = "مؤجل";
            //     $payment_delay_node->is_default = false;
            //     $payment_delay_node->deduction_value = 0;
            // }else{
            //     throw new Exception("لا يمكن تحديث المعلومات");

            // }
            // $financialDetails->payment_delay = $payment_delay_node;

            // // ---------- $answers[4] = advance_payment to be paid in next trip -------
            // $id = 1;
            // $advance_payments=[];
            // try{$answers[4] = json_decode($answers[4]);}catch(Exception $e){}
            // foreach ($answers[4] as $adv) {
            //     $advance_payment_node = new stdClass();
            //     $advance_payment_node->id =$id;
            //     $advance_payment_node->name = $adv;
            //     $advance_payment_node->status = "active";
            //     $advance_payment_node->has_warning = false;
            //     $advance_payment_node->target_account = null;
            //     array_push($advance_payments, $advance_payment_node);
            //     $id++;
            // }

            // $financialDetails->advance_payment_account = $advance_payments;

            // create tender truck object
            // $tenderTruckBean->financial_details = $financialDetails;
            $tenderTruckBean->default_contact_user_id = $truck_owner_id;

            // save it in database
            $this->_tenderCore->updateTenderTruck($tenderTruckBean, $tender_truck_id, $_SESSION['user_id']);

            // return to user
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "TENDER_TRUCK.SUCCESSFUL_UPDATE";
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // --------------------------------------------------------------------------- //
    // ---------------save default contact for mobile  --------------------------- //
    // --------------------------------------------------------------------------- //
    private function saveMobileDefaultContact($tender_truck_id, $phone, $confirmation_flag)
    {

        // get the tenderTruckBean
        $tenderTruckBean = $this->_tenderCore->getTenderTruckBasic($tender_truck_id, 0);

        //---------- validate if user exist in the system
        $searchFilter = [
            ['key' => 'phone', 'val' => convertToInternational($phone)],
            ['key' => 'status', 'val' => 'ACTIVE']
        ];
        $userInfo = $this->_UserCore->searchUser($searchFilter, 1, 0, 0);
        if ($userInfo->found_rows == 0) {
            throw new Exception("TENDER_TRUCK.DEFAULT_CONTACT_NOT_EXIST");
        };

        //------------- validate if user has an active contract on truck
        $userBean = $userInfo->data[0];
        $truckContractFilter = [
            ['key' => 'truck_id', 'val' => $tenderTruckBean->truck_id],
            ['key' => 'status', 'val' => ['ACTIVE', 'NEW'], 'op' => 'in'],
            ['key' => 'truck_owner_id', 'val' => $userBean->truck_owner_id]
        ];

        $contract_qry = $this->_truckContractCore->searchTruckContracts($truckContractFilter, 1, 0, 0);

        if ($contract_qry->found_rows == 0 && !$confirmation_flag) {
            throw new Exception("TENDER_TRUCK.DEFAULT_CONTACT_REQUIRE_CONTRACT");
        } else if ($contract_qry->found_rows == 0 && $confirmation_flag) {

            //-------if user give confirmation flag add new contract---------
            //---------------------- create truck owner  if user not owner-----------
            if ($userBean->truck_owner_id) {
                $truckOwnerID = $userBean->truck_owner_id;
            } else {
                $truckOwnerBean =  new stdClass();
                $truckOwnerBean->user_id = $userBean->id;

                // to do give user auth to create truck owner
                $truckOwnerID = $this->_truckOwnerCore->createTruckOwner($truckOwnerBean,  $_SESSION['user_id']);

                //activate it
                $this->_truckOwnerCore->activateTruckOwner($_SESSION['user_id']);
            }

            //---------------------- create new contract with contract_type AUTH-----------
            $truckContractBean = new stdClass();
            $truckContractBean->truck_owner_id = $truckOwnerID;
            $truckContractBean->truck_id =  $tenderTruckBean->truck_id;
            $truckContractBean->contract_type = "AUTH";
            $truckContractBean->photos = [];

            $this->_truckContractCore->createTruckContract($truckContractBean, $_SESSION['user_id']);
        }

        //------------- update default_contact_user_id --------------
        $tenderTruckBean->default_contact_user_id = $userBean->truck_owner_id;
        $this->_tenderCore->updateTenderTruck($tenderTruckBean, $tenderTruckBean->id, $_SESSION['user_id']);
    }

    // --------------------------------------------------------------------------- //
    // ---------------save tender questionare for mobile  ------------------------ //
    // --------------------------------------------------------------------------- //
    public function saveMobileTenderQuestionnaire()
    {

        // validate if the user has auth
        try {
            DBConnection::has_authority($_SESSION['user_id'], 'TENDER_TRUCK', 'UPDATE', 'ACTIVE', 'ACTIVE');
        } catch (Exception $e) {
            throw new Exception("NO_AUTHORITY");
        }

        // parse the answer
        $tender_truck_id = $this->_request->id;
        try {
            $answers = json_decode($this->_request->answers);
            if (gettype($answers) == "string") {
                $answers = json_decode($answers);
            }
        } catch (Exception $error) {
            parent::response($error->getMessage());
        }

        // get tenderTruck bean
        $tenderTruckBean = $this->_tenderCore->getTenderTruckBasic($tender_truck_id, $_SESSION['user_id']);
        $questionnaire = $tenderTruckBean->questionnaire;

        // loop on questions and map its correct answer
        foreach ($questionnaire as $index => $question) {
            $question->val = $answers[$index];
        }

        // save it in database
        $tenderTruckBean->questionnaire = $questionnaire;
        $this->_tenderCore->updateTenderTruck($tenderTruckBean, $tender_truck_id, $_SESSION['user_id']);

        // return result
        $result = new stdClass();
        $result->ERRORCODE = "0";
        $result->MESSAGE = "TENDER_TRUCK.SUCCESSFUL_UPDATE";
        parent::response($result);
    }

    // ---------------------------------------------------------------------------------------------------------------------------- //
    // ------------------------------ Get revoked reasons for waybills ------------------------------------------------------------ //
    // ---------------------------------------------------------------------------------------------------------------------------- //
    public function getRevokedReasons()
    {
        $tender_id = $this->_request->tender_id;

        // check if the tender_id was passed
        if (!$tender_id) {
            throw new Exception("Please provide a tender_id");
        }

        // get all revoked reasons from tender manifest
        $revokedReasons = $this->_tenderCore->getTenderManifest($tender_id, $_SESSION['user_id'])['waybill_revoked_reasons'];

        // if none was found respond with empty array
        if (!$revokedReasons) {
            parent::response([]);
        }

        // if everything was passed respond with revoked reasons
        parent::response($revokedReasons);
    }


    // // -------------------------------------------------------------------------------------------------------------------------------------- //
    // // ----------------------------- Preview how the company quota should be assigned between tender companies ------------------------------ //
    // // -------------------------------------------------------------------------------------------------------------------------------------- //
    public function previewCompanyAssignQuota()
    {
        $tender_id = $this->_request->tender_id;
        $queue_id = $this->_request->queue_id;
        $result =  $this->_tenderCore->getCompanyAssign($tender_id, $queue_id, 0);
        parent::response($result);
    }

    // ------------------------------------------------------------------------------------------------------------------------- //
    // ----------------------------- save the company quota after assigned tender companies quota ------------------------------ //
    // ----------------------------- then start the assign waybill order procedure -------------- ------------------------------ //
    // ------------------------------------------------------------------------------------------------------------------------- //
    public function saveCompanyAssignQuota()
    {

        // get params
        $tender_id = $this->_request->tender_id;
        $q_id = $this->_request->q_id;
        $user_id = $_SESSION['user_id'];

        // validate params
        if (!$tender_id) throw new Exception("tender id is required");
        if (!$q_id) throw new Exception("q_id is required");

        try {
            DBConnection::startTransaction();
            // get the tender company shares
            $servingResult = $this->_tenderCore->getCompanyQuotas($tender_id, $q_id, $user_id);

            // if the order_notes assign_to = individual , throw exception
            foreach ($servingResult['orders'] as $order) {
                $tenderOrderBean = $this->_tenderCore->getTenderOrderBasic($order['id'], $_SESSION['user_id']);

                $order_notes = json_decode($tenderOrderBean->order_notes);
                if ($order_notes->assign_mode) {
                    //throw new Exception("لا تستطيع المتابعة ، يجري حاليا توزيع الطلبية");
                }
            }

            // update residual balance for each company
            foreach ($servingResult['servedCompanies'] as $serving) {
                $tender_company_id = $serving['id'];
                $residual = $serving['residual'];
                $quota = $serving['quota'];
                $used_quota = $serving['used_quota'];
                $this->_tenderCore->saveTenderCompanyQuota($tender_company_id, $q_id, $quota, $residual, $used_quota, $_SESSION['u_id']);
            }

            // save the break down in "tender_order_company"
            foreach ($servingResult['output'] as $tender_company_id => $output) {
                foreach ($output as $order_id => $cargos) {
                    foreach ($cargos as $cargo_id => $quota) {
                        if ($quota > 0) {
                            $this->_tenderCore->saveTenderOrderCompany($order_id, $cargo_id, $tender_company_id, $quota, $_SESSION['u_id']);
                        }
                    }
                }
            }

            // start the assign waybill orders process
            $tender_code = strtoupper($servingResult['tenderMan']['tender_code']);
            switch ($tender_code) {

                    // Crude oil and FUEL
                case 'JO_PETROL_AQ':

                    // generate company assign node and save it in assign_cargo
                    $assignCargo = $this->_assignCargoCore->generateAssignCargoForCompany($tender_id, $q_id, $servingResult);
                    $assign_cargo_id = $this->_assignCargoCore->createAssignCargo($assignCargo, $_SESSION['user_id']);
                    $this->_assignCargoCore->changeStatus($assign_cargo_id, 'CLOSED', 0);
                    break;

                    // Bulk and Packed
                case 'GRAINS':

                    // save the assign cargo result
                    $assignCargo = $this->_assignCargoCore->generateAssignCargoForCompany($tender_id, $q_id, $servingResult);
                    $assign_cargo_id = $this->_assignCargoCore->createAssignCargo($assignCargo, $_SESSION['user_id']);

                    $tenderBean = $this->_tenderCore->getTenderBasic($tender_id, 0);

                    // change assign_cargo to WAITING ("جاري التوزيع للشركات")
                    $this->_assignCargoCore->changeStatus($assign_cargo_id, 'WAITING', 0);

                    // loop on all orders
                    foreach ($servingResult['orders'] as $order) {

                        // write down that order is being assigned to companies (assign_mode : companies)
                        $tenderOrderBean = $this->_tenderCore->getTenderOrderBasic($order['id'], 0);
                        $order_notes = json_decode($tenderOrderBean->order_notes);
                        $order_notes->assign_mode = "companies";
                        $updateBean = new stdClass();
                        $updateBean->id = $order['id'];
                        $updateBean->order_notes = $order_notes;
                        DBConnection::updateDB("tender_order", $updateBean, 0);

                        // change tender orders to PENDING
                        $this->_tenderCore->changeOrderStatus($order['id'], "PENDING", 0);
                    }

                    // group the output by tender_company
                    $all_orders = [];
                    foreach ($servingResult['output'] as $tenderCompanyId => $orders) {
                        foreach ($orders as $order_id => $cargos) {
                            foreach ($cargos as $cargo_id => $quota) {
                                if ($quota > 0)
                                    $all_orders[$tenderCompanyId][] = ["order" => $order_id, "quota" => $quota];
                            }
                        }
                    }

                    // loop on the assign result
                    $cnt = 0;
                    foreach ($all_orders as $key => $orders) {
                        $cnt++;

                        // the system has to skip any company that has QUEUEING service
                        $tenderCompanyBean = $this->_tenderCompanyCore->getTenderCompanyBasic($key, 0);
                        $service_list = $tenderCompanyBean->service_list;
                        $has_queue_service = false;
                        foreach ($service_list as $service) {
                            if ($service->code == "DISPATCH" && $service->type == "QUEUE") {
                                $has_queue_service = true;
                            }
                        }
                        if ($has_queue_service) {

                            // if the only company that got quota has QUEUE service , no need to pause the assign_cargo object, instead change status to PENDING directly
                            // ex: الحصة كلها ذهبت لشركة الأفراد ، فلا داعي لأبقاء الحالة جاري توزيع الشركات 
                            if (sizeof($all_orders) == 1) {
                                $this->_assignCargoCore->changeStatus($assign_cargo_id, 'PENDING', 0);
                                break;
                            } else {
                                continue;
                            }
                        }

                        // create waybill orders for companies using task queue
                        $tenderCompanyId = $key;
                        $is_last_task = false;

                        if ($cnt == sizeof($all_orders)) {
                            // last task has to update waybill orders to allow individual assign and to inform operation manager
                            $is_last_task = true;
                        }
                        $this->_taskQueuesCore->createWaybillOrderForCompanyQuota(
                            $assign_cargo_id,
                            $orders,
                            $tenderCompanyId,
                            $is_last_task
                        );
                    }
                    break;

                default:
                    throw new Exception("TENDER CODE is not defined");
                    break;
            }

            //return reponse
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "TENDER.SUCCESSFUL_CREATE";
            parent::response($Result, 200);

            DBConnection::commitTransaction();
        } catch (Exception $e) {

            DBConnection::rollBackTransaction();
            throw new Exception("Error Processing Request, " . $e->getMessage());
        }
    }


    // -------------------------------------------------------------------------------------------------------- //
    // -------------------- Search for tender companies for a certain tender ---------------------------------- //
    // -------------------------------------------------------------------------------------------------------- //
    public function searchTenderCompany()
    {
        $tenderCompanyFilter = $this->prepareFilter();
        // inject allowed tender ids only
        if ($_SESSION['tender_ids'] && $_SESSION['tender_ids'][0] != "*") {
            $temp = ['key' => 'tender_id', 'val' => $_SESSION['tender_ids'], 'op' => 'in'];
            array_push($tenderCompanyFilter, $temp);
        }

        // if tn provided search in tender trucks to get companies
        $tn = $this->_request->tn;
        if ($tn) {
            $tenderTrucksFilter = [['key' => 'tn', 'val' => $tn], ['key' => 'status', 'val' => ['INACTIVE'], 'op' => 'not in']];
            $tender_trucks = $this->_tenderCore->searchTenderTruck($tenderTrucksFilter, 1000, 0, $_SESSION['user_id']);
            if (sizeof($tender_trucks->data) > 0) {
                function tender_company_id($obj)
                {
                    return $obj->tender_company_id;
                }
                $ids = array_map('tender_company_id', $tender_trucks->data);
                $tenderCompanyFilter[] = ["key" => "id", "val" => $ids, "op" => "in"];
            } else {
                $result['data'] = [];
                $result['found_rows'] = 0;
                parent::response($result);
                die;
            }
        }

        // search from tender_company
        $tenderCompanyActiveStatus = DBConnection::getActiveStatus('tender_company');
        $tenderCompanyFilter[] = ["key" => "status", "val" => $tenderCompanyActiveStatus, "op" => "in"];

        $tenderCompaniesReuslt = $this->_tenderCompanyCore->searchTenderCompany($tenderCompanyFilter, 1000, 0, $_SESSION['user_id'], ' order by id desc ');
        parent::response($tenderCompaniesReuslt);
    }



    // --------------------------------------------------------------------------- //
    // ---------------get the company share for certain date ------------------- //
    // --------------------------------------------------------------------------- //
    public function searchCompanyShare()
    {

        $tender_company_id =  $this->_request->tender_company_id;
        $create_date =  $this->_request->create_date;
        $tender_id =  $this->_request->tender_id;

        if (!$create_date) throw new Exception("create_date is required");

        $sql = "SELECT
                    tc.name,
                    SUM(t1.share) AS share,
                    #count(w.id) AS waybills,
                    (select count(id) from waybill w where w.trucking_company_id = tc.trucking_company_id
                        and w.status not  in ('INACTIVE','REVOKED')
                        and w.tender_id = ?
                        and DATE(w.create_date) = ?) waybills ,
                    t3.queue_name
                FROM
                    tender_order_company t1,
                    tender_order_view t3,
                    tender_company_view tc
                WHERE
                    t1.tender_company_id = tc.id
                        AND t1.tender_order_id = t3.id
                        AND t1.status = 'ACTIVE'
                        AND DATE(t3.order_date) = ?
                        AND t3.tender_id = ?";

        $param[] = $tender_id;
        $param[] = $create_date;
        $param[] = $create_date;
        $param[] = $tender_id;

        if ($tender_company_id) {
            $sql .= "AND t1.tender_company_id = ?";
            $param[] = $tender_company_id;
        }
        $sql .= "GROUP BY t3.queue_name , t1.tender_company_id , DATE(t1.create_date)";

        $data = DBConnection::runBindDatabaseQuery($sql, $param);

        $Result = [];
        $Result['data'] = $data;
        $Result['found_rows'] = sizeof($data);
        parent::response($Result);
    }


    // --------------------------------------------------------------------------- //
    // ---------------get the company share for certain date ------------------- //
    // --------------------------------------------------------------------------- //
    public function searchCompanyShareForWaybillSubmit()
    {

        $tender_id =  $this->_request->tender_id;
        if (!$tender_id) throw new Exception("tender_id is required");

        $sql = "SELECT
                    t1.id,
                    tc.trucking_company_id,
                    tc.name,
                    t1.share,
                    t1.waybills,
                    t3.queue_name
                FROM
                    tender_order_company t1,
                    tender_order_view t3,
                    tender_company_view tc
                WHERE
                    t1.tender_company_id = tc.id
                        AND t1.tender_order_id = t3.id
                        AND t1.status = 'ACTIVE'
                        AND tc.tender_id = ?";
        $param[] = $tender_id;

        $data = DBConnection::runBindDatabaseQuery($sql, $param);

        $Result = [];
        $Result['data'] = $data;
        $Result['found_rows'] = sizeof($data);
        parent::response($Result);
    }

    // --------------------------------------------------------------------------- //
    // ---------------get the total company share on a certain tender ------------------- //
    // --------------------------------------------------------------------------- //
    public function searchCompanyTenderShare()
    {

        // get params
        $tender_id =  $this->_request->tender_id;

        // get list of companies in tender
        $tenderCompanyActiveStatus = DBConnection::getActiveStatus('tender_company');
        $queueSearchFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'status', 'val' => $tenderCompanyActiveStatus, 'op' => 'in']
        ];
        $tenderCompaniesReuslt = $this->_tenderCompanyCore->searchTenderCompany($queueSearchFilter, 1000, 0, $_SESSION['user_id']);

        $tender_company_ids = [];
        foreach ($tenderCompaniesReuslt->data as $tc) {
            $tender_company_ids[] = $tc->id;
        }

        $company_ids = implode(",", $tender_company_ids);
        $sqlQuery = "SELECT
                    tc.name,t1.quota, t1.used_quota, t1.residual,  t1.q_id as queue_name
                FROM
                    tender_company_quota t1,
                    tender_company_view tc
                WHERE
                    t1.tender_company_id = tc.id
                        AND t1.status = 'ACTIVE'
                        AND tender_company_id in ($company_ids)
                ORDER BY residual desc ";

        $companies = DBConnection::runBindDatabaseQuery($sqlQuery, []);
        $Result = [];
        $Result['data'] = $companies;
        $Result['found_rows'] = sizeof($companies);
        parent::response($Result);
    }


    // ----------------------------------------------------------------------------------------- //
    // ----------------------- Get Available cargo for a certain queue ------------------------- //
    // ----------------------------------------------------------------------------------------- //
    public function getQueueAvailableCargo()
    {

        $tender_id =  $this->_request->tender_id;
        $q_id =  $this->_request->q_id;

        // get tender cargos
        $cargoActiveStatus = DBConnection::getActiveStatus('cargo');
        $cargoFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'status', 'val' => $cargoActiveStatus, 'op' => 'in']
        ];
        $cargo_qry = $this->_cargoCore->searchCargo($cargoFilter, 100, 0, $_SESSION['user_id']);

        // get tender manifest
        $tenderMan = $this->_tenderCore->getTenderManifest($tender_id, $_SESSION['user_id']);
        $queue_info = $tenderMan['queues'][$q_id];
        foreach ($queue_info['cargo_filter'] as $filter) {
            $ct_id[] = $filter['val'];
        }

        $result = [];
        foreach ($cargo_qry->data as $cargo) {
            if (in_array($cargo->ct_id, $ct_id)) {

                $temp_cargo = new stdClass();
                $temp_cargo->id = $cargo->id;
                $temp_cargo->name = $cargo->name;
                $result[] = $temp_cargo;
            }
        }

        parent::response($result);
    }

    // ----------------------------------------------------------------------------------------- //
    // ----------------------- CHANGE STATUS OF COMPANIES SHARES ----------------------------------- //
    // ----------------------------------------------------------------------------------------- //
    public function closeCompanyShare()
    {
        // get ids of shares to close
        $shares = $this->_request->shares;

        try {
            // iterate and update the status of record
            foreach ($shares as $share) {
                $sqlQuery = "UPDATE tender_order_company SET status='INACTIVE' , update_by=? WHERE id = ?";
                $querey = DBConnection::runBindDatabaseQuery($sqlQuery, [$_SESSION['u_id'], $share]);
            }

            // return success message
            $Result['ERRORCODE'] = "0";
            $Result['MESSAGE'] = "SHARES.SUCCESSFUL_UPDATE";
            parent::response($Result);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------------------------------------------------------------------------------------ //
    // ------------------------------ Get a list of destination locations for a certain tender for trucking company ----------------------------------------- //
    // ------------------------------------------------------------------------------------------------------------------------------------------------------ //
    public function getTendersQueues()
    {
        $result = new stdClass();
        $tender_queues = [];

        // get the list of tenders
        $tenders = $tendersResult = $this->_tenderCore->searchTender(null, null, null, $_SESSION['user_id']);
        $tender_options = [];
        $tenders_id = [];

        foreach ($tenders->data as $tender) {
            // tender options
            $tender_option = new stdClass();
            $tender_option->label = $tender->tender_name;
            $tender_option->value = $tender->id;
            array_push($tender_options, $tender_option);


            $manifest = json_decode($tender->manifest);
            // get the queues of tender
            $q_options = [];
            foreach ($manifest->queues as $queue) {
                $option = new stdClass();
                $option->label = $queue->name;
                $option->value = $queue->id;
                array_push($q_options, $option);
            }

            ///
            $temp = new stdClass();
            $temp->tender_id = $tender->id;
            $temp->queues = $q_options;
            ///////////////////////////////////

            // get the destination options of tender
            $tenderdestination = join(",", $manifest->destination);
            $result_locations = [];

            $locations = $tenderdestination;
            if ($locations == 91000000) { // 91000000=الأردن
                $locations = getJordanCities();
            }

            $locationsArr = explode(",", $locations);

            // loop on the request locations, and get its child locations
            foreach ($locationsArr as $location_id) {

                $locationBean = new stdClass();
                $childLocations = $this->_locationCore->searchChildLocations($location_id);

                // search childLocations to get the paranet
                $index = 0;
                foreach ($childLocations as $child) {
                    if ($child->id == $location_id) {
                        $locationBean = $child;
                        unset($childLocations[$index]);
                        break;
                    }
                    $index++;
                }
                $locationBean->children = $childLocations;
                array_push($result_locations, $locationBean);
            }

            if ($tenderdestination == 91000000) { // 91000000=الأردن
                $jordanObj = new stdClass();
                $jordanObj->id = 91000000;
                $jordanObj->value = 91000000;
                $jordanObj->label = "الأردن";
                $jordanObj->pId = 0;
                $jordanObj->children = $result_locations;
                $temp->destenationOptions = [$jordanObj];
            } else {
                $temp->destenationOptions = $result_locations;
            }

            array_push($tender_queues, $temp);
        }

        $result->tender_queues = $tender_queues;
        $result->tender_options = $tender_options;
        parent::response($result);
    }



    // remove this function from here to  report interface
    // ---------------------------------------------------------------------------------------- //
    // ------------------ Get the stats report for a certain tender order --------------------- //
    //------------------- This report measure by whom each waybill_order was approved --------- //
    // ------------------ and calculate some useful info of how tender order was procces ------ //
    // ---------------------------------------------------------------------------------------- //
    public function getTenderOrderStatsReport()
    {

        // parse filter data
        $tender_order_id = $this->_request->tender_order_id;
        $tender_id = $this->_request->tender_id;

        if (!$tender_id) {
            $tenderOrderBean = $this->_tenderCore->getTenderOrderbasic($tender_order_id, 0);
            $tender_id = $tenderOrderBean->tender_id;
        }

        // if(!$tender_id){
        //     throw new Exception("tender_id is required");
        // }

        //validate role code if it has the ownership to view this report
        // $this->hasAuthToViewReport($tender_id,'tender_order_report');

        // run query to get raw data
        $sqlQuery = "SELECT
                        COUNT(w.id) cnt,
                        CASE
                            WHEN u.employee_id IS NOT NULL THEN 'موظفي الإتصال'
                            WHEN a.u_id = 375 THEN 'الإتصال الالي'
                            WHEN a.u_id = 0 THEN 'النظام'
                            ELSE 'التطبيق'
                        END AS done_by
                    FROM
                        waybill_order_view w,
                        user u,
                        activity a
                    WHERE
                        w.tender_order_id = ?
                            AND w.status IN ('APPROVED' , 'CLOSED')
                            AND a.waybill_order_id = w.id
                            AND a.object_new_status_code  = 'APPROVED'
                            AND a.action_code = 'CHANGE_STATUS'
                            AND u.id = a.u_id
                    GROUP BY done_by";

        $param = [$tender_order_id];
        $data = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        // get the tenderOrder info
        $ordersFilter = [['key' => 'id', 'val' => $tender_order_id]];
        $orderResult = $this->_tenderCore->searchTenderOrder($ordersFilter, 1, 0, $_SESSION['user_id']);
        $tenderOrderBean = $orderResult->data[0];
        $tenderOrderActivity =  json_decode($this->_tenderCore->getTenderOrder($tender_order_id, $_SESSION['user_id']))->activity;

        // calculate the lifetime of the tender order
        $end_time = DBConnection::getSystemDate();
        foreach ($tenderOrderActivity as $activity) {
            if ($activity->object_status_code == "ACTIVE" && $activity->object_new_status_code == "PENDING") {
                $start_time = $activity->activity_date;
            }
            if ($activity->object_status_code == "PENDING" && $activity->object_new_status_code == "CLOSED") {
                $end_time = $activity->activity_date;
            }
        }
        $start_time = date_create(date($start_time));
        $end_time   = date_create(date($end_time));
        $tenderOrderLifeTime = date_diff($end_time, $start_time);

        // calculate number of waybill orders by status in this tender order
        $waybillOrderFilter = [['key' => 'tender_order_id', 'val' => $tender_order_id]];
        $waybillOrderSearchResult = $this->_waybillOrderCore->searchWaybillOrder($waybillOrderFilter, 1000, 0,  $_SESSION['user_id']);

        $approved_count = 0;

        $total_approved_waybill_discharge_weight = 0;
        $closed_count = 0;
        $revoked_count = 0;
        foreach ($waybillOrderSearchResult->data as $waybillOrder) {
            if ($waybillOrder->status == 'APPROVED') $approved_count++;
            elseif ($waybillOrder->status == 'CLOSED') {
                $closed_count++;
                $total_approved_waybill_discharge_weight += json_decode($waybillOrder->document)->cargo[0]->weights->loading->net_weight;
            } elseif ($waybillOrder->status == 'REVOKED') {
                $revoked_count++;
            }
        }


        // calculate percentage of approval
        foreach ($data as &$row) {
            $row->perc = round(($row->cnt / ($approved_count + $closed_count)) * 100, 1) . "%";
            $row->cnt = intval($row->cnt);
        }

        // format data
        $result = new stdClass();
        $result->approval = $data;
        $result->info = new stdClass();
        $result->info->queue_name = $tenderOrderBean->queue_name;
        $result->info->cargo_name = $tenderOrderBean->cargo_sample_name;
        $result->info->status = $tenderOrderBean->status;
        $result->info->trucks = $tenderOrderBean->trucks;
        $result->info->approved_count = $approved_count;
        $result->info->closed_count = $closed_count;
        $result->info->revoked_count = $revoked_count;
        $result->info->total_approved_waybill_discharge_weight = $total_approved_waybill_discharge_weight;
        if ($tenderOrderLifeTime->i < 10) {
            $result->info->duration = $dateDiff = $tenderOrderLifeTime->h . ":0" . $tenderOrderLifeTime->i;
        } else {
            $result->info->duration = $dateDiff = $tenderOrderLifeTime->h . ":" . $tenderOrderLifeTime->i;
        }
        $result->info->complete_perc = round((($approved_count + $closed_count) / $tenderOrderBean->trucks) * 100, 1) . "%";

        parent::response($result, 200);
    }


    // ------------------------------------------------------------------------------------------------ //
    // ------------------ Get the stats report for a certain tender order ----------------------------- //
    //------------------- This report measure the performance of each employee on call center --------- //
    // ------------------------------------------------------------------------------------------------ //
    public function getTenderOrderPerformanceStatsReport()
    {

        // parse filter data
        $tender_order_id = $this->_request->tender_order_id;
        $tender_id = $this->_request->tender_id;

        // if(!$tender_id){
        //     throw new Exception("tender_id is required");            
        // }

        // //validate role code if it has the ownership to view this report
        // $this->hasAuthToViewReport($tender_id,'tender_order_report');       


        // run query to get raw data
        $sqlQuery = "SELECT
                        COUNT(w.id) cnt,
                        u.name,
                        a.object_new_status_code as statusCode,
                        CASE
                            WHEN a.object_new_status_code = 'APPROVED' THEN 'موافقة'
                            WHEN a.object_new_status_code = 'REVOKED' THEN 'رفض'
                        END AS status
                    FROM
                        waybill_order_view w,
                        user u,
                        activity a
                    WHERE
                        w.tender_order_id = ?
                            AND a.waybill_order_id = w.id
                            AND a.object_new_status_code IN ('APPROVED' , 'REVOKED')
                            AND a.action_code = 'CHANGE_STATUS'
                            AND u.id = a.u_id
                            AND u.employee_id IS NOT NULL
                            and a.activity_date > '2019-06-29'
                    GROUP BY u.name , status, a.object_new_status_code
                    order by name,status";

        $param = [$tender_order_id];
        $searchQueryResult = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        $obj = new stdClass();
        $result = [];
        foreach ($searchQueryResult as $record) {

            $obj->name = $record->name;
            if ($record->statusCode == 'APPROVED') $obj->approved = intval($record->cnt);
            if ($record->statusCode == 'REVOKED') $obj->revoked = intval($record->cnt);

            if ($obj->approved && $obj->revoked) {
                if (!$this->findInArray($record->name, $result, 'name')) {
                    $result[] = $obj;
                    $obj = new stdClass();
                }
            }
        }

        parent::response($result, 200);
    }

    private function findInArray($value, $arr, $key = 'name')
    {
        foreach ($arr as $temp) {
            if ($temp->$key == $value) {
                return 1;
            }
        }
        return 0;
    }


    // ---------------------------------------------------------------------------------------- //
    // ------------------ Get the stats report for a certain tender order --------------------- //
    //------------------- This report measure by whom each waybill_order was revoked --------- //
    // ------------------ and calculate some useful info of how tender order was procces ------ //
    // -------------------- Deprecated -------------------------------------------------------- //
    // ---------------------------------------------------------------------------------------- //
    public function getTenderOrderRevokedStatsReport()
    {

        // // parse filter data
        // $tender_order_id = $this->_request->tender_order_id;
        // // $tender_id = $this->_request->tender_id;

        // // if(!$tender_id){
        // //     throw new Exception("tender_id is required");            
        // // }

        // // //validate role code if it has the ownership to view this report
        // // $this->hasAuthToViewReport($tender_id,'tender_order_report');        

        // // run query to get raw data
        // $sqlQuery = "SELECT
        //                 COUNT(w.id) cnt,
        //                 CASE
        //                     WHEN u.employee_id IS NOT NULL THEN 'موظفي الإتصال'
        //                     WHEN a.u_id = 375 THEN 'الإتصال الالي'
        //                     WHEN a.u_id = 0 THEN 'موظفي الإتصال'
        //                     ELSE 'التطبيق'
        //                 END AS done_by
        //             FROM
        //                 waybill_order_view w,
        //                 user u,
        //                 activity a
        //             WHERE
        //                 w.tender_order_id = ?
        //                     AND w.status IN ('REVOKED')
        //                     AND a.waybill_order_id = w.id
        //                     AND a.object_new_status_code  = 'REVOKED'
        //                     AND a.action_code = 'CHANGE_STATUS'
        //                     AND u.id = a.u_id
        //             GROUP BY done_by";

        // $param = [$tender_order_id];
        // $data = DBConnection::runBindDatabaseQuery($sqlQuery,$param);
        // foreach ($data as &$row) {
        //     $row->cnt = intval($row->cnt);
        // }

        // $result = new stdClass();
        // $result->revoked = $data;

        // parent::response($result,200);
    }

    // ------------------------------------------------------------------------------ //
    // -------------------- Server Tender Orders on memory -------------------------- //
    // ------------------------------------------------------------------------------ //
    public function serveTenderOrders()
    {

        $tenderId = $this->_request->tenderId;
        $queueId = $this->_request->queueId;
        $user_id = $_SESSION['user_id'];
        $tender_order_ids = $this->_request->tender_order_ids;

        $result = $this->_tenderCore->serveTenderOrders($tenderId, $queueId, $user_id, $tender_order_ids);
        parent::response($result, 200);
    }


    // ------------------------------------------------------------------------------------------------------ //
    // -------------------- process poll of adding new destination to questionarre -------------------------- //
    // ------------------------------------------------------------------------------------------------------ //
    public function processPollAnswerToAddNewDestination()
    {

        $notificationCore = new NotificationCore();

        try {
            // parse incoming params
            $tender_id = $this->_request->tender_id;
            $destination_id = $this->_request->destination_id;
            $bind_params = json_decode($this->_request->bind_params);
            $bind_params = json_decode(json_encode($bind_params), true);
            $user_id = $this->_request->user_id;

            if (getType($this->_request->answers) == "string") {
                $answers = json_decode($this->_request->answers);
                $answers = json_decode(json_encode($answers), true);
                $user_answer = "";
                foreach ($answers as $ans) {
                    if ($ans['question_id'] == 0) {
                        $user_answer = $ans['value'];
                    }
                }
            } else {
                // parse user answers
                $answers = $this->_request->answers;
                $user_answer = "";
                foreach ($answers as $ans) {
                    if ($ans->question_id == 0) {
                        $user_answer = $ans->value;
                    }
                }
            }

            if ($user_answer == 1) {
                // get tender truck
                $tn = $bind_params['_$_TN_$_'];
                $tenderTruckFilter = [
                    ['key' => 'tender_id', 'val' => $tender_id],
                    ['key' => 'tn', 'val' => $tn],
                    ['key' => 'status', 'val' => ['ACTIVE'], 'op' => 'in']
                ];
                $tenderTruckResult = $this->_tenderCore->searchTenderTruck($tenderTruckFilter, 1, 0, 0);
                $tenderTruckBean = $tenderTruckResult->data[0];

                // add the destination
                $questionnaire = json_decode($tenderTruckBean->questionnaire);
                $destinations = $questionnaire[0];
                $destinations->val[] = "$destination_id";
                $questionnaire[0] = $destinations;
                $tenderTruckBean->questionnaire = json_encode($questionnaire, JSON_UNESCAPED_UNICODE);
                $this->_tenderCore->updateTenderTruck($tenderTruckBean, $tenderTruckBean->id, 0);

                // send notification to user                
                $payload = new stdClass();
                $payload->type = "set_notification";
                $payload->id = 1;
                $payload->message = "تمت اضافة الموقع كوجهة متاحة للشاحنة رقم $tn";
                $notificationCore->sendDataMessage($user_id, $payload);
            } else {
                // send notification to user                
                $payload = new stdClass();
                $payload->type = "set_notification";
                $payload->id = 1;
                $payload->message = "شكرا لك على الاجابة";
                $notificationCore->sendDataMessage($user_id, $payload);
            }
        } catch (Exception $e) {
            // send notification to user
            $payload = new stdClass();
            $payload->type = "set_notification";
            $payload->id = 1;
            $payload->message = $e->getmessage();
            $notificationCore->sendDataMessage(2, $payload);
        }
    }

    // get the tender truck if the truck has multiple loads from the Jo petrol system
    public function getTenderTrucksBasedOnDuplicateLoads()
    {
        $waybill = $this->_jo_petrol->getLoadsData();
    }

    // stop the tender truck if the truck has multiple loads from the Jo petrol system
    public function stopTenderTrucksBasedOnDuplicateLoads()
    {
        $waybill = $this->_jo_petrol->applyPunishmentOnTrucks();
    }

    // create new service in to tender truck bean

    public function createService()
    {
        $addNoteCore = new Add_notes_core();

        // prepare user data
        $services_list = new stdClass();
        $tender_truck_id = $this->_request->tender_truck_id;
        $tender_truck_Bean = $this->_tenderCore->getTenderTruckBasic($tender_truck_id, $_SESSION['user_id']);
        $searvices_array = $tender_truck_Bean->services;

        // prepare service record
        $services_list->service_code = $this->_request->service_code;
        $services_list->update_time_stamp = DBConnection::getSystemDate();
        $services_list->status = $this->_request->attatchment_url ? 'ACTIVE' : 'PENDING';
        $services_list->attatchment_url = $this->_request->attatchment_url;
        $searvices_array[] = $services_list;

        // check if the service already exest
        if ($tender_truck_Bean->services) {
            foreach ($tender_truck_Bean->services as $value) {
                if (strtoupper($value->service_code) == 'DOWNPAYMENT') {
                    throw new Exception("الخدمة مضاف مسبقا", 500);
                }
            }
        }
        $tender_truck_Bean->services = $searvices_array;
        // update tender_truck_Bean
        if ($tender_truck_Bean->services) {
            foreach ($tender_truck_Bean->services as $value) {
                if (strtoupper($value->service_code) == 'DOWNPAYMENT') {
                    $addNoteCore->addNotes('tender_truck', $tender_truck_id, 'تمت اضافة خدمة الدفعة المقدمة للشاحنة', $_SESSION['user_id']);
                }
            }
        }
        $this->_tenderCore->updateTenderTruck($tender_truck_Bean, $tender_truck_id, $_SESSION['user_id']);

        $Result = [];
        $Result['ERRORCODE'] = '0';
        $Result['MESSAGE'] = 'تمت العملية بنجاح';
        parent::response($Result);
    }

    // update new service in to tender truck bean
    public function updateService()
    {
        $addNoteCore = new Add_notes_core();
        $tender_truck_id = $this->_request->tender_truck_id;
        $tender_truck_Bean = $this->_tenderCore->getTenderTruckBasic($tender_truck_id, $_SESSION['user_id']);

        $service = $tender_truck_Bean->services;
        if ($service) {
            foreach ($service as $value) {
                if (strtoupper($value->service_code) == 'DOWNPAYMENT') {
                    $value->attatchment_url = $this->_request->attatchment_url;
                    $value->update_time_stamp = DBConnection::getSystemDate();
                    $value->status = 'ACTIVE';
                }
            }
        }
        $tender_truck_Bean->services = $service;
        $this->_tenderCore->updateTenderTruck($tender_truck_Bean, $tender_truck_id, $_SESSION['user_id']);
        $addNoteCore->addNotes('tender_truck', $tender_truck_id, 'تمت تعديل خدمة الدفعة المقدمة للشاحنة', $_SESSION['user_id']);

        $Result = [];
        $Result['ERRORCODE'] = '0';
        $Result['MESSAGE'] = 'تمت العملية بنجاح';
        parent::response($Result);
    }

    // delete new service in to tender truck bean
    public function deleteService()
    {
        $addNoteCore = new Add_notes_core();
        $tender_truck_id = $this->_request->tender_truck_id;
        $tender_truck_Bean = $this->_tenderCore->getTenderTruckBasic($tender_truck_id, $_SESSION['user_id']);

        $services_array = [];
        $service = $tender_truck_Bean->services;
        if ($service) {
            foreach ($service as $key => $value) {
                if (strtoupper($value->service_code) == 'DOWNPAYMENT') {
                    unset($service[$key]);
                }
            }
        }
        foreach ($service as $key => $value) {
            $services_array[] = $value;
        }
        $tender_truck_Bean->services = $services_array;

        $this->_tenderCore->updateTenderTruck($tender_truck_Bean, $tender_truck_id, $_SESSION['user_id']);
        $addNoteCore->addNotes('tender_truck', $tender_truck_id, 'تم حذف خدمة الدفعة المقدمة للشاحنة', $_SESSION['user_id']);

        $Result = [];
        $Result['ERRORCODE'] = '0';
        $Result['MESSAGE'] = 'تمت العملية بنجاح';
        parent::response($Result);
    }

    // ------------------------------------------------------------------------------- //
    // --------------------- get list of tender based on search filter --------------- //
    // ------------------------------------------------------------------------------- //
    public function searchPaTenders()
    {
        $tenderFilter = $this->prepareFilter();

        $tendersResult = $this->_tenderCore->searchPaTender(
            $tenderFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id'],
            " order by id "
        );


        $paProjectFilter = $this->prepareFilter();

        $paProjectReuslt = $this->_paRouteWageCore->searchPaProject(
            $paProjectFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );
        $list_of_tender_and_projects = [];
        foreach ($tendersResult->data as $key => $value) {

            $obj = new stdClass();
            $obj->id = $value->id;
            $obj->tender_id = $value->tender_id;
            $obj->name = $value->tender_name;
            $obj->template = "template_1";
            $list_of_tender_and_projects[] = $obj;
        }


        foreach ($paProjectReuslt->data as $key => $value) {
            $obj = new stdClass();
            $obj->id = $value->id;
            $obj->pa_id = $value->pa_id;
            $obj->name = $value->name;
            $obj->template = "template_2";
            $list_of_tender_and_projects[] = $obj;
        }

        parent::response($list_of_tender_and_projects);
    }


    // ------------------------------------------------------------------------------- //
    // --------------------- get list of projects available for fps claims ----------- //
    // ------------------------------------------------------------------------------- //
    public function searchProjectAvailableForClaims()
    {
        $data = [];
        $data[] = ['name' => 'البواخر', 'id' => '3', 'template' => 'template1'];
        $data[] = ['name' => 'التموين', 'id' => '13', 'template' => 'template1'];
        if ($_SESSION['company_id'] == 266770)
            $data[] = ['name' => 'نترات الأمونيا', 'id' => '53', 'template' => 'template3'];

        $result = [];
        $result['data'] = $data;
        parent::response($data);
    }

    public function getShifts()
    {
        $data = [];
        $data[] = ['label' => 'صباحي', 'value' => 'صباحي'];
        $data[] = ['label' => 'مسائي', 'value' => 'مسائي'];
        $data[] = ['label' => 'ليلي', 'value' => 'ليلي'];

        parent::response($data);
    }


    // --------------------------------------------------------------------------- //
    // ------------------- Get MG Pay Profile for certain truck owner ------------ //
    // --------------------------------------------------------------------------- //
    public function getMgPayTruckProfile()
    {
        $truck_owner_id = $_SESSION['truck_owner_id'];
        $tender_id = $this->_tenderCore->getMgPayTender()->id;
        $tenderFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in'],
            ['key' => 'financial_details', 'val' => "'$truck_owner_id'", 'op' => 'json unquote', 'node' => '$.truck_owner.id']
        ];
        $truckResult = $this->_tenderCore->searchTenderTruck(
            $tenderFilter,
            $this->_request->limit,
            $this->_request->offset,
            $_SESSION['user_id']
        );
        if ($truckResult->found_rows == 0) {

            // get user trucks
            $truck_result = $this->_truckCore->searchTrucks([], 100, 0, $_SESSION['user_id']);

            $filter = array();
            $filter['type_code'] = 'REUQEST_JOIN_MG_PAY';
            $filter['status'] = ['NEW'];
            $tickets = $this->_customerCare->searchTickets($filter, null, null, " desc ");

            if (sizeof($tickets['data']) > 0) {

                $has_join_ticket = false;
                foreach ($tickets['data'] as $ticket) {
                    $ticketData = json_decode($ticket['request']['data']);
                    $tn_in_ticket = $ticketData->body->tn;
                    $ticket_id = $ticket['id'];

                    // if the user is the owner of this tn , return message to him
                    foreach ($truck_result->data as $userTruck) {
                        if ($userTruck->tn == $tn_in_ticket) {
                            $has_join_ticket = true;
                            break;
                        }
                    }
                }
            } else {
                $has_join_ticket = false;
            }

            if ($has_join_ticket) {
                $has_no_contract_message =  "هل تود إضافة شاحنة جديدة للإستفادة من الخدمة؟";
                $has_no_contract_wall_message = "تم إرسال طلب انضمام للشاحنة رقم $tn_in_ticket بنجاح ، يتم الأن مراجعته من قبل فريق العمليات ";
                $has_no_contract_wall_message .= "رقم المعاملة: " . $ticket_id;
            } else {
                $has_no_contract_message = "هل تود إضافة شاحنة جديدة للإستفادة من الخدمة؟";
                $has_no_contract_wall_message = "مرحبا بك في خدمة السلف ... للبدء يرجى الضغظ على زر الإضافة الموجود أسفل الشاشة";
            }

            $res = new stdClass;
            $res->basic = new stdClass();
            $res->basic->has_no_contract = true;
            $res->basic->has_no_contract_message = $has_no_contract_message;
            $res->basic->has_no_contract_wall_message = $has_no_contract_wall_message;
            $res->basic->instruction_url = $this->getMgPayInstructionTemnplate();
            $res->details = [];
            $res->truckOwnerTrucks = [];
            $res->truckOwnerTrucks_template = '';
            $res->dashboard = new stdClass();
        } else {
            $fin = json_decode($truckResult->data[0]->financial_details);
            $truck_owner_name = $fin->truck_owner->name;
            $is_vip = $fin->truck_owner->is_vip;
            $account = $fin->account_id;
            $_fps = new FPS();
            $acFilter = new stdClass();
            $acFilter->filter = ["id" => explode("-", $account)[0], "sub_id" => explode("-", $account)[1]];
            $acFilter->filter = json_encode($acFilter->filter);
            $account_qry =  $_fps->searchAccount($acFilter, 0);
            $maximum_balance = $account_qry['data'][0]["maximum_balance"];
            // call FPS system to caculate how much the system can send him
            $filterObj = new stdClass();
            $filterObj->filter = new stdClass();
            $filterObj->filter->payee_reference_code = "TRUCK_OWNER";
            $filterObj->filter->payee_reference_value = $truck_owner_id;
            $filterObj->filter->status_in = ["NEW", "ACTIVE"];
            $claimsReuslt =  $_fps->searchClaims($filterObj, $_SESSION['user_id']);
            $total_new = 0;
            $total_active = 0;
            foreach ($claimsReuslt['data'] as $claim) {
                if ($claim["status"] === "NEW") {
                    $total_new = $total_new + $_fps->getClaimRemainingAmount($claim['id'], 0);
                }
                if ($claim["status"] === "ACTIVE") {
                    $total_active = $total_active + $_fps->getClaimRemainingAmount($claim['id'], 0);
                }
            }
            $remaining_balance = $maximum_balance - ($total_new + $total_active);
            $listOrOwnedTrucks = [];
            foreach ($truckResult->data as  $OneTenderTruck) {
                $newRow = new stdClass();
                $newRow->new_claims_amount = 0;
                $newRow->active_claims_amount = 0;
                $newRow->tn = $OneTenderTruck->tn;
                $newRow->truck_id = $OneTenderTruck->truck_id;
                $newRow->tender_truck_id = $OneTenderTruck->id;
                foreach ($claimsReuslt['data'] as $OneClaim) {
                    $tnFromTenderTruck = $OneTenderTruck->tn;
                    $tnFromClaims = json_decode($OneClaim["claim_details"])->tn;
                    if ($tnFromTenderTruck == $tnFromClaims) {
                        if ($OneClaim["status"] === "NEW") {
                            $newRow->new_claims_amount = $newRow->new_claims_amount + $_fps->getClaimRemainingAmount($OneClaim['id'], 0);
                        }
                        if ($OneClaim["status"] === "ACTIVE") {
                            $newRow->active_claims_amount = $newRow->active_claims_amount + $_fps->getClaimRemainingAmount($OneClaim['id'], 0);
                        }
                    }
                }
                $listOrOwnedTrucks[] = $newRow;
            }
            $res = new stdClass;
            $res->basic = new stdClass();
            $res->basic->truck_owner_id = $truck_owner_id;
            $res->basic->truck_owner_name = $truck_owner_name;
            $res->basic->is_vip = $is_vip;
            $res->basic->instruction_url = $this->getMgPayInstructionTemnplate();
            $res->basic->rate_caption = "فئة ذهبية";
            $res->basic->rate_color = "#FFD700";
            $res->basic->rate_tooltip_msg = "تستطيع طلب سلفة ضمن الحد المتاح وسيتم قبولها بشكل تلقائي";

            $res->details = [];
            $res->details[] = ["value" => $total_new, "label" => "المبلغ المطلوب"];
            $res->details[] = ["value" => $total_active, "label" => "المبلغ المسحوب"];
            $res->details[] = ["value" => $maximum_balance, "label" => "سقف الذمة"];
            $res->dashboard = new stdClass();
            $res->dashboard->max = $maximum_balance;
            $res->dashboard->min = 0;
            $res->dashboard->value = $remaining_balance;
            $res->dashboard->label = "مبلغ السلفة المتاح";
            $res->truckOwnerTrucks = $listOrOwnedTrucks;
            $res->basic->has_no_contract_message = "هل أنت متأكد من رغبتك باضافة شاحنة جديدة لمشروع السلف؟";

            $res->truckOwnerTrucks_template = '
                <!DOCTYPE html>
                <html lang="ar">
                <head>
                <meta charset="UTF-8">
                <meta http-equiv="X-UA-Compatible" content="IE=edge">
                <meta name="viewport" content="width=device-width, initial-scale=1.0">
                <script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.19.2/axios.min.js"></script>
                <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
                <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
                <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
                <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
                <title>Document</title>
                <style>
                    body {
                        font-family: "Cairo-Regular";
                        direction: rtl;
                    }
                </style>
                </head>
                <body>
                <label style="
                    padding: 0;
                    padding-top: 0px;
                    margin: 0;
                    padding-top: 1%;
                    font-size: 24px;
                    height: 51px;
                    width: 100%;
                    text-align: center;
                ">الشاحنات المسجلة على المشروع
                </label>
                <table class="table table-condensed table-hover table-striped table-bordered " style="text-align: center; width: 100%;margin: 0px;
                    max-width: 100%;font-family: "Cairo-Regular";
                    ">
                    <thead>
                    <tr>
                        <th style="text-align: center ; font-weight: bolder ; width: 10% ; color: #3995d2;font-size: 20px;"> رقم الشاحنة</th>
                        <th style="text-align: center ; font-weight: bolder ; width: 10% ; color: #3995d2;font-size: 20px;"> المطلوب </th>
                        <th style="text-align: center ; font-weight: bolder ; width: 10% ; color: #3995d2;font-size: 20px;"> المسحوب </th>
                    </tr>
                    </thead>

                    <tbody class="dist-info-table">';
            foreach ($listOrOwnedTrucks as $tnRow) {
                $res->truckOwnerTrucks_template .= "<tr>
                                <td>
                                $tnRow->tn
                                </td>
                                <td>
                                $tnRow->new_claims_amount
                                </td>
                                <td>
                                $tnRow->active_claims_amount
                                </td>
                            </tr>";
            }
            $res->truckOwnerTrucks_template .= '</tbody>
                </table>
                </body>
                </html>
             ';

            // generate bie chart
            // $chart_Engine = new Chart_Engine();
            // $dashboard_url = $chart_Engine->GenerateHorizantalStackedBarChart($total_active, $maximum_balance);
            // $res->dashboard->dashboard_url = $dashboard_url;
        }
        parent::response($res);
    }


    // ---------------------------------------------------------------------------------------- //
    // ------------- Get Instruction HTML web view for MG Pay on mobile ----------------------- //
    // ---------------------------------------------------------------------------------------- //
    private function getMgPayInstructionTemnplate()
    {
        return '<!DOCTYPE html><html lang="ar"> <head> <meta http-equiv="X-UA-Compatible" content="IE=edge" /> <meta name="viewport" content="no, initial-scale=no, maximum-scale=no" /> <meta charset="utf-8" /> <meta name="viewport" content="width=device-width, initial-scale=1" /> <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css" /> <link rel="stylesheet" media="screen" href="https://fontlibrary.org/face/droid-arabic-kufi" type="text/css" /> <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script> <script src="https://cdnjs.cloudflare.com/ajax/libs/axios/0.19.2/axios.min.js"></script> <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script> <title>Document</title> <style> .MinagateFont { font-family: DroidArabicKufiRegular; font-weight: lighter; font-style: normal; /* color: #eee; */ font-size: 15px; margin: 2%; padding: 2%; /* text-align: center; */ } .labelStyle { text-align: right; padding-right: 25px; } .valueStyle { text-align: right; color: rgb(74, 163, 222); } .divStyle { /* font-size: large; */ margin-top: 10px; /* padding: 4px; */ /* padding-bottom: 5%; */ /* border-bottom: solid 0.5px #ccc; */ /* text-align: center; */ } </style> <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.0/css/bootstrap.min.css" /> </head> <body dir="rtl" class="MinagateFont" style=" background-image: url(\'https://storage.googleapis.com/g.minagate.com/menuItemsBackgroundTop.jpg\'); background-repeat: no-repeat; background-size: cover; " > <div> <div style="text-align: center"><b>التعليمات</b></div> <form> <div class="divStyle" style="text-align: justify; padding-bottom: 10px; border-bottom: solid 0.5px #ccc"> تقدم شركة مدارج بالتعاون مع الشركة الوطنية للمحروقات خدمة صرف مستحقات الارسالية بالاضافة لخدمة صرف سلفة ديزل, حيث تستطيع الاستفادة من هذه الخدمة عن طريق ارسال طلب سلفة ديزل عبر التطبيق, وذلك ضمن الشروط و التعليمات التالية . </div> <div class="divStyle"><b>1.</b> الحد الاعلى للسلفة هو <b>250</b> دينار لكل شاحنة .</div> <div class="divStyle"><b>2.</b> يتم سداد السلفة عبر اقتطاع قيمتها من قيمة الارسالية بعد التحميل .</div> <div class="divStyle"><b>3.</b> يجب تسليم الارسالية خلال مدة اقصاها <b>7</b> ايام من تاريخ استلام السلفة .</div> <div class="divStyle"><b>4.</b> خدمة سلف الديزل مجانية بدون عمولة .</div> <div class="divStyle"><b>5.</b> يتم اقتطاع مبلغ <b>10</b> دنانير بدل عمولة صرف الارسالية بعد تفريغ الحمل .</div> <div class="divStyle"> <b> 6.</b> تستطيع صرف مستحقات الارسالية في أي من محطات الوطنية للمحروقات المعتمدة لدينا في المواقع التالية : <!-- <label class="col-sm-7 col-md-7 col-xs-7 col-form-label valueStyle">2022-01-12 </label> --> <div class="row"> <div id="available_stations" class="col-xs-12 text-center" style="display: flex; justify-content: space-evenly; flex-wrap: wrap" ></div> </div> <div class="col-xs-12" style="font-size: 12px; text-align: center; padding-bottom: 10px; border-bottom: solid 0.5px #ccc" > تستطيع الضغط على أي محطة للحصول على الاتجاهات </div> <div style="text-align: center" class="col-xs-12"> <img src="https://storage.googleapis.com/waybill_system_config/MG_logo.png" alt="" style="width: 300px" /> </div> </div> </form> </div> </body> <script> axios .post("https://api.minagate.com/publicAPI", { method: "renderAvailableStatios", }) .then(function (response) { let available_stations = response.data.available_stations; available_stations.forEach((station, i) => { var img = document.createElement("img"); img.src = station.image_url; img.width = 100; img.height = 100; img.style.borderRadius = "64.5px"; img.style.marginTop = "20px"; img.style.border = "2px solid rgb(151, 198, 103)"; var d = document.createElement("div"); d.setAttribute("style", "width:110px"); var p = document.createElement("label"); p.innerHTML = station.name; p.setAttribute("style", "font-size:10px"); var h = document.createElement("a"); h.setAttribute("href", station.location); h.append(img); h.append(p); d.append(h); document.getElementById("available_stations").append(d); }); }) .catch(function (error) { console.log(error); document.getElementById("error_massage").innerHTML = "<div class=\'error_massage_class\' align=\'center\'><h2>لا توجد معلومات متوفرة</h2></div>"; }); </script></html>';
    }


    // -------------------------------------------------------------------------- //
    // ----------- Create New ticket for advance payment (Diesel) --------------- //
    // -------------------------------------------------------------------------- //
    public function createRequestAdvancePaymentTicket()
    {
        $tn = $this->_request->tn;
        $amount = $this->_request->amount;

        // validate if the truck is for the user
        $truckFilter = [['key' => 'tn', 'val' => $tn]];
        $truck_result = $this->_truckCore->searchTrucks($truckFilter, 1, 0, $_SESSION['user_id']);
        if ($truck_result->found_rows == 0) {
            throw new Exception("لا يوجد لديك صلاحية للمتابعة");
        }

        // get MGPAY tender
        $tender_id = $this->_tenderCore->getMgPayTender()->id;

        // check if the truck has already tender truck
        $tender_truck_id = null;
        $truck_owner_id = null;
        $truck_owner_name = null;
        $truck_owner_phone = null;
        $truck_owner_nn = null;

        $tenderFilter = [
            ['key' => 'tn', 'val' => $tn],
            ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in'],
            ['key' => 'tender_id', 'val' => $tender_id]
        ];
        $tenderTruck_qry = $this->_tenderCore->searchTenderTruck($tenderFilter, 1, 0, 0);
        if ($tenderTruck_qry->found_rows > 0) {
            $tenderTruckBean = $tenderTruck_qry->data[0];
            $tender_truck_id = $tenderTruckBean->id;

            $financial_details = $tenderTruckBean->financial_details;
            $financial_details = json_decode($financial_details);
            $truck_owner_id = $financial_details->truck_owner->id;

            $truck_ownerFilter = [['key' => 'id', 'val' => $truck_owner_id]];
            $truckOwnerBean =  $this->_truckOwnerCore->searchTruckOwner($truck_ownerFilter, 1, 0, 0)->data[0];
            $truck_owner_name = $truckOwnerBean->name;
            $truck_owner_phone = $truckOwnerBean->phone;
            $truck_owner_nn = $truckOwnerBean->nn;

            // validate if the truck has exceeded its advance payment limit
            $_fps = new FPS();
            $tender_bean = $this->_tenderCore->getTenderBasic($tender_id, 0);
            $account_ledger_id = $tender_bean->manifest->account_ledger_id;
            $accountFilter = new stdClass();
            $accountFilter->filter = ["id" => $account_ledger_id, "truck_owner_id" => $financial_details->truck_owner->id];
            $accountFilter->filter = json_encode($accountFilter->filter);
            $account_qry =  $_fps->searchAccount($accountFilter, 0);

            $truckAccount = $account_qry['data'][0];
            if ($truckAccount['balance'] + $amount > $truckAccount['maximum_balance']) {
                throw new Exception("ذمة الشاحنة تجاوزت الحد المسموح");
            }
        } else {
            throw new Exception("الشاحنة غير مسجلة في الخدمة ، يرجى مراجعة مكتب الشركة في ساحة الإتحاد");
        }

        $ticket = new stdClass();
        $ticket->title = "طلب سلفة";
        $ticket->senderName = "مدارج للخدمات اللوجستية";
        $ticket->type_code = "REUQEST_ADV_PAYMENT";
        $ticket->priority = 3;
        $ticket->company_id = 266770;
        $ticket->type = "CLIENT";
        $ticket->body = [
            "tender_id" => $tender_id,
            "tn" => $tn,
            "amount" => $amount,
            "tender_truck_id" => $tender_truck_id,
            "truck_owner_id" => $truck_owner_id,
            "truck_owner_name" => $truck_owner_name,
            "truck_owner_phone" => $truck_owner_phone,
            "truck_owner_nn" => $truck_owner_nn
        ];


        $this->_customerCare->createTicket($ticket);

        $Result = [];
        $Result['ERRORCODE'] = '0';
        $Result['MESSAGE'] = 'تم انشاء طلب سلفة بنجاح ، سوف يتم التواصل معك من قبل فريق العمليات للمتابعة';
        parent::response($Result);
    }


    // -------------------------------------------------------------------------- //
    // ----------- Create New ticket for joining the MG Pay Project ------------- //
    // -------------------------------------------------------------------------- //
    public function createJoinMgPayTicket()
    {
        $answers = $this->_request->answers;

        $answers = is_string($answers) ? json_decode($answers, true) : $answers;
        $imageQuestions = array_filter($answers, function ($answer) {
            return strpos($answer->value, "http") !== false;
        });
        foreach ($imageQuestions as $imageQuestion) {
            $liecence_photo_front = $imageQuestion->value;
        }
        $imageQuestions = array_filter($answers, function ($answer) {
            return strpos($answer->value, "60") !== false;
        });
        foreach ($imageQuestions as $imageQuestion) {
            $tn = $imageQuestion->value;
        }

        // validate if the truck is for the user
        $truckFilter = [['key' => 'tn', 'val' => $tn]];
        $truck_result = $this->_truckCore->searchTrucks($truckFilter, 1, 0, $_SESSION['user_id']);
        if ($truck_result->found_rows == 0) {
            // throw new Exception("لا يوجد لديك صلاحية للمتابعة");
        }

        // get MGPAY tender
        $tender_id = $this->_tenderCore->getMgPayTender()->id;

        // check if the truck has already tender truck
        $tenderFilter = [
            ['key' => 'tn', 'val' => $tn],
            ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in'],
            ['key' => 'tender_id', 'val' => $tender_id]
        ];
        $tenderTruck_qry = $this->_tenderCore->searchTenderTruck($tenderFilter, 1, 0, 0);
        if ($tenderTruck_qry->found_rows > 0) {
            throw new Exception("الشاحنة مسجلة مسبقا على المشروع");
        }

        $truck_owner_id = $_SESSION['truck_owner_id'];
        $truck_ownerFilter = [['key' => 'id', 'val' => $truck_owner_id]];
        $truckOwnerBean =  $this->_truckOwnerCore->searchTruckOwner($truck_ownerFilter, 1, 0, 0)->data[0];
        $truck_owner_name = $truckOwnerBean->name;
        $truck_owner_phone = $truckOwnerBean->phone;
        $truck_owner_nn = $truckOwnerBean->nn;

        $ticket = new stdClass();
        $ticket->title = "طلب انضمام لمشروع السلف - " . $tn;
        $ticket->senderName = "مدارج للخدمات اللوجستية";
        $ticket->type_code = "REUQEST_JOIN_MG_PAY";
        $ticket->priority = 3;
        $ticket->company_id = 266770;
        $ticket->type = "CLIENT";
        $ticket->body = [
            "tender_id" => $tender_id,
            "tn" => $tn,
            "liecence_photo_front" => $liecence_photo_front,
            "truck_owner_id" => $truck_owner_id,
            "truck_owner_name" => $truck_owner_name,
            "truck_owner_phone" => $truck_owner_phone,
            "truck_owner_nn" => $truck_owner_nn
        ];

        $this->_customerCare->createTicket($ticket);

        // send notification to abdallah
        $message = "طلب انضمام جديد لمشروع السلف للشاحنة " . $tn;
        $messageRecipient = "0791102106";
        $messageRecipient = convertToInternational($messageRecipient);
        sendSMS($messageRecipient, $message);

        // Send notification to Hamzah
        $messageRecipient = "0791233491";
        $messageRecipient = convertToInternational($messageRecipient);
        sendSMS($messageRecipient, $message);

        $Result = [];
        $Result['ERRORCODE'] = '0';
        $Result['MESSAGE'] = 'تم ارسال طلبك بنجاح';
        parent::response($Result);
    }


    public function getCompatibleReportMobile()
    {
        $tender_id = $this->_request->tender_id;

        if ($tender_id == 3) {
            $route = [
                ['template' => 'mobile_cargo_performance_report', 'label' => 'تقرير  اداء التحميل ']
            ];
            parent::response($route);
        }
    }
}

$tender_interface = new Tender_interface();
