<?php
ini_set('max_execution_time', 300); //300 seconds = 5 minutes

// import objects
require_once(dirname(__FILE__) . "/../../includes/DBConnection.php");
require_once(dirname(__FILE__) . "/../../includes/util.php");
require_once(dirname(__FILE__) . "/../queue/queue_core.php");
require_once(dirname(__FILE__) . "/../cargo/cargo_core.php");
require_once(dirname(__FILE__) . "/../driver/driver_core.php");
require_once(dirname(__FILE__) . "/../waybill/waybill_core.php");
require_once(dirname(__FILE__) . "/../tender_company/tender_company_core.php");
require_once(dirname(__FILE__) . "/../waybill_order/waybill_order_core.php");
require_once(dirname(__FILE__) . "/../account/account_core.php");
require_once(dirname(__FILE__) . "/../taskQueues/taskQueues_core.php");
require_once(dirname(__FILE__) . "/../../includes/config.php");
require_once(dirname(__FILE__) . "/../../core/outgoing_integration/customer_care.php");
class TenderCore
{

    private $_queueServeMap = ['servedTrucks' => [], 'acceptedTrucks' => [], 'rejectedTrucks' => [], 'orders' => [], 'queuesCargoCount' => [], 'maxRows' => 0];
    private $_quotaServeMap = ['servedCompanies' => [], 'acceptedCompanies' => [], 'rejectedCompanies' => [], 'orders' => [], 'ordersCargoCount' => []];
    private $_truckCore;
    private $_truckContractCore;
    private $_customerCare;

    public function __construct()
    {
        DBConnection::getInstance();
        $this->_truckCore = new TruckCore();
        $this->_tenderCompanyCore = new TenderCompanyCore();
        $this->_accountCore = new AccountCore();
        $this->_truckContractCore = new TruckContractCore();
        $this->_customerCare = new CustomerCare();
    }

    public function getQueueServeStatus()
    {
        return 1;
    }
    // ------------------------------------------------------------------------ //
    // -------------------Create Tender bean and fill it from DB  ------------- //
    // ------------------------------------------------------------------------ //
    public function getTender($id, $user_id)
    {

        $tenderInfo = DBConnection::getObjectBean("tender", $id, $user_id);

        return $tenderInfo;
    }

    // ------------------------------------------------------------------------ //
    // -------------------Create Tender bean and fill it from DB  ------------- //
    // ------------------------------------------------------------------------ //
    public function getTenderBasic($id, $user_id)
    {

        $tenderInfo = DBConnection::getBasicObjectBean("tender", $id, $user_id);

        return $tenderInfo;
    }

    // ------------------------------------------------------------------------ //
    // -------------------get Tender manafest and parse it from DB  ------------- //
    // ------------------------------------------------------------------------ //
    public function getTenderManifest($id, $user_id)
    {
        $tender = $this->getTenderBasic($id, $user_id);
        $man = json_decode(json_encode($tender->manifest), TRUE);
        return $this->parseTenderManifest($man);
    }



    public function getTenderOrigin($tender_id, $user_id)
    {

        $tenderManifestJSON = $this->getTenderManifest($tender_id, $user_id);
        $result = [];
        $manifest_questionnaire = $tenderManifestJSON['questionnaire'];
        foreach ($manifest_questionnaire as $questions) {
            if ($questions['question_type'] == 'ROUTE:ORIGIN') {
                foreach ($questions['options'] as $temp) {
                    if ($temp['id'] != 0) {
                        $item = new stdClass();
                        $item->id = $temp['id'];
                        $item->name = $temp['name'];
                        array_push($result, $item);
                    }
                }
            }
        }
        return $result;
    }



    // --------------------------------------------------------------------------------------------------------------------------------- //
    // ------------------------------ Get a list of  destination locations for a certain order ----------------------------------------- //
    // --------------------------------------------------------------------------------------------------------------------------------- //
    public function getAllTenderDestinations($tender_id, $user_id)
    {


        $tenderManifestJSON = $this->getTenderManifest($tender_id, $user_id);

        if ($tenderManifestJSON) {

            if ($tenderManifestJSON['tender_code'] == 'JO_PETROL_AQ') {
                $result = [91030015];   //مصفاة البترول في الزرقاء
            } else {
                $result = $this->getTenderDestinations($tender_id);
            }
        }

        return $result;
    }



    public function getTenderOriginForMerchant($tender_id, $user_id)
    {

        $tenderManifestJSON = $this->getTenderManifest($tender_id, $user_id);
        $result = [];
        $manifest_questionnaire = $tenderManifestJSON['questionnaire'];

        $item = new stdClass();
        $item->id = null;
        $item->name = "الرجاء الإختيار";
        array_push($result, $item);

        foreach ($manifest_questionnaire as $questions) {
            if ($questions['question_type'] == 'ROUTE:DISTINATION') {
                foreach ($questions['options'] as $temp) {
                    if ($temp['id'] != 0) {
                        $item = new stdClass();
                        $item->id = $temp['id'];
                        $item->name = $temp['name'];
                        array_push($result, $item);
                    }
                }
            }
        }
        return $result;
    }








    // ------------------------------------------------------------------------ //
    // -------------------search for tender using any search filter ----------- //
    // ------------------------------------------------------------------------ //
    public function searchTender($searchFilter, $limit, $offset, $user_id, $order_by = null)
    {

        $searchTenderResult = DBConnection::searchDB("tender", $searchFilter, $limit, $offset, $user_id, $order_by);
        return $searchTenderResult;
    }

    // ------------------------------------------------------------------------ //
    // -------------------search for tender using any search filter ----------- //
    // ------------------------------------------------------------------------ //
    public function searchTenderTruck($searchFilter, $limit, $offset, $user_id)
    {

        $searchTenderResult = DBConnection::searchDB("tender_truck", $searchFilter, $limit, $offset, $user_id);
        return $searchTenderResult;
    }



    // ------------------------------------------------------------------------------- //
    // --------------------- get list of queues on a certain tender ------------------ //
    // ------------------------------------------------------------------------------- //
    public function searchTenderQueues($searchFilter, $limit, $offset, $user_id)
    {

        $searchTenderResult = DBConnection::searchDB("tender", $searchFilter, $limit, $offset, $user_id);
        return $searchTenderResult;
    }


    // ------------------------------------------------------------------------ //
    // -------------------create new tender order ----------------------------- //
    // ------------------------------------------------------------------------ //
    public function createTenderOrder($tenderBean,  $user_id)
    {

        //validate tenderBean
        $tenderBean->create_date = DBConnection::getSystemDate();
        $this->validateTenderOrderForCreate($tenderBean, $user_id);
        $createTenderResult = DBConnection::insertDB("tender_order", $tenderBean, $user_id);
        $order_ID =  $createTenderResult[0]['@id'];

        return $order_ID;
    }

    // ------------------------------------------------------------------------------------ //
    // ------------------- Validate if the tender order has the right structure------------ //
    // ------------------------------------------------------------------------------------ //
    private function validateTenderOrderForCreate($tenderOrderBean, $user_id)
    {
        //validate there is q_id and tender_id
        if (!$tenderOrderBean->tender_id) {
            throw new Exception("Illegal tender order! tender must be defined.");
        }

        // validate cargo list, it must be array of integers only
        if (isArrayOfType($tenderOrderBean->cargo, 'integer') != true) {
            //throw new Exception("Illegal tender cargo! cargo list must be array of integer.");
        }


        if ($tenderOrderBean->questionnaire && $tenderOrderBean->questionnaire != "[]") {
            //validate the questionnaire is valid JSON
            $tenderBeanJSON = is_string($tenderOrderBean->questionnaire) ?  json_decode($tenderOrderBean->questionnaire) : $tenderOrderBean->questionnaire;
            if ($tenderBeanJSON == null) {
                throw new Exception("Illegal order questionnaire answers! Answers must be a valid JSON document.");
            }

            // throw exception if tender questionnaire answers is not array of object
            if ($this->isArrayOfType($tenderBeanJSON, 'object') != true) {
                throw new Exception("Illegal tender order! answers must be array of objects! ");
            }

            foreach ($tenderBeanJSON as $answer) {

                // answer id must be defined
                if (!$answer->id) {
                    throw new Exception("Illegal tender order! answer id property must be provided! ");
                }

                // answer val must be defined
                if (is_array($answer->val)) {
                    if (count($answer->val) == 0) {
                        throw new Exception("Illegal tender order! answer val property must be provided! ");
                    }
                } else {
                    if (!strlen($answer->val)) {
                        throw new Exception("Illegal tender order! answer val property must be provided! ");
                    }
                }
            }

            //validate the order questionnaire has the same number of #ANSWERS# as tender questionnaire #QUESTIONS#
            $tenderMan = $this->getTenderManifest($tenderOrderBean->tender_id, 0);
            if (sizeOf($tenderMan['questionnaire']) != sizeOf($tenderBeanJSON)) {
                throw new Exception("Illegal tender order! number of answers dose not match number of questions  ");
            }
        }


        // validate if tender company has payment service, and route wage is not defined for destination
        $tenderBean = $this->getTenderBasic($tenderOrderBean->tender_id, $user_id);
        if (!$tenderBean) {
            throw new Exception("cant create tender order for not owned tender ");
        }

        // in case the company has payment service , search for route wage of the destination
        $hasPayment = $this->_tenderCompanyCore->hasPaymentService($tenderOrderBean->tender_id, $tenderBean->company_id, null);
        if ($hasPayment) {
            // search through tender order questionaire questions to look for destination_id
            $destination_id = null;
            if (is_string($tenderOrderBean->questionnaire)) {
                $answers = json_decode($tenderOrderBean->questionnaire);
            } else {
                $answers = $tenderOrderBean->questionnaire;
            }

            foreach ($tenderMan['questionnaire'] as $question) {
                if ($question['question_type'] == 'ROUTE:DISTINATION') {
                    foreach ($answers as $tenderAnswer) {
                        if ($tenderAnswer->id == $question['id']) {
                            $destination_id = $tenderAnswer->val;
                            break;
                        }
                    }
                    break;
                }
            }
        }
    }

    // ------------------------------------------------------------------------------ //
    // --------------------- Update tender order info in DB-------------------------- //
    // ------------------------------------------------------------------------------ //
    function updateTenderOrder($tender_order_bean, $tender_order_id, $updated_by)
    {

        // fill update struct and set the target user id
        $tender_order_bean->id = $tender_order_id;

        // get basic object bean without any activites
        $DB_Bean = DBConnection::getBasicObjectBean("tender_order", $tender_order_id, $updated_by);

        //update tender info only if the tender bean is different than DB bean
        if (compareObject($tender_order_bean, $DB_Bean) == false) {

            // map all the new values into the DB_bean
            $tender_order_bean = mapBeanToDBBean($tender_order_bean, $DB_Bean);

            //re-validate the user input
            $this->validateTenderOrderForCreate($tender_order_bean, $updated_by);

            if (is_string($tender_order_bean->questionnaire)) {
                $tender_order_bean->questionnaire = json_decode($tender_order_bean->questionnaire);
            }


            // fill update struct and set the target user id
            DBConnection::updateDB("tender_order", $tender_order_bean, $updated_by);
            $this->autoAssignCargo($tender_order_bean, $tender_order_id, $updated_by);
        }
    }


    // ------------------------------------------------------------------------------------------- //
    // --------------- distribute Tender Order when "distribte_method" is set to auto ------------ //
    // --------------- and when number of cargo reaches the limit to create the order ------------ //
    // ------------------------------------------------------------------------------------------- //
    public function autoAssignCargo($tender_order_bean, $tender_order_id, $user_id)
    {

        // get the tender manifest
        $tenderBean = $this->getTenderBasic($tender_order_bean->tender_id, 0);
        $tenderManifest = $tenderBean->manifest;

        // if tender distribte_method is set to auto = automaticaly assign the cargo
        if ($tender_order_bean->q_id && $tenderManifest->distribte_method == 'auto') {
            $cargoManifestNumber = (int)$tenderManifest->cargo_number;
            if ($tender_order_bean->trucks >= $cargoManifestNumber) {

                // change status of tender
                $this->changeOrderStatus($tender_order_id, 'ACTIVE', 0);

                // distribute it (assign its cargo)
                $this->distribute($tender_order_bean->tender_id, $tender_order_bean->q_id, 0);
            }
        }
    }

    // -------------------------------------------------------------------------------- //
    // -------------------- get bean for tender truck --------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function getTenderTruck($id,  $user_id)
    {
        $tenderTruckBean = DBConnection::getObjectBean("tender_truck", $id, $user_id);
        return $tenderTruckBean;
    }

    // -------------------------------------------------------------------------------------- //
    // -------------------- get basic bean for tender truck --------------------------------- //
    // -------------------------------------------------------------------------------------- //
    public function getTenderTruckBasic($id,  $user_id)
    {
        $tenderTruckBean = DBConnection::getBasicObjectBean("tender_truck", $id, $user_id);
        return $tenderTruckBean;
    }

    // -------------------------------------------------------------------------------- //
    // -------------------- get bean for tender order --------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function getTenderOrder($id,  $user_id)
    {

        $tenderOrderBean = DBConnection::getObjectBean("tender_order", $id, $user_id);
        return $tenderOrderBean;
    }

    // -------------------------------------------------------------------------------------- //
    // -------------------- get basic bean for tender order --------------------------------- //
    // -------------------------------------------------------------------------------------- //
    public function getTenderOrderBasic($id,  $user_id)
    {

        $tenderOrderBean = DBConnection::getBasicObjectBean("tender_order", $id, $user_id);
        return $tenderOrderBean;
    }



    // ------------------------------------------------------------------------ //
    // -------------------create new tender truck ----------------------------- //
    // ------------------------------------------------------------------------ //
    public function createTenderTruck($tenderTruck, $user_id)
    {

        //validate if the truck is eligable to create
        $truckBean = $this->_truckCore->getTruck($tenderTruck->truck_id, $user_id);

        $truckBean = json_decode($truckBean);
        $this->validateTenderTruckForCreate(
            $truckBean->tn,
            $tenderTruck->tender_id,
            $tenderTruck->tender_company_id,
            $user_id
        );

        // create the DB record
        $createTenderTruckResult = DBConnection::insertDB("tender_truck", $tenderTruck, $user_id);
        $truck_ID =  $createTenderTruckResult[0]['@id'];

        return $truck_ID;
    }


    // -------------------------------------------------------------- //
    // -------------------create tender ----------------------------- //
    // -------------------------------------------------------------- //
    public function createTender($tenderBean, $user_id)
    {

        // create the DB record
        $tenderBeanResult = DBConnection::insertDB("tender", $tenderBean, $user_id);
        $tender_id =  $tenderBeanResult[0]['@id'];

        return $tender_id;
    }


    // ------------------------------------------------------------------------ //
    // -------------------create  createClientTenderTruck createClientTenderTrucknew tender truck ----------------------------- //
    // ------------------------------------------------------------------------ //
    public function createClientTenderTruck($tenderTruck, $user_id)
    {

        $truckFilter = [
            ['key' => 'truck_id', 'val' => $tenderTruck->truck_id],
            ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in'],
            ['key' => 'cat', 'val' => ['TRUCK-SINGLE', 'TRUCK'], 'op' => 'in']
        ];
        $contract_qry = $this->_truckContractCore->searchTruckContracts($truckFilter, 1, 0, $user_id);
        if ($contract_qry->found_rows > 0) {
            $truckBean = new stdClass();
            $contractBean = $contract_qry->data[0];
            $truckBean->id = $contractBean->truck_id;
            $truckBean->tn = $contractBean->tn;
            $truckBean->truck_owner_id = $contractBean->truck_owner_id;
            $truckBean->status = $contractBean->truck_status;
            $truckBean->tt = $contractBean->tt;
            $truckBean->minor_tt = $contractBean->minor_tt;
            $truckBean->cat = $contractBean->cat;
        } else {
            throw new Exception("TRUCK.INVALID_TRUCK");
        }


        //validate if the truck is eligable to create
        $this->validateTenderTruckForCreate(
            $truckBean->tn,
            $tenderTruck->tender_id,
            $tenderTruck->tender_company_id,
            $user_id
        );

        // create the DB record
        $createTenderTruckResult = DBConnection::insertDB("tender_truck", $tenderTruck, $user_id);
        $truck_ID =  $createTenderTruckResult[0]['@id'];

        return $truck_ID;
    }

    // ------------------------------------------------------------------------------------------------------------ //
    // -------------------- Validate if the truck can be added to tender truck ------------------------------------ //
    // -------------------- the truck has to be active on the company fleet --------------------------------------- //
    // -------------------- the contract type has to be authorized in the tender company table -------------------- //
    // ------------------------------------------------------------------------------------------------------------ //
    public function validateTenderTruckForCreate($tn, $tender_id, $tender_company_id, $user_id)
    {

        // Step 1: search if the truck is registerd on the system
        $tnFilter = [['key' => 'tn', 'val' => $tn], ['key' => 'status', 'val' => 'ACTIVE']];
        $truck_qry = $this->_truckCore->searchTrucks($tnFilter, 1, 0, 0);

        if ($truck_qry->found_rows == 0) {
            throw new Exception("TENDER_TRUCK.TRUCK_NOT_REGISTERED", 105);
        }

        // Step 2: search if the truck is already registered as ACTIVE on tender
        $activeTenderTrucks = DBConnection::getActiveStatus('truck_contract');
        $tenderFilter = [
            ['key' => 'truck_id', 'val' => $truck_qry->data[0]->id],
            ['key' => 'status', 'val' => $activeTenderTrucks, 'op' => 'in'],
            ['key' => 'tender_id', 'val' => $tender_id]
        ];
        $tenderTruck_qry = $this->searchTenderTruck($tenderFilter, 1, 0, $user_id);

        if ($tenderTruck_qry->found_rows > 0) {

            $searchInUseFilter = [['key' => 'id', 'val' => $tenderTruck_qry->data[0]->tender_company_id]];
            $inUseTenderCompanyBean = $this->_tenderCompanyCore->searchTenderCompany($searchInUseFilter, 1, 0, $user_id);

            throw new Exception("الشاحنة مسجلة مسبقا على المشروع مع شركة " . $inUseTenderCompanyBean->data[0]->name);
        }

        // Step 3: search if the truck contract type is defined in tender company
        $tenderCompanyBean = $this->_tenderCompanyCore->getTenderCompanyBasic($tender_company_id, $user_id);
        if (!$tenderCompanyBean->allowed_truck_contract_types) {
            throw new Exception("تسجيل الشركة على المشروع غير صحيح");
        }

        $truckContractCore = new TruckContractCore();
        $activeTruckContracts = DBConnection::getActiveStatus('truck_contract');
        $companyFleetFilter = [
            ['key' => 'truck_id', 'val' => $truck_qry->data[0]->id],
            ['key' => 'status', 'val' => $activeTruckContracts, 'op' => 'in'],
            ['key' => 'contract_type', 'val' => $tenderCompanyBean->allowed_truck_contract_types, 'op' => 'in']
        ];
        $contract_qry = $truckContractCore->searchTruckContracts($companyFleetFilter, 1, 0, $user_id);

        if ($contract_qry->found_rows == 0) {
            throw new Exception("TENDER_TRUCK.TRUCK_NOT_IN_COMPANY_FLEET_OR_NOT_AUTHORIZED");
        }
    }


    // -------------------------------------------------------------------------------- //
    // -------------------- change truck status on a certain tender ------------------- //
    // -------------------------------------------------------------------------------- //
    public function changeTruckStatus($truck_id, $new_status, $user_id)
    {

        $updateStruct = new stdClass();
        $updateStruct->id = $truck_id;
        $updateStruct->status = $new_status;

        // change the status
        DBConnection::updateDB("tender_truck", $updateStruct, $user_id);
    }


    // -------------------------------------------------------------------------------- //
    // -------------------- change order ststus --------------------------------------- //
    // -------------------------------------------------------------------------------- //
    public function changeOrderStatus($order_id, $new_status, $user_id)
    {

        $updateStruct = new stdClass();
        $updateStruct->id = $order_id;
        $updateStruct->status = $new_status;

        // get basic object bean without any activites
        $truckBean = DBConnection::getBasicObjectBean("tender_order", $order_id, $user_id);

        // map all the new values into the truckBean
        $truckBean->status = $new_status;

        // change the status
        DBConnection::updateDB("tender_order", $updateStruct, $user_id);
    }



    // -------------------------------------------------------------------- //
    // --------------------- Update tender truck info in DB------------------------ //
    // -------------------------------------------------------------------- //
    function updateTenderTruck($truckBean, $tender_truck_id, $updated_by)
    {

        // get basic object bean without any activites
        $DB_Bean = DBConnection::getBasicObjectBean("tender_truck", $tender_truck_id, $updated_by);

        //update truck info only if the truck bean is different than DB bean
        if (compareObject($truckBean, $DB_Bean) == false) {

            // map all the new values into the DB_bean
            $truckBean = mapBeanToDBBean($truckBean, $DB_Bean);

            //re-validate the user input
            unset($truckBean->tender_id);
            unset($truckBean->q_id);
            unset($truckBean->status);
            unset($truckBean->truck_id);

            // fill update struct and set the target user id
            $truckBean->id = $tender_truck_id;

            DBConnection::updateDB("tender_truck", $truckBean, $updated_by);
        }
    }


    // ------------------------------------------------------------------------ //
    // -------------------search for tender using any search filter ----------- //
    // ------------------------------------------------------------------------ //
    public function searchTenderOrder($searchFilter, $limit, $offset, $user_id, $order_by = null)
    {

        $searchTenderResult = DBConnection::searchDB("tender_order", $searchFilter, $limit, $offset, $user_id, $order_by);
        return $searchTenderResult;
    }

    // ------------------------------------------------------------------------ //
    // -------------------search for tender using any search filter ----------- //
    // ------------------------------------------------------------------------ //
    public function searchTenderOrderReports($report_number, $searchFilter, $limit, $offset, $user_id)
    {
        $searchTenderResult = DBConnection::searchReport("tender_order", $report_number, $searchFilter, $limit, $offset, $user_id);
        return $searchTenderResult;
    }


    // توزيع حصص الشركات
    // this method takes companioes from tender_company and serves them with available orders
    // it can serve single order or all orders by setting tender_order_ids to null
    public function getCompanyQuotas($tenderId, $queueId, $user_id, $tender_order_ids = null)
    {

        $map = &$this->_quotaServeMap;
        $map['maxRows'] = 500;
        $tenderMan = $this->getTenderManifest($tenderId, $user_id);

        $map['tenderMan'] = $tenderMan;
        $waybillOrderObj = new WaybillOrderCore();
        /*****************************************************************************
        Part one: retrive cargos associated to the selected orders
         ****************************************************************************/

        if ($tender_order_ids) {
            $searchFilter = [
                ['key' => 'tender_id', 'val' => $tenderId, 'op' => '='],
                ['key' => 'status', 'val' => ['ACTIVE'], 'op' => 'in'],
                ['key' => 'id', 'val' => $tender_order_ids, 'op' => 'in']
            ];
            $orders = $this->searchTenderOrderReports('01', $searchFilter, $map['maxRows'], 0, $user_id);
        } else {
            $searchFilter = [
                ['key' => 'tender_id', 'val' => $tenderId, 'op' => '='],
                ['key' => 'status', 'val' => ['ACTIVE'], 'op' => 'in']
            ];
            if ($queueId && $queueId != 0) {
                array_push($searchFilter, ['key' => 'q_id', 'val' => $queueId, 'op' => '=']);
            }

            $orders = $this->searchTenderOrderReports('01', $searchFilter, $map['maxRows'], 0, $user_id);
        }

        if ($orders->found_rows == 0) {
            throw new Exception(" لم يتم العثور على بضائع للتوزيع! أو تم حجز أوامر حركة لكامل الطلبيه");
        }
        // loop orders, parse objects and inject them into map object
        // $map['maxRows'] = 0 ;

        $map['waybillOrders'] = array();
        foreach ($orders->data as $order) {
            $order = json_decode(json_encode($order), $assoc = TRUE);
            $order['cargo'] = json_decode($order['cargo'], $assoc = TRUE);
            $order['questionnaire'] = $this->parseIndexedArray($order['questionnaire']);
            $order['cargo_details'] = $this->parseIndexedArray($order['cargo_details']);
            $order['order_date'] = date_create($order['order_date'], new DateTimeZone('Asia/Amman'));
            $order['servedTrucks'] = 0;
            $map['waybillOrders'][$order['id']] = array();
            if ($tenderMan['allowMultiTruckForCargo'] == FALSE) { // if every cargo needs one truck
                // if requested trucks not equal to number of cargos, fix the number of trucks
                $order['trucks'] = sizeof($order['cargo_details']);
            }
            $map['orders'][$order['id']] = $order;
        }
        $searchFilter = [
            ['key' => 'tender_order_id', 'val' => $this->propertyOfArray($map['orders'], 'id'), 'op' => 'in'],
            ['key' => 'status', 'val' => ['REVOKED'], 'op' => 'not in']
        ];
        $activeWaybillOrders = $waybillOrderObj->searchWaybillOrder($searchFilter, $map['maxRows'], 0, $user_id);
        foreach ($activeWaybillOrders->data as $waybillOrder) {
            array_push(
                $map['waybillOrders'][$waybillOrder->tender_order_id],
                [
                    'waybillOrder' => $waybillOrder->id,
                    'order' => $waybillOrder->tender_order_id,
                    'cargo' => $waybillOrder->cargo_id
                ]
            );
            $map['orders'][$waybillOrder->tender_order_id]['servedTrucks']++;
        }
        // delete object to free memory
        $orders = null;
        $activeWaybillOrders = null;

        /*****************************************************************************
        Part two: retrive companies associated to the selected tender
         ****************************************************************************/
        $searchFilter = [
            ['key' => 'tender_id', 'val' => $tenderId, 'op' => '='],
            ['key' => 'share', 'val' => 0, 'op' => '>']
        ];
        $tenderCompany = $this->_tenderCompanyCore->searchTenderCompany($searchFilter, $map['maxRows'], 0, $user_id);

        foreach ($tenderCompany->data as $comp) {

            $comp = [
                'id' => $comp->id,
                'name' => $comp->name,
                'companyId' => $comp->company_id,
                'tcId' => $comp->trucking_company_id,
                'share' => $comp->share,
                'questionnaire' => $this->parseIndexedArray($comp->questionnaire),
                'serviceList' => $comp->service_list,
                'status' => $comp->status
            ];
            if ($comp['status'] == 'ACTIVE') {
                $map['acceptedCompanies'][$comp['id']] = $comp;
            } else {
                $comp['rejectionReason'] = 'عقد تشغيل الشركة على العطاء موقوف أو غير فعال';
                $map['rejectedCompanies'][$comp['id']] = $comp;
            }
        }

        /*****************************************************************************
        Part three: validate companies againest orders and cargos (cargo type matching and questionnaire)
        if validation passes, matching companies with orders and cargos that are compatable
         ****************************************************************************/
        // loop the accepted companies to match questionnaire answers vs order questionnaire
        // if questionnaire answers don't match with any of cargos, then remove the company to rejected companies

        foreach ($map['acceptedCompanies'] as $comp) {
            // loop orders
            $companyBean = &$map['acceptedCompanies'][$comp['id']];
            $companyCargos = &$companyBean['orders'][$order['id']];
            $companyBean['availableCargos'] = [];
            foreach ($map['orders'] as $order) {
                // loop cargos, and save available cargos for accepted companies
                foreach ($order['cargo_details'] as $cargo) {
                    try {
                        if ($this->isQuestionnaireMatch($this->_quotaServeMap, $comp['questionnaire'], $order['id'], $cargo['id']) == 0) {
                            if (!isset($companyCargos)) {
                                $companyCargos['cargoList'] = array();
                            }
                            array_push($companyCargos['cargoList'], $cargo['id']);
                            $companyBean['availableCargos'][$order['id']][$cargo['id']] = $order['trucks'];
                        }
                    } catch (Exception $e) {
                        if ($e->getMessage() == 'answer_not_found') {
                            $comp['rejectionReason'] = "استبيان الشركة غير مكتمل! لا يمكن استكمال التوزيع للشركة!";
                            $map['rejectedCompanies'][$comp['id']] = $comp;
                            unset($map['acceptedCompanies'][$comp['id']]);
                        }
                    }
                }
            }

            if (!sizeof($map['acceptedCompanies'][$comp['id']]['availableCargos'])) {
                $comp['rejectionReason'] = "لا توجد بضائع متوافقة مع الشركة!";
                $map['rejectedCompanies'][$comp['id']] = $comp;
                unset($map['acceptedCompanies'][$comp['id']]);
            }
        }


        if (sizeOf($map['acceptedCompanies']) == 0) {
            $map['error_message'] = "لم يتم العثور على شركات فعالة على المشروع!";
            return $this->_quotaServeMap;
        }

        // calculate total shares for accepted companies
        $map['totalShare'] = 0;
        foreach ($map['acceptedCompanies'] as $id => $comp) {
            $map['totalShare'] += $comp['share'];
        }

        // calculate total trucks required
        $map['totalRequiredTrucks'] = 0;
        foreach ($map['orders'] as $id => $order) {
            $map['totalRequiredTrucks'] += $order['trucks'] - $order['servedTrucks'];
        }

        // calculate partial shares for accepted companies
        //create histogram array to use it later on for sorting companies by shares
        $param = [];
        $result = DBConnection::getGrainsCompanyShare($tenderId, $queueId);

        // $residual_compansation = $tenderMan['queues'][$queueId]['residual_compansation'];
        // if(!$residual_compansation) {
        //     $residual_compansation = 1.5;
        // }

        // residual_compansation = 1 - ((totalOrderCount * smallestCompanyShare ) / totalFleet)
        $smallestShare = $map['acceptedCompanies'][0]->share;
        $totalFleet = 0;
        foreach ($map['acceptedCompanies'] as $id => $comp) {
            if ($comp['share'] < $smallestShare) {
                $smallestShare = $comp['share'];
            }
            $totalFleet += $comp['share'];
        }

        $residual_compansation   = 1 - (($map['totalRequiredTrucks'] * $smallestShare) / $totalFleet);


        $resdArr = [];
        foreach ($result as $value) {
            $resdArr[$value->id] = $value->residual;
            // if the company resudual is larger than the threshold
            if (abs($resdArr[$value->id]) > $residual_compansation) {
                $resdArr[$value->id] = ($resdArr[$value->id] > 0 ? $residual_compansation : -1 * $residual_compansation);
            }
        }

        $map['hist'] = [];
        foreach ($map['acceptedCompanies'] as $id => $comp) {
            $map['acceptedCompanies'][$id]['quota'] = $map['totalRequiredTrucks'] * $comp['share'] / $map['totalShare'];
            // By default, remaining quota is the same as company quota
            $map['acceptedCompanies'][$id]['residual'] = $map['acceptedCompanies'][$id]['quota'];
            // TODO: get reseduals from old method calls, add them to the remainingQuota value (search tender_company_quota)
            $map['acceptedCompanies'][$id]['residual'] += $resdArr[$id];
            //Push company quota into histogram
            $map['hist'][$id] = $map['acceptedCompanies'][$id]['residual'];
        }
        /*****************************************************************************
        Part four: crate indexed arrays of companies and cargos to calculate available cargos
        and let every company to choose prefarable cargo to curry.
         ****************************************************************************/
        // output array in an array of objects, index is crgo ID, then every element is an object
        // of company ID and order id. Array will be created with empty quotas, to be filled later
        // TODO: Important: in case there are multiple cargos in one single order (containers)
        foreach ($map['orders'] as $id => $order) {
            foreach ($map['acceptedCompanies'] as $cid => &$comp) {
                // $map['output'][$cid][$id][$order['cargo'][0]]=0;
                $comp['used_quota'] = 0;
            }
        }
        asort($map['hist']);
        $minShareValue = 1;
        $maxloops = ceil(max($map['hist']));
        $map['totalAssignedTrucks'] = 0;

        // -------------------------- Add 70% to indivisual ------------------
        for ($i = 1; $i < ceil($map['totalRequiredTrucks'] * 0.7); $i++) {
            $compId = 197;
            $compCargos = $map['acceptedCompanies'][$compId]['availableCargos'];
            $orders  = [];
            if ($compCargos) {
                foreach ($compCargos as $key => $value) {
                    $orders = array_merge($orders, array_fill(0, array_values($value)[0], $key));
                }

                if (!sizeof($orders)) {
                    $orderId = $orders[0];
                } else {
                    $orderId = $orders[($compId * $compId) % sizeof($orders)];
                }

                if (gettype($compCargos[$orderId]) != 'array') continue;
                $cargoId = array_keys($compCargos[$orderId])[0];

                $map['output'][$compId][$orderId][$cargoId] += 1;
                $map['acceptedCompanies'][$compId]['residual'] -= 1;
                $map['acceptedCompanies'][$compId]['used_quota'] += 1;

                foreach ($map['acceptedCompanies'] as $id => $dummy) {
                    if (isset($map['acceptedCompanies'][$id]['availableCargos'][$orderId][$cargoId])) {
                        $map['acceptedCompanies'][$id]['availableCargos'][$orderId][$cargoId] -= 1;
                        if ($map['acceptedCompanies'][$id]['availableCargos'][$orderId][$cargoId] <= 0) {
                            unset($map['acceptedCompanies'][$id]['availableCargos'][$orderId]);
                        }
                    }
                }
                $map['hist'][$compId] -= 1;
                $map['totalAssignedTrucks'] += 1;
            }
        }

        // ------------------------------


        for ($i = 0; $i <= $maxloops; $i++) {

            arsort($map['hist']);

            if ($i == $maxloops && $map['totalAssignedTrucks'] < $map['totalRequiredTrucks']) {
                // when max number of loops exceeded, take shares from resedulas in desc order
                arsort($map['hist']);
                $minShareValue = -1 * $residual_compansation;
            }

            foreach ($map['hist'] as $compId => $item) {
                //echo $i.'-'.$map['totalAssignedTrucks'].'-'.$map['totalRequiredTrucks'].'<br>';
                if ($item >= $minShareValue) {
                    $compCargos = $map['acceptedCompanies'][$compId]['availableCargos'];
                    $orders  = [];
                    foreach ($compCargos as $key => $value) {
                        $orders = array_merge($orders, array_fill(0, array_values($value)[0], $key));
                    }

                    if (!sizeof($orders)) {
                        $orderId = $orders[0];
                    } else {
                        $orderId = $orders[($compId * $compId) % sizeof($orders)];
                    }

                    if (gettype($compCargos[$orderId]) != 'array') continue;
                    $cargoId = array_keys($compCargos[$orderId])[0];

                    $map['output'][$compId][$orderId][$cargoId] += 1;
                    $map['acceptedCompanies'][$compId]['residual'] -= 1;
                    $map['acceptedCompanies'][$compId]['used_quota'] += 1;

                    foreach ($map['acceptedCompanies'] as $id => $dummy) {
                        if (isset($map['acceptedCompanies'][$id]['availableCargos'][$orderId][$cargoId])) {
                            $map['acceptedCompanies'][$id]['availableCargos'][$orderId][$cargoId] -= 1;
                            if ($map['acceptedCompanies'][$id]['availableCargos'][$orderId][$cargoId] <= 0) {
                                unset($map['acceptedCompanies'][$id]['availableCargos'][$orderId]);
                            }
                        }
                    }

                    $map['hist'][$compId] -= 1;
                    $map['totalAssignedTrucks'] += 1;

                    if ($map['totalAssignedTrucks'] == $map['totalRequiredTrucks']) {
                        break;
                    }
                }
            }
        }


        foreach ($map['acceptedCompanies'] as $compId => $company) {
            if ($company['used_quota'] == 0) {
                $company['rejectionReason'] = "تم توزيع كافة البضائع قبل حصول الشركة على حصة!";
                $map['rejectedCompanies'][$compId] = $company;
            } else {
                $map['servedCompanies'][$compId] = $company;
            }
        }

        $map['acceptedCompanies'] = [];
        return $this->_quotaServeMap;
    }


    // توزيع الطلبيات
    // this method takes trucks from queues and serves them with available orders
    // it can serve single queue or all queues in the tender by setting queueId = 0
    public function serveTenderOrders($tenderId, $queueId, $user_id, $tender_order_ids = null)
    {

        // call misc to get the serve result
        $fields = new stdClass();
        $fields->method = "serveTenderOrders";
        $fields->tender_id = $tenderId;
        $fields->queue_id = $queueId;
        $fields->user_id = $user_id;
        $fields->tender_order_ids = $tender_order_ids;

        $fields->integration_token = "PSYkhFAs2Rhmn357";    //misc
        $url = "http://misc.minagate.com/waybill-api/tender?method=serveTenderOrders";
        $result = $this->curl($url, $fields);

        return $result;
    }



    // توزيع الطلبيات
    // this method takes trucks from queues and serves them with available orders
    // it can serve single queue or all queues in the tender by setting queueId = 0
    public function serveTenderOrders_local($tenderId, $queueId, $user_id, $tender_order_ids = null)
    {
        // echo(memory_get_usage ().'<br>');
        $map = &$this->_queueServeMap;
        $queueObj = new QueueCore();
        $tenderMan = $this->getTenderManifest($tenderId, $user_id);
        $map['tenderMan'] = $tenderMan;
        $waybillOrderObj = new WaybillOrderCore();

        /*****************************************************************************
         Part one: retrive cargos associated to the selected orders
         ****************************************************************************/
        if ($tenderId == 3 || $tenderId == 15  || $tenderId == 12 || $tenderId == 22) {
            $searchFilter = [
                ['key' => 'tender_id', 'val' => $tenderId, 'op' => '='],
                ['key' => 'status', 'val' => 'ACTIVE', 'op' => '=']
            ];
        } else {
            $searchFilter = [
                ['key' => 'tender_id', 'val' => $tenderId, 'op' => '='],
                ['key' => 'status', 'val' => 'PENDING', 'op' => '=']
            ];
        }

        // if queue id is not zero, append queue id into search queue filter
        if ($queueId != 0) {
            array_push($searchFilter, ['key' => 'q_id', 'val' => $queueId, 'op' => '=']);
        }

        if (isset($tenderMan['queues'][$queueId]['assign_cargo_max_rows'])) {
            $map['maxRows'] = $tenderMan['queues'][$queueId]['assign_cargo_max_rows'];
        } else {
            $map['maxRows'] = 1000;
        }

        if ($tender_order_ids) {
            $searchFilter = [
                ['key' => 'tender_id', 'val' => $tenderId, 'op' => '='],
                ['key' => 'status', 'val' => ['PENDING', 'ACTIVE'], 'op' => 'in'],
                ['key' => 'id', 'val' => $tender_order_ids, 'op' => 'in']
            ];
            $orders = $this->searchTenderOrderReports('01', $searchFilter, $map['maxRows'], 0, $user_id);
        } else {
            $orders = $this->searchTenderOrderReports('01', $searchFilter, $map['maxRows'], 0, $user_id);

            if ($orders->found_rows == 0) {
                throw new Exception(" لم يتم العثور على بضائع للتوزيع! أو تم حجز أوامر حركة لكامل الطلبيه");
            }
        }


        // loop orders, parse objects and inject them into map object
        // $map['maxRows'] = 0 ;
        $map['waybillOrders'] = array();
        foreach ($orders->data as $order) {
            $order = json_decode(json_encode($order), $assoc = TRUE);

            $order['cargo'] = json_decode($order['cargo'], $assoc = TRUE);
            $order['questionnaire'] = $this->parseIndexedArray($order['questionnaire']);
            $order['cargo_details'] = $this->parseIndexedArray($order['cargo_details']);
            $order['order_date'] = date_create($order['order_date'], new DateTimeZone('Asia/Amman'));
            $order['servedTrucks'] = 0;
            $map['waybillOrders'][$order['id']] = array();
            if ($tenderMan['allowMultiTruckForCargo'] == FALSE) { // if every cargo needs one truck
                // if requested trucks not equal to number of cargos, fix the number of trucks
                $order['trucks'] = sizeof($order['cargo_details']);
            }
            $map['orders'][$order['id']] = $order;
            if (!isset($map['queuesCargoCount'][$order['q_id']])) {
                $map['queuesCargoCount'][$order['q_id']] = 0;
            }
            $map['queuesCargoCount'][$order['q_id']] += $order['trucks'];
            // $map['maxRows'] += 2*$order['trucks'];
        }

        $searchFilter = [
            ['key' => 'tender_order_id', 'val' => $this->propertyOfArray($map['orders'], 'id'), 'op' => 'in'],
            ['key' => 'status', 'val' => ['REVOKED'], 'op' => 'not in']
        ];
        $activeWaybillOrders = $waybillOrderObj->searchWaybillOrder($searchFilter, $map['maxRows'], 0, $user_id);


        foreach ($activeWaybillOrders->data as $waybillOrder) {

            array_push(
                $map['waybillOrders'][$waybillOrder->tender_order_id],
                [
                    'waybillOrder' => $waybillOrder->id,
                    'order' => $waybillOrder->tender_order_id,
                    'q_id' => $waybillOrder->queue_id,
                    'cargo' => $waybillOrder->cargo_id
                ]
            );
            $map['orders'][$waybillOrder->tender_order_id]['servedTrucks']++;
        }

        // delete object to free memory
        $orders = null;
        $activeWaybillOrders = null;
        /*****************************************************************************
         Part two: finding trucks in queue and filtering them according to objects statuses
         ****************************************************************************/
        $searchFilter = [
            ['key' => 'tender_id', 'val' => $tenderId, 'op' => '='],
            ['key' => 'status', 'val' => 'ACTIVE', 'op' => '=']
        ];
        // if queue id is not zero, append queue id into search queue filter
        if ($queueId != 0) {
            array_push($searchFilter, ['key' => 'q_id', 'val' => $queueId, 'op' => '=']);
        }

        $trucksInQueue = $queueObj->searchQueue($searchFilter, $map['maxRows'], 0, $user_id);
        // for testing
        if ($tenderId == 22) {
            //        dump($trucksInQueue);die;
        }


        $map['foundTrucks'] = $trucksInQueue->found_rows;
        foreach ($trucksInQueue->data as $truck) {
            $truck = json_decode(json_encode($truck), $assoc = TRUE);
            // if truck number is defined, validate status vs tender status map
            if (gettype($tenderMan['statusMap']['truck']) == 'array' && $truck['tn'] != NULL) {
                if (!in_array($truck['tn_status'], $tenderMan['statusMap']['truck'])) {
                    $truck['rejectionReason'] = "حالة الشاحنة غير صحيحة";
                    $map['rejectedTrucks'][$truck['id']] =  $truck;
                    continue;
                }
            }

            // if trailer number is defined, validate status vs tender status map
            if (gettype($tenderMan['statusMap']['trailer']) == 'array' && $truck['trn'] != NULL) {
                if (!in_array($truck['trn_status'], $tenderMan['statusMap']['trailer'])) {
                    $truck['rejectionReason'] = "حالة المقطورة غير صحيحة";
                    $map['rejectedTrucks'][$truck['id']] = $truck;
                    continue;
                }
            }
            // if driver number is defined, validate status vs tender status map
            if (gettype($tenderMan['statusMap']['driver']) == 'array' && $truck['driver_id'] != NULL) {
                if (!in_array($truck['driver_status'], $tenderMan['statusMap']['truck'])) {
                    $truck['rejectionReason'] = "حالة السائق غير صحيحة";
                    $map['rejectedTrucks'][$truck['id']] = $truck;
                    continue;
                }
            }
            $map['acceptedTrucks'][$truck['id']] = $truck;
        }

        // delete object to free memory
        $trucksInQueue = null;
        // get the accepted trucks questionnaire answers for the tender
        $searchFilter = [
            ['key' => 'tender_id', 'val' => $tenderId, 'op' => '='],
            ['key' => 'truck_id', 'val' => $this->propertyOfArray($map['acceptedTrucks'], 'truck_id'), 'op' => 'in'],
            ['key' => 'status', 'val' => ['ACTIVE', 'PENDING'], 'op' => 'in']
        ];

        $acceptedTenderTrucks = $this->searchTenderTruck($searchFilter, $map['maxRows'], 0, $user_id);

        // loop tender_trucks to extract questionnaire and inject it into acceptedTrucks array
        foreach ($acceptedTenderTrucks->data as $truck) {
            $truck = json_decode(json_encode($truck), $assoc = TRUE);
            foreach ($map['acceptedTrucks'] as &$acceptedTruckPointer) {
                if ($acceptedTruckPointer['truck_id'] == $truck['truck_id']) {
                    $acceptedTruckPointer['questionnaire'] = $this->parseIndexedArray($truck['questionnaire']);
                    $acceptedTruckPointer['tender_truck_status'] = $truck['status'];
                }
            }
        }


        // loop the accepted trucks to make sure all of them have active tender_trucks record and defined questionnaire
        // if questionnaire is not defined, then remove the truck to rejected trucks
        foreach ($map['acceptedTrucks'] as $truck) {
            if (!array_key_exists('questionnaire', $map['acceptedTrucks'][$truck['id']])) {
                $truck['rejectionReason'] = "تسجيل الشاحنة في العطاء تم إلغاؤه أو إيقافه";
                $map['rejectedTrucks'][$truck['id']] = $truck;
                unset($map['acceptedTrucks'][$truck['id']]);
            }

            if ($truck['tender_truck_status'] == 'PENDING') {
                $truck['rejectionReason'] = "عقد تشغيل الشاحنة على المشروع موقوف";
                $map['rejectedTrucks'][$truck['id']] = $truck;
                unset($map['acceptedTrucks'][$truck['id']]);
            }
        }

        if (sizeOf($map['acceptedTrucks']) == 0) {
            $map['error_message'] = "لم يتم العثور على شاحنات فعالة على الدور!";
        }




        /*****************************************************************************
         Part three: validate trucks againest orders and cargos (cargo type matching and questionnaire)
         if validation passes, matching trucks of queue with orders and cargos will be done
         ****************************************************************************/
        // loop the accepted trucks to match questionnaire answers vs order questionnaire
        // if questionnaire answers don't match with any of cargos, then remove the truck to rejected trucks
        foreach ($map['acceptedTrucks'] as $truck) {
            // loop orders
            $map['acceptedTrucks'][$truck['id']]['orders'] = [];
            foreach ($map['orders'] as $order) {
                // loop cargos, and save available cargos for truck
                foreach ($order['cargo_details'] as $cargo) {
                    try {
                        if (
                            $map['acceptedTrucks'][$truck['id']]['q_id'] == $order['q_id'] // short cirsuit if cargo and truck are not on the same queue
                            && $this->isQuestionnaireMatch($this->_queueServeMap, $truck['questionnaire'], $order['id'], $cargo['id'], $truck['id']) == 0
                        ) {
                            $truckCargos = &$map['acceptedTrucks'][$truck['id']]['orders'][$order['id']];
                            if (!isset($truckCargos)) {
                                $truckCargos['cargoList'] = array();
                            }
                            array_push($truckCargos['cargoList'], $cargo['id']);
                            $truckCargos['truckCount'] = $order['trucks'];
                        }
                    } catch (Exception $e) {
                        if ($e->getMessage() == 'answer_not_found') {
                            $truck['rejectionReason'] = "استبيان الشاحنة غير مكتمل! لا يمكن استكمال التوزيع للشاحنة!";
                            $map['rejectedTrucks'][$truck['id']] = $truck;
                            unset($map['acceptedTrucks'][$truck['id']]);
                        }
                    }
                }
            }
            if (!$map['acceptedTrucks'][$truck['id']]['orders'] || !sizeof($map['acceptedTrucks'][$truck['id']]['orders'])) {
                $truck['rejectionReason'] = "لا توجد بضائع متوافقة مع الشاحنة!";
                $map['rejectedTrucks'][$truck['id']] = $truck;
                unset($map['acceptedTrucks'][$truck['id']]);
            }
        }

        if (sizeOf($map['acceptedTrucks']) == 0) {
            $map['error_message'] = "لم يتم العثور على شاحنات متوافقة مع الأحمال المطلوبة!";
        }

        // sort queue arrays by qid
        ksort($map['acceptedTrucks']);
        ksort($map['rejectedTrucks']);


        /*****************************************************************************
         Part four: crate indexed arrays of queues and cargos to calculate available cargos
         and let every truck to choose prefarable cargo to curry.
         ****************************************************************************/
        // output array in an array of objects, index is crgo ID, then every element is an object
        // of queue ID and order id. Array will be created with empty queue ID's, to be filled later
        $map['output'] = array();
        // loop orders

        foreach ($map['orders'] as &$order) {
            // loop cargos
            foreach ($order['cargo_details'] as &$cargo) {

                if ($tenderMan['allowMultiTruckForCargo'] == FALSE) { // if every cargo needs one truck
                    // search for previous waybill order of this output entry
                    foreach ($map['waybillOrders'] as &$wo) {
                        // TODO: Container case: every caro entry should be placed in the correct place of the output map.
                    }
                    array_push($map['output'], ['order' => $order['id'], 'cargo' => $cargo['id'], 'q_id' => null]);
                } else {

                    foreach ($map['waybillOrders'][$order['id']] as $wo) {
                        array_push($map['output'], $wo);
                    }
                    for ($i = sizeof($map['waybillOrders'][$order['id']]); $i < $order['trucks']; $i++) {
                        array_push($map['output'], ['order' => $order['id'], 'cargo' => $cargo['id'], 'q_id' => null, 'waybillOrder' => null]);
                    }
                }
            }
        }


        // To free up memory
        unset($map['waybillOrders']);

        // this loop will pass through every cargo, select most suitable truck, let truck choose cargo
        // TODO: this block doesn't support multiple queues!
        // loop output cargos to select most suitable truck
        for ($cargoPointer = 0; $cargoPointer < sizeof($map['output']); $cargoPointer++) {
            // First, refresh cargo histogram based on the available un-served cargos.

            $this->fillTruckCargoHistogram();

            // calculate number of required trucks
            $availableSeats = 0;
            foreach ($map['output'] as &$output) {
                if ($output['q_id'] == null && $output['waybillOrder'] == null) $availableSeats += 1;
            }

            $leastCargoCount = $map['maxRows'];
            $i = 0;
            $selectedQ = -1;
            foreach ($map['truckCargoHistogram'] as $q_id => &$cargoCount) {
                if ($i++ == $availableSeats) break;
                if ($cargoCount < $leastCargoCount) {
                    $leastCargoCount = $cargoCount;
                    $selectedQ = $q_id;
                }
            }
            // if no more trucks can be found, breack the cargos loop
            if ($selectedQ == -1) {
                break;
            }

            $theTruck = $map['acceptedTrucks'][$selectedQ];

            $availableCompatableCargos = array();
            foreach ($theTruck['orders'] as $orderId => &$order) {
                foreach ($order['cargoList'] as $cargoId) { // loop compatable cargos of selected truck
                    foreach ($map['output'] as $id => &$outputItem) {
                        if (
                            $outputItem['order'] == $orderId &&
                            $outputItem['cargo'] == $cargoId &&
                            $outputItem['q_id'] == null &&
                            $outputItem['waybillOrder'] == null
                        ) {
                            array_push($availableCompatableCargos, $id);
                        }
                    }
                }
            }

            // Here we have Queue ID and avilable cargos to choose from, Queue algorithm will decide how to choose cargo.
            switch ($tenderMan['queues'][$theTruck['q_id']]['algorithm']['name']) {
                case "FIFO":
                    // move truck object to the served trucks array
                    $map['servedTrucks'][$theTruck['id']] = $map['acceptedTrucks'][$theTruck['id']];
                    unset($map['acceptedTrucks'][$theTruck['id']]);
                    // choose most first found cargo
                    $map['output'][$availableCompatableCargos[0]]['q_id'] = $theTruck['id'];
                    // register the selected cargo into the truck object

                    $order_id = $map['output'][$availableCompatableCargos[0]]['order'];

                    $cargo_name = $map['orders'][$order_id]['cargo_details'][$map['output'][0]['cargo']]['name'];
                    $map['servedTrucks'][$theTruck['id']]['selectedCargo'] = $map['output'][$availableCompatableCargos[0]];
                    $map['servedTrucks'][$theTruck['id']]['selectedCargo']['cargo_name'] = $cargo_name;
                    break;
                case "ROUND_ROBIN":
                    // move truck object to the served trucks array
                    $map['servedTrucks'][$theTruck['id']] = $map['acceptedTrucks'][$theTruck['id']];
                    unset($map['acceptedTrucks'][$theTruck['id']]);
                    // choose most first found cargo
                    $selectedCargoIndex = rand(0, sizeof($availableCompatableCargos) - 1);
                    $map['output'][$availableCompatableCargos[$selectedCargoIndex]]['q_id'] = $theTruck['id'];
                    // register the selected cargo into the truck object

                    $order_id = $map['output'][$availableCompatableCargos[$selectedCargoIndex]]['order'];

                    $cargo_name = $map['orders'][$order_id]['cargo_details'][$map['orders'][$order_id]['cargo'][0]]['name'];
                    $map['servedTrucks'][$theTruck['id']]['selectedCargo'] = $map['output'][$availableCompatableCargos[$selectedCargoIndex]];
                    $map['servedTrucks'][$theTruck['id']]['selectedCargo']['cargo_name'] = $cargo_name;
                    break;
            }
        }


        // Handling the shortage of trucks
        if ($cargoPointer < sizeof($map['output'])) {; // TODO
        }
        // this will flush any remaining trucks in the acceptedTrucks
        $this->fillTruckCargoHistogram();

        // remove rejected trucks where its rank is larger than min_rank
        // get the minimum accepted truck rank
        $min_rank = null;
        foreach ($map['servedTrucks'] as $served) {
            if (!$min_rank) $min_rank = $served['rank'];
            if ($served['rank'] < $min_rank) {
                $min_rank = $served['rank'];
            }
        }

        $map['available_to_overwrite'] = [];
        foreach ($map['rejectedTrucks'] as $rejected) {
            if ($rejected['rejectionReason'] == "لا توجد بضائع متوافقة مع الشاحنة أو تم توزيع البضائع المتوافقة مع الشاحنة قبل وصولها إلى الدور!");
            array_push($map['available_to_overwrite'], $rejected);
        }

        if ($min_rank) {
            // clean the rejected trucks where rank larger than min_rank
            foreach ($map['rejectedTrucks'] as $rejected) {
                if ($rejected['rank'] > $min_rank) {
                    unset($map['rejectedTrucks'][$rejected['id']]);
                }
            }
        }


        // sort queue arrays by qid
        ksort($map['acceptedTrucks']);
        ksort($map['servedTrucks']);
        ksort($map['rejectedTrucks']);

        //echo(memory_get_usage ());
        return $this->_queueServeMap;
    }


    // ----------------------------------------------------------------------------------------- //
    // ------------------ call cURL request to minagate-registrat end point ---------------------- //
    // ----------------------------------------------------------------------------------------- //
    private function curl($url, $fields)
    {

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_TIMEOUT, 150);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));

        $result = curl_exec($ch);

        if (curl_errno($ch)) {
            throw new Exception(curl_error($ch), curl_errno($ch));
        }

        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        // if($http_code != 200){
        //     throw new Exception("Error Processing Request", 1);            
        // }

        $response = json_decode($result, 1);
        if ($response) {
            return $response;
        } else {
            return $result;
        }
    }


    // truckCargo Histogram is an array of trucks and available cargos for every truck based on current state of map
    // when any truck found with zero remaining compatable cargos, it will be removed to rejected automatically.
    private function fillTruckCargoHistogram()
    {
        $map = &$this->_queueServeMap;
        $map['truckCargoHistogram'] = array();
        foreach ($map['acceptedTrucks'] as $q_id => &$truck) {
            $cargoCount = 0;

            foreach ($truck['orders'] as $order_id => &$order) {
                foreach ($order['cargoList'] as &$cargo) {
                    foreach ($map['output'] as &$output) {
                        if (
                            $output['cargo'] == $cargo &&
                            $output['order'] == $order_id &&
                            $output['q_id'] == null &&
                            $output['waybillOrder'] == null
                        ) {
                            $cargoCount += 1;
                        }
                    }
                }
            }

            if ($cargoCount > 0) {
                $map['truckCargoHistogram'][$q_id] = $cargoCount;
            } else {
                $truck['rejectionReason'] = "لا توجد بضائع متوافقة مع الشاحنة أو تم توزيع البضائع المتوافقة مع الشاحنة قبل وصولها إلى الدور!";
                $map['rejectedTrucks'][$q_id] = $truck;
                unset($map['acceptedTrucks'][$q_id]);
            }
        }
        ksort($map['truckCargoHistogram']);
    }

    // format the question node and add the source
    private function formatQuestionSource($question)
    {
        $question['source'] = 'local';

        if (gettype($question['val']) != 'string') {
            $question['val'] = json_encode($question['val']);
        }

        if (preg_match('/_*[a-zA-Z]_\$_*[a-zA-Z]_*/', $question['val'])) {
            $question['source'] = explode("$", $question['val'])[0];    // split by $ and take the first part
            $question['source'] = trim($question['source'], '_');       // remove first and last _
            $question['val'] = explode("$", $question['val'])[1];       // split by $ and take the second part
            $question['val'] = trim($question['val'], '_');             // remove first and last _
        }
        // since question type is optional, define it as null if not found.
        if (!array_key_exists('question_type', $question)) {
            $question['question_type'] = null;
        }
        return $question;
    }

    // ------------------------------------------------------------------------------------ //
    // ---------------- build map to prepare for truck and order matching ----------------- //
    // ------------------------------------------------------------------------------------ //
    public function buildQuestionnaireMap($truck_id, $tender_order_id)
    {

        // init
        $cargoCore = new CargoCore();
        $truckCore = new TruckCore();

        // get tender order bean 
        $tender_order_bean = $this->getTenderOrderBasic($tender_order_id, 0);

        // get cargo bean
        $cargo_id = $tender_order_bean->cargo[0];
        $cargo_baen = $cargoCore->getCargoBasic($cargo_id, 0);

        //get tender truck bean
        $tender_truck_filter = [
            ['key' => 'truck_id', 'val' => $truck_id],
            ['key' => 'status', 'val' => 'ACTIVE'],
            ['key' => 'tender_id', 'val' => $tender_order_bean->tender_id]
        ];

        $tender_truck_result = $this->searchTenderTruck($tender_truck_filter, 1, 0, 0);
        if ($tender_truck_result->found_rows == 0) {
            throw new Exception('لا تستطيع المتابعة ، عقد تشغيل الشاحنة على المشروع غير فعال ، الرجاء مراجعة العمليات');
        }

        // get truck questionnaire and format it
        $truck_questionnaire = $this->parseIndexedArray($tender_truck_result->data[0]->questionnaire);

        if (!$truck_questionnaire) {
            // get the company questionnaire rather than truck questionnaire
            $tenderCompanyBean = $this->_tenderCompanyCore->getTenderCompanyBasic($tender_truck_result->data[0]->tender_company_id, 0);
            $truck_questionnaire = json_decode(json_encode($tenderCompanyBean->questionnaire), true);
            $tender_truck_bean = $tender_truck_result->data[0];
            $tender_truck_bean->questionnaire = json_encode($truck_questionnaire, JSON_UNESCAPED_UNICODE);
            $this->updateTenderTruck($tender_truck_bean, $tender_truck_bean->id, 0);
        }

        if (!$truck_questionnaire) {
            throw new Exception("لا تستطيع المتابعة ، استبيان الشاحنة غير موجود");
        }

        foreach ($truck_questionnaire as &$TQ) {
            if (getType($TQ['val'] != "string")) {
                $TQ['val'] = json_encode($TQ['val']);
            }
        }

        // build map need in matching func :(
        $map = [];
        $map['orders'] = [];
        $map['orders'][$tender_order_id] = json_decode(json_encode($tender_order_bean), true);
        $map['orders'][$tender_order_id]['cargo_details'] = [];
        $map['orders'][$tender_order_id]['cargo_details'][$cargo_id] = json_decode(json_encode($cargo_baen), true);
        $map['acceptedTrucks'] = [];
        $tenderTruckBean = $tender_truck_result->data[0];
        if (gettype($tenderTruckBean->questionnaire) == "string") {
            $temp_questionnaire = json_decode($tenderTruckBean->questionnaire);
            $tenderTruckBean->questionnaire = [];
            foreach ($temp_questionnaire as $q) {
                $tenderTruckBean->questionnaire[$q->id] = $q;
            }
        } else {
            $tenderTruckBean->questionnaire = $tenderTruckBean->questionnaire;
        }

        if ($tenderTruckBean->trailer_id) {
            $trailerBean  = $truckCore->getTruckBasic($tenderTruckBean->trailer_id, 0);
            $tenderTruckBean->trail_minor_tt = $trailerBean->minor_tt;
        }
        $map['acceptedTrucks'][$truck_id] = json_decode(json_encode($tenderTruckBean), true);

        // get tender manifest
        $man = $this->getTenderManifest($tender_order_bean->tender_id, 0);
        $map['tenderMan'] = $man;

        return $map;
    }

    // -------------------------------------------------------------------------------------------- //
    // ---------------- try to match route questionnaire with truck questionnaire ----------------- //
    // -------------------------------------------------------------------------------------------- //
    public function matchRoute($truck_id, $tender_order_id, $tender_id, $route)
    {

        // build map for questionare 
        $map = $this->buildQuestionnaireMap($truck_id, $tender_order_id);

        // replace the tender order bean questionnaire with route questionnaire
        $map['orders'][$tender_order_id]['questionnaire'] = json_decode(json_encode($route->questionnaire), true);

        // extract needed info
        $truck_questionnaire = $map['acceptedTrucks'][$truck_id]['questionnaire'];
        $cargo_id = $map['orders'][$tender_order_id]['cargo'][0];

        // match route questionnaire with truck questionnaire
        $match = $this->isQuestionnaireMatch($map, $truck_questionnaire, $tender_order_id, $cargo_id, $truck_id);

        return $match == 0;
    }


    // validate cargo requirments with truck questionnaire
    private function isQuestionnaireMatch($classMap, $questionnaire, $orderId, $cargoId, $truckId = null)
    {
        $map = &$classMap;
        if ($truckId) {
            $truck = &$map['acceptedTrucks'][$truckId];
        }

        $order = &$map['orders'][$orderId];
        $cargo = &$map['orders'][$orderId]['cargo_details'][$cargoId];
        $orderQuestionnaire = $order['questionnaire'];

        //TODO
        $cargo['origin'] = '91090000';

        // First, fill order questionnaire with correct details
        foreach ($orderQuestionnaire as $question) {

            //format the question
            $question = $this->formatQuestionSource($question);

            // get Cargo Answers
            if ($question['source'] == 'cargo') {
                $orderQuestionnaire[$question['id']]['val'] = $cargo[$question['val']];
            }

            // TODO: get waybill answers
            if ($question['source'] == 'WAYBILL') {
                // TODO: get waybill answers
            }

            // get SYSTEM answers
            if ($question['source'] == 'SYSTEM') {

                if ($question['val'] == 'days') {
                    $orderQuestionnaire[$question['id']]['val'] = date('l');
                }
                if ($question['val'] == 'months') {
                    $orderQuestionnaire[$question['id']]['val'] = date('F');
                }
                if ($question['val'] == 'hours') {
                    $orderQuestionnaire[$question['id']]['val'] = date('H');
                }
            }
        }

        // convert truck answer to real value
        if ($truckId && $truck['questionnaire']) {

            foreach ($truck['questionnaire'] as $truck_answer_id => &$truckAnsweres) {
                if (gettype($truckAnsweres['val']) == "string") {
                    $truckAnsweres = $this->formatQuestionSource($truckAnsweres);
                    // get truck answers

                    if ($truckAnsweres['source'] == 'TRUCK') {
                        if ($truckAnsweres['val'] == 'TT') {
                            if ($truck['tt'] == '*') {
                                $truckAnsweres['val'] = true;
                            } else {
                                $truckAnsweres['val'] = $truck['tt'];
                            }
                        }
                        if ($truckAnsweres['val'] == 'MINOR_TT') {
                            $truckAnsweres['val'] = $truck['trail_minor_tt'];
                            $questionnaire[$truck_answer_id]['val'] = $truckAnsweres['val'];
                        }
                    }
                }
            }
        }

        foreach ($orderQuestionnaire as $orderQ) {

            if (!isset($questionnaire[$orderQ['id']]['val'])) {
                if ($orderQ['val'] != "*") {
                    throw new Exception("اسنبيان الشاحنة غير مكتمل او غير صحيح");
                }
            }

            // format the orer question
            $orderQ = $this->formatQuestionSource($orderQ);

            // if the order question is location based, location comparison will be done instead of any other questions
            $question_type = $this->getQuestionType($map['tenderMan']['questionnaire'][$orderQ['id']]);
            if ($question_type == 'ROUTE:DISTINATION' || $question_type == 'ROUTE:ORIGIN') {

                if (gettype($questionnaire[$orderQ['id']]['val']) != 'array') {
                    $questionnaire[$orderQ['id']]['val'] = [$questionnaire[$orderQ['id']]['val']];
                }

                $truck_destination_arr = $questionnaire[$orderQ['id']]['val'];
                $order_destination = $orderQ['val'];

                foreach ($truck_destination_arr as $truck_dest) {
                    $isMatched = $this->isLocationMatch($truck_dest, $order_destination);
                    if ($isMatched) break;
                }

                if (!$isMatched) {
                    return $orderQ['id'];
                    return false;
                } else {
                    continue;
                }
            }

            // TODO: get waybill answers
            if ($orderQ['source'] == 'waybill') {
                continue;
            }

            // SWITCH question type, and match order answers to truck answers.
            switch (strtolower($map['tenderMan']['questionnaire'][$orderQ['id']]['type'])) {
                case "select":
                case "tree-select":
                    if (gettype($questionnaire[$orderQ['id']]['val']) != 'array') {
                        $questionnaire[$orderQ['id']]['val'] = [$questionnaire[$orderQ['id']]['val']];
                    }
                    if ($orderQ['val'] == "*") { // in case the order want all answeres to be true
                        continue;
                    }

                    if ($questionnaire[$orderQ['id']]['val'][0] == "*") { // in case the answer is *
                        continue;
                    }
                    if (!in_array($orderQ['val'], $questionnaire[$orderQ['id']]['val'])) {
                        return $orderQ['id'];
                        return false;
                    }
                    break;

                case "slider":
                    // If answer is not defined in order (may be due to cargo lack of data), in this case consider answer is true
                    if ($orderQ['val'] == null) {
                        continue;
                    }
                    // Slider defidunes maximum value
                    if ($map['tenderMan']['questionnaire'][$orderQ['id']]['range'][0] < $map['tenderMan']['questionnaire'][$orderQ['id']]['range'][1]) {
                        if ($orderQ['val'] > $questionnaire[$orderQ['id']]['val']) {
                            return false;
                        }
                    } else { // Slider defines minimum value
                        if ($orderQ['val'] < $questionnaire[$orderQ['id']]['val']) {
                            return false;
                        }
                    }
                    break;
                case "radio":
                    if ($orderQ['val'] != $questionnaire[$orderQ['id']]['val']) {
                        return $orderQ['id'];
                        return false;
                    }
                    break;
            }
        }

        return 0;
    }

    private function getQuestionType($question)
    {

        if ($question) {
            if (array_key_exists('question_type', $question)) {
                return $question['question_type'];
            } else {
                return null;
            }
        }
    }

    // ---------------------------------------------------------------------------------------------------------------- //
    // ------------------ match any 2 locations , return true if any location is a child within the other ------------- //
    // ---------------------------------------------------------------------------------------------------------------- //
    private function isLocationMatch($location1, $location2)
    {
        for ($index = 0; $index < 7; $index += 2) {
            $location1_sub = substr($location1, $index, 2);
            $location2_sub = substr($location2, $index, 2);

            if ($location1_sub == $location2_sub) {
                continue;
            } else if ((int)$location1_sub * (int)$location2_sub == 0) {
                continue;
            } else {
                return false;
            }
        }
        return true;
    }

    // ------------------------------------------------------------------------ //
    // ------------------ reads tender JSON manifest and validate it ---------- //
    // ------------------------------------------------------------------------ //
    public function parseTenderManifest($manifest)
    {

        // Try to parse manifest document
        try {
            if (gettype($manifest) != "array") {
                $manifest = json_decode($manifest, $assoc = true);
            }
        } catch (Exception $e) {
        }

        // throw exception if document not parsed
        if ($manifest == null) {
            throw new Exception("Illegal Tender Manifest JSON Document! Tender manifest must be a valid JSON document.");
        }

        // throw exception if name element not defined or not a string
        if (gettype($manifest['name']) != "string") {
            throw new Exception("Illegal Tender Manifest JSON Document! name property must be of type STRING! ");
        }

        // throw exception if start element not defined
        if (gettype($manifest['start']) != "string") {
            throw new Exception("Illegal Tender Manifest JSON Document! start property must be of type STRING! ");
        }

        // parse start date and convert string into date object
        $manifest['start'] = date_create($manifest['start'], new DateTimeZone('Asia/Amman'));

        // throw exception if errors occured while converting string into date object
        if ($manifest['start'] == false) {
            throw new Exception("Illegal Tender Manifest JSON Document! could not parse start date! ");
        }

        // throw exception if expiry element not defined
        if (gettype($manifest['expiry']) != "string") {
            throw new Exception("Illegal Tender Manifest JSON Document! expiry property must be of type STRING! ");
        }

        // parse expiry date and convert string into date object
        $manifest['expiry'] = date_create($manifest['expiry'], new DateTimeZone('Asia/Amman'));

        // throw exception if errors occured while converting string into date object
        if ($manifest['expiry'] == false) {
            throw new Exception("Illegal Tender Manifest JSON Document! could not parse expiry date! ");
        }

        //throw exception if tender start date is before tender expiry date
        if ($manifest["start"] > $manifest["expiry"]) {
            throw new Exception('Illegal Tender Manifest JSON Document! Tender start date should be before tender expiry date');
        }

        //throw exception if ct is not an array of integers
        if ($this->isArrayOfType($manifest["ct"], 'integer' != true)) {
            throw new Exception(' Illegal Tender Manifest JSON Document! ct should be an array of integers');
        }

        // throw exception if origin element not defined or not an array
        if ($this->isArrayOfType($manifest['origin'], 'integer') != true) {
            throw new Exception("Illegal Tender Manifest JSON Document! origin property must be of type array and contains integers only! ");
        }
        // throw exception if destination element not defined or not an array
        if ($this->isArrayOfType($manifest['destination'], 'integer') != true) {
            throw new Exception("Illegal Tender Manifest JSON Document! destination property must be of type array and contains integers only! ");
        }

        // validate operation_type
        if ($this->isArrayOfType($manifest['operation_type'], 'array') != true) {
            throw new Exception("Illegal Tender Manifest JSON Document! operation_type property must be of type array and contains objects only! ");
        }

        // throw exception if queues element not defined or not an array
        if ($this->isArrayOfType($manifest['queues'], 'array') != true) {
            throw new Exception("Illegal Tender Manifest JSON Document! queues property must be of type array and contains object only! ");
        }

        $manifest['queues'] = $this->parseIndexedArray(json_encode($manifest['queues']));
        // loop over queues and valudate properties
        $qid = [];

        if (isset($manifest['queues'])) {
            foreach ($manifest['queues'] as $i) {

                // id must be defined
                // id must be unique, if repeated value found then throw exception, else append values to $qid array for future compareson.
                if (in_array($i['id'], $qid)) {
                    throw new Exception("Illegal Tender Manifest JSON Document! queue id must be unique! repeated queue id found value " . $i['id']);
                }
                array_push($qid, $i['id']);

                // throw exception if queue name element not defined
                if (gettype($i['name']) != "string") {
                    throw new Exception("Illegal Tender Manifest JSON Document! queue name property must be of type STRING! ");
                }

                // throw exception if queue status element not defined
                if (gettype($i['status']) != "string") {
                    throw new Exception("Illegal Tender Manifest JSON Document! queue status property must be of type STRING! ");
                }

                // throw exception if queue algorithm element not defined or not an object
                if (gettype($i['algorithm']) != "array") {
                    throw new Exception("Illegal Tender Manifest JSON Document! queue algorithm property is not of type object! ");
                }

                // throw exception if queue algorithm name element not defined or not a string
                if (gettype($i['algorithm']['name']) != "string") {
                    throw new Exception("Illegal Tender Manifest JSON Document! queue algorithm name property must be of type string! ");
                }

                // throw exception if delay rules not defined or not an array
                if (gettype($i['delay_rules']) != 'array') {
                    throw new Exception("Illegal Tender Manifest JSON Document! delay rules property must be of type array");
                    break;
                }

                // throw exception if method is not defined or not a string
                if (gettype($i['delay_rules']["method"]) != 'string') {
                    throw new Exception("Illegal Tender Manifest JSON Document! delay rules method property must be of type string");
                    break;
                }

                // throw exception if message is not defined or not a string
                // if (gettype($i['delay_rules']['message']) != 'string') {
                //     throw new Exception("Illegal Tender Manifest JSON Document! delay rules message property must be of type string");
                // }

                if (isset($i['delay_rules']['total_delays']) && $i['delay_rules']['total_delays'] != "") {
                    // throw exception if total_delays is not defined or not a integer
                    if (gettype($i['delay_rules']["total_delays"]) != 'integer') {
                        throw new Exception("Illegal Tender Manifest JSON Document! delay rules total_delays property must be of type integer");
                        break;
                    }

                    // throw exception if total_delays is a negative integer
                    if ($i['delay_rules']["total_delays"] < 0) {
                        throw new Exception("Illegal Tender Manifest JSON Document! delay rules total_delays property must be a positive integer");
                        break;
                    }

                    // throw exception if total_delays is not defined or not a integer
                    if ($this->isArrayOfType($i['delay_rules']['delay_options'], 'array') != true) {
                        throw new Exception("Illegal Tender Manifest JSON Document! delay_options property must be of type array and contains object only! ");
                        break;
                    }

                    //throw an exception if delay options object does not include code,value, and caption
                    foreach ($i['delay_rules']['delay_options'] as $j) {
                        //throw an exception if code is not of type integer
                        if (gettype($j["code"]) != 'integer') {
                            throw new Exception("Illegal Tender Manifest JSON Document! delay_options code property must be of type integer");
                            break;
                        }

                        //throw an exception if code have a negative value
                        if ($j["code"] < 0) {
                            throw new Exception("Illegal Tender Manifest JSON Document! delay_options code must be a positive integer");
                            break;
                        }

                        //throw an exception if value is not of type string
                        if (gettype($j["value"]) != 'string') {
                            throw new Exception("Illegal Tender Manifest JSON Document! delay_options value property must be of type string");
                            break;
                        }

                        //throw an exception if caption is not of type string
                        if (gettype($j["caption"]) != 'string') {
                            throw new Exception("Illegal Tender Manifest JSON Document! delay_options caption property must be of type string");
                            break;
                        }
                    }

                    //if delay from mobile is available
                    if (
                        array_key_exists('allow_delay_from_mobile', $i['delay_rules']) &&
                        $i['delay_rules']['allow_delay_from_mobile'] == true
                    ) {
                        //throw an exception if delay timer end message is not a string
                        if (gettype($i['delay_rules']["delay_timer_end_message"]) != 'string') {
                            throw new Exception("Illegal Tender Manifest JSON Document! delay_timer_end_message  property must be of type string");
                            break;
                        }

                        //throw an exception if delay timer end message is not a string
                        if (gettype($i['delay_rules']['allow_delay_from_mobile_message']) != 'string') {
                            throw new Exception("Illegal Tender Manifest JSON Document! allow_delay_from_mobile_message property must be of type string");
                            break;
                        }
                    }
                }

                //throw an exception if cargo_filter is not an array of objects
                if ($this->isArrayOfType($i['cargo_filter'], 'array') != true) {
                    throw new Exception("Illegal Tender Manifest JSON Document! cargo_filter property must be of type array and contains object only! ");
                    break;
                }

                //throw an exception if requeue_rules is not an array of strings
                if (gettype($i['requeue_rules']) != "array") {
                    throw new Exception("Illegal Tender Manifest JSON Document! requeue_rules property must be of type array");
                    break;
                }

                //throw an exception if method in requeue_rules is not an array of strings
                if (gettype($i["requeue_rules"]["method"]) != 'string') {
                    throw new Exception("Illegal Tender Manifest JSON Document!  requeue_rules method property must be of type string");
                    break;
                }

                //if there is requeue strategy
                if ($i["requeue_rules"]["method"] != 'NONE') {
                    //throw an exception if status in requeue_rules is not an array of strings
                    if (gettype($i["requeue_rules"]["status"]) != "string") {
                        throw new Exception("Illegal Tender Manifest JSON Document!  requeue_rules status property must be of type string");
                        break;
                    }

                    //throw an exception if new_status in requeue_rules is not an array of strings
                    if (gettype($i["requeue_rules"]["new_status"]) != "string") {
                        throw new Exception("Illegal Tender Manifest JSON Document!requeue_rules new_status property must be of type string");
                        break;
                    }

                    //throw an exception if target_queue in requeue_rules is not an array of strings
                    if (gettype($i["requeue_rules"]["target_queue"]) != 'integer') {
                        throw new Exception("Illegal Tender Manifest JSON Document! requeue_rules target_queue property must be of type integer");
                        break;
                    }
                }

                //throw an exception if allow_answer_change is not boolean
                if (!is_bool($i["allow_answer_change"])) {
                    throw new Exception("Illegal Tender Manifest JSON Document! allow_answer_change property must be of type boolean");
                    break;
                }

                if ($i["allow_answer_change"] == true) {
                    //throw an exception if allow_answer_change is true and no action is set
                    if (empty($i["answer_change_action"])) {
                        throw new Exception("Illegal Tender Manifest JSON Document! answer_change_action must be set");
                        break;
                    }
                }

                //throw an exception if allow_trailer_edit is not boolean
                if (!is_bool($i["allow_trailer_edit"])) {
                    throw new Exception("Illegal Tender Manifest JSON Document! allow_trailer_edit property must be of type boolean");
                    break;
                }

                //throw an exception if assign_cargo_max_rows is an integer
                if (gettype($i["assign_cargo_max_rows"]) != "integer") {
                    throw new Exception("Illegal Tender Manifest JSON Document! assign_cargo_max_rows property must be of type integer");
                    break;
                }

                //throw an exception if waybill_creation_method is a string
                if (gettype($i["waybill_creation_method"]) != "string") {
                    throw new Exception("Illegal Tender Manifest JSON Document! waybill_creation_method property must be of type string");
                    break;
                }
            }
        }

        /****************************************************************************************/
        /***************************Validate freight********************************************/
        /****************************************************************************************/
        if ($this->isArrayOfType($manifest["freight"], 'array') != true) {
            //throw new Exception("Illegal Tender Manifest JSON Document! freight must be of type array and contains object only! ");
        }

        $accounts_ids = [];
        $accounts = $manifest["freight"]["accounts"];

        /****************************************************************************************/
        /***************************Validate accounts********************************************/
        /****************************************************************************************/

        // throw exception if queues element not defined or not an array
        if ($this->isArrayOfType($accounts, 'array') != true) {
            throw new Exception("Illegal Tender Manifest JSON Document! accounts property must be of type array and contains object only! ");
        }

        foreach ($accounts as $account) {
            //throw exception if account id is duplicated
            if (array_key_exists($account["id"], $accounts_ids)) {
                throw new Exception("Illegal Tender Manifest JSON Document! account ids should be unique ");
                break;
            }

            //push id into account ids array
            array_push($accounts_ids, $account["id"]);

            //throw an exception if id is not an integer
            if (gettype($account["id"]) != "integer") {
                throw new Exception("Illegal Tender Manifest JSON Document! account id must be of type integer");
                break;
            }

            //throw an exception if code is not a string
            if (gettype($account["code"]) != "string") {
                throw new Exception("Illegal Tender Manifest JSON Document! code must be of type string");
                break;
            }

            //throw an exception if label is not a string
            if (gettype($account["label"]) != "string") {
                throw new Exception("Illegal Tender Manifest JSON Document! label must be of type string");
                break;
            }

            //throw an exception if account number is not an integer
            if (gettype($account["account"]) != "integer") {
                throw new Exception("Illegal Tender Manifest JSON Document! account number must be of type integer");
                break;
            }
        }

        /****************************************************************************************/
        /***************************Validate deductions********************************************/
        /****************************************************************************************/
        $deductions_ids = [];
        $deductions = $manifest["freight"]["deductions"];
        // throw exception if queues element not defined or not an array
        if ($this->isArrayOfType($deductions, 'array') != true) {
            throw new Exception("Illegal Tender Manifest JSON Document! deductions property must be of type array and contains object only! ");
        }

        foreach ($deductions as $deduction) {
            //throw exception if account id is duplicated
            if (array_key_exists($deduction["id"], $deductions_ids)) {
                throw new Exception("Illegal Tender Manifest JSON Document! account ids should be unique ");
                break;
            }

            //push id into account ids array
            array_push($deductions_ids, $deduction["id"]);

            //throw an exception if id is not an integer
            if (gettype($deduction["id"]) != "integer") {
                throw new Exception("Illegal Tender Manifest JSON Document! deduction id must be of type integer");
                break;
            }

            //throw an exception if name is not a string
            if (gettype($deduction["name"]) != "string") {
                throw new Exception("Illegal Tender Manifest JSON Document! deduction must be of type string");
                break;
            }

            //throw an exception if label is not a string
            if (gettype($deduction["label"]) != "string") {
                throw new Exception("Illegal Tender Manifest JSON Document!deduction label must be of type string");
                break;
            }

            $deduction["target_account"] = (int)$deduction["target_account"];
            //throw an exception if account number is not an integer
            if (gettype($deduction["target_account"]) != "integer") {
                throw new Exception("Illegal Tender Manifest JSON Document! deduction target_account number must be of type integer");
                break;
            }

            //throw an exception if value is not an strings of strings
            if ($this->isArrayOfType($deduction["value"], "array")) {
                throw new Exception("Illegal Tender Manifest JSON Document! deduction value property should be of type array ");
                break;
            }


            //throw an exception if rate is not an string
            if ($deduction["value"]["rate"] != null && gettype($deduction["value"]["rate"]) != 'string') {
                throw new Exception("Illegal Tender Manifest JSON Document! deduction rate property should be of type string");
                break;
            }

            //throw an exception if amount is not an string
            // dump($deduction["value"]["amount"]); dump(gettype($deduction["value"]["amount"]));
            // if ($deduction["value"]["amount"] != null &&
            //  ( gettype($deduction["value"]["amount"]) != "integer" || gettype($deduction["value"]["amount"]) != "float") ) {
            //     throw new Exception("Illegal Tender Manifest JSON Document!deduction amount value property should be of type  integer");
            //     break;
            // }

            //throw an exception if method is not an string
            if (gettype($deduction["value"]["method"]) != "string") {
                throw new Exception("Illegal Tender Manifest JSON Document!deduction method value property should be of type  string");
                break;
            }

            //throw an exception if source is not an string
            if (gettype($deduction["filter"]) != "array") {
                throw new Exception("Illegal Tender Manifest JSON Document! deduction filter  property should be of type  array");
                break;
            }


            //throw an exception if allow_edit is not an array of strings
            if ($this->isArrayOfType($deduction["allow_edit"], "string") != true) {
                throw new Exception("Illegal Tender Manifest JSON Document! deduction allow_edit property should be of type array of strings");
                break;
            }
        }

        /****************************************************************************************************/
        /*********************************** VALIDATION OF PAYMENT AGENTS************************************/
        /****************************************************************************************************/
        if (!is_bool($manifest["overrideQueue"])) {
            throw new Exception("Illegal Tender Manifest JSON Document! overrideQueue should be of type boolean");
        }

        if ($this->isArrayOfType($manifest["paymentAgents"], "array") != true) {
            throw new Exception("Illegal Tender Manifest JSON Document! paymentAgents property should be of type array of strings");
        }

        foreach ($manifest["paymentAgents"] as $agent) {
            if (gettype($agent["id"]) != "integer") {
                throw new Exception("Illegal Tender Manifest JSON Document! paymentAgents id of paymentAgent property should be integer");
                break;
            }

            if (gettype($agent["name"]) != "string") {
                throw new Exception("Illegal Tender Manifest JSON Document!paymentAgents name should be of type string");
                break;
            }


            if (gettype($agent["status"]) != "string") {
                throw new Exception("Illegal Tender Manifest JSON Document!paymentAgents status should be of type string");
                break;
            }

            if (gettype($agent["balance"]) != "string") {
                throw new Exception("Illegal Tender Manifest JSON Document!paymentAgents balance should be of type string");
                break;
            }

            if (gettype($agent["account_id"]) != "integer") {
                throw new Exception("Illegal Tender Manifest JSON Document!paymentAgents account_id should be of type integer");
                break;
            }

            if (gettype($agent["company_id"]) != "integer") {
                throw new Exception("Illegal Tender Manifest JSON Document!paymentAgents company_id should be of type integer");
                break;
            }

            if (gettype($agent["minimum_balance"]) != "string") {
                throw new Exception("Illegal Tender Manifest JSON Document!paymentAgents minimum_balance should be of type string");
                break;
            }
        }

        if (gettype($manifest['freight']['payment_method']['method']) != "string") {
            //throw new Exception("Illegal Tender Manifest JSON Document!paymentMethod should be of type string");
        }

        // questionnaire is optional in manafest, but has to be of type array if defined
        // hence, if it was null, we define it to be empty array.
        {
            if (!array_key_exists('questionnaire', $manifest)) {
                $manifest['questionnaire'] = [];
            }
        }

        $manifest['questionnaire'] = $this->parseIndexedArray(json_encode($manifest['questionnaire']));

        // loop over questionnaire and validate properties
        $qid = [];
        if ($manifest['questionnaire']) {
            foreach ($manifest['questionnaire'] as $i) {
                // id must be defined
                //if(gettype($i['id'])!= "integer"){throw new Exception("Illegal Tender Manifest JSON Document! questionnaire id property must be of type integer! ");}
                // id must be unique, if repeated value found then throw exception, else append values to $qid array for future compareson.
                if (in_array($i['id'], $qid)) {
                    throw new Exception("Illegal Tender Manifest JSON Document! questionnaire id must be unique! repeated questionnaire id found value " . $i['id']);
                }
                // Since question_type is optional, set it to null in case it is not set.
                if (!array_key_exists('question_type', $i)) {
                    $i['question_type'] = null;
                }

                array_push($qid, $i['id']);
                // throw exception if queue text element not defined
                if (gettype($i['text']) != "string") {
                    throw new Exception("Illegal Tender Manifest JSON Document! queue text property must be of type STRING! ");
                }

                // throw exception if queue type element not defined
                if (gettype($i['type']) != "string") {
                    throw new Exception("Illegal Tender Manifest JSON Document! queue type property must be of type STRING! ");
                }

                // status element must be defined for each question
                if (!array_key_exists('status', $i)) {
                    throw new Exception("Illegal Tender Manifest JSON Document! questionnaire status must be defined for each question, not found for id:" . $i['id']);
                }

                // status element must be either ACTIVE or INACTIVE
                if ($i['status'] != 'ACTIVE' && $i['status'] != 'INACTIVE') {
                    throw new Exception("Illegal Tender Manifest JSON Document! questionnaire status must be either ACTIVE or INACTIVE, wrong status for id:" . $i['id']);
                }

                switch ($i['type']) {
                    case "select":
                        // in this case, options property must be defined
                        if (!array_key_exists('options', $i)) {
                            throw new Exception("Illegal Tender Manifest JSON Document! questionnaire options must be defined for the case of select question id:" . $i['id']);
                        }
                        break;
                    case "slider":
                        // in this case, range property must be defined
                        if (!array_key_exists('range', $i)) {
                            throw new Exception("Illegal Tender Manifest JSON Document! questionnaire range must be defined for the case of slider question id:" . $i['id']);
                        }
                        break;
                    case "radio":
                        // in this case, options property must be defined
                        if (!array_key_exists('options', $i)) {
                            throw new Exception("Illegal Tender Manifest JSON Document! questionnaire options must be defined for the case of radio question id:" . $i['id']);
                        }
                        break;
                }
            }
        }

        /***********************************************************************************/
        /*************************** Quota management***************************************/
        /**********************************************************************************/
        if (gettype($manifest["quota_management"]) != "array") {
            throw new Exception("Illegal Tender Manifest JSON Document! quota_management must be of type array! ");
        }

        if (!is_bool($manifest["quota_management"]["is_quota_managed"])) {
            throw new Exception("Illegal Tender Manifest JSON Document! is_quota_managed must be of type boolean! ");
        }

        if (gettype($manifest["quota_management"]["quota_managed_label"]) != "string") {
            throw new Exception("Illegal Tender Manifest JSON Document! quota_managed_label must be of type string! ");
        }

        /***********************************************************************************/
        /*************************** waybill_captions***************************************/
        /**********************************************************************************/
        if (gettype($manifest["waybill_captions"]) != "array") {
            throw new Exception("Illegal Tender Manifest JSON Document! waybill_captions must be of type array!");
        }

        /***********************************************************************************/
        /*************************** route wage templates ***************************************/
        /**********************************************************************************/

        //throw exception if route_wage_template is not of type array
        if (gettype($manifest["route_wage_template"]) != "array") {
            throw new Exception("Illegal Tender Manifest JSON Document! route_wage_templates must be of type array! ");
        }

        //throw exception if plan is not of type string
        if (gettype($manifest["route_wage_template"]["plan"]) != "string") {
            throw new Exception("Illegal Tender Manifest JSON Document! route_wage_template plan  must be of type string! ");
        }

        //throw exception if wage_per_ton is not of type integer
        if (gettype($manifest["route_wage_template"]["wage_per_ton"]) != "string") {
            throw new Exception("Illegal Tender Manifest JSON Document! route_wage_template wage_per_ton  must be of type string! ");
        }

        //throw exception if minimum_weight is not of type integer
        if (gettype($manifest["route_wage_template"]["minimum_weight"]) != "string") {
            throw new Exception("Illegal Tender Manifest JSON Document! route_wage_template minimum_weight  must be of type string! ");
        }

        //throw exception if loss_fine_per_kg is not of type string
        if (gettype($manifest["route_wage_template"]["loss_fine_per_kg"]) != "string") {
            throw new Exception("Illegal Tender Manifest JSON Document! route_wage_template loss_fine_per_kg  must be of type string! ");
        }

        //throw exception if fixed_waybill_wage is not of type string
        if (gettype($manifest["route_wage_template"]["fixed_waybill_wage"]) != "string") {
            throw new Exception("Illegal Tender Manifest JSON Document! route_wage_template fixed_waybill_wage  must be of type string! ");
        }

        //throw exception if tolerance_percentage is not of type string
        if (gettype($manifest["route_wage_template"]["tolerance_percentage"]) != "string") {
            throw new Exception("Illegal Tender Manifest JSON Document! route_wage_template tolerance_percentage  must be of type string! ");
        }

        //throw exception if autoGenerateWaybills is not of type boolean
        if (!is_bool($manifest["autoGenerateWaybills"])) {
            throw new Exception("Illegal Tender Manifest JSON Document! autoGenerateWaybills   must be of type boolean! ");
        }

        // throw exception if statusMap element not defined or not an array of objects
        if (gettype($manifest['statusMap']) != 'array') {
            throw new Exception("Illegal Tender Manifest JSON Document! statusMap property must be of type array and contains object only! ");
        }

        //throw exception if call_center_settings is not of type array
        if (gettype($manifest["call_center_settings"]) != "array") {
            throw new Exception("Illegal Tender Manifest JSON Document! call_center_settings must be of type array!");
        }

        //throw exception if voucher_confirm_method  is not of type string
        if (gettype($manifest["voucher_confirm_method"]) != "string") {
            throw new Exception("Illegal Tender Manifest JSON Document! voucher_confirm_method must be of type string!");
        }

        //throw exception if call_center_settings is not of type array
        if (gettype($manifest["waybill_print_template"]) != "array") {
            throw new Exception("Illegal Tender Manifest JSON Document! waybill_print_template must be of type array! ");
        }

        //check if the waybill print template is not empty
        if (sizeof($manifest["waybill_print_template"]) > 0) {
            if ($this->isArrayOfType($manifest["waybill_print_template"], "array") != true) {
                throw new Exception("Illegal Tender Manifest JSON Document! waybill_print_template must be of type array of objects! ");
            }

            foreach ($manifest["waybill_print_template"] as $template) {
                //throw exception if status  is not of type string
                if (gettype($template["status"]) != "string") {
                    throw new Exception("Illegal Tender Manifest JSON Document! status must be of type string!");
                }
                if (gettype($template["template"]) != "string") {
                    throw new Exception("Illegal Tender Manifest JSON Document! template must be of type string!");
                }
                if (gettype($template["print_title"]) != "string") {
                    throw new Exception("Illegal Tender Manifest JSON Document! print_title must be of type string!");
                }
            }
        }

        //throw exception if aloowMultiCargoForOrder is not of type boolean
        if (!is_bool($manifest["allowMultiCargoForOrder"])) {
            throw new Exception("Illegal Tender Manifest JSON Document! allowMultiCargoForOrder must be of type boolean! ");
        }

        //throw exception if aloowMultiCargoForOrder is not of type boolean
        if (!is_bool($manifest["allowMultiTruckForCargo"])) {
            throw new Exception("Illegal Tender Manifest JSON Document! allowMultiTruckForCargo must be of type boolean! ");
        }

        //throw exception if enableSendNotification is not of type boolean
        if (!is_bool($manifest["enableSendNotification"])) {
            throw new Exception("Illegal Tender Manifest JSON Document! enableSendNotification must be of type boolean! ");
        }

        //throw exception if call_center_settings is not of type array
        if (array_key_exists('payment_delay', $manifest['freight']) && $manifest['freight']['payment_delay'] && gettype($manifest['freight']['payment_delay']) != "array") {
            throw new Exception("Illegal Tender Manifest JSON Document! payment_delay must be of type array! ");
        }

        //check if the payment_delay is not empty
        if ($manifest['freight']['payment_method']["payment_delay"]) {
            if (sizeof($manifest['freight']['payment_method']["payment_delay"]) > 0) {
                if ($this->isArrayOfType($manifest['freight']['payment_method']["payment_delay"], "array") != true) {
                    throw new Exception("Illegal Tender Manifest JSON Document! payment_delay must be of type array of objects! ");
                }
            }
        }

        //check extra_fees
        if ($manifest['freight']['payment_method']["extra_fees"]) {
            if (!is_bool($manifest['freight']['payment_method']["extra_fees"]['enable_extra_fees'])) {
                throw new Exception("Illegal Tender Manifest JSON Document! enable_extra_fees must be of type boolean! ");
            }

            if (gettype(intval($manifest['freight']['payment_method']["extra_fees"]['maximum_extra_fees']))  != "integer") {
                throw new Exception("Illegal Tender Manifest JSON Document!maximum_extra_fees should be of type integer");
            }
        }

        return $manifest;
    }

    private function isArrayOfType($inputArray, $inputType)
    {
        if (gettype($inputArray) != 'array') return false;
        foreach ($inputArray as $i) {
            if (gettype($i) != $inputType) return false;
        }
        return true;
    }

    private function propertyOfArray($inputArray, $inputKey)
    {
        if (gettype($inputArray) != 'array') return '';
        $outList = [];
        foreach ($inputArray as $i) {
            try {
                array_push($outList, $i[$inputKey]);
            } catch (Exception $e) {
                // if key not found, do nothing and continue
            }
        }
        return $outList;
    }
    // Any JSON array of objects with ID can be converted into indexed array object
    private function parseIndexedArray($questionnaire)
    {
        foreach (json_decode($questionnaire, $assoc = TRUE) as $q) {
            $result[$q['id']] = $q;
        }
        return $result;
    }


    // ************************************************** DISTRIBUTION PART ********************************************************************** //


    // ---------------------------------------------------------------------------------------------- //
    // ---------------- get the real time pre-distribution info for confirmation screen  ------------ //
    // ---------------------------------------------------------------------------------------------- //
    public function getQueueAssign($tender_id, $queue_id, $user_id, $tender_order_id = null)
    {

        // trucks on queue
        $queueObj = new QueueCore();
        $searchFilter = [['key' => 'q_id', 'val' => $queue_id], ['key' => 'tender_id', 'val' => $tender_id]];
        $trucksInQueue = $queueObj->searchQueue($searchFilter, 20, 0, $user_id);
        $total_trucks_on_queue = $trucksInQueue->found_rows;

        // call core to serve tender orders
        try {

            if ($tender_id == 22 || $tender_id == 12) {
                $serveTenderResult = $this->serveTenderOrders_local($tender_id, $queue_id, $user_id, $tender_order_id);
            } else {
                $serveTenderResult = $this->serveTenderOrders($tender_id, $queue_id, $user_id, $tender_order_id);
            }

            $rejectedTenderResult = $serveTenderResult['rejectedTrucks'];
            $servedTenderResult = $serveTenderResult['servedTrucks'];
            $available_to_overwrite = $serveTenderResult['available_to_overwrite'];

            $locationCore = new LocationCore();
            $total_count = sizeof($servedTenderResult);
            $ordersArr = [];

            foreach ($serveTenderResult['orders'] as &$order) {
                $tempOrder = new stdClass();
                $tempOrder->trucks = $order['trucks'];
                $orderQuestionnaire = $order['questionnaire'];
                if (is_numeric($orderQuestionnaire[1]['val'])) {
                    $destinationName = $locationCore->getBasicLocation($orderQuestionnaire[1]['val'], $user_id)->name;
                } else {
                    $destinationName = $orderQuestionnaire[1]['val'];
                }

                $tempOrder->destination = $destinationName;
                try {

                    if (gettype($order['order_date']) == "Array") {
                        $order_date = new DateTime($order['order_date']['date']);
                        $tempOrder->order_date = $order_date->format('Y-m-d');
                    } else if (gettype($order['order_date']) == "Object") {
                        $order_date = $order['order_date'];
                        $tempOrder->order_date = $order_date->format('Y-m-d');
                    }
                } catch (exception $e) {
                    $tempOrder->order_date = $order['order_date']['date'];
                }


                $tempOrder->minor_tt = $order['questionnaire'][3]['val'];
                $tempOrder->servedTrucks = $order['servedTrucks'];
                foreach ($order['cargo_details'] as $sampleCargo) {
                    $tempOrder->cargo_sample = $sampleCargo['name'];
                }

                if ($tempOrder->trucks == 0 || $tempOrder->servedTrucks ==  $tempOrder->trucks) continue;

                array_push($ordersArr, $tempOrder);
            }

            foreach ($servedTenderResult as &$served) {
                $served['cargo_name'] = $served['selectedCargo']['cargo_name'];
            }
            if ($serveTenderResult['error_message'])
                $error_message = $serveTenderResult['error_message'];
            else
                $error_message = "";
        } catch (Exception $exc) {
            $error_message = $exc->getMessage();
        }

        // get the minimum accepted truck rank
        $min_rank = null;
        if ($servedTenderResult) {
            foreach ($servedTenderResult as $servedtruck) {
                if (!$min_rank) $min_rank = $servedtruck['rank'];

                if ($servedtruck['rank'] < $min_rank) {
                    $min_rank = $servedtruck['rank'];
                }
            }
        }

        if ($min_rank) {
            // clean the rejected trucks where rank larger than min_rank
            if ($rejectedTenderResult) {
                foreach ($rejectedTenderResult as $rejected) {
                    if ($rejected['rank'] > $min_rank) {
                        unset($rejectedTenderResult[$rejected['id']]);
                    }
                }
            }
        }

        unset($serveTenderResult['available_to_overwrite']);

        if ($servedTenderResult && sizeOf($servedTenderResult) == 0) {
            $available_to_overwrite = [];
        }

        $tname = "";
        $result = [
            "info" => [
                "total_count" => $total_count,
                "tname" => $tname ? $tname : "",
                "total_trucks_on_queue" => $total_trucks_on_queue,
                "waybill_creation_method" => $serveTenderResult['tenderMan']['queues'][$queue_id]['waybill_creation_method']
            ],
            "orders" => $ordersArr,
            "distribution" => $servedTenderResult,
            "error_message" => $error_message,
            "rejected" => $rejectedTenderResult,
            "available_to_overwrite" => $available_to_overwrite
        ];


        return $result;
    }

    // -------------------------------------------------------------- //
    // ---------------- get the quota result for company ------------ //
    // -------------------------------------------------------------- //
    public function getCompanyAssign($tender_id, $q_id, $user_id)
    {

        // get the tender company shares 
        $servingResult = $this->getCompanyQuotas($tender_id, $q_id, $user_id);

        // loop on serve output to caculate how many share is given to each company
        $shares = [];
        foreach ($servingResult['output'] as $output) {
            $shares[$output['tenderCompanyId']] += $output['quota'];
        }

        // inject the shares into coresponding company
        $totalServedTrucks = 0;
        foreach ($servingResult['servedCompanies'] as &$servedCompany) {
            $servedCompany['quota_balance'] = $shares[$servedCompany['id']];
            $servedCompany['orders'] = $shares[$servedCompany['id']];
            if (!$servedCompany['quota_balance']) $servedCompany['quota_balance'] = 0;
            $totalServedTrucks += $servedCompany['used_quota'];
        }

        //return the user
        $result = [];
        $result['orders'] = sizeof($servingResult['orders']);
        $result['tenderName'] = $servingResult['tenderMan']['name'];
        $result['totalRequiredTrucks'] = $servingResult['totalRequiredTrucks'];
        $result['totalServedTrucks'] = $totalServedTrucks;
        $result['servedCompanies'] = $servingResult['servedCompanies'];
        $result['rejectedCompanies'] = $servingResult['rejectedCompanies'];

        return $result;
    }

    // ---------------------------------------------------------------------------------------- //
    // ---------------- get the raw pre-distribution info for confirmation screen  ------------ //
    // ---------------------------------------------------------------------------------------- //
    public function getRawPreDistributionInfo($tender_id, $queue_id, $user_id)
    {

        // trucks on queue
        $queueObj = new QueueCore();
        $searchFilter = [['key' => 'q_id', 'val' => $queue_id]];
        $trucksInQueue = $queueObj->searchQueue($searchFilter, 20, 0, $user_id);
        $trucksArr = [];
        foreach ($trucksInQueue->data as $queueTruck) {
            $tempTruck = new stdClass();
            $tempTruck->tn = $queueTruck->tn;
            $tempTruck->trn = $queueTruck->trn;
            $tempTruck->driver_name = $queueTruck->driver_name;
            array_push($trucksArr, $tempTruck);
        }
        $total_trucks_on_queue = $trucksInQueue->found_rows;

        // prepare orders array
        $ordersFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'q_id', 'val' => $queue_id],
            ['key' => 'status', 'val' => 'ACTIVE']
        ];
        $orderResult = $this->searchTenderOrder($ordersFilter, 20, 0, $user_id);
        $ordersArr = [];
        $total_count = 0;
        foreach ($orderResult->data as $order) {
            $tempOrder = new stdClass();
            $tempOrder->trucks = $order->trucks;
            $total_count += $order->trucks;
            $tempOrder->destination = 'TODO';
            $tempOrder->order_date = $order->order_date;
            $tempOrder->weight = 'TODO';
            array_push($ordersArr, $tempOrder);
        }

        //prepare the cargo array
        $cargoCore = new cargoCore();
        $searchFilter = [
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'q_id', 'val' => $queue_id],
            ['key' => 'status', 'val' => 'ACTIVE']
        ];
        $searchCargoResult = $cargoCore->searchCargo($searchFilter, 20, 0, $user_id);

        $cargoArr = [];
        foreach ($searchCargoResult->data as $cargo) {
            $tempCargo = new stdClass();
            $tempCargo->name = $cargo->name;
            $tempCargo->size = $cargo->size;
            $tempCargo->weight_total = $cargo->weight_total;
            $tempCargo->weight_units = $cargo->weight_units;
            array_push($cargoArr, $tempCargo);
        }

        $result = [
            "info" => [
                "total_count" => $total_count,
                "total_trucks_on_queue" => $total_trucks_on_queue
            ],
            "truck" => $trucksArr,
            "orders" => $ordersArr,
            "cargo" => $cargoArr
        ];

        return $result;
    }


    // ----------------------------------------------------------------------------------------------------------------- //
    // ---------------- start the distribution (assign cargo + createing waybills) process ----------------------------- //
    // ----------------------------------------------------------------------------------------------------------------- //
    public function distribute($tender_id, $queue_id, $user_id, $tender_order_ids = null)
    {

        // call core to serve tender orders        
        $serveTenderResult = $this->serveTenderOrders($tender_id, $queue_id, $user_id, $tender_order_ids);

        //start creating waybills
        $waybillOrderCore = new WaybillOrderCore();
        $queueCore = new QueueCore();
        $taskQueuesCore = new TaskQueuesCore();

        foreach ($serveTenderResult['servedTrucks'] as &$servedTruck) {
            if ($servedTruck['selectedCargo']['waybillOrder'] == null) {
                // prepare all needed info for waybill order
                $cargo_id = $servedTruck['selectedCargo']['cargo'];
                $order_id = $servedTruck['selectedCargo']['order'];

                // create waybill orders by pushing tasks into queue
                // $taskQueuesCore = new TaskQueuesCore();
                // $taskQueuesCore->creatWaybillOrderTask($order_id, $cargo_id, $servedTruck['truck_owner_id'], $servedTruck['id'], $tender_id);

                // for local testing only
                $waybillOrderResult = $waybillOrderCore->createWaybillOrder($order_id, $cargo_id, $servedTruck['truck_owner_id'], $servedTruck['id'], 0);
            }
        }

        return $serveTenderResult;
    }


    // -------------------------------------------------------------------------------------------------------- //
    // ---------------- start the distribution (createing waybill orders) process ----------------------------- //
    // -------------------------------------------------------------------------------------------------------- //
    public function distributeTruckingCompanyOrder($cargo_id, $order_id, $truck_ids, $user_id)
    {

        //init objects
        $queueObj = new QueueCore();
        $waybillOrderCore = new WaybillOrderCore();
        $taskQueuesCore = new TaskQueuesCore();
        $taskQueuesCore = new TaskQueuesCore();

        // get the tender order Bean
        $tenderOrderBean = $this->getTenderOrderBasic($order_id, 0);

        // get the tender trucks objects for the requested trucks
        $activeTenderTrucks = DBConnection::getActiveStatus('tender_truck');
        $searchFilter = [
            ['key' => 'tender_id', 'val' => $tenderOrderBean->tender_id],
            ['key' => 'truck_id', 'val' => $truck_ids, 'op' => 'in'],
            ['key' => 'status', 'val' => $activeTenderTrucks, 'op' => 'in']
        ];
        $tenderTrucksResult = $this->searchTenderTruck($searchFilter, 1000, 0, $user_id);
        $tenderTrucksResult = $tenderTrucksResult->data;

        foreach ($tenderTrucksResult as $servedTruck) {

            // prepare all needed info for waybill order
            $queueSearchFilter = [
                ['key' => 'q_id', 'val' => $servedTruck->q_id],
                ['key' => 'tender_id', 'val' => $servedTruck->tender_id],
                ['key' => 'status', 'val' => 'ACTIVE'],
                ['key' => 'truck_id', 'val' => $servedTruck->truck_id]
            ];
            $queueBean = $queueObj->searchQueue($queueSearchFilter, 1, 0, 0)->data[0];


            // create waybill orders by pushing tasks into queue
            $taskQueuesCore->creatWaybillOrderTask($order_id, $cargo_id, $servedTruck->truck_owner_id, $queueBean->id, $tenderOrderBean->tender_id);
        }

        // TODO: init the call center

        //return $serveTenderResult;
    }




    public function prepareLocationValue($input, $cargoBean)
    {

        if (preg_match('/_*[a-z]_\$_*[a-z]_*/', $input)) {
            $source = explode("$", $input)[0];    // split by $ and take the first part
            $source = trim($source, '_');       // remove first and last _
            $val = explode("$", $input)[1];       // split by $ and take the second part
            $val = trim($val, '_');             // remove first and last _

            if ($source == 'cargo') {
                return $cargoBean->$val;
            } else if ($source == 'system') {
                //TODO
            }
        } else {
            return $input;
        }
    }


    // ---------------------------------------------------------------------------- //
    // --------------------- get Distribution info for certain id ----------------- //
    // ---------------------------------------------------------------------------- //
    public function getDistribution($id, $user_id)
    {
        $distributionInfo = DBConnection::getObjectBean("assign_cargo", $id, $user_id);
        return $distributionInfo;
    }

    // -------------------------------------------------------------------------------- //
    // -------------------search for Distributions using any search filter ------------ //
    // -------------------------------------------------------------------------------- //
    public function searchQueueDistributions($searchFilter, $limit, $offset, $user_id)
    {
        $searchQueueDistributionsResult = DBConnection::searchDB("assign_cargo", $searchFilter, $limit, $offset, $user_id);
        return $searchQueueDistributionsResult;
    }


    // --------------------------------------------------------------------------------------------------- //
    // -------------attemp to close "tender-order" in case all the "waybill-orders" are approved---------- //
    // --------------------------------------------------------------------------------------------------- //
    public function closeTenderOrder($tender_order_id)
    {

        $waybillOrderCore = new WaybillOrderCore();

        $ordersFilter = [['key' => 'id', 'val' => $tender_order_id]];
        $tenderOrderBean = $this->searchTenderOrder($ordersFilter, 1, 0, 0)->data[0];

        // if number of approved and closed "waybill orders" equals the "tender order" truck, change status of tender order to CLOSED
        $searchFilter = [
            ['key' => 'tender_order_id', 'val' => $tender_order_id],
            ['key' => 'status', 'val' => ['APPROVED', 'CLOSED'], 'op' => 'in']
        ];
        $activeWaybillOrders = $waybillOrderCore->searchWaybillOrder($searchFilter, 1000, 0, 0);

        if ($activeWaybillOrders->found_rows >= $tenderOrderBean->trucks) {
            $this->changeOrderStatus($tender_order_id, 'CLOSED', 0); // closed by SYSTEM

            // inform operation manager
            $socialCore = new SocialCore();
            $notification_message  =  "اكتمال طلبية " . $tenderOrderBean->cargo_sample_name . " بعدد " . $tenderOrderBean->trucks . " شاحنة";
            $wall_message = "تم اكتمال طلبية " . $tenderOrderBean->cargo_sample_name . " بتاريخ " . $tenderOrderBean->order_date . " بعدد " . $tenderOrderBean->trucks . " شاحنة";
            $socialCore->informSupervisor('اكتمال طلبية', $wall_message, $notification_message);
        }
    }



    // ---------------------------------------------------------------------------- //
    // -------------------- get list of accounts in certain tender ---------------- //
    // ---------------------------------------------------------------------------- //
    public function getTenderAccounts($tender_id)
    {

        $tenderBean = $this->getTenderBasic($tender_id, 0);
        $tender_accounts = $tenderBean->manifest->freight->accounts;

        $result = [];
        foreach ($tender_accounts as $account) {
            $result[$account->code] = $account->account;
        }
        return $result;
    }


    // ---------------------------------------------------------------------------- //
    // -------------------- Update the tender manifest ---------------------------- //
    // ---------------------------------------------------------------------------- //
    public function updateTenderManifest($tender_id, $manifest, $user_id)
    {
        //parse manifest for technical validation
        $this->parseTenderManifest($manifest);

        // TODO: validate manifest for functional validation
        // $this->validateTendetMainifest($tender_id, $manifest);

        // create tender bean
        $tender_bean = new stdClass();
        $tender_bean->id = $tender_id;
        $tender_bean->manifest = json_decode($manifest);
        $tender_bean->user_id = $user_id;

        // fill update struct and set the target user id
        DBConnection::updateDB("tender", $tender_bean, $user_id);
    }


    // --------------------------------------------------------------------------------------------------- //
    // -------------validate tender mainifest ------------------------------------------------------------ //
    // --------------------------------------------------------------------------------------------------- //
    private function validateTendetMainifest($tender_id, $manifest)
    {
        //-------------------------------------------------------------------------//
        //------VALIDATE JSON  -----------------------------------------------------//
        //--------------------------------------------------------------------------//
        try {
            $validJson = json_decode(json_encode($manifest));
        } catch (Exception $error) {
            throw new Exception('خطأ في المعلومات المدخلة');
        }
        //-------------------------------------------------------------------------//
        //------VALIDATE TENDER INFO -----------------------------------------------//
        //--------------------------------------------------------------------------//
        if ($manifest->name == '') {
            throw new Exception(' اسم المشروع حقل إجباري ');
        }

        if (!validateDate($manifest->start)) {
            throw new Exception('الرجاء التأكد من تاريخ بداية المشروع  ');
        }
        if (!validateDate($manifest->expiry)) {
            throw new Exception('الرجاء التأكد من تاريخ نهاية المشروع  ');
        }
        if ($manifest->start > $manifest->expiry) {
            throw new Exception('  تاريخ بداية المشروع يجب ان يكون قبل تاريخ النهاية');
        }

        if ($manifest->ct[0] == '' || count($manifest->ct) == 0) {
            throw new Exception(' الرجاء تحديد أنماط المشروع  ');
        }
        //------validate tender location -----------

        if (count($manifest->origin) == 0) {
            throw new Exception(' الرجاء تحديد مواقع التحميل ');
        }
        if (count($manifest->destination) == 0) {
            throw new Exception(' الرجاء تحديد مواقع التفريغ       ');
        }
        //-------------------------------------------------------------------------//
        //------VALIDATE TENDER QUEUES ---------------------------------------------//
        //--------------------------------------------------------------------------//

        foreach ($manifest->queues as $queue) {
            if ($queue->name == '') {
                throw new Exception(' اسم الدور حقل إجباري ');
                break;
            }
            if (count($queue->cargo_filter) == 0) {
                throw new Exception(' الرجاء تحديد نمط البضاعة لدور ' . $queue->name);
                break;
            }
            if ($queue->delay_rules->method == '') {

                throw new Exception(' الرجاء تحديد ألية التأجيل لدور ' . $queue->name);
                break;
            }
            if ($queue->delay_rules->method != 'NONE') {
                if ($queue->delay_rules->total_delays == '') {
                    throw new Exception(' الرجاء تحديد عدد أيام التأجيل لدور ' . $queue->name);
                    break;
                }
                if ((int)$queue->delay_rules->total_delays <= 0) {
                    throw new Exception(' الرجاء التأكد من عدد أيام التأجيل لدور ' . $queue->name);
                    break;
                }
                if ($queue->delay_rules->message == '') {
                    throw new Exception(' الرجاء تحديد رسالة إنتهاء التأجيل  لدور ' . $queue->name);
                    break;
                }
            }
            if ($queue->requeue_rules->method == '') {

                throw new Exception(' الرجاء تحديد الية اعادة الدور لدور ' . $queue->name);
                break;
            }
            if ($queue->requeue_rules->method != 'NONE') {
                if ($queue->requeue_rules->status == '' || $queue->requeue_rules->new_status == '' || $queue->requeue_rules->target_queue == '') {
                    throw new Exception('المعلومات المطلوبة ﻹعادة الشاحنة على الدور  غير مكتملة  , ' . $queue->name);
                    break;
                }
            }
            if ($queue->allow_answer_change == true || $queue->allow_answer_change == 'true') {
                if ($queue->answer_change_action == '') {
                    throw new Exception(' الرجاء تحديد الإجراء عند تغيير اﻹجابة ,  لدور : ' . $queue->name);
                    break;
                }
            }
            if ($queue->allow_trailer_edit == true || $queue->allow_trailer_edit == 'true') {
                if ($queue->trailer_edit_action == '') {
                    throw new Exception(' الرجاء تحديد  المقطورة الجديدة عند السماح بتغيير رقم المقطورة ,  لدور : ' . $queue->name);
                    break;
                }
            }
        }
        //-------------------------------------------------------------------------//
        //------VALIDATE TENDER QUESTIONNAIRE --------------------------------------//
        //-------------------------------------------------------------------------//

        if (count($manifest->questionnaire) == 0) {
            throw new Exception(' الرجاء تحديد سؤال عن مواقع التحميل و سؤال عن مواقع التفريغ  على الأقل في اﻹستبيان');
        }
        $_hasOrginQuestiuoner = false;
        $_hasDestenationQuestiuoner = false;
        foreach ($manifest->questionnaire as $question) {
            if ($question->question_type == 'ROUTE:ORIGIN') {

                $_hasOrginQuestiuoner = true;
            }
            if ($question->question_type == 'ROUTE:DISTINATION') {

                $_hasDestenationQuestiuoner = true;
            }
        }
        if (!$_hasOrginQuestiuoner) {
            throw new Exception(' الرجاء تحديد سؤال عن مواقع التحميل ');
        }
        if (!$_hasDestenationQuestiuoner) {
            throw new Exception(' الرجاء تحديد سؤال عن مواقع التفريغ ');
        }
        //-------------------------------------------------------------------------//
        //------VALIDATE TENDER FREIGHT -------------------------------------------//
        //-------------------------------------------------------------------------//

        $_accountArray = array();
        $_accounts = $manifest->freight->accounts;

        // --------check duplicated accounts--------------
        foreach ($_accounts as $account) {
            array_push($_accountArray, $account->account);
        }
        if (array_has_dupes($_accountArray)) {
            throw new Exception('لا يجوز تشابه أرقام الحسابات في المشروع ');
        }
        // --------check accounts --------------
        foreach ($_accounts as $account) {
            $_accountResult = $this->_accountCore->getAccount($account->account, 0);
            if (!$_accountResult) {
                throw new Exception($account->label . ' رقم ' . $account->account . ' غير معرف على النظام');
            }
            if ($account->code != 'main_liability_account') {
                if (substr($account->account . '', 0, 2) != '59') {
                    throw new Exception($account->label . ' رقم ' . $account->account . ' غير مسموح ');
                }
            }
        }
        // --------check estimate_waybill_amount --------------
        if ($manifest->freight->estimate_waybill_amount->method == '') {
            throw new Exception(' الرجاء تحديد طريقة إحتساب القيمة التقديرية لمستند الشحن');
        }
        if ($manifest->freight->estimate_waybill_amount->method = 'fixed') {
            if ($manifest->freight->estimate_waybill_amount->value == '') {
                throw new Exception(' الرجاء تحديد  القيمة التقديرية لمستند الشحن  ');
            }
            if ((int)$manifest->freight->estimate_waybill_amount->value <= 0) {
                throw new Exception(' الرجاء التأكد  من القيمة التقديرية لمستند الشحن  ');
            }
        }
    }

    // -------------------------------------------------------------------------------------------------------------------------------- //
    // -------------------- generate json object contains all the needed info for the call center to start ---------------------------- //
    // -------------------- then call the init function of the call center ------------------------------------------------------------ //
    // -------------------------------------------------------------------------------------------------------------------------------- //
    public function createCallTicket($waybill_order_id, $forceManualMode = false)
    {

        //init obj
        $queueCore = new QueueCore();
        $waybillOrderCore = new WaybillOrderCore();

        // get the waybillOrder bean
        $searchFilter = [
            ['key' => 'id', 'val' => $waybill_order_id],
            ['key' => 'status', 'val' => ['NEW', 'WAITING'], 'op' => 'in']
        ];
        $waybillOrderResult = $waybillOrderCore->searchWaybillOrder($searchFilter, 10000, 0, 0);
        $waybillOrderBean = $waybillOrderResult->data[0];
        $waybillOrderBeanBasic = $waybillOrderCore->getWaybillOrderBasic($waybillOrderBean->id, 0);

        // if the waybill order already has a ticket , dont create ticket again
        if ($waybillOrderBeanBasic->tc_details->ticket_id && $waybillOrderBeanBasic->tc_details->ticket_id != "") {
            return;
        }

        $tender_id = $waybillOrderBean->tender_id;
        $queue_id = $waybillOrderBean->queue_id;
        $q_id = $waybillOrderBean->q_id;

        $tender_name = $waybillOrderBean->tender_name;
        $queue_name = $waybillOrderBean->queue_name;

        // get the needed info from the tender setting
        $tenderMan = $this->getTenderManifest($tender_id, 0);

        // fill the result in JSON array
        $maxRetries = $tenderMan['call_center_settings']['call_retrials'];
        if (!$maxRetries) {
            $maxRetries = 2;
        }

        $isManuallMode = false;
        try {
            $options = $queueCore->getQueueDelayOptions($waybillOrderBean->queue_id, $tender_id, $q_id, 0);
            if (!isset($options->delay_options)) {
                throw new Exception();
            }
        } catch (Exception $e) {

            $isManuallMode = true;

            $option = new stdClass();
            $option->code = -1;
            $option->value = "ارجاع إلى اخر الدور";
            $option->caption = "ارجاع إلى اخر الدور";
            $delay_options = [];
            array_push($delay_options, $option);

            $options = new stdClass();
            $options->delay_options = $delay_options;
        }

        // get queue bean
        $queueBean = $queueCore->getQueueBasic($queue_id, 0);
        $callObj = new stdClass();

        // fill basic info
        $callObj->tn = $waybillOrderBean->tn;
        $callObj->title = "معاملة اتصال عن أمر الحركة " . $waybillOrderBean->id;
        $callObj->senderName = "مدارج للخدمات اللوجستية";
        $callObj->type_code = "call";
        $callObj->priority = 3;
        $callObj->company_id = 266770;

        $callObj->trn = $waybillOrderBean->trn;
        $callObj->phone_number = $waybillOrderBean->contact_phone;
        $callObj->name = $waybillOrderBean->contact_name;
        $callObj->type = 'call';

        // fill call_details
        $cargoCore = new cargoCore();
        $cargoBean = $cargoCore->getCargoBasic($waybillOrderBean->cargo_id, 0);
        $ct_id = $cargoBean->ct_id;

        if ($tender_id == 3) {
            $cargo_wav = "T" . $tender_id . "C" . $ct_id . ".wav";
            $cargo_default_wav = "T" . str_pad($tender_id, 2, "0", STR_PAD_LEFT) . ".wav";
        }
        if ($tender_id == 13) {
            $cargo_wav = "T013.wav";
            $cargo_default_wav = "T013.wav";
        } else {
            $isManuallMode = true;
        }

        // get tender order to get destination
        $questionnaire = $tenderMan['questionnaire'];
        if ($questionnaire) {
            foreach ($questionnaire as $q) {
                if ($q['question_type'] == "ROUTE:ORIGIN") {
                    $origin_question_id = $q['id'];
                }
            }
        }

        $tenderOrderBean = $this->getTenderOrderBasic($waybillOrderBean->tender_order_id, 0);
        foreach ($tenderOrderBean->questionnaire as $order_q) {
            if ($order_q->id ==  $origin_question_id) {
                $origin_route_id = $order_q->val;
            }
        }


        $callObj->call_details = new stdClass();
        $callObj->call_details->type_code = "call";
        $callObj->call_details->id = $waybill_order_id;
        $callObj->call_details->tn = $waybillOrderBean->tn;
        $callObj->call_details->trn = $waybillOrderBean->trn;
        $callObj->call_details->rank = $queueBean->rank;
        $callObj->call_details->ct_id = $ct_id;
        $callObj->call_details->cargo_wav = $cargo_wav;
        $callObj->call_details->cargo_default_wav = $cargo_default_wav;
        $callObj->call_details->cargo_name = $waybillOrderBean->cargo_name;
        $callObj->call_details->queue_name = $queue_name;
        $callObj->call_details->tender_name = $tender_name;
        $callObj->call_details->origin_route_id = $origin_route_id;
        $callObj->call_details->truck_owner_name = $waybillOrderBean->truck_owner_name;
        $callObj->call_details->call_timeout = 120000; //in milli sec
        if ($options) {

            // in case the call is auto , limit the delay options to 9
            if ($isManuallMode || $forceManualMode == true) {
            } else {
                if (sizeof($options->delay_options) > 9) {
                    $options->delay_options = array_slice($options->delay_options, 0, 8);
                }
            }

            $callObj->call_details->delay_option = $options->delay_options;
        } else {
            $callObj->call_details->delay_option = [new stdClass()];
        }

        if ($isManuallMode || $forceManualMode == true) {
            $callObj->call_mode = "manual";
            $callObj->call_details->manual_details = new stdClass();
            $callObj->call_details->manual_details->mode = "manual";
            $callObj->call_details->manual_details->call_mode = "manual";
        } else {
            $callObj->call_details->call_mode = "auto";
            $callObj->call_mode = "auto";
        }

        $callObj->call_mode = "manual";

        try {
            $response = $this->_customerCare->createCallTicket($callObj);
            // change status of waybill order to Waiting "بانتظار الإتصال"
            $waybillOrderCore->changeStatus($waybill_order_id, 'WAITING', 0);
            //update waybill order with ticket id
            $waybillOrderBean = $waybillOrderCore->getWaybillOrderBasic($waybill_order_id, 0);
            $tc_details = $waybillOrderBean->tc_details;
            $tc_details->ticket_id = $response['id'];
            $waybillOrderBean->tc_details = $tc_details;
            // fill update struct and set ticket_id
            $waybillOrderCore->updateWaybillOrder($waybillOrderBean, $waybill_order_id, 0);
        } catch (Exception $e) {
            // in case the push to call center failed, inform call center manager
            // $callCenter_supervisor_id = $tenderMan['call_center_settings']['call_center_supervisor'];
            $callCenter_supervisor_id = 2; // for the testing phase, send me the errors so I can follow up, later send it to call center supervisor

            if ($callCenter_supervisor_id) {
                $socialCore = new SocialCore();
                $tn = $waybillOrderBean->tn;
                $wall_message = "لم يتمكن النظام من ارسال معاملة الاتصال للشاحنة رقم $tn - " . json_encode($response) . "-" . $e->getMessage();
                $notification_message = "لم يتمكن النظام من ارسال معاملة الاتصال للشاحنة رقم $tn";
                $socialCore->informSupervisor('خطأ في ارسال المعاملة', $wall_message, $notification_message, $callCenter_supervisor_id);
            }
            throw new Exception("Cant initialize a call on CALL_CENTER system, " .  $e->getMessage());
        }


        return $response;
    }


    // ------------------------------------------------------------------------------------------------------------------------- //
    // ------ if number of "active waybillorders" (approved, new, closed) is less than number of trucks in tenderOrder --------- //
    // ------ re-distribut the same tender order again in order to reach the destination number of trucks ---------------------- //
    // ------------------------------------------------------------------------------------------------------------------------- //
    public function redistributeTenderOrder($tender_order_id)
    {

        // TODO: this needs to be in task queue

        //init the obj
        $waybillOrderObj = new WaybillOrderCore();

        // search for active waybill orders created for this tender_order
        $searchFilter = [
            ['key' => 'tender_order_id', 'val' => $tender_order_id],
            ['key' => 'status', 'val' => ['REVOKED'], 'op' => 'not in']
        ];
        $activeWaybillOrders = $waybillOrderObj->searchWaybillOrder($searchFilter, 10000, 0, 0);

        // get the tenderOrderBean
        $tenderOrderBean = $this->getTenderOrderBasic($tender_order_id, 0);

        // if number is less, re-distribut it again
        if ($activeWaybillOrders->found_rows < $tenderOrderBean->trucks) {
            $this->distribute($tenderOrderBean->tender_id, $tenderOrderBean->q_id, 0, [$tender_order_id]);
        }
    }


    // ---------------------------------------------------------------------------------------------------------------------------- //
    // ----------------------------- Search tender manifest for call center super visor id ---------------------------------------- //
    // ---------------------------------------------------------------------------------------------------------------------------- //
    public function getCallCenterSupervisorId($tender_id)
    {

        $man = $this->getTenderManifest($tender_id, 0);
        $supervisorId = $man['call_center_settings']['call_center_supervisor'];
        return $supervisorId;
    }


    // ------------------------------------------------------------------------------------------------------------------- //
    // ------------------------------ set the trailer_id to null in tender truck ----------------------------------------- //
    // ------------------------------------------------------------------------------------------------------------------- //
    public function removeTenderTruckTrailerId($tender_truck_id, $user_id)
    {

        $sqlQuery = " update tender_truck set trailer_id=null , update_by= ? where id = ?";

        $param = [$user_id, $tender_truck_id];
        $result = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
    }

    // ------------------------------------------------------------------------------------------------------------------- //
    // ------------------------------ set the trailer_id to null in tender truck ----------------------------------------- //
    // ------------------------------------------------------------------------------------------------------------------- //
    public function getTenderTruckDefaultContact($tender_truck_id, $user_id)
    {

        // init objects
        $truckOwnerCore = new TruckOwnerCore();
        $userCore = new UserCore();

        // get the tender truck bean
        $tenderTruckBean = $this->getTenderTruckBasic($tender_truck_id, $user_id);

        // get the truck_owner id (here it is called "default_contact_user_id" but it is owner id not user id)
        $truck_owner_id = $tenderTruckBean->default_contact_user_id;
        $truckOwnerBean = $truckOwnerCore->getTruckOwnerBasic($truck_owner_id, $user_id);

        // get the userBean from the truckOwner
        $userBean = $userCore->getUserBasic($truckOwnerBean->user_id, $user_id);

        //return result
        $result = new stdClass();
        $result->user_id = $userBean->id;
        $result->nn = $userBean->nn;
        $result->truck_owner_id = $userBean->truck_owner_id;
        $result->name = $userBean->name;
        $result->phone = $userBean->phone;

        return $result;
    }


    // ---------------------------------------------------------------------------------------------------------------------------- //
    // ------------------------------ Validate of the user has the right role to view certain report in the tender ---------------- //
    // ---------------------------------------------------------------------------------------------------------------------------- //
    public function validateTenderReportAuth($tender_id, $reportName, $userRoles)
    {
        $has_auth = false;
        $manifestBean = $this->getTenderManifest($tender_id, 0);
        $userRoles = explode(",", $userRoles);
        $reports = $manifestBean['reports'];
        foreach ($reports as $report) {
            if ($report['template'] == $reportName) {
                $allowedRoles = $report['roles'];
                foreach ($userRoles as $userRole) {
                    if (in_array($userRole, $allowedRoles)) {
                        $has_auth = true;
                    }
                }
            }
        }
        if (!$has_auth) {
            throw new Exception("لا يوجد لديك صلاحية لمشاهدة التقرير");
        }
    }

    // -------------------------------------------------------------------------------------------------- //
    // -------------------------------- Get Tender share holders list for report ------------------------ //
    // -------------------------------------------------------------------------------------------------- //
    public function getTenderShares($tender_id, $snapshotDate = null)
    {

        // get the tender MLA account
        $tenderAccounts = $this->getTenderAccounts($tender_id);
        $MLA = $tenderAccounts['main_liability_account'];

        if (!$snapshotDate) {
            $snapshotDate = "NOW()";
        }

        // run database query to get tender shares
        $sqlQuery = "SELECT acc,a.name, SUM(amount) amount
                    FROM (SELECT id, to_account acc, - 1 * amount as amount
                        FROM waybill.account_trx
                        WHERE from_account = ?
                                AND to_account < 590000
                                AND create_date < ?
                        UNION
                        SELECT id, from_account acc, amount
                        FROM waybill.account_trx
                        WHERE to_account = ?
                                AND from_account < 590000
                                AND create_date < ?) as ttl
                    join account a on ttl.acc=a.id
                    GROUP BY acc,a.name";
        $param = [$MLA, $snapshotDate, $MLA, $snapshotDate];
        $searchQueryResult = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        //return result
        return $searchQueryResult;
    }


    // ----------------------------------------------------------------------------------------------- //
    // ----------------- Save the serve company quote in database ------------------------------------ //
    //------------------------------------------------------------------------------------------------ //
    public function saveTenderOrderCompany($tender_order_id, $cargo_id, $tender_company_id, $share, $update_by)
    {

        $sqlQuery = "insert into tender_order_company
                     (tender_order_id,cargo_id,tender_company_id,share,status,waybills,update_by) 
                     values (?,?,?,?,?,?,?)";
        $param = [$tender_order_id, $cargo_id, $tender_company_id, $share, 'ACTIVE', 0, $update_by];

        $result = DBConnection::runBindDatabaseQuery($sqlQuery, $param);
    }


    // ---------------------------------------------------------------------------------------------------------- //
    // ----------------- Save the total serve result for company in database "tender_company_quota" ------------- //
    //----------------------------------------------------------------------------------------------------------- //
    public function saveTenderCompanyQuota($tender_company_id, $q_id, $quota, $residual, $used_quota, $update_by)
    {

        // get the previos record for tender_company_id on this tender
        $sqlQuery1 = "select * from tender_company_quota
                      where status = 'ACTIVE' and tender_company_id = ?";
        $param1 = [$tender_company_id];
        $result1 = DBConnection::runBindDatabaseQuery($sqlQuery1, $param1);

        // work on old record
        if (sizeof($result1)) {
            $result1 = $result1[0];

            // here the system will determine what to do with comapny old quota
            switch ($result1->status) {
                    // The admin requested new order , old quota and residual must be transfered to the new record
                case 'ACTIVE':
                    // update residual
                    $tender_company_quota_id = $result1->id;
                    $sqlQuery2 = "update tender_company_quota
                                set quota = ?, used_quota = ?, update_by = 0
                                where id = ?";
                    $param2 = [$quota, $used_quota, $tender_company_quota_id];
                    $result2 = DBConnection::runBindDatabaseQuery($sqlQuery2, $param2);
                    break;

                default:
                    // do nothing
                    break;
            }
        } else {
            // insert the new record
            $new_quota = $quota;
            $residual = 0;
            $insertQry = "insert into tender_company_quota
                            (tender_company_id, q_id , quota, used_quota, residual, status, update_by) 
                            values (?,?,?,?,?,?,?)";
            $insertParam = [$tender_company_id, $q_id, $quota, $used_quota, $residual, 'ACTIVE', $update_by];
            DBConnection::runBindDatabaseQuery($insertQry, $insertParam);
        }
    }


    // --------------------------------------------------------------------------------------------------- //
    // --------------------- deduct 1 quota from tender company ------------------------------------------ //
    // --------------------------------------------------------------------------------------------------- //
    public function useCompanyQuota($tender_id, $tc_id, $tender_order_id)
    {

        $tenderCompanyActiveStatus = DBConnection::getActiveStatus('tender_company');

        $queueSearchFilter = [
            ['key' => 'trucking_company_id', 'val' => $tc_id],
            ['key' => 'tender_id', 'val' => $tender_id],
            ['key' => 'status', 'val' => $tenderCompanyActiveStatus, 'op' => 'in']
        ];
        $tenderCompaniesReuslt = $this->_tenderCompanyCore->searchTenderCompany($queueSearchFilter, 1, 0, 0);
        $tender_company_id = $tenderCompaniesReuslt->data[0]->id;
        if (!$tender_company_id) throw new Exception("لا تستطيع المتابعة ، الناقل الفرعي غير معرف على المشروع");

        try {
            // update used waybill in tender_order_company
            $sqlQuery3 = "select * from tender_order_company
                          where status = 'ACTIVE' and tender_company_id = ?
                          and tender_order_id = ?
                          and waybills < share
                          limit 1";
            $param3 = [$tender_company_id, $tender_order_id];
            $result3 = DBConnection::runBindDatabaseQuery($sqlQuery3, $param3);
            if (!sizeof($result3)) {
                throw new Exception("Error Processing Request");
            }
            $result3 = $result3[0];

            $tender_order_company_id = $result3->id;
            $sqlQuery4 = "update tender_order_company
                         set waybills = waybills+1
                         where id = ?";
            $param4 = [$tender_order_company_id];
            $result4 = DBConnection::runBindDatabaseQuery($sqlQuery4, $param4);
        } catch (Exception $e) {
            if ($tender_id == 11) {
                throw new Exception("لا تستطيع المتابعة ، لا يوجد حصة متبقية لشركة النقل");
            }
        }
    }

    // --------------------------------------------------------------------------------------------------------- //
    // ------------- get a human readable questionnaire , (make each question human readable) ------------------ //
    // --------------------------------------------------------------------------------------------------------- //
    public function getReadableQuestionnaire($tender_id, $questionnaire)
    {

        // get tender manifest
        $man = $this->getTenderManifest($tender_id, 0);
        $original_questionnaire = $man['questionnaire'];
        $result = "";
        foreach ($original_questionnaire as $origianl_question) {
            foreach ($questionnaire as $question) {
                if ($origianl_question['id'] == $question['id']) {
                    $Q = $origianl_question['text'];
                    $result .= $Q . " : ";
                    foreach ($origianl_question['options'] as $answer) {
                        if ($answer['id'] == $question['val']) {
                            $A = $answer['name'];
                            $result .= $A . " / ";
                        }
                    }
                }
            }
        }
        return $result;
    }


    // ------------------------------------------------------------------------------------- //
    // ------------------ Get allowed destinations for certain tender ---------------------- //
    // ------------------------------------------------------------------------------------- //
    public  function getTenderDestinations($tender_id)
    {
        $tenderManifest = $this->getTenderManifest($tender_id, 0);
        $manifest_questionnaire = $tenderManifest['questionnaire'];
        $tender_destinations = [];
        foreach ($manifest_questionnaire as $questions) {
            if ($questions['question_type'] == 'ROUTE:DISTINATION') {
                foreach ($questions['options'] as $temp) {
                    if ($temp['id'] != 0)
                        $tender_destinations[] = $temp['id'];
                }
            }
        }

        return $tender_destinations;
    }


    // ------------------------------------------------------------------------------------- //
    // ------------------ Get Tender order destination  ------------------------------------ //
    // ------------------------------------------------------------------------------------- //
    public function getTenderOrderDestinationId($tenderOrderId)
    {
        $tenderOrder = $this->getTenderOrderBasic($tenderOrderId, 0);
        // Validate that the tender order id does exists
        if (!$tenderOrder) {
            throw  new Exception("Tender Order with id ($tenderOrderId), doesn't exists");
        }
        // Get tender order questionnaire
        $tenderOrderQuestionnaire = $tenderOrder->questionnaire;

        // Get tender manifest
        $tenderManifest = $this->getTenderManifest($tenderOrder->tender_id, 0);
        $manifestQuestionnaire = $tenderManifest['questionnaire'];

        // Find destination manifest questionnaire
        $destinationQuestion = null;
        foreach ($manifestQuestionnaire as $questions) {
            if ($questions['question_type'] == 'ROUTE:DISTINATION') {
                $destinationQuestion = $questions;
            }
        }
        if (empty($destinationQuestion)) {
            throw new Exception("Can't find destination question in manifest questionnaire");
        }
        // Match the tender order question to its template in manifest
        $tenderOrderDestQuestion = null;
        foreach ($tenderOrderQuestionnaire as $question) {
            if ($question->id == $destinationQuestion['id']) {
                $tenderOrderDestQuestion = $question;
            }
        }
        if (empty($tenderOrderDestQuestion)) {
            throw new Exception("Can't find destination question in tender order questionnaire");
        }

        return $tenderOrderDestQuestion->val;
    }


    // ------------------------------------------------------------------------------------- //
    // ------------------ Get Tender order by creaet date  ------------------------------------ //
    // ------------------------------------------------------------------------------------- //
    public function getOrdersForCertainDate($tender_id, $create_date_from)
    {

        $create_date_to =  date('Y-m-d', strtotime($create_date_from . "+1 days"));

        $sqlQuery = "SELECT 
                    t.id
                FROM
                    tender_order_view t,
                    activity a
                WHERE
                    t.tender_id = ?
                        AND a.tender_order_id = t.id
                        AND a.action_code = 'CREATE'
                        AND a.activity_date > ?
                        AND a.activity_date < ?";

        $param = [$tender_id, $create_date_from, $create_date_to];
        $data = DBConnection::runBindDatabaseQuery($sqlQuery, $param);

        $result = [];
        foreach ($data as $record) {
            $result[] = $record->id;
        }
        return $result;
    }



    // ---------------------------------------------------------------------------------------------- //
    // --------------- Get the financial manager user bean for certain truck ------------------------ //
    // ---------------------------------------------------------------------------------------------- //
    public function getFinancialManagerUserBean($truck_id, $tender_id, $user_id)
    {

        $truckOwnerCore = new TruckOwnerCore();
        $userCore = new UserCore();

        $activeTenderTruckStatus = DBConnection::getActiveStatus('tender_truck');
        $tenderFilter = [
            ['key' => 'truck_id', 'val' => $truck_id],
            ['key' => 'status', 'val' => $activeTenderTruckStatus, 'op' => 'in'],
            ['key' => 'tender_id', 'val' => $tender_id]
        ];
        $tenderTruck_qry = $this->searchTenderTruck($tenderFilter, 1, 0, $user_id);
        $tenderTruckBean = $tenderTruck_qry->data[0];
        $financial_details = json_decode($tenderTruckBean->financial_details);
        $financial_manager_owner_id = $tenderTruckBean->financial_manager_owner_id;

        $financialManagerBean = $truckOwnerCore->getTruckOwnerBasic($financial_manager_owner_id, $user_id);
        $userBean =  $userCore->getUserBasic($financialManagerBean->user_id, $user_id);

        return $userBean;
    }


    // ------------------------------------------------------------------------ //
    // -------------------search for tender pa using any search filter ----------- //
    // ------------------------------------------------------------------------ //
    public function searchPaTender($searchFilter, $limit, $offset, $user_id, $order_by = null)
    {
        $searchTenderResult = DBConnection::searchDB("tender_pa", $searchFilter, $limit, $offset, $user_id, $order_by);
        return $searchTenderResult;
    }


    // ------------------------------------------------------------------------ //
    // -------------------search for tender  MGPAY----------- //
    // ------------------------------------------------------------------------ //
    public function getMgPayTender()
    {
        $tenderFilter = [];
        $tenders = $this->searchTender($tenderFilter, 100, 0, 0);
        foreach ($tenders->data as $tender) {
            $man = json_decode($tender->manifest);
            if ($man->tender_code == "MG_PAY") {
                return $tender;
            }
        }
    }


    // -------------------------------------------------------------------------- //
    // ----------- Create New ticket for joining the MG Pay Project ------------- //
    // -------------------------------------------------------------------------- //
    public function createJoinMgPayTicket($tn, $liecence_photo_front, $user_id)
    {

        $truckOwnerCore = new TruckOwnerCore();

        // validate if the truck is for the user
        $truckFilter = [['key' => 'tn', 'val' => $tn]];
        $truck_result = $this->_truckCore->searchTrucks($truckFilter, 1, 0, $user_id);
        if ($truck_result->found_rows == 0) {
            throw new Exception("لا تستطيع المتابعة الشاحنة ليست ملكا لك");
            die;
        }

        // get MGPAY tender
        $tender_id = $this->getMgPayTender()->id;

        // check if the truck has already tender truck
        $tenderFilter = [
            ['key' => 'tn', 'val' => $tn],
            ['key' => 'status', 'val' => ['NEW', 'ACTIVE'], 'op' => 'in'],
            ['key' => 'tender_id', 'val' => $tender_id]
        ];
        $tenderTruck_qry = $this->searchTenderTruck($tenderFilter, 1, 0, 0);
        if ($tenderTruck_qry->found_rows > 0) {
            throw new Exception("الشاحنة مسجلة مسبقا على المشروع");
        }

        $truck_owner_id = $_SESSION['truck_owner_id'];
        $truck_ownerFilter = [['key' => 'id', 'val' => $truck_owner_id]];
        $truckOwnerBean =  $truckOwnerCore->searchTruckOwner($truck_ownerFilter, 1, 0, 0)->data[0];
        $truck_owner_name = $truckOwnerBean->name;
        $truck_owner_phone = $truckOwnerBean->phone;
        $truck_owner_nn = $truckOwnerBean->nn;

        $ticket = new stdClass();
        $ticket->title = "طلب انضمام لمشروع السلف";
        $ticket->senderName = "مدارج للخدمات اللوجستية";
        $ticket->type_code = "REUQEST_JOIN_MG_PAY";
        $ticket->priority = 3;
        $ticket->company_id = 266770;
        $ticket->type = "CLIENT";
        $ticket->body = [
            "tender_id" => $tender_id,
            "tn" => $tn,
            "liecence_photo_front" => $liecence_photo_front,
            "truck_owner_id" => $truck_owner_id,
            "truck_owner_name" => $truck_owner_name,
            "truck_owner_phone" => $truck_owner_phone,
            "truck_owner_nn" => $truck_owner_nn
        ];

        $this->_customerCare->createTicket($ticket);
    }
}
