<?php
require_once (dirname(__FILE__)."/../API.php");
require_once (dirname(__FILE__)."/../user/user_core.php");

class TC_representative_interface extends API{

    private $_request = array();

    public function __construct(){

        // call the super constructur
        $this->_request = parent::__construct();

        session_start();    
        if( !isset($_SESSION['user_id'])){
            throw new Exception('No Session!');
        }

        // init the object
        $this->_userCore = new UserCore();

        // process the incoming request
        $func = $this->_request->method;
        unset($this->_request->method);
        $this->$func();

    }

    // --------------------------------------------------------------------- //
    // ---------------- search for TC Representative ----------------------- //
    // --------------------------------------------------------------------- //
    public function searchTCRepresentative(){

        $sql = "SELECT 
                    u.id,
                    u.name,
                    CAST(u.photos AS CHAR CHARSET UTF8) AS photos,
                    u.phone,
                    ur.status
                FROM
                    user_view u,
                    user_role ur
                WHERE
                    ur.user_id = u.id
                        AND ur.role_code = 'TC_REPRESENTATIVE'";

        $result = DBConnection::runDatabaseQuery($sql);

        $Result=[];
        $Result['data'] = $result;
        $Result['found_rows'] = sizeof($result);
        parent::response($Result);
    }

    // --------------------------------------------------------------------- //
    // ---------------- get certain TC Representative ---------------------- //
    // --------------------------------------------------------------------- //
    public function getTCRepresentative(){

        $id = $this->_request->id;
        $sql = "SELECT 
                    u.id,
                    u.name,
                    CAST(u.photos AS CHAR CHARSET UTF8) AS photos,
                    u.phone,
                    ur.status,
                    u.nn,
                    u.civil_record,
                    u.nat_code,
                    JSON_UNQUOTE(JSON_EXTRACT(u.phone_array, '$[0].email')) email
                FROM
                    user u,
                    user_role ur
                WHERE
                    ur.user_id = u.id
                        AND ur.role_code = 'TC_REPRESENTATIVE'
                    AND u.id = ?";

        $result = DBConnection::runBindDatabaseQuery($sql , [$id]);

        parent::response($result);
    }

    // --------------------------------------------------------------------------------------- //
    // ---------------- activate or deactivatre tc_representative role  ---------------------- //
    // --------------------------------------------------------------------------------------- //
    public function changeStatus(){
 
        // get params
        $id = $this->_request->id;
        $new_status = $this->_request->new_status;

        if(!$new_status){
            throw new Exception("new_status is required");
        }
        if(!$id){
            throw new Exception("id is required");
        }

        // search for the required userRole in user role table
        $searchFilter = [['key' => 'user_id', 'val' => $id],
                         ['key' => 'role_code', 'val' => "TC_REPRESENTATIVE"]];
        $searchUserResult = DBConnection::searchDB("user_role", $searchFilter, 1, 0, $_SESSION['user_id']);

        // change the status to ACTIVE
        $updateStruct = new stdClass();
        $updateStruct->id = $searchUserResult->data[0]->id;
        $updateStruct->status = $new_status;
        DBConnection::updateDB("user_role", $updateStruct, $_SESSION['user_id']);

        //return Success reponse
        $Result = [];
        $Result['ERRORCODE'] = "0";
        $Result['MESSAGE'] = "WAYBILL.SUCCESS_OPERATION";
        parent::response($Result);
        
    }

}

new TC_representative_interface();