<?php
require_once (dirname(__FILE__)."/../../vendor/autoload.php");

use Google\Cloud\Tasks\V2\AppEngineHttpRequest;
use Google\Cloud\Tasks\V2\CloudTasksClient;
use Google\Cloud\Tasks\V2\HttpMethod;
use Google\Cloud\Tasks\V2\Task;

class TaskQueuesCore{

    private $projectId = "waybill";
    private $locationId = "us-central1";

 

    // ------------------------------------------------------------------------------------------------------------------- //
    // -------------- add new notification task to inform and reminder the user about waybill order ---------------------- //
    // ------------------------------------------------------------------------------------------------------------------- //
    public function addNotificationTask($id, $params){
        try {
            $data = array();
            if (isset($params)) {
                $data = ['id' => $id];
            }

            $task = new PushTask('/waybillOrderNotification', $data, $params);
            $queue = new PushQueue("waybillOrderNotification");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------------------------------------------------------------- //
    // ------------- create new task to change status of the queue upon activation date ----------------------- //
    // -------------------------------------------------------------------------------------------------------- //
    public function addDelayQueueTask($id, $params){
        try {
            $data = array();
            if (isset($params)) {
                $data = ['id' => $id];
            }

            $task = new PushTask('/queueDelayHandler', $data, $params);
            $queue = new PushQueue("delayQueue");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------------------------------------------------- //
    // ------------- create new task to push new activated container into the system for distribute ----------------------- //
    // -------------------------------------------------------------------------------------------------------------------- //
    public function pushContainerToTenderOrder($cargo_id, $tender_id, $ct_id){
        try {

            // queue task parameter
            $params = ["name" => $cargo_id . "_" . rand(), 'delay_seconds' => 5];

            //data
            $data = ["cargo_id" => $cargo_id, "tender_id" => $tender_id, "ct_id" => $ct_id];

            // create task
            $task = new PushTask('/pushContainerToTenderHandler', $data, $params);
            $queue = new PushQueue("containers");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ----------------------------------------------------------------------------------------------------------- //
    // ------------- create new task for waybill_order after the distribute (assign cargo) ----------------------- //
    // ----------------------------------------------------------------------------------------------------------- //
    public function creatWaybillOrderTask($tender_order_id, $cargo_id, $truck_owner_id, $queue_id, $tender_id){
        try {

            // queue task parameter
            $params = ["name" => $tender_order_id . "_" . $queue_id . "_" . $cargo_id . "_" . $truck_owner_id . "_" . rand(), 'delay_seconds' => 0];

            //data
            $data = ["order_id" => $tender_order_id,
                    "cargo_id" => $cargo_id,
                    "truck_owner_id" => $truck_owner_id,
                    "queue_id" => $queue_id,
                     "tender_id" => $tender_id];

            // create task
            $task = new PushTask('/createWaybillOrderHandler', $data, $params);
            $queue = new PushQueue("waybillorders");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------------------------ //
    // ------------- create new task to follow call result once it starts ----------------------- //
    // ------------------------------------------------------------------------------------------ //
    public function addFollowCallTask($waybill_order_id){
        try {

            // queue task parameter
            $params = ["name" => $waybill_order_id . "_follow_" . rand(), 'delay_seconds' => 0];

            //data
            $data = ["waybill_order_id" => $waybill_order_id];

            // create task
            $task = new PushTask('/followCallHandler', $data, $params);
            $queue = new PushQueue("followCalls");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }



    // ------------------------------------------------------------------------------------------ //
    // ------------- create new task to call the redistribute waybill order --------------------- //
    // ------------------------------------------------------------------------------------------ //
    public function addRedistributeWaybillOrderTask($tender_order_id){
        try {

            // queue task parameter
            $params = ["name" => $tender_order_id . "_redistribute_" . rand(), 'delay_seconds' => 0];

            //data
            $data = ["tender_order_id" => $tender_order_id];

            // create task
            $task = new PushTask('/RedistributeWaybillOrderHandler', $data, $params);
            $queue = new PushQueue("redistributeWaybillOrders");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------------------------- //
    // ------------- create new task to send mobile app 100 message per task----------------------- //
    // -------------------------------------------------------------------------------------------- //
    public function creatSystemNotificationTask($reg_ids,$payload){
        try {

            // queue task parameter
            $params = ["name" => "_message_" . rand(), 'delay_seconds' => 0];

            //data
            $data = ["reg_ids" => json_encode($reg_ids),
                     "payload" =>  json_encode($payload)];

            // create task
            $task = new PushTask('/sendNotificationMessageHandler', $data, $params);
            $queue = new PushQueue("systemMessages");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------------------------------- //
    // ------------- create a task to close the waybill after certain amount of time ------------------- //
    // ------------------------------------------------------------------------------------------------- //
    public function createCloseWaybillTask($id , $delay_in_hours , $remarks){

        try {

            // queue task parameter
            $delay_in_seconds = $delay_in_hours * 60 * 60;
            $params = ["name" => "close_waybill_" . $id . "_" . rand(), 'delay_seconds' => $delay_in_seconds];

            //data
            $data = ["id" => $id,
                     "remarks" => $remarks];

            // create task
            $task = new PushTask('/closeWaybillHandler', $data, $params);
            $queue = new PushQueue("closeWaybills");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // ------------------------------------------------------------------------------------------------- //
    // ------------- create a task to close the waybill after certain amount of time ------------------- //
    // ------------------------------------------------------------------------------------------------- //
        public function createUnfreezeQueueTask($queue_id, $delay_in_hours, $remarks)
    {

        try {

            // queue task parameter
            $delay_in_seconds = $delay_in_hours * 60 * 60;
                $params = ["name" => "unfreeze_truck_" . $queue_id . "_" . rand(), 'delay_seconds' => $delay_in_seconds];

            //data
            $data = [
                    "queue_id" => $queue_id,
                "remarks" => $remarks
            ];

            // create task
            $task = new PushTask('/unfreezeQueueHandler', $data, $params);
            $queue = new PushQueue("closeWaybills");
            $queue->addTasks([$task]);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------------------------------------- //
    // ------------- create a task to create number of waybill orders based on assign quota ------------------- //
    // -------------------------------------------------------------------------------------------------------- //
    public function createWaybillOrderForCompanyQuota($assign_cargo_id , $orders, $tender_company_id , $is_last_task = false){

        try {

            // queue task parameter
            $delay_in_seconds = 1;
            $params = ["name" => $tc_id . "_" . rand(), 'delay_seconds' => $delay_in_seconds];

            //data
            $data = ["assign_cargo_id" => $assign_cargo_id,
                "orders" => json_encode($orders),
                "tender_company_id" => $tender_company_id,
                     "is_last_task" => $is_last_task];

            // create task
            $task = new PushTask('/createWaybillOrderForCompaniesHandler', $data, $params);
            $queue = new PushQueue("companyWaybillOrders");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // --------------------------------------------------------------------------- //
    // ------------- create a task to new transfer Diesel task ------------------- //
    // --------------------------------------------------------------------------- //
    public function createTransferDieselTask($waybill_id, $payment_type, $trials=1 , $delay=1){

        try {
            // queue task parameter
            $params = ["name" => $waybill_id . "_" . $payment_type . "_" . $trials, 'delay_seconds' => $delay];

            //data
            $data = ["waybill_id" => $waybill_id,
                "payment_type" => $payment_type,
                        "trials" => $trials];

            // create task
            $task = new PushTask('/transferDieselHandler', $data, $params);
            $queue = new PushQueue("transferDiesil");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // --------------------------------------------------------------------------- //
    // ------------- create a task to manual transfer Diesel task ---------------- //
    // ------------- this queue is used for diesel recovery ---------------------- //
    // --------------------------------------------------------------------------- //
    public function createManualTransferDieselTask($waybill_id, $payment_type, $trials=1 , $delay=1){

        try {
            // queue task parameter
            $params = ["name" => $waybill_id . "_" . $payment_type . "_" . $trials, 'delay_seconds' => $delay];

            //data
            $data = ["waybill_id" => $waybill_id,
                "payment_type" => $payment_type,
                    "trials" => $trials];

            // create task
            $task = new PushTask('/transferDieselHandler', $data, $params);
            $queue = new PushQueue("transferDiesil-manual");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------------------------------------------------------- //
    // ------------- create a task to validate each trx with CBJ and complete the trx ------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function createCompleteZainCashTask( $voucher_id, $ref_id, $trial=1 , $delay=1 , $errorMessage=""){

        try {
            // queue task parameter
            $params = ["name" => $voucher_id . "_" . $ref_id . "_" . $trial, 'delay_seconds' => $delay];

            //data
            $data = [
                "voucher_id" => $voucher_id,
                "ref_id" => $ref_id,
                "trial" => $trial,
                     "errorMessage" => $errorMessage];

            // create task
            $task = new PushTask('/completeZainCashTrxHandler', $data, $params);
            $queue = new PushQueue("completeZainCashTrx");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // --------------------------------------------------------------------------------- //
    // ------------- create a task to insert waybill into "" System -------------------- //
    // --------------------------------------------------------------------------------- //
    public function createInsertGrainsWaybillTask( $waybill_id, $trial=1 , $delay=1, $errorMessage = ""){

        try {
            // queue task parameter
            $params = ["name" => $waybill_id . "_" . $trial . "_" . rand(), 'delay_seconds' => $delay];

            //data
            $data = [
                "waybill_id" => $waybill_id,
                "trial" => $trial,
                "errorMessage" => $errorMessage
            ];

            // create task
            $task = new PushTask('/insertGrainsWaybillHandler', $data, $params);
            $queue = new PushQueue("grainsWaybills");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // --------------------------------------------------------------------------------------- //
    // ------------- create a task to get waybill info from grains System -------------------- //
    // --------------------------------------------------------------------------------------- //
    public function createGetGrainsWaybillInfoTask( $waybill_id, $trial=1 , $delay=1, $errorMessage = ""){

        try {
            // queue task parameter
            $params = ["name" => "getInfo" . "_" . $waybill_id . "_" . $trial . "_" . rand(), 'delay_seconds' => $delay];

            //data
            $data = [
                "waybill_id" => $waybill_id,
                "trial" => $trial,
                "errorMessage" => $errorMessage
            ];

            // create task
            $task = new PushTask('/getGrainsWaybillInfoHandler', $data, $params);
            $queue = new PushQueue("grainsWaybills");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------------------------------- //
    // ------------- create a task to validate each trx with CBJ and complete the trx ------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function createPostOnWallTask( $user_id, $body, $notification_title, $writeOnWall=true, $trial=1 , $refreshApp=false){

        try {


            $data = [
                "user_id" => $user_id,
                "notification_title" => $notification_title,
                "writeOnWall" => $writeOnWall,
                "refreshApp" => $refreshApp,
                "trial" => $trial,
                "body" => $body];
 
                putenv('GOOGLE_APPLICATION_CREDENTIALS=' . __DIR__ . '/waybill-cred.json');

                // Instantiate the client and queue name.
                $queueId = "wallMessages";
                $client = new CloudTasksClient();
                $queueName = $client->queueName($this->projectId, $this->locationId, $queueId);

                $httpRequest = new AppEngineHttpRequest();
                $httpRequest->setRelativeUri('/createWallPostHandler');
                $httpRequest->setHttpMethod(HttpMethod::POST);
                $httpRequest->setBody(json_encode($data));
 
                // Create a Cloud Task object.
                $task = new Task();
                $task->setName($user_id . "_" . $trial . "_" . rand() );
                $task->setAppEngineHttpRequest($httpRequest);
                //$task->setScheduleTime("1000");

  
                $response = $client->createTask($queueName, $task);


        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------------------------------- //
    // ------------- create a task to validate each trx with CBJ and complete the trx ------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function createAppendRecipientToPollTask($poll_id, $nn , $bind_params){

        try {
            // queue task parameter
            $params = ["name" => $poll_id . "_" . $nn . "_" . rand(), 'delay_seconds' => 1];

            //data
            $data = [
                "poll_id" => $poll_id,
                "nn" => $nn,
                "bind_params" => $bind_params];

            // create task
            $task = new PushTask('/appendRecipientToPollHandler', $data, $params);
            $queue = new PushQueue("chechUserWallet");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------------------------------------------------------- //
    // ------------- create a task to validate each trx with CBJ and complete the trx ------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function createAppendRecipientToTipsTask( $has_poll_id, $has_no_poll_id,
                                                     $nn,  $from_account, $amount,
                                                     $tender_id,$wallet_id, $notes,
                                                     $bind_params){

        try {
            // queue task parameter
            $params = ["name" => $has_poll_id . "_" . $has_no_poll_id . "_" . $nn . "_" . rand(), 'delay_seconds' => 1];

            //data
            $data = [
                "has_poll_id" => $has_poll_id,
                "has_no_poll_id" => $has_no_poll_id,
                "nn" => $nn,
                "from_account" => $from_account,
                "amount" => $amount,
                "tender_id" => $tender_id,
                "wallet_id" => $wallet_id,
                "notes" => $notes,
                "bind_params" => $bind_params];

            // create task
            $task = new PushTask('/createappendRecipientHandler', $data, $params);
            $queue = new PushQueue("chechUserWallet");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------------------------------- //
    // ------------- create a task to validate each trx with CBJ and complete the trx ------------------- //
    // -------------------------------------------------------------------------------------------------- //
        public function createTenderClaimVoucher( $tender_claim_id,$voucher_id,$from_account,
                                                  $from_account_name,$target_account,$target_account_name,
                                                  $amount,$status,$waybill_ref,$user_id,$u_id,$uuid, $errorMessage=null){

        try {
            // queue task parameter
            $params = ["name" => "voucher_" . $tender_claim_id . "_" . $voucher_id . "_" . rand(), 'delay_seconds' => 0];

            //data
            $data = [
                "tender_claim_id" => $tender_claim_id,
                "voucher_id" => $voucher_id,
                "from_account" => $from_account,
                "from_account_name" => $from_account_name,
                "target_account" => $target_account,
                "target_account_name" => $target_account_name,
                "amount" => $amount,
                "status" => $status,
                "waybill_ref" => $waybill_ref,
                "user_id" => $user_id,
                "u_id" => $u_id,
                "uuid" => $uuid
            ];

            // create task
            $task = new PushTask('/createTenderClaimVoucherHandler', $data, $params);
            $queue = new PushQueue("tenderClaimPushItem");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------------------------------- //
    // ------------- create a task to validate each trx with CBJ and complete the trx ------------------- //
    // -------------------------------------------------------------------------------------------------- //
            public function createTenderClaimWaybill( $tender_claim_id, $waybill_info,$user_id,$uuid,$errorMessage=null){

        try {
            // queue task parameter
            $params = ["name" => "waybill_" . $tender_claim_id . "_" . $waybill_info->waybill_id . "_" . rand(), 'delay_seconds' => 0];

            //data
            $data = [
                "tender_claim_id" => $tender_claim_id,
                "waybill_id" => $waybill_info->waybill_id,
                "claim_loading_date" => $waybill_info->claim_loading_date,
                "claim_discharge_date" => $waybill_info->claim_discharge_date,
                "claim_loading_weight" => $waybill_info->claim_loading_weight,
                "claim_discharge_weight" => $waybill_info->claim_discharge_weight,
                "ref_num" => $waybill_info->ref_num,
                "claim_amount" => $waybill_info->claim_amount,
                "user_id" => $user_id,
                "errorMessage" => $errorMessage,
                "uuid" => $uuid
            ];

            // create task
            $task = new PushTask('/createTenderClaimWaybillHandler', $data, $params);
            $queue = new PushQueue("tenderClaimPushItem");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------------------------------- //
    // ------------- create a task to validate each trx with CBJ and complete the trx ------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function createCheckUserWalletTask($ref_id,$phone, $poll_id=null,$trial=1 , $delay=1 , $errorMessage=""){

        try {
            $phone = str_replace("+", "", $phone);

            // queue task parameter
            $delay_in_seconds = 1;
            $params = ["name" => $ref_id . "_" . $phone . "_" . $trial . "_" . rand(), 'delay_seconds' => $delay];

            //data
            $data = [
                "ref_id" => $ref_id,
                "trial" => $trial,
                "phone" => $phone,
                "poll_id" => $poll_id,
                     "errorMessage" => $errorMessage];

            // create task
            $task = new PushTask('/checkUserWalletHandler', $data, $params);
            $queue = new PushQueue("chechUserWallet");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }

    // -------------------------------------------------------------------------------------------------- //
    // ------------- create a task to validate each trx with CBJ and complete the trx ------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function createOneFillsTask($phone , $poll_id=null){

        try {
            $name_phone = str_replace("+", "", $phone);

            // queue task parameter
            $delay = 1;
            $params = ["name" => "transfer_fills_" . $name_phone . "_" . rand(), 'delay_seconds' => $delay];

            //data
            $data = ["user_phone" => $phone, "poll_id" => $poll_id];

            // create task
            $task = new PushTask('/transferOneFillsHandler', $data, $params);
            $queue = new PushQueue("chechUserWallet");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------------------------------- //
    // ------------- create a task to activate tender truck after 2 days ------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function creteActivatTenderTruckTask($tender_truck_id){

        try {
            // queue task parameter
            $delay_in_seconds = 48 * 60 * 60;
            $params = ["name" => "activatTruckContract" . "_" . $tender_truck_id . "_" . rand(), 'delay_seconds' => $delay_in_seconds];

            //data
            $data = [
                'tender_truck_id' => $tender_truck_id
            ];

            // create task
            $task = new PushTask('/activateTenderTruckContractHandler', $data, $params);
            $queue = new PushQueue("activateTenderTruckContract");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


 // -------------------------------------------------------------------------------------------------- //
    // ------------- create a task for submitted tender claim items ----------------- ------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function createTenderClaimItemsProcessTask($tender_claim_id,$tender_claim_item_id,$waybill_id,
                                               $start_proccess_flag,$approve_tender_claim_flag,$user_id){

        try{
            // queue task parameter
            $params = ["name" => "tender_claim_" . $tender_claim_id . "_" . $tender_claim_item_id . "_" . rand() , 'delay_seconds' => 0];

            //data
            $data = [
                     'tender_claim_id'=>$tender_claim_id,
                     'tender_claim_item_id'=>$tender_claim_item_id,
                     'waybill_id'=>$waybill_id,
                     'start_proccess_flag'=>$start_proccess_flag,
                     'approve_tender_claim_flag'=>$approve_tender_claim_flag,
                     'user_id'=>$user_id
                    ];

            // create task
            $task = new PushTask('/processTenderClaim', $data, $params);
            $queue = new PushQueue("processTenderClaim");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    /**
     * Creates GCP Cloud Task for objects watchers
     * @param string $taskName short task name
     * @param array $taskRequestPayload AppEngine request payload
     * @param int $delayInSeconds Task execution delay
     * @throws Exception
     * @todo create queue and handler
     */
    public function createWatcherTask($taskName, $taskRequestPayload, $delayInSeconds){
        try {
            // queue task parameter
            $params = ["name" => $taskName, 'delay_seconds' => $delayInSeconds];

            // add method
            $taskRequestPayload['method'] = 'handleWatcher';

            // create task
            $task = new PushTask('/objectWatcherHandler', $taskRequestPayload, $params);
            $queue = new PushQueue("objectWatchers");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------------------------------- //
    // ------------- create a task create a ticket ------------------------------------------------------ //
    // -------------------------------------------------------------------------------------------------- //
    public function createTicketTask($taskData, $delay, $title){

        try {
            // queue task parameter
            $params = ["name" => "createTicket-$title-" . uniqid(), 'delay_seconds' => $delay];

            //data
            $data = ['data' => $taskData];

            // create task
            $task = new PushTask('/createTicketHandler', $data, $params);
            $queue = new PushQueue("objectWatchers");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------------------------------- //
    // ------------- create a task create a ticket ------------------------------------------------------ //
    // -------------------------------------------------------------------------------------------------- //
    public function createApproveClaimWaybillTask($waybill , $tender_claim_id,$lastTask){

        try{
            // queue task parameter
            $delay_in_seconds = 1;
            $params = ["name" => "waybill" . "_" .$waybill->wn . "_claim_". $tender_claim_id. "_" . rand() , 'delay_seconds' => $delay_in_seconds];

            //data
            $data = [
                     'tender_claim_id'=>$tender_claim_id,
                     'waybill_id'=>$waybill->waybill_id,
                     'claim_loading_weight' => $waybill->claim_loading_weight,
                     'claim_loading_date' => $waybill->claim_loading_date,
                     'claim_discharge_weight' => $waybill->claim_discharge_weight,
                     'claim_discharge_date' => $waybill->claim_discharge_date,
                     'discharge_weight' => $waybill->discharge_weight,
                     'tender_claim_item_id'=> $waybill->id,
                     "is_last_task"=>$lastTask
                    ];
            // create task
            $task = new PushTask('/approveClaimWaybillInfo', $data, $params);
            $queue = new PushQueue("approveClaims");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }

    }

    // -------------------------------------------------------------------------------------------------- //
    // ------------- create a task create a ticket ------------------------------------------------------ //
    // -------------------------------------------------------------------------------------------------- //
    public function createApproveARClaimWaybillTask($waybill , $tender_claim_id){

        try{
            // queue task parameter
            $delay_in_seconds = 1;
            $params = ["name" => "waybill" . "_" .$waybill->wn . "_claim_". $tender_claim_id. "_" . rand() , 'delay_seconds' => $delay_in_seconds];

            //data
            $data = [
                     'tender_claim_id'=>$tender_claim_id,
                     'waybill_id'=>$waybill->waybill_id,
                     'tender_claim_item_id'=> $waybill->previous_item_id
                    ];

            // create task
            $task = new PushTask('/approveARClaimWaybillInfo', $data, $params);
            $queue = new PushQueue("approveClaims");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }

    }

      // -------------------------------------------------------------------------------------------------- //
    // ------------- create a task create a ticket ------------------------------------------------------ //
    // -------------------------------------------------------------------------------------------------- //
    public function createFailureLogTenderClaimARItemTrx(
                                                       $tender_claim_id ,
                                                       $waybill_id,
                                                       $tender_claim_item_id,
                                                       $error_message
                                                       ){

        try{
            // queue task parameter
            $delay_in_seconds = 0;
            $params = ["name" => "waybill_ar_logtrx_fail" . "_" .  $tender_claim_item_id ."_" . rand() , 'delay_seconds' => $delay_in_seconds];

            //data
            $data = [
                     'tender_claim_id'=>$tender_claim_id,
                     'waybill_id'=>$waybill_id,
                     'error_message'=>$error_message,
                     'tender_claim_item_id'=> $tender_claim_item_id,
            ];

            // create task
            $task = new PushTask('/failureLogTenderClaimARItemTrx', $data, $params);
            $queue = new PushQueue("failedTenderClaimItems");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }

    }


    // -------------------------------------------------------------------------------------------------- //
    // ------------- create a task create a ticket ------------------------------------------------------ //
    // -------------------------------------------------------------------------------------------------- //
    public function createFailureLogTenderClaimItemTrx($tender_claim_id ,
                                                       $waybill_id,$claim_loading_weight,$claim_loading_date,
                                                       $claim_discharge_weight,$claim_discharge_date,$discharge_weight,
                                                       $tender_claim_item_id,$is_last_task, $error_message
                                                       ){

        try{
            // queue task parameter
            $delay_in_seconds = 0;
            $params = ["name" => "waybill_logtrx_fail" . "_" .  $tender_claim_item_id ."_" . rand() , 'delay_seconds' => $delay_in_seconds];

            //data
            $data = [
                     'tender_claim_id'=>$tender_claim_id,
                     'waybill_id'=>$waybill_id,
                     'claim_loading_weight' => $claim_loading_weight,
                     'claim_loading_date' => $claim_loading_date,
                     'claim_discharge_weight' => $claim_discharge_weight,
                     'claim_discharge_date' => $claim_discharge_date,
                     'discharge_weight' => $discharge_weight,
                     'tender_claim_item_id'=> $tender_claim_item_id,
                     "is_last_task"=>$is_last_task,
                     "error_message" => $error_message
            ];

            // create task
            $task = new PushTask('/approveClaimWaybillInfo', $data, $params);
            $queue = new PushQueue("failedTenderClaimItems");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }

    }

    // -------------------------------------------------------------------------------------------------- //
    // ------------- create a task to validate each trx with CBJ and complete the trx ------------------- //
    // -------------------------------------------------------------------------------------------------- //
    public function addItemToTenderClaimTask($ref_id,$tender_claim_id,$user_id,$u_id){

        try {
            // queue task parameter
            $delay_in_seconds = 0;
            $params = ["name" => "addItemToTenderClaimTask" . "_" . $ref_id . "_" . rand(), 'delay_seconds' => $delay_in_seconds];

            //data
            $data = [
                "ref_id" => $ref_id,
                "tender_claim_id" => $tender_claim_id,
                'user_id' => $user_id,
                'u_id' => $u_id
            ];

            // create task
            $task = new PushTask('/addItemToTenderClaim', $data, $params);
            $queue = new PushQueue("tenderClaimPushBulkItem");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // -------------------------------------------------------------------------- //
    // ------------- create a task to fix diesel card balance ------------------- //
    // -------------------------------------------------------------------------- //
    public function fixDieselCardBalanceTask($tn, $error_message){

        try{
            // queue task parameter
            $delay_in_seconds = 0;
            $params = ["name" => "fixDieselCardBalanceTask" . "_" .$tn . "_" . rand(), 'delay_seconds' => $delay_in_seconds];

            //data
            $data = [
                     "tn" => $tn,
                     "error_message" => $error_message
                    ];

            // create task
            $task = new PushTask('/fixDieselCardBalanceHandler', $data, $params);
            $queue = new PushQueue("fixDieselCardBalance");
            $queue->addTasks([$task]);

        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ----------------------------------------------------------------------------------------------------------------- //
    // ------------- create a task to unfreeze tender truck of duplicate loads truck after 48 hours  ------------------- //
    // ----------------------------------------------------------------------------------------------------------------- //
    public function unfreezeDuplicatedLoadersQueue($tender_truck_id)
    {
        try {
            // queue task parameter
            $delay_in_seconds = 48 * 60 * 60;
            $params = [
                "name" => "removeDriverFromFreezeListTask" . "_" . $tender_truck_id . "_" . rand(),
                'delay_seconds' => $delay_in_seconds

            ];

            //data
                $data = ['tender_truck_id' => $tender_truck_id , "method" => 'unfreezeTenderTruck'];

            // create task
                $task = new PushTask('/jobs', $data, $params);
                $queue = new PushQueue('tenderTruckUnfreeze');
            $queue->addTasks([$task]);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ----------------------------------------------------------------------------------------------------------------- //
    // ------------- create a task to unfreeze tender truck of duplicate loads truck after 48 hours  ------------------- //
    // ----------------------------------------------------------------------------------------------------------------- //
    public function createSendEmailTask($email_title, $email_text, $email)
    {
        try {
            // queue task parameter
            $delay_in_seconds = 0;
            $params = [
                "name" => "send_email" . "_" . rand(),
                'delay_seconds' => $delay_in_seconds
            ];

            //data
            $data = ['email_title' => $email_title , 'email_text' => $email_text, 'email' => $email, 'method' => "send_email"];

            // create task
            $task = new PushTask('/jobs', $data, $params);
            $queue = new PushQueue('sendEmails');
            $queue->addTasks([$task]);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }



    // ------------------------------------------------------------------------------- //
    // ------------- create a task to generate poll of downpayment ------------------- //
    // ------------------------------------------------------------------------------- //
    public function createDownpaymentPollTask($w_id, $delay_in_seconds=0)
    {
        try {
            // queue task parameter
            $params = [
                "name" => "create_poll" . "_" . $w_id . "_" . rand(),
                'delay_seconds' => $delay_in_seconds
            ];

            //data
            $data = ['w_id' => $w_id ,  'method' => "generateDownPaymentPoll"];

            // create task
            $task = new PushTask('/poll', $data, $params);
            $queue = new PushQueue('downpaymentPolls');
            $queue->addTasks([$task]);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------------- //
    // ------------- create a task to generate poll of downpayment ------------------- //
    // ------------------------------------------------------------------------------- //
    public function createProcessDownpaymentPollAnswerTask($poll_id, $recipient_user_id ,$u_id,  $delay_in_seconds=0)
    {
        try {
            // queue task parameter
            $params = [
                "name" => "answer_poll" . "_" . $poll_id . "_" . rand(),
                'delay_seconds' => $delay_in_seconds
            ];

            //data
            $data = ['poll_id' => $poll_id ,
                     'recipient_user_id' => $recipient_user_id,
                     'u_id' => $u_id,
                     'method' => "processDownpaymentPollAnswer"];

            // create task
            $task = new PushTask('/fps_voucher', $data, $params);
            $queue = new PushQueue('downpaymentAnswers');
            $queue->addTasks([$task]);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ----------------------------------------------------------------------------------------------------- //
    // ------------- create a task to send reminder to user in case of downpayment poll  ------------------- //
    // ----------------------------------------------------------------------------------------------------- //
    public function createDownpaymentPollReminderTask($attempts, $user_id, $poll_id , $delay_in_seconds=0)
    {
        try {
            // queue task parameter
            $params = [
                "name" => "send_reminder" . "_" . $user_id . "_" . rand(),
                'delay_seconds' => $delay_in_seconds
            ];

            //data
            $data = ['attempts' => $attempts , 'user_id' => $user_id, 'poll_id' => $poll_id, 'method' => "sendDownPaymentPollReminder"];

            // create task
            $task = new PushTask('/jobs', $data, $params);
            $queue = new PushQueue('downpaymentReminder');
            $queue->addTasks([$task]);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }



    // ------------------------------------------------------------------------------------------------------------------- //
    // ------------- create a task to be reviewd by it support in case of downpayment poll answer fail ------------------- //
    // ------------------------------------------------------------------------------------------------------------------- //
    public function createDownpaymentPollFailAnswerTask($poll_id, $message , $delay_in_seconds , $request)

    {
        try {
            // queue task parameter
            $params = [
                "name" => "poll" . "_" . $poll_id . "_" . rand(),
                'delay_seconds' => $delay_in_seconds
            ];

            //data
            // $data = ['poll_id' => $poll_id , 'message' => $message];
            $data = json_decode(json_encode($request), true);
            $data['error'] = $message;

            // create task
            $task = new PushTask('/jobs', $data, $params);
            $queue = new PushQueue('downpaymentFailure');
            $queue->addTasks([$task]);
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }
    }


    // ------------------------------------------------------------------------ //
    // ------------- create a task to be run by robot agent ------------------- //
    // ------------------------------------------------------------------------ //
    public function createRobotTask($method_name, $param, $delay_in_seconds)
    {

        if ($method_name == "submitLtrcCrudeOilWaybill") {

            // queue task parameter
            $params = [
                "name" => "robot" . "_submit_Ltrc_CrudeOil_" . $param->waybill_id . "_". rand(),
                'delay_seconds' => $delay_in_seconds
            ];

            // map exceptions tc_id with ltrc id
            if($param->tc_id == 1999){
                $param->tc_id = 307;
            }
            if($param->tc_id == 1996){
                $param->tc_id = 57;
            }
            if($param->tc_id == 1995){
                $param->tc_id = 285;
            }
            if($param->tc_id == 1993){
                $param->tc_id = 54;
            }

            //data
            $data = [
                'tn' => $param->tn,
                'trn' => $param->trn,
                'driver_nn' => $param->driver_nn,
                'tc_id' => $param->tc_id,
                'waybill_id' => $param->waybill_id,
                'method' => "submitLtrcCrudeOilWaybill"
            ];
        }

        // create task
        $task = new PushTask('/jobs_task', $data, $params);
        $queue = new PushQueue('robotTasksQueue');
        $queue->addTasks([$task]);
    }
}
