<?php
ini_set('display_errors', 'On');

require_once dirname(__FILE__) . "/../../../includes/debug.php";
require_once dirname(__FILE__) . "/../../../includes/DBConnection.php";
require_once dirname(__FILE__) . "/../../waybill_order/waybill_order_core.php";
require_once dirname(__FILE__) . "/../../tender/tender_core.php";
require_once dirname(__FILE__) . "/../../user/user_core.php";
require_once dirname(__FILE__) . "/../../taskQueues/taskQueues_core.php";

$_waybillOrderCore = new WaybillOrderCore();
$_tenderCore = new TenderCore();
$_taskQueuesCore = new TaskQueuesCore();
$_userCore = new UserCore();


$filter = array();

$id = $_POST["id"];
if(!$id){
    $id = $_GET["id"];
}

$tempArr = ['key' => "id", 'val' => $id];
array_push($filter, $tempArr);
$waybillOrderResult = $_waybillOrderCore->searchWaybillOrder($filter, 1, 0, 0);
$waybillOrder = $waybillOrderResult->data[0];



if ($waybillOrder->status == "NEW") {
    $waybillOrder = $_waybillOrderCore->calculateTimer($waybillOrder);
    $timer = $waybillOrder->timer;

    if ($timer == 0 || $timer == null) {
        // cancel notification
        $_waybillOrderCore->cancelWaybillOrderNotification($id);
        $_tenderCore->createCallTicket($id);

    } else {
        $cancel_sticky_notification = false;
        $_waybillOrderCore->cancelWaybillOrderNotification($id, $cancel_sticky_notification);

        $user_id = $_waybillOrderCore->getWaybillOrderDefaultContact($id);

        $timer = $timer / 60000;
        if ($timer <= 10 && $timer >= 9) {
            $_waybillOrderCore->sendWaybillOrderNotification($user_id, $id, 'cancel_alarm');
            $_waybillOrderCore->sendWaybillOrderNotification($user_id, $id, 'play_alarm');
            $_waybillOrderCore->sendWaybillOrderNotification($user_id, $id, 'set_notification');
            $_waybillOrderCore->sendWaybillOrderNotification($user_id, $id, 'check_waybill_order');

        } else if ($timer <= 5 && $timer >= 4) {
            $_waybillOrderCore->sendWaybillOrderNotification($user_id, $id, 'cancel_ringtone');
            $_waybillOrderCore->sendWaybillOrderNotification($user_id, $id, 'play_ringtone');
            $_waybillOrderCore->sendWaybillOrderNotification($user_id, $id, 'set_notification');
            $_waybillOrderCore->sendWaybillOrderNotification($user_id, $id, 'check_waybill_order');

        } else if ($timer <= 2 && $timer > 1) {
            $_waybillOrderCore->sendWaybillOrderNotification($user_id, $id, 'set_notification');
            $_waybillOrderCore->sendWaybillOrderNotification($user_id, $id, 'check_waybill_order');

        } else if ($timer <= 1) {
            // push the waybill order on the callcener system in order to call him
            $_tenderCore->createCallTicket($id);
        }
        else {
            $_waybillOrderCore->sendWaybillOrderNotification($user_id, $id, 'set_notification');
            $_waybillOrderCore->sendWaybillOrderNotification($user_id, $id, 'check_waybill_order');
            $_waybillOrderCore->sendWaybillOrderNotification($user_id, $id, 'cancel_ringtone');
            $_waybillOrderCore->sendWaybillOrderNotification($user_id, $id, 'cancel_alarm');
        }


        $_taskQueuesCore->addNotificationTask($id, ['delay_seconds' => 60, "name" => $id . "_" . ($timer * 60000)]);

    }
}