<?php
// ----------------------------------------------------------- //
// -------------  check if user has e wallet ----------------- //
// ----------------------------------------------------------- //
ini_set('display_errors', 'On');

// import 
require_once dirname(__FILE__) . "/../../../includes/DBConnection.php";
require_once dirname(__FILE__) . "/../../../includes/util.php";
require_once dirname(__FILE__) . "/../../user/user_core.php";
require_once dirname(__FILE__) . "/../../outgoing_integration/zain_cash.php";
require_once dirname(__FILE__) . "/../../taskQueues/taskQueues_core.php";

// init
$userCore = new userCore();
$zain_cash = new Zain_Cash();
$taskQueuesCore = new TaskQueuesCore();

// get params from request
$user_phone = $_POST['user_phone'];
$poll_id = $_POST['poll_id'];

if(!$user_phone ){
$user_phone = $_GET['user_phone'];
}

// search for user
$user_phone = convertToInternational($user_phone) ;

// check if user has wallet record in zain cash database
$result = $zain_cash->getUserWallet($user_phone);

// if user has active record , then do nothing
if(array_key_exists("STATUS", $result)) {
    if($result['STATUS'] == "ACTIVE" ){
        throw new Exception("user already has active wallet");
        die;
    }
}
 
// transfer 1 fills
$result = $zain_cash->transferOneFills($user_phone);

if(array_key_exists('REF_ID',$result)){
    //create task to check
    $trial = 1;
    $errorMessage = "";
    $ref_id = $result['REF_ID'];
    $user_phone = str_replace("+","",$user_phone);
    $taskQueuesCore->createCheckUserWalletTask($ref_id , $user_phone , $poll_id , $trial , 60 , $errorMessage);
}
    
