<?php
ini_set('display_errors', 'On');
require_once dirname(__FILE__) . "/../../waybill/waybill_core.php";
require_once dirname(__FILE__) . "/../../outgoing_integration/Jo_Petrol.php";
require_once dirname(__FILE__) . "/../../taskQueues/taskQueues_core.php";
require_once dirname(__FILE__) . "/../../social/social_core.php";
require_once dirname(__FILE__) . "/../../driver/driver_core.php";


// init objects
$waybillCore = new WaybillCore();
$jo_petrol_integration = new Jo_Petrol();
$taskQueuesCore = new TaskQueuesCore();
$socialCore = new SocialCore();
$driverCore = new DriverCore();

// get params from request
$waybill_id = $_GET['waybill_id'];
$payment_type = $_GET['payment_type'];
$trials = $_GET['trials'];

try {

    // get waybillBean
    $waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);
    $tn = $waybillBean->document->carrier[0]->truck->tn;

    // get all the waybills on tender_id = 11 and not revoked or Inactive
    $waybillFilter = [
        ['key' => 'tender_id', 'val' => 11],
        ['key' => 'status', 'val' => ['INACTIVE', 'REVOKED'], 'op' => 'not in'],
        ['key' => 'tn', 'val' => $tn]
    ];

    $waybillResult = $waybillCore->searchWaybills($waybillFilter, 10000, 0, 0);

    // loop on each waybill to caluclate the amount that must be for the truck
    $total_diesel_amount = 0;
    foreach ($waybillResult->data as $wbl) {
        // calculate diesel amount of each waybill
        $diesel_amount = $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_PRE_LOAD') +
                         $jo_petrol_integration->getDieselPayment($wbl->id, 'DEISIL_POST_LOAD');
        $total_diesel_amount += doubleval($diesel_amount);
    }

    // get the truck card balance
    $cardBalanceArr = $jo_petrol_integration->checkCardBalance($tn);
    $cardBalance = $cardBalanceArr['currentLimit'];

    // if the card balance is less than total_diesel_amount
    if ($cardBalance < $total_diesel_amount) {

        // then transfer diesel
        $payment_amount = $total_diesel_amount - $cardBalance;
        $result = $jo_petrol_integration->transferDeisil($tn, $payment_amount);

        // update the payment to add the timestamp
        $freight = $waybillBean->document->freight;
        $payments = $freight->payments;
        foreach ($payments as &$payment) {
            if (strtoupper($payment->name) == strtoupper($payment_type)) {
                unset($payment->status);
                $payment->time_stamp = DBConnection::getSystemDate();
                $payment->value->amount = $payment_amount;
            }
        }
        $waybillBean->document->freight = $freight;
        $waybillCore->updateWaybill($waybillBean, $waybill_id, 0);

        // log into waybill
        $waybillCore->logActivity(
            $waybill_id,
            "تعبئة ديزل",
            "تم تعبئة " . $result['addValue'] . " دينار ديزل للشاحنة ليصبح سقف الرصيد " . $result['newLimit'],
            "WAYBILL_PAYMENT",
            0
        );

        // send notification
        try {
            $sender_id = 266770;
            $sender_name =  "شركة مدارج للخدمات اللوجستية ";
            $body = $socialCore->createPostBody(
                "تعبئة ديزل",
                "تمت تعبئة " . $result['addValue'] . " دينار في بطاقة الديزل للشاحنة " . $waybillBean->tn,
                null,
                $sender_id,
                $sender_name
            );

            $driverFilter = [['key' => 'id', 'val' => $waybillBean->driver_id]];
            $driver_qry = $driverCore->searchDriver($driverFilter, 1, 0, 0);
            $taskQueuesCore->createPostOnWallTask($driver_qry->data[0]->user_id, $body, "تعبئة ديزل");
        } catch (Exception $e) {
            $wall_message = $e->getMessage();
            $notification_message = "خطأ في التلبيغ";
            $socialCore->informSupervisor('خطأ', $wall_message, $notification_message, '2');
        }
    }
} catch (Exception $e) {

    if ($trials >= 20) {
        $waybillCore->logActivity(
            $waybill_id,
            "خطأ تعبئة ديزل",
            "خطأ تعبئة ديزل " . $e->getMessage(),
            "WAYBILL_PAYMENT",
            0
        );

        // push new recovery task on queue, this task needs manual inspection
        $taskQueuesCore->createManualTransferDieselTask($waybill_id, $payment_type, 1, 300);

        //send notification
        try {
            $sender_id = 266770;
            $sender_name =  "شركة مدارج للخدمات اللوجستية ";
            $body = $socialCore->createPostBody(
                "خطأ في تعبئة رصيد الديزل",
                "لم يتمكن النظام من تحويل رصيد الديزل للشاحنة رقم " . $waybillBean->tn . " بسبب عدم وجود بطاقة ديزل فعالة",
                null,
                $sender_id,
                $sender_name
            );

            $driverFilter = [['key' => 'id', 'val' => $waybillBean->driver_id]];
            $driver_qry = $driverCore->searchDriver($driverFilter, 1, 0, 0);
            $taskQueuesCore->createPostOnWallTask($driver_qry->data[0]->user_id, $body, "خطأ في تعبئة رصيد الديزل");
        } catch (Exception $e) {
            $wall_message = $e->getMessage();
            $notification_message = "2 خطأ في التلبيغ";
            $socialCore->informSupervisor('خطأ', $wall_message, $notification_message, '2');
        }
    } else {
        $trials += 1;
        $taskQueuesCore->createTransferDieselTask($waybill_id, $payment_type, $trials, 300);

        if ($trials == 5) {
            $socialCore = new SocialCore();
            $wall_message = $e->getMessage() . " - الشاحنة رقم:" . $tn;
            $notification_message = "خطأ في شحن بطاقة الديزل";
            $socialCore->informSupervisor('خطأ', $wall_message, $notification_message, '2');
        }
    }
}
