<?php
// ------------------------------------------------------------------------------------------------ //
// --------------- add the newly activated container to a tender order ---------------------------- //
// --------------- or push it to an open tender_order ------------------------------------------------ //
// ------------------------------------------------------------------------------------------------ //
ini_set('display_errors', 'On');

require_once dirname(__FILE__) . "/../../../includes/debug.php";
require_once dirname(__FILE__) . "/../../../includes/DBConnection.php";
require_once dirname(__FILE__) . "/../../tender/tender_core.php";
require_once dirname(__FILE__) . "/../../cargo/cargo_core.php";
require_once dirname(__FILE__) . "/../../social/social_core.php";

try{
    // init required objects
    $tenderCore = new TenderCore();
    $cargoCore = new CargoCore();

    // get the params
    $tender_id = $_POST['tender_id'];
    $ct_id = $_POST['ct_id'];
    $cargo_id = $_POST['cargo_id'];

    // get tender manifest
    $tenderBean = $tenderCore->getTenderBasic($tender_id, 0);
    $tenderManifest = $tenderBean->manifest;

    // loop on queues , in case the cargo filter for queue match cargo ct_id
    foreach ($tenderManifest->queues as $queue) {
        $hasSameCtid = false;
        foreach ($queue->cargo_filter as $ct) {
            if ($ct->val == $ct_id) {
                $hasSameCtid = true;
                break;
            }
        }
        // if matched
        if ($hasSameCtid) {
            // search if there is already NEW tender order for queue
            $filter = [["key" => "q_id", "val" =>$queue->id],
                    ["key" => "tender_id", "val" => $tender_id],["key"=>"status", "val"=>"NEW"]
                    ];
            $orderResult = $tenderCore->searchTenderOrder($filter,100, 0, 0);

            // if tenderOrder exist push the new cargo
            if (count($orderResult->data) == 1) {

                // push the new cargo, update numberOfTrucks by +1
                $tenderOrderBean = $tenderCore->getTenderOrderBasic( $orderResult->data[0]->id,0);

                $tenderOrderCargo = $tenderOrderBean->cargo;
                array_push($tenderOrderCargo, intval($cargo_id));
                $tenderOrderBean->cargo= $tenderOrderCargo;
                $tenderOrderBean->trucks= $tenderOrderBean->trucks+1;
                $tenderOrderBean->questionnaire= json_encode($tenderOrderBean->questionnaire);

                $tenderCore->updateTenderOrder($tenderOrderBean, $tenderOrderBean->id, 0);

            }
            // in case there is no new tenderOrder, create new one,
            else if(count($orderResult->data)==0){

                // fill basic info
                $tenderOrderBean = new stdClass();
                $tenderOrderBean->tender_id =$tender_id;
                $tenderOrderBean->q_id =$queue->id;
                $tenderOrderBean->order_date =DBConnection::getSystemDate();
                $tenderOrderBean->cargo =[intval($cargo_id)];
                $tenderOrderBean->trucks = 1;

                // fill questionare
                $questionnaireArray= [];
                $cargoBean= $cargoCore->getCargoBasic($cargo_id,0);

                // loop on tender manifest questionare, to get the answers
                foreach ($tenderManifest->questionnaire as $questionnaire) {
                    // get all answeres from tender questionare
                    if($questionnaire->order_answer){
                        $question =  new stdClass();
                        $question->id=(count($questionnaireArray) +1).'';
                        $question->val=$questionnaire->order_answer;
                        array_push($questionnaireArray, $question);
                    }
                }

                // create tenderOrder
                $tenderOrderBean->questionnaire=json_encode($questionnaireArray);
                $id = $tenderCore->createTenderOrder($tenderOrderBean, 0);

                // see if tender order is set to be automaticlay
                $tenderCore->autoAssignCargo($tenderOrderBean,$id,0);
            }
        }
    }

}catch(Exception $e){
    $socialCore = new SocialCore();
    $wall_message = $e->getMessage();
    $notification_message = "خطأ اثناء اضافة الحاوية إلى الطلبية";
    $socialCore->informSupervisor('خطأ', $wall_message, $notification_message, '2');
}