<?php
// ---------------------------------------------------------------------- //
// ---------------  try insert grains waybill into "" System ------------ //
// ---------------------------------------------------------------------- //
ini_set('display_errors', 'On');

// import 
require_once dirname(__FILE__) . "/../../../includes/DBConnection.php";
require_once dirname(__FILE__) . "/../../outgoing_integration/Grains.php";
require_once dirname(__FILE__) . "/../../waybill/waybill_core.php";


//init objetcs
$grains = new Grains();
$waybillCore = new WaybillCore();
$taskQueuesCore = new TaskQueuesCore();

// get params from request
if(isset($_POST['waybill_id'])){
    $waybill_id = $_POST['waybill_id'];
}else{
    $waybill_id = $_GET['waybill_id'];
}

if(isset($_POST['trial'])){
    $trial = $_POST['trial'];
}else{
    $trial = $_GET['trial'];
}

try{

    // insert grains waybill into 
    $waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);
    echo "waybillBean status = " . $waybillBean->status . "\n";

    $result = $grains->insertAqabaWaybill($waybillBean);

    echo "after insert into silos" . "\n";

    if($result->HH_Add_TruckResult == "" || $result->HH_Add_TruckResult == "Success"){
        // log activity
        $waybillCore->logActivity($waybill_id, "ترحيل ارسالية","تم ترحيل الإرسالية الى نظام وزارة الصناعة بنجاح","check",0);
    } else{
        throw new Exception("unable to insert waybill into grains system , " . $result->HH_Add_TruckResult);        
    }  

}catch (Exception $e){

    echo "Exception has occured : " . $e->getMessage();


    // retry after 5 minutes
    $trial ++;
    $taskQueuesCore->createInsertGrainsWaybillTask($waybill_id ,$trial , 300 , $e->getMessage());

    // if number of trials exceeded 20 times, send Hamzeh an error notification
    if($trial == 20){
        $r = rand(0,3);
        if($r == 1){
            $socialCore = new SocialCore();
            $wall_message = "لا يمكن ترحيل مستندات التموين الى نظام الصوامع ، خطأ في الإتصال";
            $notification_message = "خطأ في ترحيل ارسالية تموين";
            //$socialCore->informSupervisor('خطأ', $wall_message, $notification_message, '2');

            //$socialCore->informSupervisor('خطأ', $wall_message, $notification_message, '475');
        }
    }

}

