<?php
// ---------------------------------------------------------------------- //
// ---------------  try insert grains waybill into "" System ------------ //
// ---------------------------------------------------------------------- //
ini_set('display_errors', 'On');

// import 
require_once dirname(__FILE__) . "/../../../includes/DBConnection.php";
require_once dirname(__FILE__) . "/../../outgoing_integration/Grains.php";
require_once dirname(__FILE__) . "/../../waybill/waybill_core.php";
require_once dirname(__FILE__) . "/../../registration/registration_core.php";

//init objetcs
$grains = new Grains();
$waybillCore = new WaybillCore();
$taskQueuesCore = new TaskQueuesCore();
$socialCore = new SocialCore();
$registrationCore = new RegistrationCore();

// get params from request
if(isset($_POST['waybill_id'])){
    $waybill_id = $_POST['waybill_id'];
}else{
    $waybill_id = $_GET['waybill_id'];
}
if(isset($_POST['trial'])){
    $trial = $_POST['trial'];
}else{
    $trial = $_GET['trial'];
}

try{

    // insert grains waybill into 
    $waybillBean = $waybillCore->getWaybillBasic($waybill_id, 0);

    if($waybillBean == null){
        throw new Exception("INVALID_WAYBILL");
    }

    echo "check allowed status = " . $waybillBean->status . "\n";

    // if the waybill status is one of the following kill the task
    if(! in_array($waybillBean->status  , ["CLOSED","COMPLETE","ONROAD","ARRIVED"]) ){
        
        // get info form grains system
        $tn = $waybillBean->document->carrier[0]->truck->tn;
        // $nafithPermit = $registrationCore->getNafithAsezaPermit($tn);
        $result = $grains->getAqabaWaybillInfo($waybillBean->wn);

        echo "after get info from silo system = ";
        var_dump($result);


        // if waybill is invalid
        if(!$result){
            throw new Exception("INVALID_WAYBILL_RESULT");
        }

        // if the info is not correct
        if(!isset($result->WeightExit) || !isset($result->WeightEmp)){
            throw new Exception("INVALID_WEIGHT");
        }
        // if no weight us set yet
        if(!$result->WeightExit || !$result->WeightEmp){
            throw new Exception("NO_WEIGHT");
        }
        // if weight is 0
        if($result->WeightExit == 0 || $result->WeightEmp == 0){
            throw new Exception("NO_WEIGHT");
        }

        $loading_weight = $result->WeightExit - $result->WeightEmp;
        
        // save weight in waybill

        echo "<br/>";
        echo "loading_weight = " . $loading_weight;

        $cargoBean = $waybillBean->document->cargo[0];
        $loading_time_stamp = $result->ArrivalDate;
        if(!$loading_time_stamp || $loading_time_stamp == "" || $loading_time_stamp == " "){
            $loading_time_stamp = DBConnection::getSystemDate();
            $cargoBean->weights->loading->time_stamp_source = "MINAGATE";
        }
        $cargoBean->weights->loading->net_weight = $loading_weight;
        $cargoBean->weights->loading->time_stamp = $loading_time_stamp;
        $cargoBean->weights->loading->gross_weight->weight = $result->WeightExit;
        $cargoBean->weights->loading->gross_weight->time_stamp = $loading_time_stamp;
        $cargoBean->weights->loading->tare_weight->weight = $result->WeightEmp;
        $cargoBean->weights->loading->tare_weight->time_stamp = $loading_time_stamp;
        $waybillBean->document->cargo[0] = $cargoBean;
        $waybillCore->updateWeight($waybillBean , 0);


        // write integration node
        if(!$waybillBean->document->integeration_details->grains){
            $waybillBean->document->integeration_details->grains = new stdClass();
        }
        $waybillBean->document->integeration_details->grains = $result;
        $waybillCore->updateWaybill($waybillBean, $waybillBean->id, 0);

        echo "<br/>";
        echo " write integration node " ;


        // add log message
        // if the loading weight in waybill is different than integration weight
        $original_loading_weight = $cargoBean->weights->loading->net_weight;
        if($original_loading_weight && $original_loading_weight != $loading_weight){
            $waybillCore->logActivity($waybillBean->id,
            "تغير وزن التحميل - ربط إلكتروني",
            "وزن التحميل القديم: ". $original_loading_weight ."  - الوزن الجديد : " . $loading_weight . " كغم",
            "LOAD_CARGO",0);
        }else{
            // write down note
            $waybillCore->logActivity($waybillBean->id,
            " تثبيت وزن التحميل - ربط الكتروني ",
            "وزن التحميل : ". $loading_weight ." كغم ",
            "LOAD_CARGO",0);
        }

        // change status of waybill to ONROAD in case it it active , pending
        if($waybillBean->status == "ACTIVE" || $waybillBean->status == "PENDING"){
            $waybillCore->changeStatus($waybillBean->id,'ONROAD', 0) ;
        }

        echo "<br/>";
        echo " change status of waybill to ONROAD" ;

        // close waybill after 12 hours of loading
        $taskQueuesCore->createCloseWaybillTask($waybillBean->id,12, "السبب : اغلاق المستند بسبب مرور أكثر من 12 ساعة على التحميل");

        echo "<br/>";
        echo " close waybill after 12 hours of loading " ;

    }
    else{
        echo "waybill_status is out of target status" . "\n";
    }

}catch (Exception $e){

    echo "Exception has occured : " . $e->getMessage();

    switch ($e->getMessage()) {
        case 'INVALID_WAYBILL':
            // $wall_message = "خطا في ترحيل المستند " . $waybill_id . " - waybill_id is not correct";
            // $notification_message = $wall_message;
            // $socialCore->informSupervisor('خطأ', $wall_message, $notification_message, '2');

            break;
        case 'INVALID_WAYBILL_RESULT':
            // retry after 1 hour
            $trial ++;
            $taskQueuesCore->createGetGrainsWaybillInfoTask($waybill_id ,$trial , 3600 , $e->getMessage());
            break;

        case 'NO_WEIGHT':
            // retry after 1 hour
            $trial ++;
            $taskQueuesCore->createGetGrainsWaybillInfoTask($waybill_id ,$trial , 3600 , $e->getMessage());
            break;
        default:
            // retry after 5 minutes in case any other error like timeout
            $trial ++;
            $taskQueuesCore->createGetGrainsWaybillInfoTask($waybill_id ,$trial , 600 , $e->getMessage());

            if($trial % 20 == 0){

                $r = rand(0,3);
                if($r == 1){
                    $wall_message = "لا يمكن ترحيل الاوزان من نظام الصوامع ، خطأ في الإتصال";
                    $notification_message = $wall_message;
                    //$socialCore->informSupervisor('خطأ', $wall_message, $notification_message, '2');

                    $wall_message = "لا يمكن ترحيل الاوزان من نظام الصوامع ، خطأ في الإتصال";
                    $notification_message = $wall_message;
                    //$socialCore->informSupervisor('خطأ', $wall_message, $notification_message, '475');
                }

            }
            break;
    }
}


function decimal_to_time($decimal) {
    $hours = floor($decimal / 60);
    $minutes = floor($decimal % 60);
    $seconds = $decimal - (int)$decimal;
    $seconds = round($seconds * 60);
 
    return str_pad($hours, 2, "0", STR_PAD_LEFT) . ":" . str_pad($minutes, 2, "0", STR_PAD_LEFT) . ":" . str_pad($seconds, 2, "0", STR_PAD_LEFT);
}

